/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.reflection;

import com.kingdee.eas.hr.ats.reflection.Reflector;
import com.kingdee.eas.hr.ats.reflection.ReflectorFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultReflectorFactory
implements ReflectorFactory {
    private boolean classCacheEnabled = true;
    private final ConcurrentMap<Class<?>, Reflector> reflectorMap = new ConcurrentHashMap();

    public static DefaultReflectorFactory getInstance() {
        return singletonHolder.INSTANCE;
    }

    @Override
    public boolean isClassCacheEnabled() {
        return this.classCacheEnabled;
    }

    @Override
    public void setClassCacheEnabled(boolean classCacheEnabled) {
        this.classCacheEnabled = classCacheEnabled;
    }

    @Override
    public Reflector findForClass(Class<?> type) {
        if (this.classCacheEnabled) {
            Reflector cached = (Reflector)this.reflectorMap.get(type);
            if (cached == null) {
                cached = new Reflector(type);
                this.reflectorMap.put(type, cached);
            }
            return cached;
        }
        return new Reflector(type);
    }

    public static class singletonHolder {
        public static final DefaultReflectorFactory INSTANCE = new DefaultReflectorFactory();
    }
}

