/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AtsResultToSumHRPersonHelper {
    private static Logger logger = Logger.getLogger(AtsResultToSumHRPersonHelper.class);

    public static String createResultToSumTempTableByHRPerson(Context ctx, Map<String, String> filterItems, HttpSession session) throws Exception {
        String sql = AtsResultToSumHRPersonHelper.getAttendResultSumSqlByHRPerson(ctx, filterItems);
        String tempTableName = AtsResultToSumHelper.getAttenceResultTempTable(ctx, filterItems, sql);
        filterItems.put("tempTableName", tempTableName);
        filterItems.put("resultToSumSQL", sql);
        AtsResultToSumHelper.setTmpTableToSession(filterItems, session);
        logger.error((Object)("RESULT TO SUM GROUP SQL:getGridResultToSumDataSql resultToSum dynamicSql: " + sql.toString()));
        return tempTableName;
    }

    public static String getAttendResultSumSqlByHRPerson(Context ctx, Map<String, String> filterItems) throws Exception {
        String personJson;
        String beginDate = filterItems.get("beginDate");
        String endDate = filterItems.get("endDate");
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID,person.FNumber as personNumber , person.FName" + MLUtile.getMlFlag(ctx) + " as personName ");
        sumSql.append(" FROM T_HR_ATS_AttendanceFileHIS FHIS ");
        sumSql.append(" inner join ( SELECT FHrOrgUnitID,fproposerid,MAX(fleffdt) fleffdt,MAX(FEFFDT) FEFFDT FROM t_hr_ats_attendancefilehis ");
        sumSql.append(" WHERE fleffdt >= {ts '" + beginDate + "'} AND FEFFDT <= {ts '" + endDate + "'}  ");
        sumSql.append(" group by FHrOrgUnitID,fproposerid ");
        sumSql.append(" )hisMax on FHIS.FHrOrgUnitID= hisMax.FHrOrgUnitID AND  FHIS.fproposerid= hisMax.fproposerid and FHIS.FEFFDT = hisMax.FEFFDT and FHIS.fleffdt = hisMax.fleffdt ");
        sumSql.append(" INNER JOIN T_BD_Person person on FHIS.FProposerID = person.FID ");
        sumSql.append(" WHERE FHIS.FLEFFDT >= {ts '" + beginDate + "'}");
        sumSql.append(" AND FHIS.FEFFDT <= {ts '" + endDate + "'} ");
        String attendGroupSql = AtsServerCalUtils.getAttenceGroupSql(filterItems);
        if (!StringUtils.isEmpty((String)attendGroupSql)) {
            sumSql.append(attendGroupSql);
        }
        if (!(StringUtils.isEmpty((String)(personJson = filterItems.get("personJson"))) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson))) {
            Set<String> personKeys = AtsResultToSumHelper.getSelectPersonKey(personJson);
            sumSql.append(" and concat(FHIS.fhrOrgUnitId,concat(FHIS.fproposerid,FHIS.fadminorgunitid)) in (" + AtsUtil.convertSetToString(personKeys) + ")");
        } else {
            sumSql.append(AtsResultToSumHRPersonHelper.getAttendResultSumWhereSqlHRPerson(ctx, filterItems));
            String customFilter = filterItems.get("customFilter");
            if (!StringUtils.isEmpty((String)customFilter)) {
                sumSql.append(customFilter);
            }
        }
        sumSql.append(" GROUP BY FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID,person.FNumber,person.FName" + MLUtile.getMlFlag(ctx));
        return sumSql.toString();
    }

    public static String getAttendResultSumWhereSqlHRPerson(Context ctx, Map<String, String> filterItems) {
        String attenceStatus;
        StringBuffer WhereSql = new StringBuffer();
        String filterItem = filterItems.get("filterItems");
        if (!StringUtils.isEmpty((String)filterItem)) {
            if (filterItem.indexOf("name") != -1) {
                filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
            }
            if (filterItem.indexOf("number") != -1) {
                filterItem = filterItem.replaceAll("number", "fnumber");
            }
            WhereSql.append(" and " + filterItem);
        }
        if (!StringUtils.isEmpty((String)(attenceStatus = filterItems.get("attenceStatus")))) {
            if (attenceStatus.equals("0")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("1")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     AND FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.fattencestatus in ( 1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("2")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     AND FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.fattencestatus in (1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("10")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceReSumMd atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = FHIS.fhrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = FHIS.fproposerid");
                WhereSql.append("     and atsum.fadminorgunitid = FHIS.fadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("15")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResultSum atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = FHIS.fhrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = FHIS.fproposerid");
                WhereSql.append("     and atsum.fadminorgunitid = FHIS.fadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            }
        }
        String orgTempTableName = filterItems.get("adminOrgTempTableName");
        String existsSql = AtsResultToSumHelper.getOrgWhereSql(filterItems, orgTempTableName);
        WhereSql.append(existsSql);
        return WhereSql.toString();
    }

    public static void setGridAttendResultSumInfoByHRPerson(Context ctx, String keyTmpTableName, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            Map filterItems = (Map)params.get("sumParams");
            String beginDate = (String)filterItems.get("beginDate");
            String endDate = (String)filterItems.get("endDate");
            String attendPeriodId = (String)filterItems.get("attendPeriodId");
            String attendPeriodName = (String)filterItems.get("attendPeriodName");
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsResultToSumHRPersonHelper.getAttendDetailDataGridByHRPerson(ctx, keyTmpTableName, beginDate, endDate, filterItems);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                while (rowSet.next()) {
                    String positionId = rowSet.getString("fpositionID");
                    String currentKey = rowSet.getString("fatthrorgunitid") + rowSet.getString("fproposerid");
                    String resultId = rowSet.getString("FID");
                    try {
                        if (!sumKey.contains(currentKey)) continue;
                        rowListMap.put("fpositionID", positionId);
                        rowListMap.put("resultId", resultId);
                        AtsResultToSumHelper.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: RESULTTOSUM call setGridAttendResultSumInfoByPerson error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getAttendDetailDataGridByHRPerson(Context ctx, String keyTmpTableName, String beginDate, String endDate, Map<String, String> filterItems) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_AttendanceResult RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP WHERE ATS_TMP.fproposerid = RESULT.fproposerid ");
        sb.append("  AND ATS_TMP.FHRORGUNITID = RESULT.FATTHRORGUNITID ) ");
        sb.append("  AND RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  AND RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: RESULTTOSUM call getAttendDetailDataGridByHRPerson error: " + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }

    public static IRowSet setDetailDateInfoByHRPerson(Context ctx, String hrOrgUnitId, String personId, String beginDate, String endDate, String fields) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select " + fields + " from T_HR_ATS_AttendanceResult resultDetail ");
        sb.append(" where resultDetail.fproposerid='" + personId + "' and ");
        if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
            sb.append(" resultDetail.fatthrOrgUnitId='" + hrOrgUnitId + "' and ");
        }
        sb.append(" resultDetail.FATTENCEDATE  >= {ts '" + beginDate + "'}");
        sb.append(" and resultDetail.FATTENCEDATE <= {ts '" + endDate + "'}");
        sb.append(" order by FATTENCEDATE ");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public static IRowSet getDetailDataGridHRPerson(Context ctx, String keyPerAndOrgTmpTable, String beginDate, String endDate, String summarySql, String detailSql) {
        IRowSet rowSet = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select ATS_TMP.fhrorgunitid fhrorgunitid,RESULT.fproposerid,ATS_TMP.fadminorgunitid fadminorgunitid," + detailSql + " ");
            if (!StringUtils.isEmpty((String)summarySql)) {
                sb.append("," + summarySql + "");
            }
            sb.append("  FROM T_HR_ATS_AttendanceResult RESULT ");
            sb.append("  INNER JOIN " + keyPerAndOrgTmpTable + " ATS_TMP ON ATS_TMP.fproposerid = RESULT.fproposerid AND ATS_TMP.fhrorgunitid = RESULT.fATThrorgunitid ");
            sb.append("  WHERE FATTENCEDATE >= {ts'" + beginDate + "'}");
            sb.append("  AND FATTENCEDATE <={ts'" + endDate + "'}");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public static Map<String, Object> getExistedSumRecordInfo(Context ctx, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, String keyTmpTableName) {
        Map filterItems = (Map)params.get("sumParams");
        ArrayList temExistList = new ArrayList();
        HashMap<String, Object> existAttendRecord = new HashMap<String, Object>();
        try {
            String sql = AtsResultToSumHRPersonHelper.getDynaAttendSumExistsSql((String)filterItems.get("beginDate"), (String)filterItems.get("endDate"), keyTmpTableName, filterItems, ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                String hrOrgUnitId = rowSet.getString("fhrorgunitid");
                String personId = rowSet.getString("FPROPOSERID");
                String adminOrgUnitId = rowSet.getString("FAdminORGUNITID");
                String positionId = rowSet.getString("fpositionID");
                String periodId = rowSet.getString("FSalaryPeriod");
                String salaryStatus = rowSet.getString("FSalaryStatus");
                String fid = rowSet.getString("fid");
                if (periodId != null) {
                    map.put("salaryPeriodId", periodId);
                }
                String key = hrOrgUnitId + personId + adminOrgUnitId;
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("personId", personId);
                map.put("adminOrgUnitId", adminOrgUnitId);
                map.put("fid", fid);
                map.put("fpositionID", positionId);
                map.put("salaryStatus", salaryStatus);
                map.put("key", key);
                existAttendRecord.put(key, salaryStatus);
                temExistList.add(map);
            }
            int size = rowList.size();
            int tempSize = temExistList.size();
            if (tempSize > 0) {
                block3: for (int i = 0; tempSize > i; ++i) {
                    LinkedHashMap tempexsitMap = (LinkedHashMap)temExistList.get(i);
                    String tempkey = (String)tempexsitMap.get("key");
                    for (int j = 0; size > j; ++j) {
                        Map exsitMap = rowList.get(j);
                        String key = (String)exsitMap.get("key");
                        if (!key.equals(tempkey)) continue;
                        tempexsitMap.put("orgName", exsitMap.get("orgName"));
                        tempexsitMap.put("hrOrgName", exsitMap.get("hrOrgName"));
                        tempexsitMap.put("personNumber", exsitMap.get("personNumber"));
                        tempexsitMap.put("personName", exsitMap.get("personName"));
                        rowList.set(j, tempexsitMap);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return existAttendRecord;
    }

    public static String getDynaAttendSumExistsSql(String beginDate, String endDate, String keyTmpTableName, Map<String, String> filterItems, Context ctx) {
        String isMulattendPeriod = filterItems.get("isMulattendPeriod.");
        String attendPeriodNameSet = filterItems.get("attendPeriodNameSet");
        StringBuffer sb = new StringBuffer();
        sb.append(" select resultSum.FPROPOSERID,resultSum.FADMINORGUNITID");
        sb.append(" ,resultSum.FSalaryStatus,resultSum.fpositionID");
        sb.append(",resultSum.fhrorgunitid,resultSum.FSalaryPeriod,resultSum.fid ");
        sb.append(" from T_HR_ATS_AttendanceResultSum resultSum ");
        sb.append(" INNER JOIN " + keyTmpTableName + " ATS_TMP ON ATS_TMP.fhrorgunitid = resultSum.fhrorgunitid AND ATS_TMP.fproposerid = resultSum.fproposerid ");
        sb.append(" inner JOIN T_HR_ATS_AttendancePeriod as period ON period.fid = resultSum.fattendanceperiodid  ");
        if (StringUtils.isEmpty((String)isMulattendPeriod) || StringUtils.isEmpty((String)attendPeriodNameSet)) {
            sb.append(" where period.FStartDate = {ts '" + beginDate + "'}");
            sb.append(" and period.FEndDate = {ts '" + endDate + "'}");
        } else if ("true".equalsIgnoreCase(isMulattendPeriod)) {
            sb.append(" where period.fname").append(MLUtile.getMlFlag(ctx)).append(" in ( ").append(attendPeriodNameSet).append(" )");
        } else {
            sb.append(" where period.fname").append(MLUtile.getMlFlag(ctx)).append(" = ").append(attendPeriodNameSet);
        }
        return sb.toString();
    }
}

