/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.datasynch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import java.math.BigDecimal;

public class UpdateCloudHubTimesThread
implements Runnable {
    private Context ctx;
    private long startTime;
    private long costSumTime;
    private AttendanceLogInfo logInfo;

    public UpdateCloudHubTimesThread(Context ctx, long costSumTime, long startTime, AttendanceLogInfo logInfo) {
        this.ctx = ctx;
        this.startTime = startTime;
        this.costSumTime = costSumTime;
        this.logInfo = logInfo;
    }

    @Override
    public void run() {
        long costTime = System.currentTimeMillis() - this.startTime;
        if (costTime > this.costSumTime) {
            costTime = this.costSumTime;
        }
        this.logInfo.setCostSumTime(BigDecimal.valueOf(this.costSumTime));
        this.logInfo.setCostTime(BigDecimal.valueOf(costTime));
        this.logInfo.setRemainTime(BigDecimal.valueOf(this.costSumTime - costTime));
        try {
            AttendanceLogFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.logInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

