/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.fetch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.PunchCardRecordCollection;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.syn.SynchronizationContext;
import com.kingdee.eas.hr.ats.syn.fetch.AbstractGetOuterData;
import com.kingdee.eas.hr.ats.webServiceClient.IEquWebServicebindingStub;
import com.kingdee.eas.hr.ats.webServiceClient.IEquWebServiceserviceLocator;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.StringHolder;
import junit.framework.AssertionFailedError;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class PunchCardByWebSrvcGetOuterData
extends AbstractGetOuterData {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.syn.fetch.PunchCardByWebSrvcGetOuterData");
    private final int extendDuration = 1440;

    @Override
    protected Map<String, Object> getOuterRowData(IRowSet rs) throws SQLException {
        return null;
    }

    @Override
    public Object getOuterData(SynchronizationContext synContext) throws EASBizException, BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOuterData(SynchronizationContext synContext, Map<String, Object> paramMap) throws EASBizException, BOSException {
        IEquWebServicebindingStub binding = null;
        Statement pstmt = null;
        Connection conn = null;
        String url = synContext.getWebserviceUrl();
        try {
            IEquWebServiceserviceLocator sl = new IEquWebServiceserviceLocator();
            if (StringUtils.isEmpty((String)url)) {
                logger.error((Object)"url of webservice is error,besure for example: host:port (127.1.1.0:8081");
                Object var8_12 = null;
                return var8_12;
            }
            sl.setIEquWebServicePortEndpointAddress("http://" + url + "/EquWebService.EquWebService/soap/IEquWebService");
            binding = (IEquWebServicebindingStub)sl.getIEquWebServicePort();
            binding.setTimeout(300000);
            ByteArrayHolder dataByte = new ByteArrayHolder(new byte[0]);
            StringHolder errorMsg = new StringHolder(new String());
            SimpleDateFormat form = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                binding.getEquAtdData_New((String)paramMap.get("EquNO"), (String)paramMap.get("EquNoLastTransmitTime"), form.format(new java.util.Date()), dataByte, errorMsg);
            }
            catch (Exception e) {
                logger.error((Object)("invoke webservice method err,for equipment number: " + (String)paramMap.get("EquNO") + "start Time is :" + (String)paramMap.get("EquNoLastTransmitTime") + "end time is :" + form.format(new java.util.Date())));
                e.printStackTrace();
                Object var12_18 = null;
                SQLUtils.cleanup(pstmt, conn);
                return var12_18;
            }
            byte[] arrByte = dataByte.value;
            if (arrByte != null && arrByte.length > 0) {
                CoreBaseCollection coreBaseCollection = this.getPunchCardRecord((Integer)paramMap.get("number"), synContext.getBosCtx(), arrByte, (String)paramMap.get("EquAddress"), (String)paramMap.get("EquNoLastTransmitTime"), (String)paramMap.get("EquNO"));
                return coreBaseCollection;
            }
            logger.error((Object)("when transmit equipment ,number:" + (String)paramMap.get("EquNO") + "returning Data is null,time\uff1a" + (String)paramMap.get("EquNoLastTransmitTime") + "--" + new java.util.Date().toString()));
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(pstmt, conn);
        }
        return null;
    }

    private CoreBaseCollection getPunchCardRecord(int number, Context ctx, byte[] arrByte, String equAddress, String transmitStartTime, String equipmentNum) throws EASBizException, BOSException, JDOMException, IOException {
        PunchCardRecordCollection existColl = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("punchCardDate"));
        evi.getSelector().add(new SelectorItemInfo("punchCardTime"));
        evi.getSelector().add(new SelectorItemInfo("punchCardSource"));
        evi.getSelector().add(new SelectorItemInfo("equipmentNum"));
        evi.getSelector().add(new SelectorItemInfo("attendanceNum"));
        fi.getFilterItems().add(new FilterItemInfo("punchCardSource", (Object)"0", CompareType.EQUALS));
        int equipmentNumLength = equipmentNum.length();
        if (equipmentNumLength == 3) {
            equipmentNum = "0" + equipmentNum;
        }
        if (equipmentNumLength == 2) {
            equipmentNum = "00" + equipmentNum;
        }
        if (equipmentNumLength == 1) {
            equipmentNum = "000" + equipmentNum;
        }
        fi.getFilterItems().add(new FilterItemInfo("equipmentNum", (Object)equipmentNum));
        fi.getFilterItems().add(new FilterItemInfo("punchCardTime", (Object)new Timestamp(java.util.Date.parse(transmitStartTime.replace("-", "/")) - (long)((this.extendDuration + 10) * 60 * 1000)), CompareType.GREATER_EQUALS));
        existColl = PunchCardRecordFactory.getLocalInstance(ctx).getPunchCardRecordCollection(evi);
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(arrByte);
        Document doc = builder.build((InputStream)is);
        CoreBaseCollection crdColl = new CoreBaseCollection();
        HashSet<String> setCardId = new HashSet<String>();
        PunchCardRecordInfo crdInfo = null;
        Element root = doc.getRootElement();
        List rowList = root.getChildren();
        for (Element row : rowList) {
            crdInfo = new PunchCardRecordInfo();
            String cardId = row.getChildText("CardId");
            crdInfo.setAttendanceNum(this.getCardId(cardId, number));
            crdInfo.setEquipmentNum(row.getChildText("EquNo"));
            crdInfo.setPunchCardDate(Date.valueOf(row.getChildText("RecDate")));
            crdInfo.setPunchCardTime(Timestamp.valueOf(row.getChildText("RecDate") + " " + row.getChildText("RecTime")));
            crdInfo.setPunchCardPlace(StringUtils.isEmpty((String)equAddress) ? row.getChildText("EquNo") : equAddress);
            crdInfo.setPunchCardSource(PunchCardSourceEnum.attenceMachine);
            if (existColl != null && existColl.contains(crdInfo)) continue;
            crdColl.add((CoreBaseInfo)crdInfo);
            setCardId.add(crdInfo.getAttendanceNum());
        }
        if (crdColl != null && crdColl.size() > 0) {
            Map map = AttendanceFileFactory.getLocalInstance(ctx).getPersonByAttendanceNum(setCardId);
            for (int i = 0; i < crdColl.size(); ++i) {
                PunchCardRecordInfo info = (PunchCardRecordInfo)crdColl.get(i);
                AttendanceFileInfo fileInfo = (AttendanceFileInfo)map.get(info.getAttendanceNum());
                if (fileInfo == null) continue;
                PersonInfo pf = new PersonInfo();
                pf.setId(BOSUuid.read((String)fileInfo.getProposer().getId().toString()));
                ((PunchCardRecordInfo)crdColl.get(i)).setProposer(pf);
                AdminOrgUnitInfo aoi = new AdminOrgUnitInfo();
                if (fileInfo.getAdminOrgUnit() == null) continue;
                aoi.setId(BOSUuid.read((String)fileInfo.getAdminOrgUnit().getId().toString()));
                ((PunchCardRecordInfo)crdColl.get(i)).setAdminOrgUnit(aoi);
            }
        }
        return crdColl;
    }

    private String getCardId(String cardId, int number) {
        if (StringUtils.isEmpty((String)cardId)) {
            return null;
        }
        if (number > cardId.length()) {
            String str = "";
            for (int i = cardId.length(); i < number; ++i) {
                str = str + "0";
            }
            return str + cardId;
        }
        if (number < cardId.length()) {
            return cardId.substring(cardId.length() - number, cardId.length());
        }
        return cardId;
    }
}

