/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsFileBaseCollection;
import com.kingdee.eas.hr.ats.AtsFileBaseInfo;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.BillSourceTypeEnum;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.IAtsFileBase;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsBillAssist {
    private static Map<Class, String> beginTimeField = new HashMap<Class, String>();
    private static Map<Class, String> endTimeField = new HashMap<Class, String>();
    private static Map<Class, String> realBeginTimeField = new HashMap<Class, String>();
    private static Map<Class, String> realEndTimeField = new HashMap<Class, String>();
    private static Logger logger = Logger.getLogger(AtsBillAssist.class);

    public static String getBeginTimeFieldName(Class cls) {
        return beginTimeField.getOrDefault(cls, "");
    }

    public static String getEndTimeFieldName(Class cls) {
        return endTimeField.getOrDefault(cls, "");
    }

    public static String getRealBeginTimeFieldName(Class cls) {
        return realBeginTimeField.getOrDefault(cls, "");
    }

    public static String getRealEndTimeFieldName(Class cls) {
        return realEndTimeField.getOrDefault(cls, "");
    }

    public static void regist(Class cls, String beginTimeName, String endTimeName, String realBeginTimeName, String realEndTimeName) {
        beginTimeField.put(cls, beginTimeName == null ? realBeginTimeName : beginTimeName);
        endTimeField.put(cls, endTimeName == null ? realEndTimeName : endTimeName);
        realBeginTimeField.put(cls, realBeginTimeName == null ? beginTimeName : realBeginTimeName);
        realEndTimeField.put(cls, realEndTimeName == null ? endTimeName : realEndTimeName);
    }

    public static Timestamp getBeginTime(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry((CoreBaseInfo)coreBaseInfo);
        }
        return coreBaseInfo == null ? null : coreBaseInfo.getTimestamp(beginTimeField.getOrDefault(coreBaseInfo.getClass(), "beginTime"));
    }

    public static Timestamp getEndTime(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry((CoreBaseInfo)coreBaseInfo);
        }
        return coreBaseInfo == null ? null : coreBaseInfo.getTimestamp(endTimeField.getOrDefault(coreBaseInfo.getClass(), "endTime"));
    }

    public static Timestamp getRealBeginTime(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry((CoreBaseInfo)coreBaseInfo);
        }
        if (coreBaseInfo == null) {
            return null;
        }
        Timestamp beginTime = coreBaseInfo.getTimestamp(realBeginTimeField.getOrDefault(coreBaseInfo.getClass(), "realBeginTime"));
        return beginTime == null ? AtsBillAssist.getBeginTime((CoreBaseInfo)coreBaseInfo) : beginTime;
    }

    public static Timestamp getRealEndTime(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry((CoreBaseInfo)coreBaseInfo);
        }
        if (coreBaseInfo == null) {
            return null;
        }
        Timestamp endTime = coreBaseInfo.getTimestamp(realEndTimeField.getOrDefault(coreBaseInfo.getClass(), "realEndTime"));
        return endTime == null ? AtsBillAssist.getEndTime((CoreBaseInfo)coreBaseInfo) : endTime;
    }

    public static PersonInfo getPerson(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry(coreBaseInfo);
        }
        return coreBaseInfo == null ? null : (PersonInfo)coreBaseInfo.get("person");
    }

    public static String getPersonId(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsBillAssist.getFirstBillEntry(coreBaseInfo);
        }
        return CoreBaseUtile.getId(AtsBillAssist.getPerson(coreBaseInfo));
    }

    public static AdminOrgUnitInfo getAdminUnitNoNull(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        AdminOrgUnitInfo adminUnitInfo = AtsBillAssist.getAdminUnit(coreBaseInfo);
        if (adminUnitInfo == null) {
            AtsFileBaseInfo fileBaseInfo = AtsBillAssist.getFileHisInfoByBill(ctx, coreBaseInfo);
            adminUnitInfo = fileBaseInfo == null ? fileBaseInfo.getAdminOrgUnit() : null;
        }
        return adminUnitInfo;
    }

    public static String getAdminUnitIdNoNull(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        return CoreBaseUtile.getId(AtsBillAssist.getAdminUnitNoNull(ctx, coreBaseInfo));
    }

    public static AdminOrgUnitInfo getAdminUnit(CoreBaseInfo coreBaseInfo) {
        Object adminObj = coreBaseInfo == null ? null : coreBaseInfo.get("adminOrgUnit");
        return adminObj instanceof AdminOrgUnitInfo ? (AdminOrgUnitInfo)adminObj : null;
    }

    public static String getAdminUnitId(CoreBaseInfo coreBaseInfo) {
        return CoreBaseUtile.getId(AtsBillAssist.getAdminUnit(coreBaseInfo));
    }

    public static HROrgUnitInfo getHrOrgUnitNoNull(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        HROrgUnitInfo hrOrgUnitInfo = AtsBillAssist.getHrOrgUnit(coreBaseInfo);
        if (hrOrgUnitInfo == null) {
            AtsFileBaseInfo fileBaseInfo = AtsBillAssist.getFileHisInfoByBill(ctx, coreBaseInfo);
            hrOrgUnitInfo = fileBaseInfo == null ? null : fileBaseInfo.getHrOrgUnit();
        }
        return hrOrgUnitInfo;
    }

    public static String getHrOrgUnitIdNoNull(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        return CoreBaseUtile.getId(AtsBillAssist.getHrOrgUnitNoNull(ctx, coreBaseInfo));
    }

    public static AtsFileBaseInfo getFileHisInfoByBill(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        AtsAffairEntryBaseInfo entry = AtsBillAssist.getFirstBillEntry(coreBaseInfo);
        String person = AtsBillAssist.getPersonId(coreBaseInfo);
        if (StringUtils.isBlank((CharSequence)person)) {
            person = CoreBaseUtile.getId(SHRBillUtil.getCurrPersonInfoNew(ctx));
        }
        Date attenDate = Date.getNoNullDate(AtsBillAssist.getRealBeginTime((CoreBaseInfo)entry));
        IAtsFileBase fileBase = entry instanceof AtsLeaveBillEntryInfo || entry instanceof CancelLeaveBillEntryInfo ? AtsHolidayFileHisFactory.getLocalInstance(ctx) : AttendanceFileHISFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("proposer", (Object)person, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("effdt", (Object)attenDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("leffdt", (Object)attenDate, CompareType.GREATER_EQUALS));
        AtsFileBaseCollection collection = fileBase.getAtsFileBaseCollection(String.format("select *,position.name,adminOrgUnit.name,hrOrgUnit.name where %s", filterInfo.toString()));
        return AtsCollectionUtile.isEmpty((IObjectCollection)collection) ? null : collection.get(0);
    }

    public static HROrgUnitInfo getHrOrgUnit(CoreBaseInfo coreBaseInfo) {
        Object hrObj = coreBaseInfo == null ? null : coreBaseInfo.get("hrOrgUnit");
        return hrObj instanceof HROrgUnitInfo ? (HROrgUnitInfo)hrObj : null;
    }

    public static String getHrOrgUnitId(CoreBaseInfo coreBaseInfo) {
        return CoreBaseUtile.getId(AtsBillAssist.getHrOrgUnit(coreBaseInfo));
    }

    public static AtsAffairEntryBaseInfo getFirstBillEntry(CoreBaseInfo model) {
        IObjectCollection entryColl;
        if (model instanceof AtsAffairEntryBaseInfo) {
            return (AtsAffairEntryBaseInfo)model;
        }
        Object entries = model == null ? null : model.get("entries");
        IObjectCollection iObjectCollection = entryColl = entries instanceof IObjectCollection ? (IObjectCollection)entries : null;
        if (AtsCollectionUtile.isEmpty(entryColl) || !(entryColl.getObject(0) instanceof AtsAffairEntryBaseInfo)) {
            return null;
        }
        return (AtsAffairEntryBaseInfo)entryColl.getObject(0);
    }

    public static IObjectCollection getBillEntries(CoreBaseInfo model) {
        Object entries = model == null ? null : model.get("entries");
        return entries instanceof IObjectCollection ? (IObjectCollection)entries : AtsCollectionUtile.sigleTon((IObjectValue)model);
    }

    public static CoreBaseInfo setDefaultBillTime(Context ctx, CoreBaseInfo model) {
        IObjectCollection entries;
        IObjectCollection iObjectCollection = entries = model instanceof AtsAffairBaseInfo ? (IObjectCollection)model.get("entries") : null;
        if (model instanceof AtsAffairEntryBaseInfo) {
            entries = AtsCollectionUtile.sigleTon((IObjectValue)model);
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (model instanceof AtsAffairBaseInfo) {
            ((AtsAffairBaseInfo)model).setLastUpdateTime(now);
            ((AtsAffairBaseInfo)model).setLastUpdateUser(currentUserInfo);
        }
        if (AtsCollectionUtile.isEmpty(entries)) {
            return model;
        }
        for (int i = 0; i < entries.size(); ++i) {
            if (!(entries.getObject(i) instanceof AtsAffairEntryBaseInfo)) continue;
            AtsAffairEntryBaseInfo entryBaseInfo = (AtsAffairEntryBaseInfo)entries.getObject(i);
            Timestamp startTime = AtsBillAssist.getRealBeginTime((CoreBaseInfo)entryBaseInfo);
            Timestamp endTime = AtsBillAssist.getRealEndTime((CoreBaseInfo)entryBaseInfo);
            String beginTimeFieldName = beginTimeField.get(entryBaseInfo.getClass());
            String realBeginTimeFieldName = realBeginTimeField.get(entryBaseInfo.getClass());
            String endTimeFieldName = endTimeField.get(entryBaseInfo.getClass());
            String realEndTimeFieldName = realEndTimeField.get(entryBaseInfo.getClass());
            if (startTime != null) {
                if (beginTimeFieldName != null && entryBaseInfo.get(beginTimeFieldName) == null) {
                    entryBaseInfo.put(beginTimeFieldName, startTime);
                }
                if (realBeginTimeFieldName != null && entryBaseInfo.get(realBeginTimeFieldName) == null) {
                    entryBaseInfo.put(realBeginTimeFieldName, startTime);
                }
            }
            if (endTime != null) {
                if (endTimeFieldName != null && entryBaseInfo.get(endTimeFieldName) == null) {
                    entryBaseInfo.put(endTimeFieldName, endTime);
                }
                if (realEndTimeFieldName != null && entryBaseInfo.get(realEndTimeFieldName) == null) {
                    entryBaseInfo.put(realEndTimeFieldName, endTime);
                }
            }
            if (entryBaseInfo.get("lastUpdateTime") == null) {
                entryBaseInfo.put("lastUpdateTime", now);
            }
            if (entryBaseInfo.get("lastUpdateUser") == null) {
                entryBaseInfo.put("lastUpdateUser", currentUserInfo);
            }
            AtsBillAssist.setDefaultBillOtherTime(ctx, entryBaseInfo);
        }
        return model;
    }

    public static AtsAffairEntryBaseInfo setDefaultBillOtherTime(Context ctx, AtsAffairEntryBaseInfo entryBaseInfo) {
        if (entryBaseInfo instanceof AtsTripBillEntryInfo) {
            AtsTripBillEntryInfo entryInfo = (AtsTripBillEntryInfo)entryBaseInfo;
            if (entryInfo.getStartTimeDateType() == null) {
                entryInfo.setStartTimeDateType(SegmentUnitEnum.currentDay);
            }
            if (entryInfo.getEndTimeDateType() == null) {
                entryInfo.setEndTimeDateType(SegmentUnitEnum.currentDay);
            }
            Timestamp startTime = entryInfo.getTripStartTime();
            Timestamp endTime = entryInfo.getTripEndTime();
            if (startTime != null) {
                if (entryInfo.getStartTimeHMS() == null) {
                    entryInfo.setStartTimeHMS(startTime);
                }
                if (entryInfo.getStartTimeDate() == null) {
                    Timestamp tripStartDate = AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(startTime));
                    entryInfo.setStartTimeDate(tripStartDate);
                }
            }
            if (endTime != null) {
                Timestamp tripEndDate = AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(endTime));
                entryInfo.setEndTimeDate(tripEndDate);
                entryInfo.setEndTimeHMS(endTime);
            }
            if (entryInfo.getLastUpdateTime() == null) {
                entryInfo.setLastUpdateTime(Date.getTimeInst());
            }
            if (entryInfo.getLastUpdateUser() == null) {
                entryInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
        }
        return entryBaseInfo;
    }

    public static CoreBaseInfo setDefault2Bill(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        if (!(model instanceof AtsAffairBaseInfo)) {
            return model;
        }
        AtsAffairBaseInfo billInfo = (AtsAffairBaseInfo)model;
        EntityObjectInfo entityObject = AtsBillAssist.getSupplierObject(AtsEntityUtile.getEntityObj(ctx, model), "entries");
        if (entityObject == null || !(billInfo.get("entries") instanceof IObjectCollection)) {
            return model;
        }
        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance((Context)ctx);
        AtsAffairBaseInfo dbData = (AtsAffairBaseInfo)model.clone();
        loader.fillValue((IObjectValue)dbData);
        String modelId = CoreBaseUtile.getId(model);
        boolean updateOperation = StringUtils.isNotBlank((CharSequence)modelId) && AtsEntityUtile.getBizInterface(ctx, model).exists((IObjectPK)new ObjectUuidPK(modelId));
        AtsBillAssist.setDefaultBillTime(ctx, model);
        if (loader.getProperty((IObjectValue)dbData, "number") == null) {
            NumberCodeRule.setNumber(ctx, (CoreBaseInfo)billInfo);
        }
        try {
            Class entryCls = entityObject.getObjectValueClazzRuntime();
            if (AtsAffairEntryBaseInfo.class.isAssignableFrom(entryCls)) {
                AtsAffairEntryBaseInfo entryInfo2 = null;
                IObjectCollection entryColl = (IObjectCollection)billInfo.get("entries");
                if (!updateOperation && AtsCollectionUtile.isEmpty(entryColl)) {
                    entryInfo2 = (AtsAffairEntryBaseInfo)entryCls.newInstance();
                    entryColl.addObject((IObjectValue)entryInfo2);
                }
                PersonInfo personInfo = SHRBillUtil.getCurrPersonInfoNew(ctx);
                if (StringUtils.isNotBlank((CharSequence)billInfo.getString("ccPerson"))) {
                    String personIds = billInfo.getString("ccPerson").replace(",", "','");
                    personIds = String.format("select id,name,number where id in ('%s')", personIds);
                    PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(personIds);
                    billInfo.put("ccPersonIds", persons);
                }
                AtsFileBaseInfo fileHISInfo = new AtsFileBaseInfo();
                for (AtsAffairEntryBaseInfo entryInfo2 : entryColl) {
                    if (entryInfo2.getPerson() == null) {
                        AtsAffairEntryBaseInfo dbEntry = (AtsAffairEntryBaseInfo)entryInfo2.clone();
                        loader.fillValue((IObjectValue)dbEntry);
                        entryInfo2.setPerson(dbEntry.getPerson() == null ? personInfo : dbEntry.getPerson());
                    }
                    boolean loadFile = entryInfo2.getAdminOrgUnit() == null || entryInfo2.getPosition() == null;
                    boolean bl = loadFile = loadFile || entryInfo2.getAttAdminOrgUnit() == null || !entryInfo2.containsKey("isDefaultManage");
                    if (loadFile) {
                        fileHISInfo = AtsBillAssist.getFileHisInfoByBill(ctx, (CoreBaseInfo)entryInfo2);
                        if (fileHISInfo == null && model instanceof FillSignCardInfo && entryInfo2 != null) {
                            Timestamp beginTime = AtsBillAssist.getRealBeginTime((CoreBaseInfo)entryInfo2);
                            entryInfo2.put(AtsBillAssist.getBeginTimeFieldName(entryInfo2.getClass()), Date.getNoNullTime(beginTime).preDay());
                            fileHISInfo = AtsBillAssist.getFileHisInfoByBill(ctx, model);
                            entryInfo2.put(AtsBillAssist.getBeginTimeFieldName(entryInfo2.getClass()), beginTime);
                        }
                        if (fileHISInfo == null) {
                            throw new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTFILE);
                        }
                    }
                    if (entryInfo2.getAdminOrgUnit() == null) {
                        entryInfo2.setAdminOrgUnit(fileHISInfo.getAdminOrgUnit());
                    }
                    if (entryInfo2.getPosition() == null) {
                        entryInfo2.setPosition(fileHISInfo.getPosition());
                    }
                    if (entryInfo2.getAttAdminOrgUnit() == null && fileHISInfo.get("attAdminOrgUnit") instanceof AdminOrgUnitInfo) {
                        entryInfo2.setAttAdminOrgUnit((AdminOrgUnitInfo)fileHISInfo.get("attAdminOrgUnit"));
                    }
                    if (entryInfo2.containsKey("isDefaultManage")) continue;
                    entryInfo2.put("isDefaultManage", fileHISInfo.isIsDefaultManage());
                }
                fileHISInfo = AtsBillAssist.getFileHisInfoByBill(ctx, model);
                if (loader.getProperty((IObjectValue)dbData, "proposer") == null) {
                    billInfo.setProposer(personInfo);
                }
                if (loader.getProperty((IObjectValue)dbData, "applyDate") == null) {
                    billInfo.setApplyDate(new Timestamp(System.currentTimeMillis()));
                }
                if (loader.getProperty((IObjectValue)dbData, "bizDate") == null) {
                    billInfo.setBizDate(billInfo.getApplyDate());
                }
                if (billInfo.getAdminOrg() == null) {
                    billInfo.setAdminOrg(fileHISInfo.getAdminOrgUnit());
                }
                billInfo.setIsMultiEntry(entryColl.size() > 1);
                if (loader.getProperty((IObjectValue)billInfo, "billSourceType") == null) {
                    billInfo.put("billSourceType", (Object)BillSourceTypeEnum.lightApp);
                }
                if (billInfo.get("billType") == null) {
                    billInfo.put("billType", entryColl.size() > 1 ? 2 : 1);
                }
                if (billInfo.getBillState() == null) {
                    billInfo.setBillState(HRBillStateEnum.SAVED);
                }
                if (billInfo.getHrOrgUnit() == null) {
                    billInfo.setHrOrgUnit(fileHISInfo.getHrOrgUnit());
                }
            }
        }
        catch (BOSException | ClassNotFoundException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, e, new Object[]{e.getMessage()});
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static EntityObjectInfo getSupplierObject(EntityObjectInfo entityObject, String propertyName) {
        PropertyInfo entriesProperty;
        if (entityObject != null && StringUtils.isNotBlank((CharSequence)propertyName) && (entriesProperty = entityObject.getPropertyByNameRuntime(propertyName)) instanceof LinkPropertyInfo) {
            RelationshipInfo relationship = ((LinkPropertyInfo)entriesProperty).getRelationship();
            if (relationship == null) {
                return null;
            }
            EntityObjectInfo upplierObject = relationship.getSupplierObject();
            return entityObject.equals((Object)upplierObject) ? relationship.getClientObject() : upplierObject;
        }
        return null;
    }

    public static void updateEntriesLastUpdateInfo(Context ctx, String billID) throws EASBizException, BOSException {
        Object[] billIds = StringUtils.split((String)billID, (String)",");
        if (AtsCollectionUtile.isEmpty(billIds)) {
            return;
        }
        EntityObjectInfo entityObj = AtsEntityUtile.getEntityObj(ctx, (String)billIds[0]);
        try {
            if (AtsAffairBaseInfo.class.isAssignableFrom(entityObj.getObjectValueClazzRuntime())) {
                entityObj = AtsEntityUtile.getFieldDeclareEntityObj(entityObj, "entries");
            }
        }
        catch (ClassNotFoundException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
        if (entityObj == null) {
            return;
        }
        PropertyInfo lastUpdateUser = entityObj.getPropertyByNameRuntime("lastUpdateUser");
        PropertyInfo lastUpdateTime = entityObj.getPropertyByNameRuntime("lastUpdateTime");
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(entityObj.getTable().getName()).append(" set ");
        ArrayList<Object> params = new ArrayList<Object>(2);
        if (lastUpdateUser != null) {
            updateSql.append(lastUpdateUser.getMappingField().getName()).append("=?,");
            params.add(CoreBaseUtile.getId(ContextUtil.getCurrentUserInfo((Context)ctx)));
        }
        if (lastUpdateTime != null) {
            updateSql.append(lastUpdateTime.getMappingField().getName()).append("=?,");
            params.add(Date.getTimeInst());
        }
        if (params.size() == 0) {
            return;
        }
        updateSql.setLength(updateSql.length() - 1);
        updateSql.append(" where fid in ").append(AtsCollectionUtile.joinForSql(billIds.length));
        params.addAll(Arrays.asList(billIds));
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params.toArray());
    }

    public static String getExplainField(CoreBaseInfo model) {
        String fieldNames = model instanceof AtsOverTimeBillInfo ? "otExplain" : "";
        fieldNames = model instanceof CanTripBillInfo ? "canTripExplain" : fieldNames;
        fieldNames = model instanceof AtsTripBillInfo ? "tripExplain" : fieldNames;
        fieldNames = model instanceof FillSignCardInfo ? "signCardExplain" : fieldNames;
        return fieldNames;
    }

    static {
        AtsBillAssist.regist(AtsTripBillEntryInfo.class, "tripStartTime", "tripEndTime", "realTripStartTime", "realTripEndTime");
        AtsBillAssist.regist(CanTripBillEntryInfo.class, null, null, "realStartTime", "realEndTime");
        AtsBillAssist.regist(AtsLeaveBillEntryInfo.class, "beginTime", "endTime", "realBeginTime", "realEndTime");
        AtsBillAssist.regist(CancelLeaveBillEntryInfo.class, null, null, "realLeaBeginTime", "realLeaEndTime");
        AtsBillAssist.regist(AtsOverTimeBillEntryInfo.class, "startTime", "endTime", "realStartTime", "realEndTime");
        AtsBillAssist.regist(FillSignCardEntryInfo.class, "attendDate", "attendDate", "attendDate", "attendDate");
        AtsBillAssist.regist(AtsScheduleShiftEntryInfo.class, "attendDateBefore", "attendDateBefore", "attendDateBefore", "attendDateBefore");
    }
}

