/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLogicCommonResEnum;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.ECalendarType;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsContextUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BaseTypeWithJava;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeDateTime;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import com.kingdee.util.profile.ProfileConfig;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public class AtsCommonUtile {
    private static Logger logger = Logger.getLogger(AtsCommonUtile.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormator = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormtor = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateNumFormtor = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("YYYYMMddHHmmss");
        }
    };

    public static boolean isNotNull(Object o) {
        return o != null;
    }

    public static SimpleDateFormat getDateFormat() {
        return dateFormator.get();
    }

    public static SimpleDateFormat getDateTimeFormat() {
        return dateTimeFormtor.get();
    }

    public static SimpleDateFormat getDateNumFormat() {
        return dateNumFormtor.get();
    }

    public static Timestamp getTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Date analyzeStartDate(Date date, String dateEpression) {
        Date base = AtsCommonUtile.analyzeDate(date, dateEpression);
        return AtsCommonUtile.getStartDate(base, ECalendarType.getEnum(dateEpression.substring(dateEpression.indexOf("_") + 1)));
    }

    public static Date analyzeEndDate(Date date, String dateEpression) {
        Date base = AtsCommonUtile.analyzeDate(date, dateEpression);
        return AtsCommonUtile.getEndDate(base, ECalendarType.getEnum(dateEpression.substring(dateEpression.indexOf("_") + 1)));
    }

    public static Date analyzeDate(Date date, String dateEpression) {
        Calendar base = Calendar.getInstance();
        if (date != null) {
            base.setTime(date);
        }
        if (StringUtils.isNotEmpty((CharSequence)dateEpression) && dateEpression.indexOf("_") != -1) {
            int dotIndex = dateEpression.indexOf("_");
            String calendarType = dateEpression.substring(dotIndex + 1);
            int dateChangeAmount = Integer.valueOf(dateEpression.substring(0, dotIndex));
            switch (ECalendarType.getEnum(calendarType).getValue()) {
                case 1: {
                    base.add(5, dateChangeAmount);
                    break;
                }
                case 2: {
                    base.add(5, dateChangeAmount * 7);
                    break;
                }
                case 3: {
                    base.add(2, dateChangeAmount);
                    break;
                }
                case 4: {
                    base.add(2, dateChangeAmount * 3);
                    break;
                }
                case 5: {
                    base.add(1, dateChangeAmount);
                    break;
                }
            }
        }
        return base.getTime();
    }

    public static Date getStartDate(Date date, ECalendarType calendarType) {
        Calendar base = Calendar.getInstance();
        if (date != null) {
            base.setTime(date);
        }
        switch (calendarType.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                base.set(7, 1);
                break;
            }
            case 3: {
                base.set(5, 1);
                break;
            }
            case 4: {
                base.set(base.get(1), base.get(2) / 3 * 3, 1);
                break;
            }
            case 5: {
                base.set(6, 1);
                break;
            }
        }
        return AtsCommonUtile.getDayStart(base.getTime());
    }

    public static Date getEndDate(Date date, ECalendarType calendarType) {
        Calendar base = Calendar.getInstance();
        if (date != null) {
            base.setTime(date);
        }
        switch (calendarType.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                base.set(7, 7);
                break;
            }
            case 3: {
                base.set(5, base.getActualMaximum(5));
                break;
            }
            case 4: {
                base.setTime(AtsCommonUtile.getStartDate(date, calendarType));
                base.add(2, 2);
                base.set(5, base.getActualMaximum(5));
                break;
            }
            case 5: {
                base.set(6, base.getActualMaximum(6));
                break;
            }
        }
        return AtsCommonUtile.getDayEnd(base.getTime());
    }

    public static Date getDayStart(Date baseDate) {
        Calendar calendar = Calendar.getInstance();
        if (baseDate != null) {
            calendar.setTime(baseDate);
        }
        try {
            return AtsCommonUtile.getDateTimeFormat().parse(AtsCommonUtile.getDayStartStr(baseDate));
        }
        catch (ParseException e) {
            AtsLog.getLog().error((Object)e);
            return DateUtils.truncate((Date)new Date(), (int)5);
        }
    }

    public static String getDayStartStr(Date baseDate) {
        Calendar calendar = Calendar.getInstance();
        if (baseDate != null) {
            calendar.setTime(baseDate);
        }
        return AtsCommonUtile.formateDate(calendar.getTime()) + " 00:00:00";
    }

    public static Date getDayEnd(Date baseDate) {
        if ((baseDate = AtsCommonUtile.getDayStart(baseDate)) == null) {
            return null;
        }
        return new java.sql.Date(baseDate.getTime() + 86400000L - 50L);
    }

    public static String getDayEndStr(Date baseDate) {
        return AtsCommonUtile.formateTime(AtsCommonUtile.getDayEnd(baseDate));
    }

    public static Date getNextWeekStart(Date date, int amount) {
        Date newDate = AtsCommonUtile.getNextWeekDay(date, amount);
        return AtsCommonUtile.getWeekStart(newDate);
    }

    public static Date getNextWeekEnd(Date date, int amount) {
        Date newDate = AtsCommonUtile.getNextWeekDay(date, amount);
        return AtsCommonUtile.getWeekEnd(newDate);
    }

    public static Date getNextWeekDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 7 * amount);
        return calendar.getTime();
    }

    public static Date getWeekStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static Date getWeekEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        return calendar.getTime();
    }

    public static Date getDate(Object dateExpression) {
        if (dateExpression == null) {
            return null;
        }
        String dateStr = null;
        if (Date.class.isAssignableFrom(dateExpression.getClass())) {
            dateStr = AtsCommonUtile.formateDate((Date)dateExpression);
        }
        if (Calendar.class.isAssignableFrom(dateExpression.getClass())) {
            dateStr = AtsCommonUtile.formateDate(((Calendar)dateExpression).getTime());
        }
        if (dateStr == null && AtsCommonUtile.isDigit(dateExpression.toString())) {
            dateStr = new Timestamp(Long.valueOf(dateExpression.toString())).toString();
        }
        if (dateStr == null && String.class.equals(dateExpression.getClass())) {
            dateStr = dateExpression.toString();
        }
        try {
            return AtsCommonUtile.getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            AtsLog.getLog().info((Object)("transform error:" + dateExpression));
            return null;
        }
    }

    public static Date getTime(Object dateExpression) {
        if (dateExpression == null) {
            return null;
        }
        if (String.class.equals(dateExpression.getClass())) {
            String express = dateExpression.toString().trim();
            try {
                return new Timestamp(Long.valueOf(express));
            }
            catch (Exception e) {
                try {
                    if (!express.contains(":")) {
                        express = express + " 00:00:00";
                    } else if (express.split(":").length < 3) {
                        express = express + ":00";
                    }
                    if (express.length() < 10) {
                        express = AtsCommonUtile.formateDate(Calendar.getInstance().getTime()) + " " + express;
                    }
                    return AtsCommonUtile.getDateTimeFormat().parse(express);
                }
                catch (ParseException e2) {
                    AtsLog.getLog().info((Object)("time transform error:" + dateExpression));
                }
            }
        }
        if (dateExpression instanceof Long || dateExpression.getClass() == Long.TYPE) {
            return new Timestamp((Long)dateExpression);
        }
        if (Date.class.isAssignableFrom(dateExpression.getClass())) {
            return (Date)dateExpression;
        }
        if (Calendar.class.isAssignableFrom(dateExpression.getClass())) {
            return ((Calendar)dateExpression).getTime();
        }
        return null;
    }

    @Deprecated
    public static int dateDiff(Object startDate, Object endDate, int calendarField) {
        if (startDate != null && endDate != null) {
            Date first = AtsCommonUtile.getTime(startDate);
            Date second = AtsCommonUtile.getTime(endDate);
            if (first != null && second != null) {
                Calendar first2 = Calendar.getInstance();
                Calendar second2 = Calendar.getInstance();
                first2.setTime(first);
                second2.setTime(second);
                int yearDiff = second2.get(1) - first2.get(1);
                long timeDiff = second2.getTimeInMillis() - first2.getTimeInMillis();
                switch (calendarField) {
                    case 1: {
                        return yearDiff;
                    }
                    case 2: {
                        return yearDiff * 12 + second2.get(2) - first2.get(2);
                    }
                    case 6: {
                        Date start = AtsCommonUtile.getDayStart(first);
                        Date end = AtsCommonUtile.getDayStart(second);
                        return (int)((end.getTime() - start.getTime()) / 86400000L);
                    }
                    case 10: {
                        return (int)(timeDiff / 3600000L);
                    }
                    case 12: {
                        return (int)(timeDiff / 60000L);
                    }
                    case 13: {
                        return (int)(timeDiff / 60000L);
                    }
                }
                return (int)timeDiff;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static String formateDate(String date) throws ParseException {
        return AtsCommonUtile.getDateFormat().format(AtsCommonUtile.getDateFormat().parse(date));
    }

    public static String formateDate(Date date) {
        return AtsCommonUtile.getDateFormat().format(date);
    }

    public static String formateTime(Date date) {
        return AtsCommonUtile.getDateTimeFormat().format(date);
    }

    public static String formateTime(String date) throws ParseException {
        return AtsCommonUtile.getDateTimeFormat().format(AtsCommonUtile.getDateTimeFormat().parse(date));
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static String getMonthFirstDayStr(Date date) {
        return AtsCommonUtile.getDateFormat().format(AtsCommonUtile.getMonthFirstDay(date));
    }

    public static Date getMonthFirstDay(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(AtsCommonUtile.getDateFormat().parse(date));
            calendar.set(5, 1);
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMonthFirstDayStr(String date) {
        return AtsCommonUtile.getDateFormat().format(AtsCommonUtile.getMonthFirstDay(date));
    }

    public static Date getMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static String getMonthLastDayStr(Date date) {
        return AtsCommonUtile.getDateFormat().format(AtsCommonUtile.getMonthLastDay(date));
    }

    public static Date getMonthLastDay(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(AtsCommonUtile.getDateFormat().parse(date));
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMonthLastDayStr(String date) {
        return AtsCommonUtile.getDateFormat().format(AtsCommonUtile.getMonthLastDay(date));
    }

    public static String getNextMonthDayStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 2, 1, AtsCommonUtile.getDateFormat());
    }

    public static Date getNextMonthDay(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 2, 1, AtsCommonUtile.getDateFormat());
    }

    public static String getPreMonthDayStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 2, -1, AtsCommonUtile.getDateFormat());
    }

    public static Date getPreMonthDay(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 2, -1, AtsCommonUtile.getDateFormat());
    }

    public static String getNextMonthDayStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 2, 1, AtsCommonUtile.getDateFormat());
    }

    public static Date getNextMonthDay(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 2, 1);
    }

    public static String getPreMonthDayStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 2, -1, AtsCommonUtile.getDateFormat());
    }

    public static Date getPreMonthDay(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 2, -1);
    }

    public static String getNextDayTimeStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, 1, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date getNextDayTime(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, 1);
    }

    public static String getNextDayTimeStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, 1, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date getNextDayTime(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, 1, AtsCommonUtile.getDateTimeFormat());
    }

    public static String getPreDayTimeStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, -1, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date getPreDayTime(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, -1);
    }

    public static String getPreDayTimeStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, -1, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date getPreDayTime(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, -1, AtsCommonUtile.getDateTimeFormat());
    }

    public static String timeAddStr(Date date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAddStr(date, dateField, amount, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date timeAdd(Date date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAdd(date, dateField, amount);
    }

    public static String timeAddStr(String date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAddStr(date, dateField, amount, AtsCommonUtile.getDateTimeFormat());
    }

    public static Date timeAdd(String date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAdd(date, dateField, amount, AtsCommonUtile.getDateTimeFormat());
    }

    public static String getNextDayStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, 1, AtsCommonUtile.getDateFormat());
    }

    public static Date getNextDay(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, 1);
    }

    public static String getPreDayStr(Date date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, -1, AtsCommonUtile.getDateFormat());
    }

    public static Date getPreDay(Date date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, -1);
    }

    public static String getNextDayStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, 1, AtsCommonUtile.getDateFormat());
    }

    public static Date getNextDay(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, 1, AtsCommonUtile.getDateFormat());
    }

    public static String getPreDayStr(String date) {
        return AtsCommonUtile.dateTimeAddStr(date, 5, -1, AtsCommonUtile.getDateFormat());
    }

    public static Date getPreDay(String date) {
        return AtsCommonUtile.dateTimeAdd(date, 5, -1, AtsCommonUtile.getDateFormat());
    }

    public static String dateAddStr(Date date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAddStr(date, dateField, amount, AtsCommonUtile.getDateFormat());
    }

    public static Date dateAdd(Date date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAdd(date, dateField, amount);
    }

    public static String dateAddStr(String date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAddStr(date, dateField, amount, AtsCommonUtile.getDateFormat());
    }

    public static Date dateAdd(String date, int dateField, int amount) {
        return AtsCommonUtile.dateTimeAdd(date, dateField, amount, AtsCommonUtile.getDateFormat());
    }

    public static String dateTimeAddStr(String date, int dateField, int amount, SimpleDateFormat sdf) {
        return sdf.format(AtsCommonUtile.dateTimeAdd(date, dateField, amount, sdf));
    }

    public static final Date dateTimeAdd(String date, int dateField, int amount, SimpleDateFormat sdf) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(date));
            calendar.add(dateField, amount);
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dateTimeAddStr(Date date, int dateField, int amount, SimpleDateFormat sdf) {
        return sdf.format(AtsCommonUtile.dateTimeAdd(date, dateField, amount));
    }

    public static Date dateTimeAdd(Date date, int dateField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(dateField, amount);
        return calendar.getTime();
    }

    public static Timestamp toTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Date getMinDate(Date firstDate, Date secondDate) {
        return firstDate.before(secondDate) ? firstDate : secondDate;
    }

    public static Date getMaxDate(Date firstDate, Date secondDate) {
        return firstDate.before(secondDate) ? secondDate : firstDate;
    }

    public static RangeDateTime retainAll(Date firstDate1, Date firstDate2, Date secondDate1, Date secondDate2) {
        Date endDate;
        if (firstDate1 == null || firstDate2 == null || secondDate1 == null || secondDate2 == null) {
            return new RangeDateTime();
        }
        Date firstMinDate = AtsCommonUtile.getMinDate(firstDate1, firstDate2);
        Date firstMaxDate = AtsCommonUtile.getMaxDate(firstDate1, firstDate2);
        Date secondMinDate = AtsCommonUtile.getMinDate(secondDate1, secondDate2);
        Date secondMaxDate = AtsCommonUtile.getMaxDate(secondDate1, secondDate2);
        Date startDate = AtsCommonUtile.getMaxDate(firstMinDate, secondMinDate);
        return startDate.before(endDate = AtsCommonUtile.getMinDate(firstMaxDate, secondMaxDate)) ? new RangeDateTime(startDate, endDate) : new RangeDateTime();
    }

    public static boolean isValid(RangeDate rangeDate) {
        return rangeDate != null && rangeDate.getLowBound() != null && rangeDate.getUpBound() != null;
    }

    public static AttendanceFileInfo convertHis2File(AttendanceFileHISInfo hisInfo) {
        AttendanceFileInfo fileInfo = new AttendanceFileInfo();
        fileInfo.setAttendanceNum(hisInfo.getAttendanceNum());
        fileInfo.setIsAttendance(hisInfo.getIsAttendance());
        fileInfo.setAttendFileState(hisInfo.getAttendFileState());
        fileInfo.setRemark(hisInfo.getRemark());
        fileInfo.setAttendCenter(hisInfo.getAttendCenter());
        fileInfo.setAttencePolicy(hisInfo.getAttencePolicy());
        fileInfo.setHolidayPolicySet(hisInfo.getHolidayPolicySet());
        fileInfo.setAtsShift(hisInfo.getAtsShift());
        fileInfo.setFileType(hisInfo.getFileType());
        fileInfo.setIsAutoShift(hisInfo.getIsAutoShift());
        fileInfo.setProposer(hisInfo.getProposer());
        fileInfo.setHrOrgUnit(hisInfo.getHrOrgUnit());
        fileInfo.setPosition(hisInfo.getPosition());
        fileInfo.setAttPosition(hisInfo.getAttPosition());
        fileInfo.setAdminOrgUnit(hisInfo.getAdminOrgUnit());
        fileInfo.setAttAdminOrgUnit(hisInfo.getAttAdminOrgUnit());
        fileInfo.setIsDefaultManage(hisInfo.isIsDefaultManage());
        fileInfo.setManageRelation(hisInfo.getManageRelation());
        fileInfo.setEFFDT(hisInfo.getEFFDT());
        fileInfo.setLEFFDT(hisInfo.getLEFFDT());
        fileInfo.setAttendFileState(AttendFileStateEnum.enable);
        Set<String> colNameSet = AtsCommonUtile.getAtsPrepareExtendColName("com.kingdee.eas.hr.ats.app.AttendanceFileHIS");
        if (!AtsCollectionUtile.isEmpty(colNameSet)) {
            for (String colName : colNameSet) {
                fileInfo.put(colName.substring(2), hisInfo.get(colName.substring(2)));
            }
        }
        return fileInfo;
    }

    public static Set<String> getAtsPrepareExtendColName(String metadataPath) {
        HashSet<String> colNameSet = new HashSet<String>();
        Collection<PropertyInfo> propertyVals = AtsCommonUtile.getProperties(metadataPath).values();
        for (PropertyInfo proertyVal : propertyVals) {
            if (proertyVal.getMappingField() == null || !proertyVal.getName().startsWith("CF")) continue;
            colNameSet.add(proertyVal.getName());
        }
        return colNameSet;
    }

    public static <V> V getInstance(String className, Class<V> parentClass) {
        V v = null;
        Class<V> currentClass = AtsCommonUtile.getClass(className, parentClass);
        if (currentClass != null) {
            v = AtsCommonUtile.getInstance(currentClass);
        }
        return v;
    }

    public static <V> Class<V> getClass(String className, Class<V> parentClass) {
        Class currentClass = null;
        try {
            currentClass = MsfClassLoaderFactory.forName((String)className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return currentClass;
    }

    public static <V> V getInstance(Class<V> specialClass) {
        V v = null;
        try {
            Constructor constructor = ReflectionUtils.accessibleConstructor(specialClass, null);
            v = (V)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return v;
    }

    public static Map<String, PropertyInfo> getProperties(String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return new LinkedHashMap<String, PropertyInfo>();
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            map.put(propertyInfo.getName(), propertyInfo);
        }
        return map;
    }

    public static void responseError(HttpServletResponse response, String msg) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMsg", msg == null ? "" : msg);
        map.put("success", false);
        AtsCommonUtile.writeJson(response, JSON.toJSONString(map));
    }

    public static void responseError(HttpServletResponse response, Collection<?> msgs) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMsg", AtsCollectionUtile.buildBrString(msgs));
        map.put("success", false);
        AtsCommonUtile.writeJson(response, JSON.toJSONString(map));
    }

    public static void writeJson(HttpServletResponse response, String msg) throws Exception {
        PrintWriter pw;
        response.setContentType("application/json;charset=UTF-8");
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            throw new Exception("can't open the output stream!");
        }
        pw.write(msg);
        pw.flush();
    }

    public static boolean isNotAllNullRequestField(HttpServletRequest request, String[] fields) {
        for (String field : fields) {
            if (!StringUtils.isNotEmpty((CharSequence)request.getParameter(field)) && !StringUtils.isNotEmpty((CharSequence)request.getAttribute(field).toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAllNullField(String[] fields) {
        for (String field : fields) {
            if (!StringUtils.isNotEmpty((CharSequence)field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAllNullField(Collection<?> collection) {
        for (Object field : collection) {
            if (field == null || !StringUtils.isNotEmpty((CharSequence)field.toString())) continue;
            return true;
        }
        return false;
    }

    public static String correctStr(Object o) {
        return o == null ? "" : o.toString();
    }

    public static void correctFields(JSONObject fields) {
        if (fields != null) {
            Iterator fieldIterator = fields.keySet().iterator();
            while (fieldIterator.hasNext()) {
                String field = (String)fieldIterator.next();
                Object fieldValue = fields.get((Object)field);
                if (field != null && fieldValue != null && !StringUtils.isEmpty((CharSequence)fieldValue.toString())) continue;
                fieldIterator.remove();
            }
        }
    }

    public static String formateDateNum(Date date) {
        return AtsCommonUtile.getDateNumFormat().format(date == null ? Calendar.getInstance().getTime() : date);
    }

    public static String formateDateNum(Object dateStr) {
        return AtsCommonUtile.formateDateNum(AtsCommonUtile.getTime(dateStr));
    }

    public static String formateDateNum() {
        return AtsCommonUtile.formateDateNum(null);
    }

    public static int parseInt(String numStr, int defaultValue) {
        try {
            return Integer.valueOf(numStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int parseInt(String numStr) {
        return AtsCommonUtile.parseInt(numStr, 0);
    }

    public static <V> V getFromCtx(Context ctx, Object fieldName, Class<V> classObj) {
        if (ctx == null || ctx.get(fieldName) == null) {
            return null;
        }
        return (V)ctx.get(fieldName);
    }

    public static String getFromCtx(Context ctx, Object fieldName) {
        return AtsCommonUtile.getFromCtx(ctx, fieldName, (String)null);
    }

    public static String getFromCtx(Context ctx, Object fieldName, String defaultVal) {
        if (ctx == null || ctx.get(fieldName) == null || StringUtils.isBlank((CharSequence)String.valueOf(ctx.get(fieldName)))) {
            return defaultVal;
        }
        return String.valueOf(ctx.get(fieldName));
    }

    public static <V> V getFromMap(Map<?, ?> map, Object fieldName, Class<V> classObj) {
        if (map == null || map.get(fieldName) == null) {
            return null;
        }
        return (V)map.get(fieldName);
    }

    public static String getFromMap(Map<?, ?> map, Object fieldName) {
        return AtsCommonUtile.getFromMap(map, fieldName, (String)null);
    }

    public static String getFromMap(Map<?, ?> map, Object fieldName, String defaultVal) {
        if (map == null || map.get(fieldName) == null || StringUtils.isBlank((CharSequence)String.valueOf(map.get(fieldName)))) {
            return defaultVal;
        }
        return String.valueOf(map.get(fieldName));
    }

    public static <T extends IObjectValue> T createCoreInfo(String id, Class<T> classObj) {
        IObjectValue t = (IObjectValue)AtsCommonUtile.getInstance(classObj);
        if (t != null) {
            ((CoreBaseInfo)t).setId(BOSUuid.read((String)id));
        }
        return (T)t;
    }

    public static CoreBaseInfo createCoreInfo(String id) {
        if (!BOSUuid.isValid((String)id, (boolean)true)) {
            return null;
        }
        EntityObjectInfo entityObj = AtsEntityUtile.getEntityObj(AtsContextUtile.getCtx(), id);
        CoreBaseInfo t = null;
        try {
            t = (CoreBaseInfo)AtsCommonUtile.getInstance(entityObj == null ? null : entityObj.getObjectValueClazzRuntime());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (t != null) {
            t.setId(BOSUuid.read((String)id));
        }
        return t;
    }

    public static ObjectUuidPK getUuidPk(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return new ObjectUuidPK(id);
        }
        return null;
    }

    public static String getServerInst() {
        return System.getProperty("EAS_INSTANCE_NAME");
    }

    public static Object getValFromCoreBase(CoreBaseInfo coreBaseInfo, String field) {
        Enumeration it = coreBaseInfo.keys();
        Object value = null;
        while (it.hasMoreElements()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)((String)it.nextElement()))) continue;
            value = coreBaseInfo.get(field);
            if (value instanceof Date) {
                return new Timestamp(coreBaseInfo.getDate(field).getTime());
            }
            if (value instanceof CoreBaseInfo) {
                return CoreBaseUtile.getId(value);
            }
            if (value instanceof Enum) {
                return AtsCommonUtile.serializeBosEnum((Enum)value).get((Object)"value");
            }
            if (!(value instanceof Boolean)) continue;
            return (Boolean)value != false ? 1 : 0;
        }
        return value;
    }

    public static String getValNameCoreBase(Context ctx, CoreBaseInfo coreBaseInfo, String field) {
        if (coreBaseInfo.get(field) instanceof CoreBaseInfo) {
            return String.valueOf(((CoreBaseInfo)coreBaseInfo.get(field)).get("name"));
        }
        if (coreBaseInfo.get(field) instanceof Enum) {
            return AtsCommonUtile.serializeBosEnum((Enum)coreBaseInfo.get(field)).getString("alias");
        }
        if (coreBaseInfo.get(field) instanceof Boolean) {
            return (Boolean)coreBaseInfo.get(field) != false ? MLUtile.getRes(AtsLogicCommonResEnum.Yes, ctx) : MLUtile.getRes(AtsLogicCommonResEnum.No, ctx);
        }
        if (coreBaseInfo.get(field) != null) {
            return coreBaseInfo.get(field).toString();
        }
        return "";
    }

    public static JSONObject serializeBosEnum(Enum object) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("isenum", (Object)true);
        jsonObject.put("alias", (Object)object.getAlias());
        if (object instanceof StringEnum) {
            jsonObject.put("value", (Object)((StringEnum)object).getValue());
        } else if (object instanceof IntEnum) {
            jsonObject.put("value", (Object)((IntEnum)object).getValue());
        } else if (object instanceof DoubleEnum) {
            jsonObject.put("value", (Object)((DoubleEnum)object).getValue());
        } else if (object instanceof FloatEnum) {
            jsonObject.put("value", (Object)Float.valueOf(((FloatEnum)object).getValue()));
        }
        if (object.getName() != null) {
            jsonObject.put("name", (Object)object.getName());
        }
        return jsonObject;
    }

    public static String getInSql(String list) {
        if (StringUtils.isNotBlank((CharSequence)list)) {
            return new StringBuffer().append(" in ('").append(list.replaceAll(",", "','")).append("')").toString();
        }
        return list;
    }

    public static String getLikeSql(String list, String field) {
        if (StringUtils.isNotBlank((CharSequence)list)) {
            StringBuffer likeSql = new StringBuffer();
            for (String id : list.split("'")) {
                likeSql.append(" or").append(field).append(" like '%").append(id).append("%'");
            }
            return likeSql.substring(" or".length());
        }
        return list;
    }

    public static String getAdminSubContainSql(String list, String tableAlias) {
        return AtsCommonUtile.getAdminContainSql(list, tableAlias, true);
    }

    public static String getAdminSupContainSql(String list, String tableAlias) {
        return AtsCommonUtile.getAdminContainSql(list, tableAlias, false);
    }

    public static String getAdminContainSql(String list, String tableAlias, boolean subExt) {
        if (StringUtils.isNotBlank((CharSequence)list)) {
            StringBuffer likeSql = new StringBuffer();
            likeSql.append(" ").append(tableAlias).append(".flongNumber").append(AtsCommonUtile.getInSql(list));
            boolean isStart = true;
            for (String id : list.split("'")) {
                if (!isStart) {
                    likeSql.append(" or");
                } else {
                    isStart = false;
                }
                likeSql.append(tableAlias).append(".flongNumber like '");
                if (subExt) {
                    likeSql.append(id).append("!%'");
                    continue;
                }
                likeSql.append("%!").append(id).append("'");
            }
            return likeSql.toString();
        }
        return list;
    }

    public static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            AtsLog.getLog().error((Object)e);
        }
    }

    public static String processException(Throwable throwable) throws EASBizException {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)throwable;
            throwable = targetException.getTargetException() == null ? throwable : targetException;
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, throwable, new Object[]{throwable.getMessage()});
        }
        if (throwable instanceof UndeclaredThrowableException) {
            throwable = throwable.getCause() == null ? throwable : throwable.getCause();
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, throwable, new Object[]{throwable.getMessage()});
        }
        throw new HRCommonException(HRCommonException.EXCEPTION_MSG, throwable, new Object[]{throwable.getMessage()});
    }

    public static String getExciptionInfo(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sWriter));
        return sWriter.toString();
    }

    public static String getExciptionMsg(String msg, boolean throwMsg) throws HRCommonException {
        if (throwMsg && msg != null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        return StringUtils.trimToEmpty((String)msg);
    }

    public static boolean isDigit(Object expression) {
        if (expression instanceof Integer) {
            return true;
        }
        return AtsConstants.PATTERN_DIGIT.matcher(String.valueOf(expression).trim()).matches();
    }

    public static boolean isInteger(Object expression) {
        if (expression instanceof Integer) {
            return true;
        }
        String str = String.valueOf(expression).trim();
        if (str.charAt(0) == '-') {
            str = str.substring(1);
        }
        for (int i = 0; i < str.length(); ++i) {
            char indChar = str.charAt(i);
            if (indChar <= '9' && indChar >= '0') continue;
            return false;
        }
        return true;
    }

    public static String formatStr(String text, Object[] params) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        int formateCount = 0;
        Matcher matcher = AtsConstants.PATTERN_MSG_FORMAT.matcher(text);
        while (matcher.find()) {
            ++formateCount;
        }
        if (formateCount > 0 && (params == null || params.length < formateCount)) {
            ArrayList<Object> paramList = new ArrayList<Object>(formateCount);
            for (int i = 0; i < formateCount; ++i) {
                paramList.add(params == null || params.length < i + 1 || params[i] == null ? "" : params[i]);
            }
            params = paramList.toArray();
        }
        return formateCount == 0 ? text : MessageFormat.format(text, params);
    }

    public static List<Object> getValFromeCoreBaseWithDotField(Iterator<?> it, String fieldName) {
        ArrayList<Object> returnDate = new ArrayList<Object>();
        if (it == null || StringUtils.isBlank((CharSequence)fieldName)) {
            return returnDate;
        }
        String[] fieldNames = fieldName.split("\\.");
        int fieldLength = fieldNames.length - 1;
        while (it.hasNext()) {
            Object targeObj = it.next();
            if (!(targeObj instanceof CoreBaseInfo)) continue;
            CoreBaseInfo coreBaseInfo = (CoreBaseInfo)targeObj;
            for (int i = 0; i <= fieldLength && coreBaseInfo != null; ++i) {
                if (i == fieldLength) {
                    returnDate.add(coreBaseInfo.get(fieldNames[i]));
                    continue;
                }
                coreBaseInfo = coreBaseInfo.getObjectValue(fieldNames[i]);
            }
        }
        return returnDate;
    }

    public static RangeDate getDateRange(Iterator<?> it, String ... fieldNames) {
        int fieldCount;
        RangeDate rangeDate = new RangeDate();
        if (it == null) {
            return rangeDate;
        }
        int n = fieldCount = fieldNames == null ? 0 : fieldNames.length;
        while (it.hasNext()) {
            Object targeObj = it.next();
            if (targeObj instanceof Date) {
                AtsCommonUtile.setRagneDate((Date)targeObj, rangeDate);
                continue;
            }
            if (!(targeObj instanceof CoreBaseInfo) || fieldCount <= 0) continue;
            for (String fieldName : fieldNames) {
                AtsCommonUtile.setRagneDate(((CoreBaseInfo)targeObj).getTimestamp(fieldName), rangeDate);
            }
        }
        return rangeDate;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void setRagneDate(Date date, RangeDate rangeDate) {
        if (date == null || rangeDate == null) {
            return;
        }
        if (rangeDate.getLowBound() == null || date.before((Date)rangeDate.getLowBound())) {
            rangeDate.setLowBound(date);
        }
        if (rangeDate.getUpBound() == null || date.after((Date)rangeDate.getUpBound())) {
            rangeDate.setUpBound(date);
        }
    }

    public static String escapeSafeCheck(Object sql) {
        StringBuffer newSql = new StringBuffer();
        newSql.append(MessageFormat.format("{0}", sql));
        return newSql.toString();
    }

    public static String[] splitToArray(String str, String delimiter) {
        int flagStart = 0;
        int flagEnd = 0;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new String[0];
        }
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            return new String[]{str};
        }
        ArrayList<String> strList = new ArrayList<String>();
        while ((flagEnd = str.indexOf(delimiter, flagStart)) > -1) {
            strList.add(str.substring(flagStart, flagEnd));
            flagStart = flagEnd + delimiter.length();
        }
        if (AtsCollectionUtile.isEmpty(strList)) {
            return new String[]{str};
        }
        if (flagStart <= str.length()) {
            strList.add(str.substring(flagStart, str.length()));
        }
        String[] strArray = strList.toArray(new String[strList.size()]);
        return strArray;
    }

    public static void mergeFields(CoreBaseInfo targetInfo, CoreBaseInfo sorceInfo, List<String> excludeFields) {
        if (sorceInfo == null || targetInfo == null) {
            return;
        }
        Enumeration fieldEnum = sorceInfo.keys();
        while (fieldEnum.hasMoreElements()) {
            String field = (String)fieldEnum.nextElement();
            if (excludeFields != null && excludeFields.contains(field)) continue;
            targetInfo.put(field, sorceInfo.get(field));
        }
    }

    public static Boolean containsAll(Collection<String> c1, Collection<String> c2) {
        if (AtsCollectionUtile.isEmpty(c1)) {
            return false;
        }
        if (AtsCollectionUtile.isEmpty(c2)) {
            return true;
        }
        for (String c : c2) {
            if (!c1.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static Object getValueLazy(Context ctx, IObjectValue model, String fieldName) {
        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getInstance((Context)ctx);
        try {
            return loader.getProperty(model, fieldName);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isBOSUuid(String validateStr) {
        int ind = StringUtils.indexOf((CharSequence)validateStr, (int)44);
        return BOSUuid.isValid((String)(ind < 0 ? validateStr : validateStr.substring(0, ind)), (boolean)true);
    }

    public static void logFirstStack(Throwable throwable) {
        AtsCommonUtile.logFirstStack(throwable, ".ats.", 3);
    }

    public static void logFirstStack(Throwable throwable, String logFlag, int maxPrintLineNum) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] traceElements = throwable.getStackTrace();
        StringBuffer logBuf = new StringBuffer();
        if (traceElements != null && traceElements.length > 0) {
            boolean isNullFlag = StringUtils.isBlank((CharSequence)logFlag);
            int printLineNum = maxPrintLineNum;
            int len = traceElements.length;
            for (int i = 0; i < len && printLineNum > 0; ++i) {
                if (!isNullFlag && printLineNum >= maxPrintLineNum && !String.valueOf(traceElements[i]).contains(logFlag)) continue;
                logBuf.append(String.valueOf(traceElements[i])).append(";\r\n");
                --printLineNum;
            }
        }
        if (logBuf.length() > 0) {
            logger.error((Object)SHRCheck.vaildLog((String)MessageFormat.format("error:{0}:{1};", logBuf.toString(), throwable.getMessage())));
        } else {
            logger.error((Object)throwable.getMessage(), throwable);
        }
    }

    public static boolean isEquals(IObjectValue newObj, IObjectValue oldObj, List<String> includePropertyList) {
        PropertyDescriptor[] propertyDescriptors;
        if (newObj == null || oldObj == null) {
            return false;
        }
        if (newObj.getClass() != oldObj.getClass()) {
            return false;
        }
        if (AtsCollectionUtile.isEmpty(includePropertyList)) {
            return false;
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(newObj.getClass())) {
            PropertyDescriptor propertyDescriptorPrikey;
            Object oldProVal;
            Object newProVal;
            block13: {
                newProVal = null;
                oldProVal = null;
                try {
                    Method method = propertyDescriptor.getReadMethod();
                    if (method != null) {
                        newProVal = method.invoke((Object)newObj, new Object[0]);
                        oldProVal = method.invoke((Object)oldObj, new Object[0]);
                    }
                    if (!includePropertyList.contains(propertyDescriptor.getName()) && !(newProVal instanceof IObjectValue)) {
                    }
                    break block13;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (newProVal == null || oldProVal == null || newProVal.getClass() != oldProVal.getClass()) {
                return false;
            }
            Boolean isBaseType = BaseTypeWithJava.isBaseType(newProVal.getClass());
            if (isBaseType.booleanValue() || BOSUuid.class == newProVal.getClass()) {
                if (Objects.equals(newProVal, oldProVal)) continue;
                return false;
            }
            if (!IObjectValue.class.isAssignableFrom(newProVal.getClass()) || (propertyDescriptorPrikey = BeanUtils.getPropertyDescriptor(newProVal.getClass(), (String)"id")) == null) continue;
            Object newPK = null;
            Object oldPK = null;
            try {
                Method method = propertyDescriptorPrikey.getReadMethod();
                if (method != null) {
                    newPK = method.invoke(newProVal, new Object[0]);
                    oldPK = method.invoke(oldProVal, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newPK != null && oldPK != null && Objects.equals(newPK, oldPK)) continue;
            return false;
        }
        return true;
    }

    public static Object callOsfDispatcherService(Context ctx, Object coreBaseInfo, String actMethod, Map param) throws BOSException, EASBizException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CoreBaseInfo model = null;
        if (coreBaseInfo instanceof CoreBaseInfo) {
            model = (CoreBaseInfo)coreBaseInfo;
        } else if (coreBaseInfo instanceof String && BOSUuid.isValid((String)((String)coreBaseInfo), (boolean)true)) {
            model = AtsEntityUtile.getData(ctx, (String)coreBaseInfo);
        } else if (param.get("model") instanceof CoreBaseInfo) {
            model = (CoreBaseInfo)param.get("model");
        }
        if (model == null) {
            return null;
        }
        if (param != null) {
            paramMap.putAll(param);
        }
        if (paramMap.get("appModule") == null) {
            paramMap.put("appModule", "self");
        }
        paramMap.put("entity", model.getBOSType().toString());
        if (StringUtils.isNotBlank((CharSequence)actMethod)) {
            paramMap.put("actMethod", actMethod);
        }
        paramMap.put("model", JSONUtils.convertObjectToJson((Context)ctx, (Object)model));
        JSONObject osfRes = (JSONObject)OSFExecutor.executeOSF((Context)ctx, paramMap, (String)"atsOsfDispatcher");
        if (osfRes == null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{""});
        }
        if (osfRes.getBoolean("success").booleanValue()) {
            return osfRes.get((Object)"data");
        }
        String errorMsg = osfRes.getString("msg");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = osfRes.toString();
        }
        throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{errorMsg});
    }

    public static Class getClass(Object classOrInst) throws EASBizException {
        Class clz;
        if (classOrInst == null) {
            return null;
        }
        Class clazz = clz = classOrInst instanceof Class ? (Class)classOrInst : classOrInst.getClass();
        if (classOrInst instanceof String) {
            try {
                clz = Class.forName((String)classOrInst);
            }
            catch (ClassNotFoundException e) {
                try {
                    clz = MsfClassLoaderFactory.forName((String)((String)classOrInst));
                }
                catch (ClassNotFoundException e1) {
                    AtsCommonUtile.processException(e1);
                }
            }
        }
        return clz;
    }

    public static Object getInst(Object classOrInst) throws EASBizException {
        if (classOrInst instanceof Class || classOrInst instanceof String) {
            Class clz = AtsCommonUtile.getClass(classOrInst);
            try {
                Constructor constructor = clz.getConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(constructor);
                classOrInst = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                AtsCommonUtile.processException(e);
            }
        }
        return classOrInst;
    }

    public static Object callMethod(Object instance, Method method, Object[] param) throws EASBizException {
        ReflectionUtils.makeAccessible((Method)method);
        try {
            return method.invoke(instance, param);
        }
        catch (IllegalAccessException e) {
            AtsCommonUtile.processException(e);
        }
        catch (InvocationTargetException e) {
            AtsCommonUtile.processException(e);
        }
        return null;
    }

    public static Object callMethod(Object classOrInst, String methodName, Class[] paramTypes, Object[] param) throws EASBizException {
        Class clz = AtsCommonUtile.getClass(classOrInst);
        if (clz == null || StringUtils.isBlank((CharSequence)methodName)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{"classOrInst and methodName is required!"});
        }
        Method method = ReflectionUtils.findMethod((Class)clz, (String)methodName, (Class[])paramTypes);
        Object inst = Modifier.isStatic(method.getModifiers()) ? null : AtsCommonUtile.getInst(clz);
        return AtsCommonUtile.callMethod(inst, method, param);
    }

    public static Class getCallClass() {
        return StackLocatorUtil.getCallerClass((int)2);
    }

    public static String getCaller(Integer depth) {
        depth = depth == null ? 1 : depth;
        StackTraceElement traceElement = AtsCommonUtile.getStackTraceElement(depth + 1);
        return MessageFormat.format("[l:{0},{1}#{2}]", traceElement.getLineNumber(), traceElement.getClassName(), traceElement.getMethodName());
    }

    public static void logMethod(Logger logger) {
        Logger logger2 = logger = logger == null ? AtsCommonUtile.logger : logger;
        if (logger != null) {
            logger.error((Object)AtsCommonUtile.getCaller(2));
        }
    }

    public static StackTraceElement getStackTraceElement(Integer depth) {
        depth = depth == null ? 1 : depth;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            StackTraceElement element = stackTrace[i];
            if (i != depth) continue;
            return element;
        }
        throw new IndexOutOfBoundsException(Integer.toString(depth));
    }

    public static void enableProfileLog() throws HRCommonException {
        try {
            Field field = ReflectionUtils.findField(ProfileConfig.class, (String)"instance");
            ReflectionUtils.makeAccessible((Field)field);
            Constructor constructor = ReflectionUtils.accessibleConstructor(ProfileConfig.class, null);
            ReflectionUtils.setField((Field)field, null, constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static String decodeEmpBase64(String str) throws EASBizException {
        if (str == null || str.isEmpty()) {
            return str;
        }
        try {
            String newStr = new String(Base64.decodeBase64((String)new String(Base64.decodeBase64((String)str), "UTF-8").substring("_SHRREQPARA_".length())), "UTF-8");
            return newStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
    }
}

