/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.BaseTripTimeZoneTrigger;
import com.kingdee.eas.hr.ats.util.common.TripTimeZoneTrigger;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRTimeZoneInfo;
import com.kingdee.eas.hr.base.timezone.TimeZoneEventEnum;
import com.kingdee.eas.hr.base.timezone.TimeZoneUpdater;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Iterator;

public class CanTripTimeZoneTrigger
extends BaseTripTimeZoneTrigger {
    private AtsTripBillEntryCollection tripEntryColl;

    public CanTripTimeZoneTrigger() {
        this.billEntryClass = CanTripBillEntryInfo.class;
    }

    @Override
    protected String getFetchEntryOsql(Object bill) {
        return "select *,tripEntryBill.* where bill='" + bill + "'";
    }

    @Override
    protected Object getTimeZoneChangeEventInner(boolean authenOperation) {
        return TimeZoneEventEnum.ATS_TRIP_AUTHON;
    }

    @Override
    protected Iterator<?> getEntryIterator() {
        if (this.tripEntryColl == null) {
            this.initTripEntry();
        }
        return this.tripEntryColl == null ? Collections.EMPTY_LIST.iterator() : this.tripEntryColl.iterator();
    }

    @Override
    protected java.util.Date getMaxDateForLatest() {
        return (java.util.Date)AtsCommonUtile.getDateRange(this.getEntryIterator(), "tripStartTime").getUpBound();
    }

    @Override
    protected void beforTriggerAuthen() throws EASBizException {
        this.initTripEntry();
        TimeZoneUpdater timeZoneUpdaterNew = new TimeZoneUpdater();
        Iterator<?> it = this.getEntryIterator();
        while (it.hasNext()) {
            Date end;
            HRTimeZoneInfo hrTimeZoneInfo;
            AtsTripBillEntryInfo tripEntryInfo = (AtsTripBillEntryInfo)it.next();
            if (tripEntryInfo.getRealTripEndTime().equals(tripEntryInfo.getRealTripStartTime())) {
                hrTimeZoneInfo = (HRTimeZoneInfo)this.getPreTimeZone(tripEntryInfo).clone();
                hrTimeZoneInfo.setId(null);
                hrTimeZoneInfo.setEffdt((java.util.Date)Date.getDate(tripEntryInfo.getTripStartTime()));
                hrTimeZoneInfo.setLeffdt((java.util.Date)Date.getDate(tripEntryInfo.getTripEndTime()));
                timeZoneUpdaterNew.addToUpdate(hrTimeZoneInfo);
                continue;
            }
            Date start = Date.getDate(tripEntryInfo.getTripStartTime());
            if (start.before(end = Date.getDate(tripEntryInfo.getRealTripStartTime()))) {
                hrTimeZoneInfo = (HRTimeZoneInfo)this.getPreTimeZone(tripEntryInfo).clone();
                hrTimeZoneInfo.setId(null);
                hrTimeZoneInfo.setEffdt((java.util.Date)start);
                hrTimeZoneInfo.setLeffdt((java.util.Date)end.preDay());
                timeZoneUpdaterNew.addToUpdate(hrTimeZoneInfo);
            }
            if (!(start = Date.getDate(tripEntryInfo.getRealTripEndTime())).before(end = Date.getDate(tripEntryInfo.getTripEndTime()))) continue;
            hrTimeZoneInfo = (HRTimeZoneInfo)this.getPreTimeZone(tripEntryInfo).clone();
            hrTimeZoneInfo.setId(null);
            hrTimeZoneInfo.setEffdt((java.util.Date)start.nextDay());
            hrTimeZoneInfo.setLeffdt((java.util.Date)end);
            timeZoneUpdaterNew.addToUpdate(hrTimeZoneInfo);
        }
        if (!AtsCollectionUtile.isEmpty(timeZoneUpdaterNew.getOriginUpdateDatas())) {
            timeZoneUpdaterNew.setCtx(this.ctx).setForceUpdateLevel(this.getTripTimeZoneLevel());
            timeZoneUpdaterNew.update();
        }
    }

    @Override
    public boolean triggerUnAuthen() throws EASBizException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)this.billEntries)) {
            return false;
        }
        this.initTripEntry();
        AtsTripBillEntryCollection tripBillEntries = new AtsTripBillEntryCollection();
        TimeZoneUpdater timeZoneUpdaterNew = new TimeZoneUpdater();
        Iterator<?> it = this.getEntryIterator();
        while (it.hasNext()) {
            HRTimeZoneInfo hrTimeZoneInfo;
            Date real;
            boolean startDateChanged;
            AtsTripBillEntryInfo tripEntryInfo = (AtsTripBillEntryInfo)it.next();
            Date original = Date.getDate(tripEntryInfo.getTripStartTime());
            boolean bl = startDateChanged = !original.equals(real = Date.getDate(tripEntryInfo.getRealTripStartTime()));
            if (real.before(original)) {
                hrTimeZoneInfo = (HRTimeZoneInfo)this.getPreTimeZone(tripEntryInfo).clone();
                hrTimeZoneInfo.setId(null);
                hrTimeZoneInfo.setEffdt((java.util.Date)real);
                hrTimeZoneInfo.setLeffdt((java.util.Date)original.preDay());
                timeZoneUpdaterNew.addToUpdate(hrTimeZoneInfo);
            }
            original = Date.getDate(tripEntryInfo.getTripEndTime());
            real = Date.getDate(tripEntryInfo.getRealTripEndTime());
            if (startDateChanged || !original.equals(real)) {
                tripBillEntries.add(tripEntryInfo);
            }
            if (!original.before(real)) continue;
            hrTimeZoneInfo = (HRTimeZoneInfo)this.getPreTimeZone(tripEntryInfo).clone();
            hrTimeZoneInfo.setId(null);
            hrTimeZoneInfo.setEffdt((java.util.Date)original.nextDay());
            hrTimeZoneInfo.setLeffdt((java.util.Date)real);
            timeZoneUpdaterNew.addToUpdate(hrTimeZoneInfo);
        }
        boolean result = false;
        if (!AtsCollectionUtile.isEmpty(timeZoneUpdaterNew.getOriginUpdateDatas())) {
            timeZoneUpdaterNew.setCtx(this.ctx).setForceUpdateLevel(this.getTripTimeZoneLevel());
            result = timeZoneUpdaterNew.update();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)tripBillEntries)) {
            TripTimeZoneTrigger trigger = new TripTimeZoneTrigger();
            trigger.setCtx(this.ctx);
            trigger.addBillEntries((Object)tripBillEntries);
            result = trigger.triggerAuthen() || result;
        }
        return result;
    }

    private void initTripEntry() {
        if (this.tripEntryColl == null) {
            this.tripEntryColl = new AtsTripBillEntryCollection();
        }
        if (this.billEntries == null) {
            this.billEntries = new CoreBaseCollection();
        }
        this.tripEntryColl.clear();
        for (CanTripBillEntryInfo canTripBillEntryInfo : this.billEntries) {
            AtsTripBillEntryInfo tripBillEntry = (AtsTripBillEntryInfo)canTripBillEntryInfo.get("tripEntryBill");
            tripBillEntry.setRealTripStartTime(canTripBillEntryInfo.getRealStartTime());
            tripBillEntry.setRealTripEndTime(canTripBillEntryInfo.getRealEndTime());
            this.tripEntryColl.add(tripBillEntry);
        }
    }

    @Override
    protected Timestamp getStartTime(CoreBaseInfo entryInfo) {
        return entryInfo.getTimestamp("realTripStartTime");
    }

    @Override
    protected Timestamp getEndTime(CoreBaseInfo entryInfo) {
        return entryInfo.getTimestamp("realTripEndTime");
    }
}

