/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsFileBaseCollection;
import com.kingdee.eas.hr.ats.AtsFileBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.CollaborativeStateEnum;
import com.kingdee.eas.hr.ats.IAtsFileBase;
import com.kingdee.eas.hr.ats.app.AtsDocumentType;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAcrossStoreRptUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.AtsBillAssist;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsAcrossStoreBillHelper
extends BillHelper {
    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T billInfo) throws BOSException, EASBizException {
        AtsAcrossStoreBillHelper.setDefault2Bill(ctx, billInfo);
        return billInfo;
    }

    @Override
    public BigDecimal getBillLength(Context ctx, AtsAffairEntryBaseInfo entryInfo) {
        return super.getBillLength(ctx, entryInfo);
    }

    @Override
    public String deleteWithTips(Context ctx, String billId) throws EASBizException {
        return super.deleteWithTips(ctx, billId);
    }

    @Override
    public String delete(Context ctx, String billId) throws EASBizException {
        return super.delete(ctx, billId);
    }

    @Override
    protected void runDelete(Context ctx, String id) throws BOSException, EASBizException {
        super.runDelete(ctx, id);
    }

    @Override
    protected void deleteAttachment(String boId) throws EASBizException, BOSException {
        super.deleteAttachment(boId);
    }

    public String validateBill(AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        AtsAcrossStoreRptUtils atsAcrossStoreRptUtils = new AtsAcrossStoreRptUtils();
        StringBuffer msg = new StringBuffer();
        if (billInfo.isNeedCollaborator()) {
            msg.append(atsAcrossStoreRptUtils.validateSSC(this.ctx, billInfo));
        } else {
            String errorMsg = atsAcrossStoreRptUtils.validateComplete(this.ctx, billInfo);
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                return errorMsg;
            }
            msg.append(AtsAcrossStoreRptUtils.verifySupportParameter(this.ctx, billInfo));
            msg.append(atsAcrossStoreRptUtils.checkscheduIsOFFDay(this.ctx, billInfo));
            msg.append(atsAcrossStoreRptUtils.checkRepeat(this.ctx, billInfo));
        }
        return msg.toString();
    }

    public String validateBill(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        AtsAcrossStoreRptUtils atsAcrossStoreRptUtils = new AtsAcrossStoreRptUtils();
        StringBuffer msg = new StringBuffer();
        if (billInfo.isNeedCollaborator()) {
            msg.append(atsAcrossStoreRptUtils.validateSSC(ctx, billInfo));
        } else {
            String errorMsg = atsAcrossStoreRptUtils.validateComplete(ctx, billInfo);
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                return errorMsg;
            }
            msg.append(AtsAcrossStoreRptUtils.verifySupportParameter(ctx, billInfo));
            msg.append(atsAcrossStoreRptUtils.checkscheduIsOFFDay(ctx, billInfo));
            msg.append(atsAcrossStoreRptUtils.checkRepeat(ctx, billInfo));
        }
        return msg.toString();
    }

    public static CoreBaseInfo setDefault2Bill(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        if (!(model instanceof AtsAffairBaseInfo)) {
            return model;
        }
        AtsAcrossStoreSopportInfo billInfo = (AtsAcrossStoreSopportInfo)model;
        EntityObjectInfo entityObject = AtsAcrossStoreBillHelper.getSupplierObject(AtsEntityUtile.getEntityObj(ctx, model), "entries");
        if (entityObject == null || !(billInfo.get("entries") instanceof IObjectCollection)) {
            return model;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ((AtsAffairBaseInfo)model).setLastUpdateTime(now);
        ((AtsAffairBaseInfo)model).setLastUpdateUser(currentUserInfo);
        NumberCodeRule.setNumber(ctx, (CoreBaseInfo)billInfo);
        if (null == billInfo.getCollaborativeState() && billInfo.isNeedCollaborator()) {
            billInfo.setCollaborativeState(CollaborativeStateEnum.SAVED);
            billInfo.setDocumentType(AtsDocumentType.ISCollaboration);
        } else {
            billInfo.setDocumentType(AtsDocumentType.ISWorkflow);
        }
        if (!billInfo.isNeedCollaborator()) {
            billInfo.setCollaborator(null);
        }
        try {
            Class entryCls = entityObject.getObjectValueClazzRuntime();
            Timestamp curTime = AtsBillAssist.getRealBeginTime(model);
            PersonInfo personInfo = SHRBillUtil.getCurrPersonInfoNew(ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (billInfo.getProposer() == null || billInfo.getProposer().getId() == null) {
                billInfo.setProposer(personInfo);
            }
            if (billInfo.getApplyDate() == null) {
                billInfo.setApplyDate(new Timestamp(System.currentTimeMillis()));
            }
            if (billInfo.getBizDate() == null) {
                billInfo.setBizDate(billInfo.getApplyDate());
            }
            if (billInfo.getBillState() == null) {
                billInfo.setBillState(HRBillStateEnum.SAVED);
            }
            if (StringUtils.isNotBlank((CharSequence)billInfo.getString("ccPerson"))) {
                String personIds = billInfo.getString("ccPerson").replace(",", "','");
                personIds = String.format("select id,name,number where id in ('%s')", personIds);
                PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(personIds);
                billInfo.put("ccPersonIds", persons);
            }
        }
        catch (BOSException | ClassNotFoundException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, e, new Object[]{e.getMessage()});
        }
        AtsAcrossStoreRptUtils atsAcrossStoreRptUtils = new AtsAcrossStoreRptUtils();
        AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
        HashSet<String> personids = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (null == billInfo.getSpts().get(i).getPerson()) continue;
            personids.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        Map<String, AttendanceFileInfo> atsFileHisMap = AtsServerUtils.getAttendanceFileInfoByPersonId(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        Iterator entryIterator = entries.iterator();
        while (entryIterator.hasNext()) {
            AtsAcrossStoreSptEntryInfo entryInfo = (AtsAcrossStoreSptEntryInfo)entryIterator.next();
            Timestamp offWorkTime = entryInfo.getOffWorkTime();
            Timestamp onWorkTime = entryInfo.getOnWorkTime();
            entryInfo.setWorkOffTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(offWorkTime)));
            entryInfo.setWorkOnTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(onWorkTime)));
            for (int num = 0; num < spts.size(); ++num) {
                AttendanceFileInfo attendanceFileInfo;
                AtsAcrossStoreSptsInfo storeSptsInfo = spts.get(num);
                if (!StringUtils.equals((CharSequence)CoreBaseUtile.getId(storeSptsInfo.getEntryBill()), (CharSequence)CoreBaseUtile.getId(entryInfo.getId()))) continue;
                Timestamp realOnWorkTimeData = atsAcrossStoreRptUtils.getRealWorkTime(storeSptsInfo.getAttendanceDate(), entryInfo.getOnWorkDayType().getValue(), HRTimeWebUtils.timestampToString(entryInfo.getOnWorkTime()).substring(11, 16));
                HashMap<String, Timestamp> realRestTimeAndWorkTime = atsAcrossStoreRptUtils.getRealRestTimeAndWorkTime(ctx, storeSptsInfo.getAttendanceDate(), entryInfo);
                storeSptsInfo.setRestStartTime(realRestTimeAndWorkTime.get("restStartTime"));
                storeSptsInfo.setStartTime(realOnWorkTimeData);
                Timestamp realOffWorkTimeData = atsAcrossStoreRptUtils.getRealWorkTime(storeSptsInfo.getAttendanceDate(), entryInfo.getOffWorkDayType().getValue(), HRTimeWebUtils.timestampToString(entryInfo.getOffWorkTime()).substring(11, 16));
                storeSptsInfo.setRestEndTime(realRestTimeAndWorkTime.get("restEndTime"));
                storeSptsInfo.setEndTime(realOffWorkTimeData);
                if (storeSptsInfo.getPerson() == null || null == (attendanceFileInfo = atsFileHisMap.get(AtsScheduleShiftUtil.getKey(spts.get(num).getPerson().getId().toString(), AtsDateUtils.dateShortToString(spts.get(num).getAttendanceDate()))))) continue;
                storeSptsInfo.setIsDefaultManage(attendanceFileInfo.isIsDefaultManage());
            }
        }
        return model;
    }

    public static EntityObjectInfo getSupplierObject(EntityObjectInfo entityObject, String propertyName) {
        PropertyInfo entriesProperty;
        if (entityObject != null && StringUtils.isNotBlank((CharSequence)propertyName) && (entriesProperty = entityObject.getPropertyByNameRuntime(propertyName)) instanceof LinkPropertyInfo) {
            RelationshipInfo relationship = ((LinkPropertyInfo)entriesProperty).getRelationship();
            if (relationship == null) {
                return null;
            }
            EntityObjectInfo upplierObject = relationship.getSupplierObject();
            return entityObject.equals((Object)upplierObject) ? relationship.getClientObject() : upplierObject;
        }
        return null;
    }

    public static AtsFileBaseInfo getFileHisInfoByBill(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        AtsAffairEntryBaseInfo entry = AtsAcrossStoreBillHelper.getFirstBillEntry(coreBaseInfo);
        String person = AtsAcrossStoreBillHelper.getPersonId(coreBaseInfo);
        if (StringUtils.isBlank((CharSequence)person)) {
            person = CoreBaseUtile.getId(SHRBillUtil.getCurrPersonInfoNew(ctx));
        }
        AtsAcrossStoreSptsInfo atsAcrossStoreSptsInfo = (AtsAcrossStoreSptsInfo)coreBaseInfo;
        Date attenDate = Date.getNoNullDate(atsAcrossStoreSptsInfo.getAttendanceDate());
        IAtsFileBase fileBase = entry instanceof AtsLeaveBillEntryInfo || entry instanceof CancelLeaveBillEntryInfo ? AtsHolidayFileHisFactory.getLocalInstance(ctx) : AttendanceFileHISFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("proposer", (Object)person, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("effdt", (Object)attenDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("leffdt", (Object)attenDate, CompareType.GREATER_EQUALS));
        AtsFileBaseCollection collection = fileBase.getAtsFileBaseCollection(String.format("select *,position.name,adminOrgUnit.name,hrOrgUnit.name where %s", filterInfo.toString()));
        return AtsCollectionUtile.isEmpty((IObjectCollection)collection) ? null : collection.get(0);
    }

    public static AtsAffairEntryBaseInfo getFirstBillEntry(CoreBaseInfo model) {
        IObjectCollection entryColl;
        if (model instanceof AtsAffairEntryBaseInfo) {
            return (AtsAffairEntryBaseInfo)model;
        }
        Object entries = model == null ? null : model.get("entries");
        IObjectCollection iObjectCollection = entryColl = entries instanceof IObjectCollection ? (IObjectCollection)entries : null;
        if (AtsCollectionUtile.isEmpty(entryColl) || !(entryColl.getObject(0) instanceof AtsAffairEntryBaseInfo)) {
            return null;
        }
        return (AtsAffairEntryBaseInfo)entryColl.getObject(0);
    }

    public static String getPersonId(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo instanceof AtsAffairBaseInfo) {
            coreBaseInfo = AtsAcrossStoreBillHelper.getFirstBillEntry(coreBaseInfo);
        }
        return CoreBaseUtile.getId(AtsBillAssist.getPerson(coreBaseInfo));
    }
}

