/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.shr.base.permission.helper.SHRMenuServiceHelper;
import com.kingdee.shr.base.syssetting.ServiceCategoryInfo;
import com.kingdee.shr.base.syssetting.ServiceCollection;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum PlateformType implements Serializable,
Cloneable
{
    SELF("665a23a9-9069-4429-b3c3-795298d8d6aaPERMITEM", "5mGQU3WGQ+6dmhwiREYwEaYoOi4="),
    PRO("afd26284-d409-4280-9def-dc58707d938ePERMITEM", "8RztooMYQ/KzKDIof5PxUKYoOi4="),
    PRO_HOL("5c4dd8f1-3897-42f2-bb06-6eaffe60dda4PERMITEM", "BNSMehpVSpGBrUrWidtBgKYoOi4="),
    TEAM("fffffff0-ffff-efff-deb3-000000022ec3PERMITEM", "3rMAAAABnqCmKDou");

    private String permItemId;
    private String serviceId;
    private static Map<String, Map<String, PlateformType>> typesMap;

    private PlateformType(String permItemId, String serviceId) {
        this.permItemId = permItemId;
        this.serviceId = serviceId;
    }

    public static boolean isSelf(PlateformType plateformType) {
        return SELF.equals(plateformType);
    }

    public static boolean isPro(PlateformType plateformType) {
        return PRO.equals(plateformType) || PRO_HOL.equals(plateformType);
    }

    public static boolean isTeam(PlateformType plateformType) {
        return TEAM.equals(plateformType);
    }

    public static PlateformType getPlateformType(Context ctx, String serviceId, String uipk) {
        ServiceInfo serviceInfo;
        if (!StringUtils.isBlank((CharSequence)serviceId)) {
            PlateformType type;
            serviceInfo = SHRMenuServiceHelper.getServiceMenuInfoFromCache((String)serviceId);
            PermItemInfo permItem = serviceInfo == null ? null : serviceInfo.getPermission();
            PlateformType plateformType = type = permItem == null ? null : PlateformType.getPlateformType(ctx, permItem);
            if (type != null) {
                return type;
            }
        }
        ServiceCategoryInfo categoryInfo = (serviceInfo = PlateformType.getService(ctx, serviceId, uipk)) == null ? null : serviceInfo.getCategory();
        String category = categoryInfo == null ? null : categoryInfo.getString("id");
        for (PlateformType plateformType : PlateformType.values()) {
            if (!plateformType.serviceId.equals(category)) continue;
            return plateformType;
        }
        return null;
    }

    public static ServiceInfo getService(Context ctx, String serviceId, String uipk) {
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isNotBlank((CharSequence)uipk)) {
            filter.getFilterItems().add(new FilterItemInfo("urlValue", (Object)uipk, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("urlValue", (Object)MessageFormat.format("%uipk={0}%", uipk), CompareType.LIKE));
        }
        if (StringUtils.isNotBlank((CharSequence)serviceId)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)serviceId, CompareType.EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            return null;
        }
        if (filter.getFilterItems().size() > 1) {
            filter.setMaskString(filter.getFilterItems().size() == 2 ? "#0 or #1" : "#0 or #1 or #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("category.id"));
        view.setSelector(sic);
        Object serviceInfo = null;
        try {
            ServiceCollection coll = ServiceFactory.getRemoteInstance().getServiceCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i).getCategory() == null || !StringUtils.isNotBlank((CharSequence)coll.get(i).getCategory().getString("id"))) continue;
                return coll.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static PlateformType getPlateformType(Context ctx, Object permItem) {
        String longNumber;
        String string = longNumber = permItem instanceof PermItemInfo ? ((PermItemInfo)permItem).getLongNumber() : null;
        if (longNumber == null && permItem != null) {
            String permItemId = permItem instanceof PermItemInfo ? ((PermItemInfo)permItem).getString("id") : String.valueOf(permItem);
            PermItemCollection permItemInfo = PlateformType.getPermitems(ctx, Collections.singleton(permItemId));
            longNumber = permItemInfo.get(0).getLongNumber();
        }
        return PlateformType.getPlateformTypeWithNumber(ctx, longNumber);
    }

    private static PermItemCollection getPermitems(Context ctx, Set<String> ids) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.getSelector().add("longNumber");
        evi.getSelector().add("id");
        PermItemCollection coll = null;
        try {
            coll = PermItemFactory.getLocalInstance((Context)ctx).getPermItemCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlateformType getPlateformTypeWithNumber(Context ctx, String permItemLongNumber) {
        if (StringUtils.isBlank((CharSequence)permItemLongNumber)) {
            return null;
        }
        String ais = ConfigMDUtil.getAIS((Context)ctx);
        Map<String, PlateformType> typeMap = typesMap.get(ais);
        if (typeMap == null) {
            Map<String, Map<String, PlateformType>> map = typesMap;
            synchronized (map) {
                typeMap = new HashMap<String, PlateformType>(4);
                typesMap.put(ais, typeMap);
                HashMap<String, PlateformType> idMap = new HashMap<String, PlateformType>();
                for (PlateformType type : PlateformType.values()) {
                    idMap.put(type.permItemId, type);
                }
                PermItemCollection coll = PlateformType.getPermitems(ctx, idMap.keySet());
                for (int i = 0; i < coll.size(); ++i) {
                    typeMap.put(coll.get(i).getLongNumber(), (PlateformType)idMap.remove(coll.get(i).getString("id")));
                }
            }
        }
        for (String number : typeMap.keySet()) {
            if (!StringUtils.startsWith((CharSequence)permItemLongNumber, (CharSequence)number) || permItemLongNumber.charAt(number.length()) != '!') continue;
            return typeMap.get(number);
        }
        return null;
    }

    static {
        typesMap = new HashMap<String, Map<String, PlateformType>>(4);
    }
}

