/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskInfo;
import com.kingdee.eas.hr.ats.abnormal.AbnormalUtils;
import com.kingdee.eas.hr.ats.abnormal.task.AbnormalTaskSendActuator;
import com.kingdee.eas.hr.ats.abnormal.task.AbnormalTaskUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class AbnormalTaskActuator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.task.AbnormalTaskActuator");
    private boolean isChangeEventListener = false;

    public void sendTask(Context ctx) {
        try {
            boolean createSpliteDetail = AbnormalUtils.isCreateSpliteDetail(ctx);
            if (!createSpliteDetail) {
                return;
            }
            AbnormalTaskUtils.changeAbnormalIdTrue(ctx);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Date date = new Date();
            String dateLongToString = AtsDateUtils.dateLongToString(date);
            params.put("sendDateDey", dateLongToString);
            int totalCount = AbnormalTaskUtils.getAbnormalCount(ctx, dateLongToString);
            logger.error((Object)("find can send abnormal meg : " + totalCount));
            if (totalCount <= 0) {
                return;
            }
            AbnormalAttendanceTaskCollection abnormalTasks = AbnormalUtils.getAbnormalTasks(ctx);
            HashMap<String, AbnormalAttendanceTaskInfo> tasks = new HashMap<String, AbnormalAttendanceTaskInfo>();
            for (int index = 0; index < abnormalTasks.size(); ++index) {
                tasks.put(abnormalTasks.get(index).getId().toString(), abnormalTasks.get(index));
            }
            int rows = AbnormalTaskUtils.getSendAbNumEveryAb(ctx);
            if (totalCount <= rows) {
                params.put("threadKey", "single");
                AbnormalTaskSendActuator abnormalTaskSendActuator = new AbnormalTaskSendActuator(ctx, params, tasks, 0, 0);
                abnormalTaskSendActuator.run();
                AbnormalTaskUtils.changeAbnormalIdTrue(ctx);
            } else {
                params.put("threadKey", "multi");
                int maxThreadSiz = AbnormalTaskUtils.getSendAbThreadNum(ctx);
                int CPUProcessorsNum = Runtime.getRuntime().availableProcessors();
                System.out.println("The CPU count of attendance cal\uff1a" + CPUProcessorsNum);
                maxThreadSiz = maxThreadSiz < CPUProcessorsNum * 2 ? maxThreadSiz : CPUProcessorsNum * 2;
                System.out.println("The MAX thread of attendance cal\uff1a" + maxThreadSiz);
                ExecutorService fixedThreadPool = Executors.newFixedThreadPool(maxThreadSiz);
                int allPagesInt = totalCount / rows + 1;
                int startCount = 0;
                AbnormalTaskSendActuator abnormalTaskSendActuator = null;
                for (int nowPafe = 1; nowPafe <= allPagesInt; ++nowPafe) {
                    abnormalTaskSendActuator = new AbnormalTaskSendActuator(ctx, params, tasks, startCount, rows);
                    fixedThreadPool.execute(abnormalTaskSendActuator);
                    startCount += rows;
                }
                logger.error((Object)"all cal thread enabled \uff01(abnorma)");
                fixedThreadPool.shutdown();
                do {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (!fixedThreadPool.isTerminated());
                AbnormalTaskUtils.changeAbnormalIdTrue(ctx);
                logger.error((Object)"all cal thread end \uff01(abnorma)");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

