/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.AtsFileBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsFileBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsFileBillInfo;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsFilebillBizException;
import com.kingdee.eas.hr.ats.app.AbstractAtsFileBillControllerBean;
import com.kingdee.eas.hr.ats.biz.util.AtsBizUtil;
import com.kingdee.eas.hr.ats.fillControl.AtsFileBillSupplyCtrl;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsFileBillControllerBean
extends AbstractAtsFileBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsFileBillControllerBean");

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, (AtsFileBillInfo)model);
        return super._save(ctx, model);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.beforeSave(ctx, (AtsFileBillInfo)model);
        return super.submit(ctx, model);
    }

    protected void beforeSave(Context ctx, AtsFileBillInfo billInfo) throws EASBizException {
        AtsFileBillEntryCollection entries = billInfo.getEntries();
        String sql = "select fattendanceNum from T_HR_ATS_AttendanceFileHIS where  fattendanceNum=? and fproposerid <> ? ";
        for (int i = 0; i < entries.size(); ++i) {
            AtsFileBillEntryInfo entryInfo = entries.get(i);
            if (!StringUtils.isNotBlank((String)entryInfo.getEFattendanceNum())) continue;
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{entryInfo.getEFattendanceNum(), entryInfo.getPerson().getString("id")});
                if (!rowSet.next()) continue;
                String msg = MLUtile.getRes(AtsFileResEnum.RepeatAttNum, ctx) + entryInfo.getPerson().getName() + ":" + entryInfo.getEFattendanceNum();
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
            }
            catch (BOSException e) {
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void beforSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        super.beforSubmitEffect(ctx, model);
        this.beforeSave(ctx, (AtsFileBillInfo)model);
        model.put("billState", (Object)HRBillStateEnum.AUDITED);
    }

    @Override
    protected void onBillAudied(Context ctx, Object model) throws EASBizException, BOSException {
        if (!(model instanceof CoreBaseInfo)) {
            model = this.getValue(ctx, (IObjectPK)new ObjectUuidPK(String.valueOf(model)));
        }
        if (model instanceof AtsFileBillInfo) {
            AtsBizUtil.changeAttendanceFileByAtsFileBillEntryInfo(ctx, (AtsFileBillInfo)model);
        }
    }

    @Override
    protected void onBillSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        model.put("billState", (Object)HRBillStateEnum.SUBMITED);
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, model);
        if (StringUtils.isNotBlank((String)model.getString("id"))) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getString("id")));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)0, CompareType.GREATER));
            if (iCoreBase.exists(filter)) {
                throw new AtsFilebillBizException(AtsFilebillBizException.HASSUBMIT);
            }
        }
        AtsFileBillInfo billInfo = (AtsFileBillInfo)model;
        AtsFileBillSupplyCtrl supplyCtrl = new AtsFileBillSupplyCtrl(ctx);
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            billInfo.getEntries().get(i).setBill(billInfo);
            supplyCtrl.setAtsFileBillentryInfo(billInfo.getEntries().get(i)).isInControlWithExep();
        }
    }
}

