/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsNeedReBilll;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.app.AbstractAtsOverTimeBillControllerBean;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsBillEntryHandlerUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsOverTimeUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsOverTimeBillControllerBean
extends AbstractAtsOverTimeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsOverTimeBillControllerBean");

    @Override
    protected void _setPassState_atsoverTime(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.updateLastUpdateMessageInEntry(ctx, billId);
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
    }

    @Override
    protected Map _importAtsOverTimeBillData(Context ctx, List list, boolean isOverImport, int errorHandleMode) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            AtsOverTimeBillInfo atsOverTimeBillInfo = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _overtimeBillTriggerCal(Context ctx, String beginTime, String endTime, String billId, String personId, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "overTimeBillTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("personId", personId);
        param.put("beginTime", beginTime);
        param.put("endTime", endTime);
        param.put("hrOrgUnitId", hrOrgUnitId);
        OSFAppUtil osfUtil = new OSFAppUtil();
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    @Override
    protected void _reOverTimeBillEntry(Context ctx, int dayBefore) throws BOSException {
        logger.error((Object)("_reTripBillEntry begin = " + dayBefore));
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from T_HR_ATS_OverTimeBill bill ").append(" left OUTER JOIN T_HR_ATS_OverTimeBillEntry entry on bill.fid=entry.FBillID ").append(" where bill.FBillState IN ('3') ");
        if (dayBefore != 0) {
            String DateBefore = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(new Date(), dayBefore));
            sql.append("  AND entry.FStartTime >= {TS '").append(DateBefore).append(" 00:00:00").append("'}");
        }
        sql.append(" and ( ").append(" exists (").append(this.getScheduleShiftSql()).append(") ").append(" or ").append(" exists (").append(this.getScheduleShiftLogSql()).append(")").append(" or entry.FNeedReBill ='" + AtsNeedReBilll.yes.getValue() + "' ").append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Map<String, Object> res = null;
        AtsOverTimeBillInfo info = null;
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            while (row.next()) {
                try {
                    this.reCall(ctx, info, res, row.getString("id"), tempList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.error((Object)"_reTripBillEntry end");
    }

    protected String getScheduleShiftLogSql() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > entry.FLastUpdateTime  and dateAdd(day, -1, entry.fStartTime) <= log.fAttendDate  and entry.fEndTime >= log.fAttendDate";
    }

    protected String getScheduleShiftSql() {
        return "select 1  from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > entry.FLastUpdateTime and dateAdd(day,-1, entry.fStartTime) <= C.fAttendDate  and entry.fEndTime >= C.fAttendDate ";
    }

    private void reCall(Context ctx, AtsOverTimeBillInfo info, Map<String, Object> res, String id, List<String> tempList) throws BOSException, EASBizException {
        logger.error((Object)("_reTripBillEntry reCall entry.id" + id));
        Boolean NotneedRemoveDuplicate = true;
        ObjectUuidPK pk = new ObjectUuidPK(id);
        AtsOverTimeBillEntryInfo entryInfo = AtsOverTimeBillEntryFactory.getLocalInstance(ctx).getAtsOverTimeBillEntryInfo((IObjectPK)pk);
        if (null == entryInfo) {
            return;
        }
        info = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(entryInfo.getBill().getId().toString()));
        if (null == info) {
            return;
        }
        this.updateBillAndEntryInfo(ctx, info, entryInfo);
        if (tempList.contains(info.getId().toString())) {
            NotneedRemoveDuplicate = false;
        }
        if (NotneedRemoveDuplicate.booleanValue()) {
            Map<String, String> map = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)info, OperTypeEnum.otBill);
            if (AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, map.get("beginTime"), map.get("endTime"), map.get("personId")).booleanValue()) {
                AttendCalculateJob backJob = new AttendCalculateJob();
                String billNumber = info.getNumber();
                String personId = entryInfo.getPerson().getId().toString();
                String beginTime = AtsDateUtils.dateLongToString(entryInfo.getOtDate());
                String endTime = AtsDateUtils.dateLongToString(entryInfo.getOtDate());
                backJob.createOverTimeBillTriggerAttendCalJob(ctx, beginTime, endTime, info.getId().toString(), personId, billNumber);
            }
            tempList.add(info.getId().toString());
        }
    }

    private void updateBillAndEntryInfo(Context ctx, AtsOverTimeBillInfo info, AtsOverTimeBillEntryInfo entryInfo) throws BOSException, EASBizException {
        this.updateBillEntryInfo(ctx, entryInfo);
    }

    private void updateBillInfo(Context ctx, AtsOverTimeBillInfo info) throws BOSException {
        String updateSql = "update t_hr_ats_OverTimeBill set FLastUpdateTime = ? where fid = ? ";
        Object[] params = new Object[]{new Timestamp(System.currentTimeMillis()), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
    }

    private void updateBillEntryInfo(Context ctx, AtsOverTimeBillEntryInfo entryInfo) throws BOSException, EASBizException {
        AtsOverTimeBillEntryInfo billEntryInfo = new AtsOverTimeBillEntryInfo();
        String personId = entryInfo.getPerson().getId().toString();
        String otDate = AtsDateUtils.dateShortToString(entryInfo.getOtDate());
        billEntryInfo.setId(entryInfo.getId());
        OverTimeTypeInfo otType = entryInfo.getOtType();
        if (AtsOverTimeBillControllerBean.isDefoultOtType(otType)) {
            billEntryInfo.setOtType(this.getOverTimeTypeObject(ctx, personId, otDate));
        }
        billEntryInfo.setReasonForRecalculate(this.getReasonForRecalculate(ctx, entryInfo.getReasonForRecalculate()));
        billEntryInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billEntryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        billEntryInfo.setNeedReBill(AtsNeedReBilll.no);
        AtsOverTimeBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), billEntryInfo);
    }

    private String getReasonForRecalculate(Context ctx, String preReasonForRecalculate) {
        preReasonForRecalculate = null == preReasonForRecalculate || "null".equalsIgnoreCase(preReasonForRecalculate) ? "" : preReasonForRecalculate;
        String res = MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ModifyShift, ctx, AtsDateUtils.dateLongToString(new Date())) + ";" + preReasonForRecalculate;
        return res.length() > 200 ? res.substring(0, res.substring(0, res.length() - 1).indexOf(";") + 1) : res;
    }

    public static boolean isDefoultOtType(OverTimeTypeInfo otType) {
        if (otType == null || otType.getId() == null) {
            return false;
        }
        String id = otType.getId().toString();
        if (id.equalsIgnoreCase("zr+ur5D4RA+2bdVZ2VPqp46C/nU=")) {
            return true;
        }
        if (id.equalsIgnoreCase("sRWUOt7sRpOY0TCo6NMqGY6C/nU=")) {
            return true;
        }
        return id.equalsIgnoreCase("rBy0u1YgQ9C1OxcM85mxyY6C/nU=");
    }

    private OverTimeTypeInfo getOverTimeTypeObject(Context ctx, String personId, String otDate) {
        OverTimeTypeInfo overTimeType = new OverTimeTypeInfo();
        if (personId == null || "".equals(personId) || otDate == null || "".equals(otDate)) {
            return overTimeType;
        }
        try {
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, otDate);
            if (null != scheduleShiftInfo) {
                DayTypeEnum dayTypeEnum = scheduleShiftInfo.getDayType();
                if (dayTypeEnum == DayTypeEnum.restDay) {
                    overTimeType.setId(BOSUuid.read((String)"zr+ur5D4RA+2bdVZ2VPqp46C/nU="));
                    overTimeType.setName(MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnHoliday, ctx));
                } else if (dayTypeEnum == DayTypeEnum.legalHoliday) {
                    overTimeType.setId(BOSUuid.read((String)"sRWUOt7sRpOY0TCo6NMqGY6C/nU="));
                    overTimeType.setName(MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnLegalHoliday, ctx));
                } else {
                    overTimeType.setId(BOSUuid.read((String)"rBy0u1YgQ9C1OxcM85mxyY6C/nU="));
                    overTimeType.setName(MLUtile.getRes(AtsOverTimeBillResEnum.OTOnWorkday, ctx));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return overTimeType;
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateLastUpdateMessageInEntry(ctx, billID);
        super._setAudited(ctx, billID);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.updateLastUpdateMessageInEntry(ctx, billId);
        super._setNoPassState(ctx, billId);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        super._setState(ctx, billId, state);
        this.updateLastUpdateMessageInEntry(ctx, billId);
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        this.updateLastUpdateMessageInEntry(ctx, BOSUuid.read((String)billId));
    }

    private void updateLastUpdateMessageInEntry(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        AtsOverTimeBillEntryCollection atsOverTimeBillEntryCollection = AtsOverTimeBillEntryFactory.getLocalInstance(ctx).getAtsOverTimeBillEntryCollection("where bill.id = '" + billID.toString() + "'");
        if (atsOverTimeBillEntryCollection.size() > 0) {
            AtsOverTimeBillEntryInfo atsOverTimeBillEntryInfo = null;
            for (int i = 0; i < atsOverTimeBillEntryCollection.size(); ++i) {
                atsOverTimeBillEntryInfo = atsOverTimeBillEntryCollection.get(i);
                atsOverTimeBillEntryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                atsOverTimeBillEntryInfo.setLastUpdateTime(AtsDateUtils.dateToTimestamp(new Date()));
                if (atsOverTimeBillEntryInfo.getId() != null && AtsOverTimeUtils.isNeedReCalBill(ctx, atsOverTimeBillEntryInfo.getId().toString())) {
                    atsOverTimeBillEntryInfo.setNeedReBill(AtsNeedReBilll.yes);
                }
                AtsOverTimeBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(atsOverTimeBillEntryInfo.getId()), atsOverTimeBillEntryInfo);
            }
        }
    }
}

