/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsNeedReBilll;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.TripbillCancelEnum;
import com.kingdee.eas.hr.ats.app.AbstractAtsTripBillControllerBean;
import com.kingdee.eas.hr.ats.atsTrip.CanTripBillControllerBeanUtils;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsBillEntryHandlerUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.IntersectUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsTripBillControllerBean
extends AbstractAtsTripBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsTripBillControllerBean");
    private static final String effectBillStates = AtsCollectionUtile.joinForSql(Arrays.asList(HRBillStateEnum.SUBMITED.getValue(), HRBillStateEnum.AUDITING.getValue(), HRBillStateEnum.AUDITED.getValue()));

    @Override
    protected void _setPassState_atsTrip(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
    }

    private Set<String> getNeedRecallBilEntryIds(Context ctx, String billId) throws BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return new HashSet<String>();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from T_HR_ATS_TripBill bill ").append(" left OUTER JOIN T_HR_ATS_TripBillEntry entry on bill.fid=entry.FBillID ").append(" where bill.fId = '").append(billId).append("' ");
        sql.append(" and ( ").append(" exists (").append(this.getScheduleShiftSqlByCreateTime()).append(") ").append(" or ").append(" exists (").append(this.getScheduleShiftLogSqlByCreateTime()).append(")").append(")");
        HashSet<String> entryIds = new HashSet<String>();
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                entryIds.add(row.getString("id"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entryIds;
    }

    protected String getScheduleShiftLogSqlByCreateTime() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > bill.FCreateTime  and dateAdd(day, -1, entry.fTripStartTime) <= log.fAttendDate  and entry.fTripEndTime >= log.fAttendDate";
    }

    protected String getScheduleShiftSqlByCreateTime() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > bill.FCreateTime   and dateAdd(day,-1, entry.fTripStartTime) <= C.FATTENDDATE  and entry.fTripEndTime >= C.FATTENDDATE ";
    }

    @Override
    protected void beforSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        super.beforSubmitEffect(ctx, model);
        IntersectUtile.isIntersectWithTrip(ctx, (AtsTripBillInfo)model);
        AtsTripBillInfo info = (AtsTripBillInfo)model;
        if (null == info.getId()) {
            return;
        }
        Set<String> entryIds = this.getNeedRecallBilEntryIds(ctx, info.getId().toString());
        AtsTripBillEntryCollection entries = info.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AtsTripBillEntryInfo entryInfo = entries.get(i);
            if (null == entryInfo.getId() || !entryIds.contains(entryInfo.getId().toString())) continue;
            entryInfo.setIsRecallBill(AtsNeedReBilll.yes);
        }
    }

    @Override
    protected void beforeSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        AtsTripBillEntryCollection tripItems;
        super.beforeSubmit(ctx, model);
        IntersectUtile.isIntersectWithTrip(ctx, (AtsTripBillInfo)model);
        AtsTripBillEntryCollection atsTripBillEntryCollection = tripItems = model == null ? null : ((AtsTripBillInfo)model).getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)tripItems)) {
            return;
        }
        int i = tripItems.size();
        while (i-- > 0) {
            AtsTripBillEntryInfo item = tripItems.get(i);
            item.setIsCancelTrip(TripbillCancelEnum.notconfirm);
        }
    }

    @Override
    protected Map _importAtsTripBillData(Context ctx, List list, boolean isOverImport, int errorHandleMode) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        AtsTripBillEntryInfo atsTripBillEntry;
        int i;
        super._setState(ctx, billId, state);
        AtsTripBillEntryCollection atsTripBillEntryCollection = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryCollection("where bill.id = '" + billId.toString() + "'");
        if (atsTripBillEntryCollection.size() <= 0) {
            return;
        }
        if (state.getValue() == 3) {
            Set<String> entryIds = this.getNeedRecallBilEntryIds(ctx, billId.toString());
            for (i = 0; i < atsTripBillEntryCollection.size(); ++i) {
                atsTripBillEntry = atsTripBillEntryCollection.get(i);
                atsTripBillEntry.setIsCancelTrip(TripbillCancelEnum.notconfirm);
                if (null == atsTripBillEntry.getId() || !entryIds.contains(atsTripBillEntry.getId().toString())) continue;
                atsTripBillEntry.setIsRecallBill(AtsNeedReBilll.yes);
            }
        }
        CoreBaseCollection newLimit = new CoreBaseCollection();
        for (i = 0; i < atsTripBillEntryCollection.size(); ++i) {
            atsTripBillEntry = atsTripBillEntryCollection.get(i);
            atsTripBillEntry.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            atsTripBillEntry.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            newLimit.add((CoreBaseInfo)atsTripBillEntry);
        }
        DataSaver dataSaver = new DataSaver();
        dataSaver.setCtx(ctx).save(newLimit);
    }

    @Override
    protected void _calculateTripBillEntry(Context ctx, AtsTripBillEntryInfo info, Map map) throws BOSException, EASBizException {
        super._calculateTripBillEntry(ctx, info, map);
        HashMap<String, Boolean> isCallACJobMap = new HashMap<String, Boolean>();
        this.reCall(ctx, null, map, info.getId().toString(), isCallACJobMap);
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            AtsTripBillInfo atsTripBillInfo = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _tripBillTriggerCal(Context ctx, String beginTime, String endTime, String billId, String personId, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "tripBillTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("personId", personId);
        param.put("beginTime", beginTime);
        param.put("endTime", endTime);
        param.put("hrOrgUnitId", hrOrgUnitId);
        OSFAppUtil osfUtil = new OSFAppUtil();
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    @Override
    protected void _reTripBillEntry(Context ctx, int dayBefore) throws BOSException {
        logger.error((Object)("_reTripBillEntry begin = " + dayBefore));
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from T_HR_ATS_TripBill bill ").append(" left OUTER JOIN T_HR_ATS_TripBillEntry entry on bill.fid=entry.FBillID ").append(" where bill.FBillState IN (").append(effectBillStates).append(") ");
        if (dayBefore != 0) {
            String DateBefore = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(new Date(), dayBefore));
            sql.append(" AND entry.FTripStartTime >= {TS '").append(DateBefore).append(" 00:00:00'}");
        }
        sql.append(" and ( ").append(" entry.FIsRecallBill = '").append(AtsNeedReBilll.yes.getValue()).append("' ").append(" or ").append(" exists (").append(this.getScheduleShiftSql()).append(") ").append(" or ").append(" exists (").append(this.getScheduleShiftLogSql()).append(")").append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Boolean> isCallACJobMap = new HashMap<String, Boolean>();
        try {
            while (row.next()) {
                try {
                    this.reCall(ctx, null, null, row.getString("id"), isCallACJobMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.error((Object)"_reTripBillEntry end");
    }

    protected String getScheduleShiftLogSql() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > bill.FLastUpdateTime  and dateAdd(day, -1, entry.fTripStartTime) <= log.fAttendDate  and entry.fTripEndTime >= log.fAttendDate";
    }

    protected String getScheduleShiftSql() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > bill.FLastUpdateTime   and dateAdd(day,-1, entry.fTripStartTime) <= C.FATTENDDATE  and entry.fTripEndTime >= C.FATTENDDATE ";
    }

    private void reCall(Context ctx, AtsTripBillInfo info, Map<String, Object> res, String id, Map<String, Boolean> tempMap) throws BOSException, EASBizException {
        logger.error((Object)("_reTripBillEntry reCall entry.id" + id));
        AtsTripBillEntryInfo entryInfo = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryInfo("select *, bill.* where id = '" + id + "'");
        if (null == entryInfo || null == (info = entryInfo.getBill())) {
            return;
        }
        info = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo((IObjectPK)new ObjectUuidPK(entryInfo.getBill().getId().toString()));
        this.updateBillAndEntryInfo(ctx, info, entryInfo);
        if (null == tempMap || null == tempMap.get(entryInfo.getBill().getId().toString())) {
            Map<String, String> map = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)info, OperTypeEnum.tripBill);
            Boolean isCallACJob = AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, map.get("beginTime"), map.get("endTime"), map.get("personId"));
            if (null != tempMap) {
                tempMap.put(entryInfo.getBill().getId().toString(), isCallACJob);
            }
            if (isCallACJob.booleanValue()) {
                this.triggerCalculate(ctx, info, entryInfo);
            }
        } else if (tempMap.get(entryInfo.getBill().getId().toString()).booleanValue()) {
            this.triggerCalculate(ctx, info, entryInfo);
        }
    }

    private void triggerCalculate(Context ctx, AtsTripBillInfo info, AtsTripBillEntryInfo entryInfo) throws BOSException {
        AttendCalculateJob backJob = new AttendCalculateJob();
        String billId = info.getId().toString();
        String billNumber = info.getNumber();
        String beginTime = AtsDateUtils.timestampToString(entryInfo.getTripStartTime());
        String endTime = AtsDateUtils.timestampToString(entryInfo.getTripEndTime());
        String personId = entryInfo.getPerson().getId().toString();
        backJob.createTripBillTriggerAttendCalJob(ctx, beginTime, endTime, billId, personId, billNumber);
    }

    private void updateBillAndEntryInfo(Context ctx, AtsTripBillInfo info, AtsTripBillEntryInfo entryInfo) throws BOSException, EASBizException {
        this.updateBillEntryInfo(ctx, entryInfo);
    }

    private void updateBillInfo(Context ctx, AtsTripBillInfo info) throws BOSException {
        String nowDatetime = AtsDateUtils.dateLongToString(new Date());
        String updateSql = "update t_hr_ats_tripBill set FLastUpdateTime={ts '" + nowDatetime + "'} where fid ='" + info.getId() + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void updateBillEntryInfo(Context ctx, AtsTripBillEntryInfo entryInfo) throws BOSException, EASBizException {
        String personId = entryInfo.getPerson().getId().toString();
        if (entryInfo.isIsAllDay()) {
            this.setEntryBeginAndEndTime(ctx, entryInfo, personId);
        }
        BigDecimal realLength = new BillHelper().getBillLength(ctx, entryInfo);
        AtsTripBillEntryInfo billEntryInfo = new AtsTripBillEntryInfo();
        billEntryInfo.setId(entryInfo.getId());
        billEntryInfo.setTripStartTime(entryInfo.getTripStartTime());
        billEntryInfo.setStartTimeDate(entryInfo.getStartTimeDate());
        billEntryInfo.setStartTimeDateType(entryInfo.getStartTimeDateType());
        billEntryInfo.setStartTimeHMS(entryInfo.getStartTimeHMS());
        billEntryInfo.setRealTripStartTime(entryInfo.getRealTripStartTime());
        billEntryInfo.setTripEndTime(entryInfo.getTripEndTime());
        billEntryInfo.setEndTimeDate(entryInfo.getEndTimeDate());
        billEntryInfo.setEndTimeDateType(entryInfo.getEndTimeDateType());
        billEntryInfo.setEndTimeHMS(entryInfo.getEndTimeHMS());
        billEntryInfo.setRealTripEndTime(entryInfo.getRealTripEndTime());
        billEntryInfo.setRealTripDays(realLength);
        billEntryInfo.setTripDays(realLength);
        billEntryInfo.setReasonForRecalculate(this.getReasonForRecalculate(ctx, entryInfo.getReasonForRecalculate()));
        billEntryInfo.setIsRecallBill(AtsNeedReBilll.no);
        billEntryInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billEntryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        CanTripBillControllerBeanUtils.updateBillAndEntryInfo(ctx, billEntryInfo, personId);
        AtsTripBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), billEntryInfo);
    }

    private String getReasonForRecalculate(Context ctx, String preReasonForRecalculate) {
        preReasonForRecalculate = null == preReasonForRecalculate || "null".equals(preReasonForRecalculate) ? "" : preReasonForRecalculate;
        String res = MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ModifyShift, ctx, AtsDateUtils.dateLongToString(new Date())) + ";" + preReasonForRecalculate;
        return res.length() > 200 ? res.substring(0, res.substring(0, res.length() - 1).indexOf(";") + 1) : res;
    }

    private void setEntryBeginAndEndTime(Context ctx, AtsTripBillEntryInfo entryInfo, String personId) {
        String endTime;
        String beginTime = AtsDateUtils.timestampToShortString(this.getRealAttendDate(entryInfo.getTripStartTime(), entryInfo.getStartTimeDateType()));
        Map<String, ScheduleShiftInfo> scheduleShiftForPerson = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personId, beginTime, endTime = AtsDateUtils.timestampToShortString(this.getRealAttendDate(entryInfo.getTripEndTime(), entryInfo.getEndTimeDateType())));
        if (null == scheduleShiftForPerson) {
            return;
        }
        String pTime = AtsScheduleShiftUtil.getKey(personId, beginTime);
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, beginTime));
        }
        this.setBeginTime(personId, entryInfo, beginTime, scheduleShiftForPerson);
        pTime = AtsScheduleShiftUtil.getKey(personId, endTime);
        scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, endTime));
        }
        this.setEndTime(personId, entryInfo, endTime, scheduleShiftForPerson);
    }

    private void setEndTime(String personId, AtsTripBillEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(scheduleShiftInfo.getItems().size() - 1);
        billEntryInfo.setEndTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getNextDateTime())));
        billEntryInfo.setEndTimeDateType(itemInfo.getNextTimeDayType());
        billEntryInfo.setEndTimeHMS(itemInfo.getNextDateTime());
        billEntryInfo.setTripEndTime(itemInfo.getNextDateTime());
        billEntryInfo.setRealTripEndTime(itemInfo.getNextDateTime());
    }

    private void setBeginTime(String personId, AtsTripBillEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(0);
        billEntryInfo.setStartTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getPreDateTime())));
        billEntryInfo.setStartTimeDateType(itemInfo.getPreTimeDayType());
        billEntryInfo.setStartTimeHMS(itemInfo.getPreDateTime());
        billEntryInfo.setTripStartTime(itemInfo.getPreDateTime());
        billEntryInfo.setRealTripStartTime(itemInfo.getPreDateTime());
    }

    private Timestamp getRealAttendDate(Timestamp time, SegmentUnitEnum dateType) {
        if (null == time) {
            return time;
        }
        Timestamp ret = new Timestamp(time.getTime());
        if (SegmentUnitEnum.nextDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getPreDay(time).getTime());
        } else if (SegmentUnitEnum.preDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getNextDay(time).getTime());
        }
        return ret;
    }
}

