/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.app.AbstractAttendanceFileControllerBean;
import com.kingdee.eas.hr.ats.entryhelper.AtsShiftHelper;
import com.kingdee.eas.hr.ats.entryhelper.AttendPolicyHelper;
import com.kingdee.eas.hr.ats.entryhelper.AttendanceFileHelper;
import com.kingdee.eas.hr.ats.entryhelper.CommonHelper;
import com.kingdee.eas.hr.ats.entryhelper.HolidayPolicySetHelper;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AttendanceFileControllerBean
extends AbstractAttendanceFileControllerBean {
    private static final int LIMIT_SIZE = 2000;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AttendanceFileControllerBean");

    @Override
    protected void _setAttendFileState(Context ctx, Set idSet, int state) throws BOSException {
        if (state == Integer.valueOf("2")) {
            String sql = "UPDATE T_HR_ATS_AttendanceFile SET FAttendFileState= '" + state + "' ,FLASTUPDATETIME = ? WHERE FID=?";
            Map<String, java.util.Date> personEffDt = this.getLeaveEmpOrgRelationRowSet(ctx, idSet);
            ArrayList<Object[]> params = new ArrayList<Object[]>(personEffDt.size());
            for (Map.Entry<String, java.util.Date> dateEntry : personEffDt.entrySet()) {
                params.add(new Object[]{new Date(dateEntry.getValue().getTime()), dateEntry.getKey()});
            }
            DbUtil.executeBatch((Context)ctx, (String)sql, params);
            return;
        }
        String sql = "UPDATE T_HR_ATS_AttendanceFile SET FAttendFileState = '" + state + "' ,FLASTUPDATETIME = ?  WHERE FID in ( " + AtsUtil.convertSetToString(idSet) + " )";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            java.util.Date nowDate = new java.util.Date();
            Timestamp nowTimestamp = new Timestamp(nowDate.getTime());
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, nowTimestamp);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private Map<String, java.util.Date> getLeaveEmpOrgRelationRowSet(Context ctx, Set<String> billIds) {
        StringBuffer sql = new StringBuffer();
        java.util.Date curDate = AtsCommonUtile.getDayStart(null);
        sql.append(" select emp.FEFFDT leffdt,atfile.fid id");
        sql.append(" from T_HR_EmpOrgRelation emp ");
        sql.append(" left join T_HR_EmpLaborRelation eml on emp.FlaborRelationID = eml.FID ");
        sql.append(" left join T_HR_EmpLaborRelationHis emlHis on eml.FID = emlHis.FHistoryRelateID ");
        sql.append(" left join T_HR_BDEmployeeType emt on emlHis.FLaborRelationStateID = emt.FID ");
        sql.append(" inner join T_HR_ATS_AttendanceFile atfile on atfile.FProposerid = emp.FPersonId ");
        sql.append(" where emp.FIsInner='1' and emt.fisInCount='0' and atfile.FAttendFileState='1' ");
        sql.append(" and emlHis.FEFFDT <= emp.FEFFDT ");
        sql.append(" and emlHis.FLEFFDT >= emp.FLEFFDT ");
        sql.append(" and emlHis.FLEFFDT >= emp.FLEFFDT ");
        sql.append(" and emp.FEFFDT <= {TS '" + AtsDateUtils.dateShortToString(curDate) + " 00:00:00'} ");
        sql.append(" and emp.FLEFFDT >= {TS '" + AtsDateUtils.dateShortToString(curDate) + " 00:00:00'} ");
        sql.append(" and atfile.fid in (" + AtsUtil.convertSetToString(billIds) + ")");
        sql.append(" order by emp.FEFFDT,emp.FLEFFDT ");
        IRowSet row = null;
        HashMap<String, java.util.Date> returnData = new HashMap<String, java.util.Date>();
        for (String bill : billIds) {
            returnData.put(bill, curDate);
        }
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                returnData.put(row.getString("id"), row.getDate("leffdt") == null ? curDate : row.getDate("leffdt"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return returnData;
    }

    @Override
    protected Map<String, AttendanceFileInfo> _getPersonByAttendanceNum(Context ctx, Set attendanceNumSet) throws BOSException, EASBizException {
        HashMap<String, AttendanceFileInfo> map = new HashMap<String, AttendanceFileInfo>();
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("attendanceNum,proposer.id,adminOrgUnit.id,adminOrgUnit.name,hrOrgUnit.id,hrOrgUnit.name,attAdminOrgUnit.id,attAdminOrgUnit.name ");
        oqlb.append(" where attendanceNum in ( ");
        oqlb.append(AtsUtil.convertSetToString(attendanceNumSet));
        oqlb.append(")");
        AttendanceFileCollection coll = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(oqlb.toString());
        for (int i = 0; i < coll.size(); ++i) {
            map.put(coll.get(i).getAttendanceNum(), coll.get(i));
        }
        return map;
    }

    @Override
    protected void _matchPunchCardRecord(Context ctx, String attendanceNum, String startDate, String endDate) throws BOSException, EASBizException {
        HashSet<String> attendanceNumSet = new HashSet<String>();
        attendanceNumSet.add(attendanceNum);
        this._matchPunchCardRecord(ctx, attendanceNumSet, startDate, endDate);
    }

    @Override
    protected void _matchPunchCardRecord(Context ctx, Set attendanceNumSet, String startDate, String endDate) throws BOSException, EASBizException {
        Map<String, AttendanceFileInfo> map = this._getPersonByAttendanceNum(ctx, attendanceNumSet);
        Iterator<String> itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String num = itr.next().toString();
            AttendanceFileInfo attendanceFileInfo = map.get(num);
            this.match(ctx, attendanceFileInfo, startDate, endDate);
            this.updateSignRecord(ctx, attendanceFileInfo, startDate, endDate);
        }
    }

    private void match(Context ctx, AttendanceFileInfo attendanceFileInfo, String startDate, String endDate) throws BOSException {
        ArrayList<Object> parmas = new ArrayList<Object>();
        parmas.add(attendanceFileInfo.getProposer().getId().toString());
        parmas.add(attendanceFileInfo.getAdminOrgUnit().getId().toString());
        parmas.add(attendanceFileInfo.getHrOrgUnit().getId().toString());
        parmas.add(com.kingdee.eas.hr.ats.vo.common.Date.getTimeInst());
        String attAdminId = attendanceFileInfo.getAttAdminOrgUnit() != null ? attendanceFileInfo.getAttAdminOrgUnit().getString("id") : null;
        StringBuffer sb = new StringBuffer();
        sb.append(" UPDATE T_HR_ATS_PunchCardRecord SET FProposerID=?,FAdminOrgunitID=?,FHrOrgUnitID=?,FLASTUPDATETIME=?");
        if (!StringUtils.isEmpty((String)attAdminId)) {
            sb.append(",FAttAdminOrgunitID=?");
            parmas.add(attAdminId);
        }
        sb.append(" where ((FProposerID is null and FAttendanceNum=?)");
        sb.append(" or((FAdminOrgunitID is null or FHrOrgUnitID is null) and FProposerID=?))");
        sb.append(" and FPunchCardDate>=? and FPunchCardDate<=?");
        parmas.add(attendanceFileInfo.getAttendanceNum());
        parmas.add(attendanceFileInfo.getProposer().getId().toString());
        parmas.add(com.kingdee.eas.hr.ats.vo.common.Date.getTime(startDate));
        parmas.add(com.kingdee.eas.hr.ats.vo.common.Date.getTime(endDate));
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])parmas.toArray());
    }

    private void updateSignRecord(Context ctx, AttendanceFileInfo attendanceFileInfo, String startDate, String endDate) throws BOSException {
        ArrayList<Object> parmas = new ArrayList<Object>();
        parmas.add(attendanceFileInfo.getAdminOrgUnit().getId().toString());
        parmas.add(attendanceFileInfo.getHrOrgUnit().getId().toString());
        String attAdminId = attendanceFileInfo.getAttAdminOrgUnit() != null ? attendanceFileInfo.getAttAdminOrgUnit().getString("id") : null;
        StringBuffer sb = new StringBuffer();
        sb.append(" UPDATE T_HR_SignRecord SET FAdminOrgID=?,FHrOrgUnitID=?");
        if (!StringUtils.isEmpty((String)attAdminId)) {
            sb.append(",FAttAdminOrgUnitID=?");
            parmas.add(attAdminId);
        }
        sb.append(" where (FAdminOrgID is null or FHrOrgUnitID is null)");
        sb.append(" and FPersonID=? and FSignDate>=? and FSignDate<=?");
        parmas.add(attendanceFileInfo.getProposer().getId().toString());
        parmas.add(com.kingdee.eas.hr.ats.vo.common.Date.getTime(startDate));
        parmas.add(com.kingdee.eas.hr.ats.vo.common.Date.getTime(endDate));
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])parmas.toArray());
    }

    @Override
    protected void _autoCreateFile(Context ctx) throws BOSException, EASBizException {
        IRowSet rowSet = this.getRowSet(ctx);
        if (rowSet == null) {
            logger.info((Object)"auto crate file,fetch person error");
        } else if (rowSet.size() == 0) {
            logger.info((Object)"auto create file ,not found the person who entry company just now ");
        } else {
            List<Map> shiftMapList = this.getDefaultShiftMapList(rowSet.size());
            List<Map> holidayPolicyMapList = this.getDefaultShiftMapList(rowSet.size());
            List<Map> attendPolicyMapList = this.getDefaultShiftMapList(rowSet.size());
            this.setMapListValue(rowSet, shiftMapList, holidayPolicyMapList, attendPolicyMapList, ctx);
            this.createFile(rowSet, shiftMapList, holidayPolicyMapList, attendPolicyMapList, ctx);
            rowSet = null;
        }
    }

    private List<Map> getDefaultShiftMapList(int size) {
        int page = size / 2000 + 1;
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (int i = 0; i < page; ++i) {
            mapList.add(new HashMap());
        }
        return mapList;
    }

    private IRowSet getRowSet(Context ctx) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select person.fid as id,adminOrgUnit.flongNumber as longNum,empPosOrgRelation.feffdt as flowIn,person.fnumber as personNum   ").append(" FROM T_BD_Person person ").append(" left join T_HR_BDEmployeeType employeeType ").append(" on person.FEmployeeTypeID = employeeType.fid ").append("  left join T_HR_PersonPosition pp ").append("  on person.fid = pp.FPersonID ").append(" left join T_HR_EmpOrgRelation empPosOrgRelation ").append("  on person.FId = empPosOrgRelation.FPersonID ").append("  left join T_HR_ATS_AttendanceFile attendanceFile ").append("  on person.fid = attendanceFile.fproposerId ").append(" left join T_ORG_Admin adminOrgUnit ").append("  on empPosOrgRelation.FAdminOrgID = adminOrgUnit.fid ").append(" WHERE attendanceFile.FAttendFileState is null ").append("  and empPosOrgRelation.feffdt <= ? ").append("  AND empPosOrgRelation.fleffdt > ? ").append(" AND pp.feffdt <= ? ").append(" AND pp.fleffdt >  ? ").append(" AND empPosOrgRelation.fassignType = 1").append("  and employeeType.fisInCount = 1 ");
        java.util.Date currentDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(new java.util.Date()));
        Date sqlDate = new Date(currentDate.getTime());
        Object[] params = new Object[]{sqlDate, sqlDate, sqlDate, sqlDate};
        IRowSet rowset = null;
        try {
            rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rowset;
    }

    private void setMapListValue(IRowSet rowSet, List shiftMapList, List holidayMapList, List attendMapList, Context ctx) {
        String longNumber = "";
        try {
            int count = 0;
            Map map = null;
            if (rowSet.size() > 0) {
                Map<String, Object> allDefaultAtsShiftMap = AtsShiftHelper.getDefaultShiftByLongNumber(ctx);
                Map<String, Object> allDefaultHolidayPolicyMap = HolidayPolicySetHelper.getDefaultholidayPolicySetByLongNumber(ctx);
                Map<String, Object> allDefaultAttencePolicyMap = AttendPolicyHelper.getDefaultAttendPolicyByLongNumBer(ctx);
                while (rowSet.next()) {
                    ++count;
                    longNumber = rowSet.getString("longNum");
                    boolean breakFlag = false;
                    for (int i = 0; i < shiftMapList.size(); ++i) {
                        Map tempMap = (Map)shiftMapList.get(i);
                        if (!tempMap.containsKey(longNumber)) continue;
                        breakFlag = true;
                        break;
                    }
                    if (breakFlag) continue;
                    AtsShiftInfo atsShiftInfo = (AtsShiftInfo)CommonHelper.getDefaultData(longNumber, allDefaultAtsShiftMap);
                    map = (Map)shiftMapList.get(count / 2000);
                    map.put(longNumber, atsShiftInfo);
                    HolidayPolicySetInfo holidayPolicy = (HolidayPolicySetInfo)CommonHelper.getDefaultData(longNumber, allDefaultHolidayPolicyMap);
                    map = (Map)holidayMapList.get(count / 2000);
                    map.put(longNumber, holidayPolicy);
                    AttencePolicyInfo attencePolicy = (AttencePolicyInfo)CommonHelper.getDefaultData(longNumber, allDefaultAttencePolicyMap);
                    map = (Map)attendMapList.get(count / 2000);
                    map.put(longNumber, attencePolicy);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createFile(IRowSet rowset, List shiftMapList, List holidayMapList, List attendMapList, Context ctx) {
        try {
            PersonPositionInfo ppInfo = null;
            AttendanceFileHelper fileHelper = new AttendanceFileHelper();
            IAttendanceFile iAttendaceFile = AttendanceFileFactory.getLocalInstance(ctx);
            AttendanceFileInfo fileInfo = null;
            int count = 0;
            CoreBaseCollection colls = new CoreBaseCollection();
            CoreBaseCollection collsForHis = new CoreBaseCollection();
            String longNumber = "";
            AtsShiftInfo atsShiftInfo = null;
            AttencePolicyInfo attencePolicyInfo = null;
            HolidayPolicySetInfo holidayPolicySetInfo = null;
            rowset.beforeFirst();
            while (rowset.next()) {
                String value;
                ++count;
                String personId = rowset.getString("id");
                ppInfo = CommonHelper.getAdminOrgUnitAndHrOrgUnit(personId, ctx);
                EmpLaborRelationInfo laborInfo = SHRBillUtil.getEmpLaborRelationInfo(personId, ctx);
                longNumber = rowset.getString("longNum");
                atsShiftInfo = (AtsShiftInfo)this.getEntryInfoByNum(longNumber, shiftMapList);
                attencePolicyInfo = (AttencePolicyInfo)this.getEntryInfoByNum(longNumber, attendMapList);
                holidayPolicySetInfo = (HolidayPolicySetInfo)this.getEntryInfoByNum(longNumber, holidayMapList);
                fileInfo = fileHelper.setAttendanceFileValue(ppInfo, atsShiftInfo, attencePolicyInfo, holidayPolicySetInfo);
                PersonInfo personInfo = fileInfo.getProposer();
                personInfo.setNumber(rowset.getString("personNum"));
                fileInfo.setProposer(personInfo);
                Object num = null;
                fileInfo = this.storefields(ctx, (CoreBaseInfo)fileInfo);
                this.attendanceFileDateDeal(fileInfo, ppInfo, laborInfo);
                if (fileInfo != null && org.apache.commons.lang.StringUtils.isNotBlank((String)(value = AtsServerUtils.isExistAttendanceFile(ctx, fileInfo.getAttendanceNum())))) continue;
                colls.add((CoreBaseInfo)fileInfo);
                collsForHis.add((CoreBaseInfo)fileInfo);
                if (count != 2000) continue;
                this.saveFileEntry(iAttendaceFile, colls);
                this.updateAttendanceFileHis(ctx, collsForHis);
                count = 0;
            }
            if (count > 0) {
                this.saveFileEntry(iAttendaceFile, colls);
                this.updateAttendanceFileHis(ctx, collsForHis);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void saveFileEntry(IAttendanceFile iAttendaceFile, CoreBaseCollection colls) {
        try {
            iAttendaceFile.addnew(colls);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        colls.clear();
    }

    private Object getEntryInfoByNum(String longNum, List<Map> listObject) {
        Object object = null;
        Map map = null;
        for (int i = 0; i < listObject.size() && (object = (map = listObject.get(i)).get(longNum)) == null; ++i) {
        }
        return object;
    }

    private AttendanceFileInfo storefields(Context ctx, CoreBaseInfo model) {
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)model;
        CtrlUnitInfo CU = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String appOUID = null;
            if (attendanceFileInfo.getCU() != null) {
                appOUID = attendanceFileInfo.getCU().getId().toString();
            } else {
                ObjectUuidPK pk;
                ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
                if (null != rootCU) {
                    appOUID = rootCU.getId().toString();
                }
            }
            if (iCodingRuleManager.isExist((IObjectValue)attendanceFileInfo, appOUID)) {
                if (attendanceFileInfo.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    attendanceFileInfo.setCU(CU);
                }
                String newRuleNo = iCodingRuleManager.getNumber((IObjectValue)attendanceFileInfo, appOUID);
                attendanceFileInfo.setAttendanceNum(newRuleNo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return attendanceFileInfo;
    }

    public void attendanceFileDateDeal(AttendanceFileInfo attendanceFileInfo, PersonPositionInfo ppInfo, EmpLaborRelationInfo laborInfo) {
        java.util.Date enterDate = null;
        if (laborInfo != null) {
            enterDate = laborInfo.getEnterDate();
        }
        java.util.Date joinDate = ppInfo.getJoinDate();
        java.util.Date joinGroupDate = ppInfo.getJoinGroupDate();
        java.util.Date curDate = new java.util.Date();
        boolean done = false;
        if (enterDate != null && enterDate.getTime() <= curDate.getTime()) {
            attendanceFileInfo.setEFFDT(enterDate);
            done = true;
        }
        if (joinDate != null && joinDate.getTime() <= curDate.getTime() && !done) {
            attendanceFileInfo.setEFFDT(joinDate);
            done = true;
        }
        if (joinGroupDate != null && joinGroupDate.getTime() <= curDate.getTime() && !done) {
            attendanceFileInfo.setEFFDT(joinGroupDate);
            done = true;
        }
        if (!done) {
            attendanceFileInfo.setEFFDT(AtsDateUtils.stringToShortDate("1900-01-01"));
        }
        attendanceFileInfo.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
    }

    public void updateAttendanceFileHis(Context ctx, CoreBaseCollection coll) {
        try {
            CoreBaseCollection hisColl = new CoreBaseCollection();
            int len = coll.size();
            for (int i = 0; i < len; ++i) {
                AttendanceFileHISInfo hisInfo = new AttendanceFileHISInfo();
                AttendanceFileInfo info = (AttendanceFileInfo)coll.get(i);
                if (info.getAttendanceNum() != null) {
                    hisInfo.setAttendanceNum(info.getAttendanceNum());
                }
                if (info.getIsAttendance() != null) {
                    hisInfo.setIsAttendance(info.getIsAttendance());
                }
                if (info.getAttendFileState() != null) {
                    hisInfo.setAttendFileState(info.getAttendFileState());
                }
                if (info.getRemark() != null) {
                    hisInfo.setRemark(info.getRemark());
                }
                if (info.getAttendCenter() != null) {
                    hisInfo.setAttendCenter(info.getAttendCenter());
                }
                if (info.getAttencePolicy() != null) {
                    hisInfo.setAttencePolicy(info.getAttencePolicy());
                }
                if (info.getHolidayPolicySet() != null) {
                    hisInfo.setHolidayPolicySet(info.getHolidayPolicySet());
                }
                if (info.getAtsShift() != null) {
                    hisInfo.setAtsShift(info.getAtsShift());
                }
                if (info.getIsAutoShift() != null) {
                    hisInfo.setIsAutoShift(info.getIsAutoShift());
                }
                if (info.getProposer() != null) {
                    hisInfo.setProposer(info.getProposer());
                }
                if (info.getHrOrgUnit() != null) {
                    hisInfo.setHrOrgUnit(info.getHrOrgUnit());
                }
                if (info.getPosition() != null) {
                    hisInfo.setPosition(info.getPosition());
                }
                if (info.getAdminOrgUnit() != null) {
                    hisInfo.setAdminOrgUnit(info.getAdminOrgUnit());
                }
                if (info.getEFFDT() != null) {
                    hisInfo.setEFFDT(info.getEFFDT());
                }
                if (info.getLEFFDT() != null) {
                    hisInfo.setLEFFDT(info.getLEFFDT());
                }
                hisInfo.setFileType(info.getFileType());
                hisColl.add((CoreBaseInfo)hisInfo);
            }
            if (hisColl.size() > 0) {
                AttendanceFileHISFactory.getLocalInstance(ctx).save(hisColl);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

