/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryFactory;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.FillSignCardType;
import com.kingdee.eas.hr.ats.IFillSignCard;
import com.kingdee.eas.hr.ats.IPunchCardRecord;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.PunchCardStateEnum;
import com.kingdee.eas.hr.ats.app.AbstractFillSignCardControllerBean;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsWaitCalUtil;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FillSignCardControllerBean
extends AbstractFillSignCardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.FillSignCardControllerBean");
    private IHRBillBizBean bizBean = null;

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    @Override
    protected void _setPassStateFillSignCard(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
        logger.info((Object)("---billId-----:" + billId));
        IFillSignCard fillSignCard = FillSignCardFactory.getLocalInstance(ctx);
        FillSignCardInfo fillSignCardInfo = fillSignCard.getFillSignCardInfo((IObjectPK)new ObjectUuidPK(billId));
        FillSignCardEntryCollection entryCollection = fillSignCardInfo.getEntries();
        UserInfo userInfo = this.getUserInfo(ctx);
        if (entryCollection != null && entryCollection.size() > 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < entryCollection.size(); ++i) {
                FillSignCardEntryInfo entryInfo = entryCollection.get(i);
                PunchCardRecordInfo pcrInfo = new PunchCardRecordInfo();
                if (entryInfo.getPerson() != null) {
                    String personId = entryInfo.getPerson().getId().toString();
                    pcrInfo.setProposer(entryInfo.getPerson());
                    AttendanceFileHISInfo attendanceFileInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(ctx, entryInfo.getAttendDate(), personId);
                    if (attendanceFileInfo != null) {
                        pcrInfo.setAttendanceNum(attendanceFileInfo.getAttendanceNum());
                        pcrInfo.setAttAdminOrgUnit(attendanceFileInfo.getAttAdminOrgUnit());
                    }
                }
                pcrInfo.setAdminOrgUnit(entryInfo.getAdminOrgUnit());
                pcrInfo.setPunchCardDate(entryInfo.getAttendDate());
                pcrInfo.setPunchCardTime(entryInfo.getFillCardTime());
                pcrInfo.setHrOrgUnit(fillSignCardInfo.getHrOrgUnit());
                pcrInfo.setPunchCardState(PunchCardStateEnum.normal);
                if (entryInfo.getType() == null) {
                    entryInfo.setType(FillSignCardType.fillCard);
                }
                pcrInfo.setPunchCardSource(PunchCardSourceEnum.fillCard);
                pcrInfo.setPunchCardPlace(entryInfo.getType().getAlias());
                if (pcrInfo.getCreator() == null) {
                    pcrInfo.setCreator(userInfo);
                }
                if (pcrInfo.getLastUpdateUser() == null) {
                    pcrInfo.setLastUpdateUser(userInfo);
                }
                Timestamp createtime = new Timestamp(System.currentTimeMillis());
                pcrInfo.setCreateTime(createtime);
                pcrInfo.setLastUpdateTime(createtime);
                colls.add((CoreBaseInfo)pcrInfo);
            }
            IPunchCardRecord punchCardRecord = PunchCardRecordFactory.getLocalInstance(ctx);
            punchCardRecord.saveBatchData(colls);
        }
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._submitEffect(ctx, model);
        this._setPassStateFillSignCard(ctx, model.getId());
        return objectPK;
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        this.initBizBean(ctx);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                if (plugIn != null && billExtend != null) {
                    decorators = new IReflectMethod[]{plugIn, billExtend};
                } else if (billExtend != null) {
                    decorators = new IReflectMethod[]{billExtend};
                } else if (plugIn != null) {
                    decorators = new IReflectMethod[]{plugIn};
                }
                if (decorators != null) {
                    try {
                        this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                    }
                    catch (Throwable e) {
                        throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                    }
                }
            }
        }
    }

    @Override
    protected Map _importFillSignCardData(Context ctx, List list, boolean isOverImport, int errorHandleMode) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
    }

    @Override
    protected void _fillsignBillTriggerCal(Context ctx, String attendDateBuf, String billId, String personId, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "fillSignCardTrigerCalculateOSF";
        FillSignCardInfo fillInfo = FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo(" where id='" + billId + "'");
        String fillId = fillInfo.getId().toString();
        FillSignCardEntryCollection fillColl = FillSignCardEntryFactory.getLocalInstance(ctx).getFillSignCardEntryCollection(" where bill='" + fillId + "' order by attendDate asc ");
        ArrayList<String> attendList = new ArrayList<String>();
        HashMap<String, String> attendMap = new HashMap<String, String>();
        int size = fillColl.size();
        for (int i = 0; i < size; ++i) {
            String personIdFormBill = fillColl.get(i).getPerson().getId().toString();
            String attDate = fillColl.get(i).getAttendDate().toString();
            Timestamp fillCardTime = fillColl.get(i).getFillCardTime();
            String date = AtsWaitCalUtil.requireRealityAttDate(ctx, fillCardTime, attDate, personIdFormBill);
            if (!StringUtils.isNotEmpty((CharSequence)date)) continue;
            attendList.add(date);
            attendMap.put(String.valueOf(i), date);
        }
        if (attendList.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("billId", billId);
            param.put("personId", personId);
            param.put("attendDateList", attendList);
            param.put("attendDateMap", attendMap);
            param.put("hrOrgUnitId", hrOrgUnitId);
            OSFAppUtil osfUtil = new OSFAppUtil();
            Object object = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
        }
    }
}

