/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.ruleFormula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.hr.ats.AtsCalSumBizException;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFormulaBizException;
import com.kingdee.eas.hr.ats.AtsLogicCommonResEnum;
import com.kingdee.eas.hr.ats.app.formula.ResultCalculatorMgr;
import com.kingdee.eas.hr.ats.app.ruleFormula.HolidayLimitCalFunMgr;
import com.kingdee.eas.hr.ats.app.ruleFormula.HolidayLimitCalFunction;
import com.kingdee.eas.hr.ats.app.ruleFormula.IHolidayLimitCalculator;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.formula.data.ColumnAttributes;
import com.kingdee.shr.compensation.app.formula.data.DAFactory;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSet;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.app.formula.data.DataTypes;
import com.kingdee.shr.compensation.app.formula.data.SQLGenerate;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class HolidayLimitCalculator
extends Thread
implements IHolidayLimitCalculator {
    private int precision = 2;
    private final String mainTableItemKey = "fid";
    private final String mainTableForeignKey = "FProposerID";
    private String mainTableName = "T_HR_ATS_AttendanceFile";
    private String ifTableName = "";
    private final String uid = CommonMethod.getRandomGUID();
    private Context ctx;
    private IRowSet result;
    private String schemeID;
    private String tempTable;
    private String condition;
    private String calFormulas;
    private String calculateStatus;
    private String calFromDate;
    private String calToDate;
    private String month;
    private int status = 0;
    private int finishedPer = 0;
    long estimateTime = 120000L;

    public Map<String, String> combineTableItems(IRowSet da) throws Exception {
        if (this.finishedPer < 5) {
            this.finishedPer = 5;
        }
        HashMap<String, String> assTable = new HashMap<String, String>();
        String[] item = null;
        String[] items = null;
        String clm = null;
        String listItems = null;
        while (da.next()) {
            listItems = da.getString("FListItem");
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                if (item[1].startsWith("TEMP")) continue;
                if (assTable.containsKey(item[1])) {
                    String columns = (String)assTable.get(item[1]) + ",";
                    if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                    columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                    assTable.put(item[1], columns);
                    continue;
                }
                assTable.put(item[1], item[1] + "." + item[2]);
            }
        }
        if (assTable.keySet().isEmpty()) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.NOCALDATAPRO)));
        }
        return assTable;
    }

    public void destroyed() {
        if (this.getTempTable() != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.getTempTable());
        }
    }

    void estimateTime(int recordCount) {
        this.estimateTime = recordCount < 100 ? 120000L : (recordCount < 500 ? 180000L : (recordCount < 1000 ? 300000L : (recordCount < 5000 ? 600000L : (recordCount < 10000 ? 1200000L : 2400000L))));
    }

    public List<Integer> execCalculate(CalSchemeInfo calScheme, HolidayLimitCalFunction calObj, DataSet dataSet, Set secColSet) throws Exception {
        if (this.finishedPer < 20) {
            this.finishedPer = 20;
        }
        this.estimateTime(dataSet.getTables(this.mainTableName).rowCount());
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        StringBuffer rowFilter = new StringBuffer();
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<Integer> changeIndex = new ArrayList<Integer>();
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setCalScheme(calScheme);
        calObj.setMainTableRowFilter(this.condition);
        String caltableid = null;
        Object personid = null;
        for (int index = 0; index < mainTable.rowCount(); ++index) {
            ColumnAttributes att;
            int loop;
            rowFilter.setLength(0);
            paras.clear();
            DataRow rw = mainTable.getRows(index);
            for (loop = 0; loop < rw.columnCount(); ++loop) {
                att = rw.getColumns(loop);
                if (att.getName().equalsIgnoreCase("fid")) {
                    rowFilter.append("fid");
                    rowFilter.append("='");
                    rowFilter.append(rw.getValue(loop));
                    rowFilter.append("'");
                }
                if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                    BigDecimal val = SecretUtil.decode((Context)this.ctx, (BigDecimal)((BigDecimal)rw.getValue(loop)), (String)rw.getString("FProposerID"));
                    paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), val);
                    rw.setValue(loop, (Object)val);
                    continue;
                }
                paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), rw.getValue(loop));
            }
            for (loop = 0; loop < dataSet.tableCount(); ++loop) {
                DataRow data;
                DataTable tb = dataSet.getTables(loop);
                if (this.mainTableName.equals(tb.tablename) || (data = tb.getDataRow(caltableid)) == null) continue;
                for (int i = 0; i < data.columnCount(); ++i) {
                    att = data.getColumns(i);
                    Object value = data.getValue(i);
                    if ("FGENDER".equals(att.getName().toUpperCase()) && value != null) {
                        if (value instanceof BigDecimal) {
                            value = ((BigDecimal)value).intValue();
                        }
                        value = !StringUtils.isEmpty((String)String.valueOf(value)) && "1".equalsIgnoreCase(String.valueOf(value)) ? MLUtile.getRes(AtsLogicCommonResEnum.Male, this.ctx) : MLUtile.getRes(AtsLogicCommonResEnum.Female, this.ctx);
                    }
                    paras.put((tb.tablename + "_" + att.getName()).toUpperCase(), value);
                }
            }
            try {
                calObj.setParamMap(paras);
                calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)calObj, paras);
            }
            catch (Exception e) {
                throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILECAL, new Object[]{paras, e.getMessage()})));
            }
            if (!this.hasChanged(rw, paras)) continue;
            changeIndex.add(index);
        }
        return changeIndex;
    }

    public Double execAtsCalculate(HolidayLimitCalFunction calObj, DataSet dataSet, Set secColSet, String personId) throws Exception {
        ColumnAttributes att;
        int loop;
        if (this.ifTableName == null || this.ifTableName.equals("")) {
            this.ifTableName = "T_HR_ATS_HolidayLimit";
        }
        DataTable mainTable = dataSet.getTables(this.ifTableName);
        StringBuffer rowFilter = new StringBuffer();
        HashMap<String, Object> paras = new HashMap<String, Object>();
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setMainTableRowFilter(this.condition);
        String caltableid = null;
        String personid = null;
        rowFilter.setLength(0);
        paras.clear();
        DataRow rw = mainTable.getRows(0);
        for (loop = 0; loop < rw.columnCount(); ++loop) {
            att = rw.getColumns(loop);
            if (att.getName().equalsIgnoreCase("fid")) {
                rowFilter.append("fid");
                rowFilter.append("='");
                rowFilter.append(rw.getValue(loop));
                rowFilter.append("'");
            }
            if (att.getName().equalsIgnoreCase("fid")) {
                caltableid = (String)rw.getValue(loop);
            }
            if (att.getName().equalsIgnoreCase("FProposerID")) {
                personid = (String)rw.getValue(loop);
            }
            if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                BigDecimal val = SecretUtil.decode((Context)this.ctx, (BigDecimal)((BigDecimal)rw.getValue(loop)), (String)rw.getString("FProposerID"));
                paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), val);
                rw.setValue(loop, (Object)val);
                continue;
            }
            paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), rw.getValue(loop));
        }
        for (loop = 0; loop < dataSet.tableCount(); ++loop) {
            DataRow data;
            if (caltableid == null) continue;
            DataTable tb = dataSet.getTables(loop);
            if ("T_HR_ATS_HolidayLimit".equals(tb.tablename) || (data = tb.getDataRow(caltableid)) == null) continue;
            for (int i = 0; i < data.columnCount(); ++i) {
                att = data.getColumns(i);
                Object value = data.getValue(i);
                if ("FGENDER".equals(att.getName().toUpperCase()) && value != null) {
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).intValue();
                    }
                    value = !StringUtils.isEmpty((String)String.valueOf(value)) && "1".equalsIgnoreCase(String.valueOf(value)) ? MLUtile.getRes(AtsLogicCommonResEnum.Male, this.ctx) : MLUtile.getRes(AtsLogicCommonResEnum.Female, this.ctx);
                }
                paras.put((tb.tablename + "_" + att.getName()).toUpperCase(), value);
            }
        }
        try {
            PersonPositionInfo personPositionInfo = PersonPositionFactory.getLocalInstance((Context)this.ctx).getPersonPositionInfo(" select joinDate where person= '" + personId + "'");
            PersonOtherInfoInfo othrtInfo = SHRBillUtil.getPersonOtherInfo(personId, this.ctx);
            if (othrtInfo != null && othrtInfo.getJobStartDate() != null) {
                paras.put("workDate", othrtInfo.getJobStartDate());
            } else {
                paras.put("workDate", null);
            }
            paras.put("joinCompanyDate", personPositionInfo.getJoinDate() == null ? null : new Date(personPositionInfo.getJoinDate().getTime()));
            paras.put("T_HR_ATS_HOLIDAYLIMIT_FSTANDARDLIMIT", 0.0);
            calObj.setParamMap(paras);
            calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)calObj, paras);
            Double standardLimit = (Double)paras.get("T_HR_ATS_HOLIDAYLIMIT_FSTANDARDLIMIT");
            return standardLimit;
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILECAL, new Object[]{paras, e.getMessage()})));
        }
    }

    public int getFinishedPer() {
        if (this.finishedPer >= 99) {
            this.finishedPer = 99;
        }
        return this.finishedPer;
    }

    public IRowSet getResult() {
        return this.result;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    private boolean hasChanged(DataRow rw, Map paras) {
        boolean changed = false;
        ColumnAttributes att = null;
        Object originValue = null;
        for (int index = 0; index < rw.columnCount(); ++index) {
            try {
                att = rw.getColumns(index);
                originValue = rw.getValue(index);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String paraName = (this.mainTableName + "_" + att.getName()).toUpperCase();
            Object calValue = paras.get(paraName);
            if (originValue == null && calValue == null || originValue instanceof Number && originValue != null && calValue != null && ((Number)originValue).doubleValue() == ((Number)calValue).doubleValue() || originValue instanceof String && originValue != null && originValue.equals(calValue)) continue;
            changed = true;
            try {
                if (calValue instanceof Number) {
                    rw.setValue(index, (Object)new BigDecimal(calValue.toString()));
                    continue;
                }
                rw.setValue(index, calValue);
                continue;
            }
            catch (Exception e) {
                changed = false;
            }
        }
        return changed;
    }

    public DataSet initCalData(IRowSet da, Map<String, String> assTable) throws Exception {
        DataSet dataSet = new DataSet();
        Iterator<String> iter = assTable.keySet().iterator();
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        String sq = null;
        DataTable dt = null;
        while (iter.hasNext()) {
            String tableName = iter.next();
            String columns = assTable.get(tableName);
            if (tableName.equals("T_HR_ATS_HolidayLimit")) {
                sq = this.combineInfosetSql("T_HR_ATS_HolidayLimit", tableName, columns, " 1 = 1 ");
            } else {
                if (columns.indexOf("T_HR_ATS_AttendanceFile.fid") == -1) {
                    columns = "(T_HR_ATS_AttendanceFile.fid), T_HR_ATS_AttendanceFile.FProposerID, " + columns;
                }
                sq = this.combineInfosetSql("T_HR_ATS_AttendanceFile", tableName, columns, this.condition);
            }
            try {
                if (!tableName.equals("T_HR_ATS_HolidayLimit")) {
                    this.ifTableName = tableName;
                }
                if ((dt = DAC.getDataTable(sq, tableName)) == null) continue;
                dataSet.addTable(dt);
            }
            catch (Exception e) {
                throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.PREPAREDATAERRORANDCHECK, new Object[]{sq, e.getMessage()})));
            }
        }
        assTable.clear();
        da.beforeFirst();
        String listItems = null;
        String[] item = null;
        String[] items = null;
        StringBuffer sb = new StringBuffer();
        while (da.next()) {
            listItems = da.getString("FListTable");
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                String id = "'" + item[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            StringBuffer tableName = new StringBuffer();
            for (int index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (sb.toString().toUpperCase().indexOf("WHERE") == -1) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                tableName.delete(0, tableName.length());
                int i = sb.toString().toUpperCase().indexOf("FROM ") + 5;
                while (sb.charAt(i) != ' ' && sb.charAt(i) != '\r' && sb.charAt(i) != '\t') {
                    tableName.append(sb.charAt(i));
                    ++i;
                }
                sb.insert(sb.toString().toUpperCase().indexOf("WHERE") + 6, " (" + this.condition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    DataTable dt1 = DAC.getDataTable(sq, rows[index].getString("FDefine"));
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.TEMPTABLEERRORWITHSQL, new Object[]{sq, e.getMessage()})));
                }
            }
        }
        return dataSet;
    }

    public String combineInfosetSql(String mainTable, String tableName, String fieldStr, String whereStr) throws BOSException {
        String oql = "select structure.EntityName,structure.parent.*,structure.parent.parent.*,structure.parent.parent.parent.*,structure.parent.parent.parent.parent.*,structure.parent.parent.parent.parent.parent.*,structure.filterColumn.* where tableName = '" + tableName + "'";
        CmpQueryConfigCollection configs = CmpQueryConfigFactory.getLocalInstance((Context)this.ctx).getCmpQueryConfigCollection(oql);
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldStr + " from " + mainTable);
        this.combineRecurseSql(mainTable, configs.size() == 0 ? null : configs.get(0).getStructure(), sql);
        whereStr = whereStr == null ? " 1 = 1 " : whereStr;
        sql.append(" where " + whereStr);
        return sql.toString();
    }

    private void combineRecurseSql(String mainTable, StructureConfigInfo config, StringBuffer sql) throws BOSException {
        if (config == null) {
            return;
        }
        if (config.getParent() != null) {
            this.combineRecurseSql(mainTable, config.getParent(), sql);
        }
        String oql = "where parent1.id = '" + config.getId().toString() + "'";
        StructureConfigFilterColumnCollection filters = StructureConfigFilterColumnFactory.getLocalInstance((Context)this.ctx).getStructureConfigFilterColumnCollection(oql);
        String entityName = null;
        String parentEntityName = null;
        String tableName = null;
        String parentTableName = null;
        entityName = config.getEntityName();
        tableName = this.getEntityTableName(entityName);
        if (config.getParent() != null) {
            parentEntityName = config.getParent().getEntityName();
            parentTableName = this.getEntityTableName(parentEntityName);
        }
        if (filters != null && filters.size() > 0) {
            sql.append(" left join " + tableName + " on ");
            for (int i = 0; i < filters.size(); ++i) {
                if (i != 0) {
                    sql.append(" and ");
                }
                sql.append(tableName + "." + this.getEntityFieldName(entityName, filters.get(i).getClientColumn()));
                sql.append(" = ");
                if (StringUtils.isEmpty((String)parentTableName)) {
                    sql.append(mainTable + ".FProposerID");
                    continue;
                }
                sql.append(parentTableName + "." + this.getEntityFieldName(parentEntityName, filters.get(i).getParentColumn()));
            }
        }
    }

    private String getEntityTableName(String entityName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return entityInfo.getTable().getName();
    }

    private String getEntityFieldName(String entityName, String fieldName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        PropertyInfo propertyInfo = null;
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size && !fieldName.equals((propertyInfo = collection.get(i)).getName()); ++i) {
        }
        if (propertyInfo == null) {
            return null;
        }
        if ("name".equals(propertyInfo.getName())) {
            return "FName" + MLUtile.getMlFlag(this.ctx);
        }
        if ("description".equals(propertyInfo.getName())) {
            return "FDescription" + MLUtile.getMlFlag(this.ctx);
        }
        return propertyInfo.getMappingField().getName();
    }

    public HolidayLimitCalFunction initCalInstance(Context ctx, IRowSet da) {
        HolidayLimitCalFunction calObj = null;
        try {
            calObj = HolidayLimitCalFunMgr.getInstance(ctx, da);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (calObj == null) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.SETERROR)));
        }
        return calObj;
    }

    public Set initSecureCol() throws Exception {
        String sql = "select id, fieldSn, dataType where state = 1";
        CmpItemCollection cmpItemColl = CmpItemFactory.getLocalInstance((Context)this.ctx).getCmpItemCollection(sql);
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cmpItemColl.size(); ++i) {
            cmpItemInfo = cmpItemColl.get(i);
            dataType = cmpItemInfo.getDataType();
            if (CmpItemDataType.NUMBER.getValue() != dataType.getValue()) continue;
            set.add("S" + cmpItemInfo.getFieldSn());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal parentRun(Context ctx, String holidayRuleId, String personId) {
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        String info = MLUtile.getRes(AtsCommonResEnum.ComputeAndSaveDateSucc, ctx);
        Double returnVal = 0.0;
        try {
            IRowSet da = this.getSchemeFormulas(holidayRuleId);
            Map<String, String> assTable = this.combineTableItems(da);
            HolidayLimitCalFunction calObj = this.initCalInstance(ctx, da);
            DataSet dataSet = this.initCalData(da, assTable);
            HashSet secColSet = new HashSet();
            returnVal = this.execAtsCalculate(calObj, dataSet, secColSet, personId);
        }
        catch (Exception e) {
            info = e.getMessage();
        }
        finally {
            this.destroyed();
            ResultCalculatorMgr.removeTask(this.getUID(), info);
        }
        return new BigDecimal(returnVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal testRun(Context ctx, String calFormulaid, String personId) {
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        String info = MLUtile.getRes(AtsCommonResEnum.ComputeAndSaveDateSucc, ctx);
        Double returnVal = 0.0;
        try {
            IRowSet da = this.getSchemeFormulasById(calFormulaid);
            Map<String, String> assTable = this.combineTableItems(da);
            HolidayLimitCalFunction calObj = this.initCalInstance(ctx, da);
            DataSet dataSet = this.initCalData(da, assTable);
            HashSet secColSet = new HashSet();
            returnVal = this.execAtsCalculate(calObj, dataSet, secColSet, personId);
        }
        catch (Exception e) {
            info = e.getMessage();
        }
        finally {
            this.destroyed();
            ResultCalculatorMgr.removeTask(this.getUID(), info);
        }
        return new BigDecimal(returnVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String info = MLUtile.getRes(AtsCommonResEnum.ComputeAndSaveDateSucc, this.ctx);
        try {
            try {
                CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance((Context)this.ctx).getCalSchemeInfo("select * where id = '" + this.schemeID + "'");
                if (calScheme == null || calScheme.getBeginDate() == null || calScheme.getEndDate() == null || calScheme.getPeriodYear() == 0 || calScheme.getPeriodMonth() == 0 || calScheme.getCalTime() == 0) {
                    throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.LEAKTIMECALINFO)));
                }
                IRowSet da = this.searchSchemeFormulas();
                Map<String, String> assTable = this.combineTableItems(da);
                HolidayLimitCalFunction calObj = this.initCalInstance(this.ctx, da);
                DataSet dataSet = this.initCalData(da, assTable);
                Set secColSet = this.initSecureCol();
                List<Integer> changeIndex = this.execCalculate(calScheme, calObj, dataSet, secColSet);
                this.saveCalResult(changeIndex, dataSet, secColSet);
                this.finishedPer = 99;
                throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.SUCCESSANDSAVE)));
            }
            catch (Exception e) {
                info = e.getMessage();
                this.destroyed();
                ResultCalculatorMgr.removeTask(this.getUID(), info);
            }
        }
        catch (Throwable throwable) {
            this.destroyed();
            ResultCalculatorMgr.removeTask(this.getUID(), info);
            throw throwable;
        }
    }

    public void saveCalResult(List<Integer> changeIndex, DataSet dataSet, Set secColSet) throws Exception {
        if (changeIndex.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.SUCCESSCALNOCHANGE)));
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        for (int index = 0; index < changeIndex.size(); ++index) {
            int i = changeIndex.get(index);
            DataRow rw = mainTable.getRows(i);
            sb.delete(0, sb.length());
            sb.append("UPDATE ");
            sb.append(this.mainTableName);
            sb.append(" SET ");
            if (this.calculateStatus != null && !"".equals(this.calculateStatus)) {
                sb.append(this.calculateStatus);
                sb.append(",");
            }
            for (int loop = 0; loop < rw.columnCount(); ++loop) {
                ColumnAttributes att = rw.getColumns(loop);
                if (att.getType() == DataTypes.FLOAT || att.getType() == DataTypes.INTEGER) {
                    sb.append(att.getName());
                    sb.append("=");
                    BigDecimal value = (BigDecimal)rw.getValue(loop);
                    if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                        sb.append(SecretUtil.encode((Context)this.ctx, (BigDecimal)value, (String)rw.getString("FProposerID")).toPlainString());
                    } else if (rw.getValue(loop) == null) {
                        sb.append(new BigDecimal(0));
                    } else {
                        sb.append(value);
                    }
                    sb.append(",");
                    continue;
                }
                if (att.getType() != DataTypes.STRING) continue;
                sb.append(att.getName());
                sb.append("='");
                sb.append(rw.getValue(loop) == null ? "" : rw.getValue(loop));
                sb.append("',");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(" WHERE ");
            sb.append(this.mainTableName);
            sb.append(".");
            sb.append("fid");
            sb.append("='");
            sb.append(rw.getString("fid"));
            sb.append("'");
            if (this.condition != null) {
                sb.append(" AND ");
                sb.append(this.condition);
            }
            sqls.add(sb.toString());
        }
        try {
            DataAccess DAC = DAFactory.getDataAccess();
            DAC.executeBatch(sqls);
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILSAVE, new Object[]{e.getMessage()})));
        }
    }

    public void saveAtsCalResult(List<Integer> changeIndex, DataSet dataSet, Set secColSet) throws Exception {
        if (changeIndex.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.SUCCESSCALNOCHANGE)));
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        for (int index = 0; index < changeIndex.size(); ++index) {
            int i = changeIndex.get(index);
            DataRow rw = mainTable.getRows(i);
            sb.delete(0, sb.length());
            sb.append("UPDATE ");
            sb.append(this.mainTableName);
            sb.append(" SET ");
            if (this.calculateStatus != null && !"".equals(this.calculateStatus)) {
                sb.append(this.calculateStatus);
                sb.append(",");
            }
            for (int loop = 0; loop < rw.columnCount(); ++loop) {
                ColumnAttributes att = rw.getColumns(loop);
                if (att.getType() == DataTypes.FLOAT || att.getType() == DataTypes.INTEGER) {
                    sb.append(att.getName());
                    sb.append("=");
                    BigDecimal value = (BigDecimal)rw.getValue(loop);
                    if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                        sb.append(SecretUtil.encode((Context)this.ctx, (BigDecimal)value, (String)rw.getString("FProposerID")).toPlainString());
                    } else if (rw.getValue(loop) == null) {
                        sb.append(new BigDecimal(0));
                    } else {
                        sb.append(new BigDecimal(0));
                    }
                    sb.append(",");
                    continue;
                }
                if (att.getType() != DataTypes.STRING) continue;
                sb.append(att.getName());
                sb.append("='");
                sb.append(rw.getValue(loop) == null ? "" : rw.getValue(loop));
                sb.append("',");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(" WHERE ");
            sb.append(this.mainTableName);
            sb.append(".");
            sb.append("fid");
            sb.append("='");
            sb.append(rw.getString("fid"));
            sb.append("'");
            if (this.condition != null) {
                sb.append(" AND ");
                sb.append(this.condition);
            }
            sqls.add(sb.toString());
        }
        if (this.finishedPer < 50) {
            this.finishedPer = 50;
        }
        try {
            DataAccess DAC = DAFactory.getDataAccess();
            DAC.executeBatch(sqls);
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILSAVE, new Object[]{e.getMessage()})));
        }
    }

    public IRowSet searchSchemeFormulas() throws Exception {
        if (this.finishedPer < 2) {
            this.finishedPer = 2;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn");
        sb.append(" FROM T_HR_SCalFormula where FCalSchemeID='" + this.schemeID + "'");
        if (this.calFormulas != null && !"".equals(this.calFormulas)) {
            sb.append(" AND FID IN (");
            sb.append(this.calFormulas);
            sb.append(")");
        } else {
            sb.append(" AND FIsCal='1'");
        }
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.LEAKCALFORMULA)));
        }
        return da;
    }

    public IRowSet getSchemeFormulas(String holidayRuleId) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn ");
        sb.append(" FROM T_HR_ATS_CalFormula where FHolidayRuleID='" + holidayRuleId + "' ");
        sb.append(" AND FIsCal='1' ");
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.LEAKLIMITFORMULA)));
        }
        return da;
    }

    public IRowSet getSchemeFormulasById(String calFormulaid) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn ");
        sb.append(" FROM T_HR_ATS_CalFormula where FId='" + calFormulaid + "' ");
        sb.append(" AND FIsCal='1' ");
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.LEAKLIMITFORMULA)));
        }
        return da;
    }

    @Override
    public void setCalculateStatus(String calculateStatus) {
        this.calculateStatus = calculateStatus;
    }

    @Override
    public void setCalFormulas(String calFormulas) {
        this.calFormulas = calFormulas;
    }

    @Override
    public void setCalFromDate(String calFromDate) {
        this.calFromDate = calFromDate;
    }

    @Override
    public void setCalToDate(String calToDate) {
        this.calToDate = calToDate;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    @Override
    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    @Override
    public void setMonth(String month) {
        this.month = month;
    }

    @Override
    public void setPrecision(int v) {
        this.precision = v;
    }

    @Override
    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTempTable(String tempTable) {
        this.tempTable = tempTable;
    }

    public JSONArray testExecute(Context ctx, String execPersonId, String calSchemeId, String formulaId, JSONArray calData) throws Exception {
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        this.schemeID = calSchemeId;
        this.calFormulas = "'" + formulaId + "'";
        CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance((Context)ctx).getCalSchemeInfo("select * where id = '" + calSchemeId + "'");
        IRowSet da = this.searchSchemeFormulas();
        HolidayLimitCalFunction calObj = this.initCalInstance(ctx, da);
        int colIndex = 0;
        DataSet dataSet = new DataSet();
        HashSet<String> calItem = new HashSet<String>();
        ArrayList<ColumnAttributes> columns = new ArrayList<ColumnAttributes>();
        ArrayList datas = new ArrayList();
        ArrayList<Object> row = new ArrayList<Object>();
        ColumnAttributes columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        row.add(execPersonId);
        columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FPERSONID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        CmpCalTableInfo cmpCalTableInfo = CmpCalTableFactory.getLocalInstance((Context)ctx).getCmpCalTableInfo((IObjectPK)new ObjectUuidPK(execPersonId));
        row.add(cmpCalTableInfo.getPerson().getId().toString());
        for (int i = 0; i < calData.length(); ++i) {
            JSONObject data = calData.getJSONObject(i);
            if (!data.has("fieldSn")) continue;
            columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(colIndex++);
            columnAttributes.setName(data.getString("fieldSn"));
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add(data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add(data.getDouble("value"));
            }
            columns.add(columnAttributes);
            if (!data.has("isCal")) continue;
            calItem.add(data.getString("fieldSn"));
        }
        datas.add(row);
        DataTable mainTable = new DataTable();
        mainTable.tablename = this.mainTableName;
        mainTable.columns = columns;
        mainTable.datas = datas;
        dataSet.addTable(mainTable);
        String infoset = null;
        HashSet<String> tableSet = new HashSet<String>();
        for (int i = 0; i < calData.length(); ++i) {
            if (!calData.getJSONObject(i).has("infoset")) continue;
            infoset = calData.getJSONObject(i).getString("infoset");
            tableSet.add(infoset.split("\\.")[0]);
        }
        if (!tableSet.isEmpty()) {
            for (String tableName : tableSet) {
                colIndex = 0;
                columns = new ArrayList();
                datas = new ArrayList();
                row = new ArrayList();
                columnAttributes = new ColumnAttributes();
                columnAttributes.setIndex(colIndex++);
                columnAttributes.setName("FID");
                columnAttributes.setType(DataTypes.STRING);
                columns.add(columnAttributes);
                row.add(execPersonId);
                for (int i = 0; i < calData.length(); ++i) {
                    JSONObject data = calData.getJSONObject(i);
                    String string = infoset = data.has("infoset") ? data.getString("infoset") : "";
                    if (StringUtils.isEmpty((String)infoset) || !tableName.equals(infoset.split("\\.")[0])) continue;
                    columnAttributes = new ColumnAttributes();
                    columnAttributes.setIndex(colIndex++);
                    columnAttributes.setName(infoset.split("\\.")[1]);
                    columnAttributes.setType(DataTypes.STRING);
                    columns.add(columnAttributes);
                    row.add(data.getString("value"));
                }
                datas.add(row);
                DataTable infoTable = new DataTable();
                infoTable.tablename = tableName;
                infoTable.columns = columns;
                infoTable.datas = datas;
                dataSet.addTable(infoTable);
            }
        }
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        String sq = null;
        DataTable dt = null;
        String listtable = null;
        String[] tableitem = null;
        String[] tables = null;
        StringBuffer sb = new StringBuffer();
        da.beforeFirst();
        while (da.next()) {
            listtable = da.getString("FListTable");
            if (listtable == null || "".equals(listtable)) continue;
            tables = listtable.split(";");
            for (int loop = 0; loop < tables.length; ++loop) {
                tableitem = tables[loop].split("~");
                String id = "'" + tableitem[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            StringBuffer tableName = new StringBuffer();
            for (int index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (sb.toString().toUpperCase().indexOf("WHERE") == -1) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                tableName.delete(0, tableName.length());
                int i = sb.toString().toUpperCase().indexOf("FROM ") + 5;
                while (sb.charAt(i) != ' ' && sb.charAt(i) != '\r' && sb.charAt(i) != '\t') {
                    tableName.append(sb.charAt(i));
                    ++i;
                }
                String testcondition = " T_HR_SCmpCalTable.FID = '" + execPersonId + "'";
                sb.insert(sb.toString().toUpperCase().indexOf("WHERE") + 6, " (" + testcondition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    DataTable dt1 = DAC.getDataTable(sq, rows[index].getString("FDefine"));
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.TEMPTABLEERRORWITHSQL, new Object[]{sq, e.getMessage()})));
                }
            }
        }
        this.execCalculate(calScheme, calObj, dataSet, new HashSet());
        CmpItemCollection items = CmpItemFactory.getLocalInstance((Context)ctx).getCmpItemCollection();
        HashMap<String, Integer> itemDotMap = new HashMap<String, Integer>();
        for (int i = 0; i < items.size(); ++i) {
            CmpItemInfo item = items.get(i);
            itemDotMap.put("S" + item.getFieldSn(), item.getDataDot().getValue());
        }
        JSONArray result = new JSONArray();
        mainTable = dataSet.getTables(this.mainTableName);
        if (mainTable.rowCount() > 0) {
            DataRow rw = mainTable.getRows(0);
            for (String key : calItem) {
                JSONObject cal = new JSONObject();
                cal.put("fieldSn", (Object)key);
                Object v = rw.getValue(key);
                if (v instanceof Number) {
                    cal.put("value", (Object)FunctionTools.getRound((int)((Integer)itemDotMap.get(key)), (double)((Number)v).doubleValue()));
                } else {
                    cal.put("value", v);
                }
                result.put((Object)cal);
            }
        }
        return result;
    }
}

