/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.atsTimer;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.util.Locale;
import java.util.TimerTask;

public abstract class AtsTimeTask<V>
extends TimerTask {
    protected Context ctx;
    protected V dataObj;

    public AtsTimeTask() {
    }

    public AtsTimeTask(V dataObj) {
        this.dataObj = dataObj;
    }

    public AtsTimeTask(Context ctx) {
        this.ctx = ctx;
    }

    public AtsTimeTask(Context ctx, V dataObj) {
        this(ctx);
        this.dataObj = dataObj;
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            System.out.println("timer task error");
            this.processException(e);
        }
    }

    protected Object processException(Exception e) {
        AtsLog.getLog().error((Object)e.getMessage(), (Throwable)e);
        return null;
    }

    protected abstract void process() throws Exception;

    public V getDataObj() {
        return this.dataObj;
    }

    public AtsTimeTask<V> setDataObj(V dataObj) {
        this.dataObj = dataObj;
        return this;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public AtsTimeTask<V> setCtx(Context ctx) {
        this.ctx = ctx;
        if (ctx != null && ctx.getLocale() != null) {
            ContextUtils.setLocaleToThread((Locale)ctx.getLocale());
        }
        return this;
    }
}

