/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsLeftUndoUtil {
    private static Logger logger = Logger.getLogger(AtsLeftUndoUtil.class);
    public static final String COMPENSATION_DAY_ID = "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=";

    public static Map<String, Object> leftUndo(Context ctx, String leftDate, String personId) throws BOSException, SQLException {
        Date leftDt = AtsDateUtils.stringToShortDate(leftDate);
        String updateLimit = AtsLeftUndoUtil.hasLimit(ctx, leftDt, personId);
        AtsLeftUndoUtil.updateCycleDate(ctx, personId, leftDt);
        Map<String, Object> result = null;
        if (!StringUtils.isEmpty((String)updateLimit)) {
            HashMap<Object, Object> param = new HashMap<Object, Object>();
            param.put("proposers", personId);
            param.put("existedDealType", "1");
            param.put("holidayType", updateLimit);
            param.put("leftUndo", true);
            param.put("transaction", "transaction");
            param.put("cycleDate", leftDate);
            result = new GenHolidayLimitManager().generateUpdateHolidayLimit(ctx, param);
            param.remove("leftUndo");
        }
        try {
            AtsLeftUndoUtil.updateTakeWorkLimit(ctx, personId, leftDt);
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception.", (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    private static void updateCycleDate(Context ctx, String personId, Date changeDate) throws BOSException {
        Timestamp changeTime = new Timestamp(changeDate.getTime());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" UPDATE T_HR_ATS_HOLIDAYLIMIT T1 SET FCYCLEENDDATE=FLEFTCYCLEENDDATE,FISLEFTCONVERT=? WHERE FPROPOSERID=? AND FEFFECTDATE<=? ");
        updateSql.append(" AND FCYCLEENDDATE=? AND FLEFTCYCLEENDDATE IS NOT NULL ");
        updateSql.append(" AND EXISTS(SELECT 1 FROM T_HR_ATS_HOLIDAYPOLICY T2 WHERE T1.FHOLIDAYPOLICYID=T2.FID AND T2.FHOLIDAYTYPEID <> ?) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{0, personId, changeTime, changeTime, COMPENSATION_DAY_ID});
        updateSql = new StringBuffer();
        updateSql.append(" UPDATE T_HR_ATS_HOLIDAYLIMIT T1 SET FDELAYDATE=FLEFTDELAYDATE,FISLEFTCONVERT=? WHERE FPROPOSERID=? AND FEFFECTDATE<=? AND FDELAYDATE=? ");
        updateSql.append(" AND FLEFTDELAYDATE IS NOT NULL ");
        updateSql.append(" AND EXISTS(SELECT 1 FROM T_HR_ATS_HOLIDAYPOLICY T2 WHERE T1.FHOLIDAYPOLICYID=T2.FID AND T2.FHOLIDAYTYPEID <> ?) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{0, personId, changeTime, changeTime, COMPENSATION_DAY_ID});
    }

    public static String hasLimit(Context ctx, Date leftDate, String personId) throws BOSException, SQLException {
        StringBuffer limit = new StringBuffer();
        Timestamp changeTime = new Timestamp(leftDate.getTime());
        StringBuffer querySql = new StringBuffer();
        querySql.append(" SELECT POLICY.FHOLIDAYTYPEID HOLIDAYTYPEID");
        querySql.append(" FROM T_HR_ATS_HOLIDAYLIMIT HOLIMIT ");
        querySql.append(" JOIN T_HR_ATS_HOLIDAYPOLICY POLICY ON HOLIMIT.FHOLIDAYPOLICYID = POLICY.FID");
        querySql.append(" WHERE HOLIMIT.FPROPOSERID = ? AND HOLIMIT.FCYCLEBEGINDATE <=? AND HOLIMIT.FCYCLEENDDATE >=? AND POLICY.FHOLIDAYTYPEID <> ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{personId, changeTime, changeTime, COMPENSATION_DAY_ID});
        while (rowSet.next()) {
            limit.append(rowSet.getString("holidayTypeId")).append(",");
        }
        if (limit.length() > 0) {
            limit.setLength(limit.length() - 1);
        }
        return limit.toString();
    }

    private static void updateTakeWorkLimit(Context ctx, String personId, Date changeDate) throws BOSException, EASBizException {
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer.id='" + personId + "' and holidayPolicy.holidayType.id ='" + COMPENSATION_DAY_ID + "'   ");
        if (AtsCollectionUtile.isEmpty((IObjectCollection)holidayLimitCollection)) {
            return;
        }
        CoreBaseCollection oldLimitColl = new CoreBaseCollection();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            oldLimitColl.add((CoreBaseInfo)holidayLimitCollection.get(i));
        }
        LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
        DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, oldLimitColl, OperTypeEnum.holidayLimit, OperActionEnum.leftUndoByOsf, false);
        CoreBaseCollection updateHolidayLimitCollection = new CoreBaseCollection();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
            if (holidayLimitInfo == null) continue;
            boolean isUpdate = false;
            if (holidayLimitInfo.getCycleBeginDate() != null && holidayLimitInfo.getCycleEndDate() != null && holidayLimitInfo.getCycleBeginDate().before(changeDate) && holidayLimitInfo.getCycleEndDate().equals(changeDate) && null != holidayLimitInfo.getLeftCycleEndDate()) {
                holidayLimitInfo.setCycleEndDate(holidayLimitInfo.getLeftCycleEndDate());
                holidayLimitInfo.setLeftCycleEndDate(null);
                isUpdate = true;
            }
            if (holidayLimitInfo.getEffectDate() != null && holidayLimitInfo.getDelayDate() != null && holidayLimitInfo.getEffectDate().before(changeDate) && holidayLimitInfo.getDelayDate().after(changeDate) && null != holidayLimitInfo.getLeftDelayDate()) {
                holidayLimitInfo.setDelayDate(holidayLimitInfo.getLeftDelayDate());
                holidayLimitInfo.setLeftDelayDate(null);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            holidayLimitInfo.setIsLeftConvert(false);
            updateHolidayLimitCollection.add((CoreBaseInfo)holidayLimitInfo);
        }
        Result result = HolidayLimitFactory.getLocalInstance(ctx).update(updateHolidayLimitCollection);
        DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, updateHolidayLimitCollection, OperTypeEnum.holidayLimit, OperActionEnum.leftUndoByOsf, true);
    }
}

