/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl;

import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.BaseTimeDataProcess;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.util.CalTimeUtil;
import com.kingdee.eas.hr.ats.calculate.time.util.TimeRangeUnion;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OffsiteTimeDataProcessImpl
extends BaseTimeDataProcess {
    @Override
    public List<TimeLabelModel> process(TimeDataVO timeDataVO) {
        Map<String, AtsShiftInfo> atsShiftMap;
        List coreBaseInfoList = timeDataVO.getCoreBaseInfoList();
        ArrayList<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        if (null != coreBaseInfoList && coreBaseInfoList.size() > 0 && null != (atsShiftMap = timeDataVO.getAtsShiftMap()) && atsShiftMap.size() > 0) {
            List<TimeLabelModel> shiftModel = CalTimeUtil.getShiftTime(atsShiftMap.values().iterator().next(), timeDataVO.getDate());
            for (AtsOffsiteEntryInfo atsOffsiteEntryInfo : coreBaseInfoList) {
                int i;
                String officeType = atsOffsiteEntryInfo.getTeleOfficeType().getNumber();
                if (null != shiftModel && shiftModel.size() > 0 && (atsOffsiteEntryInfo.getRealStartTime().compareTo(shiftModel.get(shiftModel.size() - 1).getEndTime()) >= 0 || atsOffsiteEntryInfo.getRealEndTime().compareTo(shiftModel.get(0).getBeginTime()) <= 0)) continue;
                if (timeDataVO.getLabel().equalsIgnoreCase("offsite" + officeType)) {
                    if (atsOffsiteEntryInfo.isIsAllDay() && null != shiftModel) {
                        for (i = 0; i < shiftModel.size(); ++i) {
                            timeLabelModels.add(new TimeLabelModel(shiftModel.get(i).getBeginTime(), shiftModel.get(i).getEndTime(), "offsite" + officeType));
                        }
                        continue;
                    }
                    timeLabelModels.add(new TimeLabelModel(atsOffsiteEntryInfo.getRealStartTime(), atsOffsiteEntryInfo.getRealEndTime(), "offsite" + officeType));
                    continue;
                }
                if (!timeDataVO.getLabel().equals("offsite")) continue;
                if (atsOffsiteEntryInfo.isIsAllDay() && null != shiftModel) {
                    for (i = 0; i < shiftModel.size(); ++i) {
                        timeLabelModels.add(new TimeLabelModel(shiftModel.get(i).getBeginTime(), shiftModel.get(i).getEndTime(), "offsite"));
                    }
                    continue;
                }
                timeLabelModels.add(new TimeLabelModel(atsOffsiteEntryInfo.getRealStartTime(), atsOffsiteEntryInfo.getRealEndTime(), "offsite"));
            }
        }
        return TimeRangeUnion.union(timeLabelModels);
    }
}

