/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calcutePrepareData;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceStatus;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.FillSignCardType;
import com.kingdee.eas.hr.ats.FillSignReasonInfo;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.OverTimeCreateTag;
import com.kingdee.eas.hr.ats.OverTimeReasonInfo;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.WorkCalendarCollection;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.lightapp.util.BillBizUtil;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsAttCalProjectDealUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsPrepareExtendData;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AtsPrepareDataHelper {
    public static Map<String, List<AttendanceDynamicResInfo>> getAttendanceResultInfoByPersonAndDate(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        HashMap<String, List<AttendanceDynamicResInfo>> cardMap = new HashMap<String, List<AttendanceDynamicResInfo>>();
        String sqlRes = " select  FProposerID , FAttenceDate,FAttenceStatus, S1, S2, S3, S4, S5, S6    from  T_HR_ATS_AttendanceResult  result  where Fproposerid in(" + personIds + ") and  result.FAttenceDate >= {TS '" + beginDate + " 00:00:00'}  and  result.FAttenceDate <= {TS '" + endDate + " 23:59:59'}  order by  result.FAttenceDate ";
        IRowSet rowRes = null;
        rowRes = DbUtil.executeQuery((Context)ctx, (String)sqlRes);
        while (rowRes.next()) {
            AttendanceDynamicResInfo info = new AttendanceDynamicResInfo();
            String personid = rowRes.getString("FProposerID");
            info.setAttenceDate(rowRes.getDate("FAttenceDate"));
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personid));
            info.setProposer(personInfo);
            info.setOneOnTime(rowRes.getString("S1"));
            info.setOneOffTime(rowRes.getString("S2"));
            info.setTwoOnTime(rowRes.getString("S3"));
            info.setTwoOffTime(rowRes.getString("S4"));
            info.setThreeOnTime(rowRes.getString("S5"));
            info.setThreeOffTime(rowRes.getString("S6"));
            info.setAttenceStatus(AttendanceStatus.getEnum(rowRes.getInt("FAttenceStatus")));
            String datestr = AtsDateUtils.dateShortToString(rowRes.getDate("FAttenceDate"));
            String key = personid + "_" + datestr;
            ArrayList<AttendanceDynamicResInfo> resultList = new ArrayList<AttendanceDynamicResInfo>();
            if (cardMap.containsKey(key)) {
                ((List)cardMap.get(key)).add(info);
            } else {
                resultList.add(info);
                cardMap.put(key, resultList);
            }
            info = null;
        }
        return cardMap;
    }

    public static Map<String, List<AttendanceDynamicResInfo>> getAttendanceResultInfoByPersonAndDateNew(Context ctx, Map<String, Object> globalMap, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        HashMap<String, List<AttendanceDynamicResInfo>> cardMap = new HashMap<String, List<AttendanceDynamicResInfo>>();
        Map atsCalFormulaMap = (Map)globalMap.get("resulTemplateProject");
        if (null == atsCalFormulaMap) {
            return cardMap;
        }
        String attResultColumn = AtsAttCalProjectDealUtils.getAttResultColumn(atsCalFormulaMap);
        List<String> columnNameList = AtsAttCalProjectDealUtils.getResultColumnNameList(atsCalFormulaMap);
        if (StringUtils.isEmpty((String)attResultColumn) || AtsCollectionUtile.isEmpty(columnNameList)) {
            return cardMap;
        }
        String beginDatestr = AtsDateUtils.getPreDay(beginDate, 1);
        String endDatestr = AtsDateUtils.getNextDay(endDate, 1);
        String sqlRes = " select   " + attResultColumn + "   from  T_HR_ATS_AttendanceResult  result  where Fproposerid in(" + personIds + ") and  result.FAttenceDate >= {TS '" + beginDatestr + " 00:00:00'}  and  result.FAttenceDate <= {TS '" + endDatestr + " 23:59:59'}  order by  result.FAttenceDate ";
        IRowSet rowRes = null;
        rowRes = DbUtil.executeQuery((Context)ctx, (String)sqlRes);
        HashMap calBeforeResultMap = new HashMap();
        while (rowRes.next()) {
            HashMap<String, Object> resultInfoMap = new HashMap<String, Object>();
            for (String columnName : columnNameList) {
                resultInfoMap.put(columnName, rowRes.getObject(columnName));
            }
            AttendanceDynamicResInfo info = new AttendanceDynamicResInfo();
            String personid = rowRes.getString("FProposerID");
            info.setAttenceDate(rowRes.getDate("FAttenceDate"));
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personid));
            info.setProposer(personInfo);
            if (rowRes.getString("S1") != null && rowRes.getString("S1").endsWith(".0")) {
                info.setOneOnTime(rowRes.getString("S1").substring(0, rowRes.getString("S1").length() - 2));
            } else {
                info.setOneOnTime(rowRes.getString("S1"));
            }
            if (rowRes.getString("S2") != null && rowRes.getString("S2").endsWith(".0")) {
                info.setOneOffTime(rowRes.getString("S2").substring(0, rowRes.getString("S2").length() - 2));
            } else {
                info.setOneOffTime(rowRes.getString("S2"));
            }
            if (rowRes.getString("S3") != null && rowRes.getString("S3").endsWith(".0")) {
                info.setTwoOnTime(rowRes.getString("S3").substring(0, rowRes.getString("S3").length() - 2));
            } else {
                info.setTwoOnTime(rowRes.getString("S3"));
            }
            if (rowRes.getString("S4") != null && rowRes.getString("S4").endsWith(".0")) {
                info.setTwoOffTime(rowRes.getString("S4").substring(0, rowRes.getString("S4").length() - 2));
            } else {
                info.setTwoOffTime(rowRes.getString("S4"));
            }
            if (rowRes.getString("S5") != null && rowRes.getString("S5").endsWith(".0")) {
                info.setThreeOnTime(rowRes.getString("S5").substring(0, rowRes.getString("S5").length() - 2));
            } else {
                info.setThreeOnTime(rowRes.getString("S5"));
            }
            if (rowRes.getString("S6") != null && rowRes.getString("S6").endsWith(".0")) {
                info.setThreeOffTime(rowRes.getString("S6").substring(0, rowRes.getString("S6").length() - 2));
            } else {
                info.setThreeOffTime(rowRes.getString("S6"));
            }
            info.setAttenceStatus(AttendanceStatus.getEnum(rowRes.getInt("FAttenceStatus")));
            String datestr = AtsDateUtils.dateShortToString(rowRes.getDate("FAttenceDate"));
            String key = personid + "_" + datestr;
            calBeforeResultMap.put(key, resultInfoMap);
            ArrayList<AttendanceDynamicResInfo> resultList = new ArrayList<AttendanceDynamicResInfo>();
            if (cardMap.containsKey(key)) {
                ((List)cardMap.get(key)).add(info);
            } else {
                resultList.add(info);
                cardMap.put(key, resultList);
            }
            info = null;
        }
        globalMap.put("calResultInfoMap", calBeforeResultMap);
        return cardMap;
    }

    public static Map<String, AttendanceFileInfo> getAttendanceFileInfosByPersonIds(Context ctx, String personIds) throws BOSException, UuidException, SQLException {
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        String oql = " where proposer in(" + personIds + ") and attendFileState = '" + "1" + "'  order by  attendanceNum ";
        AttendanceFileCollection fileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(oql);
        int size = fileColl.size();
        for (int i = 0; i < size; ++i) {
            String key = fileColl.get(i).getProposer().getId().toString();
            fileInfoMap.put(key, fileColl.get(i));
        }
        return fileInfoMap;
    }

    public static Map<String, List<AtsOverTimeBillEntryInfo>> setAtsOverTimeBillInfoMap(Context ctx, Map param) {
        String personIds = (String)param.get("personIds");
        String beginDate = (String)param.get("beginDate");
        String endDate = (String)param.get("endDate");
        Map<String, List<AtsOverTimeBillEntryInfo>> atsOverTimeBillInfoMap = null;
        try {
            Map<String, HolidayLimitCollection> holidayLimitInfoMap = AtsServerCalUtils.getAllHolidayLimitInfos(ctx, personIds);
            atsOverTimeBillInfoMap = AtsPrepareDataHelper.getAtsOverTimeBillInfo(ctx, personIds, beginDate, endDate, holidayLimitInfoMap);
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return atsOverTimeBillInfoMap;
    }

    public static Map<String, List<FillSignCardInfo>> setFillSignCardInfoMap(Context ctx, Map param) {
        String personIds = (String)param.get("personIds");
        String beginDate = (String)param.get("beginDate");
        String endDate = (String)param.get("endDate");
        Map<String, List<FillSignCardInfo>> fillSignCardInfosMap = null;
        try {
            fillSignCardInfosMap = AtsPrepareDataHelper.getFillSignCardInfo(ctx, personIds, beginDate, endDate);
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fillSignCardInfosMap;
    }

    public static Map<String, List<FillSignCardInfo>> getFillSignCardInfo(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        HashMap<String, List<FillSignCardInfo>> resMap = new HashMap<String, List<FillSignCardInfo>>();
        String beginDatestr = AtsDateUtils.getPreDay(beginDate, 1);
        String endDatestr = AtsDateUtils.getNextDay(endDate, 1);
        String sqlFill = " select fill.FID as FID,FillCardTime, FPersonid,FAttendDate,FType,reason.Fid as reasonId, reason.FNumber as reasonNumber from T_HR_ATS_fillsigncard fill   left join T_HR_ATS_fillsigncardentry entry   left join T_HR_ATS_FillSignReason reason on entry.FReasonID = reason.fid  on fill.fid = entry.fbillid    where entry.FAttendDate >= {TS '" + beginDatestr + " 00:00:00'}  and   entry.FAttendDate <= {TS '" + endDatestr + " 23:59:59'}  and   entry.fpersonid in( " + personIds + ")  and   fill.fbillstate = '" + 3 + "'  order by entry.FillCardTime ";
        IRowSet rowFill = null;
        rowFill = DbUtil.executeQuery((Context)ctx, (String)sqlFill);
        while (rowFill.next()) {
            String personid = rowFill.getString("FPersonid");
            FillSignCardInfo info = new FillSignCardInfo();
            info.setId(BOSUuid.read((String)rowFill.getString("FID")));
            FillSignCardEntryInfo entryInfo = new FillSignCardEntryInfo();
            entryInfo.setAttendDate(rowFill.getDate("FAttendDate"));
            entryInfo.setType(FillSignCardType.getEnum(rowFill.getInt("FType")));
            entryInfo.setFillCardTime(rowFill.getTimestamp("FillCardTime"));
            if (StringUtils.isNotEmpty((String)rowFill.getString("reasonId"))) {
                FillSignReasonInfo fillSignReasonInfo = new FillSignReasonInfo();
                fillSignReasonInfo.setId(BOSUuid.read((String)rowFill.getString("reasonId")));
                fillSignReasonInfo.setNumber(rowFill.getString("reasonNumber"));
                entryInfo.setReason(fillSignReasonInfo);
            }
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personid));
            info.setProposer(personInfo);
            info.getEntries().add(entryInfo);
            String datestr = AtsDateUtils.dateShortToString(rowFill.getDate("FAttendDate"));
            String key = personid + "_" + datestr;
            if (resMap.containsKey(key)) {
                ((List)resMap.get(key)).add(info);
            } else {
                ArrayList<FillSignCardInfo> fillcardList = new ArrayList<FillSignCardInfo>();
                fillcardList.add(info);
                resMap.put(key, fillcardList);
            }
            info = null;
        }
        return resMap;
    }

    public static Map<String, List<AtsOverTimeBillEntryInfo>> getAtsOverTimeBillInfo(Context ctx, String personIds, String beginDate, String endDate, Map<String, HolidayLimitCollection> holidayLimitInfoMap) throws BOSException, UuidException, SQLException {
        String atsTripMeteDataPath = "com.kingdee.eas.hr.ats.app.AtsOverTimeBillEntry";
        AtsPrepareExtendData extendData = new AtsPrepareExtendData(atsTripMeteDataPath);
        Set<String> extendColName = extendData.getColNameSet();
        String extendSql = AtsPrepareDataHelper.convertSettoSql(extendColName);
        String beginDatestr = AtsDateUtils.getPreDay(beginDate, 1);
        String endDatestr = AtsDateUtils.getNextDay(endDate, 1);
        HashMap<String, List<AtsOverTimeBillEntryInfo>> overTimeBillInfoMap = new HashMap<String, List<AtsOverTimeBillEntryInfo>>();
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(" select " + extendSql + " entry.fid as entryid,entry.FPersonID  as enpersonid,entry.FOTDate as enotdate, ");
        sBuffer.append(" entry.fstarttime as enfstarttime, entry.fendtime as enfendtime, ");
        sBuffer.append(" entry.FAdminOrgUnitID as enFAdminOrgUnitID,bill.*, entry.*  ");
        sBuffer.append(" from T_HR_ATS_overtimebillentry  entry   ");
        sBuffer.append(" left join T_HR_ATS_overtimebill  bill on bill.fid = entry.fbillid    ");
        sBuffer.append(" left join T_HR_ATS_HolidayLimit holidayLimit on holidayLimit.fid = entry.FHolidayLimit    ");
        sBuffer.append(" where entry.FOTDate >= {TS '" + beginDatestr + " 00:00:00'} ");
        sBuffer.append(" and   entry.FOTDate <= {TS '" + endDatestr + " 23:59:59'} ");
        sBuffer.append(" and   entry.fpersonid in (" + personIds + ")  ");
        sBuffer.append(" and   bill.fbillstate = '3' ");
        sBuffer.append(" order by entry.FOTDate,entry.FStartTime  ");
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sBuffer.toString());
        while (row.next()) {
            AtsOverTimeBillEntryInfo entryInfo = new AtsOverTimeBillEntryInfo();
            entryInfo.setId(BOSUuid.read((String)row.getString("entryid")));
            entryInfo.setStartTime(row.getTimestamp("enfstarttime"));
            entryInfo.setEndTime(row.getTimestamp("enfendtime"));
            entryInfo.setRealStartTime(row.getTimestamp("FRealStartTime"));
            entryInfo.setRealEndTime(row.getTimestamp("FRealEndTime"));
            entryInfo.setRealOTTime(row.getBigDecimal("FRealOTTime"));
            entryInfo.setRestTime(row.getInt("FRestTime"));
            entryInfo.setCreateTag(OverTimeCreateTag.getEnum(Integer.parseInt(row.getString("FCreateTag"))));
            entryInfo.setApplyOTTime(row.getBigDecimal("FApplyOTTime"));
            OverTimeCompensInfo compensInfo = new OverTimeCompensInfo();
            compensInfo.setId(BOSUuid.read((String)row.getString("FOTCompensID")));
            entryInfo.setOtCompens(compensInfo);
            OverTimeReasonInfo overTimeReasonInfo = new OverTimeReasonInfo();
            if (StringUtil.isNotEmpty((String)row.getString("FOTReasonID"))) {
                overTimeReasonInfo.setId(BOSUuid.read((String)row.getString("FOTReasonID")));
                entryInfo.setOtReason(overTimeReasonInfo);
            }
            OverTimeTypeInfo typeInfo = new OverTimeTypeInfo();
            typeInfo.setId(BOSUuid.read((String)row.getString("FOTTypeID")));
            entryInfo.setOtType(typeInfo);
            entryInfo.setOtDate(row.getDate("FOTDate"));
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)row.getString("FPersonID")));
            entryInfo.setPerson(pInfo);
            AdminOrgUnitInfo orgUnitInfo = new AdminOrgUnitInfo();
            orgUnitInfo.setId(BOSUuid.read((String)row.getString("enFAdminOrgUnitID")));
            entryInfo.setAdminOrgUnit(orgUnitInfo);
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)row.getString("FPositionID")));
            entryInfo.setPosition(positionInfo);
            int calculateState = row.getInt("FCalculateState");
            boolean isCalculate = calculateState == 1;
            entryInfo.setCalculateState(isCalculate);
            if (!StringUtils.isEmpty((String)row.getString("FHolidayLimit"))) {
                HolidayLimitInfo limitInfo = null;
                String key = row.getString("FHolidayLimit");
                HolidayLimitCollection limitColl = holidayLimitInfoMap.get(key);
                if (limitColl != null && limitColl.size() > 0) {
                    limitInfo = limitColl.get(0);
                }
                entryInfo.setHolidayLimit(limitInfo);
            }
            extendData.setObjectValue((AbstractObjectValue)entryInfo, row);
            String personid = row.getString("FPersonID");
            String attdate = AtsDateUtils.dateShortToString(row.getDate("FOTDate"));
            String key = personid + "_" + attdate;
            ArrayList<AtsOverTimeBillEntryInfo> entryinfoList = new ArrayList<AtsOverTimeBillEntryInfo>();
            if (overTimeBillInfoMap.containsKey(key)) {
                ((List)overTimeBillInfoMap.get(key)).add(entryInfo);
                continue;
            }
            entryinfoList.add(entryInfo);
            overTimeBillInfoMap.put(key, entryinfoList);
        }
        return overTimeBillInfoMap;
    }

    public static String convertSettoSql(Set<String> colSet) {
        if (colSet != null && !colSet.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String colName : colSet) {
                sb.append("entry." + colName + ",");
            }
            return sb.toString();
        }
        return "";
    }

    public static Map<String, AtsShiftInfo> getAtsShiftInfos(Context ctx) {
        HashMap<String, AtsShiftInfo> atsShiftInfoMap = new HashMap<String, AtsShiftInfo>();
        try {
            String oql = " select *,items.*  order by items.segment ";
            AtsShiftCollection coll = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(oql);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String key = coll.get(i).getId().toString();
                atsShiftInfoMap.put(key, coll.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return atsShiftInfoMap;
    }

    public static Map<String, Object> getAttendanceFileInfoByPersonId(Context ctx, String personIds, String beginDate, String endDate, String hrOrgUnitId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        HashMap fileInfoSizeMap = new HashMap();
        HashSet<String> hrOrgUnitIdSet = new HashSet<String>();
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select *,attencePolicy.id,attencePolicy.firstShiftPriority,attencePolicy.secondShiftPriority,attencePolicy.thirdShiftPriority,attencePolicy.multiLanLocale,adminOrgUnit.number,adminOrgUnit.name ");
            sb.append(" where proposer in(" + personIds + ") ");
            sb.append(" and  Effdt <= {ts '" + endDate + "'} and Leffdt >= {ts '" + beginDate + "'} order by  attendanceNum  ");
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(sb.toString());
            String personId = null;
            String key = null;
            AttendanceFileInfo fileInfo = null;
            AttendanceFileHISInfo hisInfo = null;
            String hrOrgUnitIdinner = null;
            for (String currentDate : dateList) {
                int size = fileColl.size();
                for (int i = 0; i < size; ++i) {
                    hisInfo = fileColl.get(i);
                    personId = hisInfo.getProposer().getId().toString();
                    if (hisInfo.getHrOrgUnit() != null && hisInfo.getHrOrgUnit().getId() != null) {
                        hrOrgUnitIdinner = hisInfo.getHrOrgUnit().getId().toString();
                    }
                    key = personId + "_" + currentDate;
                    if (StringUtils.isNotBlank((String)hrOrgUnitIdinner)) {
                        hrOrgUnitIdSet.add(hrOrgUnitIdinner);
                    }
                    fileInfoSizeMap.put(personId, hrOrgUnitIdSet);
                    Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (hisInfo.getEFFDT() == null || hisInfo.getLEFFDT() == null || hisInfo.getEFFDT().getTime() > date.getTime() || hisInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    fileInfo = BillBizUtil.convertHis2File(ctx, hisInfo);
                    fileInfoMap.put(key, fileInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        returnMap.put("fileInfoMap", fileInfoMap);
        returnMap.put("fileInfoSizeMap", fileInfoSizeMap);
        return returnMap;
    }

    public static AttendanceFileInfo convertHis2File(AttendanceFileHISInfo hisInfo) {
        String fileHisMetaDataPath = "com.kingdee.eas.hr.ats.app.AttendanceFileHIS";
        AtsPrepareExtendData extendData = new AtsPrepareExtendData(fileHisMetaDataPath);
        Set<String> colNameSet = extendData.getColNameSet();
        AttendanceFileInfo fileInfo = new AttendanceFileInfo();
        fileInfo.setAttendanceNum(hisInfo.getAttendanceNum());
        fileInfo.setIsAttendance(hisInfo.getIsAttendance());
        fileInfo.setAttendFileState(hisInfo.getAttendFileState());
        fileInfo.setRemark(hisInfo.getRemark());
        fileInfo.setAttendCenter(hisInfo.getAttendCenter());
        fileInfo.setAttencePolicy(hisInfo.getAttencePolicy());
        fileInfo.setHolidayPolicySet(hisInfo.getHolidayPolicySet());
        fileInfo.setAtsShift(hisInfo.getAtsShift());
        fileInfo.setFileType(hisInfo.getFileType());
        fileInfo.setIsAutoShift(hisInfo.getIsAutoShift());
        fileInfo.setProposer(hisInfo.getProposer());
        fileInfo.setHrOrgUnit(hisInfo.getHrOrgUnit());
        fileInfo.setPosition(hisInfo.getPosition());
        fileInfo.setAdminOrgUnit(hisInfo.getAdminOrgUnit());
        fileInfo.setEFFDT(hisInfo.getEFFDT());
        fileInfo.setLEFFDT(hisInfo.getLEFFDT());
        fileInfo.setAttendFileState(AttendFileStateEnum.enable);
        if (colNameSet != null && colNameSet.size() > 0) {
            for (String colName : colNameSet) {
                String fieldName = colName.substring(2);
                fileInfo.put(fieldName, hisInfo.get(fieldName));
            }
        }
        return fileInfo;
    }

    public static Map<String, WorkCalendarInfo> getAllWorkCalendarInfo(Context ctx) {
        HashMap<String, WorkCalendarInfo> workCalendarMap = new HashMap<String, WorkCalendarInfo>();
        try {
            WorkCalendarCollection workCalendarCol = WorkCalendarFactory.getLocalInstance(ctx).getWorkCalendarCollection();
            for (int i = 0; i < workCalendarCol.size(); ++i) {
                WorkCalendarInfo workCalendarInfo = workCalendarCol.get(i);
                workCalendarMap.put(workCalendarInfo.getId().toString(), workCalendarInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return workCalendarMap;
    }

    public static Map<String, List<AtsLeaveBillDetailInfo>> getAtsLeaveBillDetailInfo(Context ctx, Map<String, String> commonParams) {
        String personIds = commonParams.get("personIds");
        String beginDate = commonParams.get("beginDate");
        String endDate = commonParams.get("endDate");
        HashMap<String, List<AtsLeaveBillDetailInfo>> leaveBillDetailInfoMap = new HashMap<String, List<AtsLeaveBillDetailInfo>>();
        String sql = " select detail.FID,detail.FProposerID,detail.FLeaveDate,detail.FLeavebillID,detail.FleaveLength,detail.FLeaveUnit,detail.FPolicyID,type.fid typeId,type.fNumber typeNum from T_HR_ATS_leavebilldetail as detail   left join T_HR_ATS_HolidayPolicy as policy on policy.fid = detail.FPolicyID  left join T_HR_ATS_HolidayType as type  on  type.fid = policy.FHolidayTypeID   where   detail.fproposerid in (" + personIds + ")   and detail.FLeavedate >= {TS '" + beginDate + " 00:00:00'}   and detail.FLeavedate <= {TS '" + endDate + " 23:59:59'}   order by detail.FLeaveDate ";
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (row.next()) {
                AtsLeaveBillDetailInfo detailInfo = new AtsLeaveBillDetailInfo();
                detailInfo.setId(BOSUuid.read((String)row.getString("FID")));
                PersonInfo personInfo = new PersonInfo();
                String personId = row.getString("FProposerID");
                personInfo.setId(BOSUuid.read((String)personId));
                detailInfo.setProposer(personInfo);
                detailInfo.setLeaveDate(row.getDate("FLeaveDate"));
                AtsLeaveBillInfo billInfo = new AtsLeaveBillInfo();
                billInfo.setId(BOSUuid.read((String)row.getString("FLeavebillID")));
                detailInfo.setLeavebill(billInfo);
                detailInfo.setLeaveLength(row.getBigDecimal("FleaveLength"));
                HolidayPolicyInfo holidayPolicyInfo = new HolidayPolicyInfo();
                holidayPolicyInfo.setId(BOSUuid.read((String)row.getString("FPolicyID")));
                HolidayTypeInfo holidayTypeInfo = new HolidayTypeInfo();
                holidayTypeInfo.setId(BOSUuid.read((String)row.getString("typeId")));
                holidayTypeInfo.setNumber(row.getString("typeNum"));
                holidayPolicyInfo.setHolidayType(holidayTypeInfo);
                detailInfo.setPolicy(holidayPolicyInfo);
                int unit = row.getInt("FLeaveUnit");
                if (unit == 1) {
                    detailInfo.setLeaveUnit(HolidayTypeUnitEnum.day);
                } else if (unit == 2) {
                    detailInfo.setLeaveUnit(HolidayTypeUnitEnum.hour);
                }
                String keyDate = AtsDateUtils.dateShortToString(detailInfo.getLeaveDate());
                String key = personId + "_" + keyDate;
                if (leaveBillDetailInfoMap.containsKey(key)) {
                    ((List)leaveBillDetailInfoMap.get(key)).add(detailInfo);
                    continue;
                }
                ArrayList<AtsLeaveBillDetailInfo> detailList = new ArrayList<AtsLeaveBillDetailInfo>();
                detailList.add(detailInfo);
                leaveBillDetailInfoMap.put(key, detailList);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return leaveBillDetailInfoMap;
    }
}

