/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.FunctionWrapper;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.hr.ats.AtsDataDumpException;
import com.kingdee.eas.hr.ats.syn.BackTransactionJobUtils;
import com.kingdee.eas.hr.ats.util.BackJobTools;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataDumpJob {
    public final String AttenceCalfuncName = "com.kingdee.eas.hr.ats.DataDumpFunction";
    static Map<String, String> ctxCallerMap = new HashMap<String, String>();

    public int getCreateDefAndInstSum(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DEF.FMUTEX  \n");
        sb.append(" FROM T_JOB_DEF DEF \n ");
        sb.append(" INNER JOIN T_JOB_INST  INST ON DEF.FJOBDEFID = INST.FJOBDEFID \n");
        sb.append(" WHERE DEF.FMUTEX like '%G::DataDumpFunction%' AND  \n");
        sb.append(" ( INST.FJOBINSTID IS NULL \n");
        sb.append(" or ( fstate ='Created' or fstate ='ReScheduled' or fstate ='Waiting' ");
        sb.append("  or fstate ='Ready' or fstate ='Running' ) \n");
        sb.append("  )   group by  DEF.FMUTEX \n ");
        int countinst = 0;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (row.next()) {
                countinst = row.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return countinst;
    }

    public static int getRunningInstSum(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  \n");
        sb.append(" \tCOUNT (*)  \n");
        sb.append(" FROM  \n");
        sb.append(" T_JOB_INST  \n");
        sb.append(" LEFT JOIN T_JOB_DEF ON T_JOB_INST.fjobdefid = T_JOB_DEF.fjobdefid  \n");
        sb.append(" WHERE  \n");
        sb.append(" \tFCategoryID = 'IL7rQ1abA0a0aYZ0SvsDiCTIItw='  \n");
        sb.append(" AND fuserid = '" + ctx.getCaller().toString() + "'  \n");
        sb.append(" AND (  \n");
        sb.append(" fstate = 'Created'  \n");
        sb.append(" OR fstate = 'ReScheduled'  \n");
        sb.append(" OR fstate = 'Waiting'  \n");
        sb.append(" OR fstate = 'Ready'  \n");
        sb.append(" OR fstate = 'Running'  \n");
        sb.append(" )  \n");
        int countinst = 0;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (row.next()) {
                countinst = row.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return countinst;
    }

    public int getCalcultAllowVal(Context ctx) {
        int val = 1;
        String keyId = "brZdZZ9XVk+I6uGlDNNdCqiB8+c=";
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " value FROM T_BAS_PARAMITEM ITEM \n");
        sb.append(" inner join T_BAS_Param param on param.fid = item.fkeyid \n");
        sb.append(" where fkeyid ='" + keyId + "' \n");
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (row.next()) {
                val = row.getInt("value") > val ? row.getInt("value") : val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public int attenceBoardAndDetailCalProcess(Context ctx, String jobTitle, Map jobContext, String categoryId, String functionName, String operationName) throws BOSException {
        int operactionType = 0;
        int hasExistSum = this.getCreateDefAndInstSum(ctx);
        int allowVal = 1;
        if (allowVal != 1 && allowVal <= hasExistSum) {
            return operactionType;
        }
        String userName = this.getOperatePersonName(ctx);
        jobTitle = jobTitle + " ( " + userName + " )";
        String jobProcessDefID = this.createJobDefCoreProcessV2(ctx, jobTitle, jobContext, categoryId, functionName, operationName);
        if (allowVal == 1) {
            this.updateBackJobDefByDefId(ctx, jobProcessDefID);
            operactionType = 1;
        } else if (allowVal > hasExistSum) {
            this.updateBackJobDefByDefId(ctx, jobProcessDefID, userName, functionName);
            operactionType = 2;
        }
        BackTransactionJobUtils.createJobInstance(ctx, jobProcessDefID);
        return operactionType;
    }

    public String createJobDefCoreProcess(Context ctx, String jobTitle, Map jobContext, String categoryId, String functionName, String operationName) throws BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK(functionName);
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationInfo operation = this.getOperation(function, operationName);
        BackJobTools.getInstance().setCtx(ctx);
        Date date = new Date();
        String jobProcessDefID = service.createJobProcessDef(jobTitle, function, operation, jobContext, this.getSchedule(date), ctx.getLocale(), categoryId);
        System.out.println("create DataDumpJob sucess,Job ID is :" + jobProcessDefID);
        return jobProcessDefID;
    }

    private OperationInfo getOperation(FunctionObjectInfo function, String operationName) {
        OperationCollection operCol = function.getOperation();
        OperationInfo oper = null;
        if (operCol != null) {
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)operationName)) continue;
                oper = operCol.get(i);
                break;
            }
        }
        return oper;
    }

    public String getOperatePersonName(Context ctx) {
        String userName = "";
        if (ctx.getCaller() != null) {
            String fcreateUserID = ctx.getCaller().toString();
            String sql = "select fname" + MLUtile.getMlFlag(ctx) + " name from T_PM_User where Fid ='" + fcreateUserID + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rowSet.size() > 0 && rowSet.next()) {
                    userName = rowSet.getString("name");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return userName;
    }

    public int createDataDumpJob(Context ctx, Map<String, Object> param) throws BOSException {
        try {
            Mutex.lock((Context)ctx, (String)"j+YydLJ4pEWtq4emh1WryxuhXPo=");
        }
        catch (AlreadyInProcessQueueException e1) {
            e1.printStackTrace();
            System.out.println("has same job in running");
            return 3;
        }
        HashMap<String, Object> jobContext = new HashMap<String, Object>();
        jobContext.put("dumpTableName", param.get("dumpTableName"));
        jobContext.put("year", param.get("year"));
        jobContext.put("yearBeforeNum", param.get("yearBeforeNum"));
        jobContext.put("number", param.get("number"));
        String jobTitle = new AtsDataDumpException(AtsDataDumpException.DATADUMP).getMessage();
        String operationName = "dataDump";
        return this.attenceBoardAndDetailCalProcess(ctx, jobTitle, jobContext, "IL7rQ1abA0a0aYZ0SvsDiCTIItw=", "com.kingdee.eas.hr.ats.DataDumpFunction", operationName);
    }

    public int createAntiDataDumpJob(Context ctx, Map<String, Object> param) throws BOSException {
        try {
            Mutex.lock((Context)ctx, (String)"j+YydLJ4pEWtq4emh1WryxuhXPo=");
        }
        catch (AlreadyInProcessQueueException e1) {
            e1.printStackTrace();
            System.out.println("has same job in running");
            return 3;
        }
        HashMap<String, Object> jobContext = new HashMap<String, Object>();
        jobContext.put("dumpTableName", param.get("dumpTableName"));
        jobContext.put("year", param.get("year"));
        jobContext.put("yearBeforeNum", param.get("yearBeforeNum"));
        jobContext.put("number", param.get("number"));
        String jobTitle = new AtsDataDumpException(AtsDataDumpException.ANTIDATADUMP).getMessage();
        String operationName = "antiDataDump";
        return this.attenceBoardAndDetailCalProcess(ctx, jobTitle, jobContext, "IL7rQ1abA0a0aYZ0SvsDiCTIItw=", "com.kingdee.eas.hr.ats.DataDumpFunction", operationName);
    }

    public void updateBackJobDefByDefId(Context ctx, String jobDefId, String userName, String funtionFullName) {
        if (!StringUtils.isEmpty((String)userName)) {
            String fcreateUserID = ctx.getCaller().toString();
            int i = funtionFullName.lastIndexOf(46);
            if (i < 0) {
                i = -1;
            }
            String mutex = "G::" + funtionFullName.substring(++i) + userName;
            try {
                String sql = " update  T_JOB_DEF  set fcreateUserID = '" + fcreateUserID + "'  ,fmutex = '" + mutex + "' where  fjobdefid = '" + jobDefId + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateBackJobDefByDefId(Context ctx, String jobDefId) {
        String fcreateUserID = null;
        if (ctx.getCaller() != null) {
            fcreateUserID = ctx.getCaller().toString();
        }
        if (fcreateUserID != null) {
            try {
                String sql = " update  T_JOB_DEF  set fcreateUserID = '" + fcreateUserID + "'  where  fjobdefid = '" + jobDefId + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateBackJobInstByDefId(Context ctx) {
        if (ctxCallerMap.size() > 300) {
            ctxCallerMap = null;
        }
        String fcreateUserID = null;
        String jobDefId = null;
        if (ctxCallerMap != null) {
            fcreateUserID = ctxCallerMap.get("createUserID" + ctx.getContextID());
            jobDefId = ctxCallerMap.get("jobDefId" + ctx.getContextID());
        }
        if (fcreateUserID != null && jobDefId != null) {
            try {
                String sql = " update  T_JOB_INST  set fuserid = '" + fcreateUserID + "'  where  fjobdefid = '" + jobDefId + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getBackJobInstCountByState(Context ctx) {
        int countinst = 0;
        try {
            String sql = " select COUNT(1) as countinst from T_JOB_INST  where  FJOBDEFID in (select FJOBDEFID from  T_JOB_def where FHANDLERWRAPPER LIKE 'function:com.kingdee.eas.hr.ats.DataDumpFunction-dataDump;%')  and (fstate ='Created' or fstate ='ReScheduled' or fstate ='Waiting' or fstate ='Ready' or fstate ='Running' )    ";
            IRowSet rowtemp = null;
            rowtemp = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowtemp.next()) {
                countinst = rowtemp.getInt("countinst");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return countinst;
    }

    public void deleteBackJobInstByState(Context ctx) {
        try {
            String sql = " delete from T_JOB_INST  where  FJOBDEFID in (select FJOBDEFID from  T_JOB_def where FHANDLERWRAPPER LIKE 'function:com.kingdee.eas.hr.ats.DataDumpFunction-dataDump;%')  and (fstate ='Suspended' or fstate ='Missed' or fstate ='Aborted') ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getSchedule(Date date) {
        Date dt = date;
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(this.getScheduleDate(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private String getScheduleDate(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    public String createJobDefCoreProcessV2(Context ctx, String jobTitle, Map jobContext, String categoryId, String functionName, String operationName) throws BOSException {
        FunctionWrapper.Parameter[] params = this.jobContextToParameter(ctx, jobContext, functionName, operationName);
        FunctionWrapper wrapper = new FunctionWrapper(functionName, operationName, params);
        JobDef jobDef = BackTransactionJobUtils.createJobDef(ctx, null, jobTitle, null, null, null, true, (Wrapper)wrapper);
        String jobProcessDefID = BackTransactionJobUtils.saveJobDef(ctx, jobDef);
        this.updateBackJobDefCategory(ctx, jobProcessDefID, categoryId);
        System.out.println("create DataDumpJob sucess,Job ID is :" + jobProcessDefID);
        return jobProcessDefID;
    }

    public FunctionWrapper.Parameter[] jobContextToParameter(Context ctx, Map jobContext, String functionName, String operationName) {
        OperationInfo operation = this.getOperation(MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)new MetaDataPK(functionName)), operationName);
        ParameterCollection coll = operation.getEntityMethodRef().getParameters();
        int size = coll.size();
        FunctionWrapper.Parameter[] params = new FunctionWrapper.Parameter[size];
        for (int i = 0; i < size; ++i) {
            String name = coll.get(i).getName();
            String value = jobContext.get(name) == null ? "" : jobContext.get(name).toString();
            String type = coll.get(i).getDataType().toUpperCase();
            if (type.equals("DATE")) {
                type = "DATETIME";
            }
            params[i] = new FunctionWrapper.Parameter(name, "", type, "", value, "");
        }
        return params;
    }

    public void updateBackJobDefCategory(Context ctx, String jobDefId, String categoryID) {
        try {
            String sql = " UPDATE T_JOB_DEF set fCategoryID = '" + categoryID + "' where fjobdefid = '" + jobDefId + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

