/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.Timing;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;

public class DBIndexReBuilder
extends AtsCtx {
    private String packages;
    private String tables;

    public String reBuildeIndex() {
        AtsLog.getLog().error((Object)"reindex start");
        if (this.ctx == null) {
            return "ctx is null";
        }
        StringBuffer msg = new StringBuffer();
        Timing timing = new Timing();
        List<String> reIndexTable = this.getReIndexTalbe();
        msg.append(timing.setPrefix(new StringBuffer("get reindex table:")));
        if (reIndexTable == null || reIndexTable.size() == 0) {
            msg.append("\r\nno table need reBuild index");
            return msg.toString();
        }
        String dbType = ContextUtil.getDbType((Context)this.ctx);
        if ("MS SQL Server".equalsIgnoreCase(dbType)) {
            this.reBuildeMSSQLIndex(msg, reIndexTable);
        }
        AtsLog.getLog().error((Object)"reindex complete");
        msg.append(timing.setPrefix(new StringBuffer("\r\nreindex total time:")));
        return msg.toString();
    }

    protected void reBuildeMSSQLIndex(StringBuffer msg, List<String> reIndexTable) {
        Timing releaseTiming = new Timing().setRecordStack(false);
        for (String table : reIndexTable) {
            try {
                DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ dbcc dbreindex (" + table + ")"));
                msg.append(releaseTiming.setPrefix(new StringBuffer("\r\nrebuild index success,cur table:").append(table)));
            }
            catch (BOSException e) {
                msg.append(releaseTiming.setPrefix(new StringBuffer("\r\nrebuild index error,cur table:").append(table).append("caused by ").append(e.getMessage())));
                AtsLog.getLog().error((Object)e);
            }
        }
    }

    private List<String> getReIndexTalbe() {
        if (StringUtils.isNotBlank((String)this.tables)) {
            return new ArrayList<String>(Arrays.asList(this.tables.split(",")));
        }
        ArrayList<String> packageList = new ArrayList<String>();
        if (StringUtils.isBlank((String)this.packages)) {
            this.packages = "com.kingdee.eas.hr.ats,com.kingdee.eas.hr.atsContrl";
        }
        List<String> configPackageList = Arrays.asList(this.packages.split(","));
        for (String pa : configPackageList) {
            packageList.add(pa + ".app");
            while (pa.contains(".")) {
                pa = pa.substring(0, pa.lastIndexOf("."));
                packageList.add(pa);
            }
        }
        IBriefViewTreeNode mdbView = null;
        try {
            Method getIBriefViewTreeNodeMethod = SubSystemUtils.class.getDeclaredMethod("getIBriefViewTreeNode", Context.class, MetaDataBriefViewFilter.class);
            Method getFilterByNameMethod = SubSystemUtils.class.getDeclaredMethod("getFilterByName", String.class);
            getIBriefViewTreeNodeMethod.setAccessible(true);
            getFilterByNameMethod.setAccessible(true);
            mdbView = (IBriefViewTreeNode)getIBriefViewTreeNodeMethod.invoke(null, this.ctx, getFilterByNameMethod.invoke(null, "com_kingdee_eas_base_subsystemEntity"));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        DefaultKingdeeTreeNode rootNode = mdbView == null ? null : SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)mdbView));
        ArrayList<String> reIndexTable = new ArrayList<String>();
        this.getReIndexTalbe(packageList, rootNode, reIndexTable);
        return reIndexTable;
    }

    private void getReIndexTalbe(List<String> packageList, DefaultKingdeeTreeNode rootNode, List<String> reIndexTable) {
        if (rootNode == null) {
            return;
        }
        Enumeration enumeration = rootNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
            if (briefInfo == null || !packageList.contains(briefInfo.getPackgeName())) continue;
            if (DefaultMutableTreeNode.EMPTY_ENUMERATION.equals(node.children())) {
                EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo((Context)this.ctx, (BOSObjectType)briefInfo.getBOType());
                DataTableInfo tableInfo = entityObjectInfo == null ? null : entityObjectInfo.getTable();
                if (tableInfo == null || !StringUtils.isNotBlank((String)tableInfo.getName())) continue;
                reIndexTable.add(tableInfo.getName());
                continue;
            }
            Enumeration enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                this.getReIndexTalbe(packageList, (DefaultKingdeeTreeNode)enumeration2.nextElement(), reIndexTable);
            }
        }
    }

    public String getTables() {
        return this.tables;
    }

    public void setTables(String tables) {
        this.tables = tables;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }
}

