/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class RuleFunctionService {
    public double FunLimitGetWorkAge(double type, String startDate, String endDate, Map paramMap) {
        double workAge = 0.0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date start = new Date();
            Date end = new Date();
            start = startDate == null || startDate.equals("") ? (Date)paramMap.get("workDate") : sdf.parse(startDate);
            if (endDate != null && !endDate.equals("")) {
                end = sdf.parse(endDate);
            }
            if (type == 1.0) {
                double startYear = start.getYear();
                double endYear = end.getYear();
                workAge = endYear - startYear + 1.0;
            } else if (type == 2.0) {
                double startYear = start.getYear();
                double endYear = end.getYear();
                double startMonth = start.getMonth();
                double endMonth = end.getMonth();
                BigDecimal bigDecimal = BigDecimal.valueOf(((endYear - startYear) * 12.0 + (endMonth - startMonth) + 1.0) / 12.0);
                workAge = bigDecimal.setScale(8, 4).doubleValue();
            } else {
                long daysTimes = end.getTime() - start.getTime();
                workAge = new BigDecimal(daysTimes).divide(new BigDecimal(31536000000L), 8, 4).doubleValue();
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        return workAge < 0.0 ? 0.0 : workAge;
    }

    public double FunLimitGetJoinCompanyAge(double type, String startDate, String endDate, Map paramMap) {
        double joinCompanyAge = 0.0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date start = new Date();
            Date end = new Date();
            start = startDate == null || startDate.equals("") ? (Date)paramMap.get("joinCompanyDate") : sdf.parse(startDate);
            if (endDate != null && !endDate.equals("")) {
                end = sdf.parse(endDate);
            }
            if (type == 1.0) {
                double startYear = start.getYear();
                double endYear = end.getYear();
                joinCompanyAge = endYear - startYear + 1.0;
            } else if (type == 2.0) {
                double startYear = start.getYear();
                double endYear = end.getYear();
                double startMonth = start.getMonth();
                double endMonth = end.getMonth();
                BigDecimal bigDecimal = BigDecimal.valueOf(((endYear - startYear) * 12.0 + (endMonth - startMonth) + 1.0) / 12.0);
                joinCompanyAge = bigDecimal.setScale(2, 4).doubleValue();
            } else {
                long daysTimes = end.getTime() - start.getTime();
                joinCompanyAge = new BigDecimal(daysTimes).divide(new BigDecimal(31536000000L), 8, 4).doubleValue();
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        return joinCompanyAge < 0.0 ? 0.0 : joinCompanyAge;
    }
}

