/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.ChangeTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.IHolidayLimitDetail;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.holidayLimit.AbstractBaseDeductLimit;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.AtsLockUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsLeaveBillLimit;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CoreBaseDeductHolidayLimit
extends AbstractBaseDeductLimit {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.holidayLimit.CoreBaseDeductHolidayLimit");
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();

    public CoreBaseDeductHolidayLimit(Context ctx, String billId, int changeType) throws EASBizException, BOSException {
        super(ctx, billId, changeType);
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public CoreBaseDeductHolidayLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, int changeType) throws EASBizException, BOSException {
        super(ctx, atsLeaveBillInfo, changeType);
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    @Override
    public void coreBaseBeforeDeductLimit(final Context ctx, final AtsLeaveBillInfo atsLeaveBillInfo, final int changType) throws EASBizException, BOSException {
        String billId = atsLeaveBillInfo.getId().toString();
        AtsLockUtil.executeWithBlock(ctx, billId, new Runnable(){

            @Override
            public void run() {
                try {
                    int size = atsLeaveBillInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillInfo.getEntries().get(i);
                        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                        HolidayPolicyInfo policyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
                        if (!policyInfo.isIsCtrlLimit()) continue;
                        HashMap<String, Object> billInfoMap = new HashMap<String, Object>();
                        billInfoMap.put("billInfo", atsLeaveBillInfo);
                        billInfoMap.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                        billInfoMap.put("policyInfo", policyInfo);
                        CoreBaseDeductHolidayLimit.this.updateHolidayLimitBysubmitEffect(ctx, billInfoMap, changType);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
    }

    public void operatorPreOverdraftLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, AtsLeaveBillEntryInfo billEntryInfo, HolidayPolicyInfo holidayPolicyInfo, HolidayLimitInfo holidayLimitInfo, Map mapBalance, HolidayLimitCollection allHolidayLimitCollection, String personId, CoreBaseCollection holidayLimitcolls, CoreBaseCollection holidayLimitDetailcolls) throws BOSException, EASBizException {
        HashMap<String, Object> nextmapBalance;
        BigDecimal preOverdraftLimit;
        logger.info((Object)"next cycle limit deduct start... ");
        String billId = (String)mapBalance.get("billId");
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        BigDecimal changeValue = (BigDecimal)mapBalance.get("changeValue");
        allHolidayLimitCollection.sort("cyclebegindate");
        allHolidayLimitCollection.sort("delaydate");
        HolidayLimitInfo nextholidayLimitInfo = null;
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        for (int i = 0; i < allHolidayLimitCollection.size(); ++i) {
            if (!holidayLimitInfo.getId().equals((Object)allHolidayLimitCollection.get(i).getId()) || i == allHolidayLimitCollection.size() - 1) continue;
            nextholidayLimitInfo = allHolidayLimitCollection.get(i + 1);
        }
        if (holidayPolicyInfo != null && nextholidayLimitInfo == null && holidayPolicyInfo.isIsOver() && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
            BigDecimal temp = BigDecimal.valueOf(-1L);
            preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
            if (preOverdraftLimit.compareTo(changeValue) == 1) {
                preOverdraftLimit = changeValue;
            }
            nextmapBalance = new HashMap<String, Object>();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
            nextmapBalance.put("holidayLimitId", holidayLimitId);
            nextmapBalance.put("changeValue", preOverdraftLimit);
            nextmapBalance.put("personId", personId);
            nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, atsLeaveBillInfo, billEntryInfo, nextmapBalance, HolidayLimitChangeType.overdraft, personPositionInfo);
            holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
        }
        if (holidayPolicyInfo != null && nextholidayLimitInfo != null && holidayPolicyInfo.isIsOver()) {
            if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
                BigDecimal temp = BigDecimal.valueOf(-1L);
                preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
                if (preOverdraftLimit.compareTo(changeValue) == 1) {
                    preOverdraftLimit = changeValue;
                }
                nextmapBalance = new HashMap();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance.put("preOverdraftLimit", preOverdraftLimit);
                nextmapBalance.put("remainLimit", preOverdraftLimit);
                preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
                nextmapBalance.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance.put("changeValue", preOverdraftLimit);
                nextmapBalance.put("personId", personId);
                nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    BigDecimal overdraftLimit_bg = nextholidayLimitInfo.getPreOverdraftLimit().add(preOverdraftLimit);
                    nextholidayLimitInfo.setPreOverdraftLimit(overdraftLimit_bg);
                    BigDecimal remainLimit_bg = nextholidayLimitInfo.getRealLimit().subtract(nextholidayLimitInfo.getUsedLimit()).subtract(nextholidayLimitInfo.getFreezeLimit()).subtract(nextholidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    nextholidayLimitInfo.setRemainLimit(remainLimit_bg);
                    holidayLimitcolls.add((CoreBaseInfo)nextholidayLimitInfo);
                }
                HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, atsLeaveBillInfo, billEntryInfo, mapBalance, HolidayLimitChangeType.overdraft, personPositionInfo);
                holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
            } else {
                BigDecimal preOverdraftLimit2 = BigDecimal.valueOf(0L);
                HashMap<String, Object> nextmapBalance2 = new HashMap<String, Object>();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance2.put("preOverdraftLimit", preOverdraftLimit2);
                nextmapBalance2.put("remainLimit", preOverdraftLimit2);
                preOverdraftLimit2 = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit2, RoundingMode.HALF_UP);
                nextmapBalance2.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance2.put("changeValue", preOverdraftLimit2);
                nextmapBalance2.put("personId", personId);
                nextmapBalance2.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    BigDecimal overdraftLimit_bg = nextholidayLimitInfo.getPreOverdraftLimit().add(preOverdraftLimit2);
                    nextholidayLimitInfo.setPreOverdraftLimit(overdraftLimit_bg);
                    BigDecimal remainLimit_bg = nextholidayLimitInfo.getRealLimit().subtract(nextholidayLimitInfo.getUsedLimit()).subtract(nextholidayLimitInfo.getFreezeLimit()).subtract(nextholidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    nextholidayLimitInfo.setRemainLimit(remainLimit_bg);
                    holidayLimitcolls.add((CoreBaseInfo)nextholidayLimitInfo);
                    this.updateDataInfoToHolildayLimitDetail(ctx, nextmapBalance2, billId, HolidayLimitChangeType.overdraft);
                }
            }
        }
        logger.info((Object)"next cycle limit deduct end... ");
    }

    protected int updateDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, String billId, HolidayLimitChangeType holidayLimitChangeType) {
        int res = 0;
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailCollection holidayLimitDetailCollection = new HolidayLimitDetailCollection();
        try {
            holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" where holidayLimit='" + holidayLimitId + "' and changeType='" + holidayLimitChangeType.getValue() + "' and changeValue != '" + BigDecimal.valueOf(0L) + "' ");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (holidayLimitDetailCollection != null && holidayLimitDetailCollection.size() > 0) {
            holidayLimitDetailCollection.sort("createTime");
            HolidayLimitDetailInfo detailInfo = holidayLimitDetailCollection.get(0);
            detailInfo.setChangeDate(AtsDateUtils.dateToTimestamp(new Date()));
            detailInfo.setChangeValue(detailInfo.getChangeValue().subtract((BigDecimal)mapBalance.get("changeValue")));
            colls.add((CoreBaseInfo)detailInfo);
            try {
                HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
                holidayLimitDetailControllerBean.update(ctx, colls);
                res = 1;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public void updateHolidayLimitBysubmitEffectBak(Context ctx, Map<String, Object> billInfoMap, int changType) throws EASBizException, BOSException {
        logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)billInfoMap.get("policyInfo");
        BigDecimal leaveLength = atsLeaveBillEntryInfo.getRealLeaveLength();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        Timestamp startTime = atsLeaveBillEntryInfo.getRealBeginTime();
        Timestamp endTime = atsLeaveBillEntryInfo.getRealEndTime();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        String hrOrgUnitId = billInfo.getHrOrgUnit().getId().toString();
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'");
        HashMap holidayLimitCollresMap = new HashMap();
        HolidayLimitCollection holidayLimitCollection = null;
        holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionReturn"));
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        CoreBaseCollection holidayLimitcolls = new CoreBaseCollection();
        CoreBaseCollection holidayLimitDetailcolls = new CoreBaseCollection();
        if (holidayLimitCollection == null || holidayLimitCollection.isEmpty()) {
            HashMap<String, Object> mapBalance = new HashMap<String, Object>();
            mapBalance.put("changeValue", leaveLength);
            mapBalance.put("personId", personId);
            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, atsLeaveBillEntryInfo, mapBalance, HolidayLimitChangeType.getEnum(changType), personPositionInfo);
            holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
            IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            iHolidayLimitDetail.addnew(holidayLimitDetailcolls);
            return;
        }
        holidayLimitCollection.sort("cyclebegindate");
        holidayLimitCollection.sort("delaydate");
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
            String holidayLimitId = holidayLimitInfo.getId().toString();
            BigDecimal leaveLengthTemp = new BigDecimal(0);
            if (leaveLength.compareTo(BigDecimal.ZERO) != -1) {
                if (i == holidayLimitCollection.size() - 1) {
                    leaveLengthTemp = leaveLength;
                } else if (leaveLength.compareTo(holidayLimitInfo.getRemainLimit()) == 1) {
                    if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == 1) {
                        leaveLengthTemp = holidayLimitInfo.getRemainLimit();
                    }
                } else {
                    leaveLengthTemp = leaveLength;
                }
                if (leaveLengthTemp.compareTo(BigDecimal.ZERO) == 1) {
                    HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfo.getId().toString());
                    if (4 == changType) {
                        BigDecimal usedLimit_bg = holidayLimitInfo.getUsedLimit().add(leaveLengthTemp);
                        holidayLimitInfo.setUsedLimit(usedLimit_bg);
                    } else if (6 == changType) {
                        BigDecimal freezeLimi_bg = holidayLimitInfo.getFreezeLimit().add(leaveLengthTemp);
                        holidayLimitInfo.setFreezeLimit(freezeLimi_bg);
                    }
                    BigDecimal remainLimit_bg = holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()).subtract(holidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    holidayLimitInfo.setRemainLimit(remainLimit_bg);
                    HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, atsLeaveBillEntryInfo, mapBalance, HolidayLimitChangeType.getEnum(changType), personPositionInfo);
                    holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
                    this.operatorPreOverdraftLimit(ctx, billInfo, atsLeaveBillEntryInfo, holidayPolicyInfo, holidayLimitInfo, mapBalance, allHolidayLimitCollection, personId, holidayLimitcolls, holidayLimitDetailcolls);
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                }
            }
            holidayLimitcolls.add((CoreBaseInfo)holidayLimitInfo);
        }
        if (holidayLimitcolls.size() > 0) {
            IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
            iHolidayLimit.update(holidayLimitcolls);
        }
        if (holidayLimitDetailcolls.size() > 0) {
            IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            iHolidayLimitDetail.addnew(holidayLimitDetailcolls);
        }
        logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
    }

    public void updateHolidayLimitBysubmitEffect(Context ctx, Map<String, Object> billInfoMap, int changType) throws EASBizException, BOSException {
        logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)billInfoMap.get("policyInfo");
        BigDecimal billLeaveLength = atsLeaveBillEntryInfo.getRealLeaveLength();
        BigDecimal leaveLength = atsLeaveBillEntryInfo.getRealLeaveLength();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        Timestamp startTime = atsLeaveBillEntryInfo.getRealBeginTime();
        Timestamp endTime = atsLeaveBillEntryInfo.getRealEndTime();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        String hrOrgUnitId = billInfo.getHrOrgUnit().getId().toString();
        String billid = billInfo.getId().toString();
        Object _operAction = ctx.get((Object)(billid.toString() + "_OperAction"));
        if (_operAction != null && (_operAction == "approved" || _operAction == "schedualRecalculate")) {
            holidayPolicyInfo.setIsOver(true);
        }
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "' and hrOrgUnit.id = '" + hrOrgUnitId + "'");
        Map holidayLimitCollresMap = new HashMap();
        List<Object> holidayLimitCollresMapList = new ArrayList();
        try {
            boolean isElasticCalLen = atsLeaveBillEntryInfo.isIsElasticCalLen();
            holidayLimitCollresMapList = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTimeNew(ctx, allHolidayLimitCollection, startTime, endTime, hrOrgUnitId, personId, holidayTypeId, holidayPolicyInfo, isElasticCalLen, leaveLength, 0.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CoreBaseCollection oldLimitColl = new CoreBaseCollection();
        CoreBaseCollection holidayLimitcolls = new CoreBaseCollection();
        CoreBaseCollection holidayLimitDetailcolls = new CoreBaseCollection();
        HolidayLimitCollection shiftLimitHolidayLimitCollection = new HolidayLimitCollection();
        for (int resMapListIndex = 0; resMapListIndex < holidayLimitCollresMapList.size(); ++resMapListIndex) {
            holidayLimitCollresMap = (Map)holidayLimitCollresMapList.get(resMapListIndex);
            HolidayLimitCollection holidayLimitCollection = null;
            holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionSplit"));
            leaveLength = BigDecimal.valueOf((Double)holidayLimitCollresMap.get("leaveLengthWhole"));
            PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
            if (leaveLength.compareTo(BigDecimal.ZERO) <= 0 || billLeaveLength.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (leaveLength.compareTo(billLeaveLength) > 0) {
                leaveLength = billLeaveLength;
                billLeaveLength = new BigDecimal(0);
            } else {
                billLeaveLength = billLeaveLength.subtract(leaveLength);
            }
            if (holidayLimitCollection == null || holidayLimitCollection.isEmpty()) {
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                mapBalance.put("changeValue", leaveLength);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, atsLeaveBillEntryInfo, mapBalance, HolidayLimitChangeType.getEnum(changType), personPositionInfo);
                holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
                IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
                iHolidayLimitDetail.addnew(holidayLimitDetailcolls);
                return;
            }
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
                oldLimitColl.add((CoreBaseInfo)((HolidayLimitInfo)holidayLimitInfo.clone()));
                String holidayLimitId = holidayLimitInfo.getId().toString();
                BigDecimal leaveLengthTemp = new BigDecimal(0);
                if (leaveLength.compareTo(BigDecimal.ZERO) != -1) {
                    if (i == holidayLimitCollection.size() - 1) {
                        leaveLengthTemp = leaveLength;
                    } else if (leaveLength.compareTo(holidayLimitInfo.getRemainLimit()) == 1) {
                        if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == 1) {
                            leaveLengthTemp = holidayLimitInfo.getRemainLimit();
                        }
                    } else {
                        leaveLengthTemp = leaveLength;
                    }
                    if (leaveLengthTemp.compareTo(BigDecimal.ZERO) == 1) {
                        HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                        leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                        mapBalance.put("usedLimit", leaveLengthTemp);
                        mapBalance.put("holidayLimitId", holidayLimitId);
                        mapBalance.put("changeValue", leaveLengthTemp);
                        mapBalance.put("personId", personId);
                        mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                        mapBalance.put("billId", billInfo.getId().toString());
                        String cancelBillId = billInfo.getString("cancelBillId") == null ? "" : billInfo.getString("cancelBillId");
                        mapBalance.put("cancelBillId", cancelBillId);
                        if (4 == changType) {
                            BigDecimal usedLimit_bg = holidayLimitInfo.getUsedLimit().add(leaveLengthTemp);
                            holidayLimitInfo.setUsedLimit(this.decimalPlacesSystem.precisionConvert(ctx, usedLimit_bg, RoundingMode.HALF_UP));
                        } else if (6 == changType) {
                            BigDecimal freezeLimi_bg = holidayLimitInfo.getFreezeLimit().add(leaveLengthTemp);
                            holidayLimitInfo.setFreezeLimit(this.decimalPlacesSystem.precisionConvert(ctx, freezeLimi_bg, RoundingMode.HALF_UP));
                        }
                        BigDecimal remainLimit_bg = holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()).subtract(holidayLimitInfo.getPreOverdraftLimit());
                        remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                        holidayLimitInfo.setRemainLimit(remainLimit_bg);
                        HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, atsLeaveBillEntryInfo, mapBalance, HolidayLimitChangeType.getEnum(changType), personPositionInfo);
                        holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
                        this.operatorPreOverdraftLimit(ctx, billInfo, atsLeaveBillEntryInfo, holidayPolicyInfo, holidayLimitInfo, mapBalance, allHolidayLimitCollection, personId, holidayLimitcolls, holidayLimitDetailcolls);
                        leaveLength = leaveLength.subtract(leaveLengthTemp);
                    }
                }
                holidayLimitcolls.add((CoreBaseInfo)holidayLimitInfo);
                shiftLimitHolidayLimitCollection.add(holidayLimitInfo);
            }
        }
        GenHolidayLimitManager genHolidayLimitManager = new GenHolidayLimitManager();
        genHolidayLimitManager.addShiftTotalRemainLimit(shiftLimitHolidayLimitCollection, (boolean)Boolean.TRUE, ctx);
        if (holidayLimitcolls.size() > 0) {
            AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
            limit.recordHolidayLimit(ctx, holidayLimitcolls, ChangeTypeEnum.billUpdate, billInfo.getNumber());
            IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
            iHolidayLimit.update(holidayLimitcolls);
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            DataLogUtil.addLogObserverToCenter(ctx, billInfo, atsLeaveBillEntryInfo, logControlCenter, oldLimitColl, false);
            DataLogUtil.addLogObserverToCenter(ctx, billInfo, atsLeaveBillEntryInfo, logControlCenter, holidayLimitcolls, true);
        }
        if (holidayLimitDetailcolls.size() > 0) {
            IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            iHolidayLimitDetail.addnew(holidayLimitDetailcolls);
        }
        logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
    }
}

