/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttencePolicyInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemFactory;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.BillSubmitTypeEnum;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.OverTimeCompensCollection;
import com.kingdee.eas.hr.ats.OverTimeCompensFactory;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.OverTimeCreateTag;
import com.kingdee.eas.hr.ats.OverTimeTypeFactory;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillHelper;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.DateTimeUtils;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.atsContrl.util.AtsControlLimitBean;
import com.kingdee.eas.hr.atsContrl.util.AtsControlServerUtil;
import com.kingdee.eas.hr.atsContrl.util.AttendContrlServerConstant;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsOverTimeBillEditHandler {
    public String validOtStartAction(Context ctx, String personId, String applyOtTime) throws BOSException {
        AttendanceFileCollection fileCol = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("select * ,attencePolicy.* where proposer.id='" + personId + "' and attendFileState='1' ");
        BigDecimal otStart = new BigDecimal(fileCol.get(0).getAttencePolicy().getOtStart()).divide(new BigDecimal(60), 2, 4);
        String errorMsg = "";
        if (new BigDecimal(applyOtTime).compareTo(otStart) == -1) {
            errorMsg = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.UntouchLowestValueMin, ctx, "", fileCol.get(0).getAttencePolicy().getOtStart()) + "\uff01";
        }
        return errorMsg;
    }

    public static boolean isPunchcard(Context ctx, String personId, String overDate) throws BOSException {
        HashMap res = new HashMap();
        Boolean isPunchcard = true;
        AttendanceFileHISCollection atsFileHisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(" where proposer.id = '" + personId + "'  and effdt <= '" + HRTimeWebUtils.timestampToDate(HRTimeWebUtils.stringShortToTimestamp(overDate)) + "' and leffdt >= '" + HRTimeWebUtils.timestampToDate(HRTimeWebUtils.stringShortToTimestamp(overDate)) + "'");
        if (atsFileHisColl != null && atsFileHisColl.size() >= 1 && atsFileHisColl.get(0).getIsAttendance().getValue().equals("0")) {
            isPunchcard = false;
        }
        return isPunchcard;
    }

    public static Map<String, Object> isWorkTime(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Boolean isWorkTime = false;
        if (AtsOverTimeBillEditHandler.isPunchcard(ctx, personId, overDate)) {
            Map<String, ScheduleShiftInfo> scheduleShiftColl;
            if (overTimeBegin.trim().length() != 19) {
                overTimeBegin = overTimeBegin.substring(0, 19);
            }
            if (overTimeEnd.trim().length() != 19) {
                overTimeEnd = overTimeEnd.substring(0, 19);
            }
            String otDate = AtsDateUtils.tsDateStr(overDate);
            String beginDate = AtsDateUtils.tsDateStr(overTimeBegin);
            String endDate = AtsDateUtils.tsDateStr(overTimeEnd);
            Timestamp overTimeBeginTS = HRTimeWebUtils.stringToTimestamp(overTimeBegin);
            Timestamp overTimeEndTS = HRTimeWebUtils.stringToTimestamp(overTimeEnd);
            if (otDate.compareTo(endDate) == -1) {
                beginDate = otDate;
            }
            if (otDate.compareTo(endDate) == 1) {
                endDate = otDate;
            }
            if (null != (scheduleShiftColl = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, beginDate, endDate))) {
                int shiftSize = scheduleShiftColl.size();
                for (int k = 0; k < shiftSize; ++k) {
                    ScheduleShiftInfo scheduleShiftInfo = scheduleShiftColl.get(k);
                    if (null == scheduleShiftInfo) continue;
                    ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
                    for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                        int dayType;
                        if (!scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("1") && !scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("3") || 0 != (dayType = scheduleShiftInfo.getDayType().getValue())) continue;
                        if (scheduleShiftItemColl.get(i).getPreDateTime() == null || scheduleShiftItemColl.get(i).getNextDateTime() == null) {
                            isWorkTime = true;
                            continue;
                        }
                        if (scheduleShiftItemColl.get(i).getPreDateTime().compareTo(overTimeEndTS) != -1 || scheduleShiftItemColl.get(i).getNextDateTime().compareTo(overTimeBeginTS) != 1) continue;
                        isWorkTime = true;
                    }
                }
            }
        }
        res.put("isWorkTime", isWorkTime);
        return res;
    }

    public Map<String, Object> getAttencePolicyStrMsgAction(Context ctx, String personId, String theDate, String fieldNames) throws BOSException, EASBizException {
        return AttencePolicyFillUtil.getAttencePolicyMsg(ctx, personId, theDate, fieldNames);
    }

    public String checkDuplicate(Context ctx, String realEndTime, String realStartTime, String personId) throws HRCommonException {
        StringBuilder ksqlSB = new StringBuilder();
        String billStateString = "0,1,2,3";
        ksqlSB.append(" select m.fid,m.fnumber,m.fbillstate,e.fstarttime,e.fendtime,e.fpersonid,p.fname" + MLUtile.getMlFlag(ctx) + " name,e.FCREATETAG \n").append("   from T_HR_ATS_OverTimeBillEntry e  \n").append("   inner join T_HR_ATS_OverTimeBill m on  e.fbillid=m.fid  \n").append("   left join T_BD_Person p on e.fpersonid= p.fid \n").append("   where  \n").append("   m.fbillstate in (" + billStateString + ") \n").append("   and e.FCREATETAG !='2' ").append("   and ( \n").append("   ( e.fstarttime<=? and e.fendtime>=? and e.fpersonid=? )      \n").append("   ) \n");
        String errorMsg = "";
        try {
            Object[] params = new Object[]{HRTimeWebUtils.stringToTimestamp(realEndTime), HRTimeWebUtils.stringToTimestamp(realStartTime), personId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlSB.toString(), (Object[])params);
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    errorMsg = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.ExistsOverlapTimeInOTBill, ctx, rs.getString("fnumber"), rs.getString("name") + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fstarttime")) + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fendtime")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return errorMsg;
        }
        return errorMsg;
    }

    public Map<String, Object> getOverTimeType(Context ctx, String personId, String otDate) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (personId != null && !"".equals(personId) && otDate != null && !"".equals(otDate)) {
            try {
                ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, otDate);
                if (null != scheduleShiftInfo) {
                    DayTypeEnum dayTypeEnum = scheduleShiftInfo.getDayType();
                    int dayType = dayTypeEnum.getValue();
                    if (dayType == 1) {
                        res.put("otTypeValue", "zr+ur5D4RA+2bdVZ2VPqp46C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnHoliday, ctx));
                    } else if (dayType == 2) {
                        res.put("otTypeValue", "sRWUOt7sRpOY0TCo6NMqGY6C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnLegalHoliday, ctx));
                    } else {
                        res.put("otTypeValue", "rBy0u1YgQ9C1OxcM85mxyY6C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.OTOnWorkday, ctx));
                    }
                } else {
                    StringBuilder sqlSb = new StringBuilder();
                    sqlSb.append("      select attfile.fattendcenterid,attfile.fattencepolicyid,policy.FWORKCALENDARID,attwork.fbegindate,attwork.fenddate ,item.fdate,item.fdaytype \n").append("        from T_HR_ATS_AttendanceFile attfile \n").append("  inner join  t_hr_ats_attencepolicy policy on policy.fid = attfile.fattencepolicyid \n").append("  inner join  t_hr_ats_workcalendar attwork on attwork.fid = policy.FWORKCALENDARID \n").append("  inner join  t_hr_ats_workcalendaritem item on item.fcalendargroupid = attwork.fid \n").append("       where attfile.fproposerid = '" + personId + "' and attfile.FATTENDFILESTATE = '" + "1" + "' \n").append("         and  item.fdate ={ts '" + otDate + "'}  \n");
                    IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlSb.toString());
                    int dayType = -9;
                    if (rowset.next()) {
                        dayType = rowset.getInt("fdaytype");
                    }
                    if (dayType == 1) {
                        res.put("otTypeValue", "zr+ur5D4RA+2bdVZ2VPqp46C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnHoliday, ctx));
                    } else if (dayType == 2) {
                        res.put("otTypeValue", "sRWUOt7sRpOY0TCo6NMqGY6C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.WorkOnLegalHoliday, ctx));
                    } else {
                        res.put("otTypeValue", "rBy0u1YgQ9C1OxcM85mxyY6C/nU=");
                        res.put("otTypeText", MLUtile.getRes(AtsOverTimeBillResEnum.OTOnWorkday, ctx));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public long getOTRestTime(Context ctx, String personId, String monthLimitDay, String startTime, String endTime) throws BOSException {
        long restTimeStr = 0L;
        List<Object> shiftList = new ArrayList();
        shiftList = this.getMyScheduleShiftInfo(ctx, personId, monthLimitDay);
        if (shiftList.size() == 0) {
            shiftList = this.getDefaultShiftItem(ctx, personId, monthLimitDay);
        }
        if (startTime.trim().length() == 16) {
            startTime = startTime + ":00";
        }
        if (endTime.trim().length() == 16) {
            endTime = endTime + ":00";
        }
        Timestamp onStartTime = AtsDateUtils.stringToTimestamp(startTime);
        Timestamp onEndTime = AtsDateUtils.stringToTimestamp(endTime);
        Timestamp tempTime = null;
        for (int i = 0; i < shiftList.size(); ++i) {
            Map mapTime = (Map)shiftList.get(i);
            String segbegStr = (String)mapTime.get("beginTime");
            String segEndStr = (String)mapTime.get("endTime");
            String restbeginTimeStr = (String)mapTime.get("restbeginTime");
            String restendTimeStr = (String)mapTime.get("restendTime");
            Timestamp restbeginTime = null;
            Timestamp restendTime = null;
            if (StringUtils.isNotBlank((String)restbeginTimeStr)) {
                restbeginTime = AtsDateUtils.stringToTimestamp(restbeginTimeStr);
            }
            if (StringUtils.isNotBlank((String)restendTimeStr)) {
                restendTime = AtsDateUtils.stringToTimestamp(restendTimeStr);
            }
            Timestamp segbegTime = AtsDateUtils.stringToTimestamp(segbegStr);
            Timestamp segEndTime = AtsDateUtils.stringToTimestamp(segEndStr);
            String dayType = (String)mapTime.get("dayType");
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)dayType) && dayType.equals("0") && null != restbeginTime && null != restendTime && onStartTime.compareTo(restbeginTime) <= 0 && onEndTime.compareTo(restendTime) <= 0) {
                restTimeStr = 0L;
                return restTimeStr;
            }
            if (i == 0) {
                if (shiftList.size() == 1 && restbeginTime != null && restendTime != null) {
                    restTimeStr = (long)AtsServerUtils.getTwoDateTimesDiff(onStartTime, onEndTime, restbeginTime, restendTime);
                }
            } else {
                if (tempTime.getTime() <= onStartTime.getTime() && segbegTime.getTime() >= onEndTime.getTime() || segbegTime.getTime() <= onStartTime.getTime() && segEndTime.getTime() >= onEndTime.getTime()) break;
                if (onStartTime.getTime() >= tempTime.getTime() && onStartTime.getTime() <= segbegTime.getTime() && onEndTime.getTime() <= segEndTime.getTime()) {
                    restTimeStr = (long)((double)restTimeStr + AtsDateUtils.getTwoTimeDiffMinutes(onStartTime, segbegTime));
                    break;
                }
                if (onStartTime.getTime() >= tempTime.getTime() && onStartTime.getTime() <= segbegTime.getTime() && onEndTime.getTime() > segEndTime.getTime()) {
                    restTimeStr = (long)((double)restTimeStr + AtsDateUtils.getTwoTimeDiffMinutes(onStartTime, segbegTime));
                } else {
                    if (onStartTime.getTime() <= tempTime.getTime() && onEndTime.getTime() <= segbegTime.getTime()) {
                        restTimeStr = (long)((double)restTimeStr + AtsDateUtils.getTwoTimeDiffMinutes(tempTime, onEndTime));
                        break;
                    }
                    if (onStartTime.getTime() <= tempTime.getTime() && onEndTime.getTime() > segbegTime.getTime() && onEndTime.getTime() <= segEndTime.getTime()) {
                        restTimeStr = (long)((double)restTimeStr + AtsDateUtils.getTwoTimeDiffMinutes(tempTime, segbegTime));
                        break;
                    }
                    if (onStartTime.getTime() <= tempTime.getTime() && onEndTime.getTime() > segbegTime.getTime() && onEndTime.getTime() > segEndTime.getTime()) {
                        restTimeStr = (long)((double)restTimeStr + AtsDateUtils.getTwoTimeDiffMinutes(tempTime, segbegTime));
                    }
                }
            }
            tempTime = segEndTime;
        }
        return restTimeStr;
    }

    public List<HashMap<String, String>> getMyScheduleShiftInfo(Context ctx, String personId, String monthLimitDay) throws BOSException {
        ArrayList<HashMap<String, String>> shiftList = new ArrayList<HashMap<String, String>>();
        Date currentDate = AtsDateUtils.stringToShortDate(monthLimitDay);
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, monthLimitDay);
        if (null != scheduleShiftInfo) {
            ScheduleShiftItemCollection coll = scheduleShiftInfo.getItems();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                HashMap<String, String> dateMap = new HashMap<String, String>();
                String dt = null;
                String et = null;
                String restbeginTime = null;
                String restendTime = null;
                ScheduleShiftItemInfo itemInfo = coll.get(i);
                Date preDate = AtsDateUtils.getPreDay(currentDate);
                Date temp = AtsDateUtils.getNextDay(currentDate);
                if (itemInfo.getPreTimeDayType().getValue() == 0) {
                    dt = AtsDateUtils.dateShortToString(preDate) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 1) {
                    dt = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 2) {
                    dt = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 0) {
                    et = AtsDateUtils.dateShortToString(preDate) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 1) {
                    et = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 2) {
                    et = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getRestPreDateTime() != null) {
                    restbeginTime = AtsDateUtils.timestampToString(itemInfo.getRestPreDateTime());
                }
                if (itemInfo.getRestNextDateTime() != null) {
                    restendTime = AtsDateUtils.timestampToString(itemInfo.getRestNextDateTime());
                }
                dateMap.put("beginTime", dt);
                dateMap.put("endTime", et);
                dateMap.put("restbeginTime", restbeginTime);
                dateMap.put("restendTime", restendTime);
                dateMap.put("dayType", scheduleShiftInfo.getDayType().getValue() + "");
                shiftList.add(dateMap);
            }
        }
        return shiftList;
    }

    public List<HashMap<String, String>> getDefaultShiftItem(Context ctx, String personId, String tDay) throws BOSException {
        ArrayList<HashMap<String, String>> shiftList = new ArrayList<HashMap<String, String>>();
        String shiftId = "";
        AttendanceFileCollection fileCol = AtsWebUtils.getAttendanceFileByPersonId(ctx, personId);
        if (fileCol.size() > 0 && fileCol.get(0).getAtsShift() != null) {
            shiftId = fileCol.get(0).getAtsShift().getId().toString();
            Date currentDate = AtsDateUtils.stringToShortDate(tDay);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("segment"));
            sic.add(new SelectorItemInfo("preTime"));
            sic.add(new SelectorItemInfo("nextTime"));
            sic.add(new SelectorItemInfo("preTimeDayType"));
            sic.add(new SelectorItemInfo("nextTimeDayType"));
            sic.add(new SelectorItemInfo("restPreTime"));
            sic.add(new SelectorItemInfo("restNextTime"));
            sic.add(new SelectorItemInfo("restPreDateTime"));
            sic.add(new SelectorItemInfo("restNextDateTime"));
            entityViewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)shiftId));
            entityViewInfo.setFilter(filterInfo);
            SorterItemCollection sorterItemCollection = entityViewInfo.getSorter() != null ? entityViewInfo.getSorter() : new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("segment");
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemCollection.add(sorterItemInfo);
            entityViewInfo.setSorter(sorterItemCollection);
            AtsShiftItemCollection items = AtsShiftItemFactory.getLocalInstance(ctx).getAtsShiftItemCollection(entityViewInfo);
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                int prestrvalue;
                int restEndValue;
                int restStartValue;
                String prestr;
                String restendstr;
                String reststartstr;
                HashMap<String, String> dateMap = new HashMap<String, String>();
                String dt = null;
                String et = null;
                String restbeginTime = null;
                String restendTime = null;
                AtsShiftItemInfo itemInfo = items.get(i);
                Date temppre = AtsDateUtils.getPreDay(currentDate);
                Date temp = AtsDateUtils.getNextDay(currentDate);
                Date temp2 = AtsDateUtils.getNextDay(currentDate, 2);
                if (itemInfo.getPreTimeDayType().getValue() == 0) {
                    dt = AtsDateUtils.dateShortToString(temppre) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 1) {
                    dt = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 2) {
                    dt = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 0) {
                    et = AtsDateUtils.dateShortToString(temppre) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 1) {
                    et = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 2) {
                    et = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 0 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime()) && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                    reststartstr = itemInfo.getRestPreTime().substring(0, 2);
                    restendstr = itemInfo.getRestNextTime().substring(0, 2);
                    prestr = itemInfo.getPreTime().substring(0, 2);
                    restStartValue = new BigDecimal(reststartstr).intValue();
                    restEndValue = new BigDecimal(restendstr).intValue();
                    prestrvalue = new BigDecimal(prestr).intValue();
                    if (restStartValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restEndValue > prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temppre) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temppre) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restStartValue > prestrvalue && restEndValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temppre) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                    }
                }
                if (itemInfo.getPreTimeDayType().getValue() == 1 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime()) && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                    reststartstr = itemInfo.getRestPreTime().substring(0, 2);
                    restendstr = itemInfo.getRestNextTime().substring(0, 2);
                    prestr = itemInfo.getPreTime().substring(0, 2);
                    restStartValue = new BigDecimal(reststartstr).intValue();
                    restEndValue = new BigDecimal(restendstr).intValue();
                    prestrvalue = new BigDecimal(prestr).intValue();
                    if (restStartValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restEndValue > prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restStartValue > prestrvalue && restEndValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestNextTime() + ":00";
                    }
                }
                if (itemInfo.getPreTimeDayType().getValue() == 2 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime()) && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                    reststartstr = itemInfo.getRestPreTime().substring(0, 2);
                    restendstr = itemInfo.getRestNextTime().substring(0, 2);
                    prestr = itemInfo.getPreTime().substring(0, 2);
                    restStartValue = new BigDecimal(reststartstr).intValue();
                    restEndValue = new BigDecimal(restendstr).intValue();
                    prestrvalue = new BigDecimal(prestr).intValue();
                    if (restStartValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temp2) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temp2) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restEndValue > prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestNextTime() + ":00";
                    } else if (restStartValue > prestrvalue && restEndValue < prestrvalue) {
                        restbeginTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestPreTime() + ":00";
                        restendTime = AtsDateUtils.dateShortToString(temp2) + " " + itemInfo.getRestNextTime() + ":00";
                    }
                }
                dateMap.put("beginTime", dt);
                dateMap.put("endTime", et);
                dateMap.put("restbeginTime", restbeginTime);
                dateMap.put("restendTime", restendTime);
                shiftList.add(dateMap);
            }
        }
        return shiftList;
    }

    public Map<String, String> validateIsFillOt(Context ctx, String billId, String personId, String otDate) throws EASBizException, BOSException {
        HashMap<String, String> res = new HashMap<String, String>();
        String errorString = "";
        if (org.apache.axis.utils.StringUtils.isEmpty((String)personId)) {
            errorString = MLUtile.getRes(AtsFileResEnum.NullPersonId, ctx);
            res.put("errorMsg", errorString);
            return res;
        }
        if (org.apache.axis.utils.StringUtils.isEmpty((String)otDate)) {
            errorString = MLUtile.getRes(AtsOverTimeBillResEnum.NullOTDate, ctx) + "!";
            res.put("errorMsg", errorString);
            return res;
        }
        Date applyDate = null;
        try {
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)billId) && AtsWebUtils.isInWorkFlow(ctx, billId)) {
                AtsOverTimeBillInfo atsOverTimeBillInfoDB = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(billId));
                applyDate = atsOverTimeBillInfoDB.getApplyDate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Timestamp OtDateTS = HRTimeWebUtils.stringToTimestamp(otDate);
        Date OTDate = HRTimeWebUtils.stringToLongDate(otDate);
        long OtDateTime = OtDateTS.getTime();
        boolean isFillOt = false;
        AttencePolicyInfo attencePolicyInfo = AttencePolicyFillHelper.getAttencePolicyInfo(ctx, personId, null);
        if (attencePolicyInfo == null) {
            errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            res.put("errorMsg", errorString);
            return res;
        }
        isFillOt = attencePolicyInfo.isIsFillOt();
        if (isFillOt) {
            boolean isFillOtByTimeCtl = attencePolicyInfo.isFillOtByTimeCtl();
            boolean isFillOtByCycleCtrl = attencePolicyInfo.isFillOtByCycleCtl();
            if (isFillOtByTimeCtl) {
                BigDecimal amount = attencePolicyInfo.getFillOtAmount();
                FillAmountUnitEnum unit = attencePolicyInfo.getFillOtAmountUnit();
                errorString = AttencePolicyFillHelper.validateByTimeControl(ctx, amount, unit, applyDate, 3, attencePolicyInfo, OTDate);
            }
            if (isFillOtByCycleCtrl && org.apache.axis.utils.StringUtils.isEmpty((String)errorString)) {
                FillAmountUnitEnum fillOtAfterDayUnit = attencePolicyInfo.getFillOtAfterDayUnit();
                BigDecimal afterDay = attencePolicyInfo.getFillOtAfterDay();
                int fillOtCycleType = attencePolicyInfo.getFillOtCycleType().getValue();
                errorString = AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, OtDateTime, applyDate, fillOtCycleType, afterDay, 3);
            }
        }
        res.put("errorMsg", errorString);
        AtsOverTimeBillInfo billInfo = new AtsOverTimeBillInfo();
        try {
            billInfo = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (billInfo.getEntries() != null) {
                for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                    OverTimeTypeInfo otType = billInfo.getEntries().get(i).getOtType();
                    String otTypeId = otType.getId().toString();
                    String otTypeName = otType.getName();
                    String person = billInfo.getEntries().get(i).getPerson().getId().toString();
                    String otCompensNames = "";
                    String otCompensId = this.getOTCompensByOTType(ctx, person, otTypeId);
                    String currentOtCompnes = billInfo.getEntries().get(i).getOtCompens().getId().toString();
                    String[] otCompensArr = otCompensId.split(",");
                    for (int j = 0; j < otCompensArr.length; ++j) {
                        String tempOtCompensId = otCompensArr[j];
                        OverTimeCompensInfo overTimeCompensInfo = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensInfo((IObjectPK)new ObjectUuidPK(tempOtCompensId));
                        otCompensNames = otCompensNames + "[" + overTimeCompensInfo.getName() + "]";
                    }
                    if (!otCompensId.contains(currentOtCompnes)) {
                        errorString = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBe, ctx, otTypeName, otCompensNames);
                    }
                    res.put("errorMsg", errorString);
                }
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        try {
            errorString = this.checkattencePolicyParm(ctx, billId, personId, otDate);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        res.put("errorMsg", errorString);
        boolean billBefAppContrl = attencePolicyInfo.isBillBefAppContrl();
        int billBefAppOT1 = attencePolicyInfo.getBillBefAppOT1();
        int billBefAppOT2 = attencePolicyInfo.getBillBefAppOT2();
        int billBefAppOT3 = attencePolicyInfo.getBillBefAppOT3();
        String otType = billInfo.getEntries().get(0).getOtType().getId().toString();
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDateTemp = new Date();
        String nowDate = shortFormat.format(nowDateTemp);
        if (billBefAppContrl) {
            Date oTDate = billInfo.getEntries().get(0).getOtDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(oTDate);
            String tipTail = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_APPDATELIMITTAIL, (Locale)ctx.getLocale());
            String wordayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_WORKDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String restDayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_RESTDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String holidayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_HOLIDAYDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            if (AttendContrlServerConstant.OTTYPE_WORKDAY.equalsIgnoreCase(otType)) {
                cal.add(5, -billBefAppOT1);
                errorString = wordayTip + billBefAppOT1 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_RESTDAY.equalsIgnoreCase(otType)) {
                cal.add(5, -billBefAppOT2);
                errorString = restDayTip + billBefAppOT2 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_HOLIDAYDAY.equalsIgnoreCase(otType)) {
                cal.add(5, -billBefAppOT3);
                errorString = holidayTip + billBefAppOT3 + tipTail;
            }
            if (cal.getTime().getTime() < HRTimeWebUtils.stringToShortDate(nowDate).getTime()) {
                errorString = MLUtile.getRes(AtsOverTimeBillResEnum.InconformApplyTimeTimeContrl, ctx);
            }
        }
        res.put("errorMsg", errorString);
        return res;
    }

    public Map<String, String> validateIsFillOtV85(Context ctx, String billId, String currentOtCompnes, String otTypeId, String personId, String otDate, String startTimeStr) throws EASBizException, BOSException {
        HashMap<String, String> res = new HashMap<String, String>();
        String errorString = "";
        if (org.apache.axis.utils.StringUtils.isEmpty((String)personId)) {
            errorString = MLUtile.getRes(AtsFileResEnum.NullPersonId, ctx);
            res.put("errorMsg", errorString);
            return res;
        }
        if (org.apache.axis.utils.StringUtils.isEmpty((String)otDate)) {
            errorString = MLUtile.getRes(AtsOverTimeBillResEnum.NullOTDate, ctx) + "!";
            res.put("errorMsg", errorString);
            return res;
        }
        Calendar applyCal = Calendar.getInstance();
        try {
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)billId) && AtsWebUtils.isInWorkFlow(ctx, billId)) {
                AtsOverTimeBillInfo atsOverTimeBillInfoDB = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(billId));
                applyCal.setTime(atsOverTimeBillInfoDB.getApplyDate());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        applyCal.setTime(AttencePolicyFillHelper.formatCalendar(applyCal));
        Date applyDate = applyCal.getTime();
        Timestamp OtDateTS = HRTimeWebUtils.stringToTimestamp(otDate);
        Date OTDate = HRTimeWebUtils.stringToLongDate(otDate);
        long OtDateTime = OtDateTS.getTime();
        boolean isFillOt = false;
        AttencePolicyInfo attencePolicyInfo = AttencePolicyFillHelper.getAttencePolicyInfo(ctx, personId, null);
        if (attencePolicyInfo == null) {
            errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            res.put("errorMsg", errorString);
            return res;
        }
        isFillOt = attencePolicyInfo.isIsFillOt();
        if (isFillOt) {
            boolean isFillOtByTimeCtl = attencePolicyInfo.isFillOtByTimeCtl();
            boolean isFillOtByCycleCtrl = attencePolicyInfo.isFillOtByCycleCtl();
            if (isFillOtByTimeCtl) {
                BigDecimal amount = attencePolicyInfo.getFillOtAmount();
                FillAmountUnitEnum unit = attencePolicyInfo.getFillOtAmountUnit();
                if (unit == FillAmountUnitEnum.daywork) {
                    String workCalendarId = attencePolicyInfo.getWorkCalendar().getId().toString();
                    int daysBetweenTwoDate = AttencePolicyFillHelper.getRealDayCountFromWorkWorkCalendar(ctx, workCalendarId, attencePolicyInfo, new Date(), amount.intValue());
                    amount = new BigDecimal(daysBetweenTwoDate);
                }
                errorString = AttencePolicyFillHelper.validateByTimeControl(ctx, amount, unit, applyDate, 3, attencePolicyInfo, OTDate);
            }
            if (isFillOtByCycleCtrl && org.apache.axis.utils.StringUtils.isEmpty((String)errorString)) {
                FillAmountUnitEnum fillOtAfterDayUnit = attencePolicyInfo.getFillOtAfterDayUnit();
                BigDecimal afterDay = attencePolicyInfo.getFillOtAfterDay();
                int fillOtCycleType = attencePolicyInfo.getFillOtCycleType().getValue();
                errorString = AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, OtDateTime, applyDate, fillOtCycleType, afterDay, 3);
            }
        }
        res.put("errorMsg", errorString);
        if (!org.apache.axis.utils.StringUtils.isEmpty((String)errorString)) {
            return res;
        }
        try {
            OverTimeTypeInfo otType = OverTimeTypeFactory.getLocalInstance(ctx).getOverTimeTypeCollection("where id = '" + otTypeId + "' ").get(0);
            String otTypeName = otType.getName();
            String otCompensNames = "";
            String otCompensId = this.getOTCompensByOTType(ctx, personId, otTypeId);
            String[] otCompensArr = otCompensId.split(",");
            for (int j = 0; j < otCompensArr.length; ++j) {
                String tempOtCompensId = otCompensArr[j];
                OverTimeCompensInfo overTimeCompensInfo = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensInfo((IObjectPK)new ObjectUuidPK(tempOtCompensId));
                otCompensNames = otCompensNames + "[" + overTimeCompensInfo.getName() + "]";
            }
            if (!otCompensId.contains(currentOtCompnes)) {
                errorString = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBe, ctx, otTypeName, otCompensNames);
            }
            res.put("errorMsg", errorString);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        try {
            errorString = this.checkattencePolicyParmV85(ctx, otTypeId, currentOtCompnes, personId, otDate, startTimeStr);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        res.put("errorMsg", errorString);
        boolean billBefAppContrl = attencePolicyInfo.isBillBefAppContrl();
        int billBefAppOT1 = attencePolicyInfo.getBillBefAppOT1();
        int billBefAppOT2 = attencePolicyInfo.getBillBefAppOT2();
        int billBefAppOT3 = attencePolicyInfo.getBillBefAppOT3();
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDateTemp = new Date();
        String nowDate = shortFormat.format(nowDateTemp);
        if (billBefAppContrl) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(OtDateTS);
            String tipTail = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_APPDATELIMITTAIL, (Locale)ctx.getLocale());
            String wordayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_WORKDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String restDayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_RESTDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String holidayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_HOLIDAYDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            if (AttendContrlServerConstant.OTTYPE_WORKDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT1);
                errorString = wordayTip + billBefAppOT1 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_RESTDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT2);
                errorString = restDayTip + billBefAppOT2 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_HOLIDAYDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT3);
                errorString = holidayTip + billBefAppOT3 + tipTail;
            }
            if (cal.getTime().getTime() < HRTimeWebUtils.stringToShortDate(nowDate).getTime()) {
                errorString = MLUtile.getRes(AtsOverTimeBillResEnum.InconformApplyTimeTimeContrl, ctx);
            }
        }
        res.put("errorMsg", errorString);
        return res;
    }

    public String checkattencePolicyParm(Context ctx, String billId, String personId, String otDate) throws EASBizException, BOSException {
        StringBuffer errorMSg = new StringBuffer("");
        AtsOverTimeBillInfo billInfo = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(billId));
        if (billInfo.getEntries() != null) {
            for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                OverTimeTypeInfo otType = billInfo.getEntries().get(i).getOtType();
                String otTypeId = otType.getId().toString();
                Timestamp startTime = billInfo.getEntries().get(i).getStartTime();
                String curotCompens = billInfo.getEntries().get(i).getOtCompens().toString();
                try {
                    AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
                    AttencePolicyInfo attencePolicyInfo = AttencePolicyFillUtil.getAttencePolicyInfo(ctx, personId, attendanceFileColl.get(0));
                    BigDecimal afterAllowOT = attencePolicyInfo.getAfterAllowOT();
                    ScheduleShiftInfo info = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, otDate);
                    if (info == null) continue;
                    ScheduleShiftItemCollection items = info.getItems();
                    if (items.size() > 0) {
                        String nextTime = items.get(items.size() - 1).getNextTime();
                        Timestamp endtime = HRTimeWebUtils.stringToTimestamp(nextTime);
                        if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId)) {
                            if (startTime.getTime() < endtime.getTime() + (long)(afterAllowOT.intValue() * 60 * 60 * 1000)) {
                                errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, "18:30"));
                                return errorMSg.toString();
                            }
                        } else if (startTime.getTime() < endtime.getTime() + (long)(afterAllowOT.intValue() * 60 * 60 * 1000) && startTime.getTime() >= endtime.getTime()) {
                            errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, "18:30"));
                            return errorMSg.toString();
                        }
                    }
                    String otCompens = "";
                    otCompens = "rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens1() : ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens2() : attencePolicyInfo.getOtCompens3());
                    if (otCompens.contains(curotCompens)) continue;
                    errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBeTakeWork, ctx, otType.getName()));
                    return errorMSg.toString();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return errorMSg.toString();
    }

    public String checkattencePolicyParmV85(Context ctx, String otTypeId, String curotCompens, String personId, String otDate, String startTimeStr) throws EASBizException, BOSException {
        StringBuffer errorMSg = new StringBuffer("");
        OverTimeTypeInfo otType = OverTimeTypeFactory.getLocalInstance(ctx).getOverTimeTypeCollection("where id = '" + otTypeId + "' ").get(0);
        Timestamp startTime = HRTimeWebUtils.stringToTimestamp(startTimeStr);
        try {
            ScheduleShiftItemCollection items;
            AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFillUtil.getAttencePolicyInfo(ctx, personId, attendanceFileColl.get(0));
            BigDecimal afterAllowOT = attencePolicyInfo.getAfterAllowOT();
            ScheduleShiftInfo info = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, otDate);
            if (info != null && (items = info.getItems()).size() > 0) {
                items.sort("segment");
                String nextTime = AtsDateUtils.getFullTime(items.get(items.size() - 1).getNextTime());
                String dayType = String.valueOf(items.get(items.size() - 1).getNextTimeDayType().getValue());
                AtsOverTimeBillEditHandler.timeToDateByDayType(nextTime, dayType, AtsDateUtils.dateShortToString(info.getAttendDate()));
                Timestamp endtime = AtsDateUtils.stringToTimestamp(AtsOverTimeBillEditHandler.timeToDateByDayType(nextTime, dayType, AtsDateUtils.dateShortToString(info.getAttendDate())));
                if (afterAllowOT == null) {
                    afterAllowOT = new BigDecimal(0);
                }
                Date d = new Date(endtime.getTime() + (long)(afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0));
                String dstr = AtsDateUtils.getHourMinFromString(AtsDateUtils.dateLongToString(d));
                if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId)) {
                    if ((double)startTime.getTime() < (double)endtime.getTime() + afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0 && startTime.getTime() >= endtime.getTime()) {
                        errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, dstr));
                        return errorMSg.toString();
                    }
                } else if ((double)startTime.getTime() < (double)endtime.getTime() + afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0 && startTime.getTime() >= endtime.getTime()) {
                    errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, dstr));
                    return errorMSg.toString();
                }
            }
            String otCompens = "";
            otCompens = "rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens1() : ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens2() : attencePolicyInfo.getOtCompens3());
            if (!otCompens.contains(curotCompens)) {
                errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBeTakeWork, ctx, otType.getName()));
                return errorMSg.toString();
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return errorMSg.toString();
    }

    public String getOTCompensByOTType(Context ctx, String personId, String otTypeId) throws BOSException {
        AttendanceFileCollection fileCol = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("select * ,hrOrgUnit.id ,attencePolicy.* where proposer.id='" + personId + "' and attendFileState='1' ");
        String hrOrgUnit = fileCol.get(0).getHrOrgUnit().getId().toString();
        String otCompens = null;
        if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId)) {
            otCompens = fileCol.get(0).getAttencePolicy().getOtCompens1();
        } else if ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otTypeId)) {
            otCompens = fileCol.get(0).getAttencePolicy().getOtCompens2();
        } else if ("sRWUOt7sRpOY0TCo6NMqGY6C/nU=".equals(otTypeId)) {
            otCompens = fileCol.get(0).getAttencePolicy().getOtCompens3();
        }
        if (!org.apache.axis.utils.StringUtils.isEmpty((String)otCompens)) {
            String enableotCompens = "";
            OverTimeCompensCollection otCompensCollection = new OverTimeCompensCollection();
            String[] otCompensId = otCompens.split(",");
            otCompensCollection = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensCollection("where id in (" + AtsUtil.getStrFromStringArr(otCompensId) + ") and state = 1");
            for (int i = 0; i < otCompensCollection.size(); ++i) {
                enableotCompens = enableotCompens + otCompensCollection.get(i).getId().toString();
                if (i >= otCompensCollection.size() - 1) continue;
                enableotCompens = enableotCompens + ",";
            }
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)enableotCompens)) {
                return enableotCompens;
            }
        } else {
            String enableotCompens = "";
            OverTimeCompensCollection otCompensCollection = new OverTimeCompensCollection();
            otCompensCollection = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensCollection("where id in (SELECT fbaseinfoID from T_ATS_AtsOTCompensAvailable where fhrorguseid = '" + hrOrgUnit + "' ) and state = 1");
            for (int i = 0; i < otCompensCollection.size(); ++i) {
                enableotCompens = enableotCompens + otCompensCollection.get(i).getId().toString();
                if (i >= otCompensCollection.size() - 1) continue;
                enableotCompens = enableotCompens + ",";
            }
            if (!org.apache.axis.utils.StringUtils.isEmpty((String)enableotCompens)) {
                return enableotCompens;
            }
        }
        return otCompens;
    }

    public static String timeToDateByDayType(String time, String dayType, String attDate) {
        String date = "";
        long dayMs = 86400000L;
        Date tempDate = AtsDateUtils.stringToShortDate(attDate);
        if (dayType.equals("0")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() - dayMs)) + " " + time;
        } else if (dayType.equals("1")) {
            date = attDate + " " + time;
        } else if (dayType.equals("2")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() + dayMs)) + " " + time;
        }
        return date;
    }

    public Map<String, Object> checkOTBatchBill(Context ctx, AtsOverTimeBillInfo bill) throws BOSException, EASBizException {
        String attencePolicyId;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String personId = bill.getEntries().get(0).getPerson().getId().toString();
        PersonPositionInfo personPositionInfo = SHRBillUtil.getAdminOrgUnit(personId, ctx);
        int entrySize = bill.getEntries().size();
        String errorString = "";
        AttendanceFileHISInfo attendanceFileHISInfo = null;
        HROrgUnitInfo hrInfo = null;
        String startDate = entrySize > 1 ? this.getMinTime(bill) : bill.getEntries().get(0).getStartTime().toString();
        String endDate = entrySize > 1 ? this.getMaxTime(bill) : bill.getEntries().get(0).getEndTime().toString();
        String startDateStr = startDate.substring(0, 10);
        String endDateStr = endDate.substring(0, 10);
        Boolean isPunchcard = true;
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(" where proposer.id='" + personId + "' and EFFDT <='" + endDateStr + "' and LEFFDT >='" + startDateStr + "' and attendFileState='1' order by effdt desc ");
        AbstractAttencePolicyInfo attencePolicyInfo = null;
        if (null == attendanceFileHISColl || attendanceFileHISColl.size() == 0) {
            errorString = MLUtile.getRes(AtsAttenceResEnum.NotExistsHrOrgPerson, ctx);
            resultMap.put("errorMsg", errorString);
            return resultMap;
        }
        if (attendanceFileHISColl.size() > 1) {
            for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
                for (int j = i + 1; j < attendanceFileHISColl.size(); ++j) {
                    if (attendanceFileHISColl.get(i).getHrOrgUnit().getId().toString().equals(attendanceFileHISColl.get(j).getHrOrgUnit().getId().toString())) continue;
                    errorString = MLUtile.getRes(AtsOverTimeBillResEnum.OTCanNotAcrossAtsAttendance, ctx);
                    resultMap.put("errorMsg", errorString);
                    return resultMap;
                }
            }
            attendanceFileHISInfo = attendanceFileHISColl.get(0);
            hrInfo = attendanceFileHISInfo.getHrOrgUnit();
            if (attendanceFileHISInfo.getIsAttendance().getValue().equals("0")) {
                isPunchcard = false;
            }
            attencePolicyId = attendanceFileHISInfo.getAttencePolicy().getId().toString();
            try {
                attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else if (attendanceFileHISColl.get(0) != null) {
            attendanceFileHISInfo = attendanceFileHISColl.get(0);
            hrInfo = attendanceFileHISInfo.getHrOrgUnit();
            if (attendanceFileHISInfo.getIsAttendance().getValue().equals("0")) {
                isPunchcard = false;
            }
            attencePolicyId = attendanceFileHISInfo.getAttencePolicy().getId().toString();
            try {
                attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (attencePolicyInfo == null) {
            errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            resultMap.put("errorMsg", errorString);
            return resultMap;
        }
        BigDecimal otStart = new BigDecimal(attencePolicyInfo.getOtStart()).divide(new BigDecimal(60), 2, 4);
        Map<String, ScheduleShiftInfo> scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, startDate, endDate);
        if (scheduleShiftMap == null) {
            scheduleShiftMap = new HashMap<String, ScheduleShiftInfo>();
        }
        Iterator entryItem = bill.getEntries().iterator();
        while (entryItem.hasNext()) {
            AtsOverTimeBillEntryInfo entryInfo = (AtsOverTimeBillEntryInfo)entryItem.next();
            String beginTime = entryInfo.getStartTime().toString();
            String endTime = entryInfo.getEndTime().toString();
            String otDate = AtsDateUtils.dateShortToString(entryInfo.getOtDate());
            String otCompens = entryInfo.getOtCompens().getId().toString();
            String otType = entryInfo.getOtType().getId().toString();
            BigDecimal applyOtTime = entryInfo.getApplyOTTime();
            Boolean isWorkTime = false;
            List<ScheduleShiftInfo> scheduleShiftInfoList = AtsScheduleShiftUtil.getScheduleShiftListByPriority(ctx, personId, beginTime.substring(0, 10), endTime.substring(0, 10));
            isWorkTime = scheduleShiftInfoList == null || scheduleShiftInfoList.size() == 0 ? Boolean.valueOf(this.isWorkIsNotAttendance(ctx, personId, beginTime, endTime)) : Boolean.valueOf(this.isWorkTimeIsAttendance(scheduleShiftInfoList, AtsDateUtils.stringToTimestamp(beginTime), AtsDateUtils.stringToTimestamp(endTime)));
            String string = errorString = isWorkTime != false ? MLUtile.getRes(AtsOverTimeBillResEnum.CanNotSubmitOTInWorkTime, ctx) : "";
            if (!"".equals(errorString)) {
                resultMap.put("errorMsg", errorString);
                return resultMap;
            }
            errorString = this.validateIsFillOtV85New(ctx, otCompens, otType, personId, entryInfo.getOtDate(), beginTime, (AttencePolicyInfo)attencePolicyInfo, bill);
            if (!"".equals(errorString)) {
                resultMap.put("errorMsg", errorString);
                return resultMap;
            }
            if (this.isAtFixedOverTimeOrExcep(ctx, personId, beginTime, endTime, otDate)) {
                resultMap.put("errorMsg", MLUtile.getRes(AtsOverTimeBillResEnum.CommitBesideOTPerid, ctx));
                return resultMap;
            }
            try {
                errorString = this.checkattencePolicyParmV85(ctx, otType, otCompens, personId, otDate, beginTime);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.checkattencePolicyParmV85New(ctx, otType, otCompens, personId, otDate, beginTime, (AttencePolicyInfo)attencePolicyInfo, scheduleShiftMap);
            if (!"".equals(errorString)) {
                resultMap.put("errorMsg", errorString);
                return resultMap;
            }
            if (applyOtTime.compareTo(otStart) == -1) {
                errorString = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.UntouchLowestValueMin, ctx, "", attencePolicyInfo.getOtStart()) + "\uff01";
            }
            if (!"".equals(errorString)) {
                resultMap.put("errorMsg", errorString);
                return resultMap;
            }
            errorString = this.checkDuplicateNew(ctx, endTime, beginTime, personId);
            if (!"".equals(errorString)) {
                resultMap.put("errorMsg", errorString);
                return resultMap;
            }
            entryInfo.setAdminOrgUnit(attendanceFileHISInfo.getAdminOrgUnit());
            entryInfo.setAttAdminOrgUnit(attendanceFileHISInfo.getAttAdminOrgUnit());
            entryInfo.setPosition(personPositionInfo.getPrimaryPosition());
            entryInfo.setCreateTag(OverTimeCreateTag.userCreate);
        }
        AtsOverTimeBillInfo overTimeBill = new AtsOverTimeBillInfo();
        String billNumber = NumberCodeRule.readCodeRuleNumber((IObjectValue)overTimeBill, NumberCodeRule.getMainOrgByCu(ctx), ctx);
        if (StringUtils.isNotBlank((String)billNumber)) {
            bill.setNumber(billNumber);
        } else {
            billNumber = "M-JBD-" + DateTimeUtils.format(new Date(), "yyyyMMdd") + System.currentTimeMillis();
            bill.setNumber(billNumber);
        }
        bill.setHrOrgUnit(hrInfo);
        bill.setAdminOrg(attendanceFileHISInfo.getAdminOrgUnit());
        bill.setApplyDate(DateTimeUtils.truncateDate(new Date()));
        errorString = this.checkOTLimits(ctx, bill);
        if (!"".equals(errorString)) {
            resultMap.put("errorMsg", errorString);
            return resultMap;
        }
        bill.setBillSubmitType(BillSubmitTypeEnum.getEnum(entrySize > 1 ? 3 : 1));
        bill.setBillState(HRBillStateEnum.SUBMITED);
        bill.setExtendedProperty("isAddNew", "isAddNew");
        resultMap.put("bill", bill);
        return resultMap;
    }

    public boolean isAtFixedOverTimeOrExcep(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate) throws BOSException {
        Boolean isAtFixedOverTimeOrExcep = false;
        if (overTimeBegin.trim().length() != 19) {
            overTimeBegin = overTimeBegin.substring(0, 19);
        }
        if (overTimeEnd.trim().length() != 19) {
            overTimeEnd = overTimeEnd.substring(0, 19);
        }
        Timestamp overTimeBeginTS = AtsDateUtils.stringToTimestamp(overTimeBegin);
        Timestamp overTimeEndTS = AtsDateUtils.stringToTimestamp(overTimeEnd);
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, overDate);
        if (null != scheduleShiftInfo) {
            ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
            for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                if (!scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("2") && !scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("4") || scheduleShiftItemColl.get(i).getPreDateTime().compareTo(overTimeEndTS) != -1 || scheduleShiftItemColl.get(i).getNextDateTime().compareTo(overTimeBeginTS) != 1) continue;
                isAtFixedOverTimeOrExcep = true;
            }
        }
        return isAtFixedOverTimeOrExcep;
    }

    private boolean isWorkIsNotAttendance(Context ctx, String personId, String overTimeBegin, String overTimeEnd) {
        Map<String, AttendanceFileInfo> attendanceFiles = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personId, overTimeBegin.substring(0, 10), overTimeEnd.substring(0, 10));
        if (attendanceFiles != null && attendanceFiles.size() > 0) {
            Map<String, AtsShiftInfo> atsShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, attendanceFiles);
            if (atsShiftInfoMap.size() == 0) {
                return false;
            }
            Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, attendanceFiles, atsShiftInfoMap);
            ArrayList<ScheduleShiftInfo> scheduleShiftInfoList = new ArrayList<ScheduleShiftInfo>();
            Iterator<Map.Entry<String, ScheduleShiftInfo>> iterator = scheduleShiftByAtsShift.entrySet().iterator();
            while (iterator.hasNext()) {
                scheduleShiftInfoList.add(iterator.next().getValue());
            }
            if (scheduleShiftInfoList.size() == 0) {
                return false;
            }
            Timestamp overTimeBeginTS = HRTimeWebUtils.stringToTimestamp(overTimeBegin);
            Timestamp overTimeEndTS = HRTimeWebUtils.stringToTimestamp(overTimeEnd);
            return this.isWorkTimeIsAttendance(scheduleShiftInfoList, overTimeBeginTS, overTimeEndTS);
        }
        return false;
    }

    private boolean isWorkTimeIsAttendance(List<ScheduleShiftInfo> scheduleShiftInfoList, Timestamp overTimeBeginTS, Timestamp overTimeEndTS) {
        for (int j = 0; j < scheduleShiftInfoList.size(); ++j) {
            ScheduleShiftInfo scheduleShiftInfo = scheduleShiftInfoList.get(j);
            ScheduleShiftItemInfo shiftItem = null;
            ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
            for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                int dayType;
                shiftItem = scheduleShiftItemColl.get(i);
                if (!scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("1") && !scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("3") || 0 != (dayType = scheduleShiftInfo.getDayType().getValue())) continue;
                if (scheduleShiftItemColl.get(i).getPreDateTime() == null || scheduleShiftItemColl.get(i).getNextDateTime() == null) {
                    return true;
                }
                Timestamp preRestTime = shiftItem.getRestPreDateTime();
                Timestamp nextRestTime = shiftItem.getRestNextDateTime();
                if (null != preRestTime && null != nextRestTime && preRestTime.compareTo(overTimeBeginTS) <= 0 && nextRestTime.compareTo(overTimeEndTS) >= 0) {
                    return false;
                }
                if (scheduleShiftItemColl.get(i).getPreDateTime().compareTo(overTimeEndTS) != -1 || scheduleShiftItemColl.get(i).getNextDateTime().compareTo(overTimeBeginTS) != 1) continue;
                return true;
            }
        }
        return false;
    }

    public String checkDuplicateNew(Context ctx, String realEndTime, String realStartTime, String personId) throws HRCommonException {
        StringBuilder ksqlSB = new StringBuilder();
        String billStateString = "1,2,3";
        ksqlSB.append(" select m.fid,m.fnumber,m.fbillstate,e.fstarttime,e.fendtime,e.fpersonid,p.fname" + MLUtile.getMlFlag(ctx) + " name,e.FCREATETAG \n").append("   from T_HR_ATS_OverTimeBillEntry e  \n").append("   inner join T_HR_ATS_OverTimeBill m on  e.fbillid=m.fid  \n").append("   left join T_BD_Person p on e.fpersonid= p.fid \n").append("   where  \n").append("   m.fbillstate in (" + billStateString + ") \n").append("   and e.FCREATETAG !='2' ").append("   and ( \n").append("   ( e.fstarttime<=? and e.fendtime>? and e.fpersonid=? )      \n").append("   ) \n");
        String errorMsg = "";
        try {
            Object[] params = new Object[]{HRTimeWebUtils.stringToTimestamp(realEndTime), HRTimeWebUtils.stringToTimestamp(realStartTime), personId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlSB.toString(), (Object[])params);
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    errorMsg = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.ExistsOverlapTimeInOTBill, ctx, rs.getString("fnumber"), rs.getString("name") + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fstarttime")) + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fendtime")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return errorMsg;
        }
        return errorMsg;
    }

    public String validateIsFillOtV85New(Context ctx, String currentOtCompnes, String otTypeId, String personId, Date otDate, String startTimeStr, AttencePolicyInfo attencePolicyInfo, AtsOverTimeBillInfo overTimeBillInfo) throws EASBizException, BOSException {
        String errorString = "";
        Calendar applyCal = Calendar.getInstance();
        if (overTimeBillInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, overTimeBillInfo.getId().toString())) {
            AtsOverTimeBillInfo overTimeBillInfoDB = overTimeBillInfo;
            if (overTimeBillInfo.getApplyDate() == null) {
                overTimeBillInfoDB = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo((IObjectPK)new ObjectUuidPK(overTimeBillInfo.getId().toString()));
            }
            applyCal.setTime(overTimeBillInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        Date applyDate = applyCal.getTime();
        long OtDateTime = otDate.getTime();
        boolean isFillOt = false;
        isFillOt = attencePolicyInfo.isIsFillOt();
        if (isFillOt) {
            FillAmountUnitEnum unit;
            BigDecimal amount;
            boolean isFillOtByTimeCtl = attencePolicyInfo.isFillOtByTimeCtl();
            boolean isFillOtByCycleCtrl = attencePolicyInfo.isFillOtByCycleCtl();
            if (isFillOtByTimeCtl && !org.apache.axis.utils.StringUtils.isEmpty((String)(errorString = AttencePolicyFillHelper.validateByTimeControl(ctx, amount = attencePolicyInfo.getFillOtAmount(), unit = attencePolicyInfo.getFillOtAmountUnit(), applyDate, 3, attencePolicyInfo, otDate)))) {
                return errorString;
            }
            if (isFillOtByCycleCtrl && org.apache.axis.utils.StringUtils.isEmpty((String)errorString)) {
                int fillOtCycleType;
                Boolean aBoolean;
                FillAmountUnitEnum fillOtAfterDayUnit = attencePolicyInfo.getFillOtAfterDayUnit();
                BigDecimal afterDay = attencePolicyInfo.getFillOtAfterDay();
                if (fillOtAfterDayUnit == FillAmountUnitEnum.mouthEndDay ? (null == (aBoolean = AttencePolicyFillUtil.validMonthlyStatementDateByPolicy(ctx, attencePolicyInfo.getId().toString(), afterDay.intValue(), AtsDateUtils.dateShortFormatToStr(otDate), applyDate)) || aBoolean == false) && !org.apache.axis.utils.StringUtils.isEmpty((String)(errorString = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx))) : !org.apache.axis.utils.StringUtils.isEmpty((String)(errorString = AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, OtDateTime, applyDate, fillOtCycleType = attencePolicyInfo.getFillOtCycleType().getValue(), afterDay, 3)))) {
                    return errorString;
                }
            }
        }
        try {
            OverTimeTypeInfo otType = OverTimeTypeFactory.getLocalInstance(ctx).getOverTimeTypeCollection("where id = '" + otTypeId + "' ").get(0);
            String otTypeName = otType.getName();
            String otCompensNames = "";
            String otCompensId = this.getOTCompensByOTType(ctx, personId, otTypeId);
            String[] otCompensArr = otCompensId.split(",");
            for (int j = 0; j < otCompensArr.length; ++j) {
                String tempOtCompensId = otCompensArr[j];
                OverTimeCompensInfo overTimeCompensInfo = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensInfo((IObjectPK)new ObjectUuidPK(tempOtCompensId));
                otCompensNames = otCompensNames + "[" + overTimeCompensInfo.getName() + "]";
            }
            if (!otCompensId.contains(currentOtCompnes) && !org.apache.axis.utils.StringUtils.isEmpty((String)(errorString = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBe, ctx, otTypeName, otCompensNames)))) {
                return errorString;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        boolean billBefAppContrl = attencePolicyInfo.isBillBefAppContrl();
        int billBefAppOT1 = attencePolicyInfo.getBillBefAppOT1();
        int billBefAppOT2 = attencePolicyInfo.getBillBefAppOT2();
        int billBefAppOT3 = attencePolicyInfo.getBillBefAppOT3();
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDateTemp = new Date();
        String nowDate = shortFormat.format(nowDateTemp);
        if (billBefAppContrl && otDate.getTime() >= AtsDateUtils.stringToShortDate(nowDate).getTime()) {
            String billBefAppContrlMsg = "";
            Calendar cal = Calendar.getInstance();
            cal.setTime(otDate);
            String tipTail = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_APPDATELIMITTAIL, (Locale)ctx.getLocale());
            String wordayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_WORKDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String restDayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_RESTDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            String holidayTip = ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_HOLIDAYDAYAPPDATELIMIT, (Locale)ctx.getLocale());
            if (AttendContrlServerConstant.OTTYPE_WORKDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT1);
                billBefAppContrlMsg = wordayTip + billBefAppOT1 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_RESTDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT2);
                billBefAppContrlMsg = restDayTip + billBefAppOT2 + tipTail;
            } else if (AttendContrlServerConstant.OTTYPE_HOLIDAYDAY.equalsIgnoreCase(otTypeId)) {
                cal.add(5, -billBefAppOT3);
                billBefAppContrlMsg = holidayTip + billBefAppOT3 + tipTail;
            }
            if (cal.getTime().getTime() < HRTimeWebUtils.stringToShortDate(nowDate).getTime()) {
                errorString = billBefAppContrlMsg;
            }
        }
        return errorString;
    }

    public String checkattencePolicyParmV85New(Context ctx, String otTypeId, String curotCompens, String personId, String otDate, String startTimeStr, AttencePolicyInfo attencePolicyInfo, Map<String, ScheduleShiftInfo> scheduleShiftMap) throws EASBizException, BOSException {
        ScheduleShiftItemCollection items;
        StringBuffer errorMSg = new StringBuffer("");
        OverTimeTypeInfo otType = OverTimeTypeFactory.getLocalInstance(ctx).getOverTimeTypeCollection("where id = '" + otTypeId + "' ").get(0);
        Timestamp startTime = HRTimeWebUtils.stringToTimestamp(startTimeStr);
        BigDecimal afterAllowOT = attencePolicyInfo.getAfterAllowOT();
        String key = personId + "_" + otDate;
        ScheduleShiftInfo info = scheduleShiftMap.get(key);
        if (info != null && (items = info.getItems()).size() > 0) {
            items.sort("segment");
            String nextTime = AtsDateUtils.getFullTime(items.get(items.size() - 1).getNextTime());
            String dayType = String.valueOf(items.get(items.size() - 1).getNextTimeDayType().getValue());
            AtsOverTimeBillEditHandler.timeToDateByDayType(nextTime, dayType, AtsDateUtils.dateShortToString(info.getAttendDate()));
            Timestamp endtime = AtsDateUtils.stringToTimestamp(AtsOverTimeBillEditHandler.timeToDateByDayType(nextTime, dayType, AtsDateUtils.dateShortToString(info.getAttendDate())));
            if (afterAllowOT == null) {
                afterAllowOT = new BigDecimal(0);
            }
            Date d = new Date(endtime.getTime() + (long)(afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0));
            String dstr = AtsDateUtils.getHourMinFromString(AtsDateUtils.dateLongToString(d));
            if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId)) {
                if ((double)startTime.getTime() < (double)endtime.getTime() + afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0 && startTime.getTime() >= endtime.getTime()) {
                    errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, dstr));
                    return errorMSg.toString();
                }
            } else if ((double)startTime.getTime() < (double)endtime.getTime() + afterAllowOT.doubleValue() * 60.0 * 60.0 * 1000.0 && startTime.getTime() >= endtime.getTime()) {
                errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.CommitAfterRest, ctx, dstr));
                return errorMSg.toString();
            }
        }
        String otCompens = "";
        otCompens = "rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens1() : ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otTypeId) ? attencePolicyInfo.getOtCompens2() : attencePolicyInfo.getOtCompens3());
        if (!otCompens.contains(curotCompens)) {
            errorMSg.append(MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.OTCompensMustBeTakeWork, ctx, otType.getName()));
            return errorMSg.toString();
        }
        return errorMSg.toString();
    }

    public Boolean isWorkTimeNew(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate, Map<String, ScheduleShiftInfo> scheduleShiftMap, Boolean isPunchcard) throws BOSException {
        String key;
        ScheduleShiftInfo scheduleShiftInfo;
        HashMap res = new HashMap();
        Boolean isWorkTime = false;
        if (overTimeBegin.trim().length() != 19) {
            overTimeBegin = overTimeBegin.substring(0, 19);
        }
        if (overTimeEnd.trim().length() != 19) {
            overTimeEnd = overTimeEnd.substring(0, 19);
        }
        String otDate = AtsDateUtils.tsDateStr(overDate);
        String endDate = AtsDateUtils.tsDateStr(overTimeEnd);
        Timestamp overTimeBeginTS = HRTimeWebUtils.stringToTimestamp(overTimeBegin);
        Timestamp overTimeEndTS = HRTimeWebUtils.stringToTimestamp(overTimeEnd);
        if (otDate.compareTo(endDate) == -1) {
            // empty if block
        }
        if (otDate.compareTo(endDate) == 1) {
            endDate = otDate;
        }
        if (null != (scheduleShiftInfo = scheduleShiftMap.get(key = personId + "_" + overDate))) {
            ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
            for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                int dayType;
                if (!scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("1") && !scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("3") || 0 != (dayType = scheduleShiftInfo.getDayType().getValue())) continue;
                if (scheduleShiftItemColl.get(i).getPreDateTime() == null || scheduleShiftItemColl.get(i).getNextDateTime() == null) {
                    isWorkTime = true;
                    continue;
                }
                if (scheduleShiftItemColl.get(i).getPreDateTime().compareTo(overTimeEndTS) != -1 || scheduleShiftItemColl.get(i).getNextDateTime().compareTo(overTimeBeginTS) != 1) continue;
                isWorkTime = true;
            }
        }
        return isWorkTime;
    }

    public String getMinTime(AtsOverTimeBillInfo bill) {
        bill.getEntries().sort("startTime");
        return bill.getEntries().get(0).getStartTime().toString();
    }

    public String getMaxTime(AtsOverTimeBillInfo bill) {
        bill.getEntries().sort("endTime desc");
        return bill.getEntries().get(0).getEndTime().toString();
    }

    private String checkOTLimits(Context ctx, AtsOverTimeBillInfo billInfo) {
        StringBuffer otCtrlErrorMsg = new StringBuffer();
        try {
            boolean isOverTimeControl = SHRBillServerUtil.overTimeControl(ctx, billInfo.getHrOrgUnit().getId().toString());
            if (isOverTimeControl) {
                otCtrlErrorMsg = AtsOverTimeBillEditHandler.checkOTLimitInfo(ctx, null, billInfo, "single");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return otCtrlErrorMsg.toString();
    }

    public static StringBuffer checkOTLimitInfo(Context ctx, String uipk, AtsOverTimeBillInfo billInfo, String type) throws Exception {
        StringBuffer errorMSg = new StringBuffer();
        List<String> hasNotLimitRecord = new ArrayList();
        List overLimitRecord = new ArrayList();
        List<String> hasNotDepLimitRecord = new ArrayList();
        List overDepLimitRecord = new ArrayList();
        List overDepPaymentLimitRecord = new ArrayList();
        List<String> overAppDateRecord = new ArrayList();
        String appDateContrMsg = "";
        AtsControlServerUtil atsControlServerUtil = new AtsControlServerUtil(ctx);
        Map res = atsControlServerUtil.checkOverTimeLimit(billInfo, uipk);
        if (res.containsKey("errorMsgList")) {
            errorMSg.append(((List)res.get("errorMsgList")).get(0));
            return errorMSg;
        }
        if (!(res.containsKey("appDateContrMsgList") && res.containsKey("overAppDateRecord") && res.containsKey("overLimitRecord") && res.containsKey("hasNotLimitRecord") && res.containsKey("overDepLimitRecord") && res.containsKey("hasNotDepLimitRecord") && res.containsKey("overDepPaymentLimitRecord"))) {
            errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.JudgeOTCtrlFail, ctx)).append("\uff01");
            return errorMSg;
        }
        List appDateContrMsgList = (List)res.get("appDateContrMsgList");
        if (appDateContrMsgList.size() > 0) {
            appDateContrMsg = (String)appDateContrMsgList.get(0);
        }
        overAppDateRecord = (List)res.get("overAppDateRecord");
        overLimitRecord = (List)res.get("overLimitRecord");
        hasNotLimitRecord = (List)res.get("hasNotLimitRecord");
        overDepLimitRecord = (List)res.get("overDepLimitRecord");
        hasNotDepLimitRecord = (List)res.get("hasNotDepLimitRecord");
        overDepPaymentLimitRecord = (List)res.get("overDepPaymentLimitRecord");
        HashMap overPOTLimtMap = (HashMap)res.get("totalMapForPerOT");
        HashMap totalMapForDepOT = (HashMap)res.get("totalMapForDepOT");
        HashMap totalMapForDepOTCompens = (HashMap)res.get("totalMapForDepOTCompens");
        if (!"single".equalsIgnoreCase(type)) {
            errorMSg.append(AtsOverTimeBillEditHandler.handErrorMsg(overAppDateRecord, new AtsStaticResourceBizException(AtsStaticResourceBizException.APPLYTIMENOTINTIME).getMessage() + "\uff01<br/>"));
            errorMSg.append(AtsOverTimeBillEditHandler.handErrorMsg(hasNotLimitRecord, new AtsStaticResourceBizException(AtsStaticResourceBizException.NODEPOTLIMITINFO).getMessage() + "\uff01<br/>"));
            errorMSg.append(AtsOverTimeBillEditHandler.handErrorMsg(hasNotDepLimitRecord, new AtsStaticResourceBizException(AtsStaticResourceBizException.NODEPOTLIMITINFO).getMessage() + "\uff01<br/>"));
            errorMSg.append(AtsOverTimeBillEditHandler.processOverLimitMsg(overPOTLimtMap, MLUtile.getRes(AtsOverTimeBillResEnum.OTWarnTitle3, ctx) + "!<br/>"));
            errorMSg.append(AtsOverTimeBillEditHandler.processOverLimitMsg(totalMapForDepOT, MLUtile.getRes(AtsOverTimeBillResEnum.OTWarnTitle1, ctx) + "!<br/>"));
            errorMSg.append(AtsOverTimeBillEditHandler.processOverLimitMsg(totalMapForDepOTCompens, MLUtile.getRes(AtsOverTimeBillResEnum.OTWarnTitle2, ctx) + "!<br/>"));
        } else {
            if (overAppDateRecord.size() > 0) {
                errorMSg.append(appDateContrMsg);
            }
            if (overLimitRecord.size() > 0) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.ApplyOverOTLimitPer, ctx)).append("<br/>");
            }
            if (hasNotLimitRecord.size() > 0) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.NotGenerateOTLimitPer, ctx)).append("<br/>");
            }
            if (overDepLimitRecord.size() > 0) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.ApplyOverOTLimitdep, ctx)).append("<br/>");
            }
            if (hasNotDepLimitRecord.size() > 0) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.NotGenerateOTLimitDep, ctx)).append("<br/>");
            }
            if (overDepPaymentLimitRecord.size() > 0) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.OverDepOTPay, ctx)).append("\uff01<br/>");
            }
            if (AtsOverTimeBillEditHandler.checkIsOverLimit(overPOTLimtMap)) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.ApplyOverOTLimitPer, ctx)).append("<br/>");
            }
            if (AtsOverTimeBillEditHandler.checkIsOverLimit(totalMapForDepOT)) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.ApplyOverOTLimitdep, ctx)).append("<br/>");
            }
            if (AtsOverTimeBillEditHandler.checkIsOverLimit(totalMapForDepOTCompens)) {
                errorMSg.append(MLUtile.getRes(AtsOverTimeBillResEnum.OverDepOTPay, ctx)).append("\uff01<br/>");
            }
        }
        return errorMSg;
    }

    private static String handErrorMsg(List<String> recordlist, String tips) {
        StringBuffer errorMsgBuf = new StringBuffer("");
        if (recordlist.size() > 0) {
            for (int m = 0; m < recordlist.size(); ++m) {
                if (m != 0) {
                    errorMsgBuf.append("\u3001");
                }
                errorMsgBuf.append(recordlist.get(m));
            }
            return MessageFormat.format(tips, errorMsgBuf);
        }
        return "";
    }

    private static boolean checkIsOverLimit(Map<String, AtsControlLimitBean> map) {
        boolean flag = false;
        if (null != map && map.keySet().size() > 0) {
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                AtsControlLimitBean atsControlLimitBean = map.get(it.next().toString());
                if (!atsControlLimitBean.isOverLimit()) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private static StringBuffer processOverLimitMsg(Map<String, AtsControlLimitBean> map, String messageTemplate) {
        StringBuffer returnMsg = new StringBuffer();
        StringBuffer errorMSg = new StringBuffer();
        if (null != map) {
            Iterator<String> it = map.keySet().iterator();
            StringBuffer message = new StringBuffer();
            while (it.hasNext()) {
                List recordList;
                AtsControlLimitBean atsControlLimitBean = map.get(it.next().toString());
                if (!atsControlLimitBean.isOverLimit() || (recordList = atsControlLimitBean.getRecordList()).size() <= 0) continue;
                for (int i = 0; i < recordList.size(); ++i) {
                    if (i != 0) {
                        errorMSg.append("\u3001");
                    }
                    errorMSg.append((String)recordList.get(i));
                }
                returnMsg.append(MessageFormat.format(message.toString(), errorMSg, atsControlLimitBean.getDateValue(), atsControlLimitBean.getOTType()));
            }
        }
        return errorMSg;
    }
}

