/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsFillSignCardResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.FillSignCardCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignReasonCollection;
import com.kingdee.eas.hr.ats.FillSignReasonFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class FillSignCardHelper {
    public Map<String, Object> fillSignCardTimesControlHandler(Context ctx, String rowNums, String personIDs, String attendDates) {
        String[] rowNum = rowNums.split(",");
        String[] personID = personIDs.split(",");
        String[] attendDate = attendDates.split(",");
        Map<String, Object> errorMap = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> fillSignCardInfoMap = new HashMap<String, Map<String, String>>();
        this.fillSignCardInfoMapConstructor(rowNum, personID, attendDate, fillSignCardInfoMap);
        if (fillSignCardInfoMap.isEmpty()) {
            return null;
        }
        Map<String, Integer> FSCTimesAllowMap = this.fillSignCardTimesControlFilterOne(ctx, personIDs, fillSignCardInfoMap);
        Map<String, Map<String, String>> attendancePeriodMap = this.getAttendancePeriodByFillSignCardMulti(ctx, fillSignCardInfoMap);
        Map<String, Map> PatternMixedMap = this.countFillSingCardTimesAndSetPatternMulti(ctx, fillSignCardInfoMap, attendancePeriodMap);
        if (!(fillSignCardInfoMap.isEmpty() || FSCTimesAllowMap.isEmpty() || PatternMixedMap.isEmpty())) {
            errorMap = this.checkFillSignCardTimesCore(fillSignCardInfoMap, FSCTimesAllowMap, PatternMixedMap);
        }
        return errorMap;
    }

    public Map<String, String> havetAttencePolicy(Context ctx, String rowNums, String personIDs) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        String[] rowNum = rowNums.split(",");
        String[] personID = personIDs.split(",");
        AttendanceFileCollection attendanceFileColl = null;
        for (int i = 0; i < rowNum.length; ++i) {
            try {
                attendanceFileColl = AttendanceFileFactory.getRemoteInstance().getAttendanceFileCollection("where proposer = '" + personID[i] + "'");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (attendanceFileColl == null || attendanceFileColl.get(0) == null) {
                errorMap.put(rowNum[i], MLUtile.getRes(AtsFileResEnum.NotExistAtsFile, ctx));
                continue;
            }
            if (attendanceFileColl.get(0).getAttencePolicy() != null) continue;
            errorMap.put(rowNum[i], MLUtile.getRes(AtsAttenceResEnum.PersonWithoutAttencePolicy, ctx));
        }
        return errorMap;
    }

    public void fillSignCardInfoMapConstructor(String[] rowNum, String[] personID, String[] attendDate, Map<String, Map<String, String>> fillSignCardInfoMap) {
        for (int i = 0; i < rowNum.length; ++i) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            tmpMap.put("personId", personID[i]);
            tmpMap.put("attendDate", attendDate[i]);
            fillSignCardInfoMap.put(rowNum[i], tmpMap);
        }
    }

    public Map<String, Object> checkFillSignCardTimesCore(Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, Integer> FSCTimesAllowMap, Map<String, Map> PatternMixedMap) {
        Map PatternCodeMap = PatternMixedMap.get("PatternCodeMap");
        Map PatternTimesMap = PatternMixedMap.get("PatternTimesMap");
        HashMap PatternTimesMapOrigin = new HashMap();
        HashMap<Integer, Integer> PatternCurrentTimesMap = new HashMap<Integer, Integer>();
        PatternTimesMapOrigin.putAll(PatternTimesMap);
        HashMap<String, String> errorPersonMap = new HashMap<String, String>();
        ArrayList<Integer> errorPatternList = new ArrayList<Integer>();
        ArrayList<String> errorIndexList = new ArrayList<String>();
        for (String string : fillSignCardInfoMap.keySet()) {
            int patternCode = (Integer)PatternCodeMap.get(string);
            String personId = fillSignCardInfoMap.get(string).get("personId");
            int currentFSCTimes = (Integer)PatternTimesMap.get(patternCode);
            int FSCTimesAllow = FSCTimesAllowMap.get(personId);
            int currentTimes = 0;
            if (PatternCurrentTimesMap.containsKey(patternCode)) {
                currentTimes = (Integer)PatternCurrentTimesMap.get(patternCode);
            }
            if (currentTimes + 1 > FSCTimesAllow - currentFSCTimes) {
                errorPatternList.add(patternCode);
            }
            PatternCurrentTimesMap.put(patternCode, currentTimes + 1);
        }
        for (Map.Entry entry : PatternCodeMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!errorPatternList.contains(entry.getValue())) continue;
            errorIndexList.add(key);
            errorPersonMap.put(key, fillSignCardInfoMap.get(key).get("personId"));
        }
        if (errorIndexList.isEmpty()) {
            return null;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        Map map = PatternMixedMap.get("PatternDetailMap");
        resMap.put("errorIndexList", errorIndexList);
        resMap.put("errorPatternList", errorPatternList);
        resMap.put("PatternCodeMap", PatternCodeMap);
        resMap.put("PatternTimesMap", PatternTimesMapOrigin);
        resMap.put("PatternDetailMap", map);
        resMap.put("errorPersonMap", errorPersonMap);
        resMap.put("FSCTimesAllowMap", FSCTimesAllowMap);
        resMap.put("PatternCurrentTimesMap", PatternCurrentTimesMap);
        return resMap;
    }

    public Map<String, Integer> fillSignCardTimesControlFilterOne(Context ctx, String personIds, Map<String, Map<String, String>> fillSignCardInfoMap) {
        Map<String, Map> attencePolicyMap = this.getAttencePolicyMap(ctx);
        Map<String, String> attendanceFileMap = this.getAttendanceFileMap(ctx, personIds);
        HashMap<String, Integer> FSCTimesAllowMap = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            Map<String, String> tmpMap = entry.getValue();
            String personId = tmpMap.get("personId").toString();
            if (FSCTimesAllowMap.containsKey(personId)) continue;
            String attencePolicyId = attendanceFileMap.get(personId);
            if (attencePolicyId != null && !"".equals(attencePolicyId)) {
                Map tmpMap2 = attencePolicyMap.get(attencePolicyId);
                if (tmpMap2 != null) {
                    boolean isControlFSCTimes = Boolean.parseBoolean(tmpMap2.get("isControlFSCTimes").toString());
                    if (isControlFSCTimes) {
                        int fillSignCardTimesAllow = (Integer)tmpMap2.get("fillSignCardTimesAllow");
                        FSCTimesAllowMap.put(personId, fillSignCardTimesAllow);
                        continue;
                    }
                    it.remove();
                    continue;
                }
                it.remove();
                continue;
            }
            it.remove();
        }
        return FSCTimesAllowMap;
    }

    public Map<String, Map> getAttencePolicyMap(Context ctx) {
        HashMap<String, Map> attencePolicyMap = new HashMap<String, Map>();
        try {
            AttencePolicyCollection attencePolicyColl = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyCollection();
            for (int i = 0; i < attencePolicyColl.size(); ++i) {
                String attencePolicyBillId = attencePolicyColl.get(i).getId().toString();
                boolean isControlFSCTimes = attencePolicyColl.get(i).isIsControlFSCTimes();
                int fillSignCardTimesAllow = attencePolicyColl.get(i).getFillSignCardTimesAllow();
                HashMap<String, Comparable<Boolean>> tmpMap = new HashMap<String, Comparable<Boolean>>();
                tmpMap.put("isControlFSCTimes", Boolean.valueOf(isControlFSCTimes));
                tmpMap.put("fillSignCardTimesAllow", Integer.valueOf(fillSignCardTimesAllow));
                attencePolicyMap.put(attencePolicyBillId, tmpMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attencePolicyMap;
    }

    public Map<String, String> getAttendanceFileMap(Context ctx, String personIds) {
        HashMap<String, String> AttendanceFileMap = new HashMap<String, String>();
        personIds = this.uniqueString(personIds);
        String personIdsFormatter = "'" + personIds.replace(",", "','") + "'";
        try {
            AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("where proposer in (" + personIdsFormatter + ")");
            for (int i = 0; i < attendanceFileColl.size(); ++i) {
                String personId = attendanceFileColl.get(i).getProposer().getId().toString();
                String attencePolicyId = null;
                if (attendanceFileColl.get(i).getAttencePolicy() != null) {
                    attencePolicyId = attendanceFileColl.get(i).getAttencePolicy().getId().toString();
                }
                AttendanceFileMap.put(personId, attencePolicyId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return AttendanceFileMap;
    }

    public ArrayList<Map<String, String>> getAttendancePeriodByFillSignCardSingle(Context ctx, String personId, String attendDate) {
        ArrayList<Map<String, String>> resList = new ArrayList<Map<String, String>>();
        if ("".equals(personId) || personId == null) {
            return null;
        }
        StringBuffer Ksql = new StringBuffer();
        Ksql.append(" select d.fstartdate startdate,d.fenddate enddate \n").append("   from T_HR_ATS_AttendanceFile a \n").append("   left join T_HR_ATS_AttencePolicy b \n").append("     on a.FAttencePolicyID = b.fid \n").append("   left join T_ATS_AttenceCycle c \n").append("     on b.fattencecycleid = c.fid \n").append("   left join T_HR_ATS_AttendancePeriod d \n").append("     on c.fid = d.FGroupID \n").append(" where a.fproposerid = '" + personId + "' \n");
        if (!"".equals(attendDate) && attendDate != null) {
            Ksql.append(" and d.fstartdate <= {TS '" + attendDate + "'}\n").append(" and d.fenddate >= {TS '" + attendDate + "'}\n");
        }
        Ksql.append("order by d.fstartdate");
        try {
            IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)Ksql.toString());
            if (iRow.size() < 1) {
                return null;
            }
            while (iRow.next()) {
                String startDate = iRow.getString("startdate");
                String endDate = iRow.getString("enddate");
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("startDate", startDate);
                tempMap.put("endDate", endDate);
                resList.add(tempMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resList;
    }

    public Map<String, Map<String, String>> getAttendancePeriodByFillSignCardMulti(Context ctx, Map<String, Map<String, String>> fillSignCardInfoMap) {
        HashMap<String, Map<String, String>> resMap = new HashMap<String, Map<String, String>>();
        HashMap<String, ArrayList<Map<String, String>>> existMap = new HashMap<String, ArrayList<Map<String, String>>>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map<String, String> tempMap;
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            Map<String, String> fillSignCardInfo = entry.getValue();
            String personId = fillSignCardInfo.get("personId");
            String attendDate = fillSignCardInfo.get("attendDate");
            if ("".equals(personId) || personId == null) continue;
            if (!existMap.containsKey(personId)) {
                ArrayList<Map<String, String>> tempList = this.getAttendancePeriodByFillSignCardSingle(ctx, personId, "");
                if (tempList == null) {
                    it.remove();
                    continue;
                }
                existMap.put(personId, tempList);
            }
            if ((tempMap = this.getAttendancePeriodByScanExistList((ArrayList)existMap.get(personId), attendDate)) == null) {
                it.remove();
                continue;
            }
            resMap.put(index, tempMap);
        }
        return resMap;
    }

    public Map<String, String> getAttendancePeriodByScanExistList(ArrayList<Map<String, String>> existList, String attendDate) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (Map<String, String> tmp : existList) {
            String startDate = tmp.get("startDate");
            String endDate = tmp.get("endDate");
            if (!AtsDateUtils.stringToShortDate(attendDate).after(AtsDateUtils.stringToShortDate(startDate)) && !AtsDateUtils.stringToShortDate(attendDate).equals(AtsDateUtils.stringToShortDate(startDate)) || !AtsDateUtils.stringToShortDate(attendDate).before(AtsDateUtils.stringToShortDate(endDate)) && !AtsDateUtils.stringToShortDate(attendDate).equals(AtsDateUtils.stringToShortDate(endDate))) continue;
            resMap.put("startDate", startDate);
            resMap.put("endDate", endDate);
            return resMap;
        }
        return null;
    }

    public int getCurrentFillSignCardTimesSingle(Context ctx, String personId, String startDate, String endDate) {
        int resTimes = 0;
        StringBuffer Ksql = new StringBuffer();
        Ksql.append(" select count(*) total \n").append("   from t_hr_ats_fillsigncard a \n").append("   left join t_hr_ats_fillsigncardentry b \n").append("     on a.fid = b.fbillid \n").append("  where a.fbillstate in (1, 2, 3) \n").append("  and b.fpersonid='" + personId + "' \n").append("  and b.fattenddate >= {TS '" + startDate.substring(0, 10) + "'}\n").append("  and b.fattenddate <= {TS '" + endDate.substring(0, 10) + "'}\n");
        try {
            IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)Ksql.toString());
            iRow.next();
            resTimes = iRow.getInt("total");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resTimes;
    }

    public Map<String, Map> countFillSingCardTimesAndSetPatternMulti(Context ctx, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, Map<String, String>> attendancePeriodMap) {
        HashMap<String, Integer> PatternCodeMap = new HashMap<String, Integer>();
        HashMap<Integer, Integer> PatternTimesMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String[]> PatternDetailMap = new HashMap<Integer, String[]>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            String personId = entry.getValue().get("personId");
            Map<Object, Object> tempMap = new HashMap();
            tempMap = attendancePeriodMap.get(index);
            if (tempMap == null) {
                it.remove();
                continue;
            }
            String startDate = (String)tempMap.get("startDate");
            String endDate = (String)tempMap.get("endDate");
            int patternCode = (personId + startDate + endDate).hashCode();
            PatternCodeMap.put(index, patternCode);
            if (PatternTimesMap.containsKey(patternCode)) continue;
            int tmpCurrentFSCTimes = this.getCurrentFillSignCardTimesSingle(ctx, personId, startDate, endDate);
            PatternTimesMap.put(patternCode, tmpCurrentFSCTimes);
            String[] s = new String[]{startDate, endDate, personId};
            PatternDetailMap.put(patternCode, s);
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        if (PatternCodeMap.isEmpty() || PatternTimesMap.isEmpty()) {
            return resMap;
        }
        resMap.put("PatternCodeMap", PatternCodeMap);
        resMap.put("PatternTimesMap", PatternTimesMap);
        resMap.put("PatternDetailMap", PatternDetailMap);
        return resMap;
    }

    public String uniqueString(String arrString) {
        String[] initArray = arrString.split(",");
        String reString = "";
        LinkedList<String> resList = new LinkedList<String>();
        for (int i = 0; i < initArray.length; ++i) {
            if (resList.contains(initArray[i])) continue;
            resList.add(initArray[i]);
            reString = reString + initArray[i] + ",";
        }
        return reString.substring(0, reString.length() - 1);
    }

    public String errorInfoBuilderOne(Context ctx, Map<String, Object> errorInfo) throws EASBizException, BOSException {
        Map PatternTimesMap = (Map)errorInfo.get("PatternTimesMap");
        Map PatternDetailMap = (Map)errorInfo.get("PatternDetailMap");
        ArrayList errorPatternList = (ArrayList)errorInfo.get("errorPatternList");
        Map FSCTimesAllowMap = (Map)errorInfo.get("FSCTimesAllowMap");
        Map PatternCurrentTimesMap = (Map)errorInfo.get("PatternCurrentTimesMap");
        StringBuffer sb = new StringBuffer("");
        for (Integer patternCode : errorPatternList) {
            String startDate = ((String[])PatternDetailMap.get(patternCode))[0].substring(0, 10);
            String endDate = ((String[])PatternDetailMap.get(patternCode))[1].substring(0, 10);
            String personId = ((String[])PatternDetailMap.get(patternCode))[2];
            int currentFSCTimes = (Integer)PatternTimesMap.get(patternCode);
            int allowTimes = (Integer)FSCTimesAllowMap.get(personId);
            int leftTimes = allowTimes - currentFSCTimes;
            leftTimes = leftTimes < 0 ? 0 : leftTimes;
            int currentTimes = (Integer)PatternCurrentTimesMap.get(patternCode);
            ObjectUuidPK pk = new ObjectUuidPK(personId);
            PersonInfo ppi = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)pk);
            String personName = ppi.getName();
            sb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.RestFillSignTime1, ctx, personName, startDate, endDate, leftTimes));
        }
        return sb.toString();
    }

    public Map<String, String> errorInfoBuilderTwo(Context ctx, Map<String, Object> errorInfo) throws EASBizException, BOSException {
        Map PatternCodeMap = (Map)errorInfo.get("PatternCodeMap");
        Map PatternTimesMap = (Map)errorInfo.get("PatternTimesMap");
        Map PatternDetailMap = (Map)errorInfo.get("PatternDetailMap");
        Map errorPersonMap = (Map)errorInfo.get("errorPersonMap");
        ArrayList errorIndexList = (ArrayList)errorInfo.get("errorIndexList");
        Map FSCTimesAllowMap = (Map)errorInfo.get("FSCTimesAllowMap");
        Map PatternCurrentTimesMap = (Map)errorInfo.get("PatternCurrentTimesMap");
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (String index : errorIndexList) {
            int patternCode = (Integer)PatternCodeMap.get(index);
            String personId = (String)errorPersonMap.get(index);
            ObjectUuidPK pk = new ObjectUuidPK(personId);
            PersonInfo ppi = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
            String personName = ppi.getName();
            String startDate = ((String[])PatternDetailMap.get(patternCode))[0].substring(0, 10);
            String endDate = ((String[])PatternDetailMap.get(patternCode))[1].substring(0, 10);
            int currentFSCTimes = (Integer)PatternTimesMap.get(patternCode);
            int allowTimes = (Integer)FSCTimesAllowMap.get(personId);
            int leftTimes = allowTimes - currentFSCTimes;
            leftTimes = leftTimes < 0 ? 0 : leftTimes;
            int currentTimes = (Integer)PatternCurrentTimesMap.get(patternCode);
            StringBuffer sb = new StringBuffer("");
            sb.append(personName).append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.FillSignTimesInCycle, ctx, personName, startDate, endDate, currentTimes, leftTimes));
            resMap.put(index, sb.toString());
        }
        return resMap;
    }

    public static void deleteDataFromPunchCardRecord(String billIds) {
        if (billIds.trim().length() > 0) {
            String billFormatter = "('" + billIds.replaceAll(",", "','") + "')";
            try {
                FillSignCardCollection fillSignCardColl = FillSignCardFactory.getRemoteInstance().getFillSignCardCollection(" where id in " + billFormatter);
                if (fillSignCardColl.size() > 0) {
                    FillSignCardHelper.deleteDataFromPunchCardRecord(fillSignCardColl);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteDataFromPunchCardRecord(FillSignCardCollection fillSignCardColl) {
        HashMap<String, ArrayList<Timestamp>> fillSignCardFormatMap = new HashMap<String, ArrayList<Timestamp>>();
        int collLen = fillSignCardColl.size();
        for (int i = 0; i < collLen; ++i) {
            FillSignCardEntryCollection entries = fillSignCardColl.get(i).getEntries();
            for (int j = 0; j < entries.size(); ++j) {
                FillSignCardEntryInfo entryInfo = entries.get(j);
                String personId = entryInfo.getPerson().getId().toString();
                Timestamp fillCardTime = entryInfo.getFillCardTime();
                if (fillSignCardFormatMap.containsKey(personId)) {
                    ((ArrayList)fillSignCardFormatMap.get(personId)).add(fillCardTime);
                    continue;
                }
                ArrayList<Timestamp> tempArray = new ArrayList<Timestamp>();
                tempArray.add(fillCardTime);
                fillSignCardFormatMap.put(personId, tempArray);
            }
        }
        try {
            FillSignCardHelper.doPunchCardRecordDeleteAction(fillSignCardFormatMap);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void doPunchCardRecordDeleteAction(Map<String, ArrayList<Timestamp>> fillSignCardFormatMap) throws BOSException {
        for (Map.Entry<String, ArrayList<Timestamp>> entry : fillSignCardFormatMap.entrySet()) {
            StringBuffer sbMain = new StringBuffer();
            String personId = entry.getKey();
            sbMain.append(" where proposer.id = '" + personId + "'");
            StringBuffer sbTimeArray = new StringBuffer("");
            ArrayList<Timestamp> fillSignTimeArray = entry.getValue();
            for (int i = 0; i < fillSignTimeArray.size(); ++i) {
                if (i > 0) {
                    sbTimeArray.append(" or ");
                }
                sbTimeArray.append("punchCardTime = {TS '" + AtsDateUtils.timestampToString(fillSignTimeArray.get(i)) + "'}");
            }
            if (sbTimeArray.toString().length() > 0) {
                sbMain.append(" and (").append(sbTimeArray).append(")");
            }
            sbMain.append(" and punchCardSource = 2");
            FillSignCardHelper.doPunchCardRecordDeleteCore(sbMain.toString());
        }
    }

    public static void doPunchCardRecordDeleteCore(String filter) {
        try {
            IObjectPK[] iObjectPKArray = PunchCardRecordFactory.getRemoteInstance().delete(filter);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String isFillSignCardReasonEffective(String reasonId) throws BOSException, EASBizException, SQLException {
        String reasonName = "";
        if (!"".equals(reasonId) && reasonId != null) {
            FillSignReasonCollection fillSignReasonColl = FillSignReasonFactory.getRemoteInstance().getFillSignReasonCollection(" where id ='" + reasonId + "' and state = 1");
            if (fillSignReasonColl.size() < 1) {
                return null;
            }
            reasonName = fillSignReasonColl.get(0).getName();
        }
        return reasonName;
    }
}

