/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttencePolicyInfo;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.CancelLeaveAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillHolidayAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillHolidayCycleTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeCollection;
import com.kingdee.eas.hr.ats.HolidayTypeFactory;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsServerBizUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.TimeUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class HolidayPolicyParameterUtil {
    public static Boolean getIsCtrlLimit(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isCtrlLimit = false;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            isCtrlLimit = holidayPolicyInfo.isIsCtrlLimit();
        }
        return isCtrlLimit;
    }

    public static Boolean checkIsOverLeaveBillTimes(Context ctx, Timestamp startTime, Timestamp endTime, String personId, String holidayTypeId) throws EASBizException, BOSException {
        boolean isOver = true;
        int hasApp = 0;
        int allowLeaveTimes = 0;
        if (holidayTypeId != null) {
            HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            String beginTimeString = AtsDateUtils.timestampToString(startTime);
            String endTimeString = AtsDateUtils.timestampToString(endTime);
            paramsMap.put("proposerid", personId);
            paramsMap.put("beginTime", beginTimeString);
            paramsMap.put("endTime", endTimeString);
            paramsMap.put("policyId", holidayTypeId);
            paramsMap.put("policyInfo", holidayPolicyInfo);
            allowLeaveTimes = holidayPolicyInfo.getAllowLeaveTimes();
            if (allowLeaveTimes != 0) {
                Map<String, Object> allLeaveTimesMap = HolidayPolicyParameterUtil.getAllLeaveBillTimes(ctx, paramsMap);
                if ((Integer)allLeaveTimesMap.get("allTimes") > 0) {
                    hasApp = HolidayPolicyParameterUtil.getHasAppLeaveBillTimes(ctx, allLeaveTimesMap);
                    int limitSums = (Integer)allLeaveTimesMap.get("allTimes");
                    if (allowLeaveTimes * limitSums < hasApp + 1) {
                        isOver = false;
                    }
                } else {
                    Map<String, Object> infoMap = HolidayPolicyParameterUtil.getAllLeaveBillTimesOutPeriod(ctx, paramsMap);
                    hasApp = HolidayPolicyParameterUtil.getHasAppLeaveBillTimesOutPeriod(ctx, paramsMap, infoMap);
                    if (allowLeaveTimes < hasApp + 1) {
                        isOver = false;
                    }
                }
            }
        }
        return isOver;
    }

    public static Boolean getIsBeyondFillHolidayAmount(Context ctx, Timestamp endTime, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isBeyondFillHolidayAmount = false;
        Long endTimeLong = endTime.getTime();
        BigDecimal amount = HolidayPolicyParameterUtil.getFillHolidayAmount(ctx, personId, holidayTypeId);
        FillHolidayAmountUnitEnum unit = HolidayPolicyParameterUtil.getFillHolidayAmountUnit(ctx, personId, holidayTypeId);
        if (amount != null && unit != null) {
            if (unit == FillHolidayAmountUnitEnum.year) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, cal.get(1) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    isBeyondFillHolidayAmount = true;
                }
            } else if (unit == FillHolidayAmountUnitEnum.month) {
                Calendar cal = Calendar.getInstance();
                cal.set(2, cal.get(2) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    isBeyondFillHolidayAmount = true;
                }
            } else if (unit == FillHolidayAmountUnitEnum.day) {
                Calendar cal = Calendar.getInstance();
                cal.set(5, cal.get(5) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    isBeyondFillHolidayAmount = true;
                }
            }
        }
        return isBeyondFillHolidayAmount;
    }

    public static Boolean getIsFillHoliday(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isFillHoliday = false;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            isFillHoliday = holidayPolicyInfo.isIsFillHoliday();
        }
        return isFillHoliday;
    }

    public String validateIsFillHoliday(Context ctx, AtsLeaveBillInfo leaveBillInfo, AttendanceFileInfo attendanceFile) throws EASBizException, BOSException {
        String errorString = "";
        Calendar cal = Calendar.getInstance();
        Date applyDate = new Date();
        AtsLeaveBillInfo leaveBillInfoDB = leaveBillInfo;
        if (leaveBillInfo.getApplyDate() == null) {
            leaveBillInfoDB = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(leaveBillInfo.getId().toString()));
        }
        applyDate = leaveBillInfoDB.getApplyDate();
        cal.setTime(HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(leaveBillInfoDB.getApplyDate())));
        HashMap<String, AbstractAttencePolicyInfo> attencePolicyInfoMap = new HashMap<String, AbstractAttencePolicyInfo>();
        IAttendanceFile iAttendanceFile = AttendanceFileFactory.getLocalInstance(ctx);
        int entrySize = leaveBillInfo.getEntries().size();
        for (int i = 0; i < entrySize; ++i) {
            AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = leaveBillInfo.getEntries().get(i);
            String policyId = atsLeaveBillEntryInfo != null && atsLeaveBillEntryInfo.getPolicy() != null && atsLeaveBillEntryInfo.getPolicy().getId() != null ? atsLeaveBillEntryInfo.getPolicy().getId().toString() : "";
            String personId = atsLeaveBillEntryInfo != null && atsLeaveBillEntryInfo.getPerson() != null && atsLeaveBillEntryInfo.getPerson().getId() != null ? atsLeaveBillEntryInfo.getPerson().getId().toString() : "";
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("holidayType.name"));
            sic.add(new SelectorItemInfo("holidayType.id"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isFillHoliday"));
            sic.add(new SelectorItemInfo("fillHolidayAmount"));
            sic.add(new SelectorItemInfo("fillHolidayAmountUnit"));
            entityViewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)policyId));
            entityViewInfo.setFilter(filterInfo);
            HolidayPolicyCollection policyInfoCol = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(entityViewInfo);
            HolidayPolicyInfo policyInfo = policyInfoCol.get(0);
            long endTimeLong = leaveBillInfo.getEntries().get(i).getEndTime().getTime();
            Timestamp beginTimeStamp = leaveBillInfo.getEntries().get(i).getBeginTime();
            String beginTimeLongStr = HRTimeWebUtils.timestampToString(beginTimeStamp);
            Timestamp beginTimeShortStr = HRTimeWebUtils.stringShortToTimestamp(beginTimeLongStr.substring(0, 10));
            long beginTimeLong = beginTimeShortStr.getTime();
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            String nowTimeString = HRTimeWebUtils.timestampToString(nowTime);
            Timestamp nowTimeAfterDeal = HRTimeWebUtils.stringShortToTimestamp(nowTimeString.substring(0, 10));
            long nowTimeLong = nowTimeAfterDeal.getTime();
            if (nowTimeLong <= beginTimeLong) {
                return errorString;
            }
            boolean isFillHoliday = policyInfo.isIsFillHoliday();
            if (!isFillHoliday) {
                errorString = MLUtile.getRes(AtsLeaveBillResEnum.TypeUnsupportFillLeave, ctx) + "!";
                continue;
            }
            boolean isFillHolidayByTimeCtl = policyInfo.isFillHolidayByTimeCtl();
            boolean isFillHolidayByCycleCtrl = policyInfo.isFillHolidayByCycleCtl();
            if (isFillHolidayByTimeCtl) {
                BigDecimal amount = policyInfo.getFillHolidayAmount();
                FillHolidayAmountUnitEnum unit = policyInfo.getFillHolidayAmountUnit();
                if (amount != null && unit != null) {
                    if (unit == FillHolidayAmountUnitEnum.year) {
                        cal.set(1, cal.get(1) - amount.intValue());
                        if (beginTimeLong < cal.getTime().getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    } else if (unit == FillHolidayAmountUnitEnum.month) {
                        cal.set(2, cal.get(2) - amount.intValue());
                        if (beginTimeLong < cal.getTime().getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    } else if (unit == FillHolidayAmountUnitEnum.day) {
                        cal.set(5, cal.get(5) - amount.intValue());
                        if (beginTimeLong < cal.getTime().getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    } else if (unit == FillHolidayAmountUnitEnum.workDay) {
                        errorString = HolidayPolicyParameterUtil.validWorkDay(ctx, errorString, cal, personId, endTimeLong, amount);
                    }
                }
            }
            if (isFillHolidayByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                int fillHolidayCycleType = policyInfo.getFillHolidayCycleType().getValue();
                int afterDay = policyInfo.getFillHolidayAfterDay();
                if (0 == fillHolidayCycleType) {
                    int dayOfMonth = cal.get(5);
                    if (dayOfMonth <= afterDay) {
                        cal.set(2, cal.get(2) - 1);
                        Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                        if (beginTimeLong < preMonthFirstDay.getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    } else {
                        Calendar curCal = Calendar.getInstance();
                        Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(curCal.get(1) + "-" + (curCal.get(2) + 1) + "-01");
                        if (beginTimeLong < curMonthFirstDay.getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    }
                } else if (1 == fillHolidayCycleType) {
                    String attendanceCycleId = "";
                    if (attendanceFile == null) {
                        AttendanceFileCollection attendanceFileColl = iAttendanceFile.getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
                        attendanceFile = attendanceFileColl != null && attendanceFileColl.size() > 0 ? attendanceFileColl.get(0) : null;
                    }
                    AbstractAttencePolicyInfo attencePolicyInfo = null;
                    if (attendanceFile != null && attendanceFile.getAttencePolicy() != null) {
                        String attencePolicyId = attendanceFile.getAttencePolicy().getId().toString();
                        if (attencePolicyInfoMap.get(attencePolicyId) == null) {
                            attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
                            attencePolicyInfoMap.put(attencePolicyId, attencePolicyInfo);
                        } else {
                            attencePolicyInfo = (AttencePolicyInfo)attencePolicyInfoMap.get(attencePolicyId);
                        }
                    }
                    if (attencePolicyInfo != null && attencePolicyInfo.getAttenceCycle() != null) {
                        attendanceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                        if (policyInfo.getFillMonthAndDay() != FillAmountUnitEnum.mouthEndDay) {
                            AttendancePeriodInfo curPeriod;
                            Date nowDate = new Date();
                            AttendancePeriodCollection attendancePeriodCollection = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodCollection(" where group.id = '" + attendanceCycleId + "' order by endDate DESC");
                            AbstractAttendancePeriodInfo prePeriod = null;
                            int preIndex = 0;
                            for (int j = 0; j < attendancePeriodCollection.size(); ++j) {
                                AttendancePeriodInfo attendancePeriodInfo = attendancePeriodCollection.get(j);
                                if (attendancePeriodInfo.getEndDate().getTime() > nowDate.getTime()) continue;
                                prePeriod = attendancePeriodInfo;
                                preIndex = j;
                                break;
                            }
                            AttendancePeriodInfo attendancePeriodInfo = curPeriod = preIndex - 1 >= 0 ? attendancePeriodCollection.get(preIndex - 1) : null;
                            if (prePeriod != null) {
                                Date currDate;
                                Date startDate = prePeriod.getStartDate();
                                Date endDate = prePeriod.getEndDate();
                                Date addAfterDate = AtsDateUtils.dateAdd(endDate, 3, afterDay, false);
                                if (curPeriod != null && addAfterDate.getTime() > curPeriod.getEndDate().getTime()) {
                                    addAfterDate = curPeriod.getEndDate();
                                }
                                if ((currDate = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5))).getTime() > addAfterDate.getTime()) {
                                    if (curPeriod == null) {
                                        errorString = MLUtile.getRes(AtsAttenceCycleResEnum.NotExistsAndAdd, ctx);
                                    }
                                    if (curPeriod != null && curPeriod.getStartDate() != null && beginTimeLong < curPeriod.getStartDate().getTime()) {
                                        errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                                    }
                                } else if (beginTimeLong < startDate.getTime()) {
                                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                                }
                            }
                        } else if (!AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attendanceCycleId, afterDay, AtsDateUtils.dateShortToString(new Date(beginTimeLong)), applyDate).booleanValue()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                        }
                    } else {
                        int dayOfMonth = cal.get(5);
                        if (dayOfMonth <= afterDay) {
                            cal.set(2, cal.get(2) - 1);
                            Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                            if (beginTimeLong < preMonthFirstDay.getTime()) {
                                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                            }
                        } else {
                            Calendar curCal = Calendar.getInstance();
                            Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(curCal.get(1) + "-" + (curCal.get(2) + 1) + "-01");
                            if (beginTimeLong < curMonthFirstDay.getTime()) {
                                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                            }
                        }
                    }
                }
            }
            if (StringUtils.isEmpty((String)errorString) || leaveBillInfo.getBillType() == null) continue;
            if (leaveBillInfo.getBillType().getValue() == 1) {
                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                continue;
            }
            String personName = leaveBillInfo != null && leaveBillInfo.getEntries() != null && leaveBillInfo.getEntries().get(i) != null && leaveBillInfo.getEntries().get(i).getPerson() != null ? leaveBillInfo.getEntries().get(i).getPerson().getName() : "";
            String holidayType = policyInfo != null && policyInfo.getHolidayType() != null ? policyInfo.getHolidayType().getName() : "";
            errorString = personName + " " + holidayType + " " + errorString + "";
        }
        return errorString;
    }

    public static BigDecimal getFillHolidayAmount(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        BigDecimal fillHolidayAmount = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            fillHolidayAmount = holidayPolicyInfo.getFillHolidayAmount();
        }
        return fillHolidayAmount;
    }

    public static FillHolidayAmountUnitEnum getFillHolidayAmountUnit(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        FillHolidayAmountUnitEnum fillHolidayAmountUnit = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            fillHolidayAmountUnit = holidayPolicyInfo.getFillHolidayAmountUnit();
        }
        return fillHolidayAmountUnit;
    }

    public static HolidayPolicyInfo getHolidayPolicy(Context ctx, String personId, String holidayTypeId) throws BOSException, EASBizException {
        HolidayPolicyInfo holidayPolicyInfo;
        AtsHolidayFileCollection atsHolidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (atsHolidayFileColl.size() == 0) {
            return null;
        }
        if (atsHolidayFileColl.get(0).getHolidayPolicySet() == null) {
            return null;
        }
        HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + atsHolidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection("  where holidayPolicySet.id='" + holidayPolicySetInfo.getId().toString() + "' ");
        String holidayPolicyId = new String();
        int size = policyColl.size();
        for (int i = 0; i < size; ++i) {
            if (!holidayTypeId.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicyId = policyColl.get(i).getId().toString();
            break;
        }
        if ((holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id = '" + holidayPolicyId + "' ")) == null) {
            return null;
        }
        return holidayPolicyInfo;
    }

    public static Boolean getIsCancelLeave(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isCancelLeave = false;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            isCancelLeave = holidayPolicyInfo.isIsCancelLeave();
        }
        return isCancelLeave;
    }

    public static BigDecimal getCancelLeaveAmount(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        BigDecimal cancelLeaveAmount = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            cancelLeaveAmount = holidayPolicyInfo.getCancelLeaveAmount();
        }
        return cancelLeaveAmount;
    }

    public static CancelLeaveAmountUnitEnum getCancelLeaveAmountUnit(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        CancelLeaveAmountUnitEnum cancelLeaveAmountUnit = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            cancelLeaveAmountUnit = holidayPolicyInfo.getCancelLeaveAmountUnit();
        }
        return cancelLeaveAmountUnit;
    }

    public static Boolean getCanLeaveFillHolidayByCycleCtl(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isByCycleCtl = false;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            isByCycleCtl = holidayPolicyInfo.isFillHolidayCelByCycleCtl();
        }
        return isByCycleCtl;
    }

    public static Boolean getCanLeaveFillHolidayByTimeCtl(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        Boolean isByTimeCtl = false;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            isByTimeCtl = holidayPolicyInfo.isFillHolidayCelByTimeCtl();
        }
        return isByTimeCtl;
    }

    public static FillHolidayCycleTypeEnum getCancelLeaveAmountUnitByCycleCtl(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        FillHolidayCycleTypeEnum fillHolidayCycleTypeEnum = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            fillHolidayCycleTypeEnum = holidayPolicyInfo.getFillHolidayCelCycleType();
        }
        return fillHolidayCycleTypeEnum;
    }

    public static int getCancelLeaveAmountByCycleCtl(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        int fillHolidayAfterDay = 0;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            fillHolidayAfterDay = holidayPolicyInfo.getFillHolidayCelAfterDay();
        }
        return fillHolidayAfterDay;
    }

    public static FillAmountUnitEnum getCancelLeaveByCycleCtlAndFillMonthAndDay(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        FillAmountUnitEnum fillMonthAndDayCel = null;
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyParameterUtil.getHolidayPolicy(ctx, personId, holidayTypeId);
        if (holidayPolicyInfo != null) {
            fillMonthAndDayCel = holidayPolicyInfo.getFillMonthAndDayCel();
        }
        return fillMonthAndDayCel;
    }

    public static Map<String, Object> getAllLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        int times = 0;
        String proposerid = (String)paramsMap.get("proposerid");
        String beginTime = (String)paramsMap.get("beginTime");
        String endTime = (String)paramsMap.get("endTime");
        String policyId = (String)paramsMap.get("policyId");
        beginTime = beginTime.substring(0, 10) + " 00:00:00";
        endTime = endTime.substring(0, 10) + " 00:00:00";
        sql.append("select feffectDate,fdelayDate from T_HR_ATS_HolidayLimit  holiLimit ");
        sql.append(" inner join  T_HR_ATS_HolidayPolicy policy on policy.fid = holiLimit.fholidaypolicyid");
        sql.append(" where ");
        sql.append(" ({TS '" + beginTime + "'}<= feffectDate and feffectDate < {TS '" + endTime + "'}");
        sql.append(" or\t{TS '" + beginTime + "'}< fdelayDate and fdelayDate <= {TS '" + endTime + "'}");
        sql.append(" or\tfeffectDate<= {TS '" + beginTime + "'} and  {TS '" + endTime + "'}<= fdelayDate )");
        sql.append("and FProposerID = '" + proposerid + "' and policy.fholidayTypeid='" + policyId + "'");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList limitList = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> limitMap = new HashMap<String, String>();
                    String effectDate = rowSet.getString("feffectDate");
                    String delayDate = rowSet.getString("fdelayDate");
                    if (effectDate.length() > 19) {
                        effectDate = effectDate.substring(0, 19);
                    }
                    if (delayDate.length() > 19) {
                        delayDate = delayDate.substring(0, 10) + " 23:59:59";
                    }
                    limitMap.put("effectDate", effectDate);
                    limitMap.put("delayDate", delayDate);
                    limitList.add(limitMap);
                    ++times;
                }
                infoMap.put("limitDate", limitList);
            }
            infoMap.put("policyId", policyId);
            infoMap.put("proposerid", proposerid);
            infoMap.put("allTimes", times);
        }
        catch (BOSException e) {
            infoMap.put("allTimes", times);
            e.printStackTrace();
        }
        catch (SQLException s) {
            infoMap.put("allTimes", times);
            s.printStackTrace();
        }
        return infoMap;
    }

    public static Map<String, Object> getAllLeaveBillTimesOutPeriod(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        String proposerid = (String)paramsMap.get("proposerid");
        String beginTime = (String)paramsMap.get("beginTime");
        String endTime = (String)paramsMap.get("endTime");
        beginTime = beginTime.substring(0, 10) + " 00:00:00";
        endTime = endTime.substring(0, 10) + " 00:00:00";
        String policyId = (String)paramsMap.get("policyId");
        sql.append("select feffectDate,fdelayDate from T_HR_ATS_HolidayLimit  holiLimit ");
        sql.append(" inner join  T_HR_ATS_HolidayPolicy policy on policy.fid = holiLimit.fholidaypolicyid");
        sql.append(" where ");
        sql.append(" ( {TS '" + endTime + "'}<= feffectDate ");
        sql.append(" or\t{TS '" + beginTime + "'}>= fdelayDate ) ");
        sql.append(" and FProposerID = '" + proposerid + "' and policy.fholidayTypeid='" + policyId + "'");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList limitList = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> limitMap = new HashMap<String, String>();
                    String effectDate = rowSet.getString("feffectDate");
                    String delayDate = rowSet.getString("fdelayDate");
                    if (effectDate.length() > 19) {
                        effectDate = effectDate.substring(0, 19);
                    }
                    if (delayDate.length() > 19) {
                        delayDate = delayDate.substring(0, 10) + " 23:59:59";
                    }
                    limitMap.put("effectDate", effectDate);
                    limitMap.put("delayDate", delayDate);
                    limitList.add(limitMap);
                }
                infoMap.put("limitDate", limitList);
            }
            infoMap.put("policyId", policyId);
            infoMap.put("ProposerID", proposerid);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException s) {
            s.printStackTrace();
        }
        return infoMap;
    }

    public static int getHasAppLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        StringBuffer dateSql = new StringBuffer();
        List limitList = (List)paramsMap.get("limitDate");
        for (int i = 0; i < limitList.size(); ++i) {
            Map limitMap = (Map)limitList.get(i);
            String effectDate = (String)limitMap.get("effectDate");
            String delayDate = (String)limitMap.get("delayDate");
            dateSql.append(" ({TS '" + effectDate + "'}<= FBeginTime and FBeginTime < {TS '" + delayDate + "'}");
            dateSql.append(" or\t{TS '" + effectDate + "'}< FEndTime and FEndTime <= {TS '" + delayDate + "'}");
            dateSql.append(" or\tFBeginTime< {TS '" + effectDate + "'} and  {TS '" + delayDate + "'}< FEndTime ) or");
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select count(1)  from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where bill.FBillState <> 0 and bill.FBillState <> 4 and ");
        sql.append(" entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        if (dateSql.length() > 0) {
            String hql = dateSql.substring(0, dateSql.lastIndexOf("or") - 1);
            sql.append(" and (" + hql + " )");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    hasAppTimes = rowSet.getInt(1);
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static int getHasAppLeaveBillTimesByImport(Context ctx, Map<String, Object> paramsMap, Map<String, Object> billMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        StringBuffer dateSql = new StringBuffer();
        List limitList = (List)paramsMap.get("limitDate");
        for (int i = 0; i < limitList.size(); ++i) {
            Map limitMap = (Map)limitList.get(i);
            String effectDate = (String)limitMap.get("effectDate");
            String delayDate = (String)limitMap.get("delayDate");
            dateSql.append(" ({TS '" + effectDate + "'}<= FBeginTime and FBeginTime < {TS '" + delayDate + "'}");
            dateSql.append(" or\t{TS '" + effectDate + "'}< FEndTime and FEndTime <= {TS '" + delayDate + "'}");
            dateSql.append(" or\tFBeginTime< {TS '" + effectDate + "'} and  {TS '" + delayDate + "'}< FEndTime ) or");
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select entry.fid as fid from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where bill.FBillState <> 0 and bill.FBillState <> 4 and ");
        sql.append(" entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        if (dateSql.length() > 0) {
            String hql = dateSql.substring(0, dateSql.lastIndexOf("or") - 1);
            sql.append(" and (" + hql + " )");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    String fid = rowSet.getString("fid");
                    if (null != billMap.get(fid)) continue;
                    billMap.put(fid, fid);
                    ++hasAppTimes;
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static Map<String, Object> validatePreHolidayType(Context ctx, String personId, String strStartTime, String strEndTime, String hrOrgUnitId, String holidayTypeId) throws BOSException, EASBizException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        AtsHolidayFileHisCollection fileHisColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' and EFFDT <='" + strStartTime + "' and LEFFDT >='" + strEndTime + "' and attendFileState='1' order by effdt desc");
        if (fileHisColl != null && fileHisColl.size() > 0) {
            AtsHolidayFileHisInfo fileHisInfo = fileHisColl.get(0);
            if (fileHisInfo == null) {
                res.put("errorString", AtsServerBizUtil.noHolidayFile_msg.getMessage());
            }
            personId = fileHisInfo.getProposer().getId().toString();
            if (fileHisInfo.getHolidayPolicySet() == null) {
                res.put("errorString", AtsServerBizUtil.noHolidayPolicySet_msg.getMessage());
            }
            HolidayPolicySetInfo holidayPolicySetInfo = new HolidayPolicySetInfo();
            HolidayPolicyCollection policyColl = new HolidayPolicyCollection();
            try {
                holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + fileHisInfo.getHolidayPolicySet().getId().toString() + "' ");
                policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection("  where holidayPolicySet.id='" + holidayPolicySetInfo.getId().toString() + "' order by holidayType.number");
                String preHolidayTypes = "";
                for (int i = 0; i < policyColl.size(); ++i) {
                    HolidayPolicyInfo holidayPolicyInfo = policyColl.get(i);
                    HolidayTypeInfo holidayTypeInfo = holidayPolicyInfo.getHolidayType();
                    if (holidayTypeInfo == null || !holidayTypeId.equals(holidayTypeInfo.getId().toString())) continue;
                    preHolidayTypes = holidayPolicyInfo.getPreHolidayTypes();
                    break;
                }
                String[] preHolidayTypeStr = null;
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)preHolidayTypes)) {
                    preHolidayTypeStr = preHolidayTypes.split(",");
                }
                ArrayList<String> preHolidayTypeList = new ArrayList<String>();
                if (preHolidayTypeStr != null && preHolidayTypeStr.length > 0) {
                    boolean tempVal = false;
                    long b1 = 0L;
                    long e1 = 0L;
                    long b2 = 0L;
                    long e2 = 0L;
                    if (strStartTime.length() != 19 && strStartTime.length() > 10) {
                        strStartTime = strStartTime + ":00";
                    }
                    if (strEndTime.length() != 19 && strEndTime.length() > 10) {
                        strEndTime = strEndTime + ":00";
                    }
                    if (strStartTime.length() <= 10) {
                        strStartTime = strStartTime + " 00:00:00";
                    }
                    if (strEndTime.length() <= 10) {
                        strEndTime = strEndTime + " 00:00:00";
                    }
                    Timestamp beginTimeCount = TimeUtil.getBeginTimeStampNew(ctx, strStartTime, personId);
                    Timestamp endTimeCount = TimeUtil.getEndTimeStampNew(ctx, strEndTime, personId);
                    long leaveBillStartTime = beginTimeCount.getTime();
                    long leaveBillEndTime = endTimeCount.getTime();
                    for (int i = 0; i < preHolidayTypeStr.length; ++i) {
                        HolidayLimitCollection holidayLimitColl = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + preHolidayTypeStr[i] + "' and hrOrgUnit.id='" + hrOrgUnitId + "'   ");
                        if (holidayLimitColl == null || holidayLimitColl.size() <= 0) continue;
                        for (int j = 0; j < holidayLimitColl.size(); ++j) {
                            BigDecimal remainLimit;
                            b1 = leaveBillStartTime;
                            e1 = leaveBillEndTime;
                            b2 = holidayLimitColl.get(j).getEffectDate().getTime();
                            e2 = holidayLimitColl.get(j).getDelayDate().getTime() + 86400000L;
                            if (b1 < b2 || e1 >= e2 || BigDecimal.ZERO.compareTo(remainLimit = holidayLimitColl.get(j).getRemainLimit()) >= 0) continue;
                            preHolidayTypeList.add(preHolidayTypeStr[i]);
                        }
                    }
                }
                if (preHolidayTypeList != null && preHolidayTypeList.size() > 0) {
                    StringBuffer preHolidayTypeIds = new StringBuffer();
                    for (String preHolidayTypeId : preHolidayTypeList) {
                        preHolidayTypeIds.append("'" + preHolidayTypeId + "', ");
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)preHolidayTypeIds)) {
                        HolidayTypeCollection holidayTypeColl = HolidayTypeFactory.getLocalInstance(ctx).getHolidayTypeCollection(" where id in (" + preHolidayTypeIds.substring(0, preHolidayTypeIds.length() - 2) + ") ");
                        StringBuffer preHolidayTypeName = new StringBuffer();
                        if (holidayTypeColl != null && holidayTypeColl.size() > 0) {
                            for (int i = 0; i < holidayTypeColl.size(); ++i) {
                                HolidayTypeInfo holidayTypeInfo = holidayTypeColl.get(i);
                                if (holidayTypeInfo == null) continue;
                                preHolidayTypeName.append(holidayTypeInfo.getName() + ", ");
                            }
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)preHolidayTypeName)) {
                            res.put("errorString", MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.PreHolidayTypesFirst, ctx, preHolidayTypeName.substring(0, preHolidayTypeName.length() - 2)));
                        }
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return res;
    }

    public static int getHasAppLeaveBillTimesOutPeriod(Context ctx, Map<String, Object> paramsMap, Map<String, Object> infoMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        List limitList = (List)infoMap.get("limitDate");
        StringBuffer dateSql = new StringBuffer();
        if (limitList != null) {
            for (int i = 0; i < limitList.size(); ++i) {
                Map limitMap = (Map)limitList.get(i);
                String effectDate = (String)limitMap.get("effectDate");
                String delayDate = (String)limitMap.get("delayDate");
                dateSql.append(" ({TS '" + delayDate + "'} <FBeginTime ");
                dateSql.append(" or\t{TS '" + effectDate + "'}>  FEndTime ");
                dateSql.append(" ) and ");
            }
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select count(1)  from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where  ");
        if (dateSql.length() > 0) {
            sql.append(" " + dateSql);
        }
        sql.append(" bill.FBillState <> 0 and bill.FBillState <> 4 ");
        sql.append(" and entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    hasAppTimes = rowSet.getInt(1);
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static Date formatCalendar(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(year + "-" + (month + 1) + "-" + day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    protected static String validWorkDay(Context ctx, String errorString, Calendar cal, String personId, long endTimeLong, BigDecimal amount) throws BOSException {
        if (amount.intValue() == 0) {
            if (endTimeLong < cal.getTime().getTime()) {
                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
            }
        } else {
            AtsHolidayFileHisCollection fileHisColl;
            Date endDate = cal.getTime();
            AttendanceFileInfo attendanceFileInfo = AtsAttendanceFileUtils.getAttendanceFile(ctx, personId);
            if (attendanceFileInfo == null) {
                errorString = MLUtile.getRes(AtsFileResEnum.NotExistFile, ctx);
                return errorString;
            }
            Date beginDate = DateUtils.addDays((Date)endDate, (int)(-10 * amount.intValue()));
            if (beginDate.before(attendanceFileInfo.getEFFDT())) {
                beginDate = attendanceFileInfo.getEFFDT();
            }
            if ((fileHisColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' and EFFDT <='" + AtsDateUtils.dateLongToString(endDate) + "' and LEFFDT >='" + AtsDateUtils.dateLongToString(endDate) + "' and attendFileState='1' order by effdt desc")) == null || fileHisColl.size() == 0 || fileHisColl.get(0) == null) {
                errorString = MLUtile.getRes(AtsFileResEnum.NotExistFile, ctx);
                return errorString;
            }
            AtsHolidayFileHisInfo holidayFileHisInfo = fileHisColl.get(0);
            Map<String, ScheduleShiftInfo> scheduleShiftByPriority = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, AtsDateUtils.dateLongToString(beginDate), AtsDateUtils.dateLongToString(endDate));
            String calendarGroupId = null;
            calendarGroupId = attendanceFileInfo != null && attendanceFileInfo.getCalendar() != null ? attendanceFileInfo.getCalendar().getId().toString() : holidayFileHisInfo.getCalendar().getId().toString();
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(ctx).getWorkCalendarItemCollection(" where calendarGroup='" + calendarGroupId + "' and date>={ts'" + AtsDateUtils.dateLongToString(beginDate) + "'} and date <={ts'" + AtsDateUtils.dateLongToString(endDate) + "'} order by date asc ");
            Map<String, WorkCalendarItemInfo> workCalendarItemInfoMap = AtsCollectionUtile.list2Map(workCalendarItemColl, new AtsMapFn<WorkCalendarItemInfo, String>(){

                @Override
                public String map(WorkCalendarItemInfo workCalendarItemInfo) {
                    if (workCalendarItemInfo == null || workCalendarItemInfo.getDate() == null) {
                        return null;
                    }
                    return AtsDateUtils.dateShortToString(workCalendarItemInfo.getDate());
                }
            });
            Date compareDate = null;
            int days = amount.intValue();
            Date idxDate = endDate;
            while (days > 0) {
                String key = personId + "_" + AtsDateUtils.dateShortToString(idxDate);
                int dateType = 0;
                ScheduleShiftInfo scheduleShiftInfo = scheduleShiftByPriority.get(key);
                if (scheduleShiftInfo != null) {
                    dateType = scheduleShiftInfo.getDayType().getValue();
                } else {
                    WorkCalendarItemInfo workCalendarItemInfo = workCalendarItemInfoMap.get(AtsDateUtils.dateShortToString(idxDate));
                    dateType = workCalendarItemInfo.getDayType().getValue();
                }
                if (dateType == 0) {
                    --days;
                }
                if (days == 0) {
                    compareDate = idxDate;
                }
                idxDate = DateUtils.addDays((Date)idxDate, (int)-1);
            }
            if (compareDate != null && endTimeLong < compareDate.getTime()) {
                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
            }
        }
        return errorString;
    }
}

