/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.metasBuilder;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.hr.ats.metasBuilder.MetasBuilder;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ExceptMetasBuilder
extends MetasBuilder {
    protected int mainCode;
    protected List<JSONObject> BosExceptionItems;

    @Override
    protected void buildTitleInner(Element parentElement) {
        Element mainCodeEle = parentElement.element("mainCode");
        if (mainCodeEle == null) {
            mainCodeEle = parentElement.addElement("mainCode");
        }
        if (this.mainCode > 99 || this.mainCode < 1) {
            if (StringUtils.isNotBlank((String)mainCodeEle.getTextTrim())) {
                this.mainCode = Integer.valueOf(mainCodeEle.getTextTrim());
            } else {
                throw new IllegalArgumentException("mainCode is bigger than 99 or is not positive:" + this.name);
            }
        }
        mainCodeEle.setText((this.mainCode < 10 ? "0" : "") + this.mainCode);
        Element baseException = parentElement.element("baseException");
        if (baseException == null) {
            baseException = parentElement.addElement("baseException");
            baseException.addElement("key").addAttribute("name", "package").addAttribute("value", this.packageName);
            baseException.addElement("key").addAttribute("name", "name").addAttribute("value", "AtsBaseBizException");
        }
    }

    @Override
    protected void buildBodyInner(Element parentElement) {
        String subCode;
        Element bosResourceItem;
        Element bizExceptionSubItems = parentElement.element("bizExceptionSubItems");
        if (bizExceptionSubItems == null) {
            bizExceptionSubItems = parentElement.addElement("bizExceptionSubItems");
        }
        if (this.BosExceptionItems == null) {
            return;
        }
        HashMap<String, Element> savedExp = new HashMap<String, Element>();
        TreeMap<String, Element> allExp = new TreeMap<String, Element>();
        HashSet<String> allSubCodes = new HashSet<String>();
        for (Object expObj : bizExceptionSubItems.elements()) {
            bosResourceItem = (Element)expObj;
            savedExp.put(bosResourceItem.elementText("name"), bosResourceItem);
            subCode = bosResourceItem.elementText("subCode");
            while (allSubCodes.contains(subCode)) {
                subCode = Integer.valueOf(subCode) + 1 + "";
            }
            bosResourceItem.element("subCode").setText(subCode);
            allSubCodes.add(subCode);
            allExp.put(subCode + bosResourceItem.elementText("name"), bosResourceItem);
        }
        for (JSONObject item : this.BosExceptionItems) {
            bosResourceItem = (Element)savedExp.get(item.getString("name"));
            if (bosResourceItem == null) {
                bosResourceItem = bizExceptionSubItems.addElement("bizExceptionSubItem");
                bosResourceItem.addElement("name").setText(item.getString("name"));
            }
            subCode = item.getString("subCode");
            Element subCodeEle = bosResourceItem.element("subCode");
            Element element = subCodeEle = subCodeEle == null ? bosResourceItem.addElement("subCode") : subCodeEle;
            if (StringUtils.isNotBlank((String)subCode) && StringUtils.isBlank((String)subCodeEle.getText()) && AtsCommonUtile.isDigit(subCode) && subCode.length() == 3) {
                while (allSubCodes.contains(subCode)) {
                    subCode = Integer.valueOf(subCode) + 1 + "";
                }
                allSubCodes.add(subCode);
                subCodeEle.setText(subCode);
            }
            if (StringUtils.isBlank((String)subCodeEle.getText())) {
                throw new IllegalArgumentException("subCode should be three numbers:" + item);
            }
            Element msgEle = bosResourceItem.element("message");
            Element element2 = msgEle = msgEle == null ? bosResourceItem.addElement("message") : msgEle;
            if (StringUtils.isNotBlank((String)item.getString("message"))) {
                String fieldName = "bizExceptionSubItems.bizExceptionSubItem[" + item.get((Object)"name") + "].message";
                msgEle.setText(this.anchorName + fieldName);
                this.addResourceItem(fieldName, item.getString("message"));
            }
            if (StringUtils.isBlank((String)msgEle.getText())) {
                throw new IllegalArgumentException("message is required:" + bosResourceItem.elementText("name"));
            }
            bizExceptionSubItems.remove(bosResourceItem);
            allExp.put(bosResourceItem.elementText("subCode") + bosResourceItem.elementText("name"), bosResourceItem);
        }
        parentElement.remove(bizExceptionSubItems);
        bizExceptionSubItems = parentElement.addElement("bizExceptionSubItems");
        for (Element ele : allExp.values()) {
            ele.setParent(null);
            bizExceptionSubItems.add(ele);
        }
    }

    @Override
    protected String getJavaFileContent(Element metasEle) {
        StringBuffer file = new StringBuffer();
        file.append("package ").append(this.packageName).append(";\r\n");
        file.append("\r\n");
        file.append("import com.kingdee.util.NumericExceptionSubItem;\r\n");
        file.append("import com.kingdee.eas.hr.ats.AtsBaseBizException;\r\n");
        file.append("\r\n");
        file.append("\r\n");
        this.buildJavaFileDesc(file, metasEle);
        file.append("public class ").append(this.name).append(" extends AtsBaseBizException {\r\n");
        file.append("\r\n");
        file.append("\r\n");
        this.addExceptionSubItems(file, metasEle);
        this.addExceptionMethod(file);
        file.append("}");
        return file.toString();
    }

    protected void addExceptionSubItems(StringBuffer file, Element metasEle) {
        if (metasEle.getDocument() == null || metasEle.getDocument().getRootElement() == null) {
            return;
        }
        Element exceptionSubItems = metasEle.getDocument().getRootElement().element("bizExceptionSubItems");
        List resources = metasEle.getDocument().getRootElement().element("resource").elements("rs");
        if (exceptionSubItems == null || exceptionSubItems.elements() == null) {
            return;
        }
        file.append("\tprivate static final String MAINCODE = \"").append((this.mainCode < 10 ? "0" : "") + this.mainCode).append("\";\r\n");
        file.append("\r\n");
        String localeFlag = "zh_CN";
        for (Object item : exceptionSubItems.elements()) {
            Element exceptionSubItem = (Element)item;
            block1: for (Object rs : resources) {
                if (!(rs instanceof Element) || !exceptionSubItem.elementText("message").equals(((Element)rs).attributeValue("key"))) continue;
                for (Object lang : ((Element)rs).elements("lang")) {
                    if (!(lang instanceof Element) || !localeFlag.equals(((Element)lang).attributeValue("locale"))) continue;
                    file.append("\t/**\r\n\t *").append(((Element)lang).attributeValue("value")).append("\r\n\t */\r\n");
                    break block1;
                }
            }
            file.append("\t").append("public static final NumericExceptionSubItem ");
            file.append(exceptionSubItem.elementText("name").toUpperCase());
            file.append(" = new NumericExceptionSubItem(\"");
            file.append(exceptionSubItem.elementText("subCode")).append("\", \"");
            file.append(exceptionSubItem.elementText("name")).append("\");\r\n\r\n");
        }
        file.append("\r\n");
        file.append("\r\n");
    }

    protected void addExceptionMethod(StringBuffer file) {
        StringBuffer methods = new StringBuffer();
        methods.append("\tpublic ShrMlBizException(NumericExceptionSubItem info, Throwable cause, Object[] params) {\r\n");
        methods.append("\t\tsuper(info, cause, params);\r\n");
        methods.append("\t}\r\n");
        methods.append("\r\n");
        methods.append("\tpublic ShrMlBizException(NumericExceptionSubItem info, Object[] params) {\r\n");
        methods.append("\t\tthis(info, null, params);\r\n");
        methods.append("\t}\r\n");
        methods.append("\r\n");
        methods.append("\tpublic ShrMlBizException(NumericExceptionSubItem info, Throwable cause) {\r\n");
        methods.append("\t\tthis(info, cause, null);\r\n");
        methods.append("\t}\r\n");
        methods.append("\r\n");
        methods.append("\tpublic ShrMlBizException(NumericExceptionSubItem info) {\r\n");
        methods.append("\t\tthis(info, null, null);\r\n");
        methods.append("\t}\r\n");
        methods.append("\r\n");
        methods.append("\tpublic String getMainCode() {\r\n");
        methods.append("\t\t return MAINCODE;\r\n");
        methods.append("\t}\r\n");
        methods.append("\r\n");
        file.append(methods.toString().replaceAll("ShrMlBizException", this.name));
    }

    public int getMainCode() {
        return this.mainCode;
    }

    public void setMainCode(int mainCode) {
        this.mainCode = mainCode;
    }

    public List<JSONObject> getBosExceptionItems() {
        return this.BosExceptionItems;
    }

    public void setBosExceptionItems(List<JSONObject> bosExceptionItems) {
        this.BosExceptionItems = bosExceptionItems;
    }
}

