/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.pcRule;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.hr.ats.pcRule.GridDataEntity;
import com.kingdee.eas.hr.ats.pcRule.UuidGenerator;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.RowSetSizeParamConfig;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmpQueryImpl {
    private static final String QUERY_STORE_DATA = "query_store_data";
    private static final String TEMP_TABLE_NAME = "temp_table_name";
    private static final String QUERY_SQL = "query_sql";
    private static final String TEMP_TABLE_COUNT = "query_store_count";

    public static GridDataEntity execQuery(Context ctx, String function, SqlParam param) throws Exception {
        GridDataEntity gridData = null;
        gridData = param.isNeedDistinct() ? EmpQueryImpl.empQuery(ctx, function, param) : EmpQueryImpl.execQueryReal(ctx, function, param);
        return gridData;
    }

    public static GridDataEntity empQuery(Context ctx, String function, SqlParam param) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        String tempTableName = null;
        int totalCount = 0;
        String queryUuid = null;
        Map<String, Map<String, Object>> storeDatas = null;
        Map<String, Object> storeData = null;
        if (param.isSupportQueryUuid()) {
            queryUuid = param.getQueryUuid();
            storeDatas = EmpQueryImpl.getStoreDatas(ctx);
            storeData = storeDatas.get(queryUuid);
            if (storeData != null) {
                tempTableName = (String)storeData.get(TEMP_TABLE_NAME);
                totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
            }
        }
        boolean newSearch = param.isNewSearch();
        int rows = param.getRows();
        int page = param.getPage();
        if (page > 1) {
            newSearch = false;
        }
        String querySql = "";
        if (newSearch || tempTableName == null) {
            EmpQueryImpl.addSorterToSelect(param);
            if (tempTableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            String tempSql = "select * into " + tempTableName + " from (" + querySql + ") T ";
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from " + tempTableName));
            while (rs.next()) {
                totalCount = rs.getInt(1);
            }
            if (param.isSupportQueryUuid() && storeDatas != null) {
                storeDatas.remove(queryUuid);
                queryUuid = UuidGenerator.generate();
                storeData = new HashMap<String, Object>();
                storeData.put(TEMP_TABLE_NAME, tempTableName);
                storeData.put(TEMP_TABLE_COUNT, totalCount);
                storeDatas.put(queryUuid, storeData);
            }
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        int top = start + length;
        String sql = "SELECT TOP " + top + " * from " + tempTableName;
        if (param.getSorter() != null) {
            SorterItemInfo info = null;
            String orderby = " order by ";
            for (int i = 0; i < param.getSorter().size(); ++i) {
                if (i > 0) {
                    orderby = orderby + ",";
                }
                info = param.getSorter().get(i);
                orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
            }
            sql = sql + orderby;
        }
        PagingHelper pageHelper = new PagingHelper();
        int dbType = AtsBaseUtils.getDbType(ctx);
        List rowList = null;
        sql = pageHelper.getPagingSqlNoOptmize(dbType, sql, start, length);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        rowList = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setRecords(totalCount);
        gridData.setQueryUuid(queryUuid);
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        gridData.setPage(page);
        return gridData;
    }

    private static void addSorterToSelect(SqlParam param) {
        SorterItemCollection sorters = param.getSorter();
        if (sorters == null || sorters.isEmpty()) {
            return;
        }
        Map selectMapping = param.getSelectMapping();
        String propertyName = null;
        int size = sorters.size();
        for (int i = 0; i < size; ++i) {
            propertyName = sorters.get(i).getPropertyName();
            if (selectMapping.containsKey(propertyName)) continue;
            selectMapping.put(propertyName, propertyName);
        }
    }

    public static GridDataEntity execQueryReal(Context ctx, String function, SqlParam param) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        EmpQueryImpl.addSorterItemToSelector(param);
        String querySql = null;
        int totalCount = 0;
        String queryUuid = null;
        Map<String, Map<String, Object>> storeDatas = null;
        Map<String, Object> storeData = null;
        if (param.isSupportQueryUuid()) {
            queryUuid = param.getQueryUuid();
            storeDatas = EmpQueryImpl.getStoreDatas(ctx);
            storeData = storeDatas.get(queryUuid);
            if (storeData != null) {
                querySql = (String)storeData.get(QUERY_SQL);
                totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
            }
        }
        boolean newSearch = param.isNewSearch();
        int rows = param.getRows();
        int page = param.getPage();
        if (page > 1) {
            newSearch = false;
        }
        if (newSearch || querySql == null) {
            querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            String subSql = querySql.substring(querySql.indexOf("FROM"));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) " + subSql));
            if (rs.next()) {
                totalCount = rs.getInt(1);
            }
            if (param.isSupportQueryUuid() && storeData != null && !AtsCollectionUtile.isEmpty(storeDatas)) {
                storeDatas.remove(queryUuid);
                queryUuid = UuidGenerator.generate();
                storeData = new HashMap<String, Object>();
                storeData.put(QUERY_SQL, querySql);
                storeData.put(TEMP_TABLE_COUNT, totalCount);
                storeDatas.put(queryUuid, storeData);
            }
        }
        if (param.getSorter() != null) {
            SorterItemInfo info = null;
            String orderby = " order by ";
            for (int i = 0; i < param.getSorter().size(); ++i) {
                if (i > 0) {
                    orderby = orderby + ",";
                }
                info = param.getSorter().get(i);
                orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
            }
            querySql = querySql + orderby;
        }
        if (param.isAll()) {
            rows = totalCount;
            page = 1;
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        List rowList = EmpQueryImpl.doPagingQuery(ctx, param, querySql, start, length);
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setRecords(totalCount);
        gridData.setQueryUuid(queryUuid);
        int n = rows = 0 == rows ? 1 : rows;
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        gridData.setPage(page);
        return gridData;
    }

    private static List doPagingQuery(Context ctx, SqlParam param, String querySql, int start, int length) throws Exception {
        int maxPagingRowSize = EmpQueryImpl.getMaxPagingRowSize(param);
        int pagingRowSize = Math.min(length, maxPagingRowSize);
        int currentIndex = start;
        int dbType = AtsBaseUtils.getDbType(ctx);
        ArrayList rowList = new ArrayList();
        List rows = null;
        PagingHelper pageHelper = new PagingHelper();
        for (int fetchRowSize = 0; fetchRowSize < length; fetchRowSize += pagingRowSize) {
            int top = currentIndex + pagingRowSize;
            if (top > start + length) {
                top = start + length;
                pagingRowSize = top - currentIndex;
            }
            String sql = querySql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
            sql = pageHelper.getPagingSqlNoOptmize(dbType, sql, currentIndex, pagingRowSize);
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            rows = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
            rowList.addAll(rows);
            currentIndex = top;
        }
        return rowList;
    }

    private static int getMaxPagingRowSize(SqlParam param) {
        return new RowSetSizeParamConfig().getCollectionExceptionSize() / param.getSelectMapping().size();
    }

    private static void addSorterItemToSelector(SqlParam param) {
        SorterItemCollection sorter = param.getSorter();
        if (sorter == null) {
            return;
        }
        String fieldName = null;
        Map selector = param.getSelectMapping();
        int size = sorter.size();
        for (int i = 0; i < size; ++i) {
            fieldName = sorter.get(i).getPropertyName();
            if (selector.containsKey(fieldName)) continue;
            selector.put(fieldName, fieldName);
        }
    }

    private static Map<String, Map<String, Object>> getStoreDatas(Context ctx) {
        HashMap storeDatas = (HashMap)ctx.get((Object)QUERY_STORE_DATA);
        if (storeDatas == null) {
            storeDatas = new HashMap();
            ctx.put((Object)QUERY_STORE_DATA, storeDatas);
        }
        return storeDatas;
    }

    public static void removeStoreData(Context ctx, String key) {
        Map<String, Map<String, Object>> storeDatas = EmpQueryImpl.getStoreDatas(ctx);
        storeDatas.remove(key);
    }
}

