/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AtsBasicItemPermApi {
    public static Map<String, String> getAdminOrgSet(Context ctx) throws BOSException {
        HashMap<String, String> adminOrgSet = new HashMap<String, String>();
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection();
        String keyStr = "";
        for (int i = 0; i < adminOrgUnitCollection.size(); ++i) {
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(i);
            keyStr = adminOrgUnitInfo.getLongNumber().trim();
            String fid = adminOrgUnitInfo.getId().toString();
            if (adminOrgSet.containsKey(keyStr)) continue;
            adminOrgSet.put(keyStr, fid);
        }
        return adminOrgSet;
    }

    public static Set<String> getRangeAdminOrgIdBylongNumber(Context ctx, Set<String> orgsFilter) {
        if (orgsFilter.isEmpty() || orgsFilter.size() <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT adminats.FID FID,adminats.FNAME" + MLUtile.getMlFlag(ctx) + " name,adminats.FLONGNUMBER FLONGNUMBER");
        sql.append("  FROM T_ORG_ADMIN adminats WHERE  ");
        sql.append("adminats.FLONGNUMBER  IN ( ");
        sql.append(AtsBasicItemPermApi.setConvertToString(orgsFilter));
        sql.append(" ) ");
        sql.append(" order by flongnumber ");
        HashSet<String> orgIdsSet = new HashSet<String>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String fid = rowSet.getString("FID");
                orgIdsSet.add(fid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return orgIdsSet;
    }

    public static Set<String> getResponseOrgs(Context ctx, String adminAuthSql) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT adminats.FID FID,adminats.FNAME" + MLUtile.getMlFlag(ctx) + " FNAME" + MLUtile.getMlFlag(ctx) + ",adminats.FLONGNUMBER FLONGNUMBER");
        sql.append("  FROM T_ORG_ADMIN adminats WHERE  ");
        sql.append("adminats.FID  IN ( ");
        sql.append(adminAuthSql);
        sql.append(" ) ");
        sql.append(" order by flongnumber ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> orgsFilter = new HashSet<String>();
        try {
            while (rowSet.next()) {
                String longnumber = rowSet.getString("flongnumber");
                if (orgsFilter.contains(longnumber)) continue;
                orgsFilter.add(longnumber);
                while (longnumber.indexOf("!") > 0 && !orgsFilter.contains(longnumber = longnumber.substring(0, longnumber.lastIndexOf("!")))) {
                    orgsFilter.add(longnumber);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return AtsBasicItemPermApi.getRangeAdminOrgIdBylongNumber(ctx, orgsFilter);
    }

    public static boolean parentExist(HashSet parentSet, String longnumber) {
        while (longnumber.indexOf("!") > 0) {
            if (!parentSet.contains(longnumber = longnumber.substring(0, longnumber.lastIndexOf("!")))) continue;
            return true;
        }
        return false;
    }

    public static String setConvertToString(Set<String> set) {
        Iterator<String> iter = set.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            sb.append("'" + iter.next().trim() + "',");
        }
        return sb.substring(0, sb.lastIndexOf(","));
    }

    public static String getAtsAvailableBasicItemSQL(Context ctx, String hrId, String adminSql, Set<String> authOrgs, String tableName) {
        if (StringUtils.isEmpty((String)adminSql) || StringUtils.isEmpty((String)hrId) || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer fitlerSQL = new StringBuffer();
        if (authOrgs != null && !authOrgs.isEmpty()) {
            fitlerSQL.append(" SELECT FID FROM ");
            fitlerSQL.append(tableName);
            fitlerSQL.append(" WHERE ");
            fitlerSQL.append(" FHRORGUNITID NOT IN (" + hrId + " )  ");
            fitlerSQL.append(" OR ( FHRORGUNITID IN (" + hrId + " )");
            fitlerSQL.append("     AND ");
            fitlerSQL.append("    FADMINORGUNITID IN ( " + AtsBasicItemPermApi.setConvertToString(authOrgs) + " )");
            fitlerSQL.append("  )");
        }
        return fitlerSQL.toString();
    }

    public static String getAtsAvailableBasicItemSQL(Context ctx, String hrId, String adminSql, String tableName) {
        if (StringUtils.isEmpty((String)adminSql) || StringUtils.isEmpty((String)hrId) || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer fitlerSQL = new StringBuffer();
        try {
            Set<String> authOrgs = AtsBasicItemPermApi.getResponseOrgs(ctx, adminSql);
            if (authOrgs != null && !authOrgs.isEmpty()) {
                fitlerSQL.append(" SELECT FID FROM ");
                fitlerSQL.append(tableName);
                fitlerSQL.append(" WHERE ");
                fitlerSQL.append(" FHRORGUNITID NOT IN (" + hrId + " )  ");
                fitlerSQL.append(" OR ( FHRORGUNITID IN (" + hrId + " )");
                fitlerSQL.append("     AND ");
                fitlerSQL.append("    FADMINORGUNITID IN ( " + AtsBasicItemPermApi.setConvertToString(authOrgs) + " )");
                fitlerSQL.append("  )");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fitlerSQL.toString();
    }

    public static String getAtsMaintainBasicItemSQL(Context ctx, String hrId, String adminSql, String tableName) {
        if (StringUtils.isEmpty((String)adminSql) || StringUtils.isEmpty((String)hrId) || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer fitlerSQL = new StringBuffer();
        fitlerSQL.append(" SELECT FID FROM ");
        fitlerSQL.append(tableName);
        fitlerSQL.append(" WHERE ");
        fitlerSQL.append(" FHRORGUNITID NOT IN (" + hrId + " )  ");
        fitlerSQL.append(" OR ( FHRORGUNITID IN (" + hrId + " )");
        fitlerSQL.append("     AND ");
        fitlerSQL.append("    FADMINORGUNITID IN ( " + adminSql + " )");
        fitlerSQL.append("  )");
        return fitlerSQL.toString();
    }
}

