/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.thread.executor;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskIdGenerator;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorABS;
import com.kingdee.eas.hr.ats.thread.executor.TaskStatus;
import com.kingdee.eas.hr.ats.thread.executor.Thread;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class TaskExecutorBase<V>
extends TaskExecutorABS<V> {
    private Timestamp createTime;
    private Timestamp startTime;
    private Timestamp endTime;
    private boolean needExecuteRightNow = false;
    private long userdTime;
    private long totalTime;
    private long outComeHoldTime;
    private Timestamp outComeFetchTime;
    private int sameTaskCount = 1;
    private String taskId;
    private String catalog;
    private String taskName;
    private String taskDesc;
    private StringBuffer exceptionMsg = new StringBuffer();
    private Throwable exception;
    private TaskStatus taskStatus;
    private Future<V> future;
    private Thread thread;

    public TaskExecutorBase() {
        AtsLog.getLog().info((Object)("before_init:" + this));
        this.init();
        AtsLog.getLog().info((Object)("after_init:" + this));
        this.taskStatus = TaskStatus.READY;
        this.createTime = new Timestamp(System.currentTimeMillis());
        this.taskId = TaskIdGenerator.getIdWithTime();
    }

    @Override
    public final V execute() {
        V v = null;
        try {
            if (this.ctx != null && this.ctx.getLocale() != null) {
                ContextUtils.setLocaleToThread((Locale)this.ctx.getLocale());
            }
            this.startTime = AtsCommonUtile.getTimeStamp();
            AtsLog.getLog().info((Object)("before_execute:" + this));
            this.beforeExecute();
            AtsLog.getLog().info((Object)("executting:" + this));
            this.taskStatus = TaskStatus.RUNNING;
            v = this.executeInner();
        }
        catch (InterruptedException e) {
            this.exception = e;
            Thread.currentThread().interrupt();
            this.addExceptionMsg(e.getMessage());
            AtsLog.getLog().error((Object)e);
        }
        catch (Exception e) {
            this.exception = e;
            this.taskStatus = TaskStatus.EXCEPTION;
            this.addExceptionMsg(e.getMessage());
            AtsLog.getLog().error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.thread = null;
            this.endTime = AtsCommonUtile.getTimeStamp();
            this.userdTime = this.endTime.getTime() - this.startTime.getTime();
            if (this.taskStatus == TaskStatus.RUNNING) {
                this.taskStatus = TaskStatus.FINISH;
            }
            AtsLog.getLog().info((Object)("after_execute:" + this));
            this.afterExecute();
        }
        return v;
    }

    protected abstract V executeInner() throws Exception;

    protected void init() {
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    public TaskExecutorBase<V> setWaitingstatus() {
        AtsLog.getLog().info((Object)("task_waiting:" + this));
        this.taskStatus = TaskStatus.WAITTING;
        return this;
    }

    public boolean stopTask(String message) {
        if (this.hasEnd()) {
            AtsLog.getLog().info((Object)("try_stope_endTask:" + this));
            return true;
        }
        AtsLog.getLog().info((Object)("task_stoped:" + this));
        this.taskStatus = TaskStatus.STOPPED;
        this.endTime = AtsCommonUtile.getTimeStamp();
        long l = this.userdTime = this.startTime == null ? 0L : this.endTime.getTime() - this.startTime.getTime();
        if (message != null) {
            this.addExceptionMsg(message);
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
            this.thread = null;
        }
        return true;
    }

    public V fetch() throws InterruptedException, ExecutionException {
        if (this.future != null) {
            V v = this.future.get();
            this.outComeFetchTime = AtsCommonUtile.getTimeStamp();
            return v;
        }
        throw new IllegalArgumentException(this.toString());
    }

    @Override
    public TaskExecutorBase<V> setCtx(Context ctx) {
        super.setCtx(ctx);
        return this;
    }

    public Throwable getException() {
        return this.exception;
    }

    public TaskExecutorBase<V> setException(Throwable e) {
        this.exception = e;
        return this;
    }

    public boolean hasEnd() {
        return this.endTime != null;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public int getSameTaskCount() {
        return this.sameTaskCount;
    }

    public void setSameTaskCount(int sameTaskCount) {
        this.sameTaskCount = sameTaskCount;
    }

    public long getUserdTime() {
        return this.userdTime;
    }

    public void setUserdTime(long userdTime) {
        this.userdTime = userdTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public long getOutComeHoldTime() {
        return this.outComeHoldTime;
    }

    public void setOutComeHoldTime(long outComeHoldTime) {
        this.outComeHoldTime = outComeHoldTime;
    }

    public Timestamp getOutComeFetchTime() {
        return this.outComeFetchTime;
    }

    public TaskExecutorBase<V> setOutComeFetchTime(Timestamp outComeFetchTime) {
        this.outComeFetchTime = outComeFetchTime;
        return this;
    }

    public Thread getThread() {
        return this.thread;
    }

    public TaskExecutorBase<V> setThread(Thread thread) {
        this.thread = thread;
        return this;
    }

    public boolean isNeedExecuteRightNow() {
        return this.needExecuteRightNow;
    }

    public TaskExecutorBase<V> setNeedExecuteRightNow(boolean needExecuteRightNow) {
        this.needExecuteRightNow = needExecuteRightNow;
        return this;
    }

    public Future<V> getFuture() {
        return this.future;
    }

    public TaskExecutorBase<V> setFuture(Future<V> future) {
        this.future = future;
        return this;
    }

    public TaskExecutorBase<V> addExceptionMsg(Object msg) {
        this.getExceptionMsg().append(msg).append(";");
        return this;
    }

    public TaskExecutorBase<V> addExceptionMsg(Object msg, Throwable e) {
        this.getExceptionMsg().append(msg).append(";");
        this.setException(e);
        return this;
    }

    public StringBuffer getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void setExceptionMsg(StringBuffer exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskExecutorBase other = (TaskExecutorBase)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    @Override
    public TaskExecutorBase<V> setDependency(Object dependency) {
        super.setDependency(dependency);
        return this;
    }

    public String toString() {
        return "TaskExecutorBase [taskId=" + this.taskId + ", taskStatus=" + (Object)((Object)this.taskStatus) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", userdTime=" + this.userdTime + ", totalTime=" + this.totalTime + ", outComeHoldTime=" + this.outComeHoldTime + ", outComeFetchTime=" + this.outComeFetchTime + ", sameTaskCount=" + this.sameTaskCount + ", createTime=" + this.createTime + ", catalog=" + this.catalog + ", taskName=" + this.taskName + ", taskDesc=" + this.taskDesc + "]";
    }
}

