/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractScheduleShiftInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftElasticDirection;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.BreastFeedingTypeCollection;
import com.kingdee.eas.hr.ats.BreastFeedingTypeFactory;
import com.kingdee.eas.hr.ats.BreastFeedingTypeInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IAtsLeaveBillDetail;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsPrepareDataHelper;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class AtsLeaveBillSplitHelper {
    private AtsLeaveBillInfo billInfo;
    private AtsLeaveBillEntryInfo atsLeaveBillEntryInfo;
    private Context ctx;
    private String personId;
    private Boolean isIncludeLegal;
    private Boolean isIncludeRest;
    private HolidayPolicyInfo holidayPolicyInfo;
    private BigDecimal sourceLen = new BigDecimal(0);
    private BigDecimal defaultStandardHour = BigDecimal.valueOf(24L);
    private int decimalPlaceValue = 2;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.util.AtsLeaveBillSplitHelper");

    public AtsLeaveBillSplitHelper(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        this.billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='" + this.billInfo.getId().toString() + "'");
        this.atsLeaveBillEntryInfo = billEntryColl.get(0);
        this.ctx = ctx;
        this.personId = this.atsLeaveBillEntryInfo.getPerson().getId().toString();
        this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id='" + this.atsLeaveBillEntryInfo.getPolicy().getId().toString() + "'");
        this.isIncludeLegal = this.holidayPolicyInfo.isIsIncludeLegal();
        this.isIncludeRest = this.holidayPolicyInfo.isIsIncludeRest();
        this.decimalPlaceValue = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
    }

    public AtsLeaveBillSplitHelper(Context ctx, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo) throws EASBizException, BOSException {
        this.billInfo = billInfo;
        this.atsLeaveBillEntryInfo = atsLeaveBillEntryInfo;
        this.ctx = ctx;
        this.personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id='" + atsLeaveBillEntryInfo.getPolicy().getId().toString() + "'");
        this.isIncludeLegal = this.holidayPolicyInfo.isIsIncludeLegal();
        this.isIncludeRest = this.holidayPolicyInfo.isIsIncludeRest();
        this.decimalPlaceValue = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
    }

    public void splitLeaveBill() throws EASBizException, BOSException {
        logger.info((Object)(MLUtile.getRes(AtsLeaveBillResEnum.StartSplitLeaveBill, this.ctx) + "..."));
        Timestamp beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
        Timestamp endTime = this.atsLeaveBillEntryInfo.getRealEndTime();
        List dateList = this.getLeaveDateColl(beginTime, endTime);
        List dateListAfter = this.dealDateNew(dateList);
        String oql = " select holidayPolicySet.isHalfDayOff,holidayPolicySet.isHalfDayOff,holidayPolicySet.amStartWorkTime,holidayPolicySet.amEndWorkTime,holidayPolicySet.pmStartWorkTime,holidayPolicySet.pmEndWorkTime where proposer.id='" + this.personId + "' and attendFileState='1' ";
        AtsHolidayFileInfo holidayFileInfo = AtsHolidayFileFactory.getLocalInstance(this.ctx).getAtsHolidayFileInfo(oql);
        Map<String, Object> dateLenMap = null;
        HolidayPolicySetInfo holidayPolicySetInfo = holidayFileInfo.getHolidayPolicySet();
        dateLenMap = null != this.holidayPolicyInfo && null != this.holidayPolicyInfo.getHolidayType() && this.holidayPolicyInfo.getHolidayType().getId().toString().equals("8r0AAAAMhrv9LVKY") && null != this.atsLeaveBillEntryInfo.getBfType() && !this.atsLeaveBillEntryInfo.getBfType().getId().toString().equals("8r0AAAA09p9IT3K3") ? this.calRealLeaveLengthOfBF(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, holidayPolicySetInfo, this.holidayPolicyInfo) : (null != this.holidayPolicyInfo && this.holidayPolicyInfo.isIsHalfDayOff() ? this.calRealLeaveLengthOfDay(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, holidayPolicySetInfo, this.holidayPolicyInfo) : this.calRealLeaveLengthInfo(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, this.holidayPolicyInfo));
        this.insertleaveBillDetail(dateLenMap);
        logger.info((Object)(MLUtile.getRes(AtsLeaveBillResEnum.EndSplitLeaveBill, this.ctx) + "..."));
    }

    private void insertleaveBillDetailHour(List<Date> dateListAfter) throws BOSException, EASBizException {
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo(this.ctx, this.personId);
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(this.ctx, personInfo.getId().toString());
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        if (dateListAfter.size() == 0) {
            return;
        }
        BigDecimal standardHour = this.getStandardHour(this.personId, dateListAfter.get(0));
        Double standardHourDouble = standardHour.doubleValue();
        Double tempDouble = leaveLengthDouble % standardHourDouble;
        tempDouble = BigDecimal.valueOf(tempDouble).setScale(2, 4).doubleValue();
        AtsLeaveBillDetailInfo leaveBillDetailInfofirst = new AtsLeaveBillDetailInfo();
        for (int i = 0; i < dateListAfter.size(); ++i) {
            if (!(leaveLengthDouble > 0.0)) continue;
            AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
            leaveBillDetailInfo.setLeavebill(this.billInfo);
            leaveBillDetailInfo.setProposer(personInfo);
            leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
            leaveBillDetailInfo.setLeaveUnit(this.atsLeaveBillEntryInfo.getRealUnit());
            leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo);
            leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
            if (i == 0) {
                if (tempDouble != 0.0) {
                    leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
                    leaveBillDetailInfofirst = leaveBillDetailInfo;
                    leaveLengthDouble = leaveLengthDouble - tempDouble;
                    continue;
                }
                leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
                leaveBillDetailInfofirst = leaveBillDetailInfo;
                leaveLengthDouble = leaveLengthDouble - standardHourDouble;
                continue;
            }
            leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
            leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
            leaveLengthDouble = leaveLengthDouble - standardHourDouble;
        }
        if (leaveLengthDouble > 0.0) {
            leaveBillDetailInfofirst.setLeaveLength(leaveBillDetailInfofirst.getLeaveLength().add(BigDecimal.valueOf(leaveLengthDouble)));
        }
        leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfofirst);
        IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(this.ctx);
        leaveBillDetail.addnewBatchData(leaveBillDetailColl);
    }

    private void insertleaveBillDetailDay(List<Date> dateListAfter) throws BOSException, EASBizException {
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo(this.ctx, this.personId);
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(this.ctx, personInfo.getId().toString());
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        Double leaveLength = leaveLengthDouble;
        for (int i = 0; i < dateListAfter.size(); ++i) {
            if (!(leaveLengthDouble > 0.0)) continue;
            AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
            leaveBillDetailInfo.setLeavebill(this.billInfo);
            leaveBillDetailInfo.setProposer(personInfo);
            leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
            leaveBillDetailInfo.setLeaveUnit(this.atsLeaveBillEntryInfo.getRealUnit());
            leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo);
            leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
            Double tempDouble = leaveLengthDouble % 1.0;
            if (i == 0 && tempDouble != 0.0) {
                leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
                leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
                leaveLengthDouble = leaveLengthDouble - tempDouble;
                continue;
            }
            leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(1L));
            leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
            leaveLengthDouble = leaveLengthDouble - 1.0;
        }
        IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(this.ctx);
        leaveBillDetail.addnewBatchData(leaveBillDetailColl);
    }

    private void insertleaveBillDetail(Map<String, Object> dateLenMap) throws BOSException, EASBizException {
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo(this.ctx, this.personId);
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        HolidayTypeUnitEnum holidayTypeUnit = this.atsLeaveBillEntryInfo.getRealUnit();
        Object[] key = dateLenMap.keySet().toArray();
        Arrays.sort(key);
        BigDecimal leavelen = this.atsLeaveBillEntryInfo.getRealLeaveLength();
        Map<Object, Object> map = new HashMap();
        try {
            AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(this.ctx, HRTimeWebUtils.stringShortToTimestamp(key[0].toString()), HRTimeWebUtils.stringShortToTimestamp(key[key.length - 1].toString()), this.personId, null);
            AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = null;
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(this.ctx).getAtsHolidayFileHisCollection("where proposer.id='" + this.personId + "'  order by effdt asc");
            if (null != atsHolidayFileHisCollection && atsHolidayFileHisCollection.size() > 0) {
                for (int i = 0; i < atsHolidayFileHisCollection.size(); ++i) {
                    AtsHolidayFileHisInfo atsHolidayFileHis = atsHolidayFileHisCollection.get(i);
                    if (HRTimeWebUtils.stringShortToTimestamp(key[0].toString()).getTime() < atsHolidayFileHis.getEFFDT().getTime() || HRTimeWebUtils.stringShortToTimestamp(key[key.length - 1].toString()).getTime() > atsHolidayFileHis.getLEFFDT().getTime()) continue;
                    atsHolidayFileHisInfo = atsHolidayFileHisCollection.get(i);
                }
            }
            map = AtsServerCalUtils.getWorkCalendarItemInfoByDate(this.ctx, key[0].toString(), key[key.length - 1].toString(), attendanceFileHisInfo, atsHolidayFileHisInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int len = key.length;
        for (int i = 0; i < len; ++i) {
            String keyStr;
            WorkCalendarItemInfo workCalendarItemInfo;
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(this.ctx, this.personId, AtsDateUtils.stringToShortDate(key[i].toString()));
            if (scheduleShiftInfo == null && ((workCalendarItemInfo = (WorkCalendarItemInfo)map.get(keyStr = key[i].toString().substring(0, 10))) == null || workCalendarItemInfo.getDayType() == null || !this.holidayPolicyInfo.isIsIncludeRest() && (null == workCalendarItemInfo || workCalendarItemInfo.getDayType() == DayTypeEnum.restDay || workCalendarItemInfo.getDayType() == DayTypeEnum.legalHoliday))) continue;
            Map dateMap = (Map)dateLenMap.get(key[i]);
            BigDecimal tempLen = new BigDecimal(0);
            if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                tempLen = BigDecimal.valueOf((Double)dateMap.get("calDay"));
                if (this.holidayPolicyInfo.isIsRoundSum()) {
                    tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(this.holidayPolicyInfo, tempLen));
                }
                if (leavelen.compareTo(tempLen) > 0 && i != len - 1) {
                    leavelen = leavelen.subtract(tempLen);
                } else {
                    tempLen = leavelen;
                }
            } else {
                tempLen = BigDecimal.valueOf((Double)dateMap.get("calHour"));
                if (this.holidayPolicyInfo.isIsRoundSum()) {
                    tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(this.holidayPolicyInfo, tempLen));
                }
                if (leavelen.compareTo(tempLen) > 0 && i != len - 1) {
                    tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(this.holidayPolicyInfo, tempLen));
                    leavelen = leavelen.subtract(tempLen);
                } else {
                    tempLen = leavelen;
                }
            }
            List<Map<String, Object>> dateList = this.getLeaveSuchScheduleDetal(AtsDateUtils.stringShortToTimestamp(key[i].toString().substring(0, 10)), this.personId, tempLen);
            for (int j = 0; j < dateList.size(); ++j) {
                Map<String, Object> mapSplit = dateList.get(j);
                AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
                Date currDate = AtsDateUtils.stringToShortDate((String)key[i]);
                leaveBillDetailInfo.setLeavebill(this.billInfo);
                leaveBillDetailInfo.setProposer(personInfo);
                leaveBillDetailInfo.setLeaveDate(currDate);
                leaveBillDetailInfo.setLeaveUnit(holidayTypeUnit);
                leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo);
                leaveBillDetailInfo.setAdminOrgUnit(this.atsLeaveBillEntryInfo.getAdminOrgUnit());
                leaveBillDetailInfo.setLeavebillEntry(this.atsLeaveBillEntryInfo);
                leaveBillDetailInfo.setLeaveLength((BigDecimal)mapSplit.get("leaveLength"));
                leaveBillDetailInfo.setPreTime((String)mapSplit.get("beginTime"));
                leaveBillDetailInfo.setNextTime((String)mapSplit.get("endTime"));
                String attAdminOrgUnitid = (String)mapSplit.get("attAdminOrgUnit");
                AdminOrgUnitInfo info = AdminOrgUnitFactory.getLocalInstance((Context)this.ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(attAdminOrgUnitid));
                leaveBillDetailInfo.setAttAdminOrgUnit(info);
                leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
            }
            if (leavelen.compareTo(BigDecimal.valueOf(0L)) == 0) break;
        }
        IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance(this.ctx);
        leaveBillDetail.addnewBatchData(leaveBillDetailColl);
    }

    private List<Map<String, Object>> getLeaveSuchScheduleDetal(Timestamp date, String personId, BigDecimal dataLen) throws BOSException {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(this.ctx, date, date, personId, null);
        Object scheduleShiftInfo = null;
        HashMap<Object, Object> defaultItemMap = new HashMap();
        AtsShiftItemCollection shiftItemColl = new AtsShiftItemCollection();
        try {
            String curBeginTime;
            AtsShiftItemInfo shiftItemInfo;
            CoreBaseInfo info;
            int i;
            HashMap<String, Object> dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(this.ctx, personId, date, this.holidayPolicyInfo.isIsFixOTAllowLeave());
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)((Object)dateMap.get("scheduleShiftItemColl"));
            if (null == scheduleShiftItemColl || scheduleShiftItemColl.size() == 0) {
                defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(this.ctx, attendanceFileHisInfo, this.holidayPolicyInfo);
                this.defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
                shiftItemColl = (AtsShiftItemCollection)((Object)defaultItemMap.get("scheduleShiftItemColl"));
                for (i = 0; i < shiftItemColl.size(); ++i) {
                    info = shiftItemColl.get(i);
                    info.setString("adminOrgUnit", attendanceFileHisInfo.getAttAdminOrgUnit().getId().toString());
                }
            } else {
                this.defaultStandardHour = (BigDecimal)dateMap.get("standardHour");
                for (i = 0; i < scheduleShiftItemColl.size(); ++i) {
                    info = scheduleShiftItemColl.get(i);
                    AtsShiftItemInfo shiftItemInfo2 = this.createScheduleShiftItemToAtsShiftItem(this.ctx, (ScheduleShiftItemInfo)info);
                    shiftItemInfo2.setString("adminOrgUnit", attendanceFileHisInfo.getAttAdminOrgUnit().getId().toString());
                    shiftItemInfo2.getGroup().setIsElastic(info.getGroup().isIsElastic());
                    shiftItemInfo2.getGroup().setElasticDirection(info.getGroup().getElasticDirection());
                    shiftItemInfo2.getGroup().setElasticType(info.getGroup().getElasticType());
                    shiftItemInfo2.getGroup().setElasticValue(info.getGroup().getElasticValue());
                    if (info.getGroup().isIsElastic() && this.atsLeaveBillEntryInfo.isIsElasticCalLen() && i == scheduleShiftItemColl.size() - 1 && shiftItemInfo2.getGroup().getElasticDirection() == AtsShiftElasticDirection.next) {
                        BigDecimal elasticValue = shiftItemInfo2.getGroup().getElasticValue();
                        String dateTimeStr = AtsDateUtils.timestampToString(date).substring(0, 10) + " " + shiftItemInfo2.getNextTime() + ":00";
                        Timestamp newTime = new Timestamp(AtsDateUtils.stringToTimestamp(dateTimeStr).getTime() + elasticValue.longValue() * 60L * 60L * 1000L);
                        shiftItemInfo2.setNextTime(AtsDateUtils.timestampToString(newTime).substring(11, 16));
                    }
                    shiftItemColl.add(shiftItemInfo2);
                }
            }
            Timestamp beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
            Timestamp endTime = this.atsLeaveBillEntryInfo.getEndTime();
            if (shiftItemColl.size() <= 0) {
                HashMap<String, Object> dataSpiltMap = new HashMap<String, Object>();
                dataSpiltMap.put("beginTime", "00:00");
                dataSpiltMap.put("endTime", "23:59");
                dataSpiltMap.put("leaveLength", dataLen);
                dataSpiltMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                list.add(dataSpiltMap);
                return list;
            }
            shiftItemColl.sort("segment");
            String curDate = HRTimeWebUtils.timestampToString(date);
            String dateBeginTime = HRTimeWebUtils.timestampToString(beginTime);
            String dateEndTime = HRTimeWebUtils.timestampToString(endTime);
            Map<String, Object> res = this.getIsCtrlHalfDayOff(this.ctx);
            boolean isHalfDayOff = (Boolean)res.get("isHalfDayOff");
            if (curDate.equals(dateBeginTime.substring(0, 10) + " 00:00:00")) {
                if (isHalfDayOff) {
                    beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
                    endTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + res.get("pmEndTime") + ":00");
                } else {
                    shiftItemInfo = shiftItemColl.get(0);
                    String preDate = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate);
                    Timestamp shiftItemStarTime = HRTimeWebUtils.stringToTimestamp(preDate + " " + shiftItemInfo.getPreTime() + ":00");
                    if (shiftItemStarTime.getTime() > beginTime.getTime()) {
                        beginTime = shiftItemStarTime;
                    }
                    shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
                    if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
                        String nextTime = this.getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate);
                        endTime = HRTimeWebUtils.stringToTimestamp(nextTime + " " + shiftItemInfo.getNextTime() + ":00");
                    }
                }
            }
            if (curDate.equals(dateEndTime.substring(0, 10) + " 00:00:00")) {
                if (isHalfDayOff) {
                    if (!curDate.equals(dateBeginTime.substring(0, 10) + " 00:00:00")) {
                        beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + res.get("amBeginTime") + ":00");
                    }
                    endTime = this.atsLeaveBillEntryInfo.getRealEndTime();
                } else {
                    String dateEndTime1;
                    Timestamp shiftItemEndTime;
                    shiftItemInfo = shiftItemColl.get(0);
                    if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
                        curBeginTime = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
                        beginTime = HRTimeWebUtils.stringToTimestamp(curBeginTime + " " + shiftItemInfo.getPreTime() + ":00");
                    }
                    if ((shiftItemEndTime = HRTimeWebUtils.stringToTimestamp((dateEndTime1 = this.getCurDate((shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1)).getNextTimeDayType().getValue(), dateEndTime.substring(0, 10))).substring(0, 10) + " " + shiftItemInfo.getNextTime() + ":00")).getTime() < endTime.getTime()) {
                        AtsShiftInfo shiftInfo = shiftItemInfo.getGroup();
                        if (!this.atsLeaveBillEntryInfo.isIsElasticCalLen() || !shiftInfo.isIsElastic() || shiftInfo.getElasticType() != AtsShiftElasticType.commuteElastic) {
                            endTime = shiftItemEndTime;
                        }
                    }
                }
            }
            if (!curDate.substring(0, 10).equals(dateEndTime.substring(0, 10)) && !curDate.substring(0, 10).equals(dateBeginTime.substring(0, 10))) {
                if (isHalfDayOff) {
                    beginTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + res.get("amBeginTime") + ":00");
                    endTime = HRTimeWebUtils.stringToTimestamp(curDate.substring(0, 10) + " " + res.get("pmEndTime") + ":00");
                } else {
                    shiftItemInfo = shiftItemColl.get(0);
                    curBeginTime = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
                    beginTime = HRTimeWebUtils.stringToTimestamp(curBeginTime + " " + shiftItemInfo.getPreTime() + ":00");
                    if (beginTime.getTime() <= this.atsLeaveBillEntryInfo.getRealBeginTime().getTime()) {
                        beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
                    }
                    shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
                    String curEndTime = this.getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate.substring(0, 10));
                    endTime = HRTimeWebUtils.stringToTimestamp(curEndTime.substring(0, 10) + " " + shiftItemInfo.getNextTime() + ":00");
                }
            }
            list = this.getSpiltDate(beginTime, endTime, shiftItemColl, dataLen, curDate.substring(0, 10));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return list;
    }

    private List<Map<String, Object>> getSpiltDate(Timestamp beginDate, Timestamp endDate, AtsShiftItemCollection shiftItemColl, BigDecimal dataLen, String curDate) {
        List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        AtsShiftItemCollection collection = new AtsShiftItemCollection();
        AtsShiftItemCollection overTimecoll = new AtsShiftItemCollection();
        for (int i = 0; i < shiftItemColl.size(); ++i) {
            AtsShiftItemInfo info = shiftItemColl.get(i);
            String preDay = this.getCurDate(info.getPreTimeDayType().getValue(), curDate);
            Timestamp perTime = HRTimeWebUtils.stringToTimestamp(preDay + " " + info.getPreTime() + ":00");
            String nextDay = this.getCurDate(info.getNextTimeDayType().getValue(), curDate);
            Timestamp nextTime = HRTimeWebUtils.stringToTimestamp(nextDay + " " + info.getNextTime() + ":00");
            if ((beginDate.getTime() > nextTime.getTime() || perTime.getTime() > endDate.getTime()) && (!info.getGroup().isIsElastic() || !this.atsLeaveBillEntryInfo.isIsElasticCalLen())) continue;
            if (!this.holidayPolicyInfo.isIsFixOTAllowLeave()) {
                if (info.getAttendanceType() != AttendanceTypeEnum.normalAttance && info.getAttendanceType() != AttendanceTypeEnum.normalAttanceExcludExcep) continue;
                collection.add(info);
                continue;
            }
            if (info.getAttendanceType() == AttendanceTypeEnum.normalAttance || info.getAttendanceType() == AttendanceTypeEnum.normalAttanceExcludExcep) {
                collection.add(info);
                continue;
            }
            overTimecoll.add(info);
        }
        BigDecimal billTime = this.defaultStandardHour.multiply(new BigDecimal(3600000));
        this.sourceLen = dataLen.setScale(this.decimalPlaceValue, RoundingMode.HALF_UP);
        Map<String, Object> res = this.getIsCtrlHalfDayOff(this.ctx);
        boolean isHalfDayOff = (Boolean)res.get("isHalfDayOff");
        if (isHalfDayOff) {
            if (beginDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate + " " + res.get("amBeginTime") + ":00").getTime() && endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate + " " + res.get("pmEndTime") + ":00").getTime()) {
                HashMap<String, Object> dayMap = new HashMap<String, Object>();
                if (this.holidayPolicyInfo.getUnit() == HolidayTypeUnitEnum.day) {
                    if (dataLen.compareTo(new BigDecimal(1)) < 0) {
                        dayMap.put("leaveLength", dataLen);
                    } else {
                        dayMap.put("leaveLength", new BigDecimal(1));
                    }
                } else if (dataLen.compareTo(this.defaultStandardHour) < 0) {
                    dayMap.put("leaveLength", this.defaultStandardHour.divide(new BigDecimal(2), this.decimalPlaceValue, RoundingMode.HALF_UP));
                } else {
                    dayMap.put("leaveLength", this.defaultStandardHour);
                }
                dayMap.put("beginTime", res.get("amBeginTime"));
                dayMap.put("endTime", res.get("pmEndTime"));
                dayMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(dayMap);
            } else if (beginDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate + " " + res.get("amBeginTime") + ":00").getTime() && endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate + " " + res.get("amEndTime") + ":00").getTime() || endDate.getTime() == HRTimeWebUtils.stringToTimestamp(curDate + " " + res.get("pmBeginTime") + ":00").getTime()) {
                HashMap<String, Object> amMap = new HashMap<String, Object>();
                amMap.put("leaveLength", this.sourceLen);
                amMap.put("beginTime", res.get("amBeginTime"));
                amMap.put("endTime", res.get("amEndTime"));
                amMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(amMap);
            } else {
                HashMap<String, Object> pmMap = new HashMap<String, Object>();
                pmMap.put("leaveLength", this.sourceLen);
                pmMap.put("beginTime", res.get("pmBeginTime"));
                pmMap.put("endTime", res.get("pmEndTime"));
                pmMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(pmMap);
            }
        } else {
            dataList = this.getDataSpiltMap(dataList, collection, curDate, beginDate, endDate, billTime, this.defaultStandardHour);
            if (overTimecoll.size() > 0) {
                dataList = this.getDataSpiltMap(dataList, overTimecoll, curDate, beginDate, endDate, billTime, this.defaultStandardHour);
            }
            if (this.sourceLen.compareTo(new BigDecimal(0)) == 1) {
                Map<String, Object> dataSpiltMap = dataList.get(dataList.size() - 1);
                BigDecimal leaveLength = this.sourceLen.add((BigDecimal)dataSpiltMap.get("leaveLength"));
                dataList.get(dataList.size() - 1).put("leaveLength", leaveLength);
            }
        }
        return dataList;
    }

    private List<Map<String, Object>> getDataSpiltMap(List<Map<String, Object>> dataList, AtsShiftItemCollection collection, String curDate, Timestamp beginDate, Timestamp endDate, BigDecimal billTime, BigDecimal defaultHour) {
        HashMap shiftMap = new HashMap();
        for (int i = 0; i < collection.size(); ++i) {
            BigDecimal time;
            BigDecimal item;
            if (this.sourceLen.compareTo(new BigDecimal(0)) != 1) continue;
            HashMap<String, Object> dataSpiltMap = new HashMap<String, Object>();
            AtsShiftItemInfo info = collection.get(i);
            AtsShiftInfo shiftInfo = info.getGroup();
            String beginTime = this.getCurDate(info.getPreTimeDayType().getValue(), curDate);
            Timestamp perTime = HRTimeWebUtils.stringToTimestamp(beginTime + " " + info.getPreTime() + ":00");
            String endTime = this.getCurDate(info.getNextTimeDayType().getValue(), curDate);
            Timestamp nextTime = HRTimeWebUtils.stringToTimestamp(endTime + " " + info.getNextTime() + ":00");
            if (this.atsLeaveBillEntryInfo.isIsElasticCalLen() && shiftInfo.isIsElastic() && shiftInfo.getElasticType() == AtsShiftElasticType.commuteElastic) {
                if (AtsShiftElasticDirection.next == shiftInfo.getElasticDirection()) {
                    if (i == collection.size() - 1) {
                        Date nextTimed = new Date(nextTime.getTime() + shiftInfo.getElasticValue().multiply(new BigDecimal(3600000)).longValue());
                        nextTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateLongToString(nextTimed));
                    }
                } else if (AtsShiftElasticDirection.pre == shiftInfo.getElasticDirection() && i == 0) {
                    Date perTimed = new Date(perTime.getTime() - shiftInfo.getElasticValue().multiply(new BigDecimal(3600000)).longValue());
                    perTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateLongToString(perTimed));
                }
            }
            if (i == 0 && i != collection.size() - 1) {
                BigDecimal item2;
                BigDecimal time2 = new BigDecimal(0);
                BigDecimal segmentinrest = BigDecimal.ZERO;
                if (collection.get(i).getSegmentInRest() != null) {
                    segmentinrest = collection.get(i).getSegmentInRest().multiply(new BigDecimal(60000));
                }
                if (nextTime.getTime() >= endDate.getTime()) {
                    if (beginDate.getTime() <= perTime.getTime()) {
                        beginDate = perTime;
                    }
                    if ((item2 = new BigDecimal(endDate.getTime() - beginDate.getTime())).compareTo(BigDecimal.ZERO) <= 0) continue;
                    time2 = item2.divide(billTime, this.decimalPlaceValue, 4);
                    dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString(beginDate).substring(11, 16));
                    dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString(endDate).substring(11, 16));
                } else {
                    item2 = new BigDecimal(nextTime.getTime() - beginDate.getTime());
                    if (segmentinrest.compareTo(BigDecimal.ZERO) > 0) {
                        item2 = item2.compareTo(segmentinrest) > 0 ? item2.subtract(segmentinrest) : BigDecimal.ZERO;
                    }
                    if (item2.compareTo(BigDecimal.ZERO) <= 0) continue;
                    time2 = item2.divide(billTime, this.decimalPlaceValue, 4);
                    dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString(beginDate).substring(11, 16));
                    dataSpiltMap.put("endTime", info.getNextTime());
                }
                this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, time2);
            } else if (i == collection.size() - 1 || endDate.getTime() <= nextTime.getTime()) {
                if (endDate.getTime() >= nextTime.getTime()) {
                    endDate = nextTime;
                }
                item = new BigDecimal(endDate.getTime() - perTime.getTime());
                if (this.atsLeaveBillEntryInfo.isIsElasticCalLen() && shiftInfo.isIsElastic() && shiftInfo.getElasticType() == AtsShiftElasticType.commuteElastic) {
                    if (endDate.getTime() >= nextTime.getTime()) {
                        endDate = nextTime;
                    }
                    item = new BigDecimal(endDate.getTime() - beginDate.getTime());
                    time = item.divide(billTime, this.decimalPlaceValue, 4);
                    dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString(beginDate).substring(11, 16));
                    dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString(endDate).substring(11, 16));
                    this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, time);
                } else {
                    if (item.compareTo(BigDecimal.ZERO) <= 0) continue;
                    time = item.divide(billTime, this.decimalPlaceValue, 4);
                    dataSpiltMap.put("beginTime", info.getPreTime());
                    dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString(endDate).substring(11, 16));
                    this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, time);
                }
            } else {
                item = new BigDecimal(nextTime.getTime() - perTime.getTime());
                if (item.compareTo(BigDecimal.ZERO) <= 0) continue;
                time = item.divide(billTime, this.decimalPlaceValue, 4);
                dataSpiltMap.put("beginTime", info.getPreTime());
                dataSpiltMap.put("endTime", info.getNextTime());
                this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, time);
            }
            dataSpiltMap.put("attAdminOrgUnit", info.getString("adminOrgUnit"));
            dataList.add(dataSpiltMap);
        }
        return dataList;
    }

    private String getCurDate(int dateType, String curDate) {
        Date date = HRTimeWebUtils.stringToShortDate(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (dateType == 0) {
            calendar.add(5, -1);
        } else if (dateType == 2) {
            calendar.add(5, 1);
        }
        return simpleDateFormat.format(calendar.getTime());
    }

    private BigDecimal getBigDecimal(BigDecimal defaultHour, Map<String, Object> dataSpiltMap, BigDecimal time) {
        BigDecimal value = new BigDecimal(0);
        value = this.holidayPolicyInfo.getUnit().getValue() == 1 ? time : defaultHour.multiply(time).setScale(this.decimalPlaceValue, 4);
        if (this.sourceLen.compareTo(value) == 1) {
            dataSpiltMap.put("leaveLength", value);
            this.sourceLen = this.sourceLen.subtract(value);
        } else {
            dataSpiltMap.put("leaveLength", this.sourceLen);
            this.sourceLen = new BigDecimal(0);
        }
        return this.sourceLen;
    }

    private double getValueByMinLeaveLength(HolidayPolicyInfo holidayPolicyInfo, BigDecimal realLengthBigDecimal) {
        int saveLength = this.getSaveLength(this.ctx, holidayPolicyInfo);
        double length = realLengthBigDecimal.setScale(saveLength, 4).doubleValue();
        if (holidayPolicyInfo != null && holidayPolicyInfo.isEnableLeaveLength()) {
            double M = holidayPolicyInfo.getMinLeaveLength().doubleValue();
            int minLeaveLengthMtd = holidayPolicyInfo.getMinLeaveLengthVMtd().getValue();
            int ZNum = (int)(length / M);
            double XSNum = length % M;
            if (minLeaveLengthMtd == 1) {
                length = ((double)ZNum + Math.floor(XSNum / M)) * M;
            } else if (minLeaveLengthMtd == 2) {
                length = ((double)ZNum + Math.ceil(XSNum / M)) * M;
            } else if (minLeaveLengthMtd == 3) {
                length = (double)((long)ZNum + Math.round(XSNum / M)) * M;
            }
        }
        return length;
    }

    public int getSaveLength(Context ctx, HolidayPolicyInfo holidayPolicyInfo) {
        int saveLength = 0;
        if (holidayPolicyInfo != null && holidayPolicyInfo.isEnableLeaveLength()) {
            Double MinLeaveLength = holidayPolicyInfo.getMinLeaveLength().stripTrailingZeros().doubleValue();
            saveLength = AtsLeaveBillSplitHelper.getNumberDecimalDigits(MinLeaveLength);
        } else {
            saveLength = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
        }
        return saveLength;
    }

    public static int getNumberDecimalDigits(double number) {
        if (number == (double)((long)number)) {
            return 0;
        }
        int i = 0;
        while (number * Math.pow(10.0, ++i) % 1.0 != 0.0) {
        }
        return i;
    }

    private int getDayType(String personId, Date date) throws BOSException, EASBizException {
        java.sql.Date dateSql = new java.sql.Date(date.getTime());
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(this.ctx, personId, date);
        if (null != scheduleShiftInfo) {
            return scheduleShiftInfo.getDayType().getValue();
        }
        AttendanceFileCollection attendanceFileColl = AtsServerUtils.getAttendanceFileByPersonId(this.ctx, personId);
        if (attendanceFileColl != null && attendanceFileColl.get(0) != null && attendanceFileColl.get(0).getAttencePolicy() != null) {
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFactory.getLocalInstance(this.ctx).getAttencePolicyInfo(" where id='" + attendanceFileColl.get(0).getAttencePolicy().getId().toString() + "'");
            WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance(this.ctx).getWorkCalendarInfo(" where id='" + attencePolicyInfo.getWorkCalendar().getId().toString() + "'");
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + workCalendarInfo.getId().toString() + "' and date='" + dateSql + "'");
            if (workCalendarItemColl.size() > 0) {
                return workCalendarItemColl.get(0).getDayType().getValue();
            }
        } else if (this.holidayPolicyInfo.getHolidayPolicySet() != null) {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(this.ctx).getHolidayPolicySetInfo("where id = '" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "'");
            WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance(this.ctx).getWorkCalendarInfo(" where id='" + holidayPolicySetInfo.getWorkCalendar().getId().toString() + "'");
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + workCalendarInfo.getId().toString() + "' and date='" + dateSql + "'");
            if (workCalendarItemColl.size() > 0) {
                return workCalendarItemColl.get(0).getDayType().getValue();
            }
        }
        return 0;
    }

    private BigDecimal getStandardHour(String personId, Date date) throws BOSException, EASBizException {
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(this.ctx, personId, date);
        if (null != scheduleShiftInfo) {
            return scheduleShiftInfo.getDefaultShift().getStandardHour();
        }
        AttendanceFileCollection attendanceFileColl = AtsServerUtils.getAttendanceFileByPersonId(this.ctx, personId);
        AtsShiftCollection atsShiftColl = new AtsShiftCollection();
        if (attendanceFileColl.get(0).getAtsShift() != null) {
            atsShiftColl = AtsShiftFactory.getLocalInstance(this.ctx).getAtsShiftCollection(" where id='" + attendanceFileColl.get(0).getAtsShift().getId() + "'");
        }
        if (atsShiftColl.size() > 0) {
            return atsShiftColl.get(0).getStandardHour();
        }
        return this.defaultStandardHour;
    }

    private List dealDateNew(List<Date> dateList) throws EASBizException, BOSException {
        block12: {
            Map<String, AttendanceFileInfo> attendanceFileMap;
            Map<String, ScheduleShiftInfo> scheduleShiftMap;
            block11: {
                int length = dateList.size();
                String beginDate = AtsDateUtils.dateShortToString(dateList.get(0));
                String endDate = AtsDateUtils.dateShortToString(dateList.get(length - 1));
                String personIds = "'" + this.personId + "'";
                scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftByPriority(this.ctx, personIds, beginDate, endDate);
                attendanceFileMap = AtsServerUtils.getAttendanceFileInfoByPersonId(this.ctx, personIds, beginDate, endDate);
                if (!AtsCollectionUtile.isEmpty(attendanceFileMap)) break block11;
                HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(this.ctx).getHolidayPolicySetInfo("select workCalendar.id where id = '" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "'");
                WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance(this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + holidayPolicySetInfo.getWorkCalendar().getId().toString() + "' and date>={ts'" + beginDate + "'} and date <={ts'" + endDate + "'} order by date asc ");
                if (this.holidayPolicyInfo.getHolidayPolicySet() == null) break block12;
                for (int i = 0; i < dateList.size(); ++i) {
                    if (workCalendarItemColl.get(i) == null || workCalendarItemColl.get(i).getDayType() == null) continue;
                    int dayType = workCalendarItemColl.get(i).getDayType().getValue();
                    if (!this.isIncludeLegal.booleanValue() && dayType == 2) {
                        dateList.remove(i);
                        workCalendarItemColl.remove(workCalendarItemColl.get(i));
                        --i;
                        continue;
                    }
                    if (this.isIncludeRest.booleanValue() || dayType != 1) continue;
                    dateList.remove(i);
                    workCalendarItemColl.remove(workCalendarItemColl.get(i));
                    --i;
                }
                break block12;
            }
            HashSet<String> unScheduleDateSet = new HashSet<String>();
            for (Date date : dateList) {
                String scheduleShiftKey = this.personId + "_" + AtsDateUtils.dateShortToString(date);
                if (scheduleShiftMap != null && scheduleShiftMap.size() != 0 && scheduleShiftMap.get(scheduleShiftKey) != null) continue;
                unScheduleDateSet.add(AtsDateUtils.dateShortToString(date));
            }
            Map<String, Map> workCalendarItemMap = null;
            if (unScheduleDateSet.size() > 0) {
                workCalendarItemMap = this.getWorkCalendarItembyID(attendanceFileMap, unScheduleDateSet);
            }
            for (int i = 0; i < dateList.size(); ++i) {
                Date currentDate = dateList.get(i);
                int dayType = 0;
                String scheduleShiftKey = this.personId + "_" + AtsDateUtils.dateShortToString(currentDate);
                if (scheduleShiftMap != null && scheduleShiftMap.get(scheduleShiftKey) != null) {
                    ScheduleShiftInfo scheduleShiftInfo = scheduleShiftMap.get(scheduleShiftKey);
                    if (scheduleShiftInfo.getDayType() != null) {
                        dayType = scheduleShiftInfo.getDayType().getValue();
                    }
                } else {
                    AttendanceFileInfo attendanceFileInfo = attendanceFileMap.get(scheduleShiftKey);
                    if (attendanceFileInfo != null && attendanceFileInfo.getAttencePolicy() != null && attendanceFileInfo.getAttencePolicy().getWorkCalendar() != null) {
                        WorkCalendarItemInfo info;
                        Map infoMap;
                        String workCalendarId = attendanceFileMap.get(scheduleShiftKey).getAttencePolicy().getWorkCalendar().getId().toString();
                        if (workCalendarItemMap != null && (infoMap = workCalendarItemMap.get(workCalendarId)) != null && (info = (WorkCalendarItemInfo)infoMap.get(AtsDateUtils.dateShortToString(currentDate))) != null && info.getDayType() != null) {
                            dayType = info.getDayType().getValue();
                        }
                    }
                }
                if (!this.isIncludeLegal.booleanValue() && dayType == 2) {
                    dateList.remove(i);
                    --i;
                    continue;
                }
                if (this.isIncludeRest.booleanValue() || dayType != 1) continue;
                dateList.remove(i);
                --i;
            }
        }
        return dateList;
    }

    private Map<String, Map> getWorkCalendarItembyID(Map<String, AttendanceFileInfo> attendanceFileMap, Set<String> unScheduleDateSet) throws BOSException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        HashSet<String> workCalendarIds = new HashSet<String>();
        for (Map.Entry<String, AttendanceFileInfo> entry : attendanceFileMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().getCalendar() == null) continue;
            workCalendarIds.add(entry.getValue().getCalendar().getId().toString());
        }
        String workCalendarIdStr = AtsCollectionUtile.joinForSql(workCalendarIds);
        System.out.println("splitHelperError:" + AtsLeaveBillSplitHelper.convertSetToString(unScheduleDateSet));
        StringBuffer buffer = new StringBuffer();
        buffer.append("select FDayType,fid,FDate,FCalendarGroupID ").append(" from T_HR_ATS_WorkCalendarItem ").append(" where FCalendarGroupID in (").append(workCalendarIdStr).append(") ").append(" and FDate in(").append(AtsLeaveBillSplitHelper.convertSetToString(unScheduleDateSet)).append(") ");
        WorkCalendarItemCollection workCalendarItemColl = new WorkCalendarItemCollection();
        try {
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)buffer.toString());
            while (row.next()) {
                WorkCalendarItemInfo info = new WorkCalendarItemInfo();
                WorkCalendarInfo dar = new WorkCalendarInfo();
                info.setDayType(DayTypeEnum.getEnum(row.getInt("FDayType")));
                info.setId(BOSUuid.read((String)row.getString("fid")));
                dar.setId(BOSUuid.read((String)row.getString("FCalendarGroupID")));
                info.setCalendarGroup(dar);
                info.setDate(row.getDate("FDate"));
                workCalendarItemColl.add(info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (String workCalendarId : workCalendarIds) {
            HashMap<String, WorkCalendarItemInfo> workCalendarMap = new HashMap<String, WorkCalendarItemInfo>();
            for (String dateStr : unScheduleDateSet) {
                for (int j = 0; j < workCalendarItemColl.size(); ++j) {
                    if (!workCalendarItemColl.get(j).getCalendarGroup().getId().toString().equals(workCalendarId) || !workCalendarItemColl.get(j).getDate().toString().equals(dateStr)) continue;
                    workCalendarMap.put(dateStr, workCalendarItemColl.get(j));
                }
            }
            result.put(workCalendarId, workCalendarMap);
        }
        return result;
    }

    public static String convertSetToString(Set set) {
        if (set == null || set.size() <= 0) {
            return "''";
        }
        Iterator iter = set.iterator();
        StringBuffer sql = new StringBuffer();
        while (iter.hasNext()) {
            String date = iter.next().toString();
            if (date.length() > 0) {
                date = date.substring(0, 10);
            }
            sql.append("{ts'");
            sql.append(date);
            sql.append("'},");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }

    private List getLeaveDateColl(Timestamp beginTime, Timestamp endTime) throws EASBizException, BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Date beginDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateLongToString(beginTime));
        Date endDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateLongToString(endTime));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int temp = (int)((endDate.getTime() - beginDate.getTime()) / 86400000L + 1L);
        for (int i = 0; i < temp; ++i) {
            int year = beginCal.get(1);
            int month = beginCal.get(2);
            int day = beginCal.get(5);
            Date tempDate = new Date(year - 1900, month, day);
            dateList.add(tempDate);
            beginCal.add(5, 1);
        }
        return dateList;
    }

    public Map<String, Object> calRealLeaveLengthInfo(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicyInfo holidayPolicyInfo) {
        int tempAfterDealDateListSize = afterDealDateList.size();
        AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
        Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
        Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
        HashMap<Object, Object> defaultItemMap = new HashMap();
        try {
            AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(this.ctx, beginTimeCountTs, endTimeCountTs, this.personId, null);
            defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(this.ctx, attendanceFileHisInfo, holidayPolicyInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        defaultAtsShiftItemCollection = (AtsShiftItemCollection)((Object)defaultItemMap.get("scheduleShiftItemColl"));
        this.defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
        String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
        String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
        BigDecimal standardHour = new BigDecimal(0);
        try {
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(this.ctx).getAtsHolidayFileHisCollection("where proposer.id='" + this.personId + "'  order by effdt asc");
            if (null != atsHolidayFileHisCollection && atsHolidayFileHisCollection.size() > 0) {
                for (int i = 0; i < atsHolidayFileHisCollection.size(); ++i) {
                    AtsHolidayFileHisInfo atsHolidayFileHisInfo = atsHolidayFileHisCollection.get(i);
                    if (beginTimeCount.getTime() < atsHolidayFileHisInfo.getEFFDT().getTime() || endTimeCount.getTime() > atsHolidayFileHisInfo.getLEFFDT().getTime()) continue;
                    String id = atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString();
                    HolidayPolicySetInfo holidayPolicyInfo_1 = HolidayPolicySetFactory.getLocalInstance(this.ctx).getHolidayPolicySetInfo(" where id = '" + id + "'");
                    standardHour = holidayPolicyInfo_1.getDefaultStandardHour();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personId", this.personId);
        paramMap.put("beginDate", beginDate);
        paramMap.put("endDate", endDate);
        paramMap.put("endTimeCount", endTimeCount);
        paramMap.put("beginTimeCount", beginTimeCount);
        paramMap.put("defaultStandardHour", this.defaultStandardHour);
        paramMap.put("holidayTypeUnit", (Object)holidayTypeUnit);
        paramMap.put("isFixOTAllowLeave", holidayPolicyInfo.isIsFixOTAllowLeave());
        paramMap.put("afterDealDateList", afterDealDateList);
        paramMap.put("defaultAtsShiftItemCollection", (Object)defaultAtsShiftItemCollection);
        paramMap.put("dayStandardHour", standardHour);
        HashMap<String, Object> DateLeaveLenMap = new HashMap<String, Object>();
        if (tempAfterDealDateListSize != 0) {
            if (afterDealDateList.size() == 1 && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime())) && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()))) {
                paramMap.put("curDate", beginDate);
                paramMap.put("index", "index");
                this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
            } else {
                Date nowDate;
                String nowDateStr;
                boolean isPreEndDate;
                boolean isContainBeginDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime()));
                boolean isContainEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()));
                if (isContainBeginDate) {
                    paramMap.put("curDate", beginDate);
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                if (isContainEndDate) {
                    paramMap.put("curDate", endDate);
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                if (tempAfterDealDateListSize >= 3 && (isPreEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((nowDateStr = AtsDateUtils.dateShortToString(nowDate = AtsDateUtils.getPreDay(AtsDateUtils.stringToShortDate(endDate)))) + " 00:00:00").getTime())))) {
                    paramMap.put("curDate", nowDateStr);
                    paramMap.put("nowDate", nowDate);
                    paramMap.put("index", "calPreEndDate");
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(nowDateStr + " 00:00:00").getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                this.getMidleDateLength(this.ctx, paramMap, DateLeaveLenMap);
            }
        }
        Date nowDate = AtsDateUtils.getPreDay(AtsDateUtils.stringToShortDate(beginDate));
        String nowDateStr = AtsDateUtils.dateShortToString(nowDate);
        paramMap.put("curDate", nowDateStr);
        paramMap.put("nowDate", nowDate);
        paramMap.put("index", "calPrebeginDate");
        this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
        Date nextNowDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(endDate));
        String nextNowDateStr = AtsDateUtils.dateShortToString(nextNowDate);
        paramMap.put("curDate", nextNowDateStr);
        paramMap.put("nowDate", nextNowDate);
        paramMap.put("index", "calNextendDate");
        this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
        return DateLeaveLenMap;
    }

    public void getMidleDateLength(Context ctx, Map<String, Object> paramMap, Map<String, Object> DateLeaveLenMap) {
        block9: {
            BigDecimal standardHour;
            BigDecimal dayStandardHour;
            BigDecimal defaultStandardHour;
            Boolean isFixOTAllowLeave;
            String endDate;
            String beginDate;
            String personId;
            AtsShiftItemCollection defaultAtsShiftItemCollection;
            List afterDealDateList;
            HolidayTypeUnitEnum holidayTypeUnit;
            block10: {
                holidayTypeUnit = (HolidayTypeUnitEnum)((Object)paramMap.get("holidayTypeUnit"));
                afterDealDateList = (List)paramMap.get("afterDealDateList");
                defaultAtsShiftItemCollection = (AtsShiftItemCollection)((Object)paramMap.get("defaultAtsShiftItemCollection"));
                personId = (String)paramMap.get("personId");
                beginDate = (String)paramMap.get("beginDate");
                endDate = (String)paramMap.get("endDate");
                isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");
                defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
                dayStandardHour = (BigDecimal)paramMap.get("dayStandardHour");
                standardHour = new BigDecimal(0);
                if (afterDealDateList.size() <= 0) break block9;
                if (holidayTypeUnit != HolidayTypeUnitEnum.day) break block10;
                for (int i = 0; i < afterDealDateList.size(); ++i) {
                    boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, (Date)afterDealDateList.get(i));
                    String curDate = AtsDateUtils.dateShortToString((Date)afterDealDateList.get(i));
                    HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                    if (isHalfDay) {
                        curDateMap.put("calDay", 0.5);
                    } else {
                        curDateMap.put("calDay", 1.0);
                    }
                    curDateMap.put("calHour", 0.0);
                    DateLeaveLenMap.put(curDate, curDateMap);
                }
                break block9;
            }
            if (holidayTypeUnit != HolidayTypeUnitEnum.hour) break block9;
            try {
                Map<String, ScheduleShiftInfo> scheduleShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, beginDate, endDate);
                AbstractScheduleShiftInfo scheduleShiftInfo = null;
                for (int i = 0; i < afterDealDateList.size(); ++i) {
                    HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                    Date currentDate = (Date)afterDealDateList.get(i);
                    String curDate = AtsDateUtils.dateShortToString(currentDate);
                    curDateMap.put("calDay", 0.0);
                    String key = personId + "_" + AtsDateUtils.dateShortToString(currentDate);
                    DateLeaveLenMap.put(curDate, curDateMap);
                    if (null != scheduleShiftInfoMap) {
                        scheduleShiftInfo = scheduleShiftInfoMap.get(key);
                    }
                    if (scheduleShiftInfo != null) {
                        standardHour = scheduleShiftInfo.getStandardHour();
                        curDateMap.put("calHour", standardHour.doubleValue());
                        if (!isFixOTAllowLeave.booleanValue()) continue;
                        curDateMap.put("calHour", standardHour.doubleValue() + this.getFixOTSegHour(scheduleShiftInfo.getItems()));
                        continue;
                    }
                    if (defaultAtsShiftItemCollection.size() != 0) {
                        curDateMap.put("calHour", defaultStandardHour.doubleValue());
                        if (!isFixOTAllowLeave.booleanValue()) continue;
                        curDateMap.put("calHour", defaultStandardHour.doubleValue() + this.getFixOTSegHour(defaultAtsShiftItemCollection));
                        continue;
                    }
                    curDateMap.put("calHour", dayStandardHour.doubleValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public double getFixOTSegHour(ScheduleShiftItemCollection item) {
        double otSegHour = 0.0;
        ScheduleShiftItemInfo info = null;
        int len = item.size();
        for (int i = 0; i < len; ++i) {
            info = item.get(i);
            if (!info.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) continue;
            otSegHour += (double)((info.getNextDateTime().getTime() - info.getPreDateTime().getTime()) / 3600000L);
        }
        return otSegHour;
    }

    public double getFixOTSegHour(AtsShiftItemCollection item) {
        double otSegHour = 0.0;
        AtsShiftItemInfo info = null;
        int len = item.size();
        for (int i = 0; i < len; ++i) {
            String nextTime;
            info = item.get(i);
            if (!info.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) continue;
            String preTime = info.getPreTime() + ":00";
            if (preTime.compareTo(nextTime = info.getNextTime() + ":00") > 0) {
                preTime = "1900-01-01 " + preTime;
                nextTime = "1900-01-02 " + nextTime;
            } else {
                preTime = "1900-01-01 " + preTime;
                nextTime = "1900-01-01 " + nextTime;
            }
            otSegHour += (double)((HRTimeWebUtils.stringToTimestamp(nextTime).getTime() - HRTimeWebUtils.stringToTimestamp(preTime).getTime()) / 3600000L);
        }
        return otSegHour;
    }

    public void getBeginDateOrEndDateLength(Context ctx, Map<String, Object> paramMap, Map<String, Object> DateLeaveLenMap) {
        HolidayTypeUnitEnum holidayTypeUnit = (HolidayTypeUnitEnum)((Object)paramMap.get("holidayTypeUnit"));
        AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)((Object)paramMap.get("defaultAtsShiftItemCollection"));
        String personId = (String)paramMap.get("personId");
        String beginDate = (String)paramMap.get("beginDate");
        String endDate = (String)paramMap.get("endDate");
        String curDate = (String)paramMap.get("curDate");
        Boolean isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");
        Timestamp beginTimeCount = (Timestamp)paramMap.get("beginTimeCount");
        Timestamp endTimeCount = (Timestamp)paramMap.get("endTimeCount");
        BigDecimal defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
        BigDecimal standardHour = (BigDecimal)paramMap.get("dayStandardHour");
        long leaveLength = 0L;
        try {
            HashMap<String, Object> dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(ctx, personId, new Date(AtsDateUtils.stringToTimestamp(curDate + " 00:00:00").getTime()), isFixOTAllowLeave);
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)((Object)dateMap.get("scheduleShiftItemColl"));
            if (scheduleShiftItemColl.size() != 0 || defaultAtsShiftItemCollection.size() != 0) {
                List<HashMap<String, Object>> shift = null;
                if (scheduleShiftItemColl.size() != 0) {
                    standardHour = (BigDecimal)dateMap.get("standardHour");
                    shift = AtsLeaveBillUtils.getShiftItemInfos((Object)scheduleShiftItemColl, curDate, this.atsLeaveBillEntryInfo == null ? null : Boolean.valueOf(this.atsLeaveBillEntryInfo.isIsElasticCalLen()));
                } else {
                    standardHour = defaultStandardHour;
                    shift = AtsLeaveBillUtils.getShiftItemInfos((Object)defaultAtsShiftItemCollection, curDate, this.atsLeaveBillEntryInfo == null ? null : Boolean.valueOf(this.atsLeaveBillEntryInfo.isIsElasticCalLen()));
                }
                Map<String, Object> res = AtsLeaveBillUtils.calSegmentLength(ctx, shift, beginTimeCount, endTimeCount, leaveLength, this.holidayPolicyInfo, standardHour);
                leaveLength = (Long)res.get("realLen");
            } else {
                standardHour = new BigDecimal(24);
                String index = (String)paramMap.get("index");
                if (!StringUtils.isEmpty((String)index) && index.equals("index")) {
                    leaveLength = endTimeCount.getTime() - beginTimeCount.getTime();
                } else if (curDate.equals(endDate)) {
                    leaveLength = leaveLength + endTimeCount.getTime() - AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime();
                } else if (curDate.equals(beginDate)) {
                    leaveLength = leaveLength + AtsDateUtils.stringToTimestamp(beginDate + " 23:59:59").getTime() - beginTimeCount.getTime();
                } else if (!StringUtils.isEmpty((String)index) && index.equals("calPreEndDate")) {
                    leaveLength = (long)((double)standardHour.longValue() * 60.0 * 60.0 * 1000.0);
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, Double> curDateMap = new HashMap<String, Double>();
        if (leaveLength > 0L) {
            if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, personId, HRTimeWebUtils.stringToShortDate(curDate));
                if (isHalfDay) {
                    curDateMap.put("calDay", (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0 * 2.0) > 0.5 ? 0.5 : (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0 * 2.0));
                } else {
                    curDateMap.put("calDay", (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0) > 1.0 ? 1.0 : (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0));
                }
            } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                curDateMap.put("calHour", (double)leaveLength / 3600000.0 > standardHour.doubleValue() ? standardHour.doubleValue() : (double)leaveLength / 3600000.0);
            }
            DateLeaveLenMap.put(curDate, curDateMap);
        }
    }

    public Map<String, Object> calRealLeaveLengthOfDay(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicySetInfo holidayPolicySetInfo, HolidayPolicyInfo holidayPolicyInfo) throws BOSException, EASBizException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (afterDealDateList.size() == 0) {
            return retMap;
        }
        Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
        Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
        AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(this.ctx, beginTimeCountTs, endTimeCountTs, this.personId, null);
        HashMap<String, Object> defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(this.ctx, attendanceFileHisInfo, holidayPolicyInfo);
        AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)((Object)defaultItemMap.get("scheduleShiftItemColl"));
        BigDecimal defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
        BigDecimal standardHour = new BigDecimal(8);
        String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
        String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);
        String amStartTime = holidayPolicySetInfo.getAmStartWorkTime();
        String amEndTime = holidayPolicySetInfo.getAmEndWorkTime();
        String pmStartTime = holidayPolicySetInfo.getPmStartWorkTime();
        String pmEndTime = holidayPolicySetInfo.getPmEndWorkTime();
        HolidayTypeUnitEnum holidayUnit = holidayPolicyInfo.getUnit();
        Boolean isFixOTAllowLeave = holidayPolicyInfo.isIsFixOTAllowLeave();
        double realLength = 0.0;
        double leaveLengthDay = 0.0;
        double leaveLengthHour = 0.0;
        if (afterDealDateList.size() == 1 && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime())) && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()))) {
            boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(this.ctx, this.personId, HRTimeWebUtils.stringToShortDate(beginDate));
            String startTimeTemp = AtsDateUtils.dateLongToString(beginTimeCount).substring(11, 16);
            String endTimeTemp = AtsDateUtils.dateLongToString(endTimeCount).substring(11, 16);
            realLength = startTimeTemp.equals(amStartTime) && endTimeTemp.equals(amEndTime) || startTimeTemp.equals(pmStartTime) && endTimeTemp.equals(pmEndTime) || startTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmStartTime) || startTimeTemp.equals(amEndTime) && endTimeTemp.equals(pmEndTime) ? 0.5 : (startTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmEndTime) ? 1.0 : 0.0);
            if (realLength > 0.0) {
                HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                    leaveLengthDay = isHalfDay ? 0.5 : realLength;
                    curDateMap.put("calDay", leaveLengthDay);
                    curDateMap.put("calHour", 0.0);
                } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                    standardHour = this.getStandardHourOfDay(this.ctx, this.personId, beginDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                    leaveLengthHour = realLength * standardHour.doubleValue();
                    curDateMap.put("calDay", 0.0);
                    curDateMap.put("calHour", leaveLengthHour);
                }
                retMap.put(beginDate, curDateMap);
            }
        } else {
            HashMap<String, Double> curDateMap;
            boolean isHalfDay;
            if (afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime()))) {
                isHalfDay = AtsLeaveBillUtils.isHalfDay(this.ctx, this.personId, HRTimeWebUtils.stringToShortDate(beginDate));
                String amStartTimeTemp = AtsDateUtils.dateLongToString(beginTimeCount).substring(11, 16);
                afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(beginDate + " 00:00:00").getTime()));
                realLength = amStartTimeTemp.equals(amStartTime) ? 1.0 : (amStartTimeTemp.equals(pmStartTime) ? 0.5 : 0.0);
                if (realLength > 0.0) {
                    curDateMap = new HashMap<String, Double>();
                    if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                        leaveLengthDay = isHalfDay ? 0.5 : realLength;
                        curDateMap.put("calDay", leaveLengthDay);
                        curDateMap.put("calHour", 0.0);
                    } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                        standardHour = this.getStandardHourOfDay(this.ctx, this.personId, beginDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                        leaveLengthHour = realLength * standardHour.doubleValue();
                        curDateMap.put("calDay", 0.0);
                        curDateMap.put("calHour", leaveLengthHour);
                    }
                    retMap.put(beginDate, curDateMap);
                }
            }
            if (afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()))) {
                isHalfDay = AtsLeaveBillUtils.isHalfDay(this.ctx, this.personId, HRTimeWebUtils.stringToShortDate(endDate));
                afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp(endDate + " 00:00:00").getTime()));
                String amEndTimeTemp = AtsDateUtils.dateLongToString(endTimeCount).substring(11, 16);
                realLength = 0.0;
                realLength = amEndTimeTemp.equals(amEndTime) || amEndTimeTemp.equals(pmStartTime) ? 0.5 : (amEndTimeTemp.equals(pmEndTime) ? 1.0 : 0.0);
                if (realLength > 0.0) {
                    curDateMap = new HashMap();
                    if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                        leaveLengthDay = isHalfDay ? 0.5 : realLength;
                        curDateMap.put("calDay", leaveLengthDay);
                        curDateMap.put("calHour", 0.0);
                    } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                        standardHour = this.getStandardHourOfDay(this.ctx, this.personId, endDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                        leaveLengthHour = realLength * standardHour.doubleValue();
                        curDateMap.put("calDay", 0.0);
                        curDateMap.put("calHour", leaveLengthHour);
                    }
                    retMap.put(endDate, curDateMap);
                }
            }
            if (afterDealDateList.size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("leaveLengthDay", leaveLengthDay);
                paramMap.put("leaveLengthHour", leaveLengthHour);
                paramMap.put("personId", this.personId);
                paramMap.put("beginDate", beginDate);
                paramMap.put("endDate", endDate);
                paramMap.put("defaultStandardHour", defaultStandardHour);
                paramMap.put("holidayTypeUnit", (Object)holidayUnit);
                paramMap.put("isFixOTAllowLeave", isFixOTAllowLeave);
                paramMap.put("afterDealDateList", afterDealDateList);
                paramMap.put("defaultAtsShiftItemCollection", (Object)defaultAtsShiftItemCollection);
                paramMap.put("dayStandardHour", new BigDecimal(8));
                this.getMidleDateLength(this.ctx, paramMap, retMap);
            }
        }
        return retMap;
    }

    public BigDecimal getStandardHourOfDay(Context ctx, String personId, String curDate, AtsShiftItemCollection defaultAtsShiftItemCollection, BigDecimal defaultStandardHour, Boolean isFixOTAllowLeave) {
        BigDecimal standardHour = new BigDecimal(8);
        try {
            HashMap<String, Object> dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate(ctx, personId, new Date(AtsDateUtils.stringToShortDate(curDate).getTime()), isFixOTAllowLeave);
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)((Object)dateMap.get("scheduleShiftItemColl"));
            if (scheduleShiftItemColl.size() != 0 || defaultAtsShiftItemCollection.size() != 0) {
                standardHour = scheduleShiftItemColl.size() != 0 ? (BigDecimal)dateMap.get("standardHour") : defaultStandardHour;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return standardHour;
    }

    public Map<String, Object> calRealLeaveLengthOfBF(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicySetInfo holidayPolicySetInfo, HolidayPolicyInfo holidayPolicyInfo) throws BOSException, EASBizException {
        HashMap<String, Object> DateLeaveLenMap = new HashMap<String, Object>();
        if (this.atsLeaveBillEntryInfo.getBfType() == null) {
            return DateLeaveLenMap;
        }
        String bfTypeId = this.atsLeaveBillEntryInfo.getBfType().getId().toString();
        BreastFeedingTypeCollection bfTypeColl = BreastFeedingTypeFactory.getLocalInstance(this.ctx).getBreastFeedingTypeCollection("where id = '" + bfTypeId + "'");
        double leaveLengthOfSplit = 1.0;
        if (bfTypeColl.size() > 0) {
            BreastFeedingTypeInfo bfTypeInfo = bfTypeColl.get(0);
            leaveLengthOfSplit = bfTypeInfo.getLeaveLength().multiply(new BigDecimal(bfTypeInfo.getFetusNum())).doubleValue();
        }
        Map<String, List<ScheduleShiftInfo>> scheduleShiftMap = null;
        if (holidayTypeUnit.getValue() == 1) {
            Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp(beginTimeCount);
            Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp(endTimeCount);
            HashMap<Object, Object> defaultItemMap = new HashMap();
            try {
                AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(this.ctx, beginTimeCountTs, endTimeCountTs, this.personId, null);
                defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis(this.ctx, attendanceFileHisInfo, holidayPolicyInfo);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
            String beginDate = AtsDateUtils.dateLongToString(beginTimeCount).substring(0, 10);
            String endDate = AtsDateUtils.dateLongToString(endTimeCount).substring(0, 10);
            Map<String, Object> fileInfoRenturn = AtsPrepareDataHelper.getAttendanceFileInfoByPersonId(this.ctx, "'" + this.personId + "'", beginDate, endDate, null);
            Map fileInfoObject = (Map)fileInfoRenturn.get("fileInfoMap");
            scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftMapByPriority(this.ctx, fileInfoObject, this.personId, beginDate, endDate);
        }
        if (afterDealDateList.size() == 0) {
            return DateLeaveLenMap;
        }
        for (Date date : afterDealDateList) {
            HashMap<String, Double> curDateMap = new HashMap<String, Double>();
            if (holidayTypeUnit.getValue() == 1) {
                BigDecimal standardhour = new BigDecimal(0);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String ds = sdf.format(date);
                String key = this.personId + "_" + ds;
                List scheduleShiftList = null == scheduleShiftMap ? null : (List)scheduleShiftMap.get(key);
                standardhour = scheduleShiftList != null && scheduleShiftList.size() > 0 ? (BigDecimal)((ScheduleShiftInfo)scheduleShiftList.get(0)).get("standardhour") : this.defaultStandardHour;
                BigDecimal dayRealLength = BigDecimal.valueOf(leaveLengthOfSplit).divide(standardhour, 8, RoundingMode.HALF_UP);
                curDateMap.put("calDay", dayRealLength.doubleValue());
                curDateMap.put("calHour", 0.0);
            } else {
                curDateMap.put("calDay", 0.0);
                curDateMap.put("calHour", leaveLengthOfSplit);
            }
            String curDate = AtsDateUtils.dateLongToString(date);
            DateLeaveLenMap.put(curDate, curDateMap);
        }
        return DateLeaveLenMap;
    }

    public Map<String, Object> getIsCtrlHalfDayOff(Context ctx) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "' ");
            res.put("amBeginTime", holidayPolicySetInfo.getAmStartWorkTime());
            res.put("amEndTime", holidayPolicySetInfo.getAmEndWorkTime());
            res.put("pmBeginTime", holidayPolicySetInfo.getPmStartWorkTime());
            res.put("pmEndTime", holidayPolicySetInfo.getPmEndWorkTime());
            res.put("isHalfDayOff", this.holidayPolicyInfo.isIsHalfDayOff());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private AtsShiftItemInfo createScheduleShiftItemToAtsShiftItem(Context ctx, ScheduleShiftItemInfo scheduleShiftItemInfo) {
        AtsShiftItemInfo info = new AtsShiftItemInfo();
        info.setPreTime(scheduleShiftItemInfo.getPreTime());
        info.setNextTime(scheduleShiftItemInfo.getNextTime());
        info.setPreIsPunchCard(scheduleShiftItemInfo.getPreIsPunchCard());
        info.setNextIsPunchCard(scheduleShiftItemInfo.getNextIsPunchCard());
        info.setPreTimeDayType(scheduleShiftItemInfo.getPreTimeDayType());
        info.setNextTimeDayType(scheduleShiftItemInfo.getNextTimeDayType());
        info.setSegment(scheduleShiftItemInfo.getSegment());
        info.setPreFloatAdjusted(scheduleShiftItemInfo.getPreFloatAdjusted());
        info.setNextFloatAdjusted(scheduleShiftItemInfo.getNextFloatAdjusted());
        info.setRestPreTime(scheduleShiftItemInfo.getRestPreTime());
        info.setRestNextTime(scheduleShiftItemInfo.getRestNextTime());
        info.setSegmentInRest(scheduleShiftItemInfo.getSegmentInRest());
        info.setAttendanceType(scheduleShiftItemInfo.getAttendanceType());
        info.setGroup(new AtsShiftInfo());
        return info;
    }
}

