/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemFactory;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.CancelLeaveBillCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.LeavebillCancelEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.TripbillCancelEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillEntryControllerBean;
import com.kingdee.eas.hr.ats.app.AtsTripBillEntryControllerBean;
import com.kingdee.eas.hr.ats.extendEntryInfo.LeaveBillTimeInfo;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsLeaveBillUtils {
    public static BigDecimal defaultStandardHour = new BigDecimal(24);
    public static BigDecimal defaultStandardHourEnableAMPM = new BigDecimal(8);
    static String baseDate = "1990-01-01";

    public static int getSubmitTypeById(Context ctx, String billId) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" select billType where id = '" + billId + "'");
        int billSubmitType = billInfo.getBillType().getValue();
        return billSubmitType;
    }

    public static Boolean checkIsOverLeaveTimesImport(Context ctx, Map<String, Object> paramsMap, Map<String, ArrayList<LeaveBillTimeInfo>> limitInfoMap, Map<String, Object> billMap) {
        boolean isOver = false;
        String proposerid = (String)paramsMap.get("proposerid");
        HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)paramsMap.get("policy");
        HolidayTypeInfo holidayTypeInfo = (HolidayTypeInfo)paramsMap.get("holidayTypeInfo");
        String holidayTypeId = holidayTypeInfo.getId().toString();
        String key = proposerid + holidayTypeId;
        int allowTimes = holidayPolicyInfo.getAllowLeaveTimes();
        if (allowTimes > 0) {
            if (limitInfoMap.get(key) == null) {
                Map<String, Object> limitDateMap = AtsLeaveBillUtils.getAllLeaveBillTimes(ctx, paramsMap);
                if (limitDateMap.get("limitDate") != null) {
                    List limitList = (List)limitDateMap.get("limitDate");
                    boolean nextLeave = true;
                    for (int i = 0; i < limitList.size(); ++i) {
                        int realTimes;
                        ArrayList<LeaveBillTimeInfo> BillTimeInfoList = new ArrayList<LeaveBillTimeInfo>();
                        LeaveBillTimeInfo leaveTime = new LeaveBillTimeInfo();
                        Map limitMap = (Map)limitList.get(i);
                        ArrayList<Map> relimitList = new ArrayList<Map>();
                        String effectDate = (String)limitMap.get("effectDate");
                        String delayDate = (String)limitMap.get("delayDate");
                        relimitList.add(limitMap);
                        limitDateMap.put("limitDate", relimitList);
                        int hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimesByImport(ctx, limitDateMap, billMap);
                        leaveTime.setDelayDate(delayDate);
                        leaveTime.setEffectDate(effectDate);
                        leaveTime.setAllTimes(allowTimes);
                        leaveTime.setKey(key);
                        leaveTime.setUserTimes(hasApp);
                        leaveTime.setPersonId(proposerid);
                        leaveTime.setHolidayTypeId(holidayTypeId);
                        leaveTime.setOver(false);
                        if (nextLeave) {
                            if (hasApp + 1 > leaveTime.getAllTimes()) {
                                leaveTime.setRealTimes(0);
                                leaveTime.setOver(true);
                            } else {
                                realTimes = allowTimes - hasApp - 1;
                                leaveTime.setRealTimes(realTimes);
                                nextLeave = false;
                            }
                        } else {
                            realTimes = allowTimes - hasApp;
                            if (realTimes > 0) {
                                leaveTime.setRealTimes(realTimes);
                            } else {
                                leaveTime.setRealTimes(0);
                                leaveTime.setOver(true);
                            }
                        }
                        BillTimeInfoList.add(leaveTime);
                        limitInfoMap.put(key, BillTimeInfoList);
                    }
                    isOver = nextLeave;
                } else {
                    ArrayList<LeaveBillTimeInfo> BillTimeInfoList = new ArrayList<LeaveBillTimeInfo>();
                    Map<String, Object> infoMap = AtsLeaveBillUtils.getAllLeaveBillTimesOutPeriod(ctx, paramsMap);
                    int hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimesOutPeriod(ctx, paramsMap, infoMap);
                    LeaveBillTimeInfo leaveTime = new LeaveBillTimeInfo();
                    leaveTime.setAllTimes(allowTimes);
                    leaveTime.setKey(key);
                    leaveTime.setUserTimes(hasApp);
                    leaveTime.setPersonId(proposerid);
                    leaveTime.setHolidayTypeId(holidayTypeId);
                    leaveTime.setHasLimit(true);
                    limitInfoMap.put(key, BillTimeInfoList);
                    if (hasApp + 1 > leaveTime.getAllTimes()) {
                        leaveTime.setRealTimes(0);
                        leaveTime.setOver(true);
                        isOver = true;
                    } else {
                        leaveTime.setRealTimes(allowTimes - hasApp - 1);
                    }
                    BillTimeInfoList.add(leaveTime);
                    limitInfoMap.put(key, BillTimeInfoList);
                }
            } else {
                ArrayList<LeaveBillTimeInfo> BillTimeInfoList = limitInfoMap.get(key);
                Map<String, Object> limitDateMap = AtsLeaveBillUtils.getAllLeaveBillTimes(ctx, paramsMap);
                if (limitDateMap.get("limitDate") != null) {
                    List limitList = (List)limitDateMap.get("limitDate");
                    boolean isNext = false;
                    for (int i = 0; limitList.size() > i; ++i) {
                        int realTimes;
                        Map limitMap = (Map)limitList.get(i);
                        String effectDate = (String)limitMap.get("effectDate");
                        String delayDate = (String)limitMap.get("delayDate");
                        boolean isExist = false;
                        for (int j = 0; BillTimeInfoList.size() > j; ++j) {
                            LeaveBillTimeInfo leaveBillTimeInfo = BillTimeInfoList.get(j);
                            String effect = leaveBillTimeInfo.getEffectDate();
                            String delay = leaveBillTimeInfo.getDelayDate();
                            if (!effect.equals(effectDate) || !delay.equals(delayDate)) continue;
                            isExist = true;
                            if (leaveBillTimeInfo.isOver()) continue;
                            realTimes = leaveBillTimeInfo.getRealTimes();
                            if (isNext || realTimes <= 0) continue;
                            int tempReal = realTimes - 1;
                            leaveBillTimeInfo.setRealTimes(tempReal);
                            if (tempReal == 0) {
                                leaveBillTimeInfo.setOver(true);
                            }
                            isNext = true;
                        }
                        if (isExist) continue;
                        HashMap<String, String> limitNotExistMap = new HashMap<String, String>();
                        ArrayList<HashMap<String, String>> relimitList = new ArrayList<HashMap<String, String>>();
                        limitNotExistMap.put("effectDate", effectDate);
                        limitNotExistMap.put("delayDate", delayDate);
                        relimitList.add(limitNotExistMap);
                        limitDateMap.put("limitDate", relimitList);
                        int hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimesByImport(ctx, limitDateMap, billMap);
                        LeaveBillTimeInfo leaveTimeNot = new LeaveBillTimeInfo();
                        leaveTimeNot.setDelayDate(delayDate);
                        leaveTimeNot.setEffectDate(effectDate);
                        leaveTimeNot.setKey(key);
                        leaveTimeNot.setUserTimes(hasApp);
                        leaveTimeNot.setPersonId(proposerid);
                        leaveTimeNot.setHolidayTypeId(holidayTypeId);
                        leaveTimeNot.setAllTimes(allowTimes);
                        leaveTimeNot.setUserTimes(hasApp);
                        if (!isNext) {
                            realTimes = allowTimes - hasApp - 1;
                            if (realTimes >= 0) {
                                leaveTimeNot.setRealTimes(realTimes);
                                if (realTimes == 0) {
                                    leaveTimeNot.setOver(true);
                                }
                                isNext = true;
                            }
                        } else {
                            int real = allowTimes - hasApp;
                            if (real > 0) {
                                leaveTimeNot.setRealTimes(real);
                            } else {
                                leaveTimeNot.setRealTimes(0);
                                leaveTimeNot.setOver(true);
                            }
                        }
                        BillTimeInfoList.add(leaveTimeNot);
                    }
                    isOver = !isNext;
                } else {
                    boolean isFlag = false;
                    for (int i = 0; BillTimeInfoList.size() > i; ++i) {
                        LeaveBillTimeInfo leaveBillTimeInfo = BillTimeInfoList.get(i);
                        if (!leaveBillTimeInfo.isHasLimit()) continue;
                        int realTimes = leaveBillTimeInfo.getRealTimes();
                        isFlag = true;
                        int temp = realTimes - 1;
                        if (temp >= 0) {
                            leaveBillTimeInfo.setRealTimes(temp);
                            continue;
                        }
                        leaveBillTimeInfo.setRealTimes(0);
                        leaveBillTimeInfo.setOver(true);
                        isOver = true;
                    }
                    if (!isFlag) {
                        Map<String, Object> infoMap = AtsLeaveBillUtils.getAllLeaveBillTimesOutPeriod(ctx, paramsMap);
                        int hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimesOutPeriod(ctx, paramsMap, infoMap);
                        LeaveBillTimeInfo leaveTime = new LeaveBillTimeInfo();
                        leaveTime.setAllTimes(allowTimes);
                        leaveTime.setKey(key);
                        leaveTime.setUserTimes(hasApp);
                        leaveTime.setPersonId(proposerid);
                        leaveTime.setHolidayTypeId(holidayTypeId);
                        leaveTime.setHasLimit(true);
                        limitInfoMap.put(key, BillTimeInfoList);
                        if (hasApp + 1 > leaveTime.getAllTimes()) {
                            leaveTime.setRealTimes(0);
                            leaveTime.setOver(true);
                            isOver = true;
                        } else {
                            leaveTime.setRealTimes(allowTimes - hasApp - 1);
                        }
                        BillTimeInfoList.add(leaveTime);
                        limitInfoMap.put(key, BillTimeInfoList);
                    }
                }
            }
        }
        return isOver;
    }

    public static Boolean checkIsOverLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        HolidayPolicyInfo holidayPolicyInfo;
        boolean isOver = true;
        int hasApp = 0;
        int allowLeaveTimes = 0;
        if (paramsMap.get("policyInfo") != null && (allowLeaveTimes = (holidayPolicyInfo = (HolidayPolicyInfo)paramsMap.get("policyInfo")).getAllowLeaveTimes()) != 0) {
            Map<String, Object> allLeaveTimesMap = AtsLeaveBillUtils.getAllLeaveBillTimes(ctx, paramsMap);
            if ((Integer)allLeaveTimesMap.get("allTimes") > 0) {
                hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimes(ctx, allLeaveTimesMap);
                int limitSums = (Integer)allLeaveTimesMap.get("allTimes");
                if (allowLeaveTimes * limitSums < hasApp + 1) {
                    isOver = false;
                }
            } else {
                Map<String, Object> infoMap = AtsLeaveBillUtils.getAllLeaveBillTimesOutPeriod(ctx, paramsMap);
                hasApp = AtsLeaveBillUtils.getHasAppLeaveBillTimesOutPeriod(ctx, paramsMap, infoMap);
                if (allowLeaveTimes < hasApp + 1) {
                    isOver = false;
                }
            }
        }
        return isOver;
    }

    public static void getHolidayPolicyByPerson(Context ctx, Map<String, Object> paramsMap) {
        AttendanceFileInfo fileInfo;
        HolidayPolicySetInfo holidayPolicySet;
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        AttendanceFileCollection attendanceFileColl = new AttendanceFileCollection();
        try {
            attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + proposerid + "' and attendFileState='1' ");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (attendanceFileColl.size() > 0 && (holidayPolicySet = (fileInfo = attendanceFileColl.get(0)).getHolidayPolicySet()) != null) {
            HolidayPolicyInfo holidayPolicyInfo = null;
            try {
                holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo("  where holidayPolicySet = '" + holidayPolicySet.getId().toString() + "' and holidayType='" + policyId + "' ");
                if (holidayPolicyInfo != null) {
                    paramsMap.put("policyInfo", holidayPolicyInfo);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> getAllLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        int times = 0;
        String proposerid = (String)paramsMap.get("proposerid");
        String beginTime = (String)paramsMap.get("beginTime");
        String endTime = (String)paramsMap.get("endTime");
        String policyId = (String)paramsMap.get("policyId");
        beginTime = beginTime.substring(0, 10) + " 00:00:00";
        endTime = endTime.substring(0, 10) + " 00:00:00";
        sql.append("select feffectDate,fdelayDate from T_HR_ATS_HolidayLimit  holiLimit ");
        sql.append(" inner join  T_HR_ATS_HolidayPolicy policy on policy.fid = holiLimit.fholidaypolicyid");
        sql.append(" where ");
        sql.append(" ({TS '" + beginTime + "'}<= feffectDate and feffectDate < {TS '" + endTime + "'}");
        sql.append(" or\t{TS '" + beginTime + "'}< fdelayDate and fdelayDate <= {TS '" + endTime + "'}");
        sql.append(" or\tfeffectDate<= {TS '" + beginTime + "'} and  {TS '" + endTime + "'}<= fdelayDate )");
        sql.append("and FProposerID = '" + proposerid + "' and policy.fholidayTypeid='" + policyId + "'");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList limitList = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> limitMap = new HashMap<String, String>();
                    String effectDate = rowSet.getString("feffectDate");
                    String delayDate = rowSet.getString("fdelayDate");
                    if (effectDate.length() > 19) {
                        effectDate = effectDate.substring(0, 19);
                    }
                    if (delayDate.length() > 19) {
                        delayDate = delayDate.substring(0, 10) + " 23:59:59";
                    }
                    limitMap.put("effectDate", effectDate);
                    limitMap.put("delayDate", delayDate);
                    limitList.add(limitMap);
                    ++times;
                }
                infoMap.put("limitDate", limitList);
            }
            infoMap.put("policyId", policyId);
            infoMap.put("proposerid", proposerid);
            infoMap.put("allTimes", times);
        }
        catch (BOSException e) {
            infoMap.put("allTimes", times);
            e.printStackTrace();
        }
        catch (SQLException s) {
            infoMap.put("allTimes", times);
            s.printStackTrace();
        }
        return infoMap;
    }

    public static Map<String, Object> getAllLeaveBillTimesOutPeriod(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        String proposerid = (String)paramsMap.get("proposerid");
        String beginTime = (String)paramsMap.get("beginTime");
        String endTime = (String)paramsMap.get("endTime");
        beginTime = beginTime.substring(0, 10) + " 00:00:00";
        endTime = endTime.substring(0, 10) + " 00:00:00";
        String policyId = (String)paramsMap.get("policyId");
        sql.append("select feffectDate,fdelayDate from T_HR_ATS_HolidayLimit  holiLimit ");
        sql.append(" inner join  T_HR_ATS_HolidayPolicy policy on policy.fid = holiLimit.fholidaypolicyid");
        sql.append(" where ");
        sql.append(" ( {TS '" + endTime + "'}<= feffectDate ");
        sql.append(" or\t{TS '" + beginTime + "'}>= fdelayDate ) ");
        sql.append(" and FProposerID = '" + proposerid + "' and policy.fholidayTypeid='" + policyId + "'");
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList limitList = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> limitMap = new HashMap<String, String>();
                    String effectDate = rowSet.getString("feffectDate");
                    String delayDate = rowSet.getString("fdelayDate");
                    if (effectDate.length() > 19) {
                        effectDate = effectDate.substring(0, 19);
                    }
                    if (delayDate.length() > 19) {
                        delayDate = delayDate.substring(0, 10) + " 23:59:59";
                    }
                    limitMap.put("effectDate", effectDate);
                    limitMap.put("delayDate", delayDate);
                    limitList.add(limitMap);
                }
                infoMap.put("limitDate", limitList);
            }
            infoMap.put("policyId", policyId);
            infoMap.put("ProposerID", proposerid);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException s) {
            s.printStackTrace();
        }
        return infoMap;
    }

    public static int getHasAppLeaveBillTimes(Context ctx, Map<String, Object> paramsMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        StringBuffer dateSql = new StringBuffer();
        List limitList = (List)paramsMap.get("limitDate");
        for (int i = 0; i < limitList.size(); ++i) {
            Map limitMap = (Map)limitList.get(i);
            String effectDate = (String)limitMap.get("effectDate");
            String delayDate = (String)limitMap.get("delayDate");
            dateSql.append(" ({TS '" + effectDate + "'}<= FBeginTime and FBeginTime < {TS '" + delayDate + "'}");
            dateSql.append(" or\t{TS '" + effectDate + "'}< FEndTime and FEndTime <= {TS '" + delayDate + "'}");
            dateSql.append(" or\tFBeginTime< {TS '" + effectDate + "'} and  {TS '" + delayDate + "'}< FEndTime ) or");
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select count(1)  from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where bill.FBillState <> 0 and bill.FBillState <> 4 and ");
        sql.append(" entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        if (dateSql.length() > 0) {
            String hql = dateSql.substring(0, dateSql.lastIndexOf("or") - 1);
            sql.append(" and (" + hql + " )");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    hasAppTimes = rowSet.getInt(1);
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static int getHasAppLeaveBillTimesByImport(Context ctx, Map<String, Object> paramsMap, Map<String, Object> billMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        StringBuffer dateSql = new StringBuffer();
        List limitList = (List)paramsMap.get("limitDate");
        for (int i = 0; i < limitList.size(); ++i) {
            Map limitMap = (Map)limitList.get(i);
            String effectDate = (String)limitMap.get("effectDate");
            String delayDate = (String)limitMap.get("delayDate");
            dateSql.append(" ({TS '" + effectDate + "'}<= FBeginTime and FBeginTime < {TS '" + delayDate + "'}");
            dateSql.append(" or\t{TS '" + effectDate + "'}< FEndTime and FEndTime <= {TS '" + delayDate + "'}");
            dateSql.append(" or\tFBeginTime< {TS '" + effectDate + "'} and  {TS '" + delayDate + "'}< FEndTime ) or");
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select entry.fid as fid from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where bill.FBillState <> 0 and bill.FBillState <> 4 and ");
        sql.append(" entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        if (dateSql.length() > 0) {
            String hql = dateSql.substring(0, dateSql.lastIndexOf("or") - 1);
            sql.append(" and (" + hql + " )");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    String fid = rowSet.getString("fid");
                    if (null != billMap.get(fid)) continue;
                    billMap.put(fid, fid);
                    ++hasAppTimes;
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static int getHasAppLeaveBillTimesOutPeriod(Context ctx, Map<String, Object> paramsMap, Map<String, Object> infoMap) {
        StringBuffer sql = new StringBuffer();
        int hasAppTimes = 0;
        List limitList = (List)infoMap.get("limitDate");
        StringBuffer dateSql = new StringBuffer();
        if (limitList != null) {
            for (int i = 0; i < limitList.size(); ++i) {
                Map limitMap = (Map)limitList.get(i);
                String effectDate = (String)limitMap.get("effectDate");
                String delayDate = (String)limitMap.get("delayDate");
                dateSql.append(" ({TS '" + delayDate + "'} <FBeginTime ");
                dateSql.append(" or\t{TS '" + effectDate + "'}>  FEndTime ");
                dateSql.append(" ) and ");
            }
        }
        String proposerid = (String)paramsMap.get("proposerid");
        String policyId = (String)paramsMap.get("policyId");
        sql.append(" select count(1)  from T_HR_ATS_LeaveBillEntry entry ");
        sql.append(" inner join T_HR_ATS_LeaveBill bill on bill.FID = entry.FBillID");
        sql.append(" inner join T_HR_ATS_HolidayPolicy policy on policy.FID = entry.FPolicyID");
        sql.append(" where  ");
        if (dateSql.length() > 0) {
            sql.append(" " + dateSql);
        }
        sql.append(" bill.FBillState <> 0 and bill.FBillState <> 4 ");
        sql.append(" and entry.FPersonID ='" + proposerid + "' and policy.FHolidayTypeID ='" + policyId + "'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    hasAppTimes = rowSet.getInt(1);
                }
                paramsMap.put("appTimes", hasAppTimes);
            }
        }
        catch (BOSException e) {
            paramsMap.put("appTimes", hasAppTimes);
            e.printStackTrace();
        }
        catch (SQLException s) {
            paramsMap.put("appTimes", hasAppTimes);
            s.printStackTrace();
        }
        return hasAppTimes;
    }

    public static HashMap<String, Object> getdefaultShiftItem(Context ctx, AttendanceFileInfo attendanceFileInfo, HolidayPolicyInfo holidayPolicyInfo) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        AtsShiftCollection defaultAtsShiftColl = new AtsShiftCollection();
        if (attendanceFileInfo != null && attendanceFileInfo.getAtsShift() != null) {
            try {
                defaultAtsShiftColl = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(" where id='" + attendanceFileInfo.getAtsShift().getId() + "'");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        BigDecimal defaultStandardHour = new BigDecimal(24);
        AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
        if (defaultAtsShiftColl.size() != 0) {
            defaultStandardHour = defaultAtsShiftColl.get(0).getStandardHour();
            try {
                defaultAtsShiftItemCollection = AtsShiftItemFactory.getLocalInstance(ctx).getAtsShiftItemCollection(" where group='" + defaultAtsShiftColl.get(0).getId().toString() + "'");
                if (defaultAtsShiftItemCollection != null && !defaultAtsShiftItemCollection.isEmpty()) {
                    for (int i = 0; i < defaultAtsShiftItemCollection.size(); ++i) {
                        AtsShiftItemInfo atsShiftItemInfo = defaultAtsShiftItemCollection.get(i);
                        if (holidayPolicyInfo != null && holidayPolicyInfo.isIsFillHoliday()) {
                            if (!atsShiftItemInfo.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep)) continue;
                            defaultAtsShiftItemCollection.remove(atsShiftItemInfo);
                            continue;
                        }
                        if (!atsShiftItemInfo.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) && !atsShiftItemInfo.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) continue;
                        defaultAtsShiftItemCollection.remove(atsShiftItemInfo);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        dateMap.put("scheduleShiftItemColl", (Object)defaultAtsShiftItemCollection);
        dateMap.put("standardHour", defaultStandardHour);
        return dateMap;
    }

    public static HashMap<String, Object> getdefaultShiftItemV2(Context ctx, AtsHolidayFileInfo holidayFileInfo) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
        dateMap.put("scheduleShiftItemColl", (Object)defaultAtsShiftItemCollection);
        dateMap.put("standardHour", defaultStandardHour);
        return dateMap;
    }

    public static HashMap<String, Object> getdefaultShiftItemByHISV2(Context ctx, AtsHolidayFileHisInfo holidayFileHisInfo) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
        dateMap.put("scheduleShiftItemColl", (Object)defaultAtsShiftItemCollection);
        dateMap.put("standardHour", defaultStandardHour);
        return dateMap;
    }

    public static HashMap<String, Object> getScheduleShiftItemCollByDate(Context ctx, String personId, Date date, Boolean isFixOTAllowLeave) throws BOSException, EASBizException {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        BigDecimal standardHour = new BigDecimal(24);
        ScheduleShiftItemCollection scheduleShiftItemColl = new ScheduleShiftItemCollection();
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, date);
        if (null != scheduleShiftInfo) {
            standardHour = scheduleShiftInfo.getStandardHour();
            scheduleShiftItemColl = scheduleShiftInfo.getItems();
            for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                scheduleShiftItemColl.get(i).setGroup(scheduleShiftInfo);
                if (isFixOTAllowLeave.booleanValue()) {
                    if (!scheduleShiftItemColl.get(i).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep)) continue;
                    scheduleShiftItemColl.remove(scheduleShiftItemColl.get(i));
                    continue;
                }
                if (!scheduleShiftItemColl.get(i).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) && !scheduleShiftItemColl.get(i).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) continue;
                scheduleShiftItemColl.remove(scheduleShiftItemColl.get(i));
            }
        }
        dateMap.put("scheduleShiftItemColl", (Object)scheduleShiftItemColl);
        dateMap.put("standardHour", standardHour);
        return dateMap;
    }

    public static List<HashMap<String, Object>> getShiftItemInfos(Object items, String tDay, Boolean leaveBillEntryIsElasticCalLen) {
        ArrayList<HashMap<String, Object>> shiftList;
        block40: {
            Date currentDate;
            block39: {
                currentDate = AtsDateUtils.stringToShortDate(tDay);
                shiftList = new ArrayList<HashMap<String, Object>>();
                if (!(items instanceof AtsShiftItemCollection)) break block39;
                int size = ((AtsShiftItemCollection)((Object)items)).size();
                for (int i = 0; i < size; ++i) {
                    Timestamp preResTimestamp;
                    Timestamp preTimestamp;
                    HashMap<String, Object> dateMap = new HashMap<String, Object>();
                    String dt = null;
                    String et = null;
                    String restPreDateTime = null;
                    String restNextDateTime = null;
                    AtsShiftItemInfo itemInfo = ((AtsShiftItemCollection)((Object)items)).get(i);
                    Date preDay = AtsDateUtils.getPreDay(currentDate);
                    Date temp = AtsDateUtils.getNextDay(currentDate);
                    if (itemInfo.getPreTimeDayType().getValue() == 0) {
                        dt = AtsDateUtils.dateShortToString(preDay) + " " + itemInfo.getPreTime() + ":00";
                    }
                    if (itemInfo.getPreTimeDayType().getValue() == 1) {
                        dt = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getPreTime() + ":00";
                    }
                    if (itemInfo.getPreTimeDayType().getValue() == 2) {
                        dt = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getPreTime() + ":00";
                    }
                    if (itemInfo.getNextTimeDayType().getValue() == 0) {
                        et = AtsDateUtils.dateShortToString(preDay) + " " + itemInfo.getPreTime() + ":00";
                    }
                    if (itemInfo.getNextTimeDayType().getValue() == 1) {
                        et = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getNextTime() + ":00";
                    }
                    if (itemInfo.getNextTimeDayType().getValue() == 2) {
                        et = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getNextTime() + ":00";
                    }
                    if (itemInfo.getPreTimeDayType().getValue() == 0 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                        restPreDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(currentDate)) + " " + itemInfo.getRestPreTime() + ":00";
                        preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                        preResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestPreTime() + ":00");
                        if (preResTimestamp.getTime() < preTimestamp.getTime()) {
                            restPreDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                        }
                    }
                    if (itemInfo.getPreTimeDayType().getValue() == 1 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                        restPreDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                        preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                        preResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestPreTime() + ":00");
                        if (preResTimestamp.getTime() < preTimestamp.getTime()) {
                            restPreDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(currentDate)) + " " + itemInfo.getRestPreTime() + ":00";
                        }
                    }
                    if (itemInfo.getPreTimeDayType().getValue() == 2 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                        restPreDateTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestPreTime() + ":00";
                    }
                    if (itemInfo.getNextTimeDayType().getValue() == 1 && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                        restNextDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                        preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                        Timestamp nextResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestNextTime() + ":00");
                        if (itemInfo.getPreTimeDayType().getValue() == 0 && itemInfo.getNextTimeDayType().getValue() == 1) {
                            restNextDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                        } else if (nextResTimestamp.getTime() < preTimestamp.getTime()) {
                            restNextDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(currentDate)) + " " + itemInfo.getRestNextTime() + ":00";
                        }
                    }
                    if (itemInfo.getNextTimeDayType().getValue() == 2 && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                        restNextDateTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestNextTime() + ":00";
                    }
                    long segRest = itemInfo.getSegmentInRest() == null ? 0L : itemInfo.getSegmentInRest().longValue();
                    dateMap.put("beginTime", dt);
                    dateMap.put("endTime", et);
                    dateMap.put("segRest", segRest);
                    dateMap.put("restPreDateTime", restPreDateTime);
                    dateMap.put("restNextDateTime", restNextDateTime);
                    shiftList.add(dateMap);
                }
                break block40;
            }
            if (!(items instanceof ScheduleShiftItemCollection)) break block40;
            int size = ((ScheduleShiftItemCollection)((Object)items)).size();
            Boolean isElastic = false;
            Integer elasticType = 0;
            BigDecimal elasticValue = new BigDecimal(0);
            try {
                if (size > 0) {
                    ScheduleShiftInfo scheduleShiftInfo = ((ScheduleShiftItemCollection)((Object)items)).get(0).getGroup();
                    isElastic = scheduleShiftInfo.isIsElastic();
                    elasticValue = scheduleShiftInfo.getElasticValue();
                    if (scheduleShiftInfo.getElasticType() != null) {
                        elasticType = scheduleShiftInfo.getElasticType().getValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < size; ++i) {
                long segRest;
                Timestamp nextResTimestamp;
                Timestamp preResTimestamp;
                Timestamp preTimestamp;
                HashMap<String, Object> dateMap = new HashMap<String, Object>();
                String dt = null;
                String et = null;
                String restPreDateTime = null;
                String restNextDateTime = null;
                ScheduleShiftItemInfo itemInfo = ((ScheduleShiftItemCollection)((Object)items)).get(i);
                Date preDay = AtsDateUtils.getPreDay(currentDate);
                Date temp = AtsDateUtils.getNextDay(currentDate);
                if (itemInfo.getPreTimeDayType().getValue() == 0) {
                    dt = AtsDateUtils.dateShortToString(preDay) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 1) {
                    dt = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 2) {
                    dt = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 0) {
                    dt = AtsDateUtils.dateShortToString(preDay) + " " + itemInfo.getPreTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 1) {
                    et = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 2) {
                    et = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getNextTime() + ":00";
                }
                if (itemInfo.getPreTimeDayType().getValue() == 0 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                    restPreDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(currentDate)) + " " + itemInfo.getRestPreTime() + ":00";
                    preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                    preResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestPreTime() + ":00");
                    if (preResTimestamp.getTime() < preTimestamp.getTime()) {
                        restPreDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                    }
                }
                if (itemInfo.getPreTimeDayType().getValue() == 1 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                    restPreDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestPreTime() + ":00";
                    preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                    preResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestPreTime() + ":00");
                    if (preResTimestamp.getTime() < preTimestamp.getTime()) {
                        restPreDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(currentDate)) + " " + itemInfo.getRestPreTime() + ":00";
                    }
                }
                if (itemInfo.getPreTimeDayType().getValue() == 2 && StringUtils.isNotBlank((String)itemInfo.getRestPreTime())) {
                    restPreDateTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestPreTime() + ":00";
                }
                if (itemInfo.getNextTimeDayType().getValue() == 1 && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                    restNextDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                    preTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getPreTime() + ":00");
                    nextResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestNextTime() + ":00");
                    if (itemInfo.getPreTimeDayType().getValue() == 0 && itemInfo.getNextTimeDayType().getValue() == 1) {
                        restNextDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                        if (nextResTimestamp.getTime() > preTimestamp.getTime()) {
                            restNextDateTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(currentDate)) + " " + itemInfo.getRestNextTime() + ":00";
                        }
                    }
                }
                if (itemInfo.getNextTimeDayType().getValue() == 2 && StringUtils.isNotBlank((String)itemInfo.getRestNextTime())) {
                    restNextDateTime = AtsDateUtils.dateShortToString(temp) + " " + itemInfo.getRestNextTime() + ":00";
                    Timestamp nextTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getNextTime() + ":00");
                    nextResTimestamp = AtsDateUtils.stringToTimestamp(baseDate + " " + itemInfo.getRestNextTime() + ":00");
                    if (nextResTimestamp.getTime() > nextTimestamp.getTime()) {
                        restNextDateTime = AtsDateUtils.dateShortToString(currentDate) + " " + itemInfo.getRestNextTime() + ":00";
                    }
                }
                long l = segRest = itemInfo.getSegmentInRest() == null ? 0L : itemInfo.getSegmentInRest().longValue();
                if (isElastic.booleanValue() && elasticType == 1 && itemInfo.getSegment() != null && Integer.valueOf(itemInfo.getSegment().getValue()) == size && (leaveBillEntryIsElasticCalLen == null || leaveBillEntryIsElasticCalLen.booleanValue())) {
                    et = FetchCardUtil.hourExtend(et, elasticValue);
                }
                dateMap.put("beginTime", dt);
                dateMap.put("endTime", et);
                dateMap.put("segRest", segRest);
                dateMap.put("restPreDateTime", restPreDateTime);
                dateMap.put("restNextDateTime", restNextDateTime);
                shiftList.add(dateMap);
            }
        }
        return shiftList;
    }

    public static long calSegmentLength(List<HashMap<String, Object>> shiftList, Timestamp beginTimeCount, Timestamp endTimeCount, long leaveLength) {
        for (int i = 0; i < shiftList.size(); ++i) {
            HashMap<String, Object> mapTime = shiftList.get(i);
            String segbegStr = (String)mapTime.get("beginTime");
            String segEndStr = (String)mapTime.get("endTime");
            long segmentInRest = (Long)mapTime.get("segRest");
            Timestamp beginTimeStamp = AtsDateUtils.stringToTimestamp(segbegStr);
            Timestamp segEndTime = AtsDateUtils.stringToTimestamp(segEndStr);
            String restPreDateTime = null;
            if (mapTime.get("restPreDateTime") != null) {
                restPreDateTime = (String)mapTime.get("restPreDateTime");
            }
            String restNextDateTime = null;
            if (mapTime.get("restNextDateTime") != null) {
                restNextDateTime = (String)mapTime.get("restNextDateTime");
            }
            double mixdiff = new BigDecimal(segmentInRest).doubleValue();
            if (restPreDateTime != null && restNextDateTime != null) {
                mixdiff = AtsServerUtils.getTwoDateTimesDiff(beginTimeCount, endTimeCount, AtsDateUtils.stringToTimestamp(restPreDateTime), AtsDateUtils.stringToTimestamp(restNextDateTime));
            }
            long realCommonTime = 0L;
            if (shiftList.size() == 1) {
                long rest = BigDecimal.valueOf(mixdiff).longValue() * 60L * 1000L;
                realCommonTime = AtsLeaveBillUtils.getCommonTime(beginTimeCount.getTime(), endTimeCount.getTime(), beginTimeStamp.getTime(), segEndTime.getTime()) - rest;
            } else {
                realCommonTime = AtsLeaveBillUtils.getCommonTime(beginTimeCount.getTime(), endTimeCount.getTime(), beginTimeStamp.getTime(), segEndTime.getTime()) - segmentInRest * 60L * 1000L;
            }
            if (realCommonTime <= 0L) continue;
            leaveLength += realCommonTime;
        }
        return leaveLength;
    }

    public static Map<String, Object> calSegmentLength(Context ctx, List<HashMap<String, Object>> shiftList, Timestamp beginTimeCount, Timestamp endTimeCount, long leaveLength, HolidayPolicyInfo holidayPolicyInfo, BigDecimal standardHour) {
        String segbegStr;
        HashMap<String, Object> resl = new HashMap<String, Object>();
        Timestamp shiftBeginTimeStamp = null;
        Timestamp shiftEndTimeStamp = null;
        for (int i = 0; i < shiftList.size(); ++i) {
            HashMap<String, Object> mapTime = shiftList.get(i);
            segbegStr = (String)mapTime.get("beginTime");
            String segEndStr = (String)mapTime.get("endTime");
            long segmentInRest = (Long)mapTime.get("segRest");
            String restPreDateTime = null;
            if (mapTime.get("restPreDateTime") != null) {
                restPreDateTime = (String)mapTime.get("restPreDateTime");
            }
            String restNextDateTime = null;
            if (mapTime.get("restNextDateTime") != null) {
                restNextDateTime = (String)mapTime.get("restNextDateTime");
            }
            double mixdiff = new BigDecimal(segmentInRest).doubleValue();
            if (restPreDateTime != null && restNextDateTime != null) {
                mixdiff = AtsServerUtils.getTwoDateTimesDiff(beginTimeCount, endTimeCount, AtsDateUtils.stringToTimestamp(restPreDateTime), AtsDateUtils.stringToTimestamp(restNextDateTime));
            }
            Timestamp beginTimeStamp = AtsDateUtils.stringToTimestamp(segbegStr);
            Timestamp segEndTime = AtsDateUtils.stringToTimestamp(segEndStr);
            if (i == 0) {
                shiftBeginTimeStamp = beginTimeStamp;
            }
            if (i == shiftList.size() - 1) {
                shiftEndTimeStamp = segEndTime;
            }
            long realCommonTime = 0L;
            if (shiftList.size() == 1) {
                segmentInRest = BigDecimal.valueOf(mixdiff).longValue();
                realCommonTime = AtsLeaveBillUtils.getCommonTime(beginTimeCount.getTime(), endTimeCount.getTime(), beginTimeStamp.getTime(), segEndTime.getTime());
            } else {
                realCommonTime = AtsLeaveBillUtils.getCommonTime(beginTimeCount.getTime(), endTimeCount.getTime(), beginTimeStamp.getTime(), segEndTime.getTime());
            }
            if (realCommonTime > 0L) {
                if (resl.get("segRest") != null) {
                    resl.put("segRest", (Long)resl.get("segRest") + segmentInRest * 60L * 1000L);
                } else {
                    resl.put("segRest", segmentInRest * 60L * 1000L);
                }
            }
            if (holidayPolicyInfo != null) {
                String holidayPolicySetId = holidayPolicyInfo.getHolidayPolicySet().getId().toString();
                HolidayPolicySetInfo holidayPolicySet = null;
                try {
                    holidayPolicySet = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo((IObjectPK)new ObjectUuidPK(holidayPolicySetId));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (holidayPolicySet != null && holidayPolicySet.getDeductRule() != null && holidayPolicySet.getDeductRule().getValue() == 1) {
                    realCommonTime -= segmentInRest * 60L * 1000L;
                } else if (holidayPolicySet != null && holidayPolicySet.getDeductRule() != null && holidayPolicySet.getDeductRule().getValue() == 2 && holidayPolicySet.getAllowDeductHour() != null && (double)realCommonTime >= holidayPolicySet.getAllowDeductHour().doubleValue() * 60.0 * 60.0 * 1000.0) {
                    realCommonTime -= segmentInRest * 60L * 1000L;
                }
            } else {
                realCommonTime -= segmentInRest * 60L * 1000L;
            }
            if (realCommonTime <= 0L) continue;
            leaveLength += realCommonTime;
        }
        if (!shiftList.isEmpty()) {
            HashMap<String, Object> mapTime = shiftList.get(0);
            HashMap<String, Object> lastTime = shiftList.get(shiftList.size() - 1);
            segbegStr = (String)mapTime.get("beginTime");
            String lastEndSeg = (String)lastTime.get("endTime");
            Timestamp segBeginTime = AtsDateUtils.stringToTimestamp(segbegStr);
            Timestamp segEndTime = AtsDateUtils.stringToTimestamp(lastEndSeg);
            if (beginTimeCount.getTime() <= segBeginTime.getTime() && endTimeCount.getTime() >= segEndTime.getTime()) {
                resl.put("segRest", 0L);
            }
        }
        if (shiftBeginTimeStamp != null && shiftEndTimeStamp != null && beginTimeCount.getTime() <= shiftBeginTimeStamp.getTime() && endTimeCount.getTime() >= shiftEndTimeStamp.getTime()) {
            leaveLength = standardHour.multiply(new BigDecimal(3600000L)).longValue();
        }
        resl.put("realLen", leaveLength);
        return resl;
    }

    public static HashMap<String, Object> calLastSendDayLength(List<HashMap<String, Object>> shiftList, Timestamp beginTimeCount, Timestamp endTimeCount, Date lastSendDay) {
        boolean crossDayFlag = false;
        int currendDay = lastSendDay.getDay();
        long leaveLength = 0L;
        for (int i = 0; i < shiftList.size(); ++i) {
            HashMap<String, Object> mapTime = shiftList.get(i);
            String segbegStr = (String)mapTime.get("beginTime");
            String segEndStr = (String)mapTime.get("endTime");
            long segmentInRest = (Long)mapTime.get("segRest");
            long realCommonTime = 0L;
            Timestamp beginTimeStamp = AtsDateUtils.stringToTimestamp(segbegStr);
            Timestamp endTimeStamp = AtsDateUtils.stringToTimestamp(segEndStr);
            int lastEndDay = endTimeStamp.getDay();
            if (currendDay != lastEndDay && endTimeStamp.getTime() > endTimeCount.getTime()) {
                realCommonTime = endTimeCount.getTime() > beginTimeStamp.getTime() ? endTimeStamp.getTime() - endTimeCount.getTime() - segmentInRest * 60L * 1000L : endTimeStamp.getTime() - beginTimeStamp.getTime() - segmentInRest * 60L * 1000L;
                crossDayFlag = true;
            }
            leaveLength += realCommonTime;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leaveLength", leaveLength);
        map.put("crossDayFlag", crossDayFlag);
        return map;
    }

    public static long getCommonTime(long beginTime1, long endTime1, long beginTime2, long endTime2) {
        long beginTime = 0L;
        long endTime = 0L;
        endTime = endTime1 < endTime2 ? endTime1 : endTime2;
        long commonTime = endTime - (beginTime = beginTime1 > beginTime2 ? beginTime1 : beginTime2);
        if (commonTime < 0L) {
            return 0L;
        }
        return commonTime;
    }

    public static void updateAtsLeaveBillEntryIsCancelLeaveInfo(Context ctx, String leaveBillId, int submitType) {
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Object atsLeaveBillInfo = null;
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = null;
        AtsLeaveBillEntryControllerBean atsBillEntryControllerBean = new AtsLeaveBillEntryControllerBean();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        Object atsLeaveBillEntryCollection = null;
        try {
            atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillId));
            if (submitType == 0) {
                atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.notcancel);
            } else if (submitType == 1) {
                atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.hascancel);
            } else if (submitType == 2) {
                atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.midcancel);
            }
            atsLeaveBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsLeaveBillEntryInfo.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            coreBaseCollection.add((CoreBaseInfo)atsLeaveBillEntryInfo);
            atsBillEntryControllerBean.update(ctx, coreBaseCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateAtsLeaveBillEntryIsCancelLeaveInfo(Context ctx, String cancelLeaveBillEntriesId, String leaveBillEntriesId, int submitType) {
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = null;
        AtsLeaveBillEntryControllerBean atsBillEntryControllerBean = new AtsLeaveBillEntryControllerBean();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        try {
            atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveBillEntriesId));
            CancelLeaveBillEntryCollection cancelLeaveBillEntryCollection = CancelLeaveBillEntryFactory.getLocalInstance(ctx).getCancelLeaveBillEntryCollection(AtsLeaveBillUtils.requireCancelLeaveEntriseOsql(cancelLeaveBillEntriesId, leaveBillEntriesId));
            boolean isCancelLeaveBool = AtsLeaveBillUtils.requireIsCancelLeaveBool(ctx, cancelLeaveBillEntryCollection);
            if (submitType == 0) {
                if (isCancelLeaveBool) {
                    atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.notcancel);
                } else {
                    atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.hascancel);
                }
            } else if (submitType == 1) {
                atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.hascancel);
            } else if (submitType == 2) {
                atsLeaveBillEntryInfo.setIsCancelLeave(LeavebillCancelEnum.midcancel);
            }
            atsLeaveBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsLeaveBillEntryInfo.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            coreBaseCollection.add((CoreBaseInfo)atsLeaveBillEntryInfo);
            atsBillEntryControllerBean.update(ctx, coreBaseCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static boolean requireIsCancelLeaveBool(Context ctx, CancelLeaveBillEntryCollection cancelLeaveBillEntryCollection) throws BOSException {
        boolean isCancelLeaveBool = true;
        if (null != cancelLeaveBillEntryCollection && cancelLeaveBillEntryCollection.size() > 0) {
            CancelLeaveBillCollection cancelLeaveBillCollection = null;
            for (int i = 0; i < cancelLeaveBillEntryCollection.size(); ++i) {
                cancelLeaveBillCollection = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillCollection(" where id = '" + cancelLeaveBillEntryCollection.get(i).getBill().getId().toString() + "' and billState= " + 3);
                if (null == cancelLeaveBillCollection || cancelLeaveBillCollection.size() <= 0) continue;
                isCancelLeaveBool = false;
                break;
            }
        }
        return isCancelLeaveBool;
    }

    private static String requireCancelLeaveEntriseOsql(String cancelLeaveBillEntriesId, String leaveBillEntriesId) {
        StringBuilder cancelLeaveEntriesSb = new StringBuilder();
        cancelLeaveEntriesSb.append(" where id <> '");
        cancelLeaveEntriesSb.append(cancelLeaveBillEntriesId);
        cancelLeaveEntriesSb.append("'and leaveEntryBill.id='");
        cancelLeaveEntriesSb.append(leaveBillEntriesId);
        cancelLeaveEntriesSb.append("' and leaveEntryBill.isCancelLeave= ");
        cancelLeaveEntriesSb.append(1);
        return cancelLeaveEntriesSb.toString();
    }

    public static void updateAtsLeaveBillEntryUserAndTime(Context ctx, String leaveEntryBillId, int submitType) {
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = null;
        AtsLeaveBillEntryControllerBean atsBillEntryControllerBean = new AtsLeaveBillEntryControllerBean();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        try {
            atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(leaveEntryBillId));
            atsLeaveBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsLeaveBillEntryInfo.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            coreBaseCollection.add((CoreBaseInfo)atsLeaveBillEntryInfo);
            atsBillEntryControllerBean.update(ctx, coreBaseCollection);
        }
        catch (Exception e) {
            System.out.println(".............." + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void updateAtsTripBillEntryIsCancelTripInfo(Context ctx, String TripBillEntryId, int submitType) {
        AtsTripBillEntryInfo atsTripBillEntryInfo = null;
        AtsTripBillEntryControllerBean atsBillEntryControllerBean = new AtsTripBillEntryControllerBean();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        AtsTripBillEntryCollection atsTripBillEntryCollection = null;
        try {
            atsTripBillEntryCollection = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryCollection(" where id='" + TripBillEntryId + "'");
            atsTripBillEntryInfo = atsTripBillEntryCollection.get(0);
            atsTripBillEntryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            atsTripBillEntryInfo.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            if (submitType == 0) {
                atsTripBillEntryInfo.setIsCancelTrip(TripbillCancelEnum.midconfirm);
            } else if (submitType == 1) {
                atsTripBillEntryInfo.setIsCancelTrip(TripbillCancelEnum.hasconfirm);
            } else if (submitType == 2) {
                atsTripBillEntryInfo.setIsCancelTrip(TripbillCancelEnum.notconfirm);
            }
            coreBaseCollection.add((CoreBaseInfo)atsTripBillEntryInfo);
            atsBillEntryControllerBean.update(ctx, coreBaseCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, Object> getdefaultShiftItemByHis(Context ctx, AttendanceFileHISInfo attendanceFileInfo, HolidayPolicyInfo holidayPolicyInfo) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        AtsShiftCollection defaultAtsShiftColl = new AtsShiftCollection();
        if (attendanceFileInfo != null && attendanceFileInfo.getAtsShift() != null) {
            try {
                defaultAtsShiftColl = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(" where id='" + attendanceFileInfo.getAtsShift().getId() + "'");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        BigDecimal defaultStandardHour = holidayPolicyInfo.getHolidayPolicySet().getDefaultStandardHour();
        AtsShiftItemCollection defaultAtsShiftItemCollection = new AtsShiftItemCollection();
        if (defaultAtsShiftColl.size() != 0) {
            defaultStandardHour = defaultAtsShiftColl.get(0).getStandardHour();
            try {
                defaultAtsShiftItemCollection = AtsShiftItemFactory.getLocalInstance(ctx).getAtsShiftItemCollection(" where group='" + defaultAtsShiftColl.get(0).getId().toString() + "'");
                if (defaultAtsShiftItemCollection != null && !defaultAtsShiftItemCollection.isEmpty()) {
                    for (int i = 0; i < defaultAtsShiftItemCollection.size(); ++i) {
                        AtsShiftItemInfo atsShiftItemInfo = defaultAtsShiftItemCollection.get(i);
                        if (!atsShiftItemInfo.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) && !atsShiftItemInfo.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) continue;
                        defaultAtsShiftItemCollection.remove(atsShiftItemInfo);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        dateMap.put("scheduleShiftItemColl", (Object)defaultAtsShiftItemCollection);
        dateMap.put("standardHour", defaultStandardHour);
        return dateMap;
    }

    public static boolean isHalfDay(Context ctx, String personId, Date date) {
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, date);
        if (null != scheduleShiftInfo) {
            return scheduleShiftInfo.isIsHalfDay();
        }
        try {
            AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("where proposer.id = '" + personId + "' and attendFileState = 1 ");
            if (attendanceFileColl != null && attendanceFileColl.size() > 0) {
                AttendanceFileInfo attendFile = attendanceFileColl.get(0);
                AtsShiftCollection shiftColl = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("where id = '" + attendFile.getAtsShift().getId().toString() + "'");
                if (shiftColl != null && shiftColl.size() > 0) {
                    return shiftColl.get(0).isIsHalfDay();
                }
                return false;
            }
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static AtsHolidayFileHisInfo getAtsHolidayFileHisInfoByAttenceDate(Context ctx, Date attenceDate, String proposerId) throws BOSException {
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id = '" + proposerId + "'");
        for (int i = 0; i < atsHolidayFileHisCollection.size(); ++i) {
            if (attenceDate.getTime() < atsHolidayFileHisCollection.get(i).getEFFDT().getTime() || attenceDate.getTime() > atsHolidayFileHisCollection.get(i).getLEFFDT().getTime()) continue;
            return atsHolidayFileHisCollection.get(i);
        }
        return null;
    }
}

