/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.log4j.AtsLogger;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.CardRuleResult;
import com.kingdee.eas.hr.ats.util.CardRuleResultInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CardRuleServerCrossShift {
    AtsLogger logger = AtsLogger.getLogger();
    boolean sqlOutOn = AtsServerUtils.isOutPutSql(AtsLogger.getInstance().getCtx());
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();
    public String GMTDate = "1970-01-01";
    public String baseDate = "1990-01-01";
    public String split = " ";
    public String time_suffix = "00:00:00";
    public String timeInterval = "2";
    public String compareInterval = this.GMTDate + this.split + "00:02:00";
    public long timeIntervalMillisecond = new BigDecimal(this.timeInterval).longValue() * 60L * 1000L;
    public int segOneAssignType = 2;
    public int segOneAssignValue = 1;
    public int segTwoAssignType = 2;
    public int segTwoAssignValue = 4;
    public String firstOnTime = "20:00:00";
    public String firstOffTime = "06:00:00";
    public String secondOnTime = "08:00:00";
    public String secondOffTime = "12:00:00";
    public String thirdOnTime = "13:00:00";
    public String thirdOffTime = "17:00:00";
    public String firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
    public String firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
    public String secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
    public String secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
    public String thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
    public String thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;
    String firstOnworkTimeNoBase = "2014-02-24 20:00:00";
    String firstOffworkTimeNoBase = "2014-02-25 06:00:00";
    String secondOnworkTimeNoBase = "2014-02-25 08:00:00";
    String secondOffworkTimeNoBase = "2014-02-25 12:00:00";
    String thirdOnTimeNoBase = "2014-02-25 13:00:00";
    String thirdOffTimeNoBase = "2014-02-25 17:00:00";

    public CardRuleServerCrossShift() {
        if (this.decimalPlacesSystem == null) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public List getTwoShiftPunchCardData(List list, String onWorkTime, String offWorkTime) {
        ArrayList IntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            IntervalList.add(list.get(i));
        }
        return IntervalList;
    }

    public List getTwoShiftEffectivePunchCardData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        return IntervalEffective_List;
    }

    public String getTwoShiftEffectivePunchCardMinData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String minResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        minResultDate = this.getMinData(IntervalEffective_List);
        return minResultDate;
    }

    public String getTwoShiftEffectivePunchCardMaxData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String maxResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        maxResultDate = this.getMaxData(IntervalEffective_List);
        return maxResultDate;
    }

    public String getTwoShiftEffectivePunchCardMaxDataWithNoBase(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Date resDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        String maxResultDate = this.getMaxData(IntervalEffective_List);
        return maxResultDate;
    }

    public String getTwoShiftEffectivePunchCardMinDataWithNoBase(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Date resDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        String minResultDate = this.getMinData(IntervalEffective_List);
        return minResultDate;
    }

    public List<CardRuleResultInfo> getOneHeadCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> map = null;
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int predatetypeone = Integer.parseInt(dateTypeMap.get("predatetypeone"));
        map = predatetypeone == 0 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttime, endtime) : this.getStartOrEndDate(attendanceDate, starttime, endtime, oneOnTime, startBigDecimalOne, endBigDecimalOne);
        for (int i = 0; i < list.size(); ++i) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            if (map == null) continue;
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(list.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), oneOnTime);
        Map<String, String> mapCu = null;
        mapCu = predatetypeone == 0 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime")) : this.getStartOrEndDate(attendanceDate, this.firstOnTime, (String)mapCurr.get("endTime"), oneOnTime, startBigDecimalOne, endBigDecimalOne);
        mapCu.get("currentAttBeginDate");
        mapCu.get("nextAttEndDate");
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)headEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("currentAttBeginDate"));
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardList.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardList.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            Map<String, String> mapTwo = null;
            mapTwo = predatetypeone == 0 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttimeT, endtimeT) : this.getStartOrEndDate(attendanceDate, starttimeT, endtimeT, oneOnTime, startBigDecimalTwo, endBigDecimalTwo);
            for (int i = 0; i < list.size(); ++i) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(list.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate2 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate2);
                    headCardList.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardList.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        int onepreTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 1) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                onepreTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
            }
        }
        if (oneonIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOnTime");
            String finalOneOn = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (onepreTimeDayType == 1) {
                finalOneOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            } else if (onepreTimeDayType == 0) {
                finalOneOn = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Oneon = finalOneOn + this.split + shiftTime_Oneon;
            if (headCardList.size() > 0) {
                ((CardRuleResultInfo)headCardList.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                headCardList.add(infoinner);
            }
        }
        return headCardList;
    }

    public Map<String, String> getStartOrEndDate(Date attendanceDate, String startTime, String endTime, BigDecimal someShiftHour, BigDecimal startNum, BigDecimal endNum) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        String attDate = AtsDateUtils.dateLongToString(attendanceDate);
        attDate = AtsDateUtils.getDateFromLongString(attDate);
        String currentAttBeginDate = attDate + this.split + startTime;
        String nextAttEndDate = "";
        if (someShiftHour.floatValue() > 24.0f || someShiftHour.add(endNum).doubleValue() >= 24.0) {
            Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
            String nextAttDate = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
            nextAttEndDate = nextAttDate + this.split + endTime;
        } else if (someShiftHour.floatValue() <= 24.0f) {
            Date nextDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
            String nextDateStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextDate));
            nextAttEndDate = endTime.equals(this.time_suffix) ? nextDateStr + this.split + this.time_suffix : attDate + this.split + endTime;
        }
        startEndMap.put("currentAttBeginDate", currentAttBeginDate);
        startEndMap.put("nextAttEndDate", nextAttEndDate);
        return startEndMap;
    }

    public Map<String, String> getStartOrEndDateWithDateType(Map<String, String> dateTypeMap, Date attendanceDate, String startTime, String endTime) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        int predatetypeone = Integer.parseInt(dateTypeMap.get("predatetypeone"));
        String currentAttBeginDate = null;
        String nextAttEndDate = null;
        if (predatetypeone == 0) {
            currentAttBeginDate = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + this.split + startTime;
            nextAttEndDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + endTime;
        }
        if (predatetypeone == 1) {
            currentAttBeginDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + endTime;
            nextAttEndDate = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + this.split + startTime;
        }
        startEndMap.put("currentAttBeginDate", currentAttBeginDate);
        startEndMap.put("nextAttEndDate", nextAttEndDate);
        return startEndMap;
    }

    public Map<String, String> getStartOrEndDateWithDateTypeTailTwo(Map<String, String> dateTypeMap, Date attendanceDate, String startTime, String endTime, BigDecimal OffTime, BigDecimal endHour, int dateTypeTag) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        String currentAttBeginDate = null;
        String nextAttEndDate = null;
        if (dateTypeTag == 0) {
            currentAttBeginDate = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + this.split + startTime;
            nextAttEndDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + endTime;
            if (endHour.add(OffTime).doubleValue() >= 24.0) {
                nextAttEndDate = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + this.split + endTime;
            }
        }
        if (dateTypeTag == 1) {
            currentAttBeginDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + startTime;
            nextAttEndDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + endTime;
            if (endHour.add(OffTime).doubleValue() >= 24.0) {
                nextAttEndDate = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + this.split + endTime;
            }
        }
        if (dateTypeTag == 2) {
            currentAttBeginDate = AtsDateUtils.dateShortToString(attendanceDate) + this.split + endTime;
            nextAttEndDate = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + this.split + startTime;
            if (endHour.add(OffTime).doubleValue() >= 24.0) {
                nextAttEndDate = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate, 2)) + this.split + endTime;
            }
        }
        startEndMap.put("currentAttBeginDate", currentAttBeginDate);
        startEndMap.put("nextAttEndDate", nextAttEndDate);
        return startEndMap;
    }

    public Map<String, String> getStartOrEndDateWithDateTypeTailThree(Map<String, String> dateTypeMap, Date attendanceDate, String startTime, String endTime) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        return startEndMap;
    }

    public Map<String, String> getStartOrEndDateSecondDayFixed(Date attendanceDate, String startTime, String endTime, BigDecimal someShiftHour) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        String attDate = AtsDateUtils.dateLongToString(attendanceDate);
        attDate = AtsDateUtils.getDateFromLongString(attDate);
        Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
        String nextAttDate = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
        String currentAttBeginDate = nextAttDate + this.split + startTime;
        String nextAttEndDate = nextAttDate + this.split + endTime;
        startEndMap.put("currentAttBeginDate", currentAttBeginDate);
        startEndMap.put("nextAttEndDate", nextAttEndDate);
        return startEndMap;
    }

    public Map<String, String> getStartOrEndDateDayNotFixed(Date attendanceDate, String startTime, String endTime, BigDecimal someShiftHour, BigDecimal diffValue) {
        HashMap<String, String> startEndMap = new HashMap<String, String>();
        String attDate = AtsDateUtils.dateLongToString(attendanceDate);
        attDate = AtsDateUtils.getDateFromLongString(attDate);
        Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
        String nextAttDate = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
        long orgin = 86400000L;
        long difflong = diffValue.longValue() * 60L * 60L * 1000L;
        long reslong = orgin - difflong;
        String tempStartTime = AtsDateUtils.formatLongToTimeStr(reslong);
        if (reslong < 0L) {
            tempStartTime = "00:00:00";
        }
        String currentAttBeginDate = attDate + this.split + tempStartTime;
        String nextAttEndDate = nextAttDate + this.split + endTime;
        startEndMap.put("currentAttBeginDate", currentAttBeginDate);
        startEndMap.put("nextAttEndDate", nextAttEndDate);
        return startEndMap;
    }

    public List<CardRuleResultInfo> getOneTailCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        int i;
        String mixDate;
        if (shiftInfo != null) {
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal firstOff_time = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOffTime));
        Map<Object, Object> map = new HashMap();
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOneTail, endBigDecimalOneTail, firstOff_time);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int nextdatetypeone = Integer.parseInt(dateTypeMap.get("nextdatetypeone"));
        if (nextdatetypeone == 1) {
            if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, firstOff_time, endBigDecimalOneTail, 1);
            } else if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, firstOff_time, endBigDecimalOneTail, 0);
            }
        }
        if (nextdatetypeone == 2) {
            if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttime, endtime, firstOff_time);
            } else {
                BigDecimal diffValue = firstOff_time.subtract(startBigDecimalOneTail).abs();
                map = this.getStartOrEndDateDayNotFixed(attendanceDate, starttime, endtime, firstOff_time, diffValue);
            }
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i2));
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            tailList.add(list.get(i2));
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), firstOff_time);
        Date nextCrossDate = AtsDateUtils.getNextDay(attendanceDate);
        Map<String, String> mapCu = null;
        if (nextdatetypeone == 1) {
            if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), firstOff_time, BigDecimal.valueOf(0L), 1);
            } else if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), firstOff_time, BigDecimal.valueOf(0L), 0);
            }
        }
        if (nextdatetypeone == 2) {
            mapCu = firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0 ? this.getStartOrEndDate(nextCrossDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), firstOff_time, startBigDecimalOneTail, endBigDecimalOneTail) : this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), firstOff_time, BigDecimal.valueOf(0L), 1);
        }
        if (tailEffectiveList.size() > 0) {
            mixDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1 && !AtsCollectionUtile.isEmpty(mapCu)) {
                ArrayList overShiftList = new ArrayList();
                for (i = 0; i < tailEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)tailEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("nextAttEndDate"));
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setOneOffWorkTimeEarliest(mixDate);
            info.setOneOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                mixDate = this.getMinData(tailEffectiveList);
                info.setOneOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setOneOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Map<Object, Object> mapTwo = new HashMap();
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, firstOff_time);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            if (nextdatetypeone == 1) {
                if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, firstOff_time, endBigDecimalTwo, 1);
                } else if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, firstOff_time, endBigDecimalTwo, 0);
                }
            }
            if (nextdatetypeone == 2) {
                if (firstOff_time.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttimeT, endtimeT, firstOff_time);
                } else {
                    BigDecimal diffValue = firstOff_time.subtract(startBigDecimalOneTail).abs();
                    mapTwo = this.getStartOrEndDateDayNotFixed(attendanceDate, starttimeT, endtimeT, firstOff_time, diffValue);
                }
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i3));
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailTwoList.add(list.get(i3));
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate2 = this.getMinData(tailTwoEffectiveList);
                    info.setOneOffWorkTime(mixDate2);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setOneOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int oneoffIsPunchCard = 1;
        int onenextTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 1) {
            for (i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                onenextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
            }
        }
        if (oneoffIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOffTime");
            String finalOneOff = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (onenextTimeDayType == 1) {
                finalOneOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            }
            if (onenextTimeDayType == 0) {
                finalOneOff = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Oneoff = finalOneOff + this.split + shiftTime_Oneoff;
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOffWorkTime(shiftTime_Oneoff);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getTwoPunchCardInfo(AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        String mixDate;
        CardRuleResultInfo info;
        String nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        if (shiftInfo != null) {
            String nextAttendDateStr;
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
            this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
            this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
            this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
            this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
            this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
            String attDate = AtsDateUtils.dateLongToString(attendanceDate);
            attDate = AtsDateUtils.getDateFromLongString(attDate);
            Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
            nextShiftTimeStr = nextAttendDateStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
            int fpredatetypeone = 1;
            int fnextdatetypeone = 1;
            int fpredatetypetwo = 1;
            int fnextdatetypetwo = 1;
            int fpredatetypethree = 1;
            int fnextdatetypethree = 1;
            AtsShiftItemCollection coll = shiftInfo.getItems();
            for (int i = 0; i < coll.size(); ++i) {
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 1) {
                    fpredatetypeone = coll.get(i).getPreTimeDayType().getValue();
                    fnextdatetypeone = coll.get(i).getNextTimeDayType().getValue();
                }
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 2) {
                    fpredatetypeone = coll.get(0).getPreTimeDayType().getValue();
                    fnextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
                    fpredatetypetwo = coll.get(1).getPreTimeDayType().getValue();
                    fnextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
                }
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) != 3) continue;
                fpredatetypeone = coll.get(0).getPreTimeDayType().getValue();
                fnextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
                fpredatetypetwo = coll.get(1).getPreTimeDayType().getValue();
                fnextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
                fpredatetypethree = coll.get(2).getPreTimeDayType().getValue();
                fnextdatetypethree = coll.get(2).getNextTimeDayType().getValue();
            }
            String needAttendDateOneOn = attDate;
            if (fpredatetypeone == 0) {
                needAttendDateOneOn = AtsDateUtils.getPreDay(attDate);
            } else if (fpredatetypeone == 1) {
                needAttendDateOneOn = attDate;
            } else if (fpredatetypeone == 2) {
                needAttendDateOneOn = nextAttendDateStr;
            }
            String needAttendDateOneOff = attDate;
            if (fnextdatetypeone == 0) {
                needAttendDateOneOff = AtsDateUtils.getPreDay(attDate);
            } else if (fnextdatetypeone == 1) {
                needAttendDateOneOff = attDate;
            } else if (fnextdatetypeone == 2) {
                needAttendDateOneOff = nextAttendDateStr;
            }
            String needAttendDateTwoOn = attDate;
            if (fpredatetypetwo == 0) {
                needAttendDateTwoOn = AtsDateUtils.getPreDay(attDate);
            } else if (fpredatetypetwo == 1) {
                needAttendDateTwoOn = attDate;
            } else if (fpredatetypetwo == 2) {
                needAttendDateTwoOn = nextAttendDateStr;
            }
            String needAttendDateTwoOff = attDate;
            if (fnextdatetypetwo == 0) {
                needAttendDateTwoOff = AtsDateUtils.getPreDay(attDate);
            } else if (fnextdatetypetwo == 1) {
                needAttendDateTwoOff = attDate;
            } else if (fnextdatetypetwo == 2) {
                needAttendDateTwoOff = nextAttendDateStr;
            }
            this.firstOnworkTimeNoBase = needAttendDateOneOn + this.split + this.firstOnTime;
            this.firstOffworkTimeNoBase = needAttendDateOneOff + this.split + this.firstOffTime;
            this.secondOnworkTimeNoBase = needAttendDateTwoOn + this.split + this.secondOnTime;
            this.secondOffworkTimeNoBase = needAttendDateTwoOff + this.split + this.secondOffTime;
        }
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegFirAssignType() != null) {
                this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
            }
            if (cardRuleInfo.getSegFirAssignSegment() != null) {
                this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> getCardList = new ArrayList<CardRuleResultInfo>();
        int oneoffIsPunchCard = 1;
        int nextTimeDayType = 1;
        int twoonIsPunchCard = 1;
        int preTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 1) {
                    oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                    nextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 2) continue;
                twoonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                preTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
            }
        }
        String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
        String shiftTime_Twoon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
        String finalOneOff = nextShiftTimeStr;
        String finalTwoOn = nextShiftTimeStr;
        if (nextTimeDayType == 1) {
            finalOneOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        } else if (nextTimeDayType == 0) {
            finalOneOff = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
        }
        if (preTimeDayType == 1) {
            finalTwoOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        } else if (preTimeDayType == 0) {
            finalTwoOn = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
        }
        shiftTime_Oneoff = finalOneOff + this.split + shiftTime_Oneoff;
        shiftTime_Twoon = finalTwoOn + this.split + shiftTime_Twoon;
        ArrayList segIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Date resDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(this.firstOffworkTimeNoBase);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(this.secondOnworkTimeNoBase);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            segIntervalList.add(list.get(i));
        }
        List segIntervalEffectiveList = this.getEffectivePunchData(segIntervalList);
        if (this.sqlOutOn) {
            this.logger.info("cross_seg_2_effective_collection" + segIntervalEffectiveList.size());
        }
        if (segIntervalEffectiveList.size() >= 2) {
            info = new CardRuleResultInfo();
            mixDate = this.getMinData(segIntervalEffectiveList);
            String maxDate = this.getMaxData(segIntervalEffectiveList);
            info.setOneOffWorkTime(mixDate);
            info.setTwoOnWorkTime(maxDate);
            getCardList.add(info);
        }
        if (segIntervalEffectiveList.size() == 1) {
            if (this.segOneAssignType == 1) {
                if (this.segOneAssignValue == 1) {
                    info = new CardRuleResultInfo();
                    mixDate = (String)segIntervalEffectiveList.get(0);
                    info.setOneOffWorkTime(mixDate);
                    getCardList.add(info);
                } else if (this.segOneAssignValue == 2) {
                    info = new CardRuleResultInfo();
                    mixDate = (String)segIntervalEffectiveList.get(0);
                    info.setTwoOnWorkTime(mixDate);
                    getCardList.add(info);
                }
            }
            if (this.segOneAssignType == 2) {
                CardRuleResultInfo info2;
                String interDatasString = (String)segIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearlyNoBase(this.firstOffworkTimeNoBase, this.secondOnworkTimeNoBase, interDatasString);
                if (res == 1) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 2) {
                    info2 = new CardRuleResultInfo();
                    info2.setTwoOnWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 3) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                }
            }
        }
        if (segIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setTwoOnWorkTime(shiftTime_Twoon);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                info.setTwoOnWorkTime(shiftTime_Twoon);
                getCardList.add(info);
            }
        }
        return getCardList;
    }

    public Map<String, String> getShiftInfoDayType(AtsShiftInfo shiftInfo) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        int predatetypeone = 1;
        int nextdatetypeone = 1;
        int predatetypetwo = 1;
        int nextdatetypetwo = 1;
        int predatetypethree = 1;
        int nextdatetypethree = 1;
        AtsShiftItemCollection coll = shiftInfo.getItems();
        for (int i = 0; i < coll.size(); ++i) {
            if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 1) {
                predatetypeone = coll.get(i).getPreTimeDayType().getValue();
                nextdatetypeone = coll.get(i).getNextTimeDayType().getValue();
            }
            if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 2) {
                predatetypeone = coll.get(0).getPreTimeDayType().getValue();
                nextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
                predatetypetwo = coll.get(1).getPreTimeDayType().getValue();
                nextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
            }
            if (Integer.valueOf(coll.get(i).getSegment().getValue()) != 3) continue;
            predatetypeone = coll.get(0).getPreTimeDayType().getValue();
            nextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
            predatetypetwo = coll.get(1).getPreTimeDayType().getValue();
            nextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
            predatetypethree = coll.get(2).getPreTimeDayType().getValue();
            nextdatetypethree = coll.get(2).getNextTimeDayType().getValue();
        }
        resMap.put("predatetypeone", String.valueOf(predatetypeone));
        resMap.put("nextdatetypeone", String.valueOf(nextdatetypeone));
        resMap.put("predatetypetwo", String.valueOf(predatetypetwo));
        resMap.put("nextdatetypetwo", String.valueOf(nextdatetypetwo));
        resMap.put("predatetypethree", String.valueOf(predatetypethree));
        resMap.put("nextdatetypethree", String.valueOf(nextdatetypethree));
        return resMap;
    }

    public List<CardRuleResultInfo> getTwoHeadCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int predatetypeone = Integer.parseInt(dateTypeMap.get("predatetypeone"));
        int nextdatetypeone = Integer.parseInt(dateTypeMap.get("nextdatetypeone"));
        int predatetypetwo = Integer.parseInt(dateTypeMap.get("predatetypetwo"));
        int nextdatetypetwo = Integer.parseInt(dateTypeMap.get("nextdatetypetwo"));
        Map<String, String> map = null;
        map = predatetypeone == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1) || predatetypetwo == 0 && nextdatetypetwo == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttime, endtime) : this.getStartOrEndDate(attendanceDate, starttime, endtime, oneOnTime, startBigDecimalOne, endBigDecimalOne);
        for (int i = 0; i < list.size(); ++i) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            if (map == null) continue;
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(list.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), oneOnTime);
        Map<String, String> mapCu = null;
        mapCu = predatetypeone == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1) || predatetypetwo == 0 && nextdatetypetwo == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime")) : this.getStartOrEndDate(attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), oneOnTime, startBigDecimalOne, endBigDecimalOne);
        mapCu.get("currentAttBeginDate");
        mapCu.get("nextAttEndDate");
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)headEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("currentAttBeginDate"));
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardList.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardList.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            Map<String, String> mapTwo = null;
            mapTwo = predatetypeone == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1) || predatetypetwo == 0 && nextdatetypetwo == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttimeT, endtimeT) : this.getStartOrEndDate(attendanceDate, starttimeT, endtimeT, oneOnTime, startBigDecimalTwo, endBigDecimalTwo);
            for (int i = 0; i < list.size(); ++i) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
                if (mapTwo == null) continue;
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(list.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate2 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate2);
                    headCardList.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardList.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        int onepreTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                onepreTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
            }
        }
        if (oneonIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
            String finalOneOn = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (onepreTimeDayType == 1) {
                finalOneOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            } else if (onepreTimeDayType == 0) {
                finalOneOn = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Oneon = finalOneOn + this.split + shiftTime_Oneon;
            if (headCardList.size() > 0) {
                ((CardRuleResultInfo)headCardList.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                headCardList.add(infoinner);
            }
        }
        return headCardList;
    }

    public List<CardRuleResultInfo> getTwoTailCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        String mixDate;
        if (shiftInfo != null) {
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal twoOffTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.secondOffTime));
        Map<Object, Object> map = new HashMap();
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOneTail, endBigDecimalOneTail, twoOffTime);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int nextdatetypetwo = Integer.parseInt(dateTypeMap.get("nextdatetypetwo"));
        if (nextdatetypetwo == 1) {
            if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, twoOffTime, endBigDecimalOneTail, 1);
            } else if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, twoOffTime, endBigDecimalOneTail, 0);
            }
        }
        if (nextdatetypetwo == 2) {
            if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttime, endtime, twoOffTime);
            } else {
                BigDecimal diffValue = twoOffTime.subtract(startBigDecimalOneTail).abs();
                map = this.getStartOrEndDateDayNotFixed(attendanceDate, starttime, endtime, twoOffTime, diffValue);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            tailList.add(list.get(i));
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), twoOffTime);
        Date nextCrossDate = AtsDateUtils.getNextDay(attendanceDate);
        Map<String, String> mapCu = null;
        if (nextdatetypetwo == 1) {
            if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), twoOffTime, BigDecimal.valueOf(0L), 1);
            } else if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), twoOffTime, BigDecimal.valueOf(0L), 0);
            }
        } else if (nextdatetypetwo == 2) {
            mapCu = twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0 ? this.getStartOrEndDate(nextCrossDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), twoOffTime, startBigDecimalOneTail, endBigDecimalOneTail) : this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), twoOffTime, BigDecimal.valueOf(0L), 1);
        }
        if (tailEffectiveList.size() > 0) {
            mixDate = null;
            ArrayList overShiftList = new ArrayList();
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1 && !AtsCollectionUtile.isEmpty(mapCu)) {
                for (int i = 0; i < tailEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)tailEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("nextAttEndDate"));
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setTwoOffWorkTimeEarliest(mixDate);
            info.setTwoOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                mixDate = this.getMinData(tailEffectiveList);
                info.setTwoOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setTwoOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Map<Object, Object> mapTwo = new HashMap();
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, twoOffTime);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            if (nextdatetypetwo == 1) {
                if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, twoOffTime, endBigDecimalTwo, 1);
                } else if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, twoOffTime, endBigDecimalTwo, 0);
                }
            }
            if (nextdatetypetwo == 2) {
                if (twoOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttimeT, endtimeT, twoOffTime);
                } else {
                    BigDecimal diffValue = twoOffTime.subtract(startBigDecimalOneTail).abs();
                    mapTwo = this.getStartOrEndDateDayNotFixed(attendanceDate, starttimeT, endtimeT, twoOffTime, diffValue);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailTwoList.add(list.get(i));
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate2 = this.getMinData(tailTwoEffectiveList);
                    info.setTwoOffWorkTime(mixDate2);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setTwoOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int twooffIsPunchCard = 1;
        int twonextTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 2) continue;
                twooffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                twonextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
            }
        }
        if (twooffIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Twooff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
            String finalTwoOff = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (twonextTimeDayType == 1) {
                finalTwoOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            } else if (twonextTimeDayType == 0) {
                finalTwoOff = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Twooff = finalTwoOff + this.split + shiftTime_Twooff;
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setTwoOffWorkTime(shiftTime_Twooff);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getThreeSegmentPunchCardDateInfo(AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        int m;
        CardRuleResultInfo pojoUse;
        CardRuleResultInfo two;
        String mixDate;
        String mixDate2;
        CardRuleResultInfo info;
        String needShiftTimeOneOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        String needShiftTimeTwoOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        String needShiftTimeTwoOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        String needShiftTimeThreeOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
            this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
            this.thirdOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
            this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
            this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
            this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
            this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
            this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
            this.thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
            this.thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;
            String attDate = AtsDateUtils.dateLongToString(attendanceDate);
            attDate = AtsDateUtils.getDateFromLongString(attDate);
            Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
            String nextAttendDateStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
            int fpredatetypeone = 1;
            int fnextdatetypeone = 1;
            int fpredatetypetwo = 1;
            int fnextdatetypetwo = 1;
            int fpredatetypethree = 1;
            int fnextdatetypethree = 1;
            AtsShiftItemCollection coll = shiftInfo.getItems();
            for (int i = 0; i < coll.size(); ++i) {
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 1) {
                    fpredatetypeone = coll.get(i).getPreTimeDayType().getValue();
                    fnextdatetypeone = coll.get(i).getNextTimeDayType().getValue();
                }
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 2) {
                    fpredatetypetwo = coll.get(i).getPreTimeDayType().getValue();
                    fnextdatetypetwo = coll.get(i).getNextTimeDayType().getValue();
                }
                if (Integer.valueOf(coll.get(i).getSegment().getValue()) != 3) continue;
                fpredatetypethree = coll.get(i).getPreTimeDayType().getValue();
                fnextdatetypethree = coll.get(i).getNextTimeDayType().getValue();
            }
            String needAttendDateOneOn = attDate;
            if (fpredatetypeone == 0) {
                needAttendDateOneOn = AtsDateUtils.getPreDay(attDate);
            } else if (fpredatetypeone == 1) {
                needAttendDateOneOn = attDate;
            } else if (fpredatetypeone == 2) {
                needAttendDateOneOn = nextAttendDateStr;
            }
            String needAttendDateOneOff = attDate;
            if (fnextdatetypeone == 0) {
                needAttendDateOneOff = AtsDateUtils.getPreDay(attDate);
            } else if (fnextdatetypeone == 1) {
                needAttendDateOneOff = attDate;
            } else if (fnextdatetypeone == 2) {
                needAttendDateOneOff = nextAttendDateStr;
            }
            String needAttendDateTwoOn = attDate;
            if (fpredatetypetwo == 0) {
                needAttendDateTwoOn = AtsDateUtils.getPreDay(attDate);
            } else if (fpredatetypetwo == 1) {
                needAttendDateTwoOn = attDate;
            } else if (fpredatetypetwo == 2) {
                needAttendDateTwoOn = nextAttendDateStr;
            }
            String needAttendDateTwoOff = attDate;
            if (fnextdatetypetwo == 0) {
                needAttendDateTwoOff = AtsDateUtils.getPreDay(attDate);
            } else if (fnextdatetypetwo == 1) {
                needAttendDateTwoOff = attDate;
            } else if (fnextdatetypetwo == 2) {
                needAttendDateTwoOff = nextAttendDateStr;
            }
            String needAttendDateThreeOn = attDate;
            if (fpredatetypethree == 0) {
                needAttendDateThreeOn = AtsDateUtils.getPreDay(attDate);
            } else if (fpredatetypethree == 1) {
                needAttendDateThreeOn = attDate;
            } else if (fpredatetypethree == 2) {
                needAttendDateThreeOn = nextAttendDateStr;
            }
            String needAttendDateThreeOff = attDate;
            if (fnextdatetypethree == 0) {
                needAttendDateThreeOff = AtsDateUtils.getPreDay(attDate);
            } else if (fnextdatetypethree == 1) {
                needAttendDateThreeOff = attDate;
            } else if (fnextdatetypethree == 2) {
                needAttendDateThreeOff = nextAttendDateStr;
            }
            this.firstOnworkTimeNoBase = needAttendDateOneOn + this.split + this.firstOnTime;
            this.firstOffworkTimeNoBase = needAttendDateOneOff + this.split + this.firstOffTime;
            this.secondOnworkTimeNoBase = needAttendDateTwoOn + this.split + this.secondOnTime;
            this.secondOffworkTimeNoBase = needAttendDateTwoOff + this.split + this.secondOffTime;
            this.thirdOnTimeNoBase = needAttendDateThreeOn + this.split + this.thirdOnTime;
            this.thirdOffTimeNoBase = needAttendDateThreeOff + this.split + this.thirdOffTime;
            needShiftTimeOneOff = needAttendDateOneOff;
            needShiftTimeTwoOn = needAttendDateTwoOn;
            needShiftTimeTwoOff = needAttendDateTwoOff;
            needShiftTimeThreeOn = needAttendDateThreeOn;
        }
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegFirAssignType() != null) {
                this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
            }
            if (cardRuleInfo.getSegFirAssignSegment() != null) {
                this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
            }
            if (cardRuleInfo.getSegSecAssignType() != null) {
                this.segTwoAssignType = cardRuleInfo.getSegSecAssignType().getValue();
            }
            if (cardRuleInfo.getSegSecAssignSegment() != null) {
                this.segTwoAssignValue = cardRuleInfo.getSegSecAssignSegment().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> getCardList = new ArrayList<CardRuleResultInfo>();
        int oneoffIsPunchCard = 1;
        int oneoffnextTimeDayType = 1;
        int twoonIsPunchCard = 1;
        int twoonpreTimeDayType = 1;
        int twooffIsPunchCard = 1;
        int twooffnextTimeDayType = 1;
        int threeonIsPunchCard = 1;
        int threeonpreTimeDayType = 1;
        String preTime = "";
        String nextTime = "";
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 1) {
                    oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                    oneoffnextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 2) {
                    twoonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                    twooffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                    twoonpreTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
                    twooffnextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 3) continue;
                threeonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                threeonpreTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
            }
        }
        String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
        String shiftTime_Twoon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
        String shiftTime_Twooff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
        String shiftTime_Threeon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
        shiftTime_Oneoff = needShiftTimeOneOff + this.split + shiftTime_Oneoff;
        shiftTime_Twoon = needShiftTimeTwoOn + this.split + shiftTime_Twoon;
        shiftTime_Twooff = needShiftTimeTwoOff + this.split + shiftTime_Twooff;
        shiftTime_Threeon = needShiftTimeThreeOn + this.split + shiftTime_Threeon;
        ArrayList segIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Date resDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(this.firstOffworkTimeNoBase);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(this.secondOnworkTimeNoBase);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            segIntervalList.add(list.get(i));
        }
        List segIntervalEffectiveList = this.getEffectivePunchData(segIntervalList);
        if (segIntervalEffectiveList.size() >= 2) {
            info = new CardRuleResultInfo();
            mixDate2 = this.getMinData(segIntervalEffectiveList);
            String maxDate = this.getMaxData(segIntervalEffectiveList);
            info.setOneOffWorkTime(mixDate2);
            info.setTwoOnWorkTime(maxDate);
            getCardList.add(info);
        }
        if (segIntervalEffectiveList.size() == 1) {
            if (this.segOneAssignType == 1) {
                if (this.segOneAssignValue == 1) {
                    info = new CardRuleResultInfo();
                    mixDate2 = (String)segIntervalEffectiveList.get(0);
                    info.setOneOffWorkTime(mixDate2);
                    getCardList.add(info);
                } else if (this.segOneAssignValue == 2) {
                    info = new CardRuleResultInfo();
                    mixDate2 = (String)segIntervalEffectiveList.get(0);
                    info.setTwoOnWorkTime(mixDate2);
                    getCardList.add(info);
                }
            }
            if (this.segOneAssignType == 2) {
                CardRuleResultInfo info2;
                String interDatasString = (String)segIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearlyNoBase(this.firstOffworkTimeNoBase, this.secondOnworkTimeNoBase, interDatasString);
                if (res == 1) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 2) {
                    info2 = new CardRuleResultInfo();
                    info2.setTwoOnWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 3) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                }
            }
        }
        if (segIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setTwoOnWorkTime(shiftTime_Twoon);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                info.setTwoOnWorkTime(shiftTime_Twoon);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        ArrayList segSecondIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Date resDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            Date shiftSecondOffDate = AtsDateUtils.stringToLongDate(this.secondOffworkTimeNoBase);
            Date shiftThirdOnDate = AtsDateUtils.stringToLongDate(this.thirdOnTimeNoBase);
            if (resDate.getTime() < shiftSecondOffDate.getTime() || resDate.getTime() > shiftThirdOnDate.getTime()) continue;
            segSecondIntervalList.add(list.get(i));
        }
        List segSecondIntervalEffectiveList = this.getEffectivePunchData(segSecondIntervalList);
        if (this.sqlOutOn) {
            this.logger.info("cross_seg_3_begin_second\uff1a" + this.secondOffworkTimeNoBase + " endTime:" + this.thirdOnTimeNoBase);
            this.logger.info("cross_seg_3_second_effective_collection:" + segSecondIntervalEffectiveList.size());
            this.logger.info(" -------------------------------- ");
            for (int i = 0; i < segSecondIntervalEffectiveList.size(); ++i) {
                this.logger.info("cross_seg_3_second_effective_collection_is\uff1a" + segSecondIntervalEffectiveList.get(i));
            }
        }
        if (segSecondIntervalEffectiveList.size() >= 2) {
            CardRuleResultInfo info3 = new CardRuleResultInfo();
            mixDate = this.getMinData(segSecondIntervalEffectiveList);
            String maxDate = this.getMaxData(segSecondIntervalEffectiveList);
            info3.setTwoOffWorkTime(mixDate);
            info3.setThreeOnWorkTime(maxDate);
            getCardList.add(info3);
        }
        if (segSecondIntervalEffectiveList.size() == 1) {
            if (this.segTwoAssignType == 1) {
                if (this.segTwoAssignValue == 3) {
                    CardRuleResultInfo info4 = new CardRuleResultInfo();
                    mixDate = (String)segSecondIntervalEffectiveList.get(0);
                    info4.setTwoOffWorkTime(mixDate);
                    getCardList.add(info4);
                } else if (this.segTwoAssignValue == 4) {
                    CardRuleResultInfo info5 = new CardRuleResultInfo();
                    mixDate = (String)segSecondIntervalEffectiveList.get(0);
                    info5.setThreeOnWorkTime(mixDate);
                    getCardList.add(info5);
                }
            }
            if (this.segTwoAssignType == 2) {
                CardRuleResultInfo info6;
                String interDatasString = (String)segSecondIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearly(this.secondOffworkTime, this.thirdOnworkTime, interDatasString);
                if (res == 1) {
                    info6 = new CardRuleResultInfo();
                    info6.setTwoOffWorkTime(interDatasString);
                    getCardList.add(info6);
                } else if (res == 2) {
                    info6 = new CardRuleResultInfo();
                    info6.setThreeOnWorkTime(interDatasString);
                    getCardList.add(info6);
                } else if (res == 3) {
                    info6 = new CardRuleResultInfo();
                    info6.setTwoOffWorkTime(interDatasString);
                    getCardList.add(info6);
                }
            }
        }
        if (segSecondIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 1) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setTwoOffWorkTime(shiftTime_Twooff);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1 || ((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 0) {
                    CardRuleResultInfo info7 = new CardRuleResultInfo();
                    info7.setTwoOffWorkTime(shiftTime_Twooff);
                    info7.setThreeSegmentTag(2);
                    getCardList.add(info7);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setTwoOffWorkTime(shiftTime_Twooff);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        if (twooffIsPunchCard == 1 && threeonIsPunchCard == 0) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setThreeOnWorkTime(shiftTime_Threeon);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1 || ((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 0) {
                    CardRuleResultInfo info8 = new CardRuleResultInfo();
                    info8.setThreeOnWorkTime(shiftTime_Threeon);
                    info8.setThreeSegmentTag(2);
                    getCardList.add(info8);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setThreeOnWorkTime(shiftTime_Threeon);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setThreeOnWorkTime(shiftTime_Threeon);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 0) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setTwoOffWorkTime(shiftTime_Twooff);
                ((CardRuleResultInfo)getCardList.get(1)).setThreeOnWorkTime(shiftTime_Threeon);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1 || ((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 0) {
                    CardRuleResultInfo info9 = new CardRuleResultInfo();
                    info9.setTwoOffWorkTime(shiftTime_Twooff);
                    info9.setThreeOnWorkTime(shiftTime_Threeon);
                    info9.setThreeSegmentTag(2);
                    getCardList.add(info9);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
                    ((CardRuleResultInfo)getCardList.get(0)).setThreeOnWorkTime(shiftTime_Threeon);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setTwoOffWorkTime(shiftTime_Twooff);
                    pojoUse.setThreeOnWorkTime(shiftTime_Threeon);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        return getCardList;
    }

    public List<CardRuleResultInfo> getThreeHeadCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int predatetypeone = Integer.parseInt(dateTypeMap.get("predatetypeone"));
        int nextdatetypeone = Integer.parseInt(dateTypeMap.get("nextdatetypeone"));
        int predatetypetwo = Integer.parseInt(dateTypeMap.get("predatetypetwo"));
        int nextdatetypetwo = Integer.parseInt(dateTypeMap.get("nextdatetypetwo"));
        int predatetypethree = Integer.parseInt(dateTypeMap.get("predatetypethree"));
        int nextdatetypethree = Integer.parseInt(dateTypeMap.get("nextdatetypethree"));
        Map<String, String> map = null;
        map = predatetypethree == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || predatetypetwo == 0 && (nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypetwo == 0 && (predatetypethree == 1 || nextdatetypethree == 1) || predatetypethree == 0 && nextdatetypethree == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttime, endtime) : this.getStartOrEndDate(attendanceDate, starttime, endtime, oneOnTime, startBigDecimalOne, endBigDecimalOne);
        for (int i = 0; i < list.size(); ++i) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            if (map == null) continue;
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(list.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), oneOnTime);
        Map<String, String> mapCu = null;
        mapCu = predatetypethree == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || predatetypetwo == 0 && (nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypetwo == 0 && (predatetypethree == 1 || nextdatetypethree == 1) || predatetypethree == 0 && nextdatetypethree == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime")) : this.getStartOrEndDate(attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), oneOnTime, startBigDecimalOne, endBigDecimalOne);
        mapCu.get("currentAttBeginDate");
        mapCu.get("nextAttEndDate");
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)headEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("currentAttBeginDate"));
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardList.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardList.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            Map<String, String> mapTwo = null;
            mapTwo = predatetypethree == 0 || predatetypeone == 0 && (nextdatetypeone == 1 || predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypeone == 0 && (predatetypetwo == 1 || nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || predatetypetwo == 0 && (nextdatetypetwo == 1 || predatetypethree == 1 || nextdatetypethree == 1) || nextdatetypetwo == 0 && (predatetypethree == 1 || nextdatetypethree == 1) || predatetypethree == 0 && nextdatetypethree == 1 ? this.getStartOrEndDateWithDateType(dateTypeMap, attendanceDate, starttimeT, endtimeT) : this.getStartOrEndDate(attendanceDate, starttimeT, endtimeT, oneOnTime, startBigDecimalTwo, endBigDecimalTwo);
            for (int i = 0; i < list.size(); ++i) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate(mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate(mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(list.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate2 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate2);
                    headCardList.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardList.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        int onepreTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                onepreTimeDayType = shiftInfo.getItems().get(i).getPreTimeDayType().getValue();
            }
        }
        if (oneonIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
            String finalOneOn = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (onepreTimeDayType == 1) {
                finalOneOn = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            } else if (onepreTimeDayType == 0) {
                finalOneOn = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Oneon = finalOneOn + this.split + shiftTime_Oneon;
            if (headCardList.size() > 0) {
                ((CardRuleResultInfo)headCardList.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                headCardList.add(infoinner);
            }
        }
        return headCardList;
    }

    public List<CardRuleResultInfo> getThreeSegmentTailCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        if (shiftInfo != null) {
            this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal threeOffTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.thirdOffTime));
        Map<Object, Object> map = new HashMap();
        Map<String, Object> mapT = this.getSomeSectionTimeByHours(ctx, startBigDecimalOneTail, endBigDecimalOneTail, threeOffTime);
        String starttime = (String)mapT.get("startTime");
        String endtime = (String)mapT.get("endTime");
        Map<String, String> dateTypeMap = this.getShiftInfoDayType(shiftInfo);
        int nextdatetypethree = Integer.parseInt(dateTypeMap.get("nextdatetypethree"));
        if (nextdatetypethree == 1) {
            if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, threeOffTime, endBigDecimalOneTail, 1);
            } else if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                map = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttime, endtime, threeOffTime, endBigDecimalOneTail, 0);
            }
        }
        if (nextdatetypethree == 2) {
            if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                map = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttime, endtime, threeOffTime);
            } else {
                BigDecimal diffValue = threeOffTime.subtract(startBigDecimalOneTail).abs();
                map = this.getStartOrEndDateDayNotFixed(attendanceDate, starttime, endtime, threeOffTime, diffValue);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
            if (map == null) continue;
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("currentAttBeginDate"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("nextAttEndDate"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            tailList.add(list.get(i));
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        Map<String, Object> mapCurr = this.getSomeSectionTimeByHours(ctx, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), threeOffTime);
        Date nextCrossDate = AtsDateUtils.getNextDay(attendanceDate);
        Map<String, String> mapCu = null;
        if (nextdatetypethree == 1) {
            if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), threeOffTime, BigDecimal.valueOf(0L), 1);
            } else if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                mapCu = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), threeOffTime, BigDecimal.valueOf(0L), 0);
            }
        } else if (nextdatetypethree == 2) {
            mapCu = threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0 ? this.getStartOrEndDate(nextCrossDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), threeOffTime, startBigDecimalOneTail, endBigDecimalOneTail) : this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, (String)mapCurr.get("startTime"), (String)mapCurr.get("endTime"), threeOffTime, BigDecimal.valueOf(0L), 1);
        }
        if (tailEffectiveList.size() > 0) {
            ArrayList overShiftList = new ArrayList();
            String mixDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1 && !AtsCollectionUtile.isEmpty(mapCu)) {
                for (int i = 0; i < tailEffectiveList.size(); ++i) {
                    Date compareValue = AtsDateUtils.stringToLongDate((String)tailEffectiveList.get(i));
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(mapCu.get("nextAttEndDate"));
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setThreeOffWorkTimeEarliest(mixDate);
            info.setThreeOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                String mixDate = this.getMinData(tailEffectiveList);
                info.setThreeOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setThreeOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Map<Object, Object> mapTwo = new HashMap();
            Map<String, Object> someSectionMap = this.getSomeSectionTimeByHours(ctx, startBigDecimalTwo, endBigDecimalTwo, threeOffTime);
            String starttimeT = (String)someSectionMap.get("startTime");
            String endtimeT = (String)someSectionMap.get("endTime");
            if (nextdatetypethree == 1) {
                if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, threeOffTime, endBigDecimalTwo, 1);
                } else if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() < 0.0) {
                    mapTwo = this.getStartOrEndDateWithDateTypeTailTwo(dateTypeMap, attendanceDate, starttimeT, endtimeT, threeOffTime, endBigDecimalTwo, 0);
                }
            }
            if (nextdatetypethree == 2) {
                if (threeOffTime.subtract(startBigDecimalOneTail).doubleValue() >= 0.0) {
                    mapTwo = this.getStartOrEndDateSecondDayFixed(attendanceDate, starttimeT, endtimeT, threeOffTime);
                } else {
                    BigDecimal diffValue = threeOffTime.subtract(startBigDecimalOneTail).abs();
                    mapTwo = this.getStartOrEndDateDayNotFixed(attendanceDate, starttimeT, endtimeT, threeOffTime, diffValue);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                Date compareDate = AtsDateUtils.stringToLongDate((String)list.get(i));
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("currentAttBeginDate"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("nextAttEndDate"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailTwoList.add(list.get(i));
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate = this.getMinData(tailTwoEffectiveList);
                    info.setThreeOffWorkTime(mixDate);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setThreeOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int threeoffIsPunchCard = 1;
        int threenextTimeDayType = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 3) continue;
                threeoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                threenextTimeDayType = shiftInfo.getItems().get(i).getNextTimeDayType().getValue();
            }
        }
        if (threeoffIsPunchCard == 0) {
            String nextShiftTimeStr;
            String shiftTime_Threeoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
            String finalThreeOff = nextShiftTimeStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(AtsDateUtils.getNextDay(attendanceDate)));
            if (threenextTimeDayType == 1) {
                finalThreeOff = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(attendanceDate));
            } else if (threenextTimeDayType == 0) {
                finalThreeOff = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate));
            }
            shiftTime_Threeoff = finalThreeOff + this.split + shiftTime_Threeoff;
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setThreeOffWorkTime(shiftTime_Threeoff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setThreeOffWorkTime(shiftTime_Threeoff);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public Map<String, Object> getSomeSectionTimeByHoursWithBaseDate(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour, String baseDate) {
        HashMap<String, Object> withBaseDateMap = new HashMap<String, Object>();
        Map<String, Object> noBaseDateMap = this.getSomeSectionTimeByHours(ctx, startHour, endHour, shiftHour);
        String srart = baseDate + this.split + (String)noBaseDateMap.get("startTime");
        String end = baseDate + this.split + (String)noBaseDateMap.get("endTime");
        withBaseDateMap.put("startTime", srart);
        withBaseDateMap.put("endTime", end);
        return withBaseDateMap;
    }

    public Map<String, Object> getSomeSectionTimeByHours(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour) {
        Map mapTemp;
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (startHour.floatValue() >= 0.0f && endHour.floatValue() >= 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() >= 0.0f && endHour.floatValue() < 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() < 0.0f && endHour.floatValue() >= 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() < 0.0f && endHour.floatValue() < 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        return resMap;
    }

    public Map getStartTimeEndTime(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour) {
        HashMap<String, String> res_map = new HashMap<String, String>();
        BigDecimal start_value = shiftHour.subtract(startHour);
        start_value = this.decimalPlacesSystem.precisionConvert(ctx, start_value, RoundingMode.HALF_UP);
        BigDecimal end_value = shiftHour.add(endHour);
        end_value = this.decimalPlacesSystem.precisionConvert(ctx, end_value, RoundingMode.HALF_UP);
        String start_Time = AtsDateUtils.getTimeByHourDigital(start_value.doubleValue());
        String end_Time = AtsDateUtils.getTimeByHourDigital(end_value.doubleValue());
        res_map.put("start_Time", start_Time);
        res_map.put("end_Time", end_Time);
        return res_map;
    }

    public int getIntervalTimeWichNearly(String offTime, String onTime, String intervalTime) {
        long x2;
        int returnvalue = 0;
        Date offDate = AtsDateUtils.stringToLongDate(offTime);
        Date onDate = AtsDateUtils.stringToLongDate(onTime);
        String inter_suffix = AtsDateUtils.getTimeFromLongString(intervalTime);
        String interString = this.baseDate + this.split + inter_suffix;
        Date interDate = AtsDateUtils.stringToLongDate(interString);
        long x1 = interDate.getTime() - offDate.getTime();
        if (x1 < (x2 = onDate.getTime() - interDate.getTime())) {
            returnvalue = 1;
        } else if (x1 > x2) {
            returnvalue = 2;
        } else if (x1 == x2) {
            returnvalue = 3;
        }
        return returnvalue;
    }

    public int getIntervalTimeWichNearlyNoBase(String offTime, String onTime, String intervalTime) {
        long x2;
        int returnvalue = 0;
        Date offDate = AtsDateUtils.stringToLongDate(offTime);
        Date onDate = AtsDateUtils.stringToLongDate(onTime);
        Date interDate = AtsDateUtils.stringToLongDate(intervalTime);
        long x1 = interDate.getTime() - offDate.getTime();
        if (x1 < (x2 = onDate.getTime() - interDate.getTime())) {
            returnvalue = 1;
        } else if (x1 > x2) {
            returnvalue = 2;
        } else if (x1 == x2) {
            returnvalue = 3;
        }
        return returnvalue;
    }

    public String getMinData(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToLongDate((String)list.get(0)).getTime();
            Object minObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToLongDate((String)list.get(i)).getTime();
                if (list_value >= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                minObject = list.get(i);
                list_value = temp;
            }
            return (String)minObject;
        }
        return null;
    }

    public String getMaxData(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToLongDate((String)list.get(0)).getTime();
            Object maxObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToLongDate((String)list.get(i)).getTime();
                if (list_value <= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                maxObject = list.get(i);
                list_value = temp;
            }
            return (String)maxObject;
        }
        return null;
    }

    public List getEffectivePunchData(List segIntervalList) {
        ArrayList<String> resList = new ArrayList<String>();
        if (segIntervalList.size() > 0) {
            String minString = this.getMinData(segIntervalList);
            Date min_Date = AtsDateUtils.stringToLongDate(minString);
            resList.add(minString);
            for (int i = 0; i < segIntervalList.size(); ++i) {
                Date compare_Date = AtsDateUtils.stringToLongDate((String)segIntervalList.get(i));
                this.timeIntervalMillisecond = new BigDecimal(this.timeInterval).longValue() * 60L * 1000L;
                if (compare_Date.getTime() - min_Date.getTime() <= this.timeIntervalMillisecond) continue;
                resList.add((String)segIntervalList.get(i));
            }
        }
        return resList;
    }

    public List<CardRuleResultInfo> getPunchCardDataByCardRuleCrossShift(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, Date attendanceDate, Map<String, String> crossMap, Map<String, String> paraMap) {
        List<CardRuleResultInfo> resHeadList;
        int startSegmentShift = 3;
        if (cardRuleInfo != null) {
            startSegmentShift = cardRuleInfo.getStartSegmentNum().getValue();
        }
        CardRuleServerCrossShift server = new CardRuleServerCrossShift();
        ArrayList<CardRuleResultInfo> resList = new ArrayList<CardRuleResultInfo>();
        if (startSegmentShift == 1) {
            List<CardRuleResultInfo> resHeadList2 = server.getOneHeadCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            List<CardRuleResultInfo> resTailList = server.getOneTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resHeadList2.size() > 0) {
                info.setOneOnWorkTime(resHeadList2.get(0).getOneOnWorkTime());
                info.setOneOnWorkTimeEarliest(resHeadList2.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList2.get(0).getOneOnWorkTimeLatest());
            }
            if (resTailList.size() > 0) {
                info.setOneOffWorkTime(resTailList.get(0).getOneOffWorkTime());
                info.setOneOffWorkTimeEarliest(resTailList.get(0).getOneOffWorkTimeEarliest());
                info.setOneOffWorkTimeLatest(resTailList.get(0).getOneOffWorkTimeLatest());
            }
            resList.add(info);
        }
        if (startSegmentShift == 2) {
            int compareValue;
            List<CardRuleResultInfo> resIntereList = server.getTwoPunchCardInfo(shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            resHeadList = server.getTwoHeadCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            List<CardRuleResultInfo> resTailList = server.getTwoTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resIntereList.size() > 0) {
                info.setOneOffWorkTime(resIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resIntereList.get(0).getTwoOnWorkTime());
            }
            if (resHeadList.size() > 0) {
                String oneOnTime_One = resHeadList.get(0).getOneOnWorkTime();
                compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(oneOnTime_One, info);
                }
                if (compareValue == 1) {
                    info.setOneOnWorkTime(resHeadList.get(0).getOneOnWorkTime());
                }
                info.setOneOnWorkTimeEarliest(resHeadList.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList.get(0).getOneOnWorkTimeLatest());
            }
            if (resTailList.size() > 0) {
                String twoOffTime = resTailList.get(0).getTwoOffWorkTime();
                compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(twoOffTime, info);
                }
                if (compareValue == 1) {
                    info.setTwoOffWorkTime(resTailList.get(0).getTwoOffWorkTime());
                }
                info.setTwoOffWorkTimeEarliest(resTailList.get(0).getTwoOffWorkTimeEarliest());
                info.setTwoOffWorkTimeLatest(resTailList.get(0).getTwoOffWorkTimeLatest());
            }
            resList.add(info);
            if (resList.size() > 0) {
                if (shiftInfo != null) {
                    this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
                    this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
                    this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
                    this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
                    String attDate = AtsDateUtils.dateLongToString(attendanceDate);
                    attDate = AtsDateUtils.getDateFromLongString(attDate);
                    Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
                    String nextAttendDateStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
                    int fpredatetypeone = 1;
                    int fnextdatetypeone = 1;
                    int fpredatetypetwo = 1;
                    int fnextdatetypetwo = 1;
                    int fpredatetypethree = 1;
                    int fnextdatetypethree = 1;
                    AtsShiftItemCollection coll = shiftInfo.getItems();
                    for (int i = 0; i < coll.size(); ++i) {
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 1) {
                            fpredatetypeone = coll.get(i).getPreTimeDayType().getValue();
                            fnextdatetypeone = coll.get(i).getNextTimeDayType().getValue();
                        }
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 2) {
                            fpredatetypeone = coll.get(0).getPreTimeDayType().getValue();
                            fnextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
                            fpredatetypetwo = coll.get(1).getPreTimeDayType().getValue();
                            fnextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
                        }
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) != 3) continue;
                        fpredatetypeone = coll.get(0).getPreTimeDayType().getValue();
                        fnextdatetypeone = coll.get(0).getNextTimeDayType().getValue();
                        fpredatetypetwo = coll.get(1).getPreTimeDayType().getValue();
                        fnextdatetypetwo = coll.get(1).getNextTimeDayType().getValue();
                        fpredatetypethree = coll.get(2).getPreTimeDayType().getValue();
                        fnextdatetypethree = coll.get(2).getNextTimeDayType().getValue();
                    }
                    String needAttendDateOneOn = attDate;
                    if (fpredatetypeone == 0) {
                        needAttendDateOneOn = AtsDateUtils.getPreDay(attDate);
                    } else if (fpredatetypeone == 1) {
                        needAttendDateOneOn = attDate;
                    } else if (fpredatetypeone == 2) {
                        needAttendDateOneOn = nextAttendDateStr;
                    }
                    String needAttendDateOneOff = attDate;
                    if (fnextdatetypeone == 0) {
                        needAttendDateOneOff = AtsDateUtils.getPreDay(attDate);
                    } else if (fnextdatetypeone == 1) {
                        needAttendDateOneOff = attDate;
                    } else if (fnextdatetypeone == 2) {
                        needAttendDateOneOff = nextAttendDateStr;
                    }
                    String needAttendDateTwoOn = attDate;
                    if (fpredatetypetwo == 0) {
                        needAttendDateTwoOn = AtsDateUtils.getPreDay(attDate);
                    } else if (fpredatetypetwo == 1) {
                        needAttendDateTwoOn = attDate;
                    } else if (fpredatetypetwo == 2) {
                        needAttendDateTwoOn = nextAttendDateStr;
                    }
                    String needAttendDateTwoOff = attDate;
                    if (fnextdatetypetwo == 0) {
                        needAttendDateTwoOff = AtsDateUtils.getPreDay(attDate);
                    } else if (fnextdatetypetwo == 1) {
                        needAttendDateTwoOff = attDate;
                    } else if (fnextdatetypetwo == 2) {
                        needAttendDateTwoOff = nextAttendDateStr;
                    }
                    this.firstOnworkTimeNoBase = needAttendDateOneOn + this.split + this.firstOnTime;
                    this.firstOffworkTimeNoBase = needAttendDateOneOff + this.split + this.firstOffTime;
                    this.secondOnworkTimeNoBase = needAttendDateTwoOn + this.split + this.secondOnTime;
                    this.secondOffworkTimeNoBase = needAttendDateTwoOff + this.split + this.secondOffTime;
                }
                if (cardRuleInfo != null) {
                    if (cardRuleInfo.getTimeInterval() != null) {
                        this.timeInterval = cardRuleInfo.getTimeInterval().toString();
                    }
                    if (cardRuleInfo.getSegFirAssignType() != null) {
                        this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegFirAssignSegment() != null) {
                        this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime())) {
                    int compareValue2;
                    String maxDate = this.getTwoShiftEffectivePunchCardMaxDataWithNoBase(list, this.firstOnworkTimeNoBase, this.firstOffworkTimeNoBase);
                    if (this.sqlOutOn) {
                        String format = MessageFormat.format("cr_seg_2_int_1_0_eff_fetch_1_2_max\uff1a{0}", maxDate);
                        this.logger.info(format);
                    }
                    if ((compareValue2 = this.resListIsExistCurrentDate(maxDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(maxDate);
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    int compareValue3;
                    String minDate = this.getTwoShiftEffectivePunchCardMinDataWithNoBase(list, this.secondOnworkTimeNoBase, this.secondOffworkTimeNoBase);
                    if (this.sqlOutOn) {
                        String format = MessageFormat.format("cr_seg_2_int_1_0_eff_fetch_3_4_max\uff1a\uff1a{0}", minDate);
                        this.logger.info(format);
                    }
                    if ((compareValue3 = this.resListIsExistCurrentDate(minDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(minDate);
                    }
                }
            }
            if (resList != null && resList.size() > 0) {
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime());
                    ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(null);
                }
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime());
                    ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(null);
                }
            }
        }
        if (startSegmentShift == 3) {
            List<CardRuleResultInfo> resThreeSegmentIntereList = server.getThreeSegmentPunchCardDateInfo(shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            resHeadList = server.getThreeHeadCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            List<CardRuleResultInfo> resThreeSegmentTailList = server.getThreeSegmentTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, attendanceDate, crossMap, paraMap);
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resThreeSegmentIntereList.size() == 1) {
                info.setOneOffWorkTime(resThreeSegmentIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resThreeSegmentIntereList.get(0).getTwoOnWorkTime());
                info.setTwoOffWorkTime(resThreeSegmentIntereList.get(0).getTwoOffWorkTime());
                info.setThreeOnWorkTime(resThreeSegmentIntereList.get(0).getThreeOnWorkTime());
            }
            if (resThreeSegmentIntereList.size() == 0) {
                // empty if block
            }
            if (resThreeSegmentIntereList.size() == 2) {
                info.setOneOffWorkTime(resThreeSegmentIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resThreeSegmentIntereList.get(0).getTwoOnWorkTime());
                info.setTwoOffWorkTime(resThreeSegmentIntereList.get(1).getTwoOffWorkTime());
                info.setThreeOnWorkTime(resThreeSegmentIntereList.get(1).getThreeOnWorkTime());
            }
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (resHeadList.size() > 0) {
                String oneOnTime = resHeadList.get(0).getOneOnWorkTime();
                int compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(oneOnTime, info);
                }
                if (compareValue == 1) {
                    info.setOneOnWorkTime(resHeadList.get(0).getOneOnWorkTime());
                }
                info.setOneOnWorkTimeEarliest(resHeadList.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList.get(0).getOneOnWorkTimeLatest());
            }
            if (resThreeSegmentTailList.size() > 0) {
                String threeOffTime = resThreeSegmentTailList.get(0).getThreeOffWorkTime();
                int compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(threeOffTime, info);
                }
                if (compareValue == 1) {
                    info.setThreeOffWorkTime(resThreeSegmentTailList.get(0).getThreeOffWorkTime());
                }
                info.setThreeOffWorkTimeEarliest(resThreeSegmentTailList.get(0).getThreeOffWorkTimeEarliest());
                info.setThreeOffWorkTimeLatest(resThreeSegmentTailList.get(0).getThreeOffWorkTimeLatest());
            }
            resList.add(info);
            if (resList.size() > 0) {
                int compareValue;
                int preIsPunchCardone = 1;
                int nextIsPunchCardone = 1;
                int preIsPunchCardtwo = 1;
                int nextIsPunchCardtwo = 1;
                int preIsPunchCardthree = 1;
                int nextIsPunchCardthree = 1;
                if (shiftInfo != null) {
                    this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
                    this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
                    this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
                    this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
                    this.thirdOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
                    this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
                    String attDate = AtsDateUtils.dateLongToString(attendanceDate);
                    attDate = AtsDateUtils.getDateFromLongString(attDate);
                    Date nextAttendDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(attDate));
                    String nextAttendDateStr = AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(nextAttendDate));
                    int fpredatetypeone = 1;
                    int fnextdatetypeone = 1;
                    int fpredatetypetwo = 1;
                    int fnextdatetypetwo = 1;
                    int fpredatetypethree = 1;
                    int fnextdatetypethree = 1;
                    AtsShiftItemCollection coll = shiftInfo.getItems();
                    for (int i = 0; i < coll.size(); ++i) {
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 1) {
                            fpredatetypeone = coll.get(i).getPreTimeDayType().getValue();
                            fnextdatetypeone = coll.get(i).getNextTimeDayType().getValue();
                            preIsPunchCardone = Integer.parseInt(coll.get(i).getPreIsPunchCard().getValue());
                            nextIsPunchCardone = Integer.parseInt(coll.get(i).getNextIsPunchCard().getValue());
                        }
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) == 2) {
                            fpredatetypetwo = coll.get(i).getPreTimeDayType().getValue();
                            fnextdatetypetwo = coll.get(i).getNextTimeDayType().getValue();
                            preIsPunchCardtwo = Integer.parseInt(coll.get(i).getPreIsPunchCard().getValue());
                            nextIsPunchCardtwo = Integer.parseInt(coll.get(i).getNextIsPunchCard().getValue());
                        }
                        if (Integer.valueOf(coll.get(i).getSegment().getValue()) != 3) continue;
                        fpredatetypethree = coll.get(i).getPreTimeDayType().getValue();
                        fnextdatetypethree = coll.get(i).getNextTimeDayType().getValue();
                        preIsPunchCardthree = Integer.parseInt(coll.get(i).getPreIsPunchCard().getValue());
                        nextIsPunchCardthree = Integer.parseInt(coll.get(i).getNextIsPunchCard().getValue());
                    }
                    String needAttendDateOneOn = attDate;
                    if (fpredatetypeone == 0) {
                        needAttendDateOneOn = AtsDateUtils.getPreDay(attDate);
                    } else if (fpredatetypeone == 1) {
                        needAttendDateOneOn = attDate;
                    } else if (fpredatetypeone == 2) {
                        needAttendDateOneOn = nextAttendDateStr;
                    }
                    String needAttendDateOneOff = attDate;
                    if (fnextdatetypeone == 0) {
                        needAttendDateOneOff = AtsDateUtils.getPreDay(attDate);
                    } else if (fnextdatetypeone == 1) {
                        needAttendDateOneOff = attDate;
                    } else if (fnextdatetypeone == 2) {
                        needAttendDateOneOff = nextAttendDateStr;
                    }
                    String needAttendDateTwoOn = attDate;
                    if (fpredatetypetwo == 0) {
                        needAttendDateTwoOn = AtsDateUtils.getPreDay(attDate);
                    } else if (fpredatetypetwo == 1) {
                        needAttendDateTwoOn = attDate;
                    } else if (fpredatetypetwo == 2) {
                        needAttendDateTwoOn = nextAttendDateStr;
                    }
                    String needAttendDateTwoOff = attDate;
                    if (fnextdatetypetwo == 0) {
                        needAttendDateTwoOff = AtsDateUtils.getPreDay(attDate);
                    } else if (fnextdatetypetwo == 1) {
                        needAttendDateTwoOff = attDate;
                    } else if (fnextdatetypetwo == 2) {
                        needAttendDateTwoOff = nextAttendDateStr;
                    }
                    String needAttendDateThreeOn = attDate;
                    if (fpredatetypethree == 0) {
                        needAttendDateThreeOn = AtsDateUtils.getPreDay(attDate);
                    } else if (fpredatetypethree == 1) {
                        needAttendDateThreeOn = attDate;
                    } else if (fpredatetypethree == 2) {
                        needAttendDateThreeOn = nextAttendDateStr;
                    }
                    String needAttendDateThreeOff = attDate;
                    if (fnextdatetypethree == 0) {
                        needAttendDateThreeOff = AtsDateUtils.getPreDay(attDate);
                    } else if (fnextdatetypethree == 1) {
                        needAttendDateThreeOff = attDate;
                    } else if (fnextdatetypethree == 2) {
                        needAttendDateThreeOff = nextAttendDateStr;
                    }
                    this.firstOnworkTimeNoBase = needAttendDateOneOn + this.split + this.firstOnTime;
                    this.firstOffworkTimeNoBase = needAttendDateOneOff + this.split + this.firstOffTime;
                    this.secondOnworkTimeNoBase = needAttendDateTwoOn + this.split + this.secondOnTime;
                    this.secondOffworkTimeNoBase = needAttendDateTwoOff + this.split + this.secondOffTime;
                    this.thirdOnTimeNoBase = needAttendDateThreeOn + this.split + this.thirdOnTime;
                    this.thirdOffTimeNoBase = needAttendDateThreeOff + this.split + this.thirdOffTime;
                }
                if (cardRuleInfo != null) {
                    if (cardRuleInfo.getTimeInterval() != null) {
                        this.timeInterval = cardRuleInfo.getTimeInterval().toString();
                    }
                    if (cardRuleInfo.getSegFirAssignType() != null) {
                        this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegFirAssignSegment() != null) {
                        this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
                    }
                    if (cardRuleInfo.getSegSecAssignType() != null) {
                        this.segTwoAssignType = cardRuleInfo.getSegSecAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegSecAssignSegment() != null) {
                        this.segTwoAssignValue = cardRuleInfo.getSegSecAssignSegment().getValue();
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime())) {
                    if (nextIsPunchCardone == 0) {
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(this.firstOffworkTimeNoBase);
                    } else {
                        String maxDate = this.getTwoShiftEffectivePunchCardMaxDataWithNoBase(list, this.firstOnworkTimeNoBase, this.firstOffworkTimeNoBase);
                        if (this.sqlOutOn) {
                            String format = MessageFormat.format("cr_seg_3_int_1_0_eff_fetch_1_2_max\uff1a\uff1a{0}", maxDate);
                            this.logger.info(format);
                        }
                        if ((compareValue = this.resListIsExistCurrentDate(maxDate, resList)) != 2) {
                            ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(maxDate);
                        }
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    if (preIsPunchCardtwo == 0) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(this.secondOnworkTimeNoBase);
                    } else {
                        String minDate = this.getTwoShiftEffectivePunchCardMinDataWithNoBase(list, this.secondOnworkTimeNoBase, this.secondOffworkTimeNoBase);
                        if (this.sqlOutOn) {
                            String format = MessageFormat.format("cr_seg_3_int_1_0_eff_fetch_3_4_max\uff1a\uff1a\uff1a{0}", minDate);
                            this.logger.info(format);
                        }
                        if ((compareValue = this.resListIsExistCurrentDate(minDate, resList)) != 2) {
                            ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(minDate);
                        }
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    if (nextIsPunchCardtwo == 0) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOffWorkTime(this.secondOffworkTimeNoBase);
                    } else {
                        String maxDate_Two = this.getTwoShiftEffectivePunchCardMaxDataWithNoBase(list, this.secondOnworkTimeNoBase, this.secondOffworkTimeNoBase);
                        if (this.sqlOutOn) {
                            String format = MessageFormat.format("cr_seg_3_int_2_0_eff_fetch_3_4_max\uff1a{0}", maxDate_Two);
                            this.logger.info(format);
                        }
                        if ((compareValue = this.resListIsExistCurrentDate(maxDate_Two, resList)) != 2) {
                            ((CardRuleResultInfo)resList.get(0)).setTwoOffWorkTime(maxDate_Two);
                        }
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getThreeOnWorkTime())) {
                    if (preIsPunchCardthree == 0) {
                        ((CardRuleResultInfo)resList.get(0)).setThreeOnWorkTime(this.thirdOnTimeNoBase);
                    } else {
                        int compareValue4;
                        String minDate_Two = this.getTwoShiftEffectivePunchCardMinDataWithNoBase(list, this.thirdOnTimeNoBase, this.thirdOffTimeNoBase);
                        if (this.sqlOutOn) {
                            String format = MessageFormat.format("cr_seg_3_int_2_0_eff_fetch_5_6_max\uff1a{0}", minDate_Two);
                            this.logger.info(format);
                        }
                        if ((compareValue4 = this.resListIsExistCurrentDate(minDate_Two, resList)) != 2) {
                            ((CardRuleResultInfo)resList.get(0)).setThreeOnWorkTime(minDate_Two);
                        }
                    }
                }
            }
        }
        return resList;
    }

    public int resListIsExistCurrentDate(String date, List<CardRuleResultInfo> infoList) {
        int res = 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < infoList.size(); ++i) {
            list.add(infoList.get(i).getOneOnWorkTime());
            list.add(infoList.get(i).getOneOffWorkTime());
            list.add(infoList.get(i).getTwoOnWorkTime());
            list.add(infoList.get(i).getTwoOffWorkTime());
            list.add(infoList.get(i).getThreeOnWorkTime());
            list.add(infoList.get(i).getThreeOffWorkTime());
        }
        if (list.contains(date)) {
            res = 2;
        }
        return res;
    }

    public int resListIsExistCurrentDate(String date, CardRuleResultInfo info) {
        int res = 1;
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getOneOnWorkTime());
        list.add(info.getOneOffWorkTime());
        list.add(info.getTwoOnWorkTime());
        list.add(info.getTwoOffWorkTime());
        list.add(info.getThreeOnWorkTime());
        list.add(info.getThreeOffWorkTime());
        if (list.contains(date)) {
            res = 2;
        }
        return res;
    }

    public static void main(String[] args) throws ParseException {
    }
}

