/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEQFn;
import com.kingdee.eas.hr.ats.util.common.AtsFitFn;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapAndFitFn;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AtsCollectionUtile {
    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static boolean isEmpty(IObjectCollection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(JSONArray collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(JSONObject jsonObj) {
        return jsonObj == null || jsonObj.isEmpty();
    }

    public static <T> List<T> trim(List<T> collection) {
        return collection == null ? new ArrayList(0) : collection;
    }

    public static <K, V> Map<K, V> trim(Map<K, V> map) {
        return map == null ? new HashMap(0) : map;
    }

    public static <T> Set<T> trim(Set<T> set) {
        return set == null ? new HashSet(0) : set;
    }

    public static IObjectCollection trim(IObjectCollection collection) {
        return collection == null ? new CoreBaseCollection() : collection;
    }

    public static JSONArray trim(JSONArray collection) {
        return collection == null ? new JSONArray(0) : collection;
    }

    public static JSONObject trim(JSONObject jsonObj) {
        return jsonObj == null ? new JSONObject(0) : jsonObj;
    }

    public static boolean hasElement(JSONArray jsonArr) {
        return jsonArr != null && jsonArr.size() > 0;
    }

    public static boolean containsIgnoreCase(Collection collections, Object element) {
        return AtsCollectionUtile.contains(collections, element, new AtsEQFn<Object>(){

            @Override
            public boolean eq(Object t1, Object t) {
                return t1 == t || t1 != null && t1.equals(t) || String.valueOf(t1).equalsIgnoreCase(String.valueOf(t));
            }
        });
    }

    public static String conectProperty(JSONArray items, String property) {
        Set<String> set = AtsCollectionUtile.getStringPropertyCollection(items, property);
        return AtsCollectionUtile.join(set);
    }

    public static Set<String> getStringPropertyCollection(JSONArray items, String property) {
        return AtsCollectionUtile.getStringPropertyCollection(items, property, false);
    }

    public static Set<String> getStringPropertyCollection(JSONArray items, String property, boolean strictModel) {
        HashSet<String> propertySet = new HashSet<String>();
        for (Object item : items) {
            JSONObject itemTemp = (JSONObject)item;
            if (!itemTemp.containsKey((Object)property) || strictModel && (!strictModel || !StringUtils.isNotBlank((String)itemTemp.getString(property)))) continue;
            propertySet.add(itemTemp.getString(property));
        }
        return propertySet;
    }

    public static String join(Collection<?> collection) {
        return AtsCollectionUtile.join(collection, null);
    }

    public static String joinForSql(Collection<?> collection) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return "";
        }
        return "'" + AtsCollectionUtile.join(collection, "','") + "'";
    }

    public static String joinForSql(int repletCnt) {
        StringBuffer inSql = new StringBuffer("(");
        for (int i = 0; i < repletCnt; ++i) {
            inSql.append('?').append(',');
        }
        inSql.setCharAt(inSql.length() - 1, ')');
        return inSql.toString();
    }

    public static String joinForSqlWithBrackets(Collection<?> collection) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return "";
        }
        return "('" + AtsCollectionUtile.join(collection, "','") + "')";
    }

    public static String join(Collection<?> collection, String separator) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return "";
        }
        separator = separator == null ? "," : separator;
        StringBuffer strBuffer = new StringBuffer();
        for (Object o : collection) {
            strBuffer.append(o);
            strBuffer.append(separator);
        }
        return strBuffer.substring(0, strBuffer.length() - separator.length());
    }

    public static <T, R> String join(List<T> list, String separator, AtsMapFn<T, R> atsMapFn) {
        if (AtsCollectionUtile.isEmpty(list)) {
            return "";
        }
        separator = separator == null ? "," : separator;
        StringBuffer strBuffer = new StringBuffer();
        for (T t : list) {
            if (t == null || atsMapFn.map(t) == null) continue;
            strBuffer.append(atsMapFn.map(t));
            strBuffer.append(separator);
        }
        return strBuffer.substring(0, strBuffer.length() - separator.length());
    }

    public static String join(Collection<?> collection, String separator, String prefix, String suffix) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return "";
        }
        prefix = prefix == null ? "" : prefix;
        suffix = suffix == null ? "" : suffix;
        separator = separator == null ? "" : separator;
        StringBuffer strBuffer = new StringBuffer();
        for (Object o : collection) {
            strBuffer.append(prefix).append(o).append(suffix).append(separator);
        }
        return strBuffer.substring(0, strBuffer.length() - separator.length());
    }

    public static String buildBrString(Collection<?> msgs) {
        if (AtsCollectionUtile.isEmpty(msgs)) {
            return "";
        }
        int i = 0;
        LinkedHashSet msgSet = new LinkedHashSet(msgs);
        StringBuffer returnMsg = new StringBuffer();
        for (Object msg : msgSet) {
            ++i;
            if (msgSet.size() == 1) {
                return String.valueOf(msg);
            }
            returnMsg.append(i).append(") ").append(msg).append("</br>");
        }
        return returnMsg.substring(0, returnMsg.length() - "</br>".length());
    }

    public static <T> List<T> filter(Collection<T> collection, AtsFitFn<T> fitFn) {
        ArrayList<T> returnList = new ArrayList<T>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnList;
        }
        for (T o : collection) {
            if (!fitFn.fit(o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    public static CoreBaseCollection toCoreCollection(IObjectCollection collection) {
        CoreBaseCollection coll = new CoreBaseCollection();
        if (!AtsCollectionUtile.isEmpty(collection)) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                coll.add((CoreBaseInfo)it.next());
            }
        }
        return coll;
    }

    public static <T extends IObjectCollection> T toSpecificCollection(IObjectCollection collection, Class<T> t) {
        IObjectCollection coll = (IObjectCollection)AtsCommonUtile.getInstance(t);
        if (!AtsCollectionUtile.isEmpty(collection)) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                coll.addObject((IObjectValue)it.next());
            }
        }
        return (T)coll;
    }

    public static CoreBaseCollection sigleTon(IObjectValue iObjectValue) {
        CoreBaseCollection coll = new CoreBaseCollection();
        if (iObjectValue != null) {
            coll.add((CoreBaseInfo)iObjectValue);
        }
        return coll;
    }

    public static <T extends IObjectCollection> T sigleTon(IObjectValue iObjectValue, Class<T> IObjectCollectionClz) {
        return (T)AtsCollectionUtile.sigleTon(iObjectValue).cast(IObjectCollectionClz);
    }

    public static JSONObject sigleTon(String key, Object value) {
        JSONObject jsonObj = new JSONObject(1);
        jsonObj.put(key, value);
        return jsonObj;
    }

    public static JSONObject emptyJsonObj() {
        return new JSONObject(1);
    }

    public static <T> List<T> emptyAbsoluteList() {
        return Collections.emptyList();
    }

    public static <T> List<T> emptyList() {
        return new ArrayList(1);
    }

    public static <T> Set<T> emptyAbsoluteSet() {
        return Collections.emptySet();
    }

    public static <T> Set<T> emptySet() {
        return new HashSet(1);
    }

    public static <K, V> Map<K, V> emptyAbsoluteMap() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return new HashMap(1);
    }

    public static Map newMap(Object ... initParams) {
        int size;
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        int n = size = initParams == null ? 0 : initParams.length / 2;
        for (int i = 0; i < size; ++i) {
            res.put(initParams[2 * i], initParams[2 * i + 1]);
        }
        return res;
    }

    public static <T, R> List<R> map(Collection<T> collection, AtsMapFn<T, R> mapFn) {
        ArrayList<R> returnList = new ArrayList<R>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnList;
        }
        for (T o : collection) {
            returnList.add(mapFn.map(o));
        }
        return returnList;
    }

    public static <T, R> List<R> map(AbstractObjectCollection collection, AtsMapFn<T, R> mapFn) {
        ArrayList<R> returnList = new ArrayList<R>();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)collection)) {
            return returnList;
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            returnList.add(mapFn.map(it.next()));
        }
        return returnList;
    }

    public static <T, R> List<R> mapNotNull(AbstractObjectCollection collection, AtsMapFn<T, R> mapFn) {
        ArrayList<R> returnList = new ArrayList<R>();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)collection)) {
            return returnList;
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            R r = mapFn.map(it.next());
            if (r == null) continue;
            returnList.add(r);
        }
        return returnList;
    }

    public static <T, R> Map<R, T> list2Map(AbstractObjectCollection collection, AtsMapFn<T, R> mapFn) {
        HashMap returnMap = new HashMap();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)collection)) {
            return returnMap;
        }
        for (Object t : collection) {
            if (mapFn.map(t) == null) continue;
            returnMap.put(mapFn.map(t), t);
        }
        return returnMap;
    }

    public static <T, R> List<R> map(Collection<T> collection, AtsMapAndFitFn<T, R> mapAndFitFn) {
        ArrayList<R> returnList = new ArrayList<R>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnList;
        }
        for (T o : collection) {
            if (!mapAndFitFn.fit(o)) continue;
            returnList.add(mapAndFitFn.map(o));
        }
        return returnList;
    }

    public static <T> List<T> deleteNull(Collection<T> collection) {
        return AtsCollectionUtile.filter(collection, new AtsFitFn<T>(){

            @Override
            public boolean fit(T t) {
                return t != null;
            }
        });
    }

    public static <T> List<T> delRepeat(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> returnDate = new ArrayList<T>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnDate;
        }
        int compareResult = 0;
        Boolean addToList = true;
        for (T t : collection) {
            addToList = true;
            for (int i = 0; i < returnDate.size(); ++i) {
                compareResult = comparator.compare(returnDate.get(i), t);
                if (compareResult > 0) {
                    returnDate.set(i, t);
                    addToList = false;
                    continue;
                }
                if (compareResult != 0) continue;
                addToList = false;
            }
            if (!addToList.booleanValue()) continue;
            returnDate.add(t);
        }
        return returnDate;
    }

    public static <T> Set<T> delRepeatAndNull(Collection<T> collection) {
        HashSet<T> returnSet = new HashSet<T>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnSet;
        }
        for (T t : collection) {
            if (t == null) continue;
            returnSet.add(t);
        }
        return returnSet;
    }

    public static Set<String> delRepeatAndEmpty(Collection<String> collection) {
        HashSet<String> returnSet = new HashSet<String>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnSet;
        }
        for (String t : collection) {
            if (!StringUtils.isNotEmpty((String)t)) continue;
            returnSet.add(t);
        }
        return returnSet;
    }

    public static <T> List<String> deleteEmpty(Collection<String> collection) {
        return AtsCollectionUtile.filter(collection, new AtsFitFn<String>(){

            @Override
            public boolean fit(String t) {
                return StringUtils.isNotEmpty((String)t);
            }
        });
    }

    public static <R extends IObjectCollection, T extends IObjectValue> R toCoreCollection(List<T> list, Class<R> returnType) {
        IObjectCollection returnInst = null;
        try {
            returnInst = (IObjectCollection)returnType.newInstance();
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)"", (Throwable)e);
        }
        if (returnInst == null || list == null) {
            return (R)returnInst;
        }
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            returnInst.addObject((IObjectValue)it.next());
        }
        return (R)returnInst;
    }

    public static <T extends IObjectCollection, R extends IObjectValue> List<R> toList(T colls, Class<R> returnType) {
        ArrayList<IObjectValue> returnData = new ArrayList<IObjectValue>();
        if (colls == null) {
            return returnData;
        }
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            returnData.add((IObjectValue)it.next());
        }
        return returnData;
    }

    public static <K, V> void updateTargetToValMap(K key, V value, Map<K, V> valueMap) {
        if (!valueMap.containsKey(key)) {
            valueMap.put(key, value);
        }
    }

    public static <K, V> void updateTargetToValSet(K key, V value, Map<K, Set<V>> targetToValMap) {
        Set<V> values = targetToValMap.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            targetToValMap.put(key, values);
        }
        values.add(value);
    }

    public static <K, V, M> Map<K, V> assembleMap(Map<K, M> keyMap, Map<M, V> valueMap) {
        HashMap<K, V> returnMap = new HashMap<K, V>();
        for (K k : keyMap.keySet()) {
            returnMap.put(k, valueMap.get(keyMap.get(k)));
        }
        return returnMap;
    }

    public static <K, V> Map<K, V> trimValue(Map<K, V> map) {
        if (AtsCollectionUtile.isEmpty(map)) {
            return map;
        }
        for (Map.Entry<K, String> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(entry.getValue().toString().trim());
        }
        return map;
    }

    public static <T> List<List<T>> group(Collection<T> collection, int groupSize) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return new ArrayList<List<T>>(0);
        }
        if (groupSize < 1) {
            throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.GROUPSIZEERROR, new Object[]{groupSize})));
        }
        ArrayList<List<T>> returnList = new ArrayList<List<T>>(collection.size() / groupSize + 1);
        ArrayList<T> currentList = new ArrayList<T>();
        Iterator<T> it = collection.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index == groupSize) {
                returnList.add(currentList);
                currentList = new ArrayList();
                index = 0;
            }
            currentList.add(it.next());
            ++index;
        }
        returnList.add(currentList);
        return returnList;
    }

    public static <T, R> Map<R, List<T>> groupBy(Collection<T> collection, AtsMapFn<T, R> mapFn) {
        HashMap<R, ArrayList<T>> returnMap = new HashMap<R, ArrayList<T>>();
        if (AtsCollectionUtile.isEmpty(collection)) {
            return returnMap;
        }
        for (T o : collection) {
            R r = mapFn.map(o);
            if (r == null) continue;
            ArrayList<T> tList = (ArrayList<T>)returnMap.get(r);
            if (tList == null) {
                tList = new ArrayList<T>();
                returnMap.put(r, tList);
            }
            tList.add(o);
        }
        return returnMap;
    }

    public static <T> int indexOf(Collection<T> collection, Object t, AtsEQFn<T> eqFn) {
        int index = -1;
        if (!AtsCollectionUtile.isEmpty(collection)) {
            Iterator<T> it = collection.iterator();
            while (it.hasNext()) {
                ++index;
                if (!eqFn.eq(it.next(), t)) continue;
                return index;
            }
        }
        return -1;
    }

    public static <T> boolean contains(Collection<T> collection, Object t, AtsEQFn<T> eqFn) {
        return AtsCollectionUtile.indexOf(collection, t, eqFn) != -1;
    }

    public static <T> int indexOf(IObjectCollection collection, Object t, AtsEQFn<T> eqFn) {
        int index = -1;
        if (!AtsCollectionUtile.isEmpty(collection)) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                ++index;
                if (!eqFn.eq(it.next(), t)) continue;
                return index;
            }
        }
        return -1;
    }

    public static <T> boolean contains(IObjectCollection collection, Object t, AtsEQFn<T> eqFn) {
        return AtsCollectionUtile.indexOf(collection, t, eqFn) != -1;
    }

    public static List<List<Object>> group(IObjectCollection collection, int groupSize) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return new ArrayList<List<Object>>(0);
        }
        if (groupSize < 1) {
            throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.GROUPSIZEERROR, new Object[]{groupSize})));
        }
        ArrayList<List<Object>> returnList = new ArrayList<List<Object>>(collection.size() / groupSize + 1);
        ArrayList currentList = new ArrayList();
        Iterator it = collection.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index == groupSize) {
                returnList.add(currentList);
                currentList = new ArrayList();
                index = 0;
            }
            currentList.add(it.next());
            ++index;
        }
        returnList.add(currentList);
        return returnList;
    }

    public static <V extends CoreBaseInfo> Map<String, V> toMap(IObjectCollection collection, String key, Class<V> classObj) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return new HashMap();
        }
        if (StringUtils.isEmpty((String)key)) {
            key = "id";
        }
        HashMap<String, CoreBaseInfo> map = new HashMap<String, CoreBaseInfo>();
        for (CoreBaseInfo coreInfo : collection) {
            if (coreInfo == null || coreInfo.get(key) == null) continue;
            map.put(String.valueOf(coreInfo.get(key)), coreInfo);
        }
        return map;
    }

    public static <T> Map<T, Object> toMap(Iterator<T[]> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return AtsCollectionUtile.emptyMap();
        }
        HashMap returnMap = new HashMap();
        HashSet<T> lastData = null;
        while (iterator.hasNext()) {
            T[] arr = iterator.next();
            HashMap<T, Cloneable> previousMap = returnMap;
            for (int i = 0; i < arr.length; ++i) {
                HashMap tempMap;
                if (i == arr.length - 1 && lastData != null) {
                    lastData.add(arr[i]);
                    continue;
                }
                HashMap hashMap = tempMap = previousMap != null ? (HashMap)previousMap.get(arr[i]) : null;
                if (tempMap == null && previousMap != null) {
                    if (i == arr.length - 2) {
                        lastData = new HashSet<T>();
                        previousMap.put(arr[i], lastData);
                    } else {
                        tempMap = new HashMap();
                        previousMap.put(arr[i], tempMap);
                    }
                }
                previousMap = tempMap;
            }
        }
        return returnMap;
    }

    public static <V extends CoreBaseInfo> Map<String, V> toMap(Collection<V> collection, String key) {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return new HashMap();
        }
        if (StringUtils.isEmpty((String)key)) {
            key = "id";
        }
        HashMap<String, CoreBaseInfo> map = new HashMap<String, CoreBaseInfo>();
        for (CoreBaseInfo coreInfo : collection) {
            if (coreInfo == null || coreInfo.get(key) == null) continue;
            map.put(String.valueOf(coreInfo.get(key)), coreInfo);
        }
        return map;
    }

    public static List toList(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(Arrays.asList(objects));
    }

    public static List toList(String source, String separator) {
        if (StringUtils.isBlank((String)source)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(StringUtils.split((String)source, (String)separator)));
    }

    public static List toList(String source) {
        return AtsCollectionUtile.toList(source, ",");
    }

    public static Set toSet(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<Object>(Arrays.asList(objects));
    }

    public static Set toSet(String source, String separator) {
        if (StringUtils.isBlank((String)source)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)source, (String)separator)));
    }

    public static Set toSet(String source) {
        return AtsCollectionUtile.toSet(source, ",");
    }

    public static Pair<String, List<String>> inSqlMask(String inSql) {
        if (StringUtils.isBlank((String)inSql)) {
            return Pair.of(null, null);
        }
        String newSql = inSql.replaceAll("'", "").replaceAll("\"", "");
        List<String> valList = Arrays.asList(StringUtils.split((String)(newSql = StringUtils.strip((String)newSql, (String)",")), (String)","));
        if (!AtsCollectionUtile.isEmpty(valList)) {
            StringBuilder mask = new StringBuilder();
            for (String param : valList) {
                mask.append("?,");
            }
            return Pair.of((Object)StringUtils.strip((String)mask.toString(), (String)","), valList);
        }
        return Pair.of(null, null);
    }

    public static Object[] object2Arr(Object ... objects) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object object : objects) {
                if (object instanceof Collection) {
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        objectList.add(iterator.next());
                    }
                    continue;
                }
                objectList.add(object);
            }
        }
        return objectList.toArray();
    }

    public static <T> T getFirst(IObjectCollection iObjectCollection) {
        if (AtsCollectionUtile.isEmpty(iObjectCollection)) {
            return null;
        }
        return (T)iObjectCollection.getObject(0);
    }
}

