/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AtsEntityUtile {
    public static String getTableName(Context ctx, String entityName) {
        EntityObjectInfo entityObjectInfo = AtsEntityUtile.getEntityObjByEntityName(ctx, entityName);
        return AtsEntityUtile.getTableName(entityObjectInfo);
    }

    public static String getTableNameByBillId(Context ctx, String billId) throws BOSException {
        EntityObjectInfo entityObjectInfo = AtsEntityUtile.getEntityObj(ctx, billId);
        return AtsEntityUtile.getTableName(entityObjectInfo);
    }

    public static <V extends CoreBaseInfo> String getTableName(Context ctx, V object) throws BOSException {
        if (object == null) {
            return null;
        }
        EntityObjectInfo entityObjectInfo = AtsEntityUtile.getEntityObj(ctx, object);
        return AtsEntityUtile.getTableName(entityObjectInfo);
    }

    public static <V extends CoreBaseInfo> String getTableName(Context ctx, Class<V> classObj) throws BOSException {
        CoreBaseInfo v = (CoreBaseInfo)AtsCommonUtile.getInstance(classObj);
        EntityObjectInfo entityObjectInfo = AtsEntityUtile.getEntityObj(ctx, v);
        return AtsEntityUtile.getTableName(entityObjectInfo);
    }

    public static String getTableName(EntityObjectInfo entityObjectInfo) {
        if (entityObjectInfo == null || entityObjectInfo.getTable() == null) {
            return null;
        }
        return entityObjectInfo.getTable().getName();
    }

    public static <V extends CoreBaseInfo> PropertyCollection getNoLinkPropertity(Context ctx, Class<V> classObj) {
        PropertyCollection propertyCollection = AtsEntityUtile.getAllPropertity(AtsEntityUtile.getEntityObj(ctx, classObj));
        return AtsEntityUtile.removeProperty(propertyCollection, true);
    }

    public static PropertyCollection getNoLinkPropertity(Context ctx, CoreBaseInfo coreBaseInfo) {
        PropertyCollection propertyCollection = AtsEntityUtile.getAllPropertity(AtsEntityUtile.getEntityObj(ctx, coreBaseInfo));
        return AtsEntityUtile.removeProperty(propertyCollection, true);
    }

    public static PropertyCollection removeProperty(PropertyCollection propertyCollection, boolean removeLinkProperty) {
        if (propertyCollection == null) {
            return propertyCollection;
        }
        Iterator it = propertyCollection.iterator();
        while (it.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)it.next();
            if (!(propertyInfo instanceof LinkPropertyInfo) || !removeLinkProperty) continue;
            it.remove();
        }
        return propertyCollection;
    }

    public static <V extends CoreBaseInfo> PropertyCollection getAllPropertity(Context ctx, Class<V> classObj) {
        return AtsEntityUtile.getAllPropertity(AtsEntityUtile.getEntityObj(ctx, classObj));
    }

    public static PropertyCollection getAllPropertity(Context ctx, CoreBaseInfo coreBaseInfo) {
        return AtsEntityUtile.getAllPropertity(AtsEntityUtile.getEntityObj(ctx, coreBaseInfo));
    }

    public static PropertyCollection getAllPropertity(EntityObjectInfo entityObjectInfo) {
        return entityObjectInfo == null ? null : entityObjectInfo.getPropertiesRuntime();
    }

    public static EntityObjectInfo getEntityObj(Context ctx, String billId) {
        return AtsEntityUtile.getEntityObj(ctx, BOSUuid.read((String)billId).getType());
    }

    public static <V extends CoreBaseInfo> EntityObjectInfo getEntityObj(Context ctx, Class<V> classObj) {
        return AtsEntityUtile.getEntityObj(ctx, (CoreBaseInfo)AtsCommonUtile.getInstance(classObj));
    }

    public static <V extends CoreBaseInfo> EntityObjectInfo getEntityObj(Context ctx, V object) {
        return AtsEntityUtile.getEntityObj(ctx, object.getBOSType());
    }

    public static EntityObjectInfo getEntityObj(Context ctx, BOSObjectType bosType) {
        if (null == ctx) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
    }

    public static List<EntityObjectInfo> getEntitys(Context ctx) {
        EntityObjectCollection coll = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntityCollection();
        if (coll == null || coll.size() == 0) {
            return new ArrayList<EntityObjectInfo>(0);
        }
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>(coll.size());
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            list.add(coll.get(i));
        }
        return list;
    }

    public static EntityObjectInfo getEntityObjByEntityName(Context ctx, String entityName) {
        if (null == ctx) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static ICoreBase getBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        return AtsEntityUtile.getBizInterfaceByEntityName(ctx, AtsEntityUtile.getEntityObj(ctx, bosType).getFullName());
    }

    public static ICoreBase getBizInterfaceByEntityName(Context ctx, String entityName) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static ICoreBase getBizInterface(Context ctx, String billId) throws BOSException {
        EntityObjectInfo entity = AtsEntityUtile.getEntityObj(ctx, billId);
        try {
            return AtsEntityUtile.getBizInterfaceByEntityName(ctx, entity.getFullName());
        }
        catch (BOSException e) {
            throw new BOSException("get bizInterface failure,please try again!", (Throwable)e);
        }
    }

    public static <V extends CoreBaseInfo> ICoreBase getBizInterface(Context ctx, Class<V> classObj) throws BOSException {
        CoreBaseInfo v = (CoreBaseInfo)AtsCommonUtile.getInstance(classObj);
        return AtsEntityUtile.getBizInterface(ctx, v);
    }

    public static <V extends CoreBaseInfo> ICoreBase getBizInterface(Context ctx, V object) throws BOSException {
        try {
            return AtsEntityUtile.getBizInterface(ctx, object.getBOSType());
        }
        catch (BOSException e) {
            throw new BOSException("get bizInterface failure,please try again!", (Throwable)e);
        }
    }

    public static <V extends CoreBaseInfo> void save(Context ctx, V v) throws BOSException {
        if (v == null) {
            return;
        }
        AtsEntityUtile.save(ctx, AtsCollectionUtile.sigleTon(v));
    }

    public static <V extends IObjectCollection> void save(Context ctx, V collection) throws BOSException {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return;
        }
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, (CoreBaseInfo)collection.getObject(0));
        try {
            iCoreBase.save(AtsCollectionUtile.toCoreCollection(collection));
        }
        catch (Exception e) {
            throw new BOSException("save data failure,please try again!", (Throwable)e);
        }
    }

    public static <V extends CoreBaseInfo> void update(Context ctx, V v) throws BOSException {
        if (v == null) {
            return;
        }
        AtsEntityUtile.update(ctx, AtsCollectionUtile.sigleTon(v));
    }

    public static <V extends IObjectCollection> void update(Context ctx, V collection) throws BOSException {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return;
        }
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, (CoreBaseInfo)collection.getObject(0));
        try {
            iCoreBase.update(AtsCollectionUtile.toCoreCollection(collection));
        }
        catch (Exception e) {
            throw new BOSException("update data failure,please try again!", (Throwable)e);
        }
    }

    public static <V extends CoreBaseInfo> void addNew(Context ctx, V v) throws BOSException {
        if (v == null) {
            return;
        }
        AtsEntityUtile.addNew(ctx, AtsCollectionUtile.sigleTon(v));
    }

    public static <V extends IObjectCollection> void addNew(Context ctx, V collection) throws BOSException {
        if (AtsCollectionUtile.isEmpty(collection)) {
            return;
        }
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, (CoreBaseInfo)collection.getObject(0));
        try {
            iCoreBase.addnew(AtsCollectionUtile.toCoreCollection(collection));
        }
        catch (EASBizException e) {
            throw new BOSException("add data failure,please try again!", (Throwable)e);
        }
    }

    public static Map<String, String> getProperty(EntityObjectInfo entity) {
        if (entity == null) {
            return AtsCollectionUtile.emptyMap();
        }
        String localFlag = "_L" + Arrays.asList("", "en_US", "zh_CN", "zh_HK", "zh_TW").indexOf(Locale.getDefault().toString());
        PropertyCollection propertis = entity.getPropertiesRuntime();
        HashMap<String, String> returnData = new HashMap<String, String>(propertis.size());
        for (int i = 0; i < propertis.size(); ++i) {
            PropertyInfo propertyInfo = propertis.get(i);
            ColumnInfo colInfo = propertyInfo.getMappingField();
            if (colInfo == null && propertyInfo instanceof LinkPropertyInfo) {
                RelationshipInfo relationshipInfo = ((LinkPropertyInfo)propertyInfo).getRelationship();
                propertyInfo = relationshipInfo.isClient(entity) ? relationshipInfo.getSupplierProperty() : relationshipInfo.getClientProperty();
                returnData.put(propertis.get(i).getName(), "!#&@~@&#!" + propertyInfo.getName());
                continue;
            }
            if (colInfo == null) continue;
            if (colInfo.isMultilingual()) {
                returnData.put(propertis.get(i).getName(), colInfo.getName() + localFlag);
                continue;
            }
            returnData.put(propertis.get(i).getName(), colInfo.getName());
        }
        return new LinkedHashMap<String, String>(returnData);
    }

    public static CoreBaseInfo getData(Context ctx, String billId) throws BOSException {
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, billId);
        CoreBaseCollection coll = iCoreBase.getCollection("where id='" + billId + "'");
        return AtsCollectionUtile.isEmpty((IObjectCollection)coll) ? null : coll.get(0);
    }

    public static <V extends CoreBaseInfo> V getData(Context ctx, String billId, Class<V> v) throws BOSException {
        return (V)AtsEntityUtile.getData(ctx, billId);
    }

    public static <V extends CoreBaseInfo> V getData(Context ctx, Object sqlOrEvi, Class<V> v) throws BOSException {
        V coll;
        try {
            coll = AtsEntityUtile.getDatas(ctx, sqlOrEvi, AtsEntityUtile.getEntityObj(ctx, v).getObjectCollectionClazzRuntime());
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("get collection class failure,please try again!");
        }
        if (AtsCollectionUtile.isEmpty(coll)) {
            return null;
        }
        return (V)((CoreBaseInfo)coll.getObject(0));
    }

    public static <V extends IObjectCollection> V getDatas(Context ctx, Object sqlOrEvi, Class<V> v) throws BOSException {
        CoreBaseCollection coll;
        block6: {
            if (v == null) {
                throw new BOSException("get data failure,v is null,please try again!");
            }
            ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, AtsCommonUtile.getClass(v.getName().substring(0, v.getName().length() - "Collection".length()) + "Info", CoreBaseInfo.class));
            try {
                if (sqlOrEvi == null) {
                    coll = iCoreBase.getCollection();
                    break block6;
                }
                if (sqlOrEvi instanceof String) {
                    coll = iCoreBase.getCollection((String)sqlOrEvi);
                    break block6;
                }
                if (sqlOrEvi instanceof EntityViewInfo) {
                    coll = iCoreBase.getCollection((EntityViewInfo)sqlOrEvi);
                    break block6;
                }
                throw new BOSException("get data failure,please try again!");
            }
            catch (BOSException e) {
                throw new BOSException("get data failure,please try again!", (Throwable)e);
            }
        }
        return AtsCollectionUtile.toSpecificCollection((IObjectCollection)coll, v);
    }

    public static <V extends CoreBaseInfo> int getCount(Context ctx, EntityViewInfo evi, V v) throws BOSException {
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, v);
        try {
            return iCoreBase.getCount(evi);
        }
        catch (BOSException e) {
            throw new BOSException("get count failure,please try again!", (Throwable)e);
        }
    }

    public static <V extends CoreBaseInfo> boolean exist(Context ctx, Object selector, Class<V> v) throws BOSException {
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, v);
        try {
            if (selector instanceof String) {
                return iCoreBase.exists((String)selector);
            }
            if (selector instanceof FilterInfo) {
                return iCoreBase.exists((FilterInfo)selector);
            }
            if (selector instanceof IObjectPK) {
                return iCoreBase.exists((IObjectPK)selector);
            }
            throw new BOSException("query exist failure,please try again!");
        }
        catch (Exception e) {
            throw new BOSException("query exist failure,please try again!", (Throwable)e);
        }
    }

    public static EntityObjectInfo getFieldDeclareEntityObj(EntityObjectInfo entityObj, String field) {
        int size;
        String[] fieldArr = StringUtils.split((String)field, (char)'.');
        int n = size = fieldArr == null ? 0 : fieldArr.length - 1;
        for (int i = 0; i <= size; ++i) {
            if (entityObj == null) {
                return null;
            }
            PropertyInfo propertyInfo = entityObj.getPropertyByNameRuntime(fieldArr[i]);
            if (!(propertyInfo instanceof LinkPropertyInfo)) {
                return null;
            }
            RelationshipInfo relationship = ((LinkPropertyInfo)propertyInfo).getRelationship();
            if (relationship == null) continue;
            entityObj = Objects.equals(relationship.getClientObject(), entityObj) ? relationship.getSupplierObject() : relationship.getClientObject();
        }
        return entityObj;
    }

    public static EntityObjectInfo getLinkFieldTypeEntityObj(EntityObjectInfo entityObj, String field) {
        PropertyInfo propertyInfo;
        String actField;
        String string = actField = StringUtils.contains((CharSequence)field, (int)46) ? StringUtils.substringAfterLast((String)field, (String)".") : field;
        if (StringUtils.isBlank((CharSequence)actField)) {
            return null;
        }
        PropertyInfo propertyInfo2 = propertyInfo = (entityObj = AtsEntityUtile.getFieldDeclareEntityObj(entityObj, field)) == null ? null : entityObj.getPropertyByNameRuntime(actField);
        if (!(propertyInfo instanceof LinkPropertyInfo)) {
            return null;
        }
        RelationshipInfo relationship = ((LinkPropertyInfo)propertyInfo).getRelationship();
        return relationship == null ? null : (Objects.equals(relationship.getClientObject(), entityObj) ? relationship.getSupplierObject() : relationship.getClientObject());
    }

    public static List<LinkPropertyInfo> getLinkProperties(EntityObjectInfo entityObj) {
        PropertyCollection propertys = entityObj.getPropertiesRuntime();
        ArrayList<LinkPropertyInfo> linkPropertys = new ArrayList<LinkPropertyInfo>();
        if (propertys != null) {
            for (int i = 0; i < propertys.size(); ++i) {
                PropertyInfo propertyInfo = propertys.get(i);
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                linkPropertys.add((LinkPropertyInfo)propertyInfo);
            }
        }
        return linkPropertys;
    }

    public static PropertyInfo getPropertyInfo(EntityObjectInfo entityObj, String field) {
        String actField;
        String string = actField = StringUtils.contains((CharSequence)field, (int)46) ? StringUtils.substringAfterLast((String)field, (String)".") : field;
        if (StringUtils.isBlank((CharSequence)actField)) {
            return null;
        }
        return (entityObj = AtsEntityUtile.getFieldDeclareEntityObj(entityObj, field)) == null ? null : entityObj.getPropertyByNameRuntime(actField);
    }

    public static String getFieldAlias(Context ctx, CoreBaseInfo model, String field) {
        EntityObjectInfo entityObj = AtsEntityUtile.getEntityObj(ctx, model);
        PropertyInfo property = AtsEntityUtile.getPropertyInfo(entityObj, field);
        String fileAlias = property == null ? null : property.getAlias();
        return StringUtils.isBlank((CharSequence)fileAlias) ? field : fileAlias;
    }
}

