/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.ml;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.hr.ats.util.common.ml.AbstractDisplayFormate;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeDisplayFormate
extends AbstractDisplayFormate<Date> {
    private DataType dateType;

    @Override
    public String formate(Date date) {
        super.formate(date);
        if (date == null) {
            return "";
        }
        String format = this.getFormat();
        TimeZoneInfo timezoneInfo = this.userNationaPlan.getTimeZone();
        String timeDiff = UserNantionalUtil.getTimeZoneDiffStringValue((double)timezoneInfo.getTimeDiff().getValue());
        TimeZone timeZone = TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", timeDiff));
        if (DataType.TIMESTAMP.getName().equals(this.dateType)) {
            return MessageFormat.format("{0}{1} {2}", timezoneInfo.getTimeZoneStandard().getValue(), timeDiff, DateTimeUtils.format((Date)date, (String)format, (TimeZone)timeZone));
        }
        return DateTimeUtils.format((Date)date, (String)format, (TimeZone)timeZone);
    }

    private String getFormat() {
        String format = null;
        if (this.dateType == null) {
            this.dateType = DataType.TIMESTAMP;
        }
        if (DataType.TIME.getName().equals(this.dateType)) {
            format = this.userNationaPlan.getTimeFormat().toPattern();
        } else if (DataType.TIMESTAMP.getName().equals(this.dateType)) {
            format = this.userNationaPlan.getDateTimeFormat().toPattern();
        } else if (DataType.DATE.getName().equals(this.dateType)) {
            format = this.userNationaPlan.getDateFormat().toPattern();
        }
        return format;
    }

    public DataType getDateType() {
        return this.dateType;
    }

    public DateTimeDisplayFormate setDateType(DataType dateType) {
        this.dateType = dateType;
        return this;
    }
}

