/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAttencePolicyEntryInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsOffsiteCollection;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryCollection;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsOffsiteFactory;
import com.kingdee.eas.hr.ats.AtsOffsiteInfo;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AttencePolicyCycleTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyEntryCollection;
import com.kingdee.eas.hr.ats.AttencePolicyEntryFactory;
import com.kingdee.eas.hr.ats.AttencePolicyEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.BillSourceTypeEnum;
import com.kingdee.eas.hr.ats.ETimeCtrlType;
import com.kingdee.eas.hr.ats.IAtsOffsite;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.validator.ValidateCtx;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OffsiteHelper
extends BillHelper {
    private static Logger logger = LoggerFactory.getLogger(OffsiteHelper.class);
    public static final String TELE_OFFICE_TYPE_0001 = "FD5kbNUETbmUYC/iDDZ9hcVD0ro=";
    public static final String TELE_OFFICE_TYPE_0002 = "Ea7azLiFTva0RW/ne7bGc8VD0ro=";

    private OffsiteHelper() {
    }

    public static OffsiteHelper getInstance() {
        return OffsiteHelperHolder.offsiteHelper;
    }

    public String[] doAbortBill(Context ctx, String billIdParam) throws BOSException, EASBizException {
        String billId;
        String billIds = billIdParam.replaceAll(",", "','");
        String[] billIdArr = billIdParam.split(",");
        HashSet atsInfoIds = new HashSet();
        ArrayList<String> noSubmitBilList = new ArrayList<String>();
        String oql = " select number,billstate,id,entries.person where id in ( '" + billIds + "' )";
        IAtsOffsite iAtsOffsite = null;
        AtsOffsiteCollection atsOffsiteCollection = null;
        try {
            iAtsOffsite = AtsOffsiteFactory.getLocalInstance(ctx);
            atsOffsiteCollection = iAtsOffsite.getAtsOffsiteCollection(oql);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AtsStaticResourceBizException(AtsBillBizException.SYSTEMERROR);
        }
        ValidateCtx validateCtx = ValidateUtile.getValidateCtx(ctx, billIdParam);
        for (int i = 0; i < atsOffsiteCollection.size(); ++i) {
            HRBillStateEnum billState = atsOffsiteCollection.get(i).getBillState();
            billId = atsOffsiteCollection.get(i).getId().toString();
            if (!HRBillStateEnum.SAVED.equals((Object)billState) && !HRBillStateEnum.AUDITED.equals((Object)billState) && !HRBillStateEnum.AUDITEND.equals((Object)billState)) continue;
            noSubmitBilList.add(billId);
        }
        ArrayList<String> billList = new ArrayList<String>(Arrays.asList(billIdArr));
        billList.removeAll(noSubmitBilList);
        billIdArr = billList.toArray(new String[billList.size()]);
        for (int j = 0; j < billIdArr.length; ++j) {
            billId = billIdArr[j];
            try {
                ValidateUtile.setValidatorCtx(ctx, validateCtx, billId);
                iAtsOffsite.abortBizBill(billId);
                BillHelper.uptBillSourceTypeWithBack(ctx, billId);
                if (atsInfoIds.contains(billId)) continue;
                DataLogsRecordUtil.processListObjectsLog((CoreBaseInfo)AtsOffsiteFactory.getLocalInstance(ctx).getAtsOffsiteInfo(" select *,entries.* where id = ( '" + billId + "' )"), OperActionEnum.abort, ctx);
                continue;
            }
            catch (Exception e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return billIdArr;
    }

    public Map<String, BigDecimal> getMinAndMax(Context ctx, Timestamp beginDate, Timestamp endDate, String personId, String teleOfficeType) throws BOSException {
        AttencePolicyEntryCollection attencePolicyEntryCollection;
        AttencePolicyInfo attencePolicyInfo;
        HashMap rangeMap = Maps.newHashMap();
        AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, beginDate, endDate, personId, null);
        if (null != attendanceFileHisInfo && null != (attencePolicyInfo = attendanceFileHisInfo.getAttencePolicy()) && null != (attencePolicyEntryCollection = AttencePolicyEntryFactory.getLocalInstance(ctx).getAttencePolicyEntryCollection("where bill ='" + attencePolicyInfo.getId() + "' and offsiteType='" + teleOfficeType + "'")) && attencePolicyEntryCollection.size() > 0) {
            AttencePolicyEntryInfo attencePolicyEntryInfo = attencePolicyEntryCollection.get(0);
            int minOffWork = attencePolicyEntryInfo.getMinOffWork();
            int maxOffWork = attencePolicyEntryInfo.getMaxOffWork();
            if (minOffWork != 0 || maxOffWork != 0) {
                BigDecimal minVal = new BigDecimal(minOffWork).divide(new BigDecimal(60), DecimalPlaceUtil.getDecimalPlaceSystem(ctx), RoundingMode.HALF_UP);
                BigDecimal maxVal = new BigDecimal(maxOffWork).divide(new BigDecimal(60), DecimalPlaceUtil.getDecimalPlaceSystem(ctx), RoundingMode.HALF_UP);
                rangeMap.put("originalMinVal", new BigDecimal(minOffWork + ""));
                rangeMap.put("minVal", minVal);
                rangeMap.put("maxVal", maxVal);
                rangeMap.put("originalMaxVal", new BigDecimal(maxOffWork + ""));
            }
        }
        return rangeMap;
    }

    public String validateFill(Context ctx, AtsOffsiteInfo atsOffsiteInfo) throws EASBizException, BOSException {
        String errorString = "";
        String extraString = "";
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (atsOffsiteInfo == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.MissingBill, ctx);
            return errorString;
        }
        AtsOffsiteEntryCollection atsOffsiteInfoEntries = atsOffsiteInfo.getEntries();
        if (atsOffsiteInfoEntries == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.MissingBill, ctx);
            return errorString;
        }
        Calendar applyCal = Calendar.getInstance();
        if (atsOffsiteInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, atsOffsiteInfo.getId().toString())) {
            AtsOffsiteInfo billInfoDB = atsOffsiteInfo;
            if (atsOffsiteInfo.getApplyDate() == null) {
                billInfoDB = AtsOffsiteFactory.getLocalInstance(ctx).getAtsOffsiteInfo((IObjectPK)new ObjectUuidPK(atsOffsiteInfo.getId().toString()));
            }
            applyCal.setTime(billInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        java.util.Date applyDate = applyCal.getTime();
        Iterator itr = atsOffsiteInfoEntries.iterator();
        int rowNumber = 0;
        while (itr.hasNext()) {
            errorString = "";
            ++rowNumber;
            AtsOffsiteEntryInfo billEntryInfo = (AtsOffsiteEntryInfo)itr.next();
            String personId = billEntryInfo != null && billEntryInfo.getPerson() != null && billEntryInfo.getPerson().getId() != null ? billEntryInfo.getPerson().getId().toString() : "";
            Timestamp start = billEntryInfo != null ? billEntryInfo.getStartTime() : null;
            AttendanceFileHISInfo fileHisInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfo(ctx, start, personId);
            AttencePolicyInfo attencePolicyInfo = fileHisInfo.getAttencePolicy();
            AbstractAttencePolicyEntryInfo attencePolicyEntryInfo = null;
            boolean isFill = false;
            if (attencePolicyInfo == null) {
                errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            } else {
                AttencePolicyEntryCollection policyEntryCollection = AttencePolicyEntryFactory.getLocalInstance(ctx).getAttencePolicyEntryCollection("where bill ='" + attencePolicyInfo.getId() + "' and offsiteType ='" + billEntryInfo.getTeleOfficeType().getId() + "'");
                if (null != policyEntryCollection && policyEntryCollection.size() > 0) {
                    attencePolicyEntryInfo = policyEntryCollection.get(0);
                    isFill = attencePolicyEntryInfo.isFillControl();
                }
            }
            if (!isFill) continue;
            if (null == billEntryInfo || billEntryInfo.getEndTime() == null || billEntryInfo.getStartTime() == null) {
                errorString = MLUtile.getRes(AtsBillResEnum.NullBillTime, ctx);
            } else {
                long beginTimeLong = billEntryInfo.getStartTime().getTime();
                Timestamp tripEndDate = billEntryInfo.getEndTime();
                boolean isFillByTimeCtl = attencePolicyEntryInfo.isFillByTimeCtl();
                boolean isFillByCycleCtrl = attencePolicyEntryInfo.isFillByCycleCtl();
                if (isFillByTimeCtl) {
                    BigDecimal amount = attencePolicyEntryInfo.getFillByTimeCtlAmount();
                    ETimeCtrlType unit = attencePolicyEntryInfo.getFillByTimeCtlUnit();
                    errorString = AttencePolicyFillUtil.validateByTimeControle(ctx, amount, unit, applyDate, attencePolicyInfo, tripEndDate);
                }
                if (isFillByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                    int fillCycleType = attencePolicyEntryInfo.getFilByCycleCtlType().getValue();
                    Integer afterDay = attencePolicyEntryInfo.getFillByCycleCtlAfterDay();
                    if (afterDay == null) {
                        errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCheck, ctx);
                    } else if (AttencePolicyCycleTypeEnum.attendanceCycle.equals((Object)attencePolicyEntryInfo.getFilByCycleCtlType())) {
                        Boolean ok = false;
                        try {
                            String attenceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                            String theDate = AtsDateUtils.timestampToShortString(start);
                            ok = AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attenceCycleId, afterDay, theDate, atsOffsiteInfo.getApplyDate());
                        }
                        catch (EASBizException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        errorString = null != ok && ok != false ? "" : MLUtile.getRes((ResourceEnum)AtsBillResEnum.OverBillFillTime, ctx, atsOffsiteInfo.getNumber());
                    } else {
                        errorString = AttencePolicyFillUtil.validateByCycleControle(ctx, attencePolicyInfo, beginTimeLong, fillCycleType, afterDay, 1);
                    }
                }
            }
            if (!StringUtils.isNotEmpty((String)errorString)) continue;
            if (atsOffsiteInfo.getBillType() != null) {
                if (atsOffsiteInfo.getBillType().getValue() == 1) continue;
                rows.add(rowNumber);
                continue;
            }
            if (atsOffsiteInfoEntries.size() <= 1) continue;
            rows.add(rowNumber);
        }
        if (rows.size() > 0) {
            String rowTemp = "";
            for (int i = 0; i < rows.size(); ++i) {
                rowTemp = i == rows.size() - 1 ? rowTemp + rows.get(i) : rowTemp + rows.get(i) + ",";
            }
            extraString = MLUtile.getRes((ResourceEnum)AtsCommonResEnum.Row, ctx, rowTemp);
        }
        return extraString + errorString;
    }

    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T billInfo) throws BOSException, EASBizException {
        super.storefields(ctx, billInfo);
        PersonInfo curPerson = SHRBillUtil.getCurrPersonInfoNew(ctx);
        if (billInfo.getAdminOrg() == null) {
            PersonPositionInfo curPersonPosition = SHRBillUtil.getAdminOrgUnit(CoreBaseUtile.getId(curPerson), ctx);
            billInfo.setAdminOrg(curPersonPosition.getPersonDep());
        }
        if (billInfo.get("billSourceType") == null) {
            billInfo.put("billSourceType", (Object)BillSourceTypeEnum.empSelfService);
        }
        this.setCtx(ctx);
        AtsOffsiteEntryCollection atsTripBillEntryCollection = ((AtsOffsiteInfo)billInfo).getEntries();
        this.storeEntryfields(atsTripBillEntryCollection, CoreBaseUtile.getId(billInfo.getHrOrgUnit()));
        return billInfo;
    }

    protected void storeEntryfields(AtsOffsiteEntryCollection entries, String hrOrgUnitId) throws EASBizException, BOSException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        hrOrgUnitId = null;
        int entrySize = entries.size();
        for (int i = 0; i < entrySize; ++i) {
            Timestamp endTime;
            AtsOffsiteEntryInfo atsBillEntryInfo = entries.get(i);
            Timestamp beginTime = atsBillEntryInfo.getStartTime();
            AttendanceFileHISInfo fileHisInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(this.ctx, beginTime, endTime = atsBillEntryInfo.getEndTime(), CoreBaseUtile.getId(atsBillEntryInfo.getPerson()));
            if (fileHisInfo == null) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{new AtsFileBizException(AtsFileBizException.NOTEXISTFILEHIS).getMessage()});
            }
            String string = hrOrgUnitId = hrOrgUnitId == null ? CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()) : hrOrgUnitId;
            if (!StringUtils.equals((String)hrOrgUnitId, (String)CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()))) {
                throw new BOSException(new AtsBillBizException(AtsBillBizException.COMMITCROSSHRORG).getMessage());
            }
            atsBillEntryInfo.setAdminOrgUnit(fileHisInfo.getAdminOrgUnit());
            atsBillEntryInfo.setAttAdminOrgUnit(fileHisInfo.getAttAdminOrgUnit());
            atsBillEntryInfo.setPosition(fileHisInfo.getPosition());
            atsBillEntryInfo.setIsDefaultManage(fileHisInfo.isIsDefaultManage());
            if (atsBillEntryInfo.isIsDefaultManage() || !atsBillEntryInfo.containsKey("isCalOt")) {
                atsBillEntryInfo.setIsCalOt(false);
            }
            BigDecimal days = atsBillEntryInfo.getDays();
            atsBillEntryInfo.setRealStartTime(beginTime);
            atsBillEntryInfo.setRealEndTime(endTime);
            atsBillEntryInfo.setRealDays(days);
            atsBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsBillEntryInfo.setLastUpdateTime(now);
            try {
                if (atsBillEntryInfo.getStartPlace() != null && atsBillEntryInfo.getStartPlace().getBytes("utf8").length > 80) {
                    atsBillEntryInfo.setStartPlace(OffsiteHelper.substr(atsBillEntryInfo.getStartPlace(), 80, "utf8"));
                }
                if (atsBillEntryInfo.getEndPlace() != null && atsBillEntryInfo.getEndPlace().getBytes("utf8").length > 80) {
                    atsBillEntryInfo.setEndPlace(OffsiteHelper.substr(atsBillEntryInfo.getEndPlace(), 80, "utf8"));
                }
                if (atsBillEntryInfo.getReason() != null && atsBillEntryInfo.getReason().getBytes("utf8").length > 80) {
                    atsBillEntryInfo.setReason(OffsiteHelper.substr(atsBillEntryInfo.getReason(), 80, "utf8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
            if (atsBillEntryInfo.getDays() == null) {
                BigDecimal len = atsBillEntryInfo.getRealDays();
                atsBillEntryInfo.setDays(len == null ? this.getBillLength(this.ctx, atsBillEntryInfo) : len);
            }
            if (atsBillEntryInfo.getRealDays() != null) continue;
            atsBillEntryInfo.setRealDays(atsBillEntryInfo.getDays());
        }
    }

    public String doDateInterleaveVerify(AtsOffsiteEntryCollection offsiteEntryColl) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)offsiteEntryColl)) {
            return null;
        }
        int size = offsiteEntryColl.size();
        String[] rowNum = new String[size];
        String[] personID = new String[size];
        String[] offsiteStartTime = new String[size];
        String[] offsiteEndTime = new String[size];
        for (int i = 0; i < size; ++i) {
            rowNum[i] = String.valueOf(i + 1);
            personID[i] = CoreBaseUtile.getId(offsiteEntryColl.get(i).getPerson());
            offsiteStartTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealStartTime());
            offsiteEndTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealEndTime());
        }
        return this.doDateInterleaveVerify(this.getCtx(), rowNum, personID, offsiteStartTime, offsiteEndTime);
    }

    public String offsiteMinMaxVerify(Context ctx, AtsOffsiteEntryCollection offsiteEntryColl) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)offsiteEntryColl)) {
            return null;
        }
        int size = offsiteEntryColl.size();
        String[] rowNum = new String[size];
        String[] personID = new String[size];
        String[] offsiteStartTime = new String[size];
        String[] offsiteEndTime = new String[size];
        String[] hours = new String[size];
        String[] teleOfficeType = new String[size];
        String msg = "";
        logger.info("offsiteMinMaxVerify start");
        System.out.println("offsiteMinMaxVerify start");
        try {
            for (int i = 0; i < size; ++i) {
                rowNum[i] = String.valueOf(i + 1);
                personID[i] = CoreBaseUtile.getId(offsiteEntryColl.get(i).getPerson());
                offsiteStartTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealStartTime());
                offsiteEndTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealEndTime());
                hours[i] = String.valueOf(offsiteEntryColl.get(i).getHours());
                teleOfficeType[i] = offsiteEntryColl.get(i).getTeleOfficeType().getId().toString();
            }
            logger.info("offsiteMinMaxVerify params " + JSON.toJSON((Object)rowNum) + " " + JSON.toJSON((Object)personID) + " " + JSON.toJSON((Object)offsiteStartTime) + " " + JSON.toJSON((Object)offsiteEndTime) + " " + JSON.toJSON((Object)hours) + " " + JSON.toJSON((Object)teleOfficeType));
            msg = this.validateMinMax(ctx, rowNum, personID, offsiteStartTime, offsiteEndTime, hours, teleOfficeType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public String doDateInterleaveVerify(Context ctx, String[] rowNum, String[] personID, String[] offsiteStartTime, String[] offsiteEndTime) {
        int len = personID.length;
        HashMap<String, String> dateMap = new HashMap<String, String>();
        StringBuffer errorSb = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            if (dateMap.containsKey(personID[i])) {
                String tempData = (String)dateMap.get(personID[i]);
                String interleaveList = this.dateInterleaveVerifyCore(i, tempData, offsiteStartTime, offsiteEndTime);
                if (!interleaveList.equals("")) {
                    errorSb.append(MLUtile.getRes((ResourceEnum)AtsBillResEnum.RepeatPageRecord, ctx, interleaveList, rowNum[i]));
                    errorSb.append(":").append(rowNum[i]).append("&").append(interleaveList).append(",").append(interleaveList).append("&").append(rowNum[i]);
                    break;
                }
                dateMap.put(personID[i], (String)dateMap.get(personID[i]) + "," + i);
                continue;
            }
            dateMap.put(personID[i], String.valueOf(i));
        }
        return errorSb.toString();
    }

    public String validateMinMax(Context ctx, String[] rowNum, String[] personID, String[] offsiteStartTime, String[] offsiteEndTime, String[] hours, String[] teleType) throws BOSException {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < rowNum.length; ++i) {
            Map<String, BigDecimal> minAndMax = this.getMinAndMax(ctx, AtsDateUtils.stringToTimestamp(offsiteStartTime[i]), AtsDateUtils.stringToTimestamp(offsiteEndTime[i]), personID[i], teleType[i]);
            if (CollectionUtils.isEmpty(minAndMax)) continue;
            BigDecimal minVal = minAndMax.get("minVal");
            BigDecimal originalMinVal = minAndMax.get("originalMinVal");
            BigDecimal maxVal = minAndMax.get("maxVal");
            BigDecimal originalMaxVal = minAndMax.get("originalMaxVal");
            BigDecimal realVal = new BigDecimal(hours[i]);
            if (realVal.compareTo(minVal) < 0) {
                msg.append(MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "LESS_THAN_MIN", ctx, rowNum[i], originalMinVal));
                continue;
            }
            if (maxVal.compareTo(BigDecimal.ZERO) <= 0 || maxVal.compareTo(realVal) >= 0) continue;
            msg.append(MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "MORE_THAN_MAX", ctx, rowNum[i], originalMaxVal));
        }
        return msg.toString();
    }

    public OperTypeEnum convertType(String teleOfficeType) {
        OperTypeEnum operTypeEnum = null;
        operTypeEnum = StringUtils.equals((String)teleOfficeType, (String)TELE_OFFICE_TYPE_0001) ? OperTypeEnum.outsideBill : (StringUtils.equals((String)teleOfficeType, (String)TELE_OFFICE_TYPE_0002) ? OperTypeEnum.telecommuteBill : OperTypeEnum.otherOutBill);
        return operTypeEnum;
    }

    public String dateInterleaveVerifyCore(int rowNum, String arrayNum, String[] offsiteStartTime, String[] offsiteEndTime) {
        String[] arrayNums = arrayNum.split(",");
        Timestamp startTimeStA = HRTimeWebUtils.stringToTimestamp(offsiteStartTime[rowNum].substring(0, 16) + ":00");
        Timestamp endTimeStA = HRTimeWebUtils.stringToTimestamp(offsiteEndTime[rowNum].substring(0, 16) + ":00");
        for (int i = 0; i < arrayNums.length; ++i) {
            Timestamp endTimeStB;
            int tempArrayNum = Integer.parseInt(arrayNums[i]);
            Timestamp startTimeStB = HRTimeWebUtils.stringToTimestamp(offsiteStartTime[tempArrayNum].substring(0, 16) + ":00");
            if (!this.isInterleaving(startTimeStA, endTimeStA, startTimeStB, endTimeStB = HRTimeWebUtils.stringToTimestamp(offsiteEndTime[tempArrayNum].substring(0, 16) + ":00"))) continue;
            return tempArrayNum + 1 + "";
        }
        return "";
    }

    private boolean isInterleaving(Timestamp startTimeA, Timestamp endTimeA, Timestamp startTimeB, Timestamp endTimeB) {
        return startTimeA.before(endTimeB) && startTimeB.before(endTimeA) && !startTimeA.equals(endTimeB) && !startTimeB.equals(endTimeA);
    }

    public void getDateOverlappingData(AtsOffsiteInfo AtsOffsiteInfo2) throws BOSException, SQLException, EASBizException {
        Context ctx = this.getCtx();
        String billId = CoreBaseUtile.getId(AtsOffsiteInfo2);
        if (AtsOffsiteInfo2 == null || AtsCollectionUtile.isEmpty((IObjectCollection)AtsOffsiteInfo2.getEntries())) {
            return;
        }
        StringBuffer selectSql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>(4);
        String unionAllFlag = " union all ";
        for (int i = 0; i < AtsOffsiteInfo2.getEntries().size(); ++i) {
            AtsOffsiteEntryInfo atsOffsiteEntryInfo = AtsOffsiteInfo2.getEntries().get(i);
            String personId = CoreBaseUtile.getId(atsOffsiteEntryInfo.getPerson());
            Date beginTime = Date.getTime(atsOffsiteEntryInfo.getRealStartTime());
            Date endTime = Date.getTime(atsOffsiteEntryInfo.getRealEndTime());
            sqlParam.addAll(Arrays.asList(personId, endTime, beginTime));
            selectSql.append(" select bill.fnumber,entry.FRealStartTime,entry.FRealEndTime,entry.fpersonid,entry.FTeleOfficeTypeID");
            selectSql.append(" from  T_ATS_AtsOffsite  bill left join  T_ATS_AtsOffsiteEntry entry on  bill.fid = entry.fbillid ");
            selectSql.append(" where entry.fpersonid=? and bill.fbillstate not in( 0,4) and entry.FRealStartTime<? and entry.FRealEndTime>? and entry.FRealStartTime <> entry.FRealEndTime ");
            if (BOSUuid.isValid((String)billId, (boolean)true)) {
                selectSql.append("and bill.fid !=?");
                sqlParam.add(billId);
            }
            selectSql.append(unionAllFlag);
        }
        selectSql.setLength(selectSql.length() - unionAllFlag.length());
        selectSql.append(") temp");
        selectSql.insert(0, "select top 1 * from (");
        System.out.println("OffsiteBillHelper.getDateOverlappingData.sql " + selectSql.toString());
        System.out.println("OffsiteBillHelper.getDateOverlappingData.param " + sqlParam);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])sqlParam.toArray());
        if (row.next()) {
            System.out.println("OffsiteBillHelper.getDateOverlappingData.reault.has");
            java.util.Date dbBeginTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealStartTime"));
            java.util.Date dbEndTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealEndTime"));
            String teleOfficeTypeID = row.getString("FTeleOfficeTypeID");
            String typeName = this.convertType(teleOfficeTypeID).getAlias();
            String personid = row.getString("fpersonid");
            PersonPositionInfo positionInfo = SHRBillUtil.getAdminOrgUnit(personid, ctx);
            String msg = MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "OFFSITE_OVER", this.getCtx(), row.getString("FNumber"), typeName, positionInfo != null && positionInfo.getPerson() != null ? positionInfo.getPerson().getName() : "", HRTimeWebUtils.dateLongToString(dbBeginTime), HRTimeWebUtils.dateLongToString(dbEndTime));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        System.out.println("OffsiteBillHelper.getDateOverlappingData.notReault.has");
    }

    public static boolean hasIntersection(java.util.Date beginTime, java.util.Date lateTime, java.util.Date startTime, java.util.Date endTime) {
        if (startTime == null || endTime == null || startTime.getTime() >= endTime.getTime()) {
            return false;
        }
        if (beginTime == null || lateTime == null || beginTime.getTime() >= lateTime.getTime()) {
            return false;
        }
        return beginTime.getTime() < endTime.getTime() && startTime.getTime() < lateTime.getTime();
    }

    public static String substr(String str, int len, String cs) throws UnsupportedEncodingException {
        byte[] br = new byte[len];
        byte[] bt = str.getBytes(cs);
        System.arraycopy(bt, 0, br, 0, len);
        String res = new String(br, cs);
        int resLen = res.length();
        if (str.substring(0, resLen).getBytes(cs).length > len) {
            res = str.substring(0, resLen - 1);
        }
        return res;
    }

    private static class OffsiteHelperHolder {
        private static final OffsiteHelper offsiteHelper = new OffsiteHelper();

        private OffsiteHelperHolder() {
        }
    }
}

