/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.AtsTeamPermServerUtils;
import com.kingdee.eas.hr.ats.util.common.AtsContextUtile;
import com.kingdee.eas.hr.ats.util.common.AtsFitFn;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidateCtx
implements Serializable,
Cloneable {
    private Context bosCtx = AtsContextUtile.getCtx();
    private boolean beValidated;
    private boolean initialzed;
    private String permItem;
    private String validateId = ValidateCtx.class.getSimpleName();
    private PlateformType plateformType;
    private String validatorCls;
    private String methodName;
    private Set<String> hrOrgRange;
    private Set<String> adminOrgRange;
    IObjectValueLazyLoader fieldValLoader;
    private BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
    private List<Object> validateTargets = new ArrayList<Object>();
    private List<String> convertSelectFields = new ArrayList<String>(8);
    private Map<Object, Object> extParam = new HashMap<Object, Object>(2);
    private String operateFailMsg;
    private String operateSuccessMsg;

    public void init() {
        if (!this.initialzed) {
            this.doInit();
            this.initialzed = true;
        }
        ValidateUtile.removeValidateCtxParam(this.bosCtx, this.validateId);
    }

    protected void doInit() {
    }

    public Object getValidateFieldVal(IObjectValue baseInfo, String fieldName) {
        if (baseInfo == null || StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        if (this.fieldValLoader == null) {
            this.fieldValLoader = ObjectValueLazyLoaderFactory.getLocalInstance((Context)this.bosCtx);
        }
        try {
            this.fieldValLoader.getProperty(baseInfo, fieldName);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return baseInfo.get(fieldName);
    }

    public boolean isNeedValidateBiz(Object tar) {
        return ValidateUtile.isValidateBizMethod(this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ValidateCtx setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public String getPermItem() {
        return this.permItem;
    }

    public ValidateCtx setPermItem(Object permItem) {
        permItem = permItem instanceof PermItemInfo ? CoreBaseUtile.getId(permItem) : permItem;
        this.permItem = permItem == null ? null : String.valueOf(permItem);
        return this;
    }

    public PlateformType getPlateformType() {
        if (this.plateformType == null && this.getPermItem() != null) {
            this.plateformType = PlateformType.getPlateformType(this.bosCtx, this.getPermItem());
        }
        ValidateUtile.removeValidateCtxParam(this.bosCtx, this.validateId);
        return this.plateformType;
    }

    public ValidateCtx setPlateformType(PlateformType plateformType) {
        this.plateformType = plateformType;
        return this;
    }

    public Set<String> getHrOrgRange() {
        if (this.hrOrgRange != null) {
            return this.hrOrgRange;
        }
        String permItemId = this.getPermItem();
        if (PlateformType.SELF.equals(this.getPlateformType()) || StringUtils.isBlank((CharSequence)permItemId)) {
            return Collections.emptySet();
        }
        String userId = CoreBaseUtile.getId(ContextUtil.getCurrentUserInfo((Context)this.bosCtx));
        boolean teamPlat = PlateformType.isTeam(this.getPlateformType());
        this.hrOrgRange = teamPlat && !this.isUpdateMethod() ? null : SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)this.bosCtx, (String)userId, (String)permItemId);
        this.hrOrgRange = this.hrOrgRange == null ? Collections.emptySet() : this.hrOrgRange;
        return this.hrOrgRange;
    }

    public boolean isValidateBizMethod() {
        return ValidateUtile.isValidateBizMethod(this.methodName);
    }

    public boolean isUpdateMethod() {
        return ValidateUtile.isUpdateMethod(this.methodName);
    }

    public ValidateCtx setHrOrgRange(Set<String> hrOrgRange) {
        this.hrOrgRange = hrOrgRange;
        return this;
    }

    public Set<String> getAdminOrgRange() {
        if (this.adminOrgRange != null) {
            return this.adminOrgRange;
        }
        String permItemId = this.getPermItem();
        if (PlateformType.SELF.equals(this.getPlateformType()) || StringUtils.isBlank((CharSequence)permItemId)) {
            return Collections.emptySet();
        }
        String userId = CoreBaseUtile.getId(ContextUtil.getCurrentUserInfo((Context)this.bosCtx));
        boolean teamPlat = PlateformType.isTeam(this.getPlateformType());
        this.adminOrgRange = teamPlat ? AtsTeamPermServerUtils.getTeamAdminOrgRangeIdSet(this.bosCtx, permItemId) : SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)this.bosCtx, (String)userId, (String)permItemId);
        this.adminOrgRange = this.adminOrgRange == null ? Collections.emptySet() : this.adminOrgRange;
        return this.adminOrgRange;
    }

    public ValidateCtx setAdminOrgRange(Set<String> adminOrgRange) {
        this.adminOrgRange = adminOrgRange;
        return this;
    }

    public ValidateCtx addValidateErrorMsg(String validateMsg) {
        return this.addValidateMsg(validateMsg, false);
    }

    public ValidateCtx addValidateSuccessMsg(String validateMsg) {
        return this.addValidateMsg(validateMsg, true);
    }

    public ValidateCtx addValidateMsg(String validateMsg, boolean isSuccess) {
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        body.setMuitTipsState(isSuccess);
        body.setMuitTipsMessage(StringUtils.isBlank((CharSequence)validateMsg) ? (isSuccess ? this.operateSuccessMsg : this.operateFailMsg) : validateMsg);
        this.batchMessageTipsHeader.addResult(body);
        if (isSuccess) {
            this.batchMessageTipsHeader.setSuccessCount(this.batchMessageTipsHeader.getSuccessCount() + 1);
        } else {
            this.batchMessageTipsHeader.setFailureCount(this.batchMessageTipsHeader.getFailureCount() + 1);
        }
        return this;
    }

    public ValidateCtx setBatchMessageTipsHeader(BatchMessageTipsHeader batchMessageTipsHeader) {
        this.batchMessageTipsHeader = batchMessageTipsHeader;
        return this;
    }

    public List<String> getConvertSelectFields() {
        return this.convertSelectFields;
    }

    public ValidateCtx setConvertSelectFields(List<String> convertSelectFields) {
        this.convertSelectFields = convertSelectFields;
        return this;
    }

    public BatchMessageTipsHeader getBatchMessageTipsHeader() {
        return this.batchMessageTipsHeader;
    }

    public List<Object> getValidateTargets() {
        return this.validateTargets;
    }

    public void setValidateTargets(List<Object> validateTargets) {
        this.validateTargets = validateTargets == null ? Collections.emptyList() : validateTargets;
    }

    public ValidateCtx addTargets(Collection targets) {
        return this.addTarget(targets == null ? null : targets.iterator());
    }

    public ValidateCtx addTargets(IObjectCollection targets) {
        return this.addTarget(targets == null ? null : targets.iterator());
    }

    public ValidateCtx addTarget(Iterator it) {
        if (it != null) {
            while (it.hasNext()) {
                this.addTarget(it.next());
            }
        }
        return this;
    }

    public ValidateCtx addTarget(Object target) {
        if (target != null) {
            Object validator = target instanceof CoreBaseInfo ? ((CoreBaseInfo)target).get("$needValidat") : null;
            boolean needValidat = true;
            if (validator instanceof Boolean) {
                needValidat = (Boolean)validator;
            } else if (validator instanceof AtsFitFn) {
                needValidat = ((AtsFitFn)validator).fit(target);
            }
            if (needValidat) {
                this.validateTargets.add(target);
            }
        }
        return this;
    }

    public ValidateCtx addConvertSelectField(String field) {
        this.convertSelectFields.add(field);
        return this;
    }

    public boolean isBeValidated() {
        if (CollectionUtils.isEmpty(this.validateTargets)) {
            this.beValidated = true;
        }
        return this.beValidated;
    }

    public ValidateCtx setBeValidated(boolean beValidated) {
        this.beValidated = beValidated;
        return this;
    }

    public boolean isValid() {
        if (!this.beValidated) {
            throw new IllegalStateException("validator must has execute the validate method!");
        }
        return this.batchMessageTipsHeader.getFailureCount() == 0;
    }

    public String getOperateFailMsg() {
        if (this.operateFailMsg == null) {
            this.operateFailMsg = MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "OPERATE_FAIL", this.bosCtx);
        }
        return this.operateFailMsg;
    }

    public ValidateCtx setOperateFailMsg(String operateFailMsg) {
        this.operateFailMsg = operateFailMsg;
        return this;
    }

    public String getOperateSuccessMsg() {
        if (this.operateSuccessMsg == null) {
            this.operateSuccessMsg = MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "OPERATE_SUCCESS", this.bosCtx);
        }
        return this.operateSuccessMsg;
    }

    public ValidateCtx setOperateSuccessMsg(String operateSuccessMsg) {
        this.operateSuccessMsg = operateSuccessMsg;
        return this;
    }

    public Object getParam(Object paramName) {
        return this.extParam.get(paramName);
    }

    public Object setParam(Object paramName, Object value) {
        return this.extParam.put(paramName, value);
    }

    public String getValidatorCls() {
        return this.validatorCls;
    }

    public void setValidatorCls(String validatorCls) {
        this.validatorCls = validatorCls;
    }

    public Context getBosCtx() {
        return this.bosCtx;
    }

    public ValidateCtx setBosCtx(Context bosCtx) {
        if (bosCtx != null) {
            this.bosCtx = bosCtx;
        }
        return this;
    }

    public String getValidateId() {
        return this.validateId;
    }

    public ValidateCtx setValidateId(String validateId) {
        if (validateId != null) {
            this.validateId = validateId;
        }
        return this;
    }
}

