/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryCollection;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryFactory;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.CollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ArrangeShiftUtile {
    public static Map<String, Map<String, Integer>> getPersonHoliday(Context ctx, Collection<String> personNums, String beginDateStr, String endDateStr) {
        if (CollectionUtile.isEmpty(personNums)) {
            return new HashMap<String, Map<String, Integer>>();
        }
        StringBuffer sql = new StringBuffer("select");
        sql.append(" Item.FCalendarGroupID as calId, Item.FDayType as dayType, person.Fnumber as number,item.FDate as dateStr").append(" from T_HR_ATS_AttendanceFilehis attendceFile").append(" inner join t_bd_person person on person.fid = attendceFile.FProposerID").append(" inner join T_HR_ATS_WorkCalendarItem Item  on Item.FCalendarGroupID = attendceFile.fCalendarId").append(" and person.Fnumber in (").append(CollectionUtile.joinForSql(personNums)).append(")").append(" and attendceFile.feffdt <= item.FDate").append(" and attendceFile.fleffdt >= item.FDate").append(" and item.FDate >= {ts '").append(beginDateStr).append("'}").append(" and item.FDate <= {ts '").append(endDateStr).append("'}").append(" where Item.FDayType in(1,2)");
        HashMap personHolidayCalendar = new HashMap(personNums.size());
        int days = (int)AtsDateUtils.getDaysBetweenTwoDate(beginDateStr, endDateStr);
        for (String number : personNums) {
            personHolidayCalendar.put(number, new HashMap(days));
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String number;
                number = rowSet.getString("number");
                int dayType = rowSet.getInt("dayType");
                String dateStr = AtsCommonUtile.getDateFormat().format(rowSet.getDate("dateStr"));
                Map dayTypeMap = (Map)personHolidayCalendar.get(number);
                dayTypeMap.put(dateStr, dayType);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return Collections.unmodifiableMap(personHolidayCalendar);
    }

    public static Map<String, Integer> getPersonHoliday(Context ctx, String personNum, String beginDateStr, String endDateStr) {
        if (StringUtils.isEmpty((String)personNum)) {
            return new HashMap<String, Integer>();
        }
        return ArrangeShiftUtile.getPersonHoliday(ctx, Collections.singleton(personNum), beginDateStr, endDateStr).get(personNum);
    }

    public static Map<String, Map<Integer, AtsTurnShiftEntryInfo>> getTurnShiftEntrys(Context ctx, Collection<String> turnShiftIds) {
        if (CollectionUtile.isEmpty(turnShiftIds)) {
            return new HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>>();
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "defaultShift.*", "defaultShift.items.*", "group.id", "dateType", "segment"});
        evi = AtsViewUtile.getViewByFilter("group.id", turnShiftIds, CompareType.INCLUDE, evi);
        AtsViewUtile.addSorter("segment", SortType.ASCEND, evi);
        AtsTurnShiftEntryCollection entryCollection = null;
        try {
            entryCollection = AtsTurnShiftEntryFactory.getLocalInstance(ctx).getAtsTurnShiftEntryCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>> turnShiftEntrys = new HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>>();
        if (entryCollection != null && entryCollection.size() > 0) {
            for (int i = 0; i < entryCollection.size(); ++i) {
                String turnShifId = entryCollection.get(i).getGroup().getId().toString();
                HashMap<Integer, AtsTurnShiftEntryInfo> oneShiftEntrys = (HashMap<Integer, AtsTurnShiftEntryInfo>)turnShiftEntrys.get(turnShifId);
                if (oneShiftEntrys == null) {
                    oneShiftEntrys = new HashMap<Integer, AtsTurnShiftEntryInfo>();
                    turnShiftEntrys.put(turnShifId, oneShiftEntrys);
                }
                oneShiftEntrys.put(entryCollection.get(i).getSegment(), entryCollection.get(i));
            }
        }
        return turnShiftEntrys;
    }

    public static Map<Integer, AtsTurnShiftEntryInfo> getTurnShiftEntrys(Context ctx, String turnShiftId) {
        if (StringUtils.isEmpty((String)turnShiftId)) {
            return new HashMap<Integer, AtsTurnShiftEntryInfo>();
        }
        return ArrangeShiftUtile.getTurnShiftEntrys(ctx, Collections.singleton(turnShiftId)).get(turnShiftId);
    }

    public static Map<String, Map<String, ScheduleShiftInfo>> getScheduleShifts(Context ctx, Collection<String> personNums, String beginDate, String endDate, EntityViewInfo evi) {
        evi = AtsViewUtile.getViewBySelector(new String[]{"attendDate", "proposer.number", "dayType", "atsTurnShift", "shiftByTurnSegment", "adminOrgUnit", "srcType"}, evi);
        evi = AtsViewUtile.getViewByFilter("attendDate", endDate, CompareType.LESS_EQUALS, evi);
        evi = AtsViewUtile.getViewByFilter("attendDate", beginDate, CompareType.GREATER_EQUALS, evi);
        if (!AtsCollectionUtile.isEmpty(personNums)) {
            evi = AtsViewUtile.getViewByFilter("proposer.number", new HashSet<String>(personNums), CompareType.INCLUDE, evi);
        }
        ScheduleShiftCollection scheduleShiftCollection = null;
        try {
            scheduleShiftCollection = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        int initSize = scheduleShiftCollection == null ? 0 : scheduleShiftCollection.size();
        HashMap<String, HashMap<String, ScheduleShiftInfo>> allScheduleShifts = new HashMap<String, HashMap<String, ScheduleShiftInfo>>(initSize);
        if (scheduleShiftCollection != null && scheduleShiftCollection.size() > 0) {
            if (evi.toString().contains("defaultShift.items")) {
                WorkShiftUtile.updateShiftItems(ctx, scheduleShiftCollection, null);
            }
            for (int i = 0; i < scheduleShiftCollection.size(); ++i) {
                String personNum = scheduleShiftCollection.get(i).getProposer().getNumber();
                HashMap<String, ScheduleShiftInfo> oneScheduleShift = (HashMap<String, ScheduleShiftInfo>)allScheduleShifts.get(personNum);
                if (oneScheduleShift == null) {
                    oneScheduleShift = new HashMap<String, ScheduleShiftInfo>();
                    allScheduleShifts.put(personNum, oneScheduleShift);
                }
                oneScheduleShift.put(AtsCommonUtile.getDateFormat().format(scheduleShiftCollection.get(i).getAttendDate()), scheduleShiftCollection.get(i));
            }
        }
        return Collections.unmodifiableMap(allScheduleShifts);
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShifts(Context ctx, String personNum, String beginDate, String endDate, EntityViewInfo evi) {
        if (StringUtils.isEmpty((String)personNum)) {
            return new HashMap<String, ScheduleShiftInfo>();
        }
        return ArrangeShiftUtile.getScheduleShifts(ctx, Collections.singleton(personNum), beginDate, endDate, evi).get(personNum);
    }

    public static String isNull(List<String[]> fields) {
        if (fields == null || fields.isEmpty()) {
            return "";
        }
        for (String[] fieldValue : fields) {
            if (fieldValue.length != 2 || !StringUtils.isEmpty((String)fieldValue[0])) continue;
            return fieldValue[1];
        }
        return "";
    }

    public static boolean isNullAndResponse(HttpServletRequest request, HttpServletResponse response, List<String[]> fields) throws Exception {
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        for (String[] fieldValue : fields) {
            if (fieldValue.length != 2 || StringUtils.isEmpty((String)fieldValue[0]) || !StringUtils.isEmpty((String)request.getParameter(fieldValue[0]))) continue;
            AtsCommonUtile.responseError(response, fieldValue[1]);
            return true;
        }
        return false;
    }

    public static Set<String> getPersonNumFromRequest(HttpServletRequest request) {
        String personNumsStr = request.getParameter("personNums");
        if (StringUtils.isEmpty((String)personNumsStr)) {
            return null;
        }
        try {
            JSON.parse((String)request.getParameter("personNumsStr"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List personNumList = JSON.parseArray((String)personNumsStr, String.class);
        return AtsCollectionUtile.delRepeatAndEmpty(personNumList);
    }

    public static Map<String, JSONObject> getshiftTurnFromSchedule(Context ctx, Collection<String> personNums, Date postponedTo) {
        if (AtsCollectionUtile.isEmpty(personNums)) {
            return new HashMap<String, JSONObject>(0);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        StringBuffer sqlBuffer = new StringBuffer("select").append(" schedule1.fattenddate attendDate,schedule1.fshiftByTurnSegment currentSegment,person.FNumber personNum,schedule1.fatsTurnShift turnShiftId").append(" from T_HR_ATS_ScheduleShift schedule1").append(" inner join t_bd_person person on person.fid = schedule1.FProposerID").append(" where person.FNumber in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personNums)).append(" and schedule1.fattenddate=(select MAX(fattenddate) FROM T_HR_ATS_ScheduleShift schedule2").append(" where schedule1.fproposerid = schedule2.fproposerid ").append(" and schedule2.FShiftByTurnSegment is not null").append(" and schedule2.fattenddate >= {ts '").append(AtsCommonUtile.getDateFormat().format(calendar.getTime())).append("'}").append(" and schedule2.fattenddate <= {ts '").append(AtsCommonUtile.getDateFormat().format(postponedTo)).append("'})");
        HashMap<String, JSONObject> personNumToLatestSheduleTurn = new HashMap<String, JSONObject>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rowSet.next()) {
                JSONObject latestTurns = new JSONObject();
                latestTurns.put("currentSegment", (Object)rowSet.getInt("currentSegment"));
                latestTurns.put("turnShiftId", (Object)rowSet.getString("turnShiftId"));
                latestTurns.put("attendDate", (Object)rowSet.getDate("attendDate"));
                personNumToLatestSheduleTurn.put(rowSet.getString("personNum"), latestTurns);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personNumToLatestSheduleTurn;
    }
}

