/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsScheduleIntelInfo;
import com.kingdee.eas.hr.ats.AtsScheduleIntelSetInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.EMatchRule;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.workShift.ShiftTarget;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.BaseMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.LeaveBillMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchDataInfo;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchScheduleUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchShiftEnv;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.OverTimeBillMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.ShiftMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.TripBillMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.util.AttendanceLogUtil;
import com.kingdee.eas.hr.ats.workShift.save.SaveShiftUtile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MatchAnalysorManager
extends AtsCtx {
    private Set<String> errorMsg = new HashSet<String>();
    private AttendanceLogInfo attendanceLogInfo;
    private CoreBaseCollection attendanceLogEntryCollection = new CoreBaseCollection();

    public MatchAnalysorManager() {
    }

    public MatchAnalysorManager(Context ctx) {
        super(ctx);
    }

    public AttendanceLogInfo getAttendanceLogInfo() {
        return this.attendanceLogInfo;
    }

    public void setAttendanceLogInfo(AttendanceLogInfo attendanceLogInfo) {
        this.attendanceLogInfo = attendanceLogInfo;
    }

    public CoreBaseCollection getAttendanceLogEntryCollection() {
        return this.attendanceLogEntryCollection;
    }

    protected void doMatch(MatchDataInfo matchDataInfo) {
        Date preScheduleWorkOffDate = null;
        ArrayList<ScheduleShiftInfo> matchResults = new ArrayList<ScheduleShiftInfo>();
        matchDataInfo.init();
        matchDataInfo.setShifts(this.getTargetShift(matchDataInfo));
        AtsLog.getWSLog().info((Object)"all match shift\uff1a");
        AtsLog.getWSLog().info(matchDataInfo.getShifts());
        matchDataInfo.setMatchAnalysor(this.createMatchAnalysor(matchDataInfo.getMatchPlan()));
        if (AtsCollectionUtile.isEmpty(matchDataInfo.getShifts())) {
            AtsLog.getWSLog().error((Object)("th following person number can not find match shift:" + AtsCollectionUtile.join(matchDataInfo.getPersonNums())));
            this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InconformEmployeeShiftFollow, this.ctx, AtsCollectionUtile.join(matchDataInfo.getPersonNums())));
        }
        AtsLog.getWSLog().info((Object)("schdule match time range:" + AtsCommonUtile.formateTime(matchDataInfo.getBeginDate()) + "_" + AtsCommonUtile.formateTime(matchDataInfo.getEndDate())));
        AtsLog.getWSLog().info((Object)("go on match schedule to next person :" + AtsCollectionUtile.join(matchDataInfo.getPersonNums())));
        PersonCollection personCollection = AttendanceLogUtil.generatePersonColl(this.ctx, matchDataInfo.getPersonNums());
        int countPerson = 0;
        int successPerson = 0;
        for (String personNum : matchDataInfo.getPersonNums()) {
            int i;
            AttendanceLogEntryInfo attendanceLogEntryInfo;
            preScheduleWorkOffDate = null;
            CardRuleInfo preScheduleCardRule = null;
            Date currentShiftDate = (Date)matchDataInfo.getBeginDate().clone();
            ShiftTarget shiftTarget = new ShiftTarget();
            shiftTarget.setNumber(personNum);
            if (AtsCollectionUtile.isEmpty((Collection)matchDataInfo.getShifts().get(personNum))) {
                AtsLog.getWSLog().error((Object)("person number:" + personNum + " can not find match schedule!"));
                this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InconformEmployeeShift, this.ctx, personNum));
                attendanceLogEntryInfo = new AttendanceLogEntryInfo();
                attendanceLogEntryInfo.setExcepMsg(MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InconformEmployeeShift, this.ctx, personNum));
                for (i = 0; i < personCollection.size(); ++i) {
                    if (!personNum.equalsIgnoreCase(personCollection.get(i).getNumber())) continue;
                    attendanceLogEntryInfo.setPerson(personCollection.get(i));
                }
                attendanceLogEntryInfo.setGroup(this.attendanceLogInfo);
                this.attendanceLogEntryCollection.add((CoreBaseInfo)attendanceLogEntryInfo);
                continue;
            }
            while (!currentShiftDate.after(matchDataInfo.getEndDate())) {
                MatchShiftEnv matchShiftEnv = this.buildDayMatchEnv(personNum, currentShiftDate, matchDataInfo);
                matchShiftEnv.setPreScheduleWorkOffDate(preScheduleWorkOffDate);
                matchShiftEnv.setPreScheduleCardRule(preScheduleCardRule);
                matchShiftEnv.setShiftTarget(shiftTarget);
                matchDataInfo.getMatchAnalysor().setMatchShiftEnv(matchShiftEnv);
                matchDataInfo.getMatchAnalysor().analyze();
                preScheduleWorkOffDate = matchShiftEnv.getScheduleWorkOffDate();
                CardRuleInfo cardRuleInfo = preScheduleCardRule = matchShiftEnv.getSchedule() == null || matchShiftEnv.getSchedule().getMatchShift() == null ? null : matchShiftEnv.getSchedule().getMatchShift().getCardRule();
                if (matchShiftEnv.isValid()) {
                    matchResults.add(matchShiftEnv.getSchedule());
                    ++successPerson;
                } else {
                    attendanceLogEntryInfo = new AttendanceLogEntryInfo();
                    attendanceLogEntryInfo.setExcepMsg(MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InconformEmployeeShift, this.ctx, personNum));
                    for (i = 0; i < personCollection.size(); ++i) {
                        if (!personNum.equalsIgnoreCase(personCollection.get(i).getNumber())) continue;
                        attendanceLogEntryInfo.setPerson(personCollection.get(i));
                    }
                    attendanceLogEntryInfo.setAttendDate(currentShiftDate);
                    attendanceLogEntryInfo.setGroup(this.attendanceLogInfo);
                    this.attendanceLogEntryCollection.add((CoreBaseInfo)attendanceLogEntryInfo);
                }
                ++countPerson;
                currentShiftDate.setTime(currentShiftDate.getTime() + 86400000L);
            }
        }
        this.saveMatchResults(matchResults);
        if (this.attendanceLogInfo != null) {
            this.attendanceLogInfo.setSumDays(this.attendanceLogInfo.getSumDays().add(BigDecimal.valueOf(countPerson)));
            this.attendanceLogInfo.setSucessTimes(this.attendanceLogInfo.getSucessTimes().add(BigDecimal.valueOf(successPerson)));
            this.attendanceLogInfo.setFailTimes(this.attendanceLogInfo.getFailTimes().add(BigDecimal.valueOf(countPerson - successPerson)));
        }
    }

    protected BaseMatchRuleAnalysor createMatchAnalysor(AtsScheduleIntelInfo plan) {
        AtsLog.getWSLog().info((Object)("create schedule analyze according to plan:" + plan));
        AtsScheduleIntelSetInfo setInfo = plan.getAtsScheduleIntelSet();
        ShiftMatchRuleAnalysor shiftAnalysor = new ShiftMatchRuleAnalysor();
        shiftAnalysor.setCtx(this.ctx);
        shiftAnalysor.setAllowedMinusMount((long)plan.getPreTime() * 60000L);
        shiftAnalysor.setValidPunchcardInterVal((long)setInfo.getIntervalTime() * 60000L);
        shiftAnalysor.setShiftSegmentPriority(MatchScheduleUtile.getSegmentPriority(setInfo.getPunchCardShift()));
        String[] restScheduleParam = setInfo.getAtsWorkRest().getValue().split("_");
        String[] holidayScheduleParam = setInfo.getAtsLegalShift().getValue().split("_");
        shiftAnalysor.setDayTypeWhenHoliday(DayTypeEnum.getEnum(Integer.valueOf(holidayScheduleParam[0])));
        shiftAnalysor.setDayTypeWhenRest(DayTypeEnum.getEnum(Integer.valueOf(restScheduleParam[0])));
        shiftAnalysor.setRestRelateAtsShift("1".equals(restScheduleParam[1]));
        shiftAnalysor.setHolidayRelateAtsShift("1".equals(holidayScheduleParam[1]));
        shiftAnalysor.setEnableScheduleIntersect(setInfo.isSameCard());
        String[] noCardDayParam = setInfo.getNoCardDay().getValue().split("_");
        shiftAnalysor.setDayTypeWhenWork(DayTypeEnum.getEnum(Integer.valueOf(noCardDayParam[0])));
        shiftAnalysor.setShiftTypeAfterWork(setInfo.getMatchShiftType());
        shiftAnalysor.setNoCardRelateAtsShift("1".equals(noCardDayParam[1]));
        shiftAnalysor.setCardSetList(MatchScheduleUtile.getCardSet(setInfo.getIntervalCardSet()));
        OverTimeBillMatchRuleAnalysor OTBillAnalysor = new OverTimeBillMatchRuleAnalysor(shiftAnalysor);
        OTBillAnalysor.setCtx(this.ctx);
        OTBillAnalysor.setHolidayRelateAtsShift("1".equals(setInfo.getAtsShiftLegal().getValue().split("_")[1]));
        OTBillAnalysor.setRestRelateAtsShift("1".equals(setInfo.getAtsShiftRest().getValue().split("_")[1]));
        OTBillAnalysor.setRemoveShifts(plan.getIntelType() != EMatchRule.allElastic);
        LeaveBillMatchRuleAnalysor leaveBillAnalysor = new LeaveBillMatchRuleAnalysor(OTBillAnalysor);
        leaveBillAnalysor.setCtx(this.ctx);
        TripBillMatchRuleAnalysor tripBillAnalysor = new TripBillMatchRuleAnalysor(leaveBillAnalysor);
        tripBillAnalysor.setCtx(this.ctx);
        AtsLog.getWSLog().info((Object)("matchor create complete:" + tripBillAnalysor));
        return tripBillAnalysor;
    }

    protected MatchShiftEnv buildDayMatchEnv(String personNum, Date curDate, MatchDataInfo matchDataInfo) {
        MatchShiftEnv matchShiftEnv = new MatchShiftEnv();
        matchShiftEnv.setHolidayMap(matchDataInfo.getHolidayMap().get(personNum));
        if (matchDataInfo.getShifts() != null && matchDataInfo.getShifts().get(personNum) != null) {
            matchShiftEnv.setCurAtsShifts(new ArrayList<AtsShiftInfo>((Collection)matchDataInfo.getShifts().get(personNum)));
        }
        matchShiftEnv.setOTBillEntries(matchDataInfo.getOTBill().get(personNum));
        matchShiftEnv.setTripBillEntries(matchDataInfo.getTripBill().get(personNum));
        matchShiftEnv.setLeaveBillEntries(matchDataInfo.getLeaveBill().get(personNum));
        matchShiftEnv.setAttendRange(new RangeDate(AtsCommonUtile.getDayStart(curDate), AtsCommonUtile.getDayEnd(curDate)));
        matchShiftEnv.setPunchcards(this.getRecentThreeDaysPunCards(matchDataInfo, personNum, curDate));
        Integer dayTypeInt = matchShiftEnv.getHolidayMap().get(AtsCommonUtile.formateDate(curDate));
        matchShiftEnv.getSchedule().setMatchDaytype(DayTypeEnum.getEnum(dayTypeInt == null ? 0 : dayTypeInt));
        matchShiftEnv.getSchedule().setAttendDate((Date)matchShiftEnv.getAttendRange().getLowBound());
        matchShiftEnv.getSchedule().setMatchRule(matchDataInfo.getMatchPlan());
        matchShiftEnv.getSchedule().setHrOrgUnit(matchDataInfo.getMatchPlan().getAtsScheduleIntelSet().getHrOrgUnit());
        matchShiftEnv.getSchedule().setMatchPlan(matchDataInfo.getMatchPlan().getAtsScheduleIntelSet());
        matchShiftEnv.setScheduleMap(matchDataInfo.getScheduleMap());
        AtsLog.getWSLog().info((Object)matchShiftEnv);
        return matchShiftEnv;
    }

    private List<Date> getRecentThreeDaysPunCards(MatchDataInfo matchDataInfo, String personNum, Date curDate) {
        List<Date> nex;
        List<Date> now;
        Map<String, List<Date>> allPunchcard = matchDataInfo.getPunchcards().get(personNum);
        if (AtsCollectionUtile.isEmpty(allPunchcard)) {
            return null;
        }
        ArrayList<Date> curDayData = new ArrayList<Date>();
        List<Date> pre = allPunchcard.get(AtsCommonUtile.formateDate(AtsDateUtils.getPreDay(curDate)));
        if (!AtsCollectionUtile.isEmpty(pre)) {
            curDayData.addAll(pre);
        }
        if (!AtsCollectionUtile.isEmpty(now = allPunchcard.get(AtsCommonUtile.formateDate(curDate)))) {
            curDayData.addAll(now);
        }
        if (!AtsCollectionUtile.isEmpty(nex = allPunchcard.get(AtsCommonUtile.formateDate(AtsDateUtils.getNextDay(curDate))))) {
            curDayData.addAll(nex);
        }
        if (AtsCollectionUtile.isEmpty(curDayData)) {
            return null;
        }
        ArrayList<Date> returnData = new ArrayList<Date>(curDayData.size());
        AtsScheduleIntelInfo plan = matchDataInfo.getMatchPlan();
        AtsScheduleIntelSetInfo setInfo = plan.getAtsScheduleIntelSet();
        int validPunchcardInterVal = setInfo.getIntervalTime();
        for (Date date : curDayData) {
            if (returnData.size() != 0 && AtsCommonUtile.dateDiff(returnData.get(returnData.size() - 1), date, 12) <= validPunchcardInterVal) continue;
            returnData.add(date);
        }
        return returnData;
    }

    protected void saveMatchResults(List<ScheduleShiftInfo> matchResults) {
        if (AtsCollectionUtile.isEmpty(matchResults)) {
            return;
        }
        HashMap<String, ScheduleShiftInfo> noRe_matchResults = new HashMap<String, ScheduleShiftInfo>();
        HashSet<String> personNums = new HashSet<String>();
        for (ScheduleShiftInfo schedule : matchResults) {
            String personNum = schedule.getProposer().getNumber();
            personNums.add(personNum);
            String attendDate = AtsCommonUtile.formateDate(schedule.getAttendDate());
            noRe_matchResults.put(personNum + "_" + attendDate, schedule);
        }
        RangeDate dateRange = SaveShiftUtile.getRangeDate(new ArrayList<ScheduleShiftInfo>(noRe_matchResults.values()));
        AtsLog.getWSLog().error((Object)MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.SaveTimeRangeAboutShift, this.ctx, dateRange));
        AtsLog.getWSLog().info((Object)("All need save schedule:" + noRe_matchResults));
        Map<String, ScheduleShiftInfo> existsSchedule = SaveShiftUtile.getExistsSchedule(this.ctx, personNums, (Date)dateRange.getLowBound(), (Date)dateRange.getUpBound());
        ScheduleShiftCollection newColls = new ScheduleShiftCollection();
        ArrayList<Object[]> updateMatchShift = new ArrayList<Object[]>();
        ArrayList<Object[]> updateShiftItemParamsArr = new ArrayList<Object[]>();
        ArrayList<String> needDelScheduleIds = new ArrayList<String>();
        for (ScheduleShiftInfo schedule : noRe_matchResults.values()) {
            ScheduleShiftInfo curExistSchedule = existsSchedule.get(schedule.getProposer().getNumber() + "_" + schedule.getAttendDate());
            if (curExistSchedule != null) {
                if (curExistSchedule.getDefaultShift() == null && (curExistSchedule.getDayType() == null || curExistSchedule.getDayType().getValue() == 0)) {
                    if (schedule.getMatchShift() != null && !AtsCollectionUtile.isEmpty((IObjectCollection)schedule.getMatchShift().getItems())) {
                        schedule.setId(curExistSchedule.getId());
                        updateShiftItemParamsArr.addAll(SaveShiftUtile.getScheduleShiftItemParams(schedule));
                    }
                    needDelScheduleIds.add(curExistSchedule.getId().toString());
                }
                updateMatchShift.add(new Object[]{schedule.getMatchShift() == null ? "" : schedule.getMatchShift().getId().toString(), schedule.getMatchDaytype().getValue(), schedule.getMatchPlan().getId().toString(), schedule.getMatchRule().getId().toString(), curExistSchedule.getId().toString()});
                continue;
            }
            newColls.add(schedule);
        }
        AtsLog.getWSLog().info((Object)("update match schedulle: " + updateMatchShift));
        AtsLog.getWSLog().info((Object)("add new schedule:" + (Object)((Object)newColls)));
        MatchScheduleUtile.saveMatchShift(this.ctx, updateMatchShift);
        MatchScheduleUtile.saveMatchNewShift(this.ctx, newColls);
        try {
            AtsSqlUtile.deleteByIds(this.ctx, "t_hr_ats_scheduleshiftItem", "fgroupId", needDelScheduleIds);
            SaveShiftUtile.insertScheduleShiftItemsBatch(this.ctx, updateShiftItemParamsArr);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    protected Map<String, List<AtsShiftInfo>> getTargetShift(MatchDataInfo matchDataInfo) {
        EMatchRule matchRule = matchDataInfo.getMatchPlan().getIntelType();
        Date endDate = matchDataInfo.getEndDate();
        Map<String, List<AtsShiftInfo>> shifts = null;
        String hrOrgUnitId = matchDataInfo.getMatchPlan().getAtsScheduleIntelSet().getHrOrgUnit().getString("id");
        if (EMatchRule.elastic == matchRule) {
            shifts = MatchScheduleUtile.getOrgAvaiableShift(this.ctx, matchDataInfo.getPersonNums(), matchDataInfo.getBeginDate(), endDate, AtsShiftElasticType.commuteElastic);
        } else if (EMatchRule.latestSchedule == matchRule) {
            shifts = MatchScheduleUtile.getLatestAtsShift(this.ctx, matchDataInfo.getPersonNums(), this.getLatsetBeginDate(endDate, matchDataInfo), endDate, hrOrgUnitId);
        } else if (EMatchRule.latestAttGroup == matchRule) {
            shifts = MatchScheduleUtile.getLatestGroupAtsShift(this.ctx, matchDataInfo.getPersonNums(), this.getLatsetBeginDate(endDate, matchDataInfo), endDate, hrOrgUnitId);
        } else if (EMatchRule.latestOrg == matchRule) {
            shifts = MatchScheduleUtile.getLatestAdminOrgAtsShift(this.ctx, matchDataInfo.getPersonNums(), this.getLatsetBeginDate(endDate, matchDataInfo), endDate, hrOrgUnitId);
        } else if (EMatchRule.allElastic == matchRule) {
            shifts = MatchScheduleUtile.getOrgAvaiableShift(this.ctx, matchDataInfo.getPersonNums(), matchDataInfo.getBeginDate(), endDate, AtsShiftElasticType.wholeDayElastic);
        } else if (EMatchRule.userDefine == matchRule) {
            shifts = this.getUserDefinedTargetShift(matchDataInfo);
        } else if (EMatchRule.unstable == matchRule) {
            shifts = MatchScheduleUtile.getOrgAvaiableShift(this.ctx, matchDataInfo.getPersonNums(), matchDataInfo.getBeginDate(), endDate, null);
        } else if (EMatchRule.stableShift == matchRule) {
            shifts = new HashMap<String, List<AtsShiftInfo>>(matchDataInfo.getPersonNums().size());
            String selectShifts = matchDataInfo.getMatchPlan().getAtsShifts();
            if (!StringUtils.isEmpty((String)selectShifts)) {
                List<AtsShiftInfo> selectedShifs = WorkShiftUtile.getAtsShift(this.ctx, Arrays.asList(selectShifts.split(",")));
                for (String personNum : matchDataInfo.getPersonNums()) {
                    shifts.put(personNum, selectedShifs);
                }
            } else {
                AtsLog.getWSLog().error((Object)("matchPlan point shift schedule has not set shift:" + matchDataInfo.getMatchPlan()));
            }
        } else {
            AtsLog.getWSLog().error((Object)("matchPlan has no schedule source:" + matchDataInfo.getMatchPlan()));
        }
        this.validateShifts(shifts, matchDataInfo);
        return shifts;
    }

    protected void validateShifts(Map<String, List<AtsShiftInfo>> shifts, MatchDataInfo matchDataInfo) {
        if (AtsCollectionUtile.isEmpty(shifts)) {
            return;
        }
        String hrOrgId = matchDataInfo.getMatchPlan().getAtsScheduleIntelSet().getHrOrgUnit().getId().toString();
        Set<String> avaliableShiftIds = AtsSqlUtile.getOneField(this.ctx, "select fbaseInfoid from T_ATS_AtsShiftAvaliable where fhrorguseid='" + hrOrgId + "'");
        for (List<AtsShiftInfo> shiftList : shifts.values()) {
            if (AtsCollectionUtile.isEmpty(shiftList)) continue;
            for (int i = 0; i < shiftList.size(); ++i) {
                AtsShiftInfo shift = shiftList.get(i);
                if (!avaliableShiftIds.contains(shift.getId().toString())) {
                    shiftList.remove(i);
                    --i;
                    continue;
                }
                if (shift == null || AtsCollectionUtile.isEmpty((IObjectCollection)shift.getItems()) || shift.getItems().size() <= 1) continue;
                shift.getItems().sort("segment");
            }
        }
    }

    protected Date getLatsetBeginDate(Date scheduleEnd, MatchDataInfo matchDataInfo) {
        Date latestBeginDate = AtsCommonUtile.dateAdd(scheduleEnd, 6, -matchDataInfo.getMatchPlan().getWithinDate());
        return AtsCommonUtile.getDayStart(latestBeginDate);
    }

    protected Map<String, List<AtsShiftInfo>> getUserDefinedTargetShift(MatchDataInfo matchDataInfo) {
        return null;
    }
}

