/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.save;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.SegmentEnum;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapAndFitFn;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SaveShiftUtile {
    public static Map<String, AtsShiftInfo> getAtsShiftByNames(Context ctx, Set<String> shiftNames) {
        AtsShiftCollection atsShiftCollection = null;
        try {
            EntityViewInfo evi = new EntityViewInfo("select * ,items.*,otCompens.id,shiftType.id,cardRule.id");
            evi = AtsViewUtile.getViewByFilter("name", shiftNames, CompareType.INCLUDE, evi);
            atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (atsShiftCollection == null) {
            return null;
        }
        HashMap<String, AtsShiftInfo> AtsShifts = new HashMap<String, AtsShiftInfo>(atsShiftCollection.size());
        for (int i = 0; i < atsShiftCollection.size(); ++i) {
            AtsShiftInfo atsShiftInfo = atsShiftCollection.get(i);
            AtsShifts.put(atsShiftInfo.getName(), atsShiftInfo);
        }
        return AtsShifts;
    }

    public static AttendanceFileHISCollection getAttendanceFileHisShift(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId) {
        return SaveShiftUtile.getAttendanceFileHisShift(ctx, numbers, startDate, endDate, hrOrgUnitId, null);
    }

    public static AttendanceFileHISCollection getAttendanceFileHisShift(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId, String permItemId) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "proposer.id", "isAttendance", "attendFileState", "proposer.number", "proposer.name", "adminOrgUnit.id", "attAdminOrgUnit.id", "position.id", "hrOrgUnit.id", "attencePolicy.id", "atsShift.cardRule.id", "atsShift.*", "atsShift.items.*", "holidayPolicySet.id", "effdt", "leffdt"});
        String userId = CoreBaseUtile.getId(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (StringUtils.isNotEmpty((String)hrOrgUnitId)) {
            Set userHrOrgRange;
            Set set = userHrOrgRange = StringUtils.isBlank((String)permItemId) ? Collections.singleton(hrOrgUnitId) : SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permItemId);
            if (!userHrOrgRange.contains(hrOrgUnitId)) {
                return new AttendanceFileHISCollection();
            }
            AtsViewUtile.getViewByFilter("hrOrgUnit.id", (Object)hrOrgUnitId, evi);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("proposer.number", numbers, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("leffdt", (Object)AtsDateUtils.stringToShortDate(startDate), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("effdt", (Object)AtsDateUtils.stringToShortDate(endDate), CompareType.LESS_EQUALS));
        if (StringUtils.isNotBlank((String)permItemId)) {
            String adminSql = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit", (Object)adminSql, CompareType.INNER));
            filterInfo.getFilterItems().add(new FilterItemInfo("attAdminOrgUnit", (Object)adminSql, CompareType.INNER));
            filterInfo.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        }
        evi.setFilter(filterInfo);
        AttendanceFileHISCollection attFileHISColleciton = null;
        try {
            attFileHISColleciton = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attFileHISColleciton;
    }

    public static Map<String, BOSUuid> getAttendanceFileId(Context ctx, Set<String> numbers) {
        EntityViewInfo attendFileEvi = AtsViewUtile.getViewBySelector(new String[]{"id", "proposer.number"});
        attendFileEvi = AtsViewUtile.getViewByFilter("proposer.number", numbers, CompareType.INCLUDE);
        AtsViewUtile.getViewByFilter("attendFileState", (Object)"1", attendFileEvi);
        AttendanceFileCollection attendanceFileFiles = null;
        try {
            attendanceFileFiles = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(attendFileEvi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (attendanceFileFiles == null) {
            return null;
        }
        HashMap<String, BOSUuid> personNumToAttendanceFileId = new HashMap<String, BOSUuid>(attendanceFileFiles.size());
        int size = attendanceFileFiles.size();
        for (int i = 0; i < size; ++i) {
            AttendanceFileInfo fileInfo = attendanceFileFiles.get(i);
            personNumToAttendanceFileId.put(fileInfo.getProposer().getNumber(), fileInfo.getId());
        }
        return personNumToAttendanceFileId;
    }

    public static Map<String, RangeMap<Date, ScheduleShiftInfo>> getDefaultScheduleShiftFromHIS(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId) {
        return SaveShiftUtile.getDefaultScheduleShiftFromHIS(ctx, numbers, startDate, endDate, hrOrgUnitId, null);
    }

    public static Map<String, RangeMap<Date, ScheduleShiftInfo>> getDefaultScheduleShiftFromHIS(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId, String permItemId) {
        AttendanceFileHISCollection attFileHISColleciton = SaveShiftUtile.getAttendanceFileHisShift(ctx, numbers, startDate, endDate, hrOrgUnitId, permItemId);
        Map<String, BOSUuid> personNumToAttendanceFileId = SaveShiftUtile.getAttendanceFileId(ctx, numbers);
        HashMap<String, RangeMap<Date, ScheduleShiftInfo>> returnData = new HashMap<String, RangeMap<Date, ScheduleShiftInfo>>(numbers.size());
        if (AtsCollectionUtile.isEmpty((IObjectCollection)attFileHISColleciton) || AtsCollectionUtile.isEmpty(personNumToAttendanceFileId)) {
            return returnData;
        }
        AttendanceFileHISInfo hisFile = null;
        for (int i = 0; i < attFileHISColleciton.size(); ++i) {
            hisFile = attFileHISColleciton.get(i);
            String personNum = hisFile.getProposer().getNumber();
            BOSUuid uuid = personNumToAttendanceFileId.get(personNum);
            if (uuid == null) {
                System.out.println("==========during saving schedule info,personNum:" + hisFile.getProposer().getNumber() + " can not find the file in HrOrg:" + hrOrgUnitId);
                continue;
            }
            RangeMap<Date, ScheduleShiftInfo> defaultSchedule = (RangeMap<Date, ScheduleShiftInfo>)returnData.get(personNum);
            if (defaultSchedule == null) {
                defaultSchedule = new RangeMap<Date, ScheduleShiftInfo>(attFileHISColleciton.size());
                returnData.put(personNum, defaultSchedule);
            }
            hisFile = attFileHISColleciton.get(i);
            ScheduleShiftInfo scheduleInfo = new ScheduleShiftInfo();
            scheduleInfo.setProposer(hisFile.getProposer());
            scheduleInfo.setAdminOrgUnit(hisFile.getAttAdminOrgUnit());
            scheduleInfo.setPosition(hisFile.getPosition());
            scheduleInfo.setHrOrgUnit(hisFile.getHrOrgUnit());
            scheduleInfo.setAttendPolicy(hisFile.getAttencePolicy());
            scheduleInfo.setHldPlcSet(hisFile.getHolidayPolicySet());
            AtsShiftInfo atsShift = hisFile.getAtsShift();
            scheduleInfo.setDefaultShift(atsShift);
            scheduleInfo.setCardRule(atsShift == null ? null : atsShift.getCardRule());
            scheduleInfo.setOtCompens(atsShift == null ? null : atsShift.getOtCompens());
            scheduleInfo.setStandardHour(atsShift == null ? null : atsShift.getStandardHour());
            AttendanceFileInfo file = AtsCommonUtile.convertHis2File(hisFile);
            file.setId(uuid);
            scheduleInfo.setAttendFile(file);
            defaultSchedule.put(new RangeDate(file.getEFFDT(), file.getLEFFDT()), scheduleInfo);
        }
        return returnData;
    }

    public static ScheduleShiftCollection resolveToScheduleShift(Context ctx, PersonInfo personInfo, List<JSONObject> schedules, Map<String, AtsShiftInfo> atsShifts) {
        if (AtsCollectionUtile.isEmpty(schedules)) {
            return null;
        }
        ScheduleShiftCollection scheduleResult = new ScheduleShiftCollection();
        EntityObjectInfo entityObj = AtsEntityUtile.getEntityObj(ctx, ScheduleShiftInfo.class);
        for (JSONObject schedule : schedules) {
            if (!schedule.containsKey((Object)"attendDate") || !schedule.containsKey((Object)"dayType")) continue;
            if (schedule.containsKey((Object)"turnShiftId") && !schedule.containsKey((Object)"atsTurnShift")) {
                schedule.put("atsTurnShift", schedule.remove((Object)"turnShiftId"));
            }
            if (schedule.containsKey((Object)"segment") && !schedule.containsKey((Object)"shiftByTurnSegment")) {
                schedule.put("shiftByTurnSegment", schedule.remove((Object)"segment"));
            }
            String attAdminOrgUnit = (String)schedule.remove((Object)"attAdminOrgUnit");
            schedule.put("_entityName", (Object)(entityObj == null ? null : entityObj.getFullName()));
            ScheduleShiftInfo scheduleShift = (ScheduleShiftInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)schedule.toJSONString(), ScheduleShiftInfo.class);
            scheduleShift.setProposer(personInfo);
            scheduleShift.setAdvcValue(2);
            if (schedule.containsKey((Object)"shiftName") && StringUtils.isNotEmpty((String)schedule.getString("shiftName"))) {
                scheduleShift.setDefaultShift(atsShifts.get(schedule.getString("shiftName")));
            }
            SaveShiftUtile.processAttAdminField(scheduleShift, attAdminOrgUnit);
            scheduleResult.add(scheduleShift);
        }
        return scheduleResult;
    }

    public static void processAttAdminField(ScheduleShiftInfo scheduleShift, String attAdminOrgUnit) {
        if (scheduleShift.getDefaultShift() != null && StringUtils.isNotBlank((String)attAdminOrgUnit) && AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShift.getItems())) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)attAdminOrgUnit));
            int i = scheduleShift.getDefaultShift().getItems().size();
            while (i-- > 0) {
                ScheduleShiftItemInfo item = new ScheduleShiftItemInfo();
                item.setAttAdminOrgUnit(adminOrgUnitInfo);
                item.setSegment(SegmentEnum.getEnum(String.valueOf(i + 1)));
                scheduleShift.getItems().add(item);
            }
        }
    }

    public static Map<String, ScheduleShiftInfo> getExistsSchedule(Context ctx, Set<String> personNums, Date begin, Date end) {
        return SaveShiftUtile.getExistsSchedule(ctx, personNums, begin, end, null);
    }

    public static Map<String, ScheduleShiftInfo> getExistsSchedule(Context ctx, Set<String> personNums, Date begin, Date end, List<String> selector) {
        HashSet<String> seList = new HashSet<String>();
        if (selector != null) {
            seList.addAll(selector);
        }
        seList.addAll(Arrays.asList("id", "proposer.number", "attendDate", "srcType", "advcValue", "dayType", "defaultShift"));
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(seList.toArray(new String[0]));
        AtsViewUtile.getViewByFilter("proposer.number", personNums, CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("attendDate", AtsCommonUtile.getDayEnd(end), CompareType.LESS_EQUALS, evi);
        AtsViewUtile.getViewByFilter("attendDate", AtsCommonUtile.getDayStart(begin), CompareType.GREATER_EQUALS, evi);
        ScheduleShiftCollection shiftCollection = null;
        try {
            shiftCollection = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)shiftCollection)) {
            return new HashMap<String, ScheduleShiftInfo>();
        }
        HashMap<String, ScheduleShiftInfo> existSchedule = new HashMap<String, ScheduleShiftInfo>();
        ScheduleShiftInfo shiftTemp = null;
        for (int i = 0; i < shiftCollection.size(); ++i) {
            shiftTemp = shiftCollection.get(i);
            String number = shiftTemp.getProposer().getNumber();
            existSchedule.put(number + "_" + AtsCommonUtile.getDateFormat().format(shiftTemp.getAttendDate()), shiftTemp);
        }
        return existSchedule;
    }

    public static List<String> getShiftNameFromJson(Collection<JSONObject> schedules) {
        return AtsCollectionUtile.map(schedules, new AtsMapAndFitFn<JSONObject, String>(){

            @Override
            public boolean fit(JSONObject t) {
                return t.containsKey((Object)"shiftName") && StringUtils.isNotEmpty((String)t.getString("shiftName"));
            }

            @Override
            public String map(JSONObject t) {
                return t.getString("shiftName");
            }
        });
    }

    public static RangeDate getRangeDate(List<ScheduleShiftInfo> toBeSavedShift) {
        Date maxDate;
        Date minDate = maxDate = toBeSavedShift.get(0).getAttendDate();
        for (int i = 0; i < toBeSavedShift.size(); ++i) {
            if (toBeSavedShift.get(i).getAttendDate().before(minDate)) {
                minDate = toBeSavedShift.get(i).getAttendDate();
            }
            if (!toBeSavedShift.get(i).getAttendDate().after(maxDate)) continue;
            maxDate = toBeSavedShift.get(i).getAttendDate();
        }
        return new RangeDate(minDate, maxDate);
    }

    public static void insertScheduleShiftItemsBatch(Context ctx, List<Object[]> insertParamList) throws BOSException {
        StringBuffer insertShiftItemSql = new StringBuffer("insert into T_HR_ATS_ScheduleShiftItem").append("(").append(" Fid,FShiftItemID,FSegment, FPreTime,FPreFloatAdjusted,FPreUnit,FPreIsPunchCard, ").append(" FNextTime, FNextFloatAdjusted, FNextUnit, FNextIsPunchCard, FSegmentInRest, FAttendanceType,").append(" FPreTimeDayType, FNextTimeDayType, FPreDateTime, FNextDateTime, FRestPreTime, ").append(" FRestNextTime, FRestPreDateTime, FRestNextDateTime,FAttAdminOrgUnitID,FGroupID,FItemSrcType").append(")").append(" values(newbosid('4ECBA044'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (insertParamList != null && insertParamList.size() > 0) {
            DbUtile.executeBatch(ctx, insertShiftItemSql.toString(), insertParamList);
        }
    }

    public static void deleteIntersectItemWithMultiLocation(Context ctx, Collection shecheduleIds) throws BOSException {
        String delIdSql = "delete T_HR_ATS_ScheduleShiftItem where fid in( select nomulti.fid from (select FPreDateTime,FNextDateTime,FGroupID from T_HR_ATS_ScheduleShiftItem  where fismultilocation=1) multiItem join T_HR_ATS_ScheduleShiftItem nomulti on nomulti.FGroupID = multiItem.FGroupID where multiItem.FPreDateTime < nomulti.FNextDateTime and multiItem.FNextDateTime > nomulti.FPreDateTime and FGroupID in ";
        delIdSql = delIdSql + AtsCollectionUtile.joinForSql(shecheduleIds) + ")";
        DbUtil.execute((Context)ctx, (String)delIdSql);
    }

    public static void deleteScheduleItem(Context ctx, Collection shecheduleIds) throws BOSException {
        String deleteSql = "delete t_hr_ats_scheduleshiftItem where fgroupId in";
        deleteSql = deleteSql + AtsCollectionUtile.joinForSqlWithBrackets(shecheduleIds);
        DbUtil.execute((Context)ctx, (String)deleteSql);
    }

    public static Object[] getScheduleShiftParams(ScheduleShiftInfo scheduleShiftInfo, String currentUserInfo, String cu) {
        Object[] objArr = new Object[26];
        if (scheduleShiftInfo != null) {
            objArr[0] = scheduleShiftInfo.getDayType() != null ? Integer.valueOf(scheduleShiftInfo.getDayType().getValue()) : SQLType.INT;
            objArr[1] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getDefaultShift());
            objArr[2] = SaveShiftUtile.correctId(scheduleShiftInfo.getAttendFile());
            objArr[3] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getAttendPolicy());
            objArr[4] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getCardRule());
            objArr[5] = scheduleShiftInfo.getSrcType() != null ? scheduleShiftInfo.getSrcType().getValue() : null;
            objArr[6] = scheduleShiftInfo.getAdvcValue();
            objArr[7] = scheduleShiftInfo.getStandardHour() != null ? scheduleShiftInfo.getStandardHour() : Integer.valueOf(0);
            objArr[8] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getProposer());
            objArr[9] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getPosition());
            objArr[10] = currentUserInfo;
            objArr[11] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getAdminOrgUnit());
            objArr[12] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getHldPlcSet());
            objArr[13] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getShiftType());
            objArr[14] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getOtCompens());
            objArr[15] = scheduleShiftInfo.getAttendDate();
            objArr[16] = cu;
            objArr[17] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getHrOrgUnit());
            objArr[18] = scheduleShiftInfo.getShiftByTurnSegment() == 0 ? SQLType.INT : Integer.valueOf(scheduleShiftInfo.getShiftByTurnSegment());
            objArr[19] = SaveShiftUtile.correctId((DataBaseInfo)scheduleShiftInfo.getAtsTurnShift());
            objArr[20] = scheduleShiftInfo.getDefaultShift() != null && scheduleShiftInfo.getDefaultShift().isIsHalfDay() ? 1 : 0;
            objArr[21] = scheduleShiftInfo.isIsElastic() ? 1 : 0;
            objArr[22] = scheduleShiftInfo.getElasticType() == null ? SQLType.INT : Integer.valueOf(scheduleShiftInfo.getElasticType().getValue());
            objArr[23] = scheduleShiftInfo.getElasticDirection() == null ? SQLType.INT : Integer.valueOf(scheduleShiftInfo.getElasticDirection().getValue());
            objArr[24] = scheduleShiftInfo.isIsElastic() ? scheduleShiftInfo.getElasticValue() : SQLType.INT;
            objArr[25] = SaveShiftUtile.correctId(scheduleShiftInfo);
        }
        return objArr;
    }

    public static String correctId(DataBaseInfo dataBaseInfo) {
        if (dataBaseInfo == null || dataBaseInfo.getId() == null) {
            return "";
        }
        return dataBaseInfo.getId().toString();
    }

    public static List<Object[]> getScheduleShiftItemParams(ScheduleShiftInfo scheduleShiftInfo) {
        ArrayList<Object[]> shiftItemList = new ArrayList<Object[]>();
        AtsShiftItemCollection atsShiftItemCollection = null;
        if (scheduleShiftInfo.getDefaultShift() != null) {
            atsShiftItemCollection = scheduleShiftInfo.getDefaultShift().getItems();
        } else if (scheduleShiftInfo.getMatchShift() != null) {
            atsShiftItemCollection = scheduleShiftInfo.getMatchShift().getItems();
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)atsShiftItemCollection)) {
            AtsLog.getWSLog().error((Object)("no entry:" + scheduleShiftInfo));
            return shiftItemList;
        }
        Date atdt = scheduleShiftInfo.getAttendDate();
        ScheduleShiftItemCollection originalItems = scheduleShiftInfo.getItems();
        String atdtString = AtsDateUtils.dateShortToString(atdt);
        Calendar atdtNextDayCal = Calendar.getInstance();
        atdtNextDayCal.setTimeInMillis(atdt.getTime() + 86400000L);
        String atdtNextDayString = AtsCommonUtile.formateDate(atdtNextDayCal.getTime());
        Calendar atdtPreDayCal = Calendar.getInstance();
        atdtPreDayCal.setTimeInMillis(atdt.getTime() - 86400000L);
        String atdtPreDayString = AtsCommonUtile.formateDate(atdtPreDayCal.getTime());
        String preTimeStr = "";
        String preDateTimeStr = "";
        String nextTimeStr = "";
        String nextDateTimeStr = "";
        String restPreTime = "";
        for (int j = 0; j < atsShiftItemCollection.size(); ++j) {
            Object[] insertShiftItemObjArr = new Object[23];
            AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(j);
            preTimeStr = atsShiftItemInfo.getPreTime();
            int preTimeValue = atsShiftItemInfo.getPreTimeDayType().getValue();
            preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString, preTimeStr);
            int nextTimeValue = atsShiftItemInfo.getNextTimeDayType().getValue();
            nextTimeStr = atsShiftItemInfo.getNextTime();
            nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, atdtString, atdtPreDayString, atdtNextDayString, nextTimeStr);
            restPreTime = atsShiftItemInfo.getRestPreTime();
            String restNextTime = atsShiftItemInfo.getRestNextTime();
            String restPreDateTimeStr = "";
            String restNextDateTimeStr = "";
            if (!StringUtils.isEmpty((String)restPreTime) && !StringUtils.isEmpty((String)restNextTime)) {
                restPreDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restPreTime");
                restNextDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restNextTime");
            }
            insertShiftItemObjArr[0] = atsShiftItemInfo != null && atsShiftItemInfo.getId() != null ? atsShiftItemInfo.getId().toString() : "";
            insertShiftItemObjArr[1] = atsShiftItemInfo.getSegment() == null ? "" : atsShiftItemInfo.getSegment().getValue();
            insertShiftItemObjArr[2] = atsShiftItemInfo.getPreTime() == null ? "" : atsShiftItemInfo.getPreTime();
            insertShiftItemObjArr[3] = atsShiftItemInfo.getPreFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getPreFloatAdjusted().floatValue();
            insertShiftItemObjArr[4] = atsShiftItemInfo.getPreUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getPreUnit().getValue());
            insertShiftItemObjArr[5] = atsShiftItemInfo.getPreIsPunchCard() == null ? "" : atsShiftItemInfo.getPreIsPunchCard().getValue();
            insertShiftItemObjArr[6] = atsShiftItemInfo.getNextTime() == null ? "" : atsShiftItemInfo.getNextTime();
            insertShiftItemObjArr[7] = atsShiftItemInfo.getNextFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getNextFloatAdjusted().floatValue();
            insertShiftItemObjArr[8] = atsShiftItemInfo.getNextUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getNextUnit().getValue());
            insertShiftItemObjArr[9] = atsShiftItemInfo.getNextIsPunchCard() == null ? "" : atsShiftItemInfo.getNextIsPunchCard().getValue();
            insertShiftItemObjArr[10] = atsShiftItemInfo.getSegmentInRest() == null ? Integer.valueOf(0) : atsShiftItemInfo.getSegmentInRest();
            insertShiftItemObjArr[11] = atsShiftItemInfo.getAttendanceType() == null ? "" : atsShiftItemInfo.getAttendanceType().getValue();
            insertShiftItemObjArr[12] = atsShiftItemInfo.getPreTimeDayType().getValue();
            insertShiftItemObjArr[13] = atsShiftItemInfo.getNextTimeDayType().getValue();
            insertShiftItemObjArr[14] = StringUtils.isNotEmpty((String)preDateTimeStr) ? AtsCommonUtile.toTimestamp(preDateTimeStr) : SQLType.DATETIME;
            insertShiftItemObjArr[15] = StringUtils.isNotEmpty((String)nextDateTimeStr) ? AtsCommonUtile.toTimestamp(nextDateTimeStr) : SQLType.DATETIME;
            insertShiftItemObjArr[16] = restPreTime == null ? "" : restPreTime;
            insertShiftItemObjArr[17] = restNextTime == null ? "" : restNextTime;
            insertShiftItemObjArr[18] = StringUtils.isNotEmpty((String)restPreDateTimeStr) ? AtsCommonUtile.toTimestamp(restPreDateTimeStr) : SQLType.DATETIME;
            insertShiftItemObjArr[19] = StringUtils.isNotEmpty((String)restNextDateTimeStr) ? AtsCommonUtile.toTimestamp(restNextDateTimeStr) : SQLType.DATETIME;
            insertShiftItemObjArr[20] = CoreBaseUtile.getId(SaveShiftUtile.getItemAttAdmin(scheduleShiftInfo, atsShiftItemInfo.getSegment()));
            insertShiftItemObjArr[21] = scheduleShiftInfo != null && scheduleShiftInfo.getId() != null ? scheduleShiftInfo.getId().toString() : "";
            insertShiftItemObjArr[22] = scheduleShiftInfo != null && scheduleShiftInfo.getSrcType() == SchlShiftSrcTypeEnum.storeSchShift ? 1 : 0;
            shiftItemList.add(insertShiftItemObjArr);
        }
        return shiftItemList;
    }

    public static AdminOrgUnitInfo getItemAttAdmin(ScheduleShiftInfo scheduleShiftInfo, SegmentEnum segmentEnum) {
        ScheduleShiftItemCollection items = scheduleShiftInfo.getItems();
        if (items != null && segmentEnum != null) {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                boolean useSegment = segmentEnum.equals((Object)items.get(i).getSegment());
                if (!useSegment || items.get(i).getAttAdminOrgUnit() == null) continue;
                return items.get(i).getAttAdminOrgUnit();
            }
        }
        return scheduleShiftInfo.getAdminOrgUnit();
    }
}

