/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.baseconfig.IStructureConfig;
import com.kingdee.shr.baseconfig.IStructureConfigColumns;
import com.kingdee.shr.baseconfig.IStructureConfigFilterColumn;
import com.kingdee.shr.baseconfig.PropertyTypeEnum;
import com.kingdee.shr.baseconfig.StructureConfigChangeCollection;
import com.kingdee.shr.baseconfig.StructureConfigChangeInfo;
import com.kingdee.shr.baseconfig.StructureConfigChangeState;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeCollection;
import com.kingdee.shr.baseconfig.StructureConfigSchemeFactory;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import com.kingdee.shr.baseconfig.app.AbstractStructureConfigChangeControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StructureConfigChangeControllerBean
extends AbstractStructureConfigChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.baseconfig.app.StructureConfigChangeControllerBean");

    @Override
    protected void _changeLevelUp(Context ctx) throws BOSException, EASBizException {
        Map<String, List<StructureConfigChangeInfo>> needHandlerMap = this.getMappingStructureConfigChangeInfo(ctx);
        if (null == needHandlerMap) {
            return;
        }
        StructureConfigSchemeCollection coll = StructureConfigSchemeFactory.getLocalInstance(ctx).getStructureConfigSchemeCollection();
        IStructureConfig iStructureConfig = StructureConfigFactory.getLocalInstance(ctx);
        IStructureConfigColumns iStructureConfigColumns = StructureConfigColumnsFactory.getLocalInstance(ctx);
        IStructureConfigFilterColumn iStructureConfigFilterColumn = StructureConfigFilterColumnFactory.getLocalInstance(ctx);
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            StructureConfigSchemeInfo schemeModel = coll.get(i);
            this.handler(ctx, iStructureConfig, iStructureConfigColumns, iStructureConfigFilterColumn, schemeModel, needHandlerMap);
        }
        for (Map.Entry<String, List<StructureConfigChangeInfo>> entry : needHandlerMap.entrySet()) {
            List<StructureConfigChangeInfo> handlerList = entry.getValue();
            for (StructureConfigChangeInfo changeModel : handlerList) {
                this.enable(ctx, changeModel.getId().toString());
            }
        }
    }

    private void handler(Context ctx, IStructureConfig iStructureConfig, IStructureConfigColumns iStructureConfigColumns, IStructureConfigFilterColumn iStructureConfigFilterColumn, StructureConfigSchemeInfo schemeModel, Map<String, List<StructureConfigChangeInfo>> needHandlerMap) throws BOSException, EASBizException {
        for (Map.Entry<String, List<StructureConfigChangeInfo>> entry : needHandlerMap.entrySet()) {
            String sFullName = entry.getKey();
            List<StructureConfigChangeInfo> handlerList = entry.getValue();
            StructureConfigCollection coll = iStructureConfig.getStructureConfigCollection(this.getEntityViewInfo(schemeModel.getId().toString(), sFullName));
            if (null == coll || coll.size() <= 0) continue;
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                StructureConfigInfo model = coll.get(i);
                this.doHandler(ctx, iStructureConfig, iStructureConfigColumns, iStructureConfigFilterColumn, model, handlerList);
            }
        }
    }

    private EntityViewInfo getEntityViewInfo(String schemeId, String entityFullName) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EntityName", (Object)entityFullName, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private void doHandler(Context ctx, IStructureConfig iStructureConfig, IStructureConfigColumns iStructureConfigColumns, IStructureConfigFilterColumn iStructureConfigFilterColumn, StructureConfigInfo model, List<StructureConfigChangeInfo> handlerList) throws BOSException, EASBizException {
        for (StructureConfigChangeInfo changeModel : handlerList) {
            if (PropertyTypeEnum.ownProperty.equals((Object)changeModel.getPropertyType())) {
                this.doStructureConfigColumnsHandler(ctx, iStructureConfig, iStructureConfigColumns, model, changeModel);
                continue;
            }
            this.doStructureConfigHandler(ctx, iStructureConfig, iStructureConfigFilterColumn, model, changeModel);
        }
    }

    private void doStructureConfigColumnsHandler(Context ctx, IStructureConfig iStructureConfig, IStructureConfigColumns iStructureConfigColumns, StructureConfigInfo model, StructureConfigChangeInfo changeModel) throws BOSException, EASBizException {
        StructureConfigColumnsCollection coll = model.getColumns();
        StructureConfigCollection tcoll = iStructureConfig.getStructureConfigCollection(this.getEntityViewInfo(model.getScheme().getId().toString(), changeModel.getTFullEntityName()));
        if (coll == null || coll.size() <= 0) {
            return;
        }
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            StructureConfigColumnsInfo columnInfo = coll.get(i);
            if (!changeModel.getSPropertyName().equals(columnInfo.getNumber())) continue;
            StructureConfigInfo oldStructureConfigInfo = tcoll.get(0);
            boolean isExist = false;
            if (model.getColumns() != null && model.getColumns().size() > 0) {
                int stotal = model.getColumns().size();
                for (int j = 0; j < stotal; ++j) {
                    StructureConfigColumnsInfo newColumnInfo = coll.get(j);
                    if (!changeModel.getTPropertyName().equals(newColumnInfo.getNumber())) continue;
                    isExist = true;
                }
            }
            if (isExist) continue;
            StructureConfigColumnsInfo updateModel = new StructureConfigColumnsInfo();
            updateModel.setId(columnInfo.getId());
            updateModel.setStructureConfig(oldStructureConfigInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("structureConfig.id"));
            if (!changeModel.getSPropertyName().equals(changeModel.getTPropertyName())) {
                updateModel.setNumber(changeModel.getTPropertyName());
                selector.add(new SelectorItemInfo("number"));
            }
            iStructureConfigColumns.updatePartial(updateModel, selector);
        }
    }

    private void doStructureConfigHandler(Context ctx, IStructureConfig iStructureConfig, IStructureConfigFilterColumn iStructureConfigFilterColumn, StructureConfigInfo model, StructureConfigChangeInfo changeModel) throws BOSException, EASBizException {
        StructureConfigCollection tcoll = iStructureConfig.getStructureConfigCollection(this.getEntityViewInfo(model.getScheme().getId().toString(), changeModel.getTFullEntityName()));
        StructureConfigInfo newStructureConfigInfo = tcoll.get(0);
        if (null == newStructureConfigInfo) {
            return;
        }
        if (!model.getParent().getId().toString().equals(newStructureConfigInfo.getId().toString())) {
            StructureConfigInfo updateModel = new StructureConfigInfo();
            updateModel.setId(model.getId());
            updateModel.setParent(newStructureConfigInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("parent.id"));
            iStructureConfig.updatePartial((CoreBaseInfo)updateModel, selector);
        }
    }

    private Map<String, List<StructureConfigChangeInfo>> getMappingStructureConfigChangeInfo(Context ctx) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)10, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        StructureConfigChangeCollection coll = this.getStructureConfigChangeCollection(ctx, view);
        if (null == coll || coll.size() <= 0) {
            return null;
        }
        HashMap<String, List<StructureConfigChangeInfo>> map = new HashMap<String, List<StructureConfigChangeInfo>>();
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            StructureConfigChangeInfo model = coll.get(i);
            ArrayList list = (ArrayList)map.get(model.getSFullEntityName());
            if (null == list) {
                list = new ArrayList();
                map.put(model.getSFullEntityName(), list);
            }
            ((List)map.get(model.getSFullEntityName())).add(model);
        }
        return map;
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.doEnable(ctx, id, StructureConfigChangeState.DONE);
    }

    private void doEnable(Context ctx, String id, StructureConfigChangeState state) throws BOSException, EASBizException {
        StructureConfigChangeInfo model = new StructureConfigChangeInfo();
        model.setId(BOSUuid.read((String)id));
        model.setState(state);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        this.updatePartial(ctx, (CoreBaseInfo)model, selector);
    }
}

