/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.service.api.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ShrSqlEnum;
import com.kingdee.eas.hr.base.app.filter.FilterConstant;
import com.kingdee.eas.hr.base.app.filter.SqlGenerateUtils;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.LinkType;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.QueryConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.AbstractSHRSqlBuilder;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CommonSHRSqlBuilder
extends AbstractSHRSqlBuilder {
    private static Logger logger = Logger.getLogger(CommonSHRSqlBuilder.class);

    @Override
    protected String assembleSQLFrom() throws EASBizException, BOSException {
        int i;
        long begin = System.currentTimeMillis();
        HashMap<String, HistoryGeneratorParam> hisParamMap = new HashMap<String, HistoryGeneratorParam>();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain(this.ctx, this.param.getScheme());
        StringBuffer sql = new StringBuffer();
        ArrayList<String> tempLeft = new ArrayList<String>();
        StructureConfigCollection relateConfigColl = this.getRelateStructureConfig(main);
        StructureConfigCollection structureConfigColl = (StructureConfigCollection)((Object)relateConfigColl.clone());
        HashMap<String, StructureConfigInfo> alreadyProcessMap = new HashMap<String, StructureConfigInfo>();
        this.processFirstTable(hisParamMap, main, alreadyProcessMap, sql);
        StructureConfigInfo info = null;
        for (i = 0; i < structureConfigColl.size(); ++i) {
            info = structureConfigColl.get(i);
            if (alreadyProcessMap.containsKey(info.getId().toString())) continue;
            this.processEachNode(tempLeft, info, alreadyProcessMap, hisParamMap);
        }
        int size = tempLeft.size();
        for (i = 0; i < size; ++i) {
            this.assembleSQLFromReal(((String)tempLeft.get(i)).toString(), sql);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("assembleSQLFrom cost:" + (end - begin)));
        }
        return sql.toString();
    }

    protected void assembleSQLFromReal(String eachTable, StringBuffer sql) throws EASBizException, BOSException {
        sql.append(eachTable);
    }

    private StructureConfigCollection getRelateStructureConfig(StructureConfigInfo main) throws EASBizException, BOSException {
        int i;
        StructureConfigCollection relateColl = this.getAllTableInfo();
        relateColl.add(main);
        Map<String, StructureConfigInfo> allParentMap = this.initParentMap(relateColl, main);
        ArrayList<StructureConfigInfo> addList = new ArrayList<StructureConfigInfo>();
        for (i = 0; i < relateColl.size(); ++i) {
            for (StructureConfigInfo parentInfo = relateColl.get(i).getParent(); parentInfo != null && !allParentMap.containsKey(parentInfo.getId().toString()); parentInfo = parentInfo.getParent()) {
                parentInfo = StructureConfigConvertHelper.getStructureConfigByID(this.ctx, parentInfo.getId().toString(), this.param.getScheme());
                addList.add(parentInfo);
                allParentMap.put(parentInfo.getId().toString(), parentInfo);
            }
        }
        for (i = 0; i < addList.size(); ++i) {
            relateColl.add((StructureConfigInfo)addList.get(i));
        }
        return relateColl;
    }

    private StructureConfigCollection getAllTableInfo() throws EASBizException, BOSException {
        StructureConfigInfo structureConfigByKey;
        StructureConfigCollection tableCollection = new StructureConfigCollection();
        for (Map.Entry<String, String> entry : this.param.getSelectMapping().entrySet()) {
            structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, entry.getKey(), this.param.getScheme());
            if (structureConfigByKey == null) continue;
            tableCollection.add(structureConfigByKey);
        }
        for (int i = 0; i < this.param.getFilterInfo().getFilterItems().size(); ++i) {
            structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, this.param.getFilterInfo().getFilterItems().get(i).getPropertyName(), this.param.getScheme());
            if (structureConfigByKey == null) continue;
            tableCollection.add(structureConfigByKey);
        }
        if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
            this.afterGetAllTableInfoForReport(tableCollection);
        }
        return tableCollection;
    }

    private Map<String, StructureConfigInfo> initParentMap(StructureConfigCollection relateColl, StructureConfigInfo main) throws EASBizException, BOSException {
        HashMap<String, StructureConfigInfo> allParentMap = new HashMap<String, StructureConfigInfo>();
        StructureConfigInfo tempParentInfo = null;
        StructureConfigInfo parentInfo = StructureConfigConvertHelper.getMain(this.ctx, this.param.getScheme());
        int total = relateColl.size();
        for (int i = 0; i < total; ++i) {
            allParentMap.put(relateColl.get(i).getId().toString(), relateColl.get(i));
        }
        boolean flag = true;
        do {
            if (parentInfo.getParent() != null) {
                if (allParentMap.containsKey((parentInfo = parentInfo.getParent()).getId().toString())) {
                    flag = false;
                    break;
                }
                if (this.getInfoFromCollByKey((IObjectCollection)relateColl, parentInfo.getId().toString()) != null) {
                    tempParentInfo = StructureConfigConvertHelper.getStructureConfigByID(this.ctx, main.getParent().getId().toString(), this.param.getScheme());
                    while (!tempParentInfo.getId().equals((Object)parentInfo.getId())) {
                        relateColl.add(tempParentInfo);
                        tempParentInfo = StructureConfigConvertHelper.getStructureConfigByID(this.ctx, tempParentInfo.getParent().getId().toString(), this.param.getScheme());
                    }
                }
                allParentMap.put(parentInfo.getId().toString(), StructureConfigConvertHelper.getStructureConfigByID(this.ctx, parentInfo.getId().toString(), this.param.getScheme()));
                continue;
            }
            flag = false;
        } while (flag);
        return allParentMap;
    }

    private void processFirstTable(Map<String, HistoryGeneratorParam> hisParamMap, StructureConfigInfo mainConfig, Map<String, StructureConfigInfo> alreadyProcessMap, StringBuffer sql) throws EASBizException, BOSException {
        sql.append(this.generateFromSql(mainConfig, null, hisParamMap));
        alreadyProcessMap.put(mainConfig.getId().toString(), mainConfig);
        hisParamMap.put(mainConfig.getId().toString(), this.getHisParam(mainConfig));
    }

    private StringBuffer generateFromSql(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        String tableName = this.getTableName(configInfo, this.param.isHistoryMode());
        StringBuffer sql = new StringBuffer();
        if (relateInfo == null) {
            sql.append(this.getTableNameAndAlias(configInfo, tableName));
        } else if (LinkType.INNER.equals((Object)relateInfo.getLinkType())) {
            this.appendInnerJoin(sql, this.getTableNameAndAlias(configInfo, tableName), this.getFromOnSql(configInfo, relateInfo, hisParamMap));
        } else {
            this.appendLeftJoin(sql, this.getTableNameAndAlias(configInfo, tableName), this.getFromOnSql(configInfo, relateInfo, hisParamMap));
        }
        if ("T_ORG_ADMINHIS".equalsIgnoreCase(tableName)) {
            String adminAlias = this.getQuoTableAlias(configInfo);
            String adminTAlias = this.appendQuo(this.getTableAlias(configInfo) + "T");
            this.appendLeftJoin(sql, new StringBuffer("T_ORG_ADMINORGTREEHIS").append(" AS ").append(adminTAlias), this.generateAdminHis(configInfo, adminAlias, adminTAlias));
        }
        return sql;
    }

    protected void recordArchivesInfo(EntityObjectInfo clientEntity, StructureConfigInfo configInfo) {
        String isShrDefaultMange = clientEntity.getExtendedProperty("isShrDefaultMange");
        if (!StringUtils.isEmpty((String)isShrDefaultMange)) {
            PropertyInfo propertyInfo = clientEntity.getPropertyByName(isShrDefaultMange);
            this.permissFields.put("defaultManage", this.appendQuo(configInfo.getClientNumber().toUpperCase()) + "." + propertyInfo.getMappingField().getName());
        }
    }

    protected void recordOrgInfo(EntityObjectInfo clientEntity, StructureConfigInfo clientInfo, String clientField, String leftJoinField) {
        if ("com.kingdee.eas.basedata.org.app.HROrgUnit".equals(clientEntity.getFullName()) && "FID".equals(clientField)) {
            this.permissFields.put("hr", leftJoinField);
        } else if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(clientEntity.getFullName()) && "FID".equals(clientField)) {
            this.permissFields.put("admin", leftJoinField);
        }
    }

    protected StringBuffer getFromOnSql(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        String multi;
        StringBuffer sql = new StringBuffer();
        StructureConfigInfo clientInfo = this.getClientInfo(configInfo, relateInfo);
        EntityObjectInfo clientEntity = this.getEntityObject(clientInfo.getEntityName());
        EntityObjectInfo parentEntity = this.getEntityObject(clientInfo.getParent().getEntityName());
        this.recordArchivesInfo(clientEntity, clientInfo);
        int total = clientInfo.getFilterColumn().size();
        for (int i = 0; i < total; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            String clientField = this.getRelationFieldTableColumn(clientEntity, configInfo.getFilterColumn().get(i).getClientColumn(), configInfo.getFilterColumn().get(i).getClientColumnAlias());
            StringBuffer client = new StringBuffer();
            this.appendAliasQueAndFiled(client, this.getTableAlias(clientInfo), clientField);
            String leftJoinField = this.getColumnHisotryName(this.historyReplayColumn, client.toString());
            sql.append(leftJoinField);
            this.recordOrgInfo(clientEntity, clientInfo, clientField, leftJoinField);
            if (clientInfo.getFilterColumn().get(i).getCompareType() == null || clientInfo.getFilterColumn().get(i).getCompareType().getValue() == null) {
                sql.append(" = ");
            } else {
                sql.append(clientInfo.getFilterColumn().get(i).getCompareType().getValue());
            }
            if (clientInfo.getFilterColumn().get(i).getParentColumn() != null) {
                String parentField = this.getQuoTableAlias(clientInfo.getParent()) + "." + this.getRelationFieldTableColumn(parentEntity, clientInfo.getFilterColumn().get(i).getParentColumn(), configInfo.getFilterColumn().get(i).getParentColumnAlias());
                sql.append(this.getColumnHisotryName(this.historyReplayColumn, parentField.toUpperCase()));
                continue;
            }
            String fixValue = clientInfo.getFilterColumn().get(i).getFixValue();
            if ("@baseDate".equalsIgnoreCase(fixValue)) {
                fixValue = this.getValueStringOnly(this.param.getFilterDate());
            }
            sql.append(fixValue);
        }
        if (this.isNeedHistory(hisParamMap.get(clientInfo.getId().toString()), clientEntity, clientInfo) && this.param.isHistoryMode() && (clientInfo.isNowDateFilter() || StringUtils.isEmpty((String)clientInfo.getSingleCondition()))) {
            if (clientInfo.isNowDateFilter() && !StringUtils.isEmpty((String)clientInfo.getSingleCondition())) {
                this.addSingleCondition(clientInfo, sql);
            } else {
                this.hisModleHandlerDateFilter(clientInfo, sql);
            }
        }
        String tableAlias = this.getTableAlias(clientInfo);
        if (this.param.getInfoCtr().containsKey(tableAlias) && "true".equals(multi = this.param.getInfoCtr().get(tableAlias)) && !clientInfo.isNowDateFilter() && clientInfo.isMultiRow() && clientInfo.isSupportSingleView() && !StringUtils.isEmpty((String)clientInfo.getSingleCondition())) {
            this.addSingleCondition(clientInfo, sql);
        }
        if ("com.kingdee.eas.hr.base.app.EmpPosOrgRelation".equals(configInfo.getEntityName()) && "true".equals(this.param.getInfoCtr().get("isLatestInAday".toUpperCase()))) {
            sql.append(" AND ").append(this.getQuoTableAlias(clientInfo)).append(".").append("FIsLatestInAday = 1");
        }
        return sql;
    }

    protected void hisModleHandlerDateFilter(StructureConfigInfo clientInfo, StringBuffer sql) {
        String dateValue = "{ts '" + DateTimeUtils.format((Date)this.param.getFilterDate(), (String)"yyyy-MM-dd HH:mm:ss") + "'}";
        this.appendCommonJoinOnCondition(" AND ", sql, this.getQuoTableAlias(clientInfo), HistoryConstant.EFFDTCol.toUpperCase(), " <= ", null, dateValue);
        this.appendCommonJoinOnCondition(" AND ", sql, this.getQuoTableAlias(clientInfo), HistoryConstant.LEFFDTCol.toUpperCase(), " >= ", null, dateValue);
    }

    protected boolean isNeedHistory(HistoryGeneratorParam hisParam, EntityObjectInfo clientEntity, StructureConfigInfo clientInfo) {
        String hisEntity = clientEntity.getExtendedProperty(HistoryConstant.hisEntity);
        String enableHistory = clientEntity.getExtendedProperty(HistoryConstant.enableHistoryFlag);
        boolean entityHistory = Boolean.FALSE;
        if (!StringUtils.isEmpty((String)hisEntity) && !StringUtils.isEmpty((String)enableHistory) && "true".equals(enableHistory)) {
            EntityObjectInfo hisEntityObject = this.getEntityObject(hisEntity);
            try {
                OwnPropertyInfo effdt = (OwnPropertyInfo)hisEntityObject.getPropertyByNameRuntime(HistoryConstant.EFFDT);
                OwnPropertyInfo leffdt = (OwnPropertyInfo)hisEntityObject.getPropertyByNameRuntime(HistoryConstant.LEFFDT);
                if (null != effdt && null != leffdt && HistoryConstant.EFFDTCol.equals(effdt.getMappingField().getName()) && HistoryConstant.LEFFDTCol.equals(leffdt.getMappingField().getName())) {
                    entityHistory = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)clientEntity.getExtendedProperty("shrHisEntity"))) {
            return Boolean.TRUE;
        }
        return hisParam.isNeedHisFilter() && clientEntity.isNeedHistory() || entityHistory;
    }

    private StructureConfigInfo getClientInfo(StructureConfigInfo configInfo, StructureConfigInfo relateInfo) {
        if (configInfo.getParent() != null && configInfo.getParent().getId().equals((Object)relateInfo.getId())) {
            configInfo.setParent(relateInfo);
            return configInfo;
        }
        relateInfo.setParent(configInfo);
        return relateInfo;
    }

    protected void addSingleCondition(StructureConfigInfo clientInfo, StringBuffer sql) throws EASBizException, BOSException {
        StringBuffer fromCond;
        String filterCond = clientInfo.getSingleCondition();
        FilterInfo filterInfo = null;
        if (StringUtils.isEmpty((String)filterCond)) {
            return;
        }
        try {
            filterInfo = new FilterInfo(filterCond);
        }
        catch (ParserException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0 && (fromCond = this.getFromClause(filterInfo, clientInfo)).length() > 0) {
            sql.append(" AND ").append(fromCond);
        }
    }

    private StringBuffer getFromClause(FilterInfo filterInfo, StructureConfigInfo clientInfo) throws EASBizException, BOSException {
        int i;
        StringBuffer whereSql = new StringBuffer("");
        int filtersCount = filterInfo.getFilterItems().size();
        if (filtersCount <= 0) {
            return whereSql;
        }
        String format = filterInfo.getMaskString();
        if (!StringUtils.isEmpty((String)format)) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            StringBuffer filter = new StringBuffer("");
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            Object value = filterItemInfo.getCompareValue();
            if (value != null && FilterConstant.DATEFILTER.equalsIgnoreCase(value.toString())) {
                value = this.param.getFilterDate();
            }
            CompareType type = filterItemInfo.getCompareType();
            String[] propertyNames = null;
            String propertyName = null;
            if (filterItemInfo.getPropertyName().contains(".")) {
                propertyNames = filterItemInfo.getPropertyName().split("\\.");
                propertyName = propertyNames[1];
            } else {
                propertyName = filterItemInfo.getPropertyName();
            }
            PropertyInfo propInfo = this.getPropertyInfo(clientInfo, propertyName);
            if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                filter.append(this.getColumnName(clientInfo, propertyName));
            }
            if (filterItemInfo.isCompareValueIsProperty()) {
                filter.append(filterItemInfo.getCompareExpression());
                String propertyValue = filterItemInfo.getCompareValue().toString();
                StructureConfigInfo propertyConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, propertyValue, this.param.getScheme());
                if (propertyValue.contains(".")) {
                    propertyValue = propertyValue.split("\\.")[1];
                }
                filter.append(this.getColumnName(propertyConfigInfo, propertyValue));
            } else {
                this.appendClouse(filter, value, type, filterItemInfo, propInfo);
            }
            if (StringUtils.isEmpty((String)format)) {
                whereSql.append(filter);
                if (i >= filtersCount - 1) continue;
                whereSql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
        }
        if (format != null) {
            whereSql.append(format);
        }
        return whereSql;
    }

    private StringBuffer getTableNameAndAlias(StructureConfigInfo configInfo, String tableName) {
        StringBuffer sql = new StringBuffer();
        String tableAlias = this.getQuoTableAlias(configInfo);
        tableAlias = tableAlias.toUpperCase();
        if (this.isNeedHistory(configInfo) && this.param.isHistoryMode()) {
            this.historyReplayColumn.put(tableAlias + ".FID", tableAlias + ".F" + HistoryConstant.historyRelateID);
        }
        sql.append(" ").append(tableName).append(" AS ").append(tableAlias);
        return sql;
    }

    private boolean isNeedHistory(StructureConfigInfo configInfo) {
        EntityObjectInfo objectInfo = this.getEntityObject(configInfo.getEntityName());
        return this.isHistoryEntity(objectInfo);
    }

    private void processEachNode(List<String> tempLeft, StructureConfigInfo structureConfigInfo, Map<String, StructureConfigInfo> alreadyProcessMap, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        StructureConfigInfo parentInfo = null;
        if (null != structureConfigInfo.getParent()) {
            parentInfo = StructureConfigConvertHelper.getStructureConfigByID(this.ctx, structureConfigInfo.getParent().getId().toString(), this.param.getScheme());
        }
        if (parentInfo == null) {
            throw new BOSException(structureConfigInfo.getAlias() + " parentnode is null,please set");
        }
        if (!alreadyProcessMap.containsKey(parentInfo.getId().toString())) {
            this.processEachNode(tempLeft, parentInfo, alreadyProcessMap, hisParamMap);
        }
        this.processNode(tempLeft, alreadyProcessMap, structureConfigInfo, parentInfo, hisParamMap);
    }

    private void processNode(List<String> tempLeft, Map<String, StructureConfigInfo> alreadyProcessMap, StructureConfigInfo clientInfo, StructureConfigInfo parentInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        this.handleSingleViewValue(clientInfo);
        alreadyProcessMap.put(clientInfo.getId().toString(), clientInfo);
        this.prepareHisparam(hisParamMap, clientInfo, parentInfo);
        String tempStr = this.generateFromSql(clientInfo, parentInfo, hisParamMap).toString();
        int size = tempLeft.size();
        for (int i = 0; i < size; ++i) {
            if (!tempLeft.get(i).toString().contains("\"" + clientInfo.getClientNumber().toUpperCase() + "\"")) continue;
            tempLeft.add(i, tempStr);
            break;
        }
        if (!tempLeft.contains(tempStr)) {
            tempLeft.add(tempStr);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processNode cost:" + (end - begin) + ", tempStr:" + tempStr));
        }
    }

    private void prepareHisparam(Map<String, HistoryGeneratorParam> hisParamMap, StructureConfigInfo currentInfo, StructureConfigInfo parentInfo) {
        HistoryGeneratorParam parentParam = hisParamMap.get(parentInfo.getId().toString());
        HistoryGeneratorParam clientParam = null;
        if (parentParam.isNeedHisFilter()) {
            clientParam = new HistoryGeneratorParam();
            clientParam.setRelateColumn(parentParam.getRelateColumn());
            clientParam.setRelateColumnFieldName(parentParam.getRelateColumnFieldName());
            clientParam.setRelateTalbe(parentParam.getRelateTalbe());
        } else {
            clientParam = this.getHisParam(currentInfo);
        }
        hisParamMap.put(currentInfo.getId().toString(), clientParam);
    }

    protected void handleSingleViewValue(StructureConfigInfo info) {
        Map<String, String> infoCtrl;
        if (info.isMultiRow() && info.isSupportSingleView() && !(infoCtrl = this.param.getInfoCtr()).containsKey(info.getClientNumber().toUpperCase())) {
            infoCtrl.put(info.getClientNumber().toUpperCase(), Boolean.TRUE.toString());
        }
    }

    protected boolean isNeedDistinct() {
        return this.param.isNeedDistinct();
    }

    @Override
    protected String assembleSQLSelect() throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        if (this.isNeedDistinct()) {
            sql.append("DISTINCT ");
        }
        String column = null;
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.param.getSelectMapping().entrySet()) {
            column = this.param.getGroupType() != null ? this.generateOneColumn2(entry.getKey(), entry.getValue()) : this.generateOneColumn(entry.getKey(), entry.getValue());
            if (StringUtils.isEmpty((String)column)) continue;
            if (isFirst) {
                sql.append(column);
                isFirst = false;
                continue;
            }
            sql.append(",").append("\n").append(column);
        }
        sql.append("\n");
        if (this.param.isNeedGropBy()) {
            this.appendCount(sql);
        }
        SqlGenerateUtils.clearLaborCostTypeQueryFieldLeafList();
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("assembleSQLSelect cost:" + (end - begin)));
        }
        return sql.toString();
    }

    protected String generateOneColumn(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        boolean isBigDataType = false;
        StringBuffer selectColumnString = new StringBuffer();
        StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber(this.ctx, keys[0], scheme);
        if (configInfo == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)keys[1]) && StringUtils.isEmpty((String)configInfo.getEntityName())) {
            throw new BaseConfigException(BaseConfigException.TABLENAMEANDCOLUMNNAMENULL);
        }
        PropertyInfo prop = this.getPropertyInfo(configInfo, keys[1]);
        if (this.param.isNeedDistinct()) {
            isBigDataType = this.isBigDataType(configInfo, column);
        }
        ArrayList<String> allLocales = new ArrayList<String>();
        allLocales.add(LocaleUtils.locale_l1.getDisplayName());
        allLocales.add(LocaleUtils.locale_l2.getDisplayName());
        allLocales.add(LocaleUtils.locale_l3.getDisplayName());
        if (this.param.isHistoryMode() && column.toUpperCase().contains("LONGNUMBER") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            this.appendQueAdminHis(selectColumnString, configInfo, "T", "FLongNumber", alias);
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("DISPLAYNAME") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), alias);
            } else if (StringUtils.isEmpty((String)this.param.getMultiLanLocale()) || this.ctx.getLocale().getDisplayName().equalsIgnoreCase(this.param.getMultiLanLocale())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
            } else if ("all".equalsIgnoreCase(this.param.getMultiLanLocale())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
                for (String locale : allLocales) {
                    selectColumnString.append(",").append("\n");
                    this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", locale), MessageFormat.format("{0}_{1}", alias, locale));
                }
            } else {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.param.getMultiLanLocale()), alias);
            }
        } else if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual()) {
            if (StringUtils.isEmpty((String)this.param.getMultiLanLocale()) || this.ctx.getLocale().getDisplayName().equalsIgnoreCase(this.param.getMultiLanLocale())) {
                this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
            } else if ("all".equalsIgnoreCase(this.param.getMultiLanLocale())) {
                this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
                for (String locale : allLocales) {
                    selectColumnString.append(",").append("\n");
                    this.appendColumnStringForMultiLan(selectColumnString, isBigDataType, configInfo, MessageFormat.format("{0}_{1}", prop.getMappingField().getName(), locale), MessageFormat.format("{0}_{1}", alias, locale));
                }
            } else {
                this.appendColumnStringForMultiLan(selectColumnString, isBigDataType, configInfo, MessageFormat.format("{0}_{1}", prop.getMappingField().getName(), this.param.getMultiLanLocale()), alias);
            }
        } else {
            this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
        }
        return selectColumnString.toString();
    }

    protected final void appendColumnString(StringBuffer selectColumnString, boolean isBigDataType, StructureConfigInfo configInfo, String[] keys, String alias) throws EASBizException, BOSException {
        selectColumnString.append(" ");
        if (isBigDataType) {
            selectColumnString.append("convert(nvarchar(4000),");
        }
        selectColumnString.append(this.getColumnHisotryName(this.historyReplayColumn, this.getColumnName(configInfo, keys[1])));
        if (isBigDataType) {
            selectColumnString.append(")");
        }
        selectColumnString.append(" AS ").append(this.appendQuo(alias)).append(" ");
    }

    protected final void appendColumnStringForMultiLan(StringBuffer selectColumnString, boolean isBigDataType, StructureConfigInfo configInfo, String fieldName, String fieldAlias) throws EASBizException, BOSException {
        selectColumnString.append(" ");
        if (isBigDataType) {
            selectColumnString.append("convert(nvarchar(4000),");
        }
        StringBuffer columnString = new StringBuffer();
        columnString.append(this.getQuoTableAlias(configInfo)).append(".");
        columnString.append(fieldName);
        selectColumnString.append(this.getColumnHisotryName(this.historyReplayColumn, columnString.toString()));
        if (isBigDataType) {
            selectColumnString.append(")");
        }
        selectColumnString.append(" AS ").append(this.appendQuo(fieldAlias)).append(" ");
    }

    protected String generateOneColumn2(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        StringBuffer selectColumnString = new StringBuffer();
        String customStr = this.generateCustomColumnStr(column, alias);
        StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber(this.ctx, keys[0], scheme);
        if (configInfo == null) {
            if (customStr != null && !"".equals(customStr)) {
                alias = SqlGenerateUtils.getLabCostColumnAlias(this.ctx, column, alias);
                selectColumnString.append(" ").append(customStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else {
                alias = SqlGenerateUtils.getLabCostColumnAlias(this.ctx, column, alias);
                selectColumnString.append(" ").append(column).append(" AS ").append(this.appendQuo(alias)).append(" ");
            }
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("LONGNUMBER") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            this.appendQueAdminHis(selectColumnString, configInfo, "T", "FLongNumber", alias);
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("DISPLAYNAME") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), alias);
            } else {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
            }
        } else {
            String relaceStr = this.getColumnHisotryName(this.historyReplayColumn, this.getColumnName(configInfo, keys[1]));
            if (this.param.getColumns().get(column) != null && ((Map)this.param.getColumns().get(column)).get("columnsql") != null && !"".equals(((Map)this.param.getColumns().get(column)).get("columnsql")) && !"null".equals(((Map)this.param.getColumns().get(column)).get("columnsql"))) {
                String columnSql = (String)((Map)this.param.getColumns().get(column)).get("columnsql");
                selectColumnString.append(" ").append(columnSql.replace(column, relaceStr)).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else if (customStr != null && !"".equals(customStr)) {
                alias = SqlGenerateUtils.getLabCostColumnAlias(this.ctx, column, alias);
                selectColumnString.append(" ").append(customStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else {
                selectColumnString.append(" ").append(relaceStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            }
        }
        return selectColumnString.toString();
    }

    protected String generateCustomColumnStr(String column, String alias) throws EASBizException, BOSException {
        return null;
    }

    private boolean isBigDataType(StructureConfigInfo configInfo, String column) {
        EntityObjectInfo entityObjectInfo = this.getEntityObject(configInfo.getEntityName());
        String propertyName = "";
        propertyName = column.indexOf(".") > 0 ? column.split("\\.")[1] : column;
        PropertyInfo propertyInfo = entityObjectInfo.getPropertyByNameRuntime(propertyName);
        ColumnInfo ColumnInfo2 = propertyInfo.getMappingField();
        int sqlType = ColumnInfo2.getSQLType();
        return sqlType == SQLType.CLOB.getSQLType() || sqlType == SQLType.BLOB.getSQLType() || sqlType == SQLType.NCLOB.getSQLType();
    }

    @Override
    protected String assembleSQLWhere() throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        FilterInfo filterInfo = this.param.getFilterInfo();
        int filtersCount = filterInfo.getFilterItems().size();
        StringBuffer whereSql = new StringBuffer("");
        if (filtersCount > 0) {
            int i;
            String format = filterInfo.getMaskString();
            if (!StringUtils.isEmpty((String)format)) {
                format = "(" + format + ")";
                for (i = filtersCount - 1; i >= 0; --i) {
                    format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
                }
            }
            for (i = 0; i < filtersCount; ++i) {
                StringBuffer filter = new StringBuffer("");
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                Object value = filterItemInfo.getCompareValue();
                CompareType type = filterItemInfo.getCompareType();
                StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, filterItemInfo.getPropertyName(), this.param.getScheme());
                if (null == configInfo) {
                    logger.error((Object)("filterInfo:" + filterInfo));
                    logger.error((Object)("maskString:" + filterInfo.getMaskString()));
                    logger.error((Object)("index:" + i));
                    logger.error((Object)("filterItemInfo:" + filterItemInfo));
                    String clinetNumber = filterItemInfo.getPropertyName().split("\\.")[0];
                    logger.error((Object)("clientNumber:" + clinetNumber + ",Scheme:" + this.param.getScheme()));
                    throw new BaseConfigException(BaseConfigException.STRUCTURECONFIG_MISSING, new Object[]{this.param.getScheme(), clinetNumber});
                }
                PropertyInfo propInfo = this.getPropertyInfoFullPath(configInfo, filterItemInfo.getPropertyName());
                if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                    if (this.param.isHistoryMode() && "longNumber".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                        this.appendQueAdminHis(filter, configInfo, "T", "FLongNumber ", null);
                    } else if (this.param.isHistoryMode() && "displayName".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                        if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                            this.appendQueAdminHis(filter, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), null);
                        } else {
                            this.appendQueAdminHis(filter, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), null);
                        }
                    } else {
                        filter.append(this.getColumnName(this.historyReplayColumn, configInfo, filterItemInfo.getPropertyName()));
                    }
                }
                if (filterItemInfo.isCompareValueIsProperty()) {
                    filter.append(filterItemInfo.getCompareExpression());
                    String propertyValue = filterItemInfo.getCompareValue().toString();
                    StructureConfigInfo propertyConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, propertyValue, this.param.getScheme());
                    if (this.param.isHistoryMode() && "longNumber".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                        this.appendQueAdminHis(filter, configInfo, "T", "FLongNumber ", null);
                    } else if (this.param.isHistoryMode() && "displayName".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                        if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                            this.appendQueAdminHis(filter, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), null);
                        } else {
                            this.appendQueAdminHis(filter, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), null);
                        }
                    } else {
                        filter.append(this.getColumnName(this.historyReplayColumn, propertyConfigInfo, propertyValue));
                    }
                } else {
                    this.appendClouse(filter, value, type, filterItemInfo, propInfo);
                }
                if (StringUtils.isEmpty((String)format)) {
                    whereSql.append(filter);
                    if (i >= filtersCount - 1) continue;
                    whereSql.append(" AND ");
                    continue;
                }
                format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
            }
            if (format != null) {
                whereSql.append(format);
            }
        }
        String permissionFilter = this.generatePermissionRangeFilter();
        if (StringUtils.isEmpty((String)whereSql.toString())) {
            if (!StringUtils.isEmpty((String)permissionFilter)) {
                whereSql.append("\n").append(permissionFilter);
            }
        } else if (!StringUtils.isEmpty((String)permissionFilter)) {
            whereSql.append("\n").append(" AND ").append(permissionFilter);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("assembleSQLWhere cost:" + (end - begin)));
        }
        return whereSql.toString();
    }

    @Override
    protected String assembleSQLOrderby() throws EASBizException, BOSException {
        StringBuffer sorterSql = new StringBuffer("");
        String orderStr = this.param.getSortStr();
        if (StringUtils.isEmpty((String)orderStr)) {
            return sorterSql.toString();
        }
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode(" ORDER BY " + orderStr);
        }
        catch (ParserException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return this.getOrder(sorterItemCollection).toString();
    }

    private StringBuffer getOrder(SorterItemCollection sorterItemCollection) throws EASBizException, BOSException {
        int count = sorterItemCollection.size();
        StringBuffer sorterSql = new StringBuffer("");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                SorterItemInfo sorterItemInfo = sorterItemCollection.get(i);
                String fieldvalue = sorterItemInfo.getPropertyName();
                SortType type = sorterItemInfo.getSortType();
                StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, fieldvalue, this.param.getScheme());
                PropertyInfo propInfo = this.getPropertyInfoFullPath(configInfo, fieldvalue);
                if (sorterSql.length() > 0) {
                    sorterSql.append(",");
                }
                boolean isStringField = false;
                if (propInfo instanceof OwnPropertyInfo && DataType.STRING.equals((Object)((OwnPropertyInfo)propInfo).getDataType())) {
                    isStringField = true;
                }
                StringBuffer sHis = new StringBuffer();
                if (this.param.isHistoryMode() && "longNumber".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                    this.appendQueAdminHis(sHis, configInfo, "T", "FLongNumber ", null);
                } else if (this.param.isHistoryMode() && "displayName".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                    if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                        this.appendQueAdminHis(sHis, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), null);
                    } else {
                        this.appendQueAdminHis(sHis, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), null);
                    }
                } else {
                    sHis.append(this.getColumnName(this.historyReplayColumn, configInfo, fieldvalue));
                }
                if (isStringField && "SCHINESE_PINYIN".equals(this.param.getSorterMethod())) {
                    sorterSql.append("NLSSORT(").append(sHis.toString()).append(", 'NLS_SORT=SCHINESE_PINYIN_M')");
                } else {
                    sorterSql.append(sHis.toString());
                }
                sorterSql.append(" ").append(type.getAlias());
            }
        }
        return sorterSql;
    }

    @Override
    protected String assembleSQLGroupby() throws EASBizException, BOSException {
        StringBuffer groupSql = new StringBuffer("");
        for (Map.Entry<String, String> entry : this.param.getSelectMapping().entrySet()) {
            String[] keys = entry.getKey().split("\\.");
            StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByKey(this.ctx, entry.getKey().toString(), this.param.getScheme());
            if (groupSql.length() > 0) {
                groupSql.append(",");
            }
            this.appendGroupField(groupSql, keys, configInfo, entry);
        }
        return groupSql.toString();
    }

    @Override
    protected FilterInfo privateDataSourceCustomFilter(String scheme, Map configParam, String effdtStr, Date effdt) throws EASBizException, BOSException {
        return null;
    }

    protected FilterInfo getFlowInOutFilter(String startStr, String endStr) throws BOSException {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = startStr != null && !"".equals(startStr) ? DateTimeUtils.parseDate((String)startStr, (String)"yyyy-MM-dd") : DateTimeUtils.truncateDate((Date)new Date());
            endDate = endStr != null && !"".equals(endStr) ? DateTimeUtils.parseDate((String)endStr, (String)"yyyy-MM-dd") : DateTimeUtils.truncateDate((Date)new Date());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo effectFilter = new FilterInfo();
        effectFilter.getFilterItems().add(new FilterItemInfo("empflowinout.EFFDT", (Object)new Timestamp(startDate.getTime()), CompareType.GREATER_EQUALS));
        effectFilter.getFilterItems().add(new FilterItemInfo("empflowinout.EFFDT", (Object)new Timestamp(endDate.getTime()), CompareType.LESS_EQUALS));
        return effectFilter;
    }

    protected FilterInfo getEffdtFilter(Date effet) {
        if (effet == null) {
            effet = DateTimeUtils.truncateDate((Date)new Date());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        return filter;
    }

    @Override
    protected OwnPropertyInfo getCmpPropertyInfo(StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected OwnPropertyInfo getAtsPropertyInfo(StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected void pupolateCnSnOSFHandler(Map<String, Object> cnSn, Map<String, Integer> dataTypeValueMap, Map<String, String> labCostTypeNumberFieldMap) throws EASBizException, BOSException {
    }

    @Override
    protected boolean pupolateColumnAndDateTypesFhandler(int k, String key, String reallyColumn, PropertyInfo[] props, String[] columns, int[] datetypes, Map<String, String> labCostTypeNumberFieldMap) {
        if (StringUtils.isEmpty((String)reallyColumn)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected boolean pupolateColumnAndDateTypesFhandler0(int k, String key, String fieldStr, PropertyInfo[] props, String[] columns, int[] datetypes, Map<String, Integer> dataTypeValueMap, Map<String, String> originMap) {
        return Boolean.FALSE;
    }

    protected StringBuffer generateAdminHis(StructureConfigInfo configInfo, String adminAlias, String adminTAlias) {
        StringBuffer sql = new StringBuffer();
        if (this.param.getRealFilterDate() != null) {
            this.appendCommonJoinOnCondition(null, sql, adminAlias, "FhistoryRelateID", " = ", adminTAlias, "FAdminOrgID");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FEFFDT", " <= ", null, "{ts '" + DateTimeUtils.format((Date)this.param.getFilterDate()) + "'}");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FLEFFDT", " >= ", null, "{ts '" + DateTimeUtils.format((Date)this.param.getFilterDate()) + "'}");
        } else {
            this.appendCommonJoinOnCondition(null, sql, adminAlias, "FhistoryRelateID", " = ", adminTAlias, "FAdminOrgID");
            this.appendCommonJoinOnCondition(" AND ", sql, adminAlias, "FLEFFDT", " <= ", adminTAlias, "FLEFFDT");
            this.appendCommonJoinOnCondition(" AND ", sql, adminAlias, "FLEFFDT", " >= ", adminTAlias, "FEFFDT");
        }
        return sql;
    }

    protected void appendGroupField(StringBuffer sql, String[] keys, StructureConfigInfo configInfo, Map.Entry<String, String> entry) throws EASBizException, BOSException {
        sql.append(this.getColumnName(this.historyReplayColumn, configInfo, entry.getKey()));
    }

    protected String getAlias(String scheme, Map.Entry<String, String> entry) throws EASBizException, BOSException {
        return entry.getValue();
    }

    @Override
    protected String assembleOuterSQLSelect() throws EASBizException, BOSException {
        StringBuffer selectSql = new StringBuffer();
        String scheme = this.param.getScheme();
        Set<Map.Entry<String, String>> keys = this.param.getSelectMapping().entrySet();
        Iterator<Map.Entry<String, String>> it = keys.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String alias = this.getAlias(scheme, entry);
            if (isFirst) {
                if ("groupsum".equals(this.param.getGroupType()) && this.param.getColumns().get(entry.getKey()) != null && Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("issum"))).booleanValue()) {
                    this.appendFuntionQue(selectSql, " sum ", alias);
                    isFirst = false;
                    continue;
                }
                if ("groupavg".equals(this.param.getGroupType()) && this.param.getColumns().get(entry.getKey()) != null && Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isavg"))).booleanValue()) {
                    this.appendFuntionQue(selectSql, " avg ", alias);
                    isFirst = false;
                    continue;
                }
                if ("groupsum".equals(this.param.getGroupType()) || "groupavg".equals(this.param.getGroupType())) {
                    if (this.param.getColumns().get(entry.getKey()) == null || !Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isgroup"))).booleanValue()) continue;
                    selectSql.append(this.appendQuo(alias));
                    isFirst = false;
                    continue;
                }
                selectSql.append(this.appendQuo(alias));
                isFirst = false;
                continue;
            }
            if ("groupsum".equals(this.param.getGroupType()) && this.param.getColumns().get(entry.getKey()) != null && Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("issum"))).booleanValue()) {
                selectSql.append(",").append("\n");
                this.appendFuntionQue(selectSql, " sum ", alias);
                continue;
            }
            if ("groupavg".equals(this.param.getGroupType()) && this.param.getColumns().get(entry.getKey()) != null && Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isavg"))).booleanValue()) {
                selectSql.append(",").append("\n");
                this.appendFuntionQue(selectSql, " avg ", alias);
                continue;
            }
            if ("groupsum".equals(this.param.getGroupType()) || "groupavg".equals(this.param.getGroupType())) {
                if (this.param.getColumns().get(entry.getKey()) == null || !Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isgroup"))).booleanValue()) continue;
                selectSql.append(",").append("\n").append(this.appendQuo(alias));
                continue;
            }
            selectSql.append(",").append("\n").append(this.appendQuo(alias));
        }
        if ("groupcount".equals(this.param.getGroupType())) {
            this.appendCount(selectSql);
        }
        selectSql.append("\n");
        return selectSql.toString();
    }

    @Override
    protected String assembleOutSQLGroupby() throws EASBizException, BOSException {
        boolean isFirst = Boolean.TRUE;
        StringBuffer groupbySql = new StringBuffer();
        for (Map.Entry<String, String> entry : this.param.getSelectMapping().entrySet()) {
            String alias = this.getAlias(this.param.getScheme(), entry);
            if ("groupcount".equals(this.param.getGroupType())) {
                if (isFirst) {
                    this.appendAliasQue(groupbySql, alias);
                    isFirst = Boolean.FALSE;
                    continue;
                }
                groupbySql.append(",");
                this.appendAliasQue(groupbySql, alias);
                continue;
            }
            if ("groupsum".equals(this.param.getGroupType()) && this.param.getColumns().get(entry.getKey()) != null && Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isgroup"))).booleanValue()) {
                if (isFirst) {
                    this.appendAliasQue(groupbySql, alias);
                    isFirst = Boolean.FALSE;
                    continue;
                }
                groupbySql.append(",");
                this.appendAliasQue(groupbySql, alias);
                continue;
            }
            if (!"groupavg".equals(this.param.getGroupType()) || this.param.getColumns().get(entry.getKey()) == null || !Boolean.valueOf(String.valueOf(((Map)this.param.getColumns().get(entry.getKey())).get("isgroup"))).booleanValue()) continue;
            if (isFirst) {
                this.appendAliasQue(groupbySql, alias);
                isFirst = Boolean.FALSE;
                continue;
            }
            groupbySql.append(",");
            this.appendAliasQue(groupbySql, alias);
        }
        return groupbySql.toString();
    }

    @Override
    public void getQueryFieldInfoList(Context ctx, Map param, List<QueryFieldInfo> entityList) throws EASBizException, BOSException {
    }

    @Override
    public boolean setQueryFieldInfoEnumSource(QueryFieldInfo queryFieldInfo, QueryConfigInfo entityInfo, QueryConfigFieldInfo fieldInfo) {
        String enumSource = fieldInfo.getFactField().getEnumSource();
        queryFieldInfo.setEnumSource(enumSource);
        return Boolean.FALSE;
    }
}

