/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.app;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.certificationservice.CertificationException;
import com.kingdee.shr.certificationservice.CertificationTempletFactory;
import com.kingdee.shr.certificationservice.CertificationTempletInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeInfo;
import com.kingdee.shr.certificationservice.IHRCertificationBill;
import com.kingdee.shr.certificationservice.app.AbstractECertificationOptFacadeControllerBean;
import com.kingdee.shr.certificationservice.app.CertificateStatusEnum;
import com.kingdee.shr.certificationservice.util.CertificationConstants;
import com.kingdee.shr.certificationservice.util.CertificationUtil;
import com.kingdee.shr.certificationservice.util.SSCCertificationUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.util.Base64Utils;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.HttpMethodUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.CloudServiceException;
import com.kingdee.shr.shareservice.util.KDContractConfigUtil;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECertificationOptFacadeControllerBean
extends AbstractECertificationOptFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ECertificationOptFacadeControllerBean.class);

    @Override
    protected void _createECertification(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._createECertification(ctx, billId, true);
    }

    private void afterCreateECertification(Context ctx, IHRCertificationBill certificationBill, HRCertificationBillInfo info, Map<String, Object> param) throws EASBizException, BOSException {
        info.setIsIssue(true);
        info.setIsSign(true);
        info.setSignNO((String)param.get("realCertificationNO"));
        SelectorItemCollection newSelector = new SelectorItemCollection();
        newSelector.add(new SelectorItemInfo("isIssue"));
        newSelector.add(new SelectorItemInfo("isSign"));
        newSelector.add(new SelectorItemInfo("signNO"));
        if (((Boolean)param.get("isChangeBillstate")).booleanValue()) {
            info.setCertificationStatus(CertificateStatusEnum.Certificated);
            newSelector.add(new SelectorItemInfo("certificationStatus"));
            Object APPLY_SUC = null;
            HRCertificationBillTypeInfo certificationBillTypeInfo = HRCertificationBillTypeFactory.getLocalInstance(ctx).getHRCertificationBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getCertificationBillType().getId()));
            try {
                CertificationUtil.sendCertBillCloudHubMessage(ctx, certificationBillTypeInfo, info);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        HRCertificationBillFactory.getLocalInstance(ctx).updatePartial(info, newSelector);
        this.updateSSCRule(ctx, info);
    }

    private void updateSSCRule(Context ctx, HRCertificationBillInfo info) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("isIssue", (Object)(info.isIsIssue() ? 1 : 0));
        paramJson.put("isSign", (Object)(info.isIsSign() ? 1 : 0));
        paramJson.put("signNO", (Object)info.getSignNO());
        paramJson.put("certificationStatus", (Object)info.getCertificationStatus().getValue());
        JSONObject dyValues = new JSONObject();
        dyValues.put(info.getId().toString(), (Object)paramJson);
        HashMap<String, Object> taskParam = new HashMap<String, Object>();
        taskParam.put("mapValue", dyValues);
        taskParam.put("isUpdateHis", true);
        try {
            SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"UPDATEDYNAMICVALUE", taskParam);
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.certificationservice.app.ECertificationOptFacadeControllerBean.updateSSCRule" + e.getMessage(), (Throwable)e);
        }
    }

    private List<Map<String, String>> assembleInfoMap(Context ctx, String billId, String certificationTempletInfoId) throws EASBizException, BOSException, UuidException {
        ArrayList<Map<String, String>> osfContractDataList = new ArrayList<Map<String, String>>();
        Map<Object, Object> osfParamsData = new HashMap();
        CertificationTempletInfo certificationTempletInfo = CertificationTempletFactory.getLocalInstance(ctx).getCertificationTempletInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)certificationTempletInfoId)));
        osfParamsData = SSCCertificationUtil.assembleInfoMap(ctx, billId, certificationTempletInfo);
        osfContractDataList.add(osfParamsData);
        return osfContractDataList;
    }

    private void beforeAssembleInfo(Context ctx, IHRCertificationBill iHRCertificationBill, HRCertificationBillInfo info) throws EASBizException, BOSException {
        info.setPrintDate(new Date());
        SelectorItemCollection newSelector = new SelectorItemCollection();
        newSelector.add(new SelectorItemInfo("printDate"));
        iHRCertificationBill.updatePartial(info, newSelector);
    }

    private String getRealCertificaitonNO(HRCertificationBillInfo info, KDContractConfigInfo kdContractConfigInfo) {
        if (info == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)info.getSignNO())) {
            return info.getSignNO();
        }
        if (kdContractConfigInfo == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-hhmmss");
        GregorianCalendar c = new GregorianCalendar();
        return info.getNumber() + "-" + kdContractConfigInfo.getClientKDAppId() + "-" + sdf.format(c.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getCertTempletInfoMap(Context ctx, HRCertificationBillInfo hrCertificationBillInfo) throws BOSException, EASBizException {
        String cloudTemplateId = null;
        if (hrCertificationBillInfo.getCertificationBillType() == null || hrCertificationBillInfo.getCertificationBillType().getId() == null) {
            throw new CertificationException(CertificationException.BILL_NOT_BILLTYPE);
        }
        Map<String, Object> result = null;
        if (hrCertificationBillInfo.getCertificationTemplet() != null) {
            CertificationTempletInfo certificationTempletInfo = CertificationTempletFactory.getLocalInstance(ctx).getCertificationTempletInfo((IObjectPK)new ObjectUuidPK(hrCertificationBillInfo.getCertificationTemplet().getId()));
            result = new HashMap<String, Boolean>();
            result.put("isRegister", certificationTempletInfo.isIsRegister());
            result.put("templateId", certificationTempletInfo.getCloudTemplateId());
            result.put("csTemplateId", certificationTempletInfo.getCsTemplateId());
            result.put("keys", certificationTempletInfo.getKeys());
            result.put("config", certificationTempletInfo.getConfig());
            result.put("isESignature", certificationTempletInfo.isIsESignature());
            result.put("certificationTempletInfoId", certificationTempletInfo.getId().toString());
            result.put("name", certificationTempletInfo.getName());
            result.put("eContractSealType", certificationTempletInfo.getEContractSealType().getId().toString());
            return result;
        } else {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("certificationBillTypeId", hrCertificationBillInfo.getCertificationBillType().getId().toString());
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            result = (Map)osfServiceFacade.processService("getCertTempletInfoByBillTypeService", dataMap);
            if (result.get("isSuccess") == null || !Boolean.valueOf(result.get("isSuccess").toString()).booleanValue()) throw new BOSException(result.get("msg").toString());
            if (result.get("isRegister") == null || !Boolean.valueOf(result.get("isRegister").toString()).booleanValue()) throw new CertificationException(CertificationException.TEMPLATE_NOT_REGISTER);
            cloudTemplateId = result.get("templateId") == null ? null : result.get("templateId").toString();
        }
        return result;
    }

    @Override
    protected void _createECertification(Context ctx, BOSUuid billId, boolean isChangeBillstate) throws BOSException, EASBizException {
        boolean isHandle;
        String bussJobHandleUserId;
        Map dataMap;
        List<Map<String, String>> osfContractDataList;
        String realCertificationNO;
        HashMap<String, Object> paramsMap;
        KDContractConfigInfo kdContractConfigInfo;
        Map<String, Object> certTempletInfoMap;
        HRCertificationBillInfo info;
        String csTemplateId;
        IHRCertificationBill iHRCertificationBill;
        block22: {
            logger.error("com.kingdee.shr.certificationservice.app.ECertificationOptFacadeControllerBean._createECertification billId:" + billId + "; isChangeBillstate:" + isChangeBillstate);
            iHRCertificationBill = HRCertificationBillFactory.getLocalInstance(ctx);
            if (billId == null || !iHRCertificationBill.exists((IObjectPK)new ObjectUuidPK(billId))) {
                throw new CertificationException(CertificationException.BILL_NOT_EXIST);
            }
            csTemplateId = "";
            Object certificationTempletInfo = null;
            info = iHRCertificationBill.getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (info.isIsSign() && !StringUtils.isEmpty((String)info.getSignNO())) {
                logger.info("certification bill " + billId.toString() + " electronic certification generate :  " + info.getSignNO());
                return;
            }
            certTempletInfoMap = this.getCertTempletInfoMap(ctx, info);
            LabContractFirstPartyInfo labContractFirstPartyInfo = null;
            if (info.getLabContractFirstParty() == null) {
                PersonInfo person = info.getPerson();
                labContractFirstPartyInfo = CertificationUtil.getLabContractFirstPartyInfo(ctx, person);
            } else {
                labContractFirstPartyInfo = info.getLabContractFirstParty();
            }
            if (labContractFirstPartyInfo == null) {
                throw new CertificationException(CertificationException.PERSON_NO_FIRSTPARTY);
            }
            kdContractConfigInfo = KDContractConfigUtil.getKDContractConfigInfo((Context)ctx, (LabContractFirstPartyInfo)labContractFirstPartyInfo);
            if (null == kdContractConfigInfo) {
                throw new CertificationException(CertificationException.SIGNATURE_AUTHENTICATION_UNFINISHED);
            }
            ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (KDContractConfigInfo)kdContractConfigInfo);
            paramsMap = new HashMap<String, Object>();
            realCertificationNO = this.getRealCertificaitonNO(info, kdContractConfigInfo);
            CloudServiceConfigCollection cloudServiceConfigColl = CloudServiceConfigFactory.getLocalInstance((Context)ctx).getCloudServiceConfigCollection();
            if (cloudServiceConfigColl.size() == 0) {
                throw new CloudServiceException(CloudServiceException.PLEASE_CONFIG_TSP_SERVER_INFO);
            }
            String serviceId = cloudServiceConfigColl.get(0).getServiceID();
            CheckHRCloudLicenseUtils.checkLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)realCertificationNO);
            ArrayList<String> templateIds = new ArrayList<String>();
            templateIds.add(certTempletInfoMap.get("templateId").toString());
            this.beforeAssembleInfo(ctx, iHRCertificationBill, info);
            osfContractDataList = this.assembleInfoMap(ctx, billId.toString(), certTempletInfoMap.get("certificationTempletInfoId").toString());
            dataMap = null;
            paramsMap.put("contractNo", realCertificationNO);
            paramsMap.put("templates", templateIds);
            paramsMap.put("templateData", osfContractDataList);
            paramsMap.put("labContractFirstPartyInfoId", labContractFirstPartyInfo.getId().toString());
            paramsMap.put("billId", billId.toString());
            String logPrefix = "create electronic certification,";
            csTemplateId = certTempletInfoMap.get("csTemplateId") == null ? "" : certTempletInfoMap.get("csTemplateId").toString();
            HashMap<String, Object> serviceParam = new HashMap<String, Object>();
            serviceParam.put("billId", billId);
            serviceParam.put("type", "3");
            serviceParam.put("selector", "bussAttrID,personnelID.easUserId");
            JsonObject jobInfoJS = SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"GETJOBINFOBYBILLID", serviceParam);
            if (jobInfoJS != null) {
                logger.error(logPrefix + " jobInfoJS: " + jobInfoJS.toString());
            }
            bussJobHandleUserId = "";
            isHandle = false;
            try {
                JsonArray asJsonArray;
                if (jobInfoJS == null || jobInfoJS.get("success") == null || !jobInfoJS.get("success").getAsBoolean() || (asJsonArray = jobInfoJS.get("data").getAsJsonArray()) == null || asJsonArray.size() <= 0) break block22;
                for (int dex = 0; dex < asJsonArray.size(); ++dex) {
                    JsonObject bussAttrIDObj;
                    String bussId;
                    JsonObject asJsonObject = asJsonArray.get(dex).getAsJsonObject();
                    if (asJsonObject.get("bussAttrID") == null || !CertificationConstants.HANDLE_TASK_BUSSATTRID_MAP.containsKey(bussId = (bussAttrIDObj = asJsonObject.get("bussAttrID").getAsJsonObject()).get("id").getAsString())) continue;
                    JsonObject personnelIDObj = asJsonObject.get("personnelID").getAsJsonObject();
                    bussJobHandleUserId = personnelIDObj.get("easUserId").getAsString();
                    isHandle = true;
                    break;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((String)csTemplateId)) {
            if (!StringUtils.isEmpty((String)bussJobHandleUserId) && isHandle) {
                HashMap<String, String> js = new HashMap<String, String>();
                js.put("handlerId", bussJobHandleUserId);
                paramsMap.put("otherParam", Base64Utils.encode((String)JSONUtils.convertObjectToJson((Context)ctx, js)));
            }
            String certificationSealType = (String)certTempletInfoMap.get("eContractSealType");
            String signatureId = com.kingdee.eas.hr.contract.util.ElectronicContractUtils.getSignatureId((Context)ctx, (String)certificationSealType, (KDContractConfigInfo)kdContractConfigInfo);
            paramsMap.put("signatureId", signatureId);
            dataMap = SSCCertificationUtil.packageOsfParamsSign(paramsMap);
            Object result = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("electronicLaborQuickCreateService", dataMap);
            HashMap resultMap = null;
            resultMap = JSONUtils.convertJsonToObject((Context)ctx, (String)result.toString());
            int returnCode = ((Double)resultMap.get("code")).intValue();
            if (returnCode != 0) {
                String label5 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label5", (Context)ctx);
                String message = MessageFormat.format(label5, returnCode, resultMap.get("msg").toString(), new Gson().toJson((Object)resultMap), new Gson().toJson((Object)dataMap));
                throw new BOSException(message);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("realCertificationNO", realCertificationNO);
            param.put("isChangeBillstate", isChangeBillstate);
            this.afterCreateECertification(ctx, iHRCertificationBill, info, param);
        } else {
            info.setSignNO(realCertificationNO);
            SelectorItemCollection newSelector = new SelectorItemCollection();
            newSelector.add(new SelectorItemInfo("signNO"));
            iHRCertificationBill.updatePartial(info, newSelector);
            String serverURL = CloudServiceUtil.getServiceUrl((Context)ctx, (String)"BASE") + "/kdcontract/contract/fillTemplate";
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(serverURL);
            httpPost = (HttpPost)HttpMethodUtils.addHeader((Context)ctx, (AbstractHttpMessage)httpPost);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("templateId", csTemplateId);
            ArrayList<String> fileIdList = new ArrayList<String>();
            fileIdList.add(realCertificationNO);
            params.put("fileId", fileIdList);
            params.put("fileName", realCertificationNO);
            if (!StringUtils.isEmpty((String)bussJobHandleUserId) && isHandle) {
                HashMap<String, String> otherParam = new HashMap<String, String>();
                otherParam.put("handlerId", bussJobHandleUserId);
                params.put("message", Base64Utils.encode((String)JSONUtils.convertObjectToJson((Context)ctx, otherParam)));
            }
            if (isChangeBillstate) {
                params.put("callbackOSF", "certificationSignCallbackService");
            } else {
                params.put("callbackOSF", "cerSignCallbackWithoutChangStateService");
            }
            ArrayList<String> dataList = new ArrayList<String>();
            String signJsonStr = JSONUtils.convertObjectToJson((Context)ctx, osfContractDataList.get(0));
            signJsonStr = signJsonStr.replace("\\\"", "\"").replace("\"[", "[").replace("]\"", "]").replace("\\\\", "\\");
            dataList.add(signJsonStr);
            params.put("data", dataList);
            String content = JSONUtils.convertObjectToJson((Context)ctx, params);
            content = content.replace("\\\"", "\"").replace("\"[", "[").replace("]\"", "]").replace("\\\\", "\\").replace("\"{", "{").replace("}\"", "}");
            logger.error("=========== request to: " + serverURL + ", content: " + Base64Utils.encode((String)content));
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
                HttpEntity httpEntity = httpResponse.getEntity();
                String response = EntityUtils.toString((HttpEntity)httpEntity);
                String encodeStr = Base64Utils.encode((String)response);
                if (200 != httpResponse.getStatusLine().getStatusCode()) {
                    logger.error("=========== response from: " + serverURL + ", response: " + encodeStr);
                    throw new BOSException("request fail and the statuscode = " + httpResponse.getStatusLine().getStatusCode());
                }
                logger.error("=========== response from: " + serverURL + ", response: " + encodeStr);
                JSONObject result = JSONObject.parseObject((String)response);
                if (result.get((Object)"code") != null && "1".equals(result.getString("code"))) {
                    throw new BOSException(result.getString("msg"));
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

