/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.cmpdesign.app.v2.base.AbstractAdjustSalaryItemControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryTypeInfo;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.app.integrate.CalSchemeItemForF7Info;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjustSalaryItemControllerBean
extends AbstractAdjustSalaryItemControllerBean {
    private static final long serialVersionUID = 6585020706860028321L;
    private static final Logger logger = LoggerFactory.getLogger(AdjustSalaryItemControllerBean.class);

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCalItem(ctx, pk);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void checkIsRefferenced(String billId, Context ctx) throws HRCommonException {
        StringBuffer checkSqlBuf = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        checkSqlBuf.append(" SELECT ss.Fname_" + language + " as SBNAME ");
        checkSqlBuf.append(" FROM T_HR_SBatchAdjustRuleItem css  ");
        checkSqlBuf.append(" left join T_HR_ScalsubmitScheme ss on ss.Fid=css.FCalSubmitSchemeID  ");
        checkSqlBuf.append(" where css.FAdjustSalaryItemID= '" + billId + "'");
        StringBuffer submitSchemeBuff = new StringBuffer();
        try {
            IRowSet iRowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)checkSqlBuf.toString());
            String sbname = null;
            for (int limit = 1; iRowSet.next() && limit != 10; ++limit) {
                sbname = iRowSet.getString("SBNAME");
                if (sbname == null || sbname.trim().length() <= 0) continue;
                submitSchemeBuff.append(",");
                submitSchemeBuff.append(sbname);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String names = submitSchemeBuff.toString();
        if (names != null && names.trim().length() > 0) {
            names = names.substring(1);
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label121", (Locale)ctx.getLocale()), names);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    private void deleteCalItem(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String column = "";
        boolean count = false;
        AdjustSalaryItemInfo cmpInfo = AdjustSalaryItemFactory.getLocalInstance(ctx).getAdjustSalaryItemInfo(pk);
        if (cmpInfo == null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label85", (Locale)ctx.getLocale())});
        }
        SHRBasicItemInfo shrBasicItem = cmpInfo.getShrBasicItem();
        boolean isPreset = shrBasicItem.isIsPreset();
        BasicItemStateEnum state = shrBasicItem.getState();
        int value = state.getValue();
        if (isPreset) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label24", (Locale)ctx.getLocale())});
        }
        if (value != 0) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label86", (Locale)ctx.getLocale())});
        }
        this.checkIsRefferenced(pk.toString(), ctx);
    }

    protected IObjectPK[] _beforeDeleteOperation(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo model = (SHRBaseItemInfo)shrBaseItem;
        if (null == model) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label87", (Locale)ctx.getLocale())});
        }
        IObjectPK[] baseInfoOrgRefPK = null;
        if (BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label88", (Locale)ctx.getLocale()), model.getNumber());
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            // empty if block
        }
        return baseInfoOrgRefPK;
    }

    private IObjectPK addNewItemAndColumns(Context ctx, AdjustSalaryItemInfo item, int fieldSn) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String name = item.getName();
        String number = item.getNumber();
        int dataLength = item.getDataLength();
        SHRBasicItemInfo shrBasicItemInfo = null;
        shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select * where number='" + number + "'";
        boolean exists = AdjustSalaryItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label90", (Locale)ctx.getLocale()), number);
            throw new EASBizException(new NumericExceptionSubItem("022", msg));
        }
        item.setFieldSn(fieldSn + 1);
        item.setIsSysPreset(false);
        item.setShrBasicItem(shrBasicItemInfo);
        if (item.getCU() == null) {
            item.setCU(this.getCU(ctx, (ObjectBaseInfo)item));
        }
        if (item.getCreator() == null) {
            item.setCreator(userInfo);
        }
        Timestamp createtime = this.getTime();
        if (item.getCreateTime() == null) {
            item.setCreateTime(createtime);
        }
        item.setLastUpdateUser(userInfo);
        item.setLastUpdateTime(createtime);
        item.setState(BaseItemStateEnum.NEW);
        IObjectPK baseInfoChangePK = null;
        IObjectPK idPk = null;
        if (!BaseItemStateEnum.NEW.equals((Object)item.getState())) {
            baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            } else {
                baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
                if (null != baseInfoChangePK) {
                    this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        } else {
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
        }
        if (item.getDataType() == CalSubmitItemDataType.String && dataLength > 1000) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label91", (Locale)ctx.getLocale()));
        }
        item.setId(BOSUuid.read((String)idPk.toString()));
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, idPk));
        return idPk;
    }

    private IObjectPK updateItem(Context ctx, AdjustSalaryItemInfo item) throws BOSException, EASBizException {
        String name = item.getName();
        String number = item.getNumber();
        String itemid = item.getId().toString();
        String description = item.getDescription();
        CmpItemDataDot dataDot = item.getDataDot();
        int dataLength = item.getDataLength();
        DateTypeEnum dateType = item.getDateType();
        CalSchemeItemForF7Info filterField = item.getFilterField();
        int index = item.getIndex();
        BaseItemStateEnum state = item.getState();
        AdjustSalaryTypeInfo salaryType = item.getSalaryType();
        UsePolicy usePolicy = item.getUsePolicy();
        HROrgUnitInfo hrOrgUnit = item.getHrOrgUnit();
        boolean isSysPreset = item.isIsSysPreset();
        CalSubmitItemDataType dataType = item.getDataType();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        this.beforeUpdate(ctx, item);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select * where  number = '" + number + "' and id <> '" + itemid + "'";
        boolean exists = AdjustSalaryItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label90", (Locale)ctx.getLocale()), number);
            throw new EASBizException(new NumericExceptionSubItem("022", msg));
        }
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        AdjustSalaryItemInfo cmpItemInfo = new AdjustSalaryItemInfo();
        cmpItemInfo.setId(item.getId());
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        cmpItemInfo.setNumber(number);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        cmpItemInfo.setDataDot(dataDot);
        cmpItemInfo.setDataLength(dataLength);
        cmpItemInfo.setDateType(dateType);
        cmpItemInfo.setFilterField(filterField);
        cmpItemInfo.setSalaryType(salaryType);
        cmpItemInfo.setHrOrgUnit(hrOrgUnit);
        cmpItemInfo.setUsePolicy(usePolicy);
        cmpItemInfo.setState(state);
        cmpItemInfo.setIndex(index);
        cmpItemInfo.setIsSysPreset(isSysPreset);
        cmpItemInfo.setLastUpdateUser(userInfo);
        cmpItemInfo.setLastUpdateTime(this.getTime());
        cmpItemInfo.setShrBasicItem(shrBasicItemInfo);
        cmpItemInfo.setDataType(dataType);
        cmpItemInfo.setCmpItem(item.getCmpItem());
        if (item.getFieldSn() <= 0) {
            String sql = "select FieldSn from T_HR_AdjustSalaryItem where fid='" + item.getId().toString() + "'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowset.next()) {
                    int fieldSn = rowset.getInt(1);
                    cmpItemInfo.setFieldSn(fieldSn);
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            cmpItemInfo.setFieldSn(item.getFieldSn());
        }
        ObjectUuidPK idPk = new ObjectUuidPK(itemid);
        IObjectPK baseInfoChangePK = null;
        baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
        super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)cmpItemInfo);
        if (null != baseInfoChangePK) {
            this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
        } else {
            baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            }
        }
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, (IObjectPK)idPk));
        return idPk;
    }

    private void syncCalFOrmula(Context ctx, AdjustSalaryItemInfo item) throws BOSException {
    }

    private void beforeUpdate(Context ctx, AdjustSalaryItemInfo item) throws BOSException {
    }

    private IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            FunUtils.clearSessionMap();
            AdjustSalaryItemInfo item = (AdjustSalaryItemInfo)model;
            String name = item.getName();
            String name_l1 = item.getName(LocaleUtils.locale_L1);
            String name_l2 = item.getName(LocaleUtils.locale_L2);
            String name_l3 = item.getName(LocaleUtils.locale_L3);
            if (!StringUtils.isEmpty((String)name) && (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3))) {
                name_l1 = StringUtils.isEmpty((String)name_l1) ? name : name_l1;
                name_l2 = StringUtils.isEmpty((String)name_l2) ? name : name_l2;
                String string = name_l3 = StringUtils.isEmpty((String)name_l3) ? name : name_l3;
            }
            if (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3) || StringUtils.isEmpty((String)item.getNumber())) {
                throw new EASBizException(new NumericExceptionSubItem("021", EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label92", (Locale)ctx.getLocale())));
            }
            String reg = "^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9\uff08\uff09]*$";
            if (!(name_l1.matches(reg) && name_l2.matches(reg) && name_l3.matches(reg))) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label93", (Locale)ctx.getLocale())));
            }
            if (!item.getNumber().matches(reg)) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label94", (Locale)ctx.getLocale())));
            }
            String[] arr = new String[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label66", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label67", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label68", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label69", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label70", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label71", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label72", (Locale)ctx.getLocale())};
            for (int i = 0; i < arr.length; ++i) {
                if (name_l1.indexOf(arr[i]) != -1 || name_l2.indexOf(arr[i]) != -1 || name_l3.indexOf(arr[i]) != -1) {
                    throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label93", (Locale)ctx.getLocale())));
                }
                if (item.getNumber().indexOf(arr[i]) == -1) continue;
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label94", (Locale)ctx.getLocale())));
            }
            int fieldSn = 60;
            String sql = "select max(FieldSn) from T_HR_AdjustSalaryItem";
            IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (list.next()) {
                if (list.getInt(1) <= fieldSn) continue;
                fieldSn = list.getInt(1);
            }
            boolean isNewOp = false;
            int orgFieldSn = item.getFieldSn();
            if (orgFieldSn == -1 || orgFieldSn == 0) {
                isNewOp = true;
            }
            if (item.getId() != null && !StringUtils.isEmpty((String)item.getId().toString())) {
                isNewOp = false;
            }
            if (isNewOp) {
                return this.addNewItemAndColumns(ctx, item, fieldSn);
            }
            return this.updateItem(ctx, item);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private SHRBasicItemInfo getShrBasicItemInfo(Context ctx) throws BOSException, EASBizException {
        String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType()).getFullName();
        ISHRBasicItem shrBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        String oql = "where entityName='" + entityName + "'";
        SHRBasicItemInfo basicItemInfo = shrBasicItem.getSHRBasicItemInfo(oql);
        return basicItemInfo;
    }
}

