/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.mapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AbstractEmpAdjustItemMappingTableControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjBusinessTypeRecordCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjBusinessTypeRecordInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjustItemMappingSchemeCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjustItemMappingSchemeInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableFactory;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.SubmitItemMappingSchemeCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.SubmitItemMappingSchemeInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.MappingTableUtils;
import com.kingdee.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpAdjustItemMappingTableControllerBean
extends AbstractEmpAdjustItemMappingTableControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableControllerBean");
    private static Map<String, EmpAdjustItemMappingTableInfo> hrOrg2MappingTable = new HashMap<String, EmpAdjustItemMappingTableInfo>();
    private static Map<String, HROrgUnitInfo> hrOrgMap = new HashMap<String, HROrgUnitInfo>();

    @Override
    protected String _createHrMappingTable(Context ctx, Map params) throws BOSException, EASBizException {
        EmpAdjustItemMappingTableInfo mappingTable = (EmpAdjustItemMappingTableInfo)params.get("mappingTable");
        try {
            String hrOrgId = mappingTable.getHrOrgUnit().getId().toString();
            String mappingTableId = mappingTable.getId().toString();
            String longNumber = mappingTable.getHrOrgUnit().getLongNumber();
            String type = params.get("type").toString();
            String sql = null;
            String parentHrOrgId = null;
            String parentMappingTableId = null;
            String businessType = MappingTableUtils.getBusinessType((Context)ctx, (EmpAdjustItemMappingTableInfo)mappingTable);
            String parentLongNumber = MappingTableUtils.getMaxParentNumber((Context)ctx, (String)"T_HR_SEmpAdjItemMappingTable", (String)hrOrgId, (String)businessType);
            if (CmpStrUtil.isNotEmpty((String)parentLongNumber)) {
                sql = "select FHrOrgID, FMappingTableID from T_HR_SOrgMappingTable where FLongNumber = '" + parentLongNumber + "' and FBusinessType = '" + businessType + "'";
                IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    parentHrOrgId = rs.getString("FHrOrgID");
                    parentMappingTableId = rs.getString("FMappingTableID");
                }
            }
            if ("enable".equals(type)) {
                sql = MappingTableUtils.getInsertSql((String)mappingTableId, (String)hrOrgId, (String)longNumber, (String)businessType);
                CmpSQLUtil.execute((Context)ctx, (String)sql);
                if (!CmpStrUtil.isEmpty((String)parentLongNumber)) {
                    sql = MappingTableUtils.getUpdateSql((String)mappingTableId, (String)hrOrgId, parentHrOrgId, (String)longNumber, (String)businessType);
                    CmpSQLUtil.execute((Context)ctx, (String)sql);
                }
            } else if (CmpStrUtil.isEmpty((String)parentLongNumber)) {
                sql = "delete from T_HR_SOrgMappingTable where FUseHr = '" + hrOrgId + "' and FBusinessType = '" + businessType + "'";
                CmpSQLUtil.execute((Context)ctx, (String)sql);
            } else {
                sql = MappingTableUtils.getUpdateSql(parentMappingTableId, parentHrOrgId, (String)hrOrgId, (String)longNumber, (String)businessType);
                CmpSQLUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected void _initMappingTable(Context ctx) throws BOSException, EASBizException {
        this.initHrOrgUnit(ctx);
        hrOrg2MappingTable.clear();
        String deleteSql = "delete from T_HR_SOrgMappingTable";
        CmpSQLUtil.execute((Context)ctx, (String)deleteSql);
        this.getMappingTable(ctx);
        this.buildhrOrg2MappingTable(ctx);
        ArrayList<Object[]> bankParams = new ArrayList<Object[]>();
        String insertSql = "insert into T_HR_SOrgMappingTable (FHrOrgID, FMappingTableID, FUseHr, FLongNumber) values (?,?,?,?)";
        Iterator<String> it = hrOrg2MappingTable.keySet().iterator();
        while (it.hasNext()) {
            Object[] batchParam = new Object[5];
            String orgId = it.next();
            String mappingTableId = hrOrg2MappingTable.get(orgId).getId().toString();
            String parentOrg = hrOrg2MappingTable.get(orgId).getHrOrgUnit().getId().toString();
            String longNumber = hrOrgMap.get(orgId).getLongNumber();
            batchParam[0] = orgId;
            batchParam[1] = mappingTableId;
            batchParam[2] = parentOrg;
            batchParam[3] = longNumber;
            bankParams.add(batchParam);
        }
        CmpSQLUtil.executeBatch((Context)ctx, (String)insertSql, bankParams);
    }

    private void initHrOrgUnit(Context ctx) throws BOSException {
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id, number, longNumber, name, parent.*");
        for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
            HROrgUnitInfo hrOrg = hrOrgUnitCollection.get(i);
            hrOrgMap.put(hrOrg.getId().toString(), hrOrg);
        }
    }

    private void getMappingTable(Context ctx) throws BOSException {
        EmpAdjustItemMappingTableCollection EmpAdjustItemMappingTableCollection2 = EmpAdjustItemMappingTableFactory.getLocalInstance(ctx).getEmpAdjustItemMappingTableCollection();
        for (int i = 0; i < EmpAdjustItemMappingTableCollection2.size(); ++i) {
            EmpAdjustItemMappingTableInfo mappingTable = EmpAdjustItemMappingTableCollection2.get(i);
            if (mappingTable.getHrOrgUnit() == null) continue;
            hrOrg2MappingTable.put(mappingTable.getHrOrgUnit().getId().toString(), mappingTable);
        }
    }

    private void buildhrOrg2MappingTable(Context ctx) {
        Iterator<String> iterator = hrOrgMap.keySet().iterator();
        while (iterator.hasNext()) {
            HROrgUnitInfo hrOrg = hrOrgMap.get(iterator.next());
            EmpAdjustItemMappingTableInfo mappingTable = hrOrg2MappingTable.get(hrOrg.getId().toString());
            if (mappingTable != null || (mappingTable = this.getmappingTableByParent(hrOrg)) == null) continue;
            hrOrg2MappingTable.put(hrOrg.getId().toString(), mappingTable);
        }
    }

    private EmpAdjustItemMappingTableInfo getmappingTableByParent(HROrgUnitInfo currentHrOrg) {
        EmpAdjustItemMappingTableInfo mappingTable = hrOrg2MappingTable.get(currentHrOrg.getId().toString());
        if (mappingTable != null) {
            return mappingTable;
        }
        if (currentHrOrg.getParent() == null) {
            return null;
        }
        return this.getmappingTableByParent(hrOrgMap.get(currentHrOrg.getParent().getId().toString()));
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        EmpAdjustItemMappingTableInfo info = (EmpAdjustItemMappingTableInfo)model;
        this.beforeSave(ctx, info);
        return super.save(ctx, model);
    }

    protected void beforeSave(Context ctx, EmpAdjustItemMappingTableInfo info) throws EASBizException, BOSException {
        this._checkNumberDup(ctx, info);
        this._checkNameDup(ctx, info);
    }

    protected void _checkNumberDup(Context ctx, EmpAdjustItemMappingTableInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)info, "number") + " : " + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, EmpAdjustItemMappingTableInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getString("name"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, (DataBaseInfo)info, "name") + " : " + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected String _copy(Context ctx, String billId) throws BOSException, EASBizException {
        String oql = "select *, adjustItemMapping.*, submitItemMapping.*, adjBusinessTypeRecord.* where id = '" + billId + "'";
        EmpAdjustItemMappingTableInfo oldMappingTable = EmpAdjustItemMappingTableFactory.getLocalInstance(ctx).getEmpAdjustItemMappingTableInfo(oql);
        if (oldMappingTable == null) {
            return null;
        }
        EmpAdjustItemMappingTableInfo newMappingTable = (EmpAdjustItemMappingTableInfo)oldMappingTable.clone();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mappingTable", newMappingTable);
        return this.copyProperties(ctx, map);
    }

    protected String copyProperties(Context ctx, Map<String, Object> map) throws BOSException, EASBizException {
        EmpAdjustItemMappingTableInfo newMappingTable = (EmpAdjustItemMappingTableInfo)map.get("mappingTable");
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmmss");
        String random = sdf.format(new Date());
        newMappingTable.setId(null);
        String name = newMappingTable.getName() + "_" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpPermDynResource", (String)"label17", (Locale)ctx.getLocale()) + random;
        newMappingTable.setName(name, LocaleUtils.locale_l1);
        newMappingTable.setName(name, LocaleUtils.locale_l2);
        newMappingTable.setName(name, LocaleUtils.locale_l3);
        newMappingTable.setNumber(newMappingTable.getNumber() + "_copy" + random);
        newMappingTable.setState(StateEnum.DISABLE);
        AdjustItemMappingSchemeCollection newAimsColls = newMappingTable.getAdjustItemMapping();
        for (int i = 0; newAimsColls != null && i < newAimsColls.size(); ++i) {
            AdjustItemMappingSchemeInfo newAims = newAimsColls.get(i);
            newAims.setId(null);
            newAims.setBill(newMappingTable);
        }
        SubmitItemMappingSchemeCollection newSimsColls = newMappingTable.getSubmitItemMapping();
        for (int i = 0; newSimsColls != null && i < newSimsColls.size(); ++i) {
            SubmitItemMappingSchemeInfo newSims = newSimsColls.get(i);
            newSims.setId(null);
            newSims.setBill(newMappingTable);
        }
        AdjBusinessTypeRecordCollection newAbtrColls = newMappingTable.getAdjBusinessTypeRecord();
        for (int i = 0; newAbtrColls != null && i < newAbtrColls.size(); ++i) {
            AdjBusinessTypeRecordInfo newAbtr = newAbtrColls.get(i);
            newAbtr.setId(null);
            newAbtr.setEmpAdjItemMapping(newMappingTable);
        }
        IObjectPK idPK = EmpAdjustItemMappingTableFactory.getLocalInstance(ctx).save((CoreBaseInfo)newMappingTable);
        return idPK.toString();
    }
}

