/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.cmpdesign.BatchAdjustBillEntryCollection;
import com.kingdee.shr.cmpdesign.BatchAdjustBillEntryFactory;
import com.kingdee.shr.cmpdesign.BatchAdjustBillEntryInfo;
import com.kingdee.shr.cmpdesign.BatchAdjustBillFactory;
import com.kingdee.shr.cmpdesign.BatchAdjustBillInfo;
import com.kingdee.shr.cmpdesign.IBatchAdjustBill;
import com.kingdee.shr.cmpdesign.app.AbstractBatchAdjustBillControllerBean;
import com.kingdee.shr.cmpdesign.fix.FixAdjustSalaryExecuteCommon;
import com.kingdee.shr.compensation.AdjustEmpORelationCollection;
import com.kingdee.shr.compensation.AdjustEmpORelationFactory;
import com.kingdee.shr.compensation.AdjustPersonRecordCollection;
import com.kingdee.shr.compensation.AdjustPersonRecordFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.LeffectSourceEnum;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BatchAdjustBillControllerBean
extends AbstractBatchAdjustBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.BatchAdjustBillControllerBean");

    private void submitToFixAdjustSalary(Context ctx, BatchAdjustBillInfo bill) throws BOSException, EASBizException {
        int i;
        FixAdjustSalaryExecuteCommon execute = new FixAdjustSalaryExecuteCommon();
        FixAdjustSalaryInfo fixInfo = null;
        BatchAdjustBillEntryCollection coll = BatchAdjustBillEntryFactory.getLocalInstance(ctx).getBatchAdjustBillEntryCollection(" where bill.id = '" + bill.getId().toString() + "'");
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        StringBuilder str = new StringBuilder();
        int size = coll.size();
        for (int i2 = 0; i2 < size; ++i2) {
            str.append("'").append(coll.get(i2).getPerson().getId().toString()).append("',");
        }
        String personIds = str.substring(0, str.lastIndexOf(","));
        String oql = "where person.id in (" + personIds + ") and hrOrgUnit = '" + bill.getHrOrgUnit().getId().toString() + "' ";
        AdjustPersonRecordCollection recColl = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(oql);
        HashMap<String, Date> map = new HashMap<String, Date>();
        for (int i3 = 0; i3 < recColl.size(); ++i3) {
            map.put(recColl.get(i3).getPerson().getId().toString(), recColl.get(i3).getLeffectDate());
        }
        oql = "select useDefault, id where person.id in (" + personIds + ")";
        AdjustEmpORelationCollection adjColl = AdjustEmpORelationFactory.getLocalInstance((Context)ctx).getAdjustEmpORelationCollection(oql);
        HashMap<String, Boolean> aeoMap = new HashMap<String, Boolean>();
        for (i = 0; i < adjColl.size(); ++i) {
            aeoMap.put(adjColl.get(i).getId().toString(), adjColl.get(i).isUseDefault());
        }
        int size2 = coll.size();
        for (i = 0; i < size2; ++i) {
            fixInfo = new FixAdjustSalaryInfo();
            BatchAdjustBillEntryInfo info = coll.get(i);
            fixInfo.setAdjEmpORelation(info.getAdjEmpORelation());
            if (info.getAdjEmpORelation() != null && aeoMap.get(info.getAdjEmpORelation().getId().toString()) != null) {
                fixInfo.setUseDefault(((Boolean)aeoMap.get(info.getAdjEmpORelation().getId().toString())).booleanValue());
            } else {
                fixInfo.setUseDefault(Boolean.TRUE.booleanValue());
            }
            fixInfo.setAdminOrgUnit(info.getAdminOrgUnit());
            fixInfo.setPosition(info.getPosition());
            fixInfo.setAdjHrOrgUnit(bill.getHrOrgUnit());
            fixInfo.setAdjustSalaryCause(info.getAdjustCause());
            fixInfo.setCmpItem(info.getCmpItem());
            fixInfo.setEffectDay(info.getEffectDate());
            fixInfo.setLeffectDay((Date)map.get(info.getPerson().getId().toString()));
            fixInfo.setStandard(info.getCmpStandard());
            fixInfo.setStdLevel(info.getCmpLevel());
            fixInfo.setStdPoint(info.getStdPoint());
            fixInfo.setStdScope(info.getStdScope());
            fixInfo.setFloatRate(info.getFloatRate());
            fixInfo.setMoney(info.getMoney());
            fixInfo.setPerson(info.getPerson());
            fixInfo.setRemark(info.getRemark());
            fixInfo.setBillId(info.getBill().getId().toString());
            fixInfo.setOldFixAdjustSalary(info.getLastInfo());
            fixInfo.setPayHrOrgUnit(info.getPayHrOrgUnit());
            fixInfo.setCurrency(info.getCurrency());
            if (null != info.getLeffectDate() && info.getLeffectDate().compareTo((Date)map.get(info.getPerson().getId().toString())) < 0) {
                fixInfo.setLeffectSource(LeffectSourceEnum.MANUAL);
                fixInfo.setLeffectDay(info.getLeffectDate());
            } else if (null == info.getLeffectDate()) {
                fixInfo.setLeffectDay((Date)map.get(info.getPerson().getId().toString()));
                fixInfo.setLeffectSource(LeffectSourceEnum.AUTO);
            }
            execute.save(ctx, fixInfo);
        }
    }

    public IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BatchAdjustBillInfo bill = (BatchAdjustBillInfo)model;
        bill.setApproveType(ApproveTypeEnum.DIRECT);
        bill.setBillState(HRBillStateEnum.SAVED);
        IObjectPK objectPK = super.save(ctx, model);
        bill.setId(BOSUuid.read((String)objectPK.toString()));
        this.submitToFixAdjustSalary(ctx, bill);
        bill.setBillState(HRBillStateEnum.AUDITED);
        super.save(ctx, model);
        return objectPK;
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITED);
        BatchAdjustBillInfo bill = BatchAdjustBillFactory.getLocalInstance(ctx).getBatchAdjustBillInfo("where id = '" + billId.toString() + "'");
        this.submitToFixAdjustSalary(ctx, bill);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITEND);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.SUBMITED);
    }

    private void setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        String sql = "update T_HR_SBatchAdjustBill set FBillState = ? where fid = ? ";
        Object[] param = new Object[]{state.getValue(), billId.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IBatchAdjustBill iBatchAdjustBill = BatchAdjustBillFactory.getLocalInstance(ctx);
            BatchAdjustBillInfo billInfo = iBatchAdjustBill.getBatchAdjustBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == billInfo) {
                logger.error((Object)MessageFormat.format(" when BatchAdjustBillControllerBean._abortBizBill invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                billInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                iBatchAdjustBill.updatePartial(billInfo, selector);
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
            }
        } else {
            logger.error((Object)" when CmpWorkFlowMainBillControllerBean._abortBizBill invocked, param billId is empty! please check param ");
        }
    }
}

