/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.cmpdesign.CmpStandardInfo;
import com.kingdee.shr.cmpdesign.CmpStdLevelInfo;
import com.kingdee.shr.cmpdesign.CmpStdPointInfo;
import com.kingdee.shr.cmpdesign.CmpStdScopeInfo;
import com.kingdee.shr.cmpdesign.app.AbstractBatchAdjustFacadeControllerBean;
import com.kingdee.shr.cmpdesign.sql.BatchAdjustSql;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchAdjustFacadeControllerBean
extends AbstractBatchAdjustFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.BatchAdjustFacadeControllerBean");

    @Override
    protected Map _getLastAdjustSalary(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, FixAdjustSalaryInfo> itemMap = new HashMap<String, FixAdjustSalaryInfo>();
        StringBuffer perSb = new StringBuffer();
        StringBuffer itemSb = new StringBuffer();
        Map m = map;
        for (Map.Entry entry : m.entrySet()) {
            perSb.append("'").append((String)entry.getKey()).append("',");
            itemSb.append("'").append((String)entry.getValue()).append("',");
        }
        String personIds = perSb.substring(0, perSb.length() - 1);
        String itemIds = itemSb.substring(0, itemSb.length() - 1);
        String sql = BatchAdjustSql.getLastAdjustInfoForSimple(personIds, itemIds, ctx);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String personId = rowSet.getString("PERSONID");
                String itemId = rowSet.getString("ITEMID");
                FixAdjustSalaryInfo info = new FixAdjustSalaryInfo();
                info.setMoney(rowSet.getBigDecimal("MONEY"));
                info.setEffectDay((java.util.Date)rowSet.getDate("EFFECTDAY"));
                info.setId(BOSUuid.read((String)rowSet.getString("id")));
                CmpStandardInfo stdInfo = new CmpStandardInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("stdId"))) {
                    stdInfo.setId(BOSUuid.read((String)rowSet.getString("stdId")));
                    stdInfo.setName(rowSet.getString("stdName"));
                }
                info.setStandard(stdInfo);
                CmpStdLevelInfo levelInfo = new CmpStdLevelInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("levelId"))) {
                    levelInfo.setId(BOSUuid.read((String)rowSet.getString("levelId")));
                    levelInfo.setName(rowSet.getString("levelName"));
                    levelInfo.setFloatRate(rowSet.getString("FloatRate"));
                }
                info.setStdLevel(levelInfo);
                CmpStdPointInfo pointInfo = new CmpStdPointInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("pointId"))) {
                    pointInfo.setId(BOSUuid.read((String)rowSet.getString("pointId")));
                    pointInfo.setName(rowSet.getString("pointName"));
                }
                info.setStdPoint(pointInfo);
                CmpStdScopeInfo scopeInfo = new CmpStdScopeInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("scopeId"))) {
                    scopeInfo.setId(BOSUuid.read((String)rowSet.getString("scopeId")));
                    scopeInfo.setName(rowSet.getString("scopeName"));
                }
                info.setStdScope(scopeInfo);
                itemMap.put(personId + "_" + itemId, info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return itemMap;
    }

    @Override
    protected IObjectValue _verifyAdjustSalaryInfo(Context ctx, String personId, String itemId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _batchVerifyAdjustSalary(Context ctx, Map map) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastAdjustSalary(Context ctx, String personIds, String itemIds, String payHrOrgIds) throws BOSException, EASBizException {
        HashMap<String, FixAdjustSalaryInfo> itemMap = new HashMap<String, FixAdjustSalaryInfo>();
        String personSql = "'" + personIds.replace(",", "','") + "'";
        String itemSql = "'" + itemIds.replace(",", "','") + "'";
        String payHrOrgSql = "'" + payHrOrgIds.replace(",", "','") + "'";
        String sql = BatchAdjustSql.getLastAdjustInfoForSimple(personSql, itemSql, payHrOrgSql, ctx);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String personId = rowSet.getString("PERSONID");
                String itemId = rowSet.getString("ITEMID");
                String payHrOrgId = rowSet.getString("FPayHrOrgUnitID");
                FixAdjustSalaryInfo info = new FixAdjustSalaryInfo();
                info.setMoney(rowSet.getBigDecimal("MONEY"));
                info.setEffectDay((java.util.Date)rowSet.getDate("EFFECTDAY"));
                info.setId(BOSUuid.read((String)rowSet.getString("id")));
                CmpStandardInfo stdInfo = new CmpStandardInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("stdId"))) {
                    stdInfo.setId(BOSUuid.read((String)rowSet.getString("stdId")));
                    stdInfo.setName(rowSet.getString("stdName"));
                }
                info.setStandard(stdInfo);
                CmpStdLevelInfo levelInfo = new CmpStdLevelInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("levelId"))) {
                    levelInfo.setId(BOSUuid.read((String)rowSet.getString("levelId")));
                    levelInfo.setName(rowSet.getString("levelName"));
                    levelInfo.setFloatRate(rowSet.getString("FloatRate"));
                }
                info.setStdLevel(levelInfo);
                CmpStdPointInfo pointInfo = new CmpStdPointInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("pointId"))) {
                    pointInfo.setId(BOSUuid.read((String)rowSet.getString("pointId")));
                    pointInfo.setName(rowSet.getString("pointName"));
                }
                info.setStdPoint(pointInfo);
                CmpStdScopeInfo scopeInfo = new CmpStdScopeInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("scopeId"))) {
                    scopeInfo.setId(BOSUuid.read((String)rowSet.getString("scopeId")));
                    scopeInfo.setName(rowSet.getString("scopeName"));
                }
                info.setStdScope(scopeInfo);
                CurrencyInfo currencyInfo = new CurrencyInfo();
                if (!StringUtils.isEmpty((String)rowSet.getString("currencyId"))) {
                    currencyInfo.setId(BOSUuid.read((String)rowSet.getString("currencyId")));
                    currencyInfo.setName(rowSet.getString("currencyName"));
                }
                info.setCurrency(currencyInfo);
                itemMap.put(personId + "_" + itemId + "_" + payHrOrgId, info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return itemMap;
    }

    @Override
    protected Object _reverseAudit(Context ctx, String billId) throws BOSException, EASBizException {
        Date effdt;
        String lang = ctx.getLocale().getLanguage();
        int successCount = 0;
        int errorCount = 0;
        HashMap<String, Date> map = new HashMap<String, Date>();
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT MAX(TT.FEFFECTDAY) EFFDT, FPERSONID, FCMPITEMID, FPayHrOrgUnitID ");
        str.append(" FROM T_HR_SFIXADJUSTSALARY TT ");
        str.append(" WHERE EXISTS ( SELECT 1 FROM T_HR_SBATCHADJUSTBILLENTRY ENTRY WHERE TT.FPERSONID = ENTRY.FPERSONID  ");
        str.append(" AND (ENTRY.FPayHrOrgUnitID = TT.FPayHrOrgUnitID or (ENTRY.FPayHrOrgUnitID is null or ENTRY.FPayHrOrgUnitID in ('')) )");
        str.append(" AND ENTRY.FCMPITEMID = TT.FCMPITEMID AND ENTRY.FBILLID = '" + billId + "')");
        str.append(" GROUP BY  FPERSONID, FCMPITEMID, FPayHrOrgUnitID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString(2) + "_" + rowSet.getString(3) + "_" + rowSet.getString(4), rowSet.getDate(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" SELECT distinct A01.FBILLID, A01.FEFFECTDAY, A01.FPERSONID, A01.FCMPITEMID, A01.FPayHrOrgUnitID, A04.FNAME_" + lang + " payHrName, A02.FNAME_" + lang + " PERNAME, A03.FNAME_" + lang + " ITEMNAME, A01.FID ");
        str.append(" FROM T_HR_SBATCHADJUSTBILLENTRY AA");
        str.append(" LEFT JOIN T_HR_SFIXADJUSTSALARY A01 ON AA.FPERSONID = A01.FPERSONID AND AA.FCMPITEMID = A01.FCMPITEMID AND AA.FBILLID = A01.FBILLID ");
        str.append(" AND (AA.FPayHrOrgUnitID = A01.FPayHrOrgUnitID or (AA.FPayHrOrgUnitID is null or AA.FPayHrOrgUnitID in (''))) ");
        str.append(" INNER JOIN T_BD_PERSON A02 ON AA.FPERSONID = A02.FID ");
        str.append(" INNER JOIN T_HR_SCMPITEM A03 ON AA.FCMPITEMID = A03.FID ");
        str.append(" LEFT JOIN T_ORG_HRO A04 ON AA.FPayHrOrgUnitID = A04.FID ");
        str.append(" WHERE AA.FBILLID  = '" + billId + "'");
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        str = new StringBuilder();
        try {
            while (rowSet1.next()) {
                String msg;
                String payHrName;
                str.append(rowSet1.getString("FID")).append(",");
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(rowSet1.getString("FID"));
                String key = rowSet1.getString("FPERSONID") + "_" + rowSet1.getString("FCMPITEMID") + "_" + rowSet1.getString("FPayHrOrgUnitID");
                effdt = rowSet1.getDate("FEFFECTDAY");
                String perName = rowSet1.getString("PERNAME");
                String itemName = rowSet1.getString("ITEMNAME");
                String string = payHrName = rowSet1.getString("payHrName") != null ? rowSet1.getString("payHrName") : EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label123", (Locale)ctx.getLocale());
                if (StringUtils.isEmpty((String)rowSet1.getString("FID"))) {
                    ++successCount;
                    body.setMuitTipsState(true);
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label104", (Locale)ctx.getLocale()), perName, itemName, payHrName);
                    body.setMuitTipsMessage(msg);
                } else if (map.containsKey(key) && ((java.util.Date)map.get(key)).after(effdt)) {
                    ++errorCount;
                    body.setMuitTipsState(false);
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label105", (Locale)ctx.getLocale()), perName, itemName, payHrName);
                    body.setMuitTipsMessage(msg);
                } else {
                    ++successCount;
                    body.setMuitTipsState(true);
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.CmpdesignMultiLanResource", (String)"label106", (Locale)ctx.getLocale()), perName, itemName, payHrName);
                    body.setMuitTipsMessage(msg);
                }
                header.addResult(body);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        String headIds = null;
        if (str.length() > 0) {
            headIds = str.substring(0, str.length() - 1);
        }
        header.setBillId(headIds);
        header.setFailureCount(errorCount);
        header.setSuccessCount(successCount);
        if (errorCount > 0) {
            return header;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        Date maxDate = new Date(calendar.getTime().getTime());
        String deleteSql = "DELETE FROM T_HR_SFIXADJUSTSALARY WHERE FID = ?";
        String updateSql = "UPDATE T_HR_SFIXADJUSTSALARY SET FLEFFECTDAY = ? WHERE FID = ? ";
        String delRecSql = "DELETE FROM T_HR_SFIXADJUSTPAYHRRECORD WHERE FSOURCEID = ? ";
        String updateRecSql = "UPDATE T_HR_SFIXADJUSTPAYHRRECORD SET FLEFFDT = ? WHERE FSOURCEID = ?";
        ArrayList<Object[]> delList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        str = new StringBuilder();
        str.append(" SELECT A01.FID NEWFID, A01.FEFFECTDAY NEWEFFDT, A02.FID OLDID, A02.FLEFFECTDAY OLDLEFFDT,A02.FLEFFECTSOURCE OLDLEFFECTSOURCE ");
        str.append(" ,A02.FSysLFDBak SYSLFDBAK,adjRecord.FLeffectDate RECORDLFD ");
        str.append(" FROM T_HR_SFIXADJUSTSALARY A01 ");
        str.append(" LEFT JOIN T_HR_SFIXADJUSTSALARY A02 ON A01.FOLDFIXADJUSTSALARYID = A02.FID ");
        str.append(" left join T_HR_SAdjustPersonRecord adjRecord on A01.FPERSONID = adjRecord.FPersonId and A01.FAdjHrOrgUnitID = adjRecord.FHrOrgUnitID ");
        str.append(" WHERE A01.FBILLID = '" + billId + "'");
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (r.next()) {
                Date syslfdbak;
                String OLDLEFFECTSOURCE;
                int days;
                Object[] param = new Object[]{r.getString("NEWFID")};
                delList.add(param);
                effdt = r.getDate("NEWEFFDT");
                Date oldEffdt = r.getDate("OLDLEFFDT");
                if (null == r.getString("OLDID") || (days = (int)((effdt.getTime() - oldEffdt.getTime()) / 86400000L)) > 1 || StringUtils.isEmpty((String)(OLDLEFFECTSOURCE = r.getString("OLDLEFFECTSOURCE")))) continue;
                param = new Object[2];
                param[0] = maxDate;
                Date recordlfd = r.getDate("RECORDLFD");
                if (recordlfd.before(maxDate)) {
                    param[0] = recordlfd;
                }
                if ("20".equals(OLDLEFFECTSOURCE) && (syslfdbak = r.getDate("SYSLFDBAK")) != null) {
                    param[0] = syslfdbak;
                }
                param[1] = r.getString("OLDID");
                updateList.add(param);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection("where billId = '" + billId + "'");
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(list, "abort");
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, delList);
        DbUtil.executeBatch((Context)ctx, (String)delRecSql, delList);
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateList);
            DbUtil.executeBatch((Context)ctx, (String)updateRecSql, updateList);
        }
        DbUtil.execute((Context)ctx, (String)("update T_HR_SBatchAdjustBill set FBillState = 0 where fid = '" + billId + "'"));
        return header;
    }
}

