/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.AbstractBatchAdjustRuleItemControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchAdjustRuleItemControllerBean
extends AbstractBatchAdjustRuleItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    private IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            BatchAdjustRuleItemInfo adjustRuleItemInfo = (BatchAdjustRuleItemInfo)model;
            String calSubmitSchemeId = adjustRuleItemInfo.getCalSubmitScheme().getId().toString();
            AdjustSalaryItemInfo salaryItemInfo = adjustRuleItemInfo.getAdjustSalaryItem();
            Map<String, String> alterTableNameMap = this.getAlterTableName(ctx, calSubmitSchemeId);
            String billEntryTableName = alterTableNameMap.get("billEntryTableName");
            String adjustBaseTableName = alterTableNameMap.get("adjustBaseTableName");
            DbUtil.execute((Context)ctx, (String)this.getALterTableAddColumnSql(ctx, salaryItemInfo, billEntryTableName));
            DbUtil.execute((Context)ctx, (String)this.getALterTableAddColumnSql(ctx, salaryItemInfo, adjustBaseTableName));
            super.innerAddnew(ctx, (IObjectValue)adjustRuleItemInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label27", (Locale)ctx.getLocale()), (Throwable)e);
        }
        return null;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AdjustSalaryItemInfo adjustSalaryItem;
        String oql = "select *, adjustSalaryItem.* where id = '" + pk.toString() + "'";
        BatchAdjustRuleItemInfo adjustRuleItemInfo = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemInfo(oql);
        if (adjustRuleItemInfo != null && (adjustSalaryItem = adjustRuleItemInfo.getAdjustSalaryItem()) != null) {
            Map<String, String> alterTableNameMap = this.getAlterTableName(ctx, adjustRuleItemInfo.getCalSubmitScheme().getId().toString());
            this.alterTableDropColumn(ctx, adjustSalaryItem, alterTableNameMap);
            super._delete(ctx, pk);
        }
    }

    private Map<String, String> getAlterTableName(Context ctx, String calSubmitSchemeId) throws BOSException {
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        String sql = "select FBillEntryTableName, FAdjustBaseTableName from T_HR_SAdjSalaryTableRelation where FAdjustSalaryRule = '" + calSubmitSchemeId + "'";
        String billEntryTableName = "";
        String adjustBaseTableName = "";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (list.next()) {
                billEntryTableName = list.getString("FBillEntryTableName");
                adjustBaseTableName = list.getString("FAdjustBaseTableName");
            }
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label27", (Locale)ctx.getLocale()), (Throwable)e);
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label27", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (CmpStrUtil.isEmpty((String)billEntryTableName)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label28", (Locale)ctx.getLocale()));
        }
        if (CmpStrUtil.isEmpty((String)adjustBaseTableName)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label29", (Locale)ctx.getLocale()));
        }
        tableNameMap.put("billEntryTableName", billEntryTableName);
        tableNameMap.put("adjustBaseTableName", adjustBaseTableName);
        return tableNameMap;
    }

    private String getALterTableAddColumnSql(Context ctx, AdjustSalaryItemInfo salaryItemInfo, String tableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String columnName = "S" + salaryItemInfo.getFieldSn();
        sb.append("if not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + columnName + "'  and KSQL_COL_TABNAME='" + tableName + "')");
        sb.append(" alter table  " + tableName);
        sb.append(" add S" + salaryItemInfo.getFieldSn());
        int dataLength = salaryItemInfo.getDataLength();
        CalSubmitItemDataType calSubmitItemDataType = salaryItemInfo.getDataType();
        if (calSubmitItemDataType == CalSubmitItemDataType.number) {
            sb.append(" numeric(20,10)");
        } else if (calSubmitItemDataType == CalSubmitItemDataType.String) {
            if (dataLength > 1000) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label30", (Locale)ctx.getLocale()));
            }
            sb.append(" nvarchar(" + dataLength + ")");
        } else if (calSubmitItemDataType == CalSubmitItemDataType.Date) {
            sb.append(" DateTime");
        } else if (calSubmitItemDataType == CalSubmitItemDataType.F7) {
            sb.append(" VARCHAR(44)");
        }
        return sb.toString();
    }

    private boolean alterTableDropColumn(Context ctx, AdjustSalaryItemInfo salaryItemInfo, Map<String, String> alterTableNameMap) throws BOSException {
        String billEntryTableName = alterTableNameMap.get("billEntryTableName");
        String adjustBaseTableName = alterTableNameMap.get("adjustBaseTableName");
        String columnName = "S" + salaryItemInfo.getFieldSn();
        StringBuilder calShemeTable = new StringBuilder("If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + columnName + "'  and KSQL_COL_TABNAME='" + billEntryTableName + "')");
        calShemeTable.append(" ALTER TABLE " + billEntryTableName + " drop column " + columnName + " ");
        StringBuilder billEntryTable = new StringBuilder("If  exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + columnName + "'  and KSQL_COL_TABNAME='" + adjustBaseTableName + "')");
        billEntryTable.append(" ALTER TABLE " + adjustBaseTableName + " drop column " + columnName + " ");
        DbUtil.execute((Context)ctx, (String)calShemeTable.toString());
        DbUtil.execute((Context)ctx, (String)billEntryTable.toString());
        return true;
    }
}

